/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentValues;
import android.database.Cursor;
import com.android.internal.util.HexDump;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.Date;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class InboundSmsTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private byte[] mPdu;
    private long mTimestamp;
    private int mDestPort;
    private boolean mIs3gpp2;
    private boolean mIs3gpp2WapPdu;
    private String mAddress;
    private int mReferenceNumber;
    private int mSequenceNumber;
    private int mMessageCount;
    private String mDeleteWhere;
    private String[] mDeleteWhereArgs;
    private static int DEST_PORT_FLAG_NO_PORT = 65536;
    private static int DEST_PORT_FLAG_3GPP = 131072;
    private static int DEST_PORT_FLAG_3GPP2 = 262144;
    private static int DEST_PORT_FLAG_3GPP2_WAP_PDU = 524288;
    private static int DEST_PORT_MASK = 65535;

    private void $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byte[] pdu, long timestamp, int destPort, boolean is3gpp2, boolean is3gpp2WapPdu) {
        this.mPdu = pdu;
        this.mTimestamp = timestamp;
        this.mDestPort = destPort;
        this.mIs3gpp2 = is3gpp2;
        this.mIs3gpp2WapPdu = is3gpp2WapPdu;
        this.mAddress = null;
        this.mReferenceNumber = -1;
        this.mSequenceNumber = this.getIndexOffset();
        this.mMessageCount = 1;
    }

    private void $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byte[] pdu, long timestamp, int destPort, boolean is3gpp2, String address, int referenceNumber, int sequenceNumber, int messageCount, boolean is3gpp2WapPdu) {
        this.mPdu = pdu;
        this.mTimestamp = timestamp;
        this.mDestPort = destPort;
        this.mIs3gpp2 = is3gpp2;
        this.mIs3gpp2WapPdu = is3gpp2WapPdu;
        this.mAddress = address;
        this.mReferenceNumber = referenceNumber;
        this.mSequenceNumber = sequenceNumber;
        this.mMessageCount = messageCount;
    }

    private void $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(Cursor cursor, boolean isCurrentFormat3gpp2) {
        this.mPdu = HexDump.hexStringToByteArray(cursor.getString(0));
        if (cursor.isNull(2)) {
            this.mDestPort = -1;
            this.mIs3gpp2 = isCurrentFormat3gpp2;
            this.mIs3gpp2WapPdu = false;
        } else {
            int destPort = cursor.getInt(2);
            this.mIs3gpp2 = (destPort & 0x20000) != 0 ? false : ((destPort & 0x40000) != 0 ? true : isCurrentFormat3gpp2);
            this.mIs3gpp2WapPdu = (destPort & 0x80000) != 0;
            this.mDestPort = InboundSmsTracker.getRealDestPort(destPort);
        }
        this.mTimestamp = cursor.getLong(3);
        if (cursor.isNull(5)) {
            long rowId = cursor.getLong(7);
            this.mAddress = null;
            this.mReferenceNumber = -1;
            this.mSequenceNumber = this.getIndexOffset();
            this.mMessageCount = 1;
            this.mDeleteWhere = "_id=?";
            this.mDeleteWhereArgs = new String[]{Long.toString(rowId)};
        } else {
            this.mAddress = cursor.getString(6);
            this.mReferenceNumber = cursor.getInt(4);
            this.mMessageCount = cursor.getInt(5);
            this.mSequenceNumber = cursor.getInt(1);
            int index = this.mSequenceNumber - this.getIndexOffset();
            if (index < 0 || index >= this.mMessageCount) {
                throw new IllegalArgumentException("invalid PDU sequence " + this.mSequenceNumber + " of " + this.mMessageCount);
            }
            this.mDeleteWhere = "address=? AND reference_number=? AND count=?";
            this.mDeleteWhereArgs = new String[]{this.mAddress, Integer.toString(this.mReferenceNumber), Integer.toString(this.mMessageCount)};
        }
    }

    private final ContentValues $$robo$$com_android_internal_telephony_InboundSmsTracker$getContentValues() {
        ContentValues values = new ContentValues();
        values.put("pdu", HexDump.toHexString(this.mPdu));
        values.put("date", this.mTimestamp);
        int destPort = this.mDestPort == -1 ? 65536 : this.mDestPort & 0xFFFF;
        destPort = this.mIs3gpp2 ? (destPort |= 0x40000) : (destPort |= 0x20000);
        if (this.mIs3gpp2WapPdu) {
            destPort |= 0x80000;
        }
        values.put("destination_port", destPort);
        if (this.mAddress != null) {
            values.put("address", this.mAddress);
            values.put("reference_number", this.mReferenceNumber);
            values.put("sequence", this.mSequenceNumber);
            values.put("count", this.mMessageCount);
        }
        return values;
    }

    private static final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getRealDestPort(int destPort) {
        if ((destPort & 0x10000) != 0) {
            return -1;
        }
        return destPort & 0xFFFF;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsTracker$setDeleteWhere(String deleteWhere, String[] deleteWhereArgs) {
        this.mDeleteWhere = deleteWhere;
        this.mDeleteWhereArgs = deleteWhereArgs;
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$toString() {
        StringBuilder builder = new StringBuilder("SmsTracker{timestamp=");
        builder.append(new Date(this.mTimestamp));
        builder.append(" destPort=").append(this.mDestPort);
        builder.append(" is3gpp2=").append(this.mIs3gpp2);
        if (this.mAddress != null) {
            builder.append(" address=").append(this.mAddress);
            builder.append(" refNumber=").append(this.mReferenceNumber);
            builder.append(" seqNumber=").append(this.mSequenceNumber);
            builder.append(" msgCount=").append(this.mMessageCount);
        }
        if (this.mDeleteWhere != null) {
            builder.append(" deleteWhere(").append(this.mDeleteWhere);
            builder.append(") deleteArgs=(").append(Arrays.toString(this.mDeleteWhereArgs));
            builder.append(')');
        }
        builder.append('}');
        return builder.toString();
    }

    private final byte[] $$robo$$com_android_internal_telephony_InboundSmsTracker$getPdu() {
        return this.mPdu;
    }

    private final long $$robo$$com_android_internal_telephony_InboundSmsTracker$getTimestamp() {
        return this.mTimestamp;
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getDestPort() {
        return this.mDestPort;
    }

    private final boolean $$robo$$com_android_internal_telephony_InboundSmsTracker$is3gpp2() {
        return this.mIs3gpp2;
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$getFormat() {
        return this.mIs3gpp2 ? "3gpp2" : "3gpp";
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getIndexOffset() {
        return this.mIs3gpp2 && this.mIs3gpp2WapPdu ? 0 : 1;
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$getAddress() {
        return this.mAddress;
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getReferenceNumber() {
        return this.mReferenceNumber;
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getSequenceNumber() {
        return this.mSequenceNumber;
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsTracker$getMessageCount() {
        return this.mMessageCount;
    }

    private final String $$robo$$com_android_internal_telephony_InboundSmsTracker$getDeleteWhere() {
        return this.mDeleteWhere;
    }

    private final String[] $$robo$$com_android_internal_telephony_InboundSmsTracker$getDeleteWhereArgs() {
        return this.mDeleteWhereArgs;
    }

    private void __constructor__(byte[] byArray, long l, int n, boolean bl, boolean bl2) {
        this.$$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byArray, l, n, bl, bl2);
    }

    InboundSmsTracker(byte[] byArray, long l, int n, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byte[] long int boolean boolean ), 0, this, byArray, l, n, bl, bl2);
    }

    private void __constructor__(byte[] byArray, long l, int n, boolean bl, String string2, int n2, int n3, int n4, boolean bl2) {
        this.$$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byArray, l, n, bl, string2, n2, n3, n4, bl2);
    }

    public InboundSmsTracker(byte[] byArray, long l, int n, boolean bl, String string2, int n2, int n3, int n4, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(byte[] long int boolean java.lang.String int int int boolean ), 0, this, byArray, l, n, bl, string2, n2, n3, n4, bl2);
    }

    private void __constructor__(Cursor cursor, boolean bl) {
        this.$$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(cursor, bl);
    }

    InboundSmsTracker(Cursor cursor, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsTracker$__constructor__(android.database.Cursor boolean ), 0, this, cursor, bl);
    }

    ContentValues getContentValues() {
        return InvokeDynamicSupport.bootstrap("getContentValues", $$robo$$com_android_internal_telephony_InboundSmsTracker$getContentValues(), 0, this);
    }

    static int getRealDestPort(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRealDestPort", $$robo$$com_android_internal_telephony_InboundSmsTracker$getRealDestPort(int ), 0, (int)n);
    }

    void setDeleteWhere(String string2, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setDeleteWhere", $$robo$$com_android_internal_telephony_InboundSmsTracker$setDeleteWhere(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_InboundSmsTracker$toString(), 0, this);
    }

    byte[] getPdu() {
        return InvokeDynamicSupport.bootstrap("getPdu", $$robo$$com_android_internal_telephony_InboundSmsTracker$getPdu(), 0, this);
    }

    long getTimestamp() {
        return (long)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$com_android_internal_telephony_InboundSmsTracker$getTimestamp(), 0, this);
    }

    int getDestPort() {
        return (int)InvokeDynamicSupport.bootstrap("getDestPort", $$robo$$com_android_internal_telephony_InboundSmsTracker$getDestPort(), 0, this);
    }

    boolean is3gpp2() {
        return (boolean)InvokeDynamicSupport.bootstrap("is3gpp2", $$robo$$com_android_internal_telephony_InboundSmsTracker$is3gpp2(), 0, this);
    }

    String getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$com_android_internal_telephony_InboundSmsTracker$getFormat(), 0, this);
    }

    int getIndexOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getIndexOffset", $$robo$$com_android_internal_telephony_InboundSmsTracker$getIndexOffset(), 0, this);
    }

    String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$com_android_internal_telephony_InboundSmsTracker$getAddress(), 0, this);
    }

    int getReferenceNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getReferenceNumber", $$robo$$com_android_internal_telephony_InboundSmsTracker$getReferenceNumber(), 0, this);
    }

    int getSequenceNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getSequenceNumber", $$robo$$com_android_internal_telephony_InboundSmsTracker$getSequenceNumber(), 0, this);
    }

    int getMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getMessageCount", $$robo$$com_android_internal_telephony_InboundSmsTracker$getMessageCount(), 0, this);
    }

    String getDeleteWhere() {
        return InvokeDynamicSupport.bootstrap("getDeleteWhere", $$robo$$com_android_internal_telephony_InboundSmsTracker$getDeleteWhere(), 0, this);
    }

    String[] getDeleteWhereArgs() {
        return InvokeDynamicSupport.bootstrap("getDeleteWhereArgs", $$robo$$com_android_internal_telephony_InboundSmsTracker$getDeleteWhereArgs(), 0, this);
    }

    public /* synthetic */ InboundSmsTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InboundSmsTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

