/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.wifi.WifiManager;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.CellIdentityCdma;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.VoLteServiceState;
import android.text.TextUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallManager;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.Subscription;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyTester;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UsimServiceTable;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class PhoneBase
extends Handler
implements Phone,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "PhoneBase";
    private BroadcastReceiver mImsIntentReceiver;
    public static String NETWORK_SELECTION_KEY = "network_selection_key";
    public static String NETWORK_SELECTION_NAME_KEY = "network_selection_name_key";
    public static String DATA_DISABLED_ON_BOOT_KEY = "disabled_on_boot_key";
    protected static int EVENT_RADIO_AVAILABLE = 1;
    protected static int EVENT_SSN = 2;
    protected static int EVENT_SIM_RECORDS_LOADED = 3;
    protected static int EVENT_MMI_DONE = 4;
    protected static int EVENT_RADIO_ON = 5;
    protected static int EVENT_GET_BASEBAND_VERSION_DONE = 6;
    protected static int EVENT_USSD = 7;
    protected static int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 8;
    protected static int EVENT_GET_IMEI_DONE = 9;
    protected static int EVENT_GET_IMEISV_DONE = 10;
    protected static int EVENT_GET_SIM_STATUS_DONE = 11;
    protected static int EVENT_SET_CALL_FORWARD_DONE = 12;
    protected static int EVENT_GET_CALL_FORWARD_DONE = 13;
    protected static int EVENT_CALL_RING = 14;
    protected static int EVENT_CALL_RING_CONTINUE = 15;
    protected static int EVENT_SET_NETWORK_MANUAL_COMPLETE = 16;
    protected static int EVENT_SET_NETWORK_AUTOMATIC_COMPLETE = 17;
    protected static int EVENT_SET_CLIR_COMPLETE = 18;
    protected static int EVENT_REGISTERED_TO_NETWORK = 19;
    protected static int EVENT_SET_VM_NUMBER_DONE = 20;
    protected static int EVENT_GET_DEVICE_IDENTITY_DONE = 21;
    protected static int EVENT_RUIM_RECORDS_LOADED = 22;
    protected static int EVENT_NV_READY = 23;
    protected static int EVENT_SET_ENHANCED_VP = 24;
    protected static int EVENT_EMERGENCY_CALLBACK_MODE_ENTER = 25;
    protected static int EVENT_EXIT_EMERGENCY_CALLBACK_RESPONSE = 26;
    protected static int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 27;
    protected static int EVENT_SET_NETWORK_AUTOMATIC = 28;
    protected static int EVENT_ICC_RECORD_EVENTS = 29;
    protected static int EVENT_ICC_CHANGED = 30;
    protected static int EVENT_SRVCC_STATE_CHANGED = 31;
    protected static int EVENT_INITIATE_SILENT_REDIAL = 32;
    protected static int EVENT_UNSOL_OEM_HOOK_RAW = 33;
    protected static int EVENT_LAST = 33;
    public static String CLIR_KEY = "clir_key";
    public static String DNS_SERVER_CHECK_DISABLED_KEY = "dns_server_check_disabled_key";
    public CommandsInterface mCi;
    boolean mDnsCheckDisabled;
    public DcTrackerBase mDcTracker;
    boolean mDoesRilSendMultipleCallRing;
    int mCallRingContinueToken;
    int mCallRingDelay;
    public boolean mIsTheCurrentActivePhone;
    boolean mIsVoiceCapable;
    protected UiccController mUiccController;
    public AtomicReference<IccRecords> mIccRecords;
    public SmsStorageMonitor mSmsStorageMonitor;
    public SmsUsageMonitor mSmsUsageMonitor;
    protected AtomicReference<UiccCardApplication> mUiccApplication;
    private TelephonyTester mTelephonyTester;
    private String mName;
    private String mActionDetached;
    private String mActionAttached;
    protected Subscription mSubscriptionData;
    protected int mPhoneId;
    private Object mImsLock;
    private boolean mImsServiceReady;
    protected ImsPhone mImsPhone;
    protected RegistrantList mPreciseCallStateRegistrants;
    protected RegistrantList mHandoverRegistrants;
    protected RegistrantList mNewRingingConnectionRegistrants;
    protected RegistrantList mIncomingRingRegistrants;
    protected RegistrantList mDisconnectRegistrants;
    protected RegistrantList mServiceStateRegistrants;
    protected RegistrantList mMmiCompleteRegistrants;
    protected RegistrantList mMmiRegistrants;
    protected RegistrantList mUnknownConnectionRegistrants;
    protected RegistrantList mSuppServiceFailedRegistrants;
    protected RegistrantList mSimRecordsLoadedRegistrants;
    protected Looper mLooper;
    protected Context mContext;
    protected PhoneNotifier mNotifier;
    protected SimulatedRadioControl mSimulatedRadioControl;
    boolean mUnitTestMode;

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getPhoneName() {
        return this.mName;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getActionDetached() {
        return this.mActionDetached;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getActionAttached() {
        return this.mActionAttached;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setSystemProperty(String property, String value) {
        if (this.getUnitTestMode()) {
            return;
        }
        SystemProperties.set(property, value);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getSystemProperty(String property, String defValue) {
        if (this.getUnitTestMode()) {
            return null;
        }
        return SystemProperties.get(property, defValue);
    }

    private void $$robo$$com_android_internal_telephony_PhoneBase$__constructor__(String name, PhoneNotifier notifier, Context context, CommandsInterface ci) {
    }

    private void $$robo$$com_android_internal_telephony_PhoneBase$__constructor__(String name, PhoneNotifier notifier, Context context, CommandsInterface ci, boolean unitTestMode) {
    }

    private void $$robo$$com_android_internal_telephony_PhoneBase$__constructor__(String name, PhoneNotifier notifier, Context context, CommandsInterface ci, boolean unitTestMode, int phoneId) {
        this.mImsIntentReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PhoneBase this$0;

            private void $$robo$$com_android_internal_telephony_PhoneBase_1$__constructor__(PhoneBase phoneBase) {
            }

            private final void $$robo$$com_android_internal_telephony_PhoneBase_1$onReceive(Context context, Intent intent) {
                if (intent.hasExtra("android:subid") && intent.getLongExtra("android:subid", -1L) != this.this$0.getSubId()) {
                    return;
                }
                if (intent.getAction().equals("com.android.ims.IMS_SERVICE_UP")) {
                    this.this$0.mImsServiceReady = true;
                    this.this$0.updateImsPhone();
                } else if (intent.getAction().equals("com.android.ims.IMS_SERVICE_DOWN")) {
                    this.this$0.mImsServiceReady = false;
                    this.this$0.updateImsPhone();
                }
            }

            private void __constructor__(PhoneBase phoneBase) {
                this.$$robo$$com_android_internal_telephony_PhoneBase_1$__constructor__(phoneBase);
            }
            {
                this.this$0 = phoneBase;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneBase_1$__constructor__(com.android.internal.telephony.PhoneBase ), 0, this, phoneBase);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_PhoneBase_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mIsTheCurrentActivePhone = true;
        this.mIsVoiceCapable = true;
        this.mUiccController = null;
        this.mIccRecords = new AtomicReference();
        this.mUiccApplication = new AtomicReference();
        this.mSubscriptionData = null;
        this.mImsLock = new Object();
        this.mImsServiceReady = false;
        this.mImsPhone = null;
        this.mPreciseCallStateRegistrants = new RegistrantList();
        this.mHandoverRegistrants = new RegistrantList();
        this.mNewRingingConnectionRegistrants = new RegistrantList();
        this.mIncomingRingRegistrants = new RegistrantList();
        this.mDisconnectRegistrants = new RegistrantList();
        this.mServiceStateRegistrants = new RegistrantList();
        this.mMmiCompleteRegistrants = new RegistrantList();
        this.mMmiRegistrants = new RegistrantList();
        this.mUnknownConnectionRegistrants = new RegistrantList();
        this.mSuppServiceFailedRegistrants = new RegistrantList();
        this.mSimRecordsLoadedRegistrants = new RegistrantList();
        this.mPhoneId = phoneId;
        this.mName = name;
        this.mNotifier = notifier;
        this.mContext = context;
        this.mLooper = Looper.myLooper();
        this.mCi = ci;
        this.mActionDetached = this.getClass().getPackage().getName() + ".action_detached";
        this.mActionAttached = this.getClass().getPackage().getName() + ".action_attached";
        if (Build.IS_DEBUGGABLE) {
            this.mTelephonyTester = new TelephonyTester(this);
        }
        this.setUnitTestMode(unitTestMode);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        this.mDnsCheckDisabled = sp.getBoolean("dns_server_check_disabled_key", false);
        this.mCi.setOnCallRing(this, 14, null);
        this.mIsVoiceCapable = this.mContext.getResources().getBoolean(17956931);
        this.mDoesRilSendMultipleCallRing = SystemProperties.getBoolean("ro.telephony.call_ring.multiple", true);
        Rlog.d("PhoneBase", "mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing);
        this.mCallRingDelay = SystemProperties.getInt("ro.telephony.call_ring.delay", 3000);
        Rlog.d("PhoneBase", "mCallRingDelay=" + this.mCallRingDelay);
        if (this.getPhoneType() == 5) {
            return;
        }
        this.setPropertiesByCarrier();
        this.mSmsStorageMonitor = new SmsStorageMonitor(this);
        this.mSmsUsageMonitor = new SmsUsageMonitor(context);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 30, null);
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.android.ims.IMS_SERVICE_UP");
        filter.addAction("com.android.ims.IMS_SERVICE_DOWN");
        this.mContext.registerReceiver(this.mImsIntentReceiver, filter);
        this.mCi.registerForSrvccStateChanged(this, 31, null);
        this.mCi.setOnUnsolOemHookRaw(this, 33, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_PhoneBase$dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            ImsPhone imsPhone;
            this.mContext.unregisterReceiver(this.mImsIntentReceiver);
            this.mCi.unSetOnCallRing(this);
            this.mDcTracker.cleanUpAllConnections(null);
            this.mIsTheCurrentActivePhone = false;
            this.mSmsStorageMonitor.dispose();
            this.mSmsUsageMonitor.dispose();
            this.mUiccController.unregisterForIccChanged(this);
            this.mCi.unregisterForSrvccStateChanged(this);
            this.mCi.unSetOnUnsolOemHookRaw(this);
            if (this.mTelephonyTester != null) {
                this.mTelephonyTester.dispose();
            }
            if ((imsPhone = this.mImsPhone) != null) {
                imsPhone.unregisterForSilentRedial(this);
                imsPhone.dispose();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$removeReferences() {
        this.mSmsStorageMonitor = null;
        this.mSmsUsageMonitor = null;
        this.mIccRecords.set(null);
        this.mUiccApplication.set(null);
        this.mDcTracker = null;
        this.mUiccController = null;
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null) {
            imsPhone.removeReferences();
            this.mImsPhone = null;
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$handleMessage(Message msg) {
        if (!this.mIsTheCurrentActivePhone) {
            Rlog.e("PhoneBase", "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        switch (msg.what) {
            case 14: {
                Rlog.d("PhoneBase", "Event EVENT_CALL_RING Received state=" + (Object)((Object)this.getState()));
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                PhoneConstants.State state = this.getState();
                if (!(this.mDoesRilSendMultipleCallRing || state != PhoneConstants.State.RINGING && state != PhoneConstants.State.IDLE)) {
                    ++this.mCallRingContinueToken;
                    this.sendIncomingCallRingNotification(this.mCallRingContinueToken);
                    break;
                }
                this.notifyIncomingRing();
                break;
            }
            case 15: {
                Rlog.d("PhoneBase", "Event EVENT_CALL_RING_CONTINUE Received stat=" + (Object)((Object)this.getState()));
                if (this.getState() != PhoneConstants.State.RINGING) break;
                this.sendIncomingCallRingNotification(msg.arg1);
                break;
            }
            case 30: {
                this.onUpdateIccAvailability();
                break;
            }
            case 16: 
            case 17: {
                this.handleSetSelectNetwork((AsyncResult)msg.obj);
                break;
            }
            case 32: {
                Rlog.d("PhoneBase", "Event EVENT_INITIATE_SILENT_REDIAL Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null || ar.result == null) break;
                String dialString = (String)ar.result;
                if (TextUtils.isEmpty(dialString)) {
                    return;
                }
                try {
                    this.dialInternal(dialString, null, 0);
                }
                catch (CallStateException e) {
                    Rlog.e("PhoneBase", "silent redial failed: " + e);
                }
                break;
            }
            case 31: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.handleSrvccStateChanged((int[])ar.result);
                    break;
                }
                Rlog.e("PhoneBase", "Srvcc exception: " + ar.exception);
                break;
            }
            case 33: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    Rlog.d("PhoneBase", "EVENT_UNSOL_OEM_HOOK_RAW data=" + IccUtils.bytesToHexString(data));
                    this.mNotifier.notifyOemHookRawEventForSubscriber(this.getSubId(), data);
                    break;
                }
                Rlog.e("PhoneBase", "OEM hook raw exception: " + ar.exception);
                break;
            }
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$handleSrvccStateChanged(int[] ret) {
        Rlog.d("PhoneBase", "handleSrvccStateChanged");
        ImsPhoneConnection conn = null;
        ImsPhone imsPhone = this.mImsPhone;
        Call.SrvccState srvccState = Call.SrvccState.NONE;
        if (ret != null && ret.length != 0) {
            int state = ret[0];
            switch (state) {
                case 0: {
                    srvccState = Call.SrvccState.STARTED;
                    if (imsPhone != null) {
                        conn = imsPhone.getHandoverConnection();
                        break;
                    }
                    Rlog.d("PhoneBase", "HANDOVER_STARTED: mImsPhone null");
                    break;
                }
                case 1: {
                    srvccState = Call.SrvccState.COMPLETED;
                    if (imsPhone != null) {
                        imsPhone.notifySrvccState(srvccState);
                        break;
                    }
                    Rlog.d("PhoneBase", "HANDOVER_COMPLETED: mImsPhone null");
                    break;
                }
                case 2: 
                case 3: {
                    srvccState = Call.SrvccState.FAILED;
                    break;
                }
                default: {
                    return;
                }
            }
            this.getCallTracker().notifySrvccState(srvccState, conn);
            VoLteServiceState lteState = new VoLteServiceState(state);
            this.notifyVoLteServiceStateChanged(lteState);
        }
    }

    private final Context $$robo$$com_android_internal_telephony_PhoneBase$getContext() {
        return this.mContext;
    }

    protected abstract void onUpdateIccAvailability();

    private final void $$robo$$com_android_internal_telephony_PhoneBase$disableDnsCheck(boolean b) {
        this.mDnsCheckDisabled = b;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean("dns_server_check_disabled_key", b);
        editor.apply();
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$isDnsCheckDisabled() {
        return this.mDnsCheckDisabled;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForPreciseCallStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mPreciseCallStateRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForPreciseCallStateChanged(Handler h) {
        this.mPreciseCallStateRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyPreciseCallStateChangedP() {
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mPreciseCallStateRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyPreciseCallState(this);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForHandoverStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mHandoverRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForHandoverStateChanged(Handler h) {
        this.mHandoverRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyHandoverStateChanged(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mHandoverRegistrants.notifyRegistrants(ar);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$migrateFrom(PhoneBase from) {
        this.migrate(this.mHandoverRegistrants, from.mHandoverRegistrants);
        this.migrate(this.mPreciseCallStateRegistrants, from.mPreciseCallStateRegistrants);
        this.migrate(this.mNewRingingConnectionRegistrants, from.mNewRingingConnectionRegistrants);
        this.migrate(this.mIncomingRingRegistrants, from.mIncomingRingRegistrants);
        this.migrate(this.mDisconnectRegistrants, from.mDisconnectRegistrants);
        this.migrate(this.mServiceStateRegistrants, from.mServiceStateRegistrants);
        this.migrate(this.mMmiCompleteRegistrants, from.mMmiCompleteRegistrants);
        this.migrate(this.mMmiRegistrants, from.mMmiRegistrants);
        this.migrate(this.mUnknownConnectionRegistrants, from.mUnknownConnectionRegistrants);
        this.migrate(this.mSuppServiceFailedRegistrants, from.mSuppServiceFailedRegistrants);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$migrate(RegistrantList to, RegistrantList from) {
        from.removeCleared();
        int n = from.size();
        for (int i = 0; i < n; ++i) {
            to.add((Registrant)from.get(i));
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForUnknownConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mUnknownConnectionRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForUnknownConnection(Handler h) {
        this.mUnknownConnectionRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mNewRingingConnectionRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForNewRingingConnection(Handler h) {
        this.mNewRingingConnectionRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mCi.registerForInCallVoicePrivacyOn(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mCi.unregisterForInCallVoicePrivacyOn(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mCi.registerForInCallVoicePrivacyOff(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mCi.unregisterForInCallVoicePrivacyOff(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForIncomingRing(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mIncomingRingRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForIncomingRing(Handler h) {
        this.mIncomingRingRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForDisconnect(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mDisconnectRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForDisconnect(Handler h) {
        this.mDisconnectRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mSuppServiceFailedRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForSuppServiceFailed(Handler h) {
        this.mSuppServiceFailedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForMmiInitiate(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForMmiInitiate(Handler h) {
        this.mMmiRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForMmiComplete(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForMmiComplete(Handler h) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForSimRecordsLoaded(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("registerForSimRecordsLoaded");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForSimRecordsLoaded(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unregisterForSimRecordsLoaded");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setNetworkSelectionModeAutomatic(Message response) {
        NetworkSelectMessage nsm = new NetworkSelectMessage();
        nsm.message = response;
        nsm.operatorNumeric = "";
        nsm.operatorAlphaLong = "";
        Message msg = this.obtainMessage(17, nsm);
        this.mCi.setNetworkSelectionModeAutomatic(msg);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$selectNetworkManually(OperatorInfo network, Message response) {
        NetworkSelectMessage nsm = new NetworkSelectMessage();
        nsm.message = response;
        nsm.operatorNumeric = network.getOperatorNumeric();
        nsm.operatorAlphaLong = network.getOperatorAlphaLong();
        Message msg = this.obtainMessage(16, nsm);
        this.mCi.setNetworkSelectionModeManual(network.getOperatorNumeric(), msg);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$handleSetSelectNetwork(AsyncResult ar) {
        if (!(ar.userObj instanceof NetworkSelectMessage)) {
            Rlog.e("PhoneBase", "unexpected result from user object.");
            return;
        }
        NetworkSelectMessage nsm = (NetworkSelectMessage)ar.userObj;
        if (nsm.message != null) {
            AsyncResult.forMessage(nsm.message, ar.result, ar.exception);
            nsm.message.sendToTarget();
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("network_selection_key", nsm.operatorNumeric);
        editor.putString("network_selection_name_key", nsm.operatorAlphaLong);
        if (!editor.commit()) {
            Rlog.e("PhoneBase", "failed to commit network selection preference");
        }
    }

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getSavedNetworkSelection() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        return sp.getString("network_selection_key", "");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$restoreSavedNetworkSelection(Message response) {
        String networkSelection = this.getSavedNetworkSelection();
        if (TextUtils.isEmpty(networkSelection)) {
            this.mCi.setNetworkSelectionModeAutomatic(response);
        } else {
            this.mCi.setNetworkSelectionModeManual(networkSelection, response);
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setUnitTestMode(boolean f) {
        this.mUnitTestMode = f;
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$getUnitTestMode() {
        return this.mUnitTestMode;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyDisconnectP(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mDisconnectRegistrants.notifyRegistrants(ar);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mServiceStateRegistrants.add(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForServiceStateChanged(Handler h) {
        this.mServiceStateRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForRingbackTone(Handler h, int what, Object obj) {
        this.mCi.registerForRingbackTone(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForRingbackTone(Handler h) {
        this.mCi.unregisterForRingbackTone(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForOnHoldTone(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForOnHoldTone(Handler h) {
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForResendIncallMute(Handler h, int what, Object obj) {
        this.mCi.registerForResendIncallMute(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForResendIncallMute(Handler h) {
        this.mCi.unregisterForResendIncallMute(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setEchoSuppressionEnabled() {
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyServiceStateChangedP(ServiceState ss) {
        AsyncResult ar = new AsyncResult(null, ss, null);
        this.mServiceStateRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyServiceState(this);
    }

    private final SimulatedRadioControl $$robo$$com_android_internal_telephony_PhoneBase$getSimulatedRadioControl() {
        return this.mSimulatedRadioControl;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$checkCorrectThread(Handler h) {
        if (h.getLooper() != this.mLooper) {
            throw new RuntimeException("com.android.internal.telephony.Phone must be used from within one thread");
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setPropertiesByCarrier() {
        String carrier = SystemProperties.get("ro.carrier");
        if (null == carrier || 0 == carrier.length() || "unknown".equals(carrier)) {
            return;
        }
        CharSequence[] carrierLocales = this.mContext.getResources().getTextArray(17236034);
        for (int i = 0; i < carrierLocales.length; i += 3) {
            String c = carrierLocales[i].toString();
            if (!carrier.equals(c)) continue;
            Locale l = Locale.forLanguageTag(carrierLocales[i + 1].toString().replace('_', '-'));
            String country = l.getCountry();
            MccTable.setSystemLocale(this.mContext, l.getLanguage(), country);
            if (!country.isEmpty()) {
                try {
                    Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_country_code");
                }
                catch (Settings.SettingNotFoundException e) {
                    WifiManager wM = (WifiManager)this.mContext.getSystemService("wifi");
                    wM.setCountryCode(country, false);
                }
            }
            return;
        }
    }

    @Override
    public abstract PhoneConstants.State getState();

    private final IccFileHandler $$robo$$com_android_internal_telephony_PhoneBase$getIccFileHandler() {
        IccFileHandler fh;
        UiccCardApplication uiccApplication = this.mUiccApplication.get();
        if (uiccApplication == null) {
            Rlog.d("PhoneBase", "getIccFileHandler: uiccApplication == null, return null");
            fh = null;
        } else {
            fh = uiccApplication.getIccFileHandler();
        }
        Rlog.d("PhoneBase", "getIccFileHandler: fh=" + fh);
        return fh;
    }

    private final Handler $$robo$$com_android_internal_telephony_PhoneBase$getHandler() {
        return this;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$updatePhoneObject(int voiceRadioTech) {
        PhoneFactory.getDefaultPhone().updatePhoneObject(voiceRadioTech);
    }

    private final ServiceStateTracker $$robo$$com_android_internal_telephony_PhoneBase$getServiceStateTracker() {
        return null;
    }

    private final CallTracker $$robo$$com_android_internal_telephony_PhoneBase$getCallTracker() {
        return null;
    }

    private final IccCardApplicationStatus.AppType $$robo$$com_android_internal_telephony_PhoneBase$getCurrentUiccAppType() {
        UiccCardApplication currentApp = this.mUiccApplication.get();
        if (currentApp != null) {
            return currentApp.getType();
        }
        return IccCardApplicationStatus.AppType.APPTYPE_UNKNOWN;
    }

    private final IccCard $$robo$$com_android_internal_telephony_PhoneBase$getIccCard() {
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getIccSerialNumber() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getIccId() : null;
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$getIccRecordsLoaded() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getRecordsLoaded() : false;
    }

    private final List<CellInfo> $$robo$$com_android_internal_telephony_PhoneBase$getAllCellInfo() {
        List<CellInfo> cellInfoList = this.getServiceStateTracker().getAllCellInfo();
        return this.privatizeCellInfoList(cellInfoList);
    }

    private final List<CellInfo> $$robo$$com_android_internal_telephony_PhoneBase$privatizeCellInfoList(List<CellInfo> cellInfoList) {
        int mode = Settings.Secure.getInt(this.getContext().getContentResolver(), "location_mode", 0);
        if (mode == 0) {
            ArrayList<CellInfo> privateCellInfoList = new ArrayList<CellInfo>(cellInfoList.size());
            for (CellInfo c : cellInfoList) {
                if (c instanceof CellInfoCdma) {
                    CellInfoCdma cellInfoCdma = (CellInfoCdma)c;
                    CellIdentityCdma cellIdentity = cellInfoCdma.getCellIdentity();
                    CellIdentityCdma maskedCellIdentity = new CellIdentityCdma(cellIdentity.getNetworkId(), cellIdentity.getSystemId(), cellIdentity.getBasestationId(), Integer.MAX_VALUE, Integer.MAX_VALUE);
                    CellInfoCdma privateCellInfoCdma = new CellInfoCdma(cellInfoCdma);
                    privateCellInfoCdma.setCellIdentity(maskedCellIdentity);
                    privateCellInfoList.add(privateCellInfoCdma);
                    continue;
                }
                privateCellInfoList.add(c);
            }
            cellInfoList = privateCellInfoList;
        }
        return cellInfoList;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setCellInfoListRate(int rateInMillis) {
        this.mCi.setCellInfoListRate(rateInMillis, null);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$getMessageWaitingIndicator() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getVoiceMessageWaiting() : false;
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$getCallForwardingIndicator() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getVoiceCallForwardingFlag() : false;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$queryCdmaRoamingPreference(Message response) {
        this.mCi.queryCdmaRoamingPreference(response);
    }

    private final SignalStrength $$robo$$com_android_internal_telephony_PhoneBase$getSignalStrength() {
        ServiceStateTracker sst = this.getServiceStateTracker();
        if (sst == null) {
            return new SignalStrength();
        }
        return sst.getSignalStrength();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        this.mCi.setCdmaRoamingPreference(cdmaRoamingType, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setCdmaSubscription(int cdmaSubscriptionType, Message response) {
        this.mCi.setCdmaSubscriptionSource(cdmaSubscriptionType, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setPreferredNetworkType(int networkType, Message response) {
        this.mCi.setPreferredNetworkType(networkType, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$getPreferredNetworkType(Message response) {
        this.mCi.getPreferredNetworkType(response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$getSmscAddress(Message result) {
        this.mCi.getSmscAddress(result);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setSmscAddress(String address, Message result) {
        this.mCi.setSmscAddress(address, result);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setTTYMode(int ttyMode, Message onComplete) {
        this.mCi.setTTYMode(ttyMode, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$queryTTYMode(Message onComplete) {
        this.mCi.queryTTYMode(onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
        PhoneBase.logUnexpectedCdmaMethodCall("enableEnhancedVoicePrivacy");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$getEnhancedVoicePrivacy(Message onComplete) {
        PhoneBase.logUnexpectedCdmaMethodCall("getEnhancedVoicePrivacy");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setBandMode(int bandMode, Message response) {
        this.mCi.setBandMode(bandMode, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$queryAvailableBandMode(Message response) {
        this.mCi.queryAvailableBandMode(response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$invokeOemRilRequestRaw(byte[] data, Message response) {
        this.mCi.invokeOemRilRequestRaw(data, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$invokeOemRilRequestStrings(String[] strings, Message response) {
        this.mCi.invokeOemRilRequestStrings(strings, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$nvReadItem(int itemID, Message response) {
        this.mCi.nvReadItem(itemID, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$nvWriteItem(int itemID, String itemValue, Message response) {
        this.mCi.nvWriteItem(itemID, itemValue, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$nvWriteCdmaPrl(byte[] preferredRoamingList, Message response) {
        this.mCi.nvWriteCdmaPrl(preferredRoamingList, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$nvResetConfig(int resetType, Message response) {
        this.mCi.nvResetConfig(resetType, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyDataActivity() {
        this.mNotifier.notifyDataActivity(this);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyMessageWaitingIndicator() {
        if (!this.mIsVoiceCapable) {
            return;
        }
        this.mNotifier.notifyMessageWaitingChanged(this);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyDataConnection(String reason, String apnType, PhoneConstants.DataState state) {
        this.mNotifier.notifyDataConnection(this, reason, apnType, state);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyDataConnection(String reason, String apnType) {
        this.mNotifier.notifyDataConnection(this, reason, apnType, this.getDataConnectionState(apnType));
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyDataConnection(String reason) {
        String[] types;
        for (String apnType : types = this.getActiveApnTypes()) {
            this.mNotifier.notifyDataConnection(this, reason, apnType, this.getDataConnectionState(apnType));
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyOtaspChanged(int otaspMode) {
        this.mNotifier.notifyOtaspChanged(this, otaspMode);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifySignalStrength() {
        this.mNotifier.notifySignalStrength(this);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyCellInfo(List<CellInfo> cellInfo) {
        this.mNotifier.notifyCellInfo(this, this.privatizeCellInfoList(cellInfo));
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyDataConnectionRealTimeInfo(DataConnectionRealTimeInfo dcRtInfo) {
        this.mNotifier.notifyDataConnectionRealTimeInfo(this, dcRtInfo);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyVoLteServiceStateChanged(VoLteServiceState lteState) {
        this.mNotifier.notifyVoLteServiceStateChanged(this, lteState);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$isInEmergencyCall() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$isInEcm() {
        return false;
    }

    @Override
    public abstract int getPhoneType();

    private final int $$robo$$com_android_internal_telephony_PhoneBase$getVoiceMessageCount() {
        return 0;
    }

    private final int $$robo$$com_android_internal_telephony_PhoneBase$getCdmaEriIconIndex() {
        PhoneBase.logUnexpectedCdmaMethodCall("getCdmaEriIconIndex");
        return -1;
    }

    private final int $$robo$$com_android_internal_telephony_PhoneBase$getCdmaEriIconMode() {
        PhoneBase.logUnexpectedCdmaMethodCall("getCdmaEriIconMode");
        return -1;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getCdmaEriText() {
        PhoneBase.logUnexpectedCdmaMethodCall("getCdmaEriText");
        return "GSM nw, no ERI";
    }

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getCdmaMin() {
        PhoneBase.logUnexpectedCdmaMethodCall("getCdmaMin");
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$isMinInfoReady() {
        PhoneBase.logUnexpectedCdmaMethodCall("isMinInfoReady");
        return false;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getCdmaPrlVersion() {
        PhoneBase.logUnexpectedCdmaMethodCall("getCdmaPrlVersion");
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        PhoneBase.logUnexpectedCdmaMethodCall("sendBurstDtmf");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$exitEmergencyCallbackMode() {
        PhoneBase.logUnexpectedCdmaMethodCall("exitEmergencyCallbackMode");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("registerForCdmaOtaStatusChange");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForCdmaOtaStatusChange(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unregisterForCdmaOtaStatusChange");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("registerForSubscriptionInfoReady");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForSubscriptionInfoReady(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unregisterForSubscriptionInfoReady");
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$needsOtaServiceProvisioning() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$isOtaSpNumber(String dialStr) {
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForCallWaiting(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("registerForCallWaiting");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForCallWaiting(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unregisterForCallWaiting");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForEcmTimerReset(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("registerForEcmTimerReset");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForEcmTimerReset(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unregisterForEcmTimerReset");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForSignalInfo(Handler h, int what, Object obj) {
        this.mCi.registerForSignalInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForSignalInfo(Handler h) {
        this.mCi.unregisterForSignalInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mCi.registerForDisplayInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForDisplayInfo(Handler h) {
        this.mCi.unregisterForDisplayInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForNumberInfo(Handler h, int what, Object obj) {
        this.mCi.registerForNumberInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForNumberInfo(Handler h) {
        this.mCi.unregisterForNumberInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForRedirectedNumberInfo(Handler h, int what, Object obj) {
        this.mCi.registerForRedirectedNumberInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForRedirectedNumberInfo(Handler h) {
        this.mCi.unregisterForRedirectedNumberInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForLineControlInfo(Handler h, int what, Object obj) {
        this.mCi.registerForLineControlInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForLineControlInfo(Handler h) {
        this.mCi.unregisterForLineControlInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerFoT53ClirlInfo(Handler h, int what, Object obj) {
        this.mCi.registerFoT53ClirlInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForT53ClirInfo(Handler h) {
        this.mCi.unregisterForT53ClirInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$registerForT53AudioControlInfo(Handler h, int what, Object obj) {
        this.mCi.registerForT53AudioControlInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unregisterForT53AudioControlInfo(Handler h) {
        this.mCi.unregisterForT53AudioControlInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("setOnEcbModeExitResponse");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$unsetOnEcbModeExitResponse(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unsetOnEcbModeExitResponse");
    }

    private final String[] $$robo$$com_android_internal_telephony_PhoneBase$getActiveApnTypes() {
        return this.mDcTracker.getActiveApnTypes();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getActiveApnHost(String apnType) {
        return this.mDcTracker.getActiveApnString(apnType);
    }

    private final LinkProperties $$robo$$com_android_internal_telephony_PhoneBase$getLinkProperties(String apnType) {
        return this.mDcTracker.getLinkProperties(apnType);
    }

    private final NetworkCapabilities $$robo$$com_android_internal_telephony_PhoneBase$getNetworkCapabilities(String apnType) {
        return this.mDcTracker.getNetworkCapabilities(apnType);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$isDataConnectivityPossible() {
        return this.isDataConnectivityPossible("default");
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$isDataConnectivityPossible(String apnType) {
        return this.mDcTracker != null && this.mDcTracker.isDataPossible(apnType);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyNewRingingConnectionP(Connection cn) {
        if (!this.mIsVoiceCapable) {
            return;
        }
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mNewRingingConnectionRegistrants.notifyRegistrants(ar);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyIncomingRing() {
        if (!this.mIsVoiceCapable) {
            return;
        }
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mIncomingRingRegistrants.notifyRegistrants(ar);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$sendIncomingCallRingNotification(int token) {
        if (this.mIsVoiceCapable && !this.mDoesRilSendMultipleCallRing && token == this.mCallRingContinueToken) {
            Rlog.d("PhoneBase", "Sending notifyIncomingRing");
            this.notifyIncomingRing();
            this.sendMessageDelayed(this.obtainMessage(15, token, 0), this.mCallRingDelay);
        } else {
            Rlog.d("PhoneBase", "Ignoring ring notification request, mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing + " token=" + token + " mCallRingContinueToken=" + this.mCallRingContinueToken + " mIsVoiceCapable=" + this.mIsVoiceCapable);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$isCspPlmnEnabled() {
        PhoneBase.logUnexpectedGsmMethodCall("isCspPlmnEnabled");
        return false;
    }

    private final IsimRecords $$robo$$com_android_internal_telephony_PhoneBase$getIsimRecords() {
        Rlog.e("PhoneBase", "getIsimRecords() is only supported on LTE devices");
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_PhoneBase$getMsisdn() {
        PhoneBase.logUnexpectedGsmMethodCall("getMsisdn");
        return null;
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneBase$logUnexpectedCdmaMethodCall(String name) {
        Rlog.e("PhoneBase", "Error! " + name + "() in PhoneBase should not be " + "called, CDMAPhone inactive.");
    }

    private final PhoneConstants.DataState $$robo$$com_android_internal_telephony_PhoneBase$getDataConnectionState() {
        return this.getDataConnectionState("default");
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneBase$logUnexpectedGsmMethodCall(String name) {
        Rlog.e("PhoneBase", "Error! " + name + "() in PhoneBase should not be " + "called, GSMPhone inactive.");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyCallForwardingIndicator() {
        Rlog.e("PhoneBase", "Error! This function should never be executed, inactive CDMAPhone.");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyDataConnectionFailed(String reason, String apnType) {
        this.mNotifier.notifyDataConnectionFailed(this, reason, apnType);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$notifyPreciseDataConnectionFailed(String reason, String apnType, String apn, String failCause) {
        this.mNotifier.notifyPreciseDataConnectionFailed(this, reason, apnType, apn, failCause);
    }

    private final int $$robo$$com_android_internal_telephony_PhoneBase$getLteOnCdmaMode() {
        return this.mCi.getLteOnCdmaMode();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setVoiceMessageWaiting(int line, int countWaiting) {
        IccRecords r = this.mIccRecords.get();
        if (r != null) {
            r.setVoiceMessageWaiting(line, countWaiting);
        }
    }

    private final UsimServiceTable $$robo$$com_android_internal_telephony_PhoneBase$getUsimServiceTable() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getUsimServiceTable() : null;
    }

    private final UiccCard $$robo$$com_android_internal_telephony_PhoneBase$getUiccCard() {
        return this.mUiccController.getUiccCard(this.mPhoneId);
    }

    private final String[] $$robo$$com_android_internal_telephony_PhoneBase$getPcscfAddress(String apnType) {
        return this.mDcTracker.getPcscfAddress(apnType);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$setImsRegistrationState(boolean registered) {
        this.mDcTracker.setImsRegistrationState(registered);
    }

    private final Phone $$robo$$com_android_internal_telephony_PhoneBase$getImsPhone() {
        return this.mImsPhone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ImsPhone $$robo$$com_android_internal_telephony_PhoneBase$relinquishOwnershipOfImsPhone() {
        Object object = this.mImsLock;
        synchronized (object) {
            if (this.mImsPhone == null) {
                return null;
            }
            ImsPhone imsPhone = this.mImsPhone;
            this.mImsPhone = null;
            CallManager.getInstance().unregisterPhone(imsPhone);
            imsPhone.unregisterForSilentRedial(this);
            return imsPhone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_PhoneBase$acquireOwnershipOfImsPhone(ImsPhone imsPhone) {
        Object object = this.mImsLock;
        synchronized (object) {
            if (imsPhone == null) {
                return;
            }
            if (this.mImsPhone != null) {
                Rlog.e("PhoneBase", "acquireOwnershipOfImsPhone: non-null mImsPhone. Shouldn't happen - but disposing");
                this.mImsPhone.dispose();
            }
            this.mImsPhone = imsPhone;
            this.mImsServiceReady = true;
            this.mImsPhone.updateParentPhone(this);
            CallManager.getInstance().registerPhone(this.mImsPhone);
            this.mImsPhone.registerForSilentRedial(this, 32, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_PhoneBase$updateImsPhone() {
        Object object = this.mImsLock;
        synchronized (object) {
            Rlog.d("PhoneBase", "updateImsPhone mImsServiceReady=" + this.mImsServiceReady);
            if (this.mImsServiceReady && this.mImsPhone == null) {
                this.mImsPhone = PhoneFactory.makeImsPhone(this.mNotifier, this);
                CallManager.getInstance().registerPhone(this.mImsPhone);
                this.mImsPhone.registerForSilentRedial(this, 32, null);
            } else if (!this.mImsServiceReady && this.mImsPhone != null) {
                CallManager.getInstance().unregisterPhone(this.mImsPhone);
                this.mImsPhone.unregisterForSilentRedial(this);
                this.mImsPhone.dispose();
                this.mImsPhone = null;
            }
        }
    }

    private final Connection $$robo$$com_android_internal_telephony_PhoneBase$dialInternal(String dialString, UUSInfo uusInfo, int videoState) throws CallStateException {
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("PhoneBase:");
        pw.println(" mCi=" + this.mCi);
        pw.println(" mDnsCheckDisabled=" + this.mDnsCheckDisabled);
        pw.println(" mDcTracker=" + this.mDcTracker);
        pw.println(" mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing);
        pw.println(" mCallRingContinueToken=" + this.mCallRingContinueToken);
        pw.println(" mCallRingDelay=" + this.mCallRingDelay);
        pw.println(" mIsTheCurrentActivePhone=" + this.mIsTheCurrentActivePhone);
        pw.println(" mIsVoiceCapable=" + this.mIsVoiceCapable);
        pw.println(" mIccRecords=" + this.mIccRecords.get());
        pw.println(" mUiccApplication=" + this.mUiccApplication.get());
        pw.println(" mSmsStorageMonitor=" + this.mSmsStorageMonitor);
        pw.println(" mSmsUsageMonitor=" + this.mSmsUsageMonitor);
        pw.flush();
        pw.println(" mLooper=" + this.mLooper);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mNotifier=" + this.mNotifier);
        pw.println(" mSimulatedRadioControl=" + this.mSimulatedRadioControl);
        pw.println(" mUnitTestMode=" + this.mUnitTestMode);
        pw.println(" isDnsCheckDisabled()=" + this.isDnsCheckDisabled());
        pw.println(" getUnitTestMode()=" + this.getUnitTestMode());
        pw.println(" getState()=" + (Object)((Object)this.getState()));
        pw.println(" getIccSerialNumber()=" + this.getIccSerialNumber());
        pw.println(" getIccRecordsLoaded()=" + this.getIccRecordsLoaded());
        pw.println(" getMessageWaitingIndicator()=" + this.getMessageWaitingIndicator());
        pw.println(" getCallForwardingIndicator()=" + this.getCallForwardingIndicator());
        pw.println(" isInEmergencyCall()=" + this.isInEmergencyCall());
        pw.flush();
        pw.println(" isInEcm()=" + this.isInEcm());
        pw.println(" getPhoneName()=" + this.getPhoneName());
        pw.println(" getPhoneType()=" + this.getPhoneType());
        pw.println(" getVoiceMessageCount()=" + this.getVoiceMessageCount());
        pw.println(" getActiveApnTypes()=" + this.getActiveApnTypes());
        pw.println(" isDataConnectivityPossible()=" + this.isDataConnectivityPossible());
        pw.println(" needsOtaServiceProvisioning=" + this.needsOtaServiceProvisioning());
    }

    private final long $$robo$$com_android_internal_telephony_PhoneBase$getSubId() {
        return SubscriptionController.getInstance().getSubIdUsingPhoneId(this.mPhoneId);
    }

    private final int $$robo$$com_android_internal_telephony_PhoneBase$getPhoneId() {
        return this.mPhoneId;
    }

    private final Subscription $$robo$$com_android_internal_telephony_PhoneBase$getSubscriptionInfo() {
        return this.mSubscriptionData;
    }

    private final int $$robo$$com_android_internal_telephony_PhoneBase$getVoicePhoneServiceState() {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            return 0;
        }
        return this.getServiceState().getState();
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$setOperatorBrandOverride(String brand) {
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneBase$isRadioAvailable() {
        return this.mCi.getRadioState().isAvailable();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneBase$shutdownRadio() {
        this.getServiceStateTracker().requestShutdown();
    }

    @Override
    public String getPhoneName() {
        return InvokeDynamicSupport.bootstrap("getPhoneName", $$robo$$com_android_internal_telephony_PhoneBase$getPhoneName(), 0, this);
    }

    public String getActionDetached() {
        return InvokeDynamicSupport.bootstrap("getActionDetached", $$robo$$com_android_internal_telephony_PhoneBase$getActionDetached(), 0, this);
    }

    public String getActionAttached() {
        return InvokeDynamicSupport.bootstrap("getActionAttached", $$robo$$com_android_internal_telephony_PhoneBase$getActionAttached(), 0, this);
    }

    public void setSystemProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSystemProperty", $$robo$$com_android_internal_telephony_PhoneBase$setSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String getSystemProperty(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getSystemProperty", $$robo$$com_android_internal_telephony_PhoneBase$getSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void __constructor__(String string2, PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_PhoneBase$__constructor__(string2, phoneNotifier, context, commandsInterface);
    }

    protected PhoneBase(String string2, PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface) {
        this(string2, phoneNotifier, context, commandsInterface, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneBase$__constructor__(java.lang.String com.android.internal.telephony.PhoneNotifier android.content.Context com.android.internal.telephony.CommandsInterface ), 0, this, string2, phoneNotifier, context, commandsInterface);
    }

    private void __constructor__(String string2, PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface, boolean bl) {
        this.$$robo$$com_android_internal_telephony_PhoneBase$__constructor__(string2, phoneNotifier, context, commandsInterface, bl);
    }

    protected PhoneBase(String string2, PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface, boolean bl) {
        this(string2, phoneNotifier, context, commandsInterface, bl, Integer.MAX_VALUE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneBase$__constructor__(java.lang.String com.android.internal.telephony.PhoneNotifier android.content.Context com.android.internal.telephony.CommandsInterface boolean ), 0, this, string2, phoneNotifier, context, commandsInterface, bl);
    }

    private void __constructor__(String string2, PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface, boolean bl, int n) {
        this.$$robo$$com_android_internal_telephony_PhoneBase$__constructor__(string2, phoneNotifier, context, commandsInterface, bl, n);
    }

    protected PhoneBase(String string2, PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface, boolean bl, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneBase$__constructor__(java.lang.String com.android.internal.telephony.PhoneNotifier android.content.Context com.android.internal.telephony.CommandsInterface boolean int ), 0, this, string2, phoneNotifier, context, commandsInterface, bl, n);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_PhoneBase$dispose(), 0, this);
    }

    @Override
    public void removeReferences() {
        InvokeDynamicSupport.bootstrap("removeReferences", $$robo$$com_android_internal_telephony_PhoneBase$removeReferences(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_PhoneBase$handleMessage(android.os.Message ), 0, this, message);
    }

    private void handleSrvccStateChanged(int[] nArray) {
        InvokeDynamicSupport.bootstrap("handleSrvccStateChanged", $$robo$$com_android_internal_telephony_PhoneBase$handleSrvccStateChanged(int[] ), 0, this, nArray);
    }

    @Override
    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$com_android_internal_telephony_PhoneBase$getContext(), 0, this);
    }

    @Override
    public void disableDnsCheck(boolean bl) {
        InvokeDynamicSupport.bootstrap("disableDnsCheck", $$robo$$com_android_internal_telephony_PhoneBase$disableDnsCheck(boolean ), 0, this, bl);
    }

    @Override
    public boolean isDnsCheckDisabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDnsCheckDisabled", $$robo$$com_android_internal_telephony_PhoneBase$isDnsCheckDisabled(), 0, this);
    }

    @Override
    public void registerForPreciseCallStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForPreciseCallStateChanged", $$robo$$com_android_internal_telephony_PhoneBase$registerForPreciseCallStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForPreciseCallStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForPreciseCallStateChanged", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForPreciseCallStateChanged(android.os.Handler ), 0, this, handler);
    }

    protected void notifyPreciseCallStateChangedP() {
        InvokeDynamicSupport.bootstrap("notifyPreciseCallStateChangedP", $$robo$$com_android_internal_telephony_PhoneBase$notifyPreciseCallStateChangedP(), 0, this);
    }

    @Override
    public void registerForHandoverStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForHandoverStateChanged", $$robo$$com_android_internal_telephony_PhoneBase$registerForHandoverStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForHandoverStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForHandoverStateChanged", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForHandoverStateChanged(android.os.Handler ), 0, this, handler);
    }

    public void notifyHandoverStateChanged(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyHandoverStateChanged", $$robo$$com_android_internal_telephony_PhoneBase$notifyHandoverStateChanged(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    public void migrateFrom(PhoneBase phoneBase) {
        InvokeDynamicSupport.bootstrap("migrateFrom", $$robo$$com_android_internal_telephony_PhoneBase$migrateFrom(com.android.internal.telephony.PhoneBase ), 0, this, phoneBase);
    }

    public void migrate(RegistrantList registrantList, RegistrantList registrantList2) {
        InvokeDynamicSupport.bootstrap("migrate", $$robo$$com_android_internal_telephony_PhoneBase$migrate(android.os.RegistrantList android.os.RegistrantList ), 0, this, registrantList, registrantList2);
    }

    @Override
    public void registerForUnknownConnection(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForUnknownConnection", $$robo$$com_android_internal_telephony_PhoneBase$registerForUnknownConnection(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForUnknownConnection(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForUnknownConnection", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForUnknownConnection(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForNewRingingConnection(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNewRingingConnection", $$robo$$com_android_internal_telephony_PhoneBase$registerForNewRingingConnection(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForNewRingingConnection(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNewRingingConnection", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForNewRingingConnection(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForInCallVoicePrivacyOn(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForInCallVoicePrivacyOn", $$robo$$com_android_internal_telephony_PhoneBase$registerForInCallVoicePrivacyOn(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOn(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForInCallVoicePrivacyOn", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForInCallVoicePrivacyOn(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForInCallVoicePrivacyOff(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForInCallVoicePrivacyOff", $$robo$$com_android_internal_telephony_PhoneBase$registerForInCallVoicePrivacyOff(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOff(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForInCallVoicePrivacyOff", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForInCallVoicePrivacyOff(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForIncomingRing(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForIncomingRing", $$robo$$com_android_internal_telephony_PhoneBase$registerForIncomingRing(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForIncomingRing(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForIncomingRing", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForIncomingRing(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForDisconnect(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDisconnect", $$robo$$com_android_internal_telephony_PhoneBase$registerForDisconnect(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForDisconnect(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDisconnect", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForDisconnect(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSuppServiceFailed(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSuppServiceFailed", $$robo$$com_android_internal_telephony_PhoneBase$registerForSuppServiceFailed(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSuppServiceFailed(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSuppServiceFailed", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForSuppServiceFailed(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForMmiInitiate(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForMmiInitiate", $$robo$$com_android_internal_telephony_PhoneBase$registerForMmiInitiate(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForMmiInitiate(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForMmiInitiate", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForMmiInitiate(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForMmiComplete(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForMmiComplete", $$robo$$com_android_internal_telephony_PhoneBase$registerForMmiComplete(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForMmiComplete(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForMmiComplete", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForMmiComplete(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSimRecordsLoaded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSimRecordsLoaded", $$robo$$com_android_internal_telephony_PhoneBase$registerForSimRecordsLoaded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSimRecordsLoaded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSimRecordsLoaded", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForSimRecordsLoaded(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeAutomatic", $$robo$$com_android_internal_telephony_PhoneBase$setNetworkSelectionModeAutomatic(android.os.Message ), 0, this, message);
    }

    @Override
    public void selectNetworkManually(OperatorInfo operatorInfo, Message message) {
        InvokeDynamicSupport.bootstrap("selectNetworkManually", $$robo$$com_android_internal_telephony_PhoneBase$selectNetworkManually(com.android.internal.telephony.OperatorInfo android.os.Message ), 0, this, operatorInfo, message);
    }

    private void handleSetSelectNetwork(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleSetSelectNetwork", $$robo$$com_android_internal_telephony_PhoneBase$handleSetSelectNetwork(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private String getSavedNetworkSelection() {
        return InvokeDynamicSupport.bootstrap("getSavedNetworkSelection", $$robo$$com_android_internal_telephony_PhoneBase$getSavedNetworkSelection(), 0, this);
    }

    public void restoreSavedNetworkSelection(Message message) {
        InvokeDynamicSupport.bootstrap("restoreSavedNetworkSelection", $$robo$$com_android_internal_telephony_PhoneBase$restoreSavedNetworkSelection(android.os.Message ), 0, this, message);
    }

    @Override
    public void setUnitTestMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUnitTestMode", $$robo$$com_android_internal_telephony_PhoneBase$setUnitTestMode(boolean ), 0, this, bl);
    }

    @Override
    public boolean getUnitTestMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("getUnitTestMode", $$robo$$com_android_internal_telephony_PhoneBase$getUnitTestMode(), 0, this);
    }

    protected void notifyDisconnectP(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyDisconnectP", $$robo$$com_android_internal_telephony_PhoneBase$notifyDisconnectP(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    @Override
    public void registerForServiceStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForServiceStateChanged", $$robo$$com_android_internal_telephony_PhoneBase$registerForServiceStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForServiceStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForServiceStateChanged", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForServiceStateChanged(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForRingbackTone(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRingbackTone", $$robo$$com_android_internal_telephony_PhoneBase$registerForRingbackTone(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForRingbackTone(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRingbackTone", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForRingbackTone(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForOnHoldTone(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForOnHoldTone", $$robo$$com_android_internal_telephony_PhoneBase$registerForOnHoldTone(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForOnHoldTone(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForOnHoldTone", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForOnHoldTone(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForResendIncallMute(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForResendIncallMute", $$robo$$com_android_internal_telephony_PhoneBase$registerForResendIncallMute(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForResendIncallMute(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForResendIncallMute", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForResendIncallMute(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void setEchoSuppressionEnabled() {
        InvokeDynamicSupport.bootstrap("setEchoSuppressionEnabled", $$robo$$com_android_internal_telephony_PhoneBase$setEchoSuppressionEnabled(), 0, this);
    }

    protected void notifyServiceStateChangedP(ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("notifyServiceStateChangedP", $$robo$$com_android_internal_telephony_PhoneBase$notifyServiceStateChangedP(android.telephony.ServiceState ), 0, this, serviceState);
    }

    @Override
    public SimulatedRadioControl getSimulatedRadioControl() {
        return InvokeDynamicSupport.bootstrap("getSimulatedRadioControl", $$robo$$com_android_internal_telephony_PhoneBase$getSimulatedRadioControl(), 0, this);
    }

    private void checkCorrectThread(Handler handler) {
        InvokeDynamicSupport.bootstrap("checkCorrectThread", $$robo$$com_android_internal_telephony_PhoneBase$checkCorrectThread(android.os.Handler ), 0, this, handler);
    }

    private void setPropertiesByCarrier() {
        InvokeDynamicSupport.bootstrap("setPropertiesByCarrier", $$robo$$com_android_internal_telephony_PhoneBase$setPropertiesByCarrier(), 0, this);
    }

    public IccFileHandler getIccFileHandler() {
        return InvokeDynamicSupport.bootstrap("getIccFileHandler", $$robo$$com_android_internal_telephony_PhoneBase$getIccFileHandler(), 0, this);
    }

    public Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$com_android_internal_telephony_PhoneBase$getHandler(), 0, this);
    }

    @Override
    public void updatePhoneObject(int n) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_PhoneBase$updatePhoneObject(int ), 0, this, n);
    }

    public ServiceStateTracker getServiceStateTracker() {
        return InvokeDynamicSupport.bootstrap("getServiceStateTracker", $$robo$$com_android_internal_telephony_PhoneBase$getServiceStateTracker(), 0, this);
    }

    public CallTracker getCallTracker() {
        return InvokeDynamicSupport.bootstrap("getCallTracker", $$robo$$com_android_internal_telephony_PhoneBase$getCallTracker(), 0, this);
    }

    public IccCardApplicationStatus.AppType getCurrentUiccAppType() {
        return InvokeDynamicSupport.bootstrap("getCurrentUiccAppType", $$robo$$com_android_internal_telephony_PhoneBase$getCurrentUiccAppType(), 0, this);
    }

    @Override
    public IccCard getIccCard() {
        return InvokeDynamicSupport.bootstrap("getIccCard", $$robo$$com_android_internal_telephony_PhoneBase$getIccCard(), 0, this);
    }

    @Override
    public String getIccSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getIccSerialNumber", $$robo$$com_android_internal_telephony_PhoneBase$getIccSerialNumber(), 0, this);
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccRecordsLoaded", $$robo$$com_android_internal_telephony_PhoneBase$getIccRecordsLoaded(), 0, this);
    }

    @Override
    public List<CellInfo> getAllCellInfo() {
        return InvokeDynamicSupport.bootstrap("getAllCellInfo", $$robo$$com_android_internal_telephony_PhoneBase$getAllCellInfo(), 0, this);
    }

    private List<CellInfo> privatizeCellInfoList(List<CellInfo> list) {
        return InvokeDynamicSupport.bootstrap("privatizeCellInfoList", $$robo$$com_android_internal_telephony_PhoneBase$privatizeCellInfoList(java.util.List<android.telephony.CellInfo> ), 0, this, list);
    }

    @Override
    public void setCellInfoListRate(int n) {
        InvokeDynamicSupport.bootstrap("setCellInfoListRate", $$robo$$com_android_internal_telephony_PhoneBase$setCellInfoListRate(int ), 0, this, n);
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMessageWaitingIndicator", $$robo$$com_android_internal_telephony_PhoneBase$getMessageWaitingIndicator(), 0, this);
    }

    @Override
    public boolean getCallForwardingIndicator() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCallForwardingIndicator", $$robo$$com_android_internal_telephony_PhoneBase$getCallForwardingIndicator(), 0, this);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        InvokeDynamicSupport.bootstrap("queryCdmaRoamingPreference", $$robo$$com_android_internal_telephony_PhoneBase$queryCdmaRoamingPreference(android.os.Message ), 0, this, message);
    }

    @Override
    public SignalStrength getSignalStrength() {
        return InvokeDynamicSupport.bootstrap("getSignalStrength", $$robo$$com_android_internal_telephony_PhoneBase$getSignalStrength(), 0, this);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaRoamingPreference", $$robo$$com_android_internal_telephony_PhoneBase$setCdmaRoamingPreference(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setCdmaSubscription(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaSubscription", $$robo$$com_android_internal_telephony_PhoneBase$setCdmaSubscription(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setPreferredNetworkType", $$robo$$com_android_internal_telephony_PhoneBase$setPreferredNetworkType(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getPreferredNetworkType(Message message) {
        InvokeDynamicSupport.bootstrap("getPreferredNetworkType", $$robo$$com_android_internal_telephony_PhoneBase$getPreferredNetworkType(android.os.Message ), 0, this, message);
    }

    @Override
    public void getSmscAddress(Message message) {
        InvokeDynamicSupport.bootstrap("getSmscAddress", $$robo$$com_android_internal_telephony_PhoneBase$getSmscAddress(android.os.Message ), 0, this, message);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setSmscAddress", $$robo$$com_android_internal_telephony_PhoneBase$setSmscAddress(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setTTYMode", $$robo$$com_android_internal_telephony_PhoneBase$setTTYMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void queryTTYMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryTTYMode", $$robo$$com_android_internal_telephony_PhoneBase$queryTTYMode(android.os.Message ), 0, this, message);
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("enableEnhancedVoicePrivacy", $$robo$$com_android_internal_telephony_PhoneBase$enableEnhancedVoicePrivacy(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getEnhancedVoicePrivacy(Message message) {
        InvokeDynamicSupport.bootstrap("getEnhancedVoicePrivacy", $$robo$$com_android_internal_telephony_PhoneBase$getEnhancedVoicePrivacy(android.os.Message ), 0, this, message);
    }

    @Override
    public void setBandMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setBandMode", $$robo$$com_android_internal_telephony_PhoneBase$setBandMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryAvailableBandMode", $$robo$$com_android_internal_telephony_PhoneBase$queryAvailableBandMode(android.os.Message ), 0, this, message);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestRaw", $$robo$$com_android_internal_telephony_PhoneBase$invokeOemRilRequestRaw(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestStrings", $$robo$$com_android_internal_telephony_PhoneBase$invokeOemRilRequestStrings(java.lang.String[] android.os.Message ), 0, this, stringArray, message);
    }

    @Override
    public void nvReadItem(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvReadItem", $$robo$$com_android_internal_telephony_PhoneBase$nvReadItem(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void nvWriteItem(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteItem", $$robo$$com_android_internal_telephony_PhoneBase$nvWriteItem(int java.lang.String android.os.Message ), 0, this, n, string2, message);
    }

    @Override
    public void nvWriteCdmaPrl(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteCdmaPrl", $$robo$$com_android_internal_telephony_PhoneBase$nvWriteCdmaPrl(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Override
    public void nvResetConfig(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvResetConfig", $$robo$$com_android_internal_telephony_PhoneBase$nvResetConfig(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void notifyDataActivity() {
        InvokeDynamicSupport.bootstrap("notifyDataActivity", $$robo$$com_android_internal_telephony_PhoneBase$notifyDataActivity(), 0, this);
    }

    public void notifyMessageWaitingIndicator() {
        InvokeDynamicSupport.bootstrap("notifyMessageWaitingIndicator", $$robo$$com_android_internal_telephony_PhoneBase$notifyMessageWaitingIndicator(), 0, this);
    }

    public void notifyDataConnection(String string2, String string3, PhoneConstants.DataState dataState) {
        InvokeDynamicSupport.bootstrap("notifyDataConnection", $$robo$$com_android_internal_telephony_PhoneBase$notifyDataConnection(java.lang.String java.lang.String com.android.internal.telephony.PhoneConstants$DataState ), 0, this, string2, string3, dataState);
    }

    public void notifyDataConnection(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("notifyDataConnection", $$robo$$com_android_internal_telephony_PhoneBase$notifyDataConnection(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void notifyDataConnection(String string2) {
        InvokeDynamicSupport.bootstrap("notifyDataConnection", $$robo$$com_android_internal_telephony_PhoneBase$notifyDataConnection(java.lang.String ), 0, this, string2);
    }

    public void notifyOtaspChanged(int n) {
        InvokeDynamicSupport.bootstrap("notifyOtaspChanged", $$robo$$com_android_internal_telephony_PhoneBase$notifyOtaspChanged(int ), 0, this, n);
    }

    public void notifySignalStrength() {
        InvokeDynamicSupport.bootstrap("notifySignalStrength", $$robo$$com_android_internal_telephony_PhoneBase$notifySignalStrength(), 0, this);
    }

    public void notifyCellInfo(List<CellInfo> list) {
        InvokeDynamicSupport.bootstrap("notifyCellInfo", $$robo$$com_android_internal_telephony_PhoneBase$notifyCellInfo(java.util.List<android.telephony.CellInfo> ), 0, this, list);
    }

    public void notifyDataConnectionRealTimeInfo(DataConnectionRealTimeInfo dataConnectionRealTimeInfo) {
        InvokeDynamicSupport.bootstrap("notifyDataConnectionRealTimeInfo", $$robo$$com_android_internal_telephony_PhoneBase$notifyDataConnectionRealTimeInfo(android.telephony.DataConnectionRealTimeInfo ), 0, this, dataConnectionRealTimeInfo);
    }

    public void notifyVoLteServiceStateChanged(VoLteServiceState voLteServiceState) {
        InvokeDynamicSupport.bootstrap("notifyVoLteServiceStateChanged", $$robo$$com_android_internal_telephony_PhoneBase$notifyVoLteServiceStateChanged(android.telephony.VoLteServiceState ), 0, this, voLteServiceState);
    }

    public boolean isInEmergencyCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEmergencyCall", $$robo$$com_android_internal_telephony_PhoneBase$isInEmergencyCall(), 0, this);
    }

    public boolean isInEcm() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEcm", $$robo$$com_android_internal_telephony_PhoneBase$isInEcm(), 0, this);
    }

    @Override
    public int getVoiceMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$com_android_internal_telephony_PhoneBase$getVoiceMessageCount(), 0, this);
    }

    @Override
    public int getCdmaEriIconIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$com_android_internal_telephony_PhoneBase$getCdmaEriIconIndex(), 0, this);
    }

    @Override
    public int getCdmaEriIconMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$com_android_internal_telephony_PhoneBase$getCdmaEriIconMode(), 0, this);
    }

    @Override
    public String getCdmaEriText() {
        return InvokeDynamicSupport.bootstrap("getCdmaEriText", $$robo$$com_android_internal_telephony_PhoneBase$getCdmaEriText(), 0, this);
    }

    @Override
    public String getCdmaMin() {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$com_android_internal_telephony_PhoneBase$getCdmaMin(), 0, this);
    }

    @Override
    public boolean isMinInfoReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMinInfoReady", $$robo$$com_android_internal_telephony_PhoneBase$isMinInfoReady(), 0, this);
    }

    @Override
    public String getCdmaPrlVersion() {
        return InvokeDynamicSupport.bootstrap("getCdmaPrlVersion", $$robo$$com_android_internal_telephony_PhoneBase$getCdmaPrlVersion(), 0, this);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_PhoneBase$sendBurstDtmf(java.lang.String int int android.os.Message ), 0, this, string2, n, n2, message);
    }

    @Override
    public void exitEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_PhoneBase$exitEmergencyCallbackMode(), 0, this);
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_PhoneBase$registerForCdmaOtaStatusChange(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForCdmaOtaStatusChange(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_PhoneBase$registerForSubscriptionInfoReady(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForSubscriptionInfoReady(android.os.Handler ), 0, this, handler);
    }

    @Override
    public boolean needsOtaServiceProvisioning() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsOtaServiceProvisioning", $$robo$$com_android_internal_telephony_PhoneBase$needsOtaServiceProvisioning(), 0, this);
    }

    @Override
    public boolean isOtaSpNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOtaSpNumber", $$robo$$com_android_internal_telephony_PhoneBase$isOtaSpNumber(java.lang.String ), 0, this, string2);
    }

    @Override
    public void registerForCallWaiting(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCallWaiting", $$robo$$com_android_internal_telephony_PhoneBase$registerForCallWaiting(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForCallWaiting(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCallWaiting", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForCallWaiting(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEcmTimerReset", $$robo$$com_android_internal_telephony_PhoneBase$registerForEcmTimerReset(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEcmTimerReset", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForEcmTimerReset(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSignalInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSignalInfo", $$robo$$com_android_internal_telephony_PhoneBase$registerForSignalInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSignalInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSignalInfo", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForSignalInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForDisplayInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDisplayInfo", $$robo$$com_android_internal_telephony_PhoneBase$registerForDisplayInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForDisplayInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDisplayInfo", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForDisplayInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForNumberInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNumberInfo", $$robo$$com_android_internal_telephony_PhoneBase$registerForNumberInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForNumberInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNumberInfo", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForNumberInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForRedirectedNumberInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRedirectedNumberInfo", $$robo$$com_android_internal_telephony_PhoneBase$registerForRedirectedNumberInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForRedirectedNumberInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRedirectedNumberInfo", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForRedirectedNumberInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForLineControlInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForLineControlInfo", $$robo$$com_android_internal_telephony_PhoneBase$registerForLineControlInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForLineControlInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForLineControlInfo", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForLineControlInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerFoT53ClirlInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerFoT53ClirlInfo", $$robo$$com_android_internal_telephony_PhoneBase$registerFoT53ClirlInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForT53ClirInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForT53ClirInfo", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForT53ClirInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForT53AudioControlInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForT53AudioControlInfo", $$robo$$com_android_internal_telephony_PhoneBase$registerForT53AudioControlInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForT53AudioControlInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForT53AudioControlInfo", $$robo$$com_android_internal_telephony_PhoneBase$unregisterForT53AudioControlInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_PhoneBase$setOnEcbModeExitResponse(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler handler) {
        InvokeDynamicSupport.bootstrap("unsetOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_PhoneBase$unsetOnEcbModeExitResponse(android.os.Handler ), 0, this, handler);
    }

    @Override
    public String[] getActiveApnTypes() {
        return InvokeDynamicSupport.bootstrap("getActiveApnTypes", $$robo$$com_android_internal_telephony_PhoneBase$getActiveApnTypes(), 0, this);
    }

    @Override
    public String getActiveApnHost(String string2) {
        return InvokeDynamicSupport.bootstrap("getActiveApnHost", $$robo$$com_android_internal_telephony_PhoneBase$getActiveApnHost(java.lang.String ), 0, this, string2);
    }

    @Override
    public LinkProperties getLinkProperties(String string2) {
        return InvokeDynamicSupport.bootstrap("getLinkProperties", $$robo$$com_android_internal_telephony_PhoneBase$getLinkProperties(java.lang.String ), 0, this, string2);
    }

    @Override
    public NetworkCapabilities getNetworkCapabilities(String string2) {
        return InvokeDynamicSupport.bootstrap("getNetworkCapabilities", $$robo$$com_android_internal_telephony_PhoneBase$getNetworkCapabilities(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isDataConnectivityPossible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataConnectivityPossible", $$robo$$com_android_internal_telephony_PhoneBase$isDataConnectivityPossible(), 0, this);
    }

    @Override
    public boolean isDataConnectivityPossible(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataConnectivityPossible", $$robo$$com_android_internal_telephony_PhoneBase$isDataConnectivityPossible(java.lang.String ), 0, this, string2);
    }

    public void notifyNewRingingConnectionP(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyNewRingingConnectionP", $$robo$$com_android_internal_telephony_PhoneBase$notifyNewRingingConnectionP(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    private void notifyIncomingRing() {
        InvokeDynamicSupport.bootstrap("notifyIncomingRing", $$robo$$com_android_internal_telephony_PhoneBase$notifyIncomingRing(), 0, this);
    }

    private void sendIncomingCallRingNotification(int n) {
        InvokeDynamicSupport.bootstrap("sendIncomingCallRingNotification", $$robo$$com_android_internal_telephony_PhoneBase$sendIncomingCallRingNotification(int ), 0, this, n);
    }

    @Override
    public boolean isCspPlmnEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCspPlmnEnabled", $$robo$$com_android_internal_telephony_PhoneBase$isCspPlmnEnabled(), 0, this);
    }

    @Override
    public IsimRecords getIsimRecords() {
        return InvokeDynamicSupport.bootstrap("getIsimRecords", $$robo$$com_android_internal_telephony_PhoneBase$getIsimRecords(), 0, this);
    }

    @Override
    public String getMsisdn() {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$com_android_internal_telephony_PhoneBase$getMsisdn(), 0, this);
    }

    private static void logUnexpectedCdmaMethodCall(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logUnexpectedCdmaMethodCall", $$robo$$com_android_internal_telephony_PhoneBase$logUnexpectedCdmaMethodCall(java.lang.String ), 0, (String)string2);
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState() {
        return InvokeDynamicSupport.bootstrap("getDataConnectionState", $$robo$$com_android_internal_telephony_PhoneBase$getDataConnectionState(), 0, this);
    }

    private static void logUnexpectedGsmMethodCall(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logUnexpectedGsmMethodCall", $$robo$$com_android_internal_telephony_PhoneBase$logUnexpectedGsmMethodCall(java.lang.String ), 0, (String)string2);
    }

    public void notifyCallForwardingIndicator() {
        InvokeDynamicSupport.bootstrap("notifyCallForwardingIndicator", $$robo$$com_android_internal_telephony_PhoneBase$notifyCallForwardingIndicator(), 0, this);
    }

    public void notifyDataConnectionFailed(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("notifyDataConnectionFailed", $$robo$$com_android_internal_telephony_PhoneBase$notifyDataConnectionFailed(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void notifyPreciseDataConnectionFailed(String string2, String string3, String string4, String string5) {
        InvokeDynamicSupport.bootstrap("notifyPreciseDataConnectionFailed", $$robo$$com_android_internal_telephony_PhoneBase$notifyPreciseDataConnectionFailed(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4, string5);
    }

    @Override
    public int getLteOnCdmaMode() {
        return (int)InvokeDynamicSupport.bootstrap("getLteOnCdmaMode", $$robo$$com_android_internal_telephony_PhoneBase$getLteOnCdmaMode(), 0, this);
    }

    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVoiceMessageWaiting", $$robo$$com_android_internal_telephony_PhoneBase$setVoiceMessageWaiting(int int ), 0, this, n, n2);
    }

    @Override
    public UsimServiceTable getUsimServiceTable() {
        return InvokeDynamicSupport.bootstrap("getUsimServiceTable", $$robo$$com_android_internal_telephony_PhoneBase$getUsimServiceTable(), 0, this);
    }

    @Override
    public UiccCard getUiccCard() {
        return InvokeDynamicSupport.bootstrap("getUiccCard", $$robo$$com_android_internal_telephony_PhoneBase$getUiccCard(), 0, this);
    }

    @Override
    public String[] getPcscfAddress(String string2) {
        return InvokeDynamicSupport.bootstrap("getPcscfAddress", $$robo$$com_android_internal_telephony_PhoneBase$getPcscfAddress(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setImsRegistrationState(boolean bl) {
        InvokeDynamicSupport.bootstrap("setImsRegistrationState", $$robo$$com_android_internal_telephony_PhoneBase$setImsRegistrationState(boolean ), 0, this, bl);
    }

    @Override
    public Phone getImsPhone() {
        return InvokeDynamicSupport.bootstrap("getImsPhone", $$robo$$com_android_internal_telephony_PhoneBase$getImsPhone(), 0, this);
    }

    @Override
    public ImsPhone relinquishOwnershipOfImsPhone() {
        return InvokeDynamicSupport.bootstrap("relinquishOwnershipOfImsPhone", $$robo$$com_android_internal_telephony_PhoneBase$relinquishOwnershipOfImsPhone(), 0, this);
    }

    @Override
    public void acquireOwnershipOfImsPhone(ImsPhone imsPhone) {
        InvokeDynamicSupport.bootstrap("acquireOwnershipOfImsPhone", $$robo$$com_android_internal_telephony_PhoneBase$acquireOwnershipOfImsPhone(com.android.internal.telephony.imsphone.ImsPhone ), 0, this, imsPhone);
    }

    protected void updateImsPhone() {
        InvokeDynamicSupport.bootstrap("updateImsPhone", $$robo$$com_android_internal_telephony_PhoneBase$updateImsPhone(), 0, this);
    }

    protected Connection dialInternal(String string2, UUSInfo uUSInfo, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_PhoneBase$dialInternal(java.lang.String com.android.internal.telephony.UUSInfo int ), 0, this, string2, uUSInfo, n);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_PhoneBase$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public long getSubId() {
        return (long)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$com_android_internal_telephony_PhoneBase$getSubId(), 0, this);
    }

    @Override
    public int getPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$com_android_internal_telephony_PhoneBase$getPhoneId(), 0, this);
    }

    public Subscription getSubscriptionInfo() {
        return InvokeDynamicSupport.bootstrap("getSubscriptionInfo", $$robo$$com_android_internal_telephony_PhoneBase$getSubscriptionInfo(), 0, this);
    }

    @Override
    public int getVoicePhoneServiceState() {
        return (int)InvokeDynamicSupport.bootstrap("getVoicePhoneServiceState", $$robo$$com_android_internal_telephony_PhoneBase$getVoicePhoneServiceState(), 0, this);
    }

    @Override
    public boolean setOperatorBrandOverride(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$com_android_internal_telephony_PhoneBase$setOperatorBrandOverride(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isRadioAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRadioAvailable", $$robo$$com_android_internal_telephony_PhoneBase$isRadioAvailable(), 0, this);
    }

    @Override
    public void shutdownRadio() {
        InvokeDynamicSupport.bootstrap("shutdownRadio", $$robo$$com_android_internal_telephony_PhoneBase$shutdownRadio(), 0, this);
    }

    public /* synthetic */ PhoneBase() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneBase)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    protected static class NetworkSelectMessage
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Message message;
        public String operatorNumeric;
        public String operatorAlphaLong;

        private void $$robo$$com_android_internal_telephony_PhoneBase_NetworkSelectMessage$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_PhoneBase_NetworkSelectMessage$__constructor__();
        }

        protected NetworkSelectMessage() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneBase_NetworkSelectMessage$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkSelectMessage)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

