/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.LocalServerSocket;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DefaultPhoneNotifier;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.ProxyController;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SubInfoRecordUpdater;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyDevController;
import com.android.internal.telephony.cdma.CDMALTEPhone;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneFactory;
import com.android.internal.telephony.sip.SipPhone;
import com.android.internal.telephony.sip.SipPhoneFactory;
import com.android.internal.telephony.uicc.UiccController;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PhoneFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "PhoneFactory";
    static int SOCKET_OPEN_RETRY_MILLIS = 2000;
    static int SOCKET_OPEN_MAX_RETRY = 3;
    static Object sLockProxyPhones;
    private static PhoneProxy[] sProxyPhones;
    private static PhoneProxy sProxyPhone;
    private static CommandsInterface[] sCommandsInterfaces;
    private static ProxyController mProxyController;
    private static UiccController mUiccController;
    private static CommandsInterface sCommandsInterface;
    private static SubInfoRecordUpdater sSubInfoRecordUpdater;
    private static boolean sMadeDefaults;
    private static PhoneNotifier sPhoneNotifier;
    private static Context sContext;

    private void $$robo$$com_android_internal_telephony_PhoneFactory$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$makeDefaultPhones(Context context) {
        PhoneFactory.makeDefaultPhone(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$makeDefaultPhone(Context context) {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                int i;
                sContext = context;
                TelephonyDevController.create();
                int retryCount = 0;
                while (true) {
                    boolean hasException = false;
                    ++retryCount;
                    try {
                        new LocalServerSocket("com.android.internal.telephony");
                    }
                    catch (IOException ex) {
                        hasException = true;
                    }
                    if (!hasException) break;
                    if (retryCount > 3) {
                        throw new RuntimeException("PhoneFactory probably already running");
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {}
                }
                sPhoneNotifier = new DefaultPhoneNotifier();
                int preferredNetworkMode = 0;
                if (TelephonyManager.getLteOnCdmaModeStatic() == 1) {
                    preferredNetworkMode = 7;
                }
                int cdmaSubscription = CdmaSubscriptionSourceManager.getDefault(context);
                Rlog.i("PhoneFactory", "Cdma Subscription set to " + cdmaSubscription);
                int numPhones = TelephonyManager.getDefault().getPhoneCount();
                int[] networkModes = new int[numPhones];
                sProxyPhones = new PhoneProxy[numPhones];
                sCommandsInterfaces = new RIL[numPhones];
                for (i = 0; i < numPhones; ++i) {
                    try {
                        networkModes[i] = TelephonyManager.getIntAtIndex(context.getContentResolver(), "preferred_network_mode", i);
                    }
                    catch (Settings.SettingNotFoundException snfe) {
                        Rlog.e("PhoneFactory", "Settings Exception Reading Value At Index for Settings.Global.PREFERRED_NETWORK_MODE");
                        networkModes[i] = preferredNetworkMode;
                    }
                    Rlog.i("PhoneFactory", "Network Mode set to " + Integer.toString(networkModes[i]));
                    PhoneFactory.sCommandsInterfaces[i] = new RIL(context, networkModes[i], cdmaSubscription, i);
                }
                Rlog.i("PhoneFactory", "Creating SubscriptionController");
                SubscriptionController.init(context, sCommandsInterfaces);
                mUiccController = UiccController.make(context, sCommandsInterfaces);
                for (i = 0; i < numPhones; ++i) {
                    PhoneBase phone = null;
                    int phoneType = TelephonyManager.getPhoneType(networkModes[i]);
                    if (phoneType == 1) {
                        phone = new GSMPhone(context, sCommandsInterfaces[i], sPhoneNotifier, i);
                    } else if (phoneType == 2) {
                        phone = new CDMALTEPhone(context, sCommandsInterfaces[i], sPhoneNotifier, i);
                    }
                    Rlog.i("PhoneFactory", "Creating Phone with type = " + phoneType + " sub = " + i);
                    PhoneFactory.sProxyPhones[i] = new PhoneProxy(phone);
                }
                mProxyController = ProxyController.getInstance(context, sProxyPhones, mUiccController, sCommandsInterfaces);
                sProxyPhone = sProxyPhones[0];
                sCommandsInterface = sCommandsInterfaces[0];
                ComponentName componentName = SmsApplication.getDefaultSmsApplication(context, true);
                String packageName = "NONE";
                if (componentName != null) {
                    packageName = componentName.getPackageName();
                }
                Rlog.i("PhoneFactory", "defaultSmsApplication: " + packageName);
                SmsApplication.initSmsPackageMonitor(context);
                sMadeDefaults = true;
                Rlog.i("PhoneFactory", "Creating SubInfoRecordUpdater ");
                sSubInfoRecordUpdater = new SubInfoRecordUpdater(context, sProxyPhones, sCommandsInterfaces);
                SubscriptionController.getInstance().updatePhonesAvailability(sProxyPhones);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Phone $$robo$$com_android_internal_telephony_PhoneFactory$getCdmaPhone(int phoneId) {
        CDMALTEPhone phone;
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            phone = new CDMALTEPhone(sContext, sCommandsInterfaces[phoneId], sPhoneNotifier, phoneId);
        }
        return phone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Phone $$robo$$com_android_internal_telephony_PhoneFactory$getGsmPhone(int phoneId) {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            GSMPhone phone = new GSMPhone(sContext, sCommandsInterfaces[phoneId], sPhoneNotifier, phoneId);
            return phone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Phone $$robo$$com_android_internal_telephony_PhoneFactory$getDefaultPhone() {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            return sProxyPhone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Phone $$robo$$com_android_internal_telephony_PhoneFactory$getPhone(int phoneId) {
        Object object = sLockProxyPhones;
        synchronized (object) {
            PhoneProxy phone;
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            if (phoneId == Integer.MAX_VALUE) {
                Rlog.d("PhoneFactory", "getPhone: phoneId == DEFAULT_PHONE_ID");
                phone = sProxyPhone;
            } else {
                Rlog.d("PhoneFactory", "getPhone: phoneId != DEFAULT_PHONE_ID");
                phone = phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount() ? sProxyPhones[phoneId] : null;
            }
            Rlog.d("PhoneFactory", "getPhone:- phone=" + phone);
            return phone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Phone[] $$robo$$com_android_internal_telephony_PhoneFactory$getPhones() {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            return sProxyPhones;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Phone $$robo$$com_android_internal_telephony_PhoneFactory$getCdmaPhone() {
        CDMAPhone phone;
        if (!sMadeDefaults) {
            throw new IllegalStateException("Default phones haven't been made yet!");
        }
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            switch (TelephonyManager.getLteOnCdmaModeStatic()) {
                case 1: {
                    phone = new CDMALTEPhone(sContext, sCommandsInterface, sPhoneNotifier);
                    break;
                }
                default: {
                    phone = new CDMAPhone(sContext, sCommandsInterface, sPhoneNotifier);
                }
            }
        }
        return phone;
    }

    private static final Phone $$robo$$com_android_internal_telephony_PhoneFactory$getGsmPhone() {
        int phoneId = SubscriptionController.getInstance().getPhoneId(PhoneFactory.getDefaultSubscription());
        if (phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            phoneId = 0;
        }
        return PhoneFactory.getGsmPhone(phoneId);
    }

    private static final SipPhone $$robo$$com_android_internal_telephony_PhoneFactory$makeSipPhone(String sipUri) {
        return SipPhoneFactory.makePhone(sipUri, sContext, sPhoneNotifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$setDefaultSubscription(int subId) {
        SystemProperties.set("persist.radio.default.sub", Integer.toString(subId));
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (phoneId >= 0 && phoneId < sProxyPhones.length) {
                sProxyPhone = sProxyPhones[phoneId];
                sCommandsInterface = sCommandsInterfaces[phoneId];
                sMadeDefaults = true;
            }
        }
        String defaultMccMnc = TelephonyManager.getDefault().getSimOperator(phoneId);
        Rlog.d("PhoneFactory", "update mccmnc=" + defaultMccMnc);
        MccTable.updateMccMncConfiguration(sContext, defaultMccMnc, false);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x20000000);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId);
        Rlog.d("PhoneFactory", "setDefaultSubscription : " + subId + " Broadcasting Default Subscription Changed...");
        sContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private static final int $$robo$$com_android_internal_telephony_PhoneFactory$calculatePreferredNetworkType(Context context) {
        int preferredNetworkType = 0;
        if (TelephonyManager.getLteOnCdmaModeStatic() == 1) {
            preferredNetworkType = 7;
        }
        int networkType = Settings.Global.getInt(context.getContentResolver(), "preferred_network_mode", preferredNetworkType);
        return networkType;
    }

    private static final long $$robo$$com_android_internal_telephony_PhoneFactory$getDefaultSubscription() {
        return SubscriptionController.getInstance().getDefaultSubId();
    }

    private static final int $$robo$$com_android_internal_telephony_PhoneFactory$getVoiceSubscription() {
        int subId = 0;
        try {
            subId = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_voice_call");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e("PhoneFactory", "Settings Exception Reading Dual Sim Voice Call Values");
        }
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            Rlog.i("PhoneFactory", "Subscription is invalid..." + subId + " Set to 0");
            subId = 0;
            PhoneFactory.setVoiceSubscription(subId);
        }
        return subId;
    }

    private static final boolean $$robo$$com_android_internal_telephony_PhoneFactory$isPromptEnabled() {
        boolean prompt = false;
        int value = 0;
        try {
            value = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_voice_prompt");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e("PhoneFactory", "Settings Exception Reading Dual Sim Voice Prompt Values");
        }
        prompt = value != 0;
        Rlog.d("PhoneFactory", "Prompt option:" + prompt);
        return prompt;
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$setPromptEnabled(boolean enabled) {
        int value = !enabled ? 0 : 1;
        Settings.Global.putInt(sContext.getContentResolver(), "multi_sim_voice_prompt", value);
        Rlog.d("PhoneFactory", "setVoicePromptOption to " + enabled);
    }

    private static final boolean $$robo$$com_android_internal_telephony_PhoneFactory$isSMSPromptEnabled() {
        boolean prompt = false;
        int value = 0;
        try {
            value = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_sms_prompt");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e("PhoneFactory", "Settings Exception Reading Dual Sim SMS Prompt Values");
        }
        prompt = value != 0;
        Rlog.d("PhoneFactory", "SMS Prompt option:" + prompt);
        return prompt;
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$setSMSPromptEnabled(boolean enabled) {
        int value = !enabled ? 0 : 1;
        Settings.Global.putInt(sContext.getContentResolver(), "multi_sim_sms_prompt", value);
        Rlog.d("PhoneFactory", "setSMSPromptOption to " + enabled);
    }

    private static final long $$robo$$com_android_internal_telephony_PhoneFactory$getDataSubscription() {
        long subId = 1L;
        try {
            subId = Settings.Global.getLong(sContext.getContentResolver(), "multi_sim_data_call");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e("PhoneFactory", "Settings Exception Reading Dual Sim Data Call Values");
        }
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            subId = 1L;
            Rlog.i("PhoneFactory", "Subscription is invalid..." + subId + " Set to 0");
            PhoneFactory.setDataSubscription(subId);
        }
        return subId;
    }

    private static final int $$robo$$com_android_internal_telephony_PhoneFactory$getSMSSubscription() {
        int subId = 0;
        try {
            subId = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_sms");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e("PhoneFactory", "Settings Exception Reading Dual Sim SMS Values");
        }
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            Rlog.i("PhoneFactory", "Subscription is invalid..." + subId + " Set to 0");
            subId = 0;
            PhoneFactory.setSMSSubscription(subId);
        }
        return subId;
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$setVoiceSubscription(int subId) {
        Settings.Global.putInt(sContext.getContentResolver(), "multi_sim_voice_call", subId);
        Rlog.d("PhoneFactory", "setVoiceSubscription : " + subId);
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$setDataSubscription(long subId) {
        Settings.Global.putLong(sContext.getContentResolver(), "multi_sim_data_call", subId);
        Rlog.d("PhoneFactory", "setDataSubscription: " + subId);
        boolean enabled = Settings.Global.getInt(sContext.getContentResolver(), "mobile_data" + subId, 0) != 0;
        Settings.Global.putInt(sContext.getContentResolver(), "mobile_data", enabled ? 1 : 0);
        Rlog.d("PhoneFactory", "set mobile_data: " + enabled);
        enabled = Settings.Global.getInt(sContext.getContentResolver(), "data_roaming" + subId, 0) != 0;
        Settings.Global.putInt(sContext.getContentResolver(), "data_roaming", enabled ? 1 : 0);
        Rlog.d("PhoneFactory", "set data_roaming: " + enabled);
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$setSMSSubscription(int subId) {
        Settings.Global.putInt(sContext.getContentResolver(), "multi_sim_sms", subId);
        Intent intent = new Intent("com.android.mms.transaction.SEND_MESSAGE");
        sContext.sendBroadcast(intent);
        Rlog.d("PhoneFactory", "setSMSSubscription : " + subId);
    }

    private static final ImsPhone $$robo$$com_android_internal_telephony_PhoneFactory$makeImsPhone(PhoneNotifier phoneNotifier, Phone defaultPhone) {
        return ImsPhoneFactory.makePhone(sContext, phoneNotifier, defaultPhone);
    }

    static void __staticInitializer__() {
        sLockProxyPhones = new Object();
        sProxyPhones = null;
        sProxyPhone = null;
        sCommandsInterfaces = null;
        sCommandsInterface = null;
        sSubInfoRecordUpdater = null;
        sMadeDefaults = false;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_PhoneFactory$__constructor__();
    }

    public PhoneFactory() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneFactory$__constructor__(), 0, this);
    }

    public static void makeDefaultPhones(Context context) {
        InvokeDynamicSupport.bootstrapStatic("makeDefaultPhones", $$robo$$com_android_internal_telephony_PhoneFactory$makeDefaultPhones(android.content.Context ), 0, (Context)context);
    }

    public static void makeDefaultPhone(Context context) {
        InvokeDynamicSupport.bootstrapStatic("makeDefaultPhone", $$robo$$com_android_internal_telephony_PhoneFactory$makeDefaultPhone(android.content.Context ), 0, (Context)context);
    }

    public static Phone getCdmaPhone(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCdmaPhone", $$robo$$com_android_internal_telephony_PhoneFactory$getCdmaPhone(int ), 0, (int)n);
    }

    public static Phone getGsmPhone(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getGsmPhone", $$robo$$com_android_internal_telephony_PhoneFactory$getGsmPhone(int ), 0, (int)n);
    }

    public static Phone getDefaultPhone() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultPhone", $$robo$$com_android_internal_telephony_PhoneFactory$getDefaultPhone(), 0);
    }

    public static Phone getPhone(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getPhone", $$robo$$com_android_internal_telephony_PhoneFactory$getPhone(int ), 0, (int)n);
    }

    public static Phone[] getPhones() {
        return InvokeDynamicSupport.bootstrapStatic("getPhones", $$robo$$com_android_internal_telephony_PhoneFactory$getPhones(), 0);
    }

    public static Phone getCdmaPhone() {
        return InvokeDynamicSupport.bootstrapStatic("getCdmaPhone", $$robo$$com_android_internal_telephony_PhoneFactory$getCdmaPhone(), 0);
    }

    public static Phone getGsmPhone() {
        return InvokeDynamicSupport.bootstrapStatic("getGsmPhone", $$robo$$com_android_internal_telephony_PhoneFactory$getGsmPhone(), 0);
    }

    public static SipPhone makeSipPhone(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeSipPhone", $$robo$$com_android_internal_telephony_PhoneFactory$makeSipPhone(java.lang.String ), 0, (String)string2);
    }

    public static void setDefaultSubscription(int n) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultSubscription", $$robo$$com_android_internal_telephony_PhoneFactory$setDefaultSubscription(int ), 0, (int)n);
    }

    public static int calculatePreferredNetworkType(Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("calculatePreferredNetworkType", $$robo$$com_android_internal_telephony_PhoneFactory$calculatePreferredNetworkType(android.content.Context ), 0, (Context)context);
    }

    public static long getDefaultSubscription() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDefaultSubscription", $$robo$$com_android_internal_telephony_PhoneFactory$getDefaultSubscription(), 0);
    }

    public static int getVoiceSubscription() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getVoiceSubscription", $$robo$$com_android_internal_telephony_PhoneFactory$getVoiceSubscription(), 0);
    }

    public static boolean isPromptEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPromptEnabled", $$robo$$com_android_internal_telephony_PhoneFactory$isPromptEnabled(), 0);
    }

    public static void setPromptEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setPromptEnabled", $$robo$$com_android_internal_telephony_PhoneFactory$setPromptEnabled(boolean ), 0, (boolean)bl);
    }

    public static boolean isSMSPromptEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSMSPromptEnabled", $$robo$$com_android_internal_telephony_PhoneFactory$isSMSPromptEnabled(), 0);
    }

    public static void setSMSPromptEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setSMSPromptEnabled", $$robo$$com_android_internal_telephony_PhoneFactory$setSMSPromptEnabled(boolean ), 0, (boolean)bl);
    }

    public static long getDataSubscription() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDataSubscription", $$robo$$com_android_internal_telephony_PhoneFactory$getDataSubscription(), 0);
    }

    public static int getSMSSubscription() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSMSSubscription", $$robo$$com_android_internal_telephony_PhoneFactory$getSMSSubscription(), 0);
    }

    public static void setVoiceSubscription(int n) {
        InvokeDynamicSupport.bootstrapStatic("setVoiceSubscription", $$robo$$com_android_internal_telephony_PhoneFactory$setVoiceSubscription(int ), 0, (int)n);
    }

    public static void setDataSubscription(long l) {
        InvokeDynamicSupport.bootstrapStatic("setDataSubscription", $$robo$$com_android_internal_telephony_PhoneFactory$setDataSubscription(long ), 0, (long)l);
    }

    public static void setSMSSubscription(int n) {
        InvokeDynamicSupport.bootstrapStatic("setSMSSubscription", $$robo$$com_android_internal_telephony_PhoneFactory$setSMSSubscription(int ), 0, (int)n);
    }

    public static ImsPhone makeImsPhone(PhoneNotifier phoneNotifier, Phone phone) {
        return InvokeDynamicSupport.bootstrapStatic("makeImsPhone", $$robo$$com_android_internal_telephony_PhoneFactory$makeImsPhone(com.android.internal.telephony.PhoneNotifier com.android.internal.telephony.Phone ), 0, (PhoneNotifier)phoneNotifier, (Phone)phone);
    }

    static {
        RobolectricInternals.classInitializing(PhoneFactory.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

