/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.Intent;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallManager;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccPhoneBookInterfaceManagerProxy;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.PhoneSubInfoProxy;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CDMALTEPhone;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccCardProxy;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UsimServiceTable;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PhoneProxy
extends Handler
implements Phone,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static Object lockForRadioTechnologyChange;
    private Phone mActivePhone;
    private CommandsInterface mCommandsInterface;
    private IccSmsInterfaceManager mIccSmsInterfaceManager;
    private IccPhoneBookInterfaceManagerProxy mIccPhoneBookInterfaceManagerProxy;
    private PhoneSubInfoProxy mPhoneSubInfoProxy;
    private IccCardProxy mIccCardProxy;
    private boolean mResetModemOnRadioTechnologyChange;
    private int mRilVersion;
    private static int EVENT_VOICE_RADIO_TECH_CHANGED = 1;
    private static int EVENT_RADIO_ON = 2;
    private static int EVENT_REQUEST_VOICE_RADIO_TECH_DONE = 3;
    private static int EVENT_RIL_CONNECTED = 4;
    private static int EVENT_UPDATE_PHONE_OBJECT = 5;
    private int mPhoneId;
    private static String LOG_TAG = "PhoneProxy";

    private void $$robo$$com_android_internal_telephony_PhoneProxy$__constructor__(PhoneBase phone) {
        this.mResetModemOnRadioTechnologyChange = false;
        this.mPhoneId = 0;
        this.mActivePhone = phone;
        this.mResetModemOnRadioTechnologyChange = SystemProperties.getBoolean("persist.radio.reset_on_switch", false);
        this.mIccPhoneBookInterfaceManagerProxy = new IccPhoneBookInterfaceManagerProxy(phone.getIccPhoneBookInterfaceManager());
        this.mPhoneSubInfoProxy = new PhoneSubInfoProxy(phone.getPhoneSubInfo());
        this.mCommandsInterface = ((PhoneBase)this.mActivePhone).mCi;
        this.mCommandsInterface.registerForRilConnected(this, 4, null);
        this.mCommandsInterface.registerForOn(this, 2, null);
        this.mCommandsInterface.registerForVoiceRadioTechChanged(this, 1, null);
        this.mPhoneId = phone.getPhoneId();
        this.mIccSmsInterfaceManager = new IccSmsInterfaceManager((PhoneBase)this.mActivePhone);
        this.mIccCardProxy = new IccCardProxy(this.mActivePhone.getContext(), this.mCommandsInterface, this.mActivePhone.getPhoneId());
        if (phone.getPhoneType() == 1) {
            this.mIccCardProxy.setVoiceRadioTech(3);
        } else if (phone.getPhoneType() == 2) {
            this.mIccCardProxy.setVoiceRadioTech(6);
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$handleMessage(Message msg) {
        AsyncResult ar = (AsyncResult)msg.obj;
        switch (msg.what) {
            case 2: {
                this.mCommandsInterface.getVoiceRadioTechnology(this.obtainMessage(3));
                break;
            }
            case 4: {
                if (ar.exception == null && ar.result != null) {
                    this.mRilVersion = (Integer)ar.result;
                    break;
                }
                PhoneProxy.logd("Unexpected exception on EVENT_RIL_CONNECTED");
                this.mRilVersion = -1;
                break;
            }
            case 1: 
            case 3: {
                String what;
                String string2 = what = msg.what == 1 ? "EVENT_VOICE_RADIO_TECH_CHANGED" : "EVENT_REQUEST_VOICE_RADIO_TECH_DONE";
                if (ar.exception == null) {
                    if (ar.result != null && ((int[])ar.result).length != 0) {
                        int newVoiceTech = ((int[])ar.result)[0];
                        PhoneProxy.logd(what + ": newVoiceTech=" + newVoiceTech);
                        this.phoneObjectUpdater(newVoiceTech);
                        break;
                    }
                    this.loge(what + ": has no tech!");
                    break;
                }
                this.loge(what + ": exception=" + ar.exception);
                break;
            }
            case 5: {
                this.phoneObjectUpdater(msg.arg1);
                break;
            }
            default: {
                this.loge("Error! This handler was not registered for this message type. Message: " + msg.what);
            }
        }
        super.handleMessage(msg);
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneProxy$logd(String msg) {
        Rlog.d("PhoneProxy", "[PhoneProxy] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$loge(String msg) {
        Rlog.e("PhoneProxy", "[PhoneProxy] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$phoneObjectUpdater(int newVoiceRadioTech) {
        PhoneProxy.logd("phoneObjectUpdater: newVoiceRadioTech=" + newVoiceRadioTech);
        if (this.mActivePhone != null) {
            if (newVoiceRadioTech == 14 || newVoiceRadioTech == 0) {
                int volteReplacementRat = this.mActivePhone.getContext().getResources().getInteger(17694809);
                PhoneProxy.logd("phoneObjectUpdater: volteReplacementRat=" + volteReplacementRat);
                if (volteReplacementRat != 0) {
                    newVoiceRadioTech = volteReplacementRat;
                }
            }
            if (this.mRilVersion == 6 && this.getLteOnCdmaMode() == 1) {
                if (this.mActivePhone.getPhoneType() == 2) {
                    PhoneProxy.logd("phoneObjectUpdater: LTE ON CDMA property is set. Use CDMA Phone newVoiceRadioTech=" + newVoiceRadioTech + " mActivePhone=" + this.mActivePhone.getPhoneName());
                    return;
                }
                PhoneProxy.logd("phoneObjectUpdater: LTE ON CDMA property is set. Switch to CDMALTEPhone newVoiceRadioTech=" + newVoiceRadioTech + " mActivePhone=" + this.mActivePhone.getPhoneName());
                newVoiceRadioTech = 6;
            } else if (ServiceState.isCdma(newVoiceRadioTech) && this.mActivePhone.getPhoneType() == 2 || ServiceState.isGsm(newVoiceRadioTech) && this.mActivePhone.getPhoneType() == 1) {
                PhoneProxy.logd("phoneObjectUpdater: No change ignore, newVoiceRadioTech=" + newVoiceRadioTech + " mActivePhone=" + this.mActivePhone.getPhoneName());
                return;
            }
        }
        if (newVoiceRadioTech == 0) {
            PhoneProxy.logd("phoneObjectUpdater: Unknown rat ignore,  newVoiceRadioTech=Unknown. mActivePhone=" + this.mActivePhone.getPhoneName());
            return;
        }
        boolean oldPowerState = false;
        if (this.mResetModemOnRadioTechnologyChange && this.mCommandsInterface.getRadioState().isOn()) {
            oldPowerState = true;
            PhoneProxy.logd("phoneObjectUpdater: Setting Radio Power to Off");
            this.mCommandsInterface.setRadioPower(false, null);
        }
        this.deleteAndCreatePhone(newVoiceRadioTech);
        if (this.mResetModemOnRadioTechnologyChange && oldPowerState) {
            PhoneProxy.logd("phoneObjectUpdater: Resetting Radio");
            this.mCommandsInterface.setRadioPower(oldPowerState, null);
        }
        this.mIccSmsInterfaceManager.updatePhoneObject((PhoneBase)this.mActivePhone);
        this.mIccPhoneBookInterfaceManagerProxy.setmIccPhoneBookInterfaceManager(this.mActivePhone.getIccPhoneBookInterfaceManager());
        this.mPhoneSubInfoProxy.setmPhoneSubInfo(this.mActivePhone.getPhoneSubInfo());
        this.mCommandsInterface = ((PhoneBase)this.mActivePhone).mCi;
        this.mIccCardProxy.setVoiceRadioTech(newVoiceRadioTech);
        Intent intent = new Intent("android.intent.action.RADIO_TECHNOLOGY");
        intent.addFlags(0x20000000);
        intent.putExtra("phoneName", this.mActivePhone.getPhoneName());
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhoneId);
        ActivityManagerNative.broadcastStickyIntent(intent, null, -1);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$deleteAndCreatePhone(int newVoiceRadioTech) {
        String outgoingPhoneName = "Unknown";
        Phone oldPhone = this.mActivePhone;
        ImsPhone imsPhone = null;
        if (oldPhone != null) {
            outgoingPhoneName = ((PhoneBase)oldPhone).getPhoneName();
        }
        PhoneProxy.logd("Switching Voice Phone : " + outgoingPhoneName + " >>> " + (ServiceState.isGsm(newVoiceRadioTech) ? "GSM" : "CDMA"));
        if (ServiceState.isCdma(newVoiceRadioTech)) {
            this.mActivePhone = PhoneFactory.getCdmaPhone(this.mPhoneId);
        } else if (ServiceState.isGsm(newVoiceRadioTech)) {
            this.mActivePhone = PhoneFactory.getGsmPhone(this.mPhoneId);
        }
        if (oldPhone != null) {
            imsPhone = oldPhone.relinquishOwnershipOfImsPhone();
        }
        if (this.mActivePhone != null) {
            CallManager.getInstance().registerPhone(this.mActivePhone);
            if (imsPhone != null) {
                this.mActivePhone.acquireOwnershipOfImsPhone(imsPhone);
            }
        }
        if (oldPhone != null) {
            CallManager.getInstance().unregisterPhone(oldPhone);
            PhoneProxy.logd("Disposing old phone..");
            oldPhone.dispose();
        }
        oldPhone = null;
    }

    private final IccSmsInterfaceManager $$robo$$com_android_internal_telephony_PhoneProxy$getIccSmsInterfaceManager() {
        return this.mIccSmsInterfaceManager;
    }

    private final PhoneSubInfoProxy $$robo$$com_android_internal_telephony_PhoneProxy$getPhoneSubInfoProxy() {
        return this.mPhoneSubInfoProxy;
    }

    private final IccPhoneBookInterfaceManagerProxy $$robo$$com_android_internal_telephony_PhoneProxy$getIccPhoneBookInterfaceManagerProxy() {
        return this.mIccPhoneBookInterfaceManagerProxy;
    }

    private final IccFileHandler $$robo$$com_android_internal_telephony_PhoneProxy$getIccFileHandler() {
        return ((PhoneBase)this.mActivePhone).getIccFileHandler();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$updatePhoneObject(int voiceRadioTech) {
        PhoneProxy.logd("updatePhoneObject: radioTechnology=" + voiceRadioTech);
        this.sendMessage(this.obtainMessage(5, voiceRadioTech, 0, null));
    }

    private final ServiceState $$robo$$com_android_internal_telephony_PhoneProxy$getServiceState() {
        return this.mActivePhone.getServiceState();
    }

    private final CellLocation $$robo$$com_android_internal_telephony_PhoneProxy$getCellLocation() {
        return this.mActivePhone.getCellLocation();
    }

    private final List<CellInfo> $$robo$$com_android_internal_telephony_PhoneProxy$getAllCellInfo() {
        return this.mActivePhone.getAllCellInfo();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setCellInfoListRate(int rateInMillis) {
        this.mActivePhone.setCellInfoListRate(rateInMillis);
    }

    private final PhoneConstants.DataState $$robo$$com_android_internal_telephony_PhoneProxy$getDataConnectionState() {
        return this.mActivePhone.getDataConnectionState("default");
    }

    private final PhoneConstants.DataState $$robo$$com_android_internal_telephony_PhoneProxy$getDataConnectionState(String apnType) {
        return this.mActivePhone.getDataConnectionState(apnType);
    }

    private final Phone.DataActivityState $$robo$$com_android_internal_telephony_PhoneProxy$getDataActivityState() {
        return this.mActivePhone.getDataActivityState();
    }

    private final Context $$robo$$com_android_internal_telephony_PhoneProxy$getContext() {
        return this.mActivePhone.getContext();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$disableDnsCheck(boolean b) {
        this.mActivePhone.disableDnsCheck(b);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$isDnsCheckDisabled() {
        return this.mActivePhone.isDnsCheckDisabled();
    }

    private final PhoneConstants.State $$robo$$com_android_internal_telephony_PhoneProxy$getState() {
        return this.mActivePhone.getState();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getPhoneName() {
        return this.mActivePhone.getPhoneName();
    }

    private final int $$robo$$com_android_internal_telephony_PhoneProxy$getPhoneType() {
        return this.mActivePhone.getPhoneType();
    }

    private final String[] $$robo$$com_android_internal_telephony_PhoneProxy$getActiveApnTypes() {
        return this.mActivePhone.getActiveApnTypes();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getActiveApnHost(String apnType) {
        return this.mActivePhone.getActiveApnHost(apnType);
    }

    private final LinkProperties $$robo$$com_android_internal_telephony_PhoneProxy$getLinkProperties(String apnType) {
        return this.mActivePhone.getLinkProperties(apnType);
    }

    private final NetworkCapabilities $$robo$$com_android_internal_telephony_PhoneProxy$getNetworkCapabilities(String apnType) {
        return this.mActivePhone.getNetworkCapabilities(apnType);
    }

    private final SignalStrength $$robo$$com_android_internal_telephony_PhoneProxy$getSignalStrength() {
        return this.mActivePhone.getSignalStrength();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForUnknownConnection(Handler h, int what, Object obj) {
        this.mActivePhone.registerForUnknownConnection(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForUnknownConnection(Handler h) {
        this.mActivePhone.unregisterForUnknownConnection(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForHandoverStateChanged(Handler h, int what, Object obj) {
        this.mActivePhone.registerForHandoverStateChanged(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForHandoverStateChanged(Handler h) {
        this.mActivePhone.unregisterForHandoverStateChanged(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForPreciseCallStateChanged(Handler h, int what, Object obj) {
        this.mActivePhone.registerForPreciseCallStateChanged(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForPreciseCallStateChanged(Handler h) {
        this.mActivePhone.unregisterForPreciseCallStateChanged(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.mActivePhone.registerForNewRingingConnection(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForNewRingingConnection(Handler h) {
        this.mActivePhone.unregisterForNewRingingConnection(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForIncomingRing(Handler h, int what, Object obj) {
        this.mActivePhone.registerForIncomingRing(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForIncomingRing(Handler h) {
        this.mActivePhone.unregisterForIncomingRing(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForDisconnect(Handler h, int what, Object obj) {
        this.mActivePhone.registerForDisconnect(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForDisconnect(Handler h) {
        this.mActivePhone.unregisterForDisconnect(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForMmiInitiate(Handler h, int what, Object obj) {
        this.mActivePhone.registerForMmiInitiate(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForMmiInitiate(Handler h) {
        this.mActivePhone.unregisterForMmiInitiate(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForMmiComplete(Handler h, int what, Object obj) {
        this.mActivePhone.registerForMmiComplete(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForMmiComplete(Handler h) {
        this.mActivePhone.unregisterForMmiComplete(h);
    }

    private final List<? extends MmiCode> $$robo$$com_android_internal_telephony_PhoneProxy$getPendingMmiCodes() {
        return this.mActivePhone.getPendingMmiCodes();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$sendUssdResponse(String ussdMessge) {
        this.mActivePhone.sendUssdResponse(ussdMessge);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.mActivePhone.registerForServiceStateChanged(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForServiceStateChanged(Handler h) {
        this.mActivePhone.unregisterForServiceStateChanged(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForSuppServiceNotification(Handler h, int what, Object obj) {
        this.mActivePhone.registerForSuppServiceNotification(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForSuppServiceNotification(Handler h) {
        this.mActivePhone.unregisterForSuppServiceNotification(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.mActivePhone.registerForSuppServiceFailed(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForSuppServiceFailed(Handler h) {
        this.mActivePhone.unregisterForSuppServiceFailed(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mActivePhone.registerForInCallVoicePrivacyOn(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mActivePhone.unregisterForInCallVoicePrivacyOn(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mActivePhone.registerForInCallVoicePrivacyOff(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mActivePhone.unregisterForInCallVoicePrivacyOff(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        this.mActivePhone.registerForCdmaOtaStatusChange(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForCdmaOtaStatusChange(Handler h) {
        this.mActivePhone.unregisterForCdmaOtaStatusChange(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        this.mActivePhone.registerForSubscriptionInfoReady(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForSubscriptionInfoReady(Handler h) {
        this.mActivePhone.unregisterForSubscriptionInfoReady(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForEcmTimerReset(Handler h, int what, Object obj) {
        this.mActivePhone.registerForEcmTimerReset(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForEcmTimerReset(Handler h) {
        this.mActivePhone.unregisterForEcmTimerReset(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForRingbackTone(Handler h, int what, Object obj) {
        this.mActivePhone.registerForRingbackTone(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForRingbackTone(Handler h) {
        this.mActivePhone.unregisterForRingbackTone(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForOnHoldTone(Handler h, int what, Object obj) {
        this.mActivePhone.registerForOnHoldTone(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForOnHoldTone(Handler h) {
        this.mActivePhone.unregisterForOnHoldTone(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForResendIncallMute(Handler h, int what, Object obj) {
        this.mActivePhone.registerForResendIncallMute(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForResendIncallMute(Handler h) {
        this.mActivePhone.unregisterForResendIncallMute(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForSimRecordsLoaded(Handler h, int what, Object obj) {
        this.mActivePhone.registerForSimRecordsLoaded(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForSimRecordsLoaded(Handler h) {
        this.mActivePhone.unregisterForSimRecordsLoaded(h);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$getIccRecordsLoaded() {
        return this.mIccCardProxy.getIccRecordsLoaded();
    }

    private final IccCard $$robo$$com_android_internal_telephony_PhoneProxy$getIccCard() {
        return this.mIccCardProxy;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$acceptCall(int videoState) throws CallStateException {
        this.mActivePhone.acceptCall(videoState);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$rejectCall() throws CallStateException {
        this.mActivePhone.rejectCall();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$switchHoldingAndActive() throws CallStateException {
        this.mActivePhone.switchHoldingAndActive();
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$canConference() {
        return this.mActivePhone.canConference();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$conference() throws CallStateException {
        this.mActivePhone.conference();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
        this.mActivePhone.enableEnhancedVoicePrivacy(enable, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$getEnhancedVoicePrivacy(Message onComplete) {
        this.mActivePhone.getEnhancedVoicePrivacy(onComplete);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$canTransfer() {
        return this.mActivePhone.canTransfer();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$explicitCallTransfer() throws CallStateException {
        this.mActivePhone.explicitCallTransfer();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$clearDisconnected() {
        this.mActivePhone.clearDisconnected();
    }

    private final Call $$robo$$com_android_internal_telephony_PhoneProxy$getForegroundCall() {
        return this.mActivePhone.getForegroundCall();
    }

    private final Call $$robo$$com_android_internal_telephony_PhoneProxy$getBackgroundCall() {
        return this.mActivePhone.getBackgroundCall();
    }

    private final Call $$robo$$com_android_internal_telephony_PhoneProxy$getRingingCall() {
        return this.mActivePhone.getRingingCall();
    }

    private final Connection $$robo$$com_android_internal_telephony_PhoneProxy$dial(String dialString, int videoState) throws CallStateException {
        return this.mActivePhone.dial(dialString, videoState);
    }

    private final Connection $$robo$$com_android_internal_telephony_PhoneProxy$dial(String dialString, UUSInfo uusInfo, int videoState) throws CallStateException {
        return this.mActivePhone.dial(dialString, uusInfo, videoState);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$handlePinMmi(String dialString) {
        return this.mActivePhone.handlePinMmi(dialString);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$handleInCallMmiCommands(String command) throws CallStateException {
        return this.mActivePhone.handleInCallMmiCommands(command);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$sendDtmf(char c) {
        this.mActivePhone.sendDtmf(c);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$startDtmf(char c) {
        this.mActivePhone.startDtmf(c);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$stopDtmf() {
        this.mActivePhone.stopDtmf();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setRadioPower(boolean power) {
        this.mActivePhone.setRadioPower(power);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$getMessageWaitingIndicator() {
        return this.mActivePhone.getMessageWaitingIndicator();
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$getCallForwardingIndicator() {
        return this.mActivePhone.getCallForwardingIndicator();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getLine1Number() {
        return this.mActivePhone.getLine1Number();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getCdmaMin() {
        return this.mActivePhone.getCdmaMin();
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$isMinInfoReady() {
        return this.mActivePhone.isMinInfoReady();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getCdmaPrlVersion() {
        return this.mActivePhone.getCdmaPrlVersion();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getLine1AlphaTag() {
        return this.mActivePhone.getLine1AlphaTag();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setLine1Number(String alphaTag, String number, Message onComplete) {
        this.mActivePhone.setLine1Number(alphaTag, number, onComplete);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getVoiceMailNumber() {
        return this.mActivePhone.getVoiceMailNumber();
    }

    private final int $$robo$$com_android_internal_telephony_PhoneProxy$getVoiceMessageCount() {
        return this.mActivePhone.getVoiceMessageCount();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getVoiceMailAlphaTag() {
        return this.mActivePhone.getVoiceMailAlphaTag();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setVoiceMailNumber(String alphaTag, String voiceMailNumber, Message onComplete) {
        this.mActivePhone.setVoiceMailNumber(alphaTag, voiceMailNumber, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        this.mActivePhone.getCallForwardingOption(commandInterfaceCFReason, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setCallForwardingOption(int commandInterfaceCFReason, int commandInterfaceCFAction, String dialingNumber, int timerSeconds, Message onComplete) {
        this.mActivePhone.setCallForwardingOption(commandInterfaceCFReason, commandInterfaceCFAction, dialingNumber, timerSeconds, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$getOutgoingCallerIdDisplay(Message onComplete) {
        this.mActivePhone.getOutgoingCallerIdDisplay(onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        this.mActivePhone.setOutgoingCallerIdDisplay(commandInterfaceCLIRMode, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$getCallWaiting(Message onComplete) {
        this.mActivePhone.getCallWaiting(onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setCallWaiting(boolean enable, Message onComplete) {
        this.mActivePhone.setCallWaiting(enable, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$getAvailableNetworks(Message response) {
        this.mActivePhone.getAvailableNetworks(response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setNetworkSelectionModeAutomatic(Message response) {
        this.mActivePhone.setNetworkSelectionModeAutomatic(response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$selectNetworkManually(OperatorInfo network, Message response) {
        this.mActivePhone.selectNetworkManually(network, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setPreferredNetworkType(int networkType, Message response) {
        this.mActivePhone.setPreferredNetworkType(networkType, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$getPreferredNetworkType(Message response) {
        this.mActivePhone.getPreferredNetworkType(response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$getNeighboringCids(Message response) {
        this.mActivePhone.getNeighboringCids(response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setOnPostDialCharacter(Handler h, int what, Object obj) {
        this.mActivePhone.setOnPostDialCharacter(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setMute(boolean muted) {
        this.mActivePhone.setMute(muted);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$getMute() {
        return this.mActivePhone.getMute();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setEchoSuppressionEnabled() {
        this.mActivePhone.setEchoSuppressionEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$invokeOemRilRequestRaw(byte[] data, Message response) {
        this.mActivePhone.invokeOemRilRequestRaw(data, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$invokeOemRilRequestStrings(String[] strings, Message response) {
        this.mActivePhone.invokeOemRilRequestStrings(strings, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$getDataCallList(Message response) {
        this.mActivePhone.getDataCallList(response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$updateServiceLocation() {
        this.mActivePhone.updateServiceLocation();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$enableLocationUpdates() {
        this.mActivePhone.enableLocationUpdates();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$disableLocationUpdates() {
        this.mActivePhone.disableLocationUpdates();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setUnitTestMode(boolean f) {
        this.mActivePhone.setUnitTestMode(f);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$getUnitTestMode() {
        return this.mActivePhone.getUnitTestMode();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setBandMode(int bandMode, Message response) {
        this.mActivePhone.setBandMode(bandMode, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$queryAvailableBandMode(Message response) {
        this.mActivePhone.queryAvailableBandMode(response);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$getDataRoamingEnabled() {
        return this.mActivePhone.getDataRoamingEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setDataRoamingEnabled(boolean enable) {
        this.mActivePhone.setDataRoamingEnabled(enable);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$getDataEnabled() {
        return this.mActivePhone.getDataEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setDataEnabled(boolean enable) {
        this.mActivePhone.setDataEnabled(enable);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$queryCdmaRoamingPreference(Message response) {
        this.mActivePhone.queryCdmaRoamingPreference(response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        this.mActivePhone.setCdmaRoamingPreference(cdmaRoamingType, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setCdmaSubscription(int cdmaSubscriptionType, Message response) {
        this.mActivePhone.setCdmaSubscription(cdmaSubscriptionType, response);
    }

    private final SimulatedRadioControl $$robo$$com_android_internal_telephony_PhoneProxy$getSimulatedRadioControl() {
        return this.mActivePhone.getSimulatedRadioControl();
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$isDataConnectivityPossible() {
        return this.mActivePhone.isDataConnectivityPossible("default");
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$isDataConnectivityPossible(String apnType) {
        return this.mActivePhone.isDataConnectivityPossible(apnType);
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getDeviceId() {
        return this.mActivePhone.getDeviceId();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getDeviceSvn() {
        return this.mActivePhone.getDeviceSvn();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getSubscriberId() {
        return this.mActivePhone.getSubscriberId();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getGroupIdLevel1() {
        return this.mActivePhone.getGroupIdLevel1();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getIccSerialNumber() {
        return this.mActivePhone.getIccSerialNumber();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getEsn() {
        return this.mActivePhone.getEsn();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getMeid() {
        return this.mActivePhone.getMeid();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getMsisdn() {
        return this.mActivePhone.getMsisdn();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getImei() {
        return this.mActivePhone.getImei();
    }

    private final PhoneSubInfo $$robo$$com_android_internal_telephony_PhoneProxy$getPhoneSubInfo() {
        return this.mActivePhone.getPhoneSubInfo();
    }

    private final IccPhoneBookInterfaceManager $$robo$$com_android_internal_telephony_PhoneProxy$getIccPhoneBookInterfaceManager() {
        return this.mActivePhone.getIccPhoneBookInterfaceManager();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setTTYMode(int ttyMode, Message onComplete) {
        this.mActivePhone.setTTYMode(ttyMode, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$queryTTYMode(Message onComplete) {
        this.mActivePhone.queryTTYMode(onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$activateCellBroadcastSms(int activate, Message response) {
        this.mActivePhone.activateCellBroadcastSms(activate, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$getCellBroadcastSmsConfig(Message response) {
        this.mActivePhone.getCellBroadcastSmsConfig(response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setCellBroadcastSmsConfig(int[] configValuesArray, Message response) {
        this.mActivePhone.setCellBroadcastSmsConfig(configValuesArray, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$notifyDataActivity() {
        this.mActivePhone.notifyDataActivity();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$getSmscAddress(Message result) {
        this.mActivePhone.getSmscAddress(result);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setSmscAddress(String address, Message result) {
        this.mActivePhone.setSmscAddress(address, result);
    }

    private final int $$robo$$com_android_internal_telephony_PhoneProxy$getCdmaEriIconIndex() {
        return this.mActivePhone.getCdmaEriIconIndex();
    }

    private final String $$robo$$com_android_internal_telephony_PhoneProxy$getCdmaEriText() {
        return this.mActivePhone.getCdmaEriText();
    }

    private final int $$robo$$com_android_internal_telephony_PhoneProxy$getCdmaEriIconMode() {
        return this.mActivePhone.getCdmaEriIconMode();
    }

    private final Phone $$robo$$com_android_internal_telephony_PhoneProxy$getActivePhone() {
        return this.mActivePhone;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        this.mActivePhone.sendBurstDtmf(dtmfString, on, off, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$exitEmergencyCallbackMode() {
        this.mActivePhone.exitEmergencyCallbackMode();
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$needsOtaServiceProvisioning() {
        return this.mActivePhone.needsOtaServiceProvisioning();
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$isOtaSpNumber(String dialStr) {
        return this.mActivePhone.isOtaSpNumber(dialStr);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForCallWaiting(Handler h, int what, Object obj) {
        this.mActivePhone.registerForCallWaiting(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForCallWaiting(Handler h) {
        this.mActivePhone.unregisterForCallWaiting(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForSignalInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForSignalInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForSignalInfo(Handler h) {
        this.mActivePhone.unregisterForSignalInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForDisplayInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForDisplayInfo(Handler h) {
        this.mActivePhone.unregisterForDisplayInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForNumberInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForNumberInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForNumberInfo(Handler h) {
        this.mActivePhone.unregisterForNumberInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForRedirectedNumberInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForRedirectedNumberInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForRedirectedNumberInfo(Handler h) {
        this.mActivePhone.unregisterForRedirectedNumberInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForLineControlInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForLineControlInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForLineControlInfo(Handler h) {
        this.mActivePhone.unregisterForLineControlInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerFoT53ClirlInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerFoT53ClirlInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForT53ClirInfo(Handler h) {
        this.mActivePhone.unregisterForT53ClirInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForT53AudioControlInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForT53AudioControlInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForT53AudioControlInfo(Handler h) {
        this.mActivePhone.unregisterForT53AudioControlInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        this.mActivePhone.setOnEcbModeExitResponse(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unsetOnEcbModeExitResponse(Handler h) {
        this.mActivePhone.unsetOnEcbModeExitResponse(h);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$isCspPlmnEnabled() {
        return this.mActivePhone.isCspPlmnEnabled();
    }

    private final IsimRecords $$robo$$com_android_internal_telephony_PhoneProxy$getIsimRecords() {
        return this.mActivePhone.getIsimRecords();
    }

    private final int $$robo$$com_android_internal_telephony_PhoneProxy$getLteOnCdmaMode() {
        return this.mActivePhone.getLteOnCdmaMode();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setVoiceMessageWaiting(int line, int countWaiting) {
        this.mActivePhone.setVoiceMessageWaiting(line, countWaiting);
    }

    private final UsimServiceTable $$robo$$com_android_internal_telephony_PhoneProxy$getUsimServiceTable() {
        return this.mActivePhone.getUsimServiceTable();
    }

    private final UiccCard $$robo$$com_android_internal_telephony_PhoneProxy$getUiccCard() {
        return this.mActivePhone.getUiccCard();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$nvReadItem(int itemID, Message response) {
        this.mActivePhone.nvReadItem(itemID, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$nvWriteItem(int itemID, String itemValue, Message response) {
        this.mActivePhone.nvWriteItem(itemID, itemValue, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$nvWriteCdmaPrl(byte[] preferredRoamingList, Message response) {
        this.mActivePhone.nvWriteCdmaPrl(preferredRoamingList, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$nvResetConfig(int resetType, Message response) {
        this.mActivePhone.nvResetConfig(resetType, response);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$dispose() {
        this.mCommandsInterface.unregisterForOn(this);
        this.mCommandsInterface.unregisterForVoiceRadioTechChanged(this);
        this.mCommandsInterface.unregisterForRilConnected(this);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$removeReferences() {
        this.mActivePhone = null;
        this.mCommandsInterface = null;
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$updateCurrentCarrierInProvider() {
        if (this.mActivePhone instanceof CDMALTEPhone) {
            return ((CDMALTEPhone)this.mActivePhone).updateCurrentCarrierInProvider();
        }
        if (this.mActivePhone instanceof GSMPhone) {
            return ((GSMPhone)this.mActivePhone).updateCurrentCarrierInProvider();
        }
        this.loge("Phone object is not MultiSim. This should not hit!!!!");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$updateDataConnectionTracker() {
        PhoneProxy.logd("Updating Data Connection Tracker");
        if (this.mActivePhone instanceof CDMALTEPhone) {
            ((CDMALTEPhone)this.mActivePhone).updateDataConnectionTracker();
        } else if (this.mActivePhone instanceof GSMPhone) {
            ((GSMPhone)this.mActivePhone).updateDataConnectionTracker();
        } else {
            this.loge("Phone object is not MultiSim. This should not hit!!!!");
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setInternalDataEnabled(boolean enable) {
        this.setInternalDataEnabled(enable, null);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$setInternalDataEnabledFlag(boolean enable) {
        boolean flag = false;
        if (this.mActivePhone instanceof CDMALTEPhone) {
            flag = ((CDMALTEPhone)this.mActivePhone).setInternalDataEnabledFlag(enable);
        } else if (this.mActivePhone instanceof GSMPhone) {
            flag = ((GSMPhone)this.mActivePhone).setInternalDataEnabledFlag(enable);
        } else {
            this.loge("Phone object is not MultiSim. This should not hit!!!!");
        }
        return flag;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setInternalDataEnabled(boolean enable, Message onCompleteMsg) {
        if (this.mActivePhone instanceof CDMALTEPhone) {
            ((CDMALTEPhone)this.mActivePhone).setInternalDataEnabled(enable, onCompleteMsg);
        } else if (this.mActivePhone instanceof GSMPhone) {
            ((GSMPhone)this.mActivePhone).setInternalDataEnabled(enable, onCompleteMsg);
        } else {
            this.loge("Phone object is not MultiSim. This should not hit!!!!");
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$registerForAllDataDisconnected(Handler h, int what, Object obj) {
        if (this.mActivePhone instanceof CDMALTEPhone) {
            ((CDMALTEPhone)this.mActivePhone).registerForAllDataDisconnected(h, what, obj);
        } else if (this.mActivePhone instanceof GSMPhone) {
            ((GSMPhone)this.mActivePhone).registerForAllDataDisconnected(h, what, obj);
        } else {
            this.loge("Phone object is not MultiSim. This should not hit!!!!");
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForAllDataDisconnected(Handler h) {
        if (this.mActivePhone instanceof CDMALTEPhone) {
            ((CDMALTEPhone)this.mActivePhone).unregisterForAllDataDisconnected(h);
        } else if (this.mActivePhone instanceof GSMPhone) {
            ((GSMPhone)this.mActivePhone).unregisterForAllDataDisconnected(h);
        } else {
            this.loge("Phone object is not MultiSim. This should not hit!!!!");
        }
    }

    private final long $$robo$$com_android_internal_telephony_PhoneProxy$getSubId() {
        return this.mActivePhone.getSubId();
    }

    private final int $$robo$$com_android_internal_telephony_PhoneProxy$getPhoneId() {
        return this.mActivePhone.getPhoneId();
    }

    private final String[] $$robo$$com_android_internal_telephony_PhoneProxy$getPcscfAddress(String apnType) {
        return this.mActivePhone.getPcscfAddress(apnType);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$setImsRegistrationState(boolean registered) {
        PhoneProxy.logd("setImsRegistrationState - registered: " + registered);
        this.mActivePhone.setImsRegistrationState(registered);
        if (this.mActivePhone.getPhoneName().equals("GSM")) {
            GSMPhone GP = (GSMPhone)this.mActivePhone;
            GP.getServiceStateTracker().setImsRegistrationState(registered);
        } else if (this.mActivePhone.getPhoneName().equals("CDMA")) {
            CDMAPhone CP = (CDMAPhone)this.mActivePhone;
            CP.getServiceStateTracker().setImsRegistrationState(registered);
        }
    }

    private final Phone $$robo$$com_android_internal_telephony_PhoneProxy$getImsPhone() {
        return this.mActivePhone.getImsPhone();
    }

    private final ImsPhone $$robo$$com_android_internal_telephony_PhoneProxy$relinquishOwnershipOfImsPhone() {
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$acquireOwnershipOfImsPhone(ImsPhone imsPhone) {
    }

    private final int $$robo$$com_android_internal_telephony_PhoneProxy$getVoicePhoneServiceState() {
        return this.mActivePhone.getVoicePhoneServiceState();
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$setOperatorBrandOverride(String brand) {
        return this.mActivePhone.setOperatorBrandOverride(brand);
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneProxy$isRadioAvailable() {
        return this.mCommandsInterface.getRadioState().isAvailable();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneProxy$shutdownRadio() {
        this.mActivePhone.shutdownRadio();
    }

    static void __staticInitializer__() {
        lockForRadioTechnologyChange = new Object();
    }

    private void __constructor__(PhoneBase phoneBase) {
        this.$$robo$$com_android_internal_telephony_PhoneProxy$__constructor__(phoneBase);
    }

    public PhoneProxy(PhoneBase phoneBase) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneProxy$__constructor__(com.android.internal.telephony.PhoneBase ), 0, this, phoneBase);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_PhoneProxy$handleMessage(android.os.Message ), 0, this, message);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$com_android_internal_telephony_PhoneProxy$logd(java.lang.String ), 0, (String)string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_PhoneProxy$loge(java.lang.String ), 0, this, string2);
    }

    private void phoneObjectUpdater(int n) {
        InvokeDynamicSupport.bootstrap("phoneObjectUpdater", $$robo$$com_android_internal_telephony_PhoneProxy$phoneObjectUpdater(int ), 0, this, n);
    }

    private void deleteAndCreatePhone(int n) {
        InvokeDynamicSupport.bootstrap("deleteAndCreatePhone", $$robo$$com_android_internal_telephony_PhoneProxy$deleteAndCreatePhone(int ), 0, this, n);
    }

    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return InvokeDynamicSupport.bootstrap("getIccSmsInterfaceManager", $$robo$$com_android_internal_telephony_PhoneProxy$getIccSmsInterfaceManager(), 0, this);
    }

    public PhoneSubInfoProxy getPhoneSubInfoProxy() {
        return InvokeDynamicSupport.bootstrap("getPhoneSubInfoProxy", $$robo$$com_android_internal_telephony_PhoneProxy$getPhoneSubInfoProxy(), 0, this);
    }

    public IccPhoneBookInterfaceManagerProxy getIccPhoneBookInterfaceManagerProxy() {
        return InvokeDynamicSupport.bootstrap("getIccPhoneBookInterfaceManagerProxy", $$robo$$com_android_internal_telephony_PhoneProxy$getIccPhoneBookInterfaceManagerProxy(), 0, this);
    }

    public IccFileHandler getIccFileHandler() {
        return InvokeDynamicSupport.bootstrap("getIccFileHandler", $$robo$$com_android_internal_telephony_PhoneProxy$getIccFileHandler(), 0, this);
    }

    @Override
    public void updatePhoneObject(int n) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_PhoneProxy$updatePhoneObject(int ), 0, this, n);
    }

    @Override
    public ServiceState getServiceState() {
        return InvokeDynamicSupport.bootstrap("getServiceState", $$robo$$com_android_internal_telephony_PhoneProxy$getServiceState(), 0, this);
    }

    @Override
    public CellLocation getCellLocation() {
        return InvokeDynamicSupport.bootstrap("getCellLocation", $$robo$$com_android_internal_telephony_PhoneProxy$getCellLocation(), 0, this);
    }

    @Override
    public List<CellInfo> getAllCellInfo() {
        return InvokeDynamicSupport.bootstrap("getAllCellInfo", $$robo$$com_android_internal_telephony_PhoneProxy$getAllCellInfo(), 0, this);
    }

    @Override
    public void setCellInfoListRate(int n) {
        InvokeDynamicSupport.bootstrap("setCellInfoListRate", $$robo$$com_android_internal_telephony_PhoneProxy$setCellInfoListRate(int ), 0, this, n);
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState() {
        return InvokeDynamicSupport.bootstrap("getDataConnectionState", $$robo$$com_android_internal_telephony_PhoneProxy$getDataConnectionState(), 0, this);
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState(String string2) {
        return InvokeDynamicSupport.bootstrap("getDataConnectionState", $$robo$$com_android_internal_telephony_PhoneProxy$getDataConnectionState(java.lang.String ), 0, this, string2);
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        return InvokeDynamicSupport.bootstrap("getDataActivityState", $$robo$$com_android_internal_telephony_PhoneProxy$getDataActivityState(), 0, this);
    }

    @Override
    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$com_android_internal_telephony_PhoneProxy$getContext(), 0, this);
    }

    @Override
    public void disableDnsCheck(boolean bl) {
        InvokeDynamicSupport.bootstrap("disableDnsCheck", $$robo$$com_android_internal_telephony_PhoneProxy$disableDnsCheck(boolean ), 0, this, bl);
    }

    @Override
    public boolean isDnsCheckDisabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDnsCheckDisabled", $$robo$$com_android_internal_telephony_PhoneProxy$isDnsCheckDisabled(), 0, this);
    }

    @Override
    public PhoneConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_PhoneProxy$getState(), 0, this);
    }

    @Override
    public String getPhoneName() {
        return InvokeDynamicSupport.bootstrap("getPhoneName", $$robo$$com_android_internal_telephony_PhoneProxy$getPhoneName(), 0, this);
    }

    @Override
    public int getPhoneType() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneType", $$robo$$com_android_internal_telephony_PhoneProxy$getPhoneType(), 0, this);
    }

    @Override
    public String[] getActiveApnTypes() {
        return InvokeDynamicSupport.bootstrap("getActiveApnTypes", $$robo$$com_android_internal_telephony_PhoneProxy$getActiveApnTypes(), 0, this);
    }

    @Override
    public String getActiveApnHost(String string2) {
        return InvokeDynamicSupport.bootstrap("getActiveApnHost", $$robo$$com_android_internal_telephony_PhoneProxy$getActiveApnHost(java.lang.String ), 0, this, string2);
    }

    @Override
    public LinkProperties getLinkProperties(String string2) {
        return InvokeDynamicSupport.bootstrap("getLinkProperties", $$robo$$com_android_internal_telephony_PhoneProxy$getLinkProperties(java.lang.String ), 0, this, string2);
    }

    @Override
    public NetworkCapabilities getNetworkCapabilities(String string2) {
        return InvokeDynamicSupport.bootstrap("getNetworkCapabilities", $$robo$$com_android_internal_telephony_PhoneProxy$getNetworkCapabilities(java.lang.String ), 0, this, string2);
    }

    @Override
    public SignalStrength getSignalStrength() {
        return InvokeDynamicSupport.bootstrap("getSignalStrength", $$robo$$com_android_internal_telephony_PhoneProxy$getSignalStrength(), 0, this);
    }

    @Override
    public void registerForUnknownConnection(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForUnknownConnection", $$robo$$com_android_internal_telephony_PhoneProxy$registerForUnknownConnection(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForUnknownConnection(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForUnknownConnection", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForUnknownConnection(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForHandoverStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForHandoverStateChanged", $$robo$$com_android_internal_telephony_PhoneProxy$registerForHandoverStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForHandoverStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForHandoverStateChanged", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForHandoverStateChanged(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForPreciseCallStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForPreciseCallStateChanged", $$robo$$com_android_internal_telephony_PhoneProxy$registerForPreciseCallStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForPreciseCallStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForPreciseCallStateChanged", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForPreciseCallStateChanged(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForNewRingingConnection(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNewRingingConnection", $$robo$$com_android_internal_telephony_PhoneProxy$registerForNewRingingConnection(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForNewRingingConnection(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNewRingingConnection", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForNewRingingConnection(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForIncomingRing(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForIncomingRing", $$robo$$com_android_internal_telephony_PhoneProxy$registerForIncomingRing(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForIncomingRing(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForIncomingRing", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForIncomingRing(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForDisconnect(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDisconnect", $$robo$$com_android_internal_telephony_PhoneProxy$registerForDisconnect(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForDisconnect(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDisconnect", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForDisconnect(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForMmiInitiate(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForMmiInitiate", $$robo$$com_android_internal_telephony_PhoneProxy$registerForMmiInitiate(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForMmiInitiate(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForMmiInitiate", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForMmiInitiate(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForMmiComplete(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForMmiComplete", $$robo$$com_android_internal_telephony_PhoneProxy$registerForMmiComplete(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForMmiComplete(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForMmiComplete", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForMmiComplete(android.os.Handler ), 0, this, handler);
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return InvokeDynamicSupport.bootstrap("getPendingMmiCodes", $$robo$$com_android_internal_telephony_PhoneProxy$getPendingMmiCodes(), 0, this);
    }

    @Override
    public void sendUssdResponse(String string2) {
        InvokeDynamicSupport.bootstrap("sendUssdResponse", $$robo$$com_android_internal_telephony_PhoneProxy$sendUssdResponse(java.lang.String ), 0, this, string2);
    }

    @Override
    public void registerForServiceStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForServiceStateChanged", $$robo$$com_android_internal_telephony_PhoneProxy$registerForServiceStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForServiceStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForServiceStateChanged", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForServiceStateChanged(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSuppServiceNotification", $$robo$$com_android_internal_telephony_PhoneProxy$registerForSuppServiceNotification(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSuppServiceNotification", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForSuppServiceNotification(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSuppServiceFailed(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSuppServiceFailed", $$robo$$com_android_internal_telephony_PhoneProxy$registerForSuppServiceFailed(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSuppServiceFailed(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSuppServiceFailed", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForSuppServiceFailed(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForInCallVoicePrivacyOn(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForInCallVoicePrivacyOn", $$robo$$com_android_internal_telephony_PhoneProxy$registerForInCallVoicePrivacyOn(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOn(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForInCallVoicePrivacyOn", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForInCallVoicePrivacyOn(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForInCallVoicePrivacyOff(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForInCallVoicePrivacyOff", $$robo$$com_android_internal_telephony_PhoneProxy$registerForInCallVoicePrivacyOff(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOff(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForInCallVoicePrivacyOff", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForInCallVoicePrivacyOff(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_PhoneProxy$registerForCdmaOtaStatusChange(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForCdmaOtaStatusChange(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_PhoneProxy$registerForSubscriptionInfoReady(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForSubscriptionInfoReady(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEcmTimerReset", $$robo$$com_android_internal_telephony_PhoneProxy$registerForEcmTimerReset(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEcmTimerReset", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForEcmTimerReset(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForRingbackTone(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRingbackTone", $$robo$$com_android_internal_telephony_PhoneProxy$registerForRingbackTone(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForRingbackTone(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRingbackTone", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForRingbackTone(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForOnHoldTone(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForOnHoldTone", $$robo$$com_android_internal_telephony_PhoneProxy$registerForOnHoldTone(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForOnHoldTone(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForOnHoldTone", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForOnHoldTone(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForResendIncallMute(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForResendIncallMute", $$robo$$com_android_internal_telephony_PhoneProxy$registerForResendIncallMute(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForResendIncallMute(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForResendIncallMute", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForResendIncallMute(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSimRecordsLoaded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSimRecordsLoaded", $$robo$$com_android_internal_telephony_PhoneProxy$registerForSimRecordsLoaded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSimRecordsLoaded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSimRecordsLoaded", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForSimRecordsLoaded(android.os.Handler ), 0, this, handler);
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccRecordsLoaded", $$robo$$com_android_internal_telephony_PhoneProxy$getIccRecordsLoaded(), 0, this);
    }

    @Override
    public IccCard getIccCard() {
        return InvokeDynamicSupport.bootstrap("getIccCard", $$robo$$com_android_internal_telephony_PhoneProxy$getIccCard(), 0, this);
    }

    @Override
    public void acceptCall(int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_PhoneProxy$acceptCall(int ), 0, this, n);
    }

    @Override
    public void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_PhoneProxy$rejectCall(), 0, this);
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchHoldingAndActive", $$robo$$com_android_internal_telephony_PhoneProxy$switchHoldingAndActive(), 0, this);
    }

    @Override
    public boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_PhoneProxy$canConference(), 0, this);
    }

    @Override
    public void conference() throws CallStateException {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_PhoneProxy$conference(), 0, this);
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("enableEnhancedVoicePrivacy", $$robo$$com_android_internal_telephony_PhoneProxy$enableEnhancedVoicePrivacy(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getEnhancedVoicePrivacy(Message message) {
        InvokeDynamicSupport.bootstrap("getEnhancedVoicePrivacy", $$robo$$com_android_internal_telephony_PhoneProxy$getEnhancedVoicePrivacy(android.os.Message ), 0, this, message);
    }

    @Override
    public boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_PhoneProxy$canTransfer(), 0, this);
    }

    @Override
    public void explicitCallTransfer() throws CallStateException {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_PhoneProxy$explicitCallTransfer(), 0, this);
    }

    @Override
    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_PhoneProxy$clearDisconnected(), 0, this);
    }

    @Override
    public Call getForegroundCall() {
        return InvokeDynamicSupport.bootstrap("getForegroundCall", $$robo$$com_android_internal_telephony_PhoneProxy$getForegroundCall(), 0, this);
    }

    @Override
    public Call getBackgroundCall() {
        return InvokeDynamicSupport.bootstrap("getBackgroundCall", $$robo$$com_android_internal_telephony_PhoneProxy$getBackgroundCall(), 0, this);
    }

    @Override
    public Call getRingingCall() {
        return InvokeDynamicSupport.bootstrap("getRingingCall", $$robo$$com_android_internal_telephony_PhoneProxy$getRingingCall(), 0, this);
    }

    @Override
    public Connection dial(String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_PhoneProxy$dial(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public Connection dial(String string2, UUSInfo uUSInfo, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_PhoneProxy$dial(java.lang.String com.android.internal.telephony.UUSInfo int ), 0, this, string2, uUSInfo, n);
    }

    @Override
    public boolean handlePinMmi(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePinMmi", $$robo$$com_android_internal_telephony_PhoneProxy$handlePinMmi(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean handleInCallMmiCommands(String string2) throws CallStateException {
        return (boolean)InvokeDynamicSupport.bootstrap("handleInCallMmiCommands", $$robo$$com_android_internal_telephony_PhoneProxy$handleInCallMmiCommands(java.lang.String ), 0, this, string2);
    }

    @Override
    public void sendDtmf(char c) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_PhoneProxy$sendDtmf(char ), 0, this, c);
    }

    @Override
    public void startDtmf(char c) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_PhoneProxy$startDtmf(char ), 0, this, c);
    }

    @Override
    public void stopDtmf() {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_PhoneProxy$stopDtmf(), 0, this);
    }

    @Override
    public void setRadioPower(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRadioPower", $$robo$$com_android_internal_telephony_PhoneProxy$setRadioPower(boolean ), 0, this, bl);
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMessageWaitingIndicator", $$robo$$com_android_internal_telephony_PhoneProxy$getMessageWaitingIndicator(), 0, this);
    }

    @Override
    public boolean getCallForwardingIndicator() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCallForwardingIndicator", $$robo$$com_android_internal_telephony_PhoneProxy$getCallForwardingIndicator(), 0, this);
    }

    @Override
    public String getLine1Number() {
        return InvokeDynamicSupport.bootstrap("getLine1Number", $$robo$$com_android_internal_telephony_PhoneProxy$getLine1Number(), 0, this);
    }

    @Override
    public String getCdmaMin() {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$com_android_internal_telephony_PhoneProxy$getCdmaMin(), 0, this);
    }

    @Override
    public boolean isMinInfoReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMinInfoReady", $$robo$$com_android_internal_telephony_PhoneProxy$isMinInfoReady(), 0, this);
    }

    @Override
    public String getCdmaPrlVersion() {
        return InvokeDynamicSupport.bootstrap("getCdmaPrlVersion", $$robo$$com_android_internal_telephony_PhoneProxy$getCdmaPrlVersion(), 0, this);
    }

    @Override
    public String getLine1AlphaTag() {
        return InvokeDynamicSupport.bootstrap("getLine1AlphaTag", $$robo$$com_android_internal_telephony_PhoneProxy$getLine1AlphaTag(), 0, this);
    }

    @Override
    public void setLine1Number(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setLine1Number", $$robo$$com_android_internal_telephony_PhoneProxy$setLine1Number(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public String getVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$com_android_internal_telephony_PhoneProxy$getVoiceMailNumber(), 0, this);
    }

    @Override
    public int getVoiceMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$com_android_internal_telephony_PhoneProxy$getVoiceMessageCount(), 0, this);
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$com_android_internal_telephony_PhoneProxy$getVoiceMailAlphaTag(), 0, this);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$com_android_internal_telephony_PhoneProxy$setVoiceMailNumber(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void getCallForwardingOption(int n, Message message) {
        InvokeDynamicSupport.bootstrap("getCallForwardingOption", $$robo$$com_android_internal_telephony_PhoneProxy$getCallForwardingOption(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
        InvokeDynamicSupport.bootstrap("setCallForwardingOption", $$robo$$com_android_internal_telephony_PhoneProxy$setCallForwardingOption(int int java.lang.String int android.os.Message ), 0, this, n, n2, string2, n3, message);
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        InvokeDynamicSupport.bootstrap("getOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_PhoneProxy$getOutgoingCallerIdDisplay(android.os.Message ), 0, this, message);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_PhoneProxy$setOutgoingCallerIdDisplay(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getCallWaiting(Message message) {
        InvokeDynamicSupport.bootstrap("getCallWaiting", $$robo$$com_android_internal_telephony_PhoneProxy$getCallWaiting(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setCallWaiting", $$robo$$com_android_internal_telephony_PhoneProxy$setCallWaiting(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        InvokeDynamicSupport.bootstrap("getAvailableNetworks", $$robo$$com_android_internal_telephony_PhoneProxy$getAvailableNetworks(android.os.Message ), 0, this, message);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeAutomatic", $$robo$$com_android_internal_telephony_PhoneProxy$setNetworkSelectionModeAutomatic(android.os.Message ), 0, this, message);
    }

    @Override
    public void selectNetworkManually(OperatorInfo operatorInfo, Message message) {
        InvokeDynamicSupport.bootstrap("selectNetworkManually", $$robo$$com_android_internal_telephony_PhoneProxy$selectNetworkManually(com.android.internal.telephony.OperatorInfo android.os.Message ), 0, this, operatorInfo, message);
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setPreferredNetworkType", $$robo$$com_android_internal_telephony_PhoneProxy$setPreferredNetworkType(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getPreferredNetworkType(Message message) {
        InvokeDynamicSupport.bootstrap("getPreferredNetworkType", $$robo$$com_android_internal_telephony_PhoneProxy$getPreferredNetworkType(android.os.Message ), 0, this, message);
    }

    @Override
    public void getNeighboringCids(Message message) {
        InvokeDynamicSupport.bootstrap("getNeighboringCids", $$robo$$com_android_internal_telephony_PhoneProxy$getNeighboringCids(android.os.Message ), 0, this, message);
    }

    @Override
    public void setOnPostDialCharacter(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnPostDialCharacter", $$robo$$com_android_internal_telephony_PhoneProxy$setOnPostDialCharacter(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_PhoneProxy$setMute(boolean ), 0, this, bl);
    }

    @Override
    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_PhoneProxy$getMute(), 0, this);
    }

    @Override
    public void setEchoSuppressionEnabled() {
        InvokeDynamicSupport.bootstrap("setEchoSuppressionEnabled", $$robo$$com_android_internal_telephony_PhoneProxy$setEchoSuppressionEnabled(), 0, this);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestRaw", $$robo$$com_android_internal_telephony_PhoneProxy$invokeOemRilRequestRaw(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestStrings", $$robo$$com_android_internal_telephony_PhoneProxy$invokeOemRilRequestStrings(java.lang.String[] android.os.Message ), 0, this, stringArray, message);
    }

    @Override
    public void getDataCallList(Message message) {
        InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$com_android_internal_telephony_PhoneProxy$getDataCallList(android.os.Message ), 0, this, message);
    }

    @Override
    public void updateServiceLocation() {
        InvokeDynamicSupport.bootstrap("updateServiceLocation", $$robo$$com_android_internal_telephony_PhoneProxy$updateServiceLocation(), 0, this);
    }

    @Override
    public void enableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("enableLocationUpdates", $$robo$$com_android_internal_telephony_PhoneProxy$enableLocationUpdates(), 0, this);
    }

    @Override
    public void disableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("disableLocationUpdates", $$robo$$com_android_internal_telephony_PhoneProxy$disableLocationUpdates(), 0, this);
    }

    @Override
    public void setUnitTestMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUnitTestMode", $$robo$$com_android_internal_telephony_PhoneProxy$setUnitTestMode(boolean ), 0, this, bl);
    }

    @Override
    public boolean getUnitTestMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("getUnitTestMode", $$robo$$com_android_internal_telephony_PhoneProxy$getUnitTestMode(), 0, this);
    }

    @Override
    public void setBandMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setBandMode", $$robo$$com_android_internal_telephony_PhoneProxy$setBandMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryAvailableBandMode", $$robo$$com_android_internal_telephony_PhoneProxy$queryAvailableBandMode(android.os.Message ), 0, this, message);
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataRoamingEnabled", $$robo$$com_android_internal_telephony_PhoneProxy$getDataRoamingEnabled(), 0, this);
    }

    @Override
    public void setDataRoamingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataRoamingEnabled", $$robo$$com_android_internal_telephony_PhoneProxy$setDataRoamingEnabled(boolean ), 0, this, bl);
    }

    @Override
    public boolean getDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataEnabled", $$robo$$com_android_internal_telephony_PhoneProxy$getDataEnabled(), 0, this);
    }

    @Override
    public void setDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataEnabled", $$robo$$com_android_internal_telephony_PhoneProxy$setDataEnabled(boolean ), 0, this, bl);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        InvokeDynamicSupport.bootstrap("queryCdmaRoamingPreference", $$robo$$com_android_internal_telephony_PhoneProxy$queryCdmaRoamingPreference(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaRoamingPreference", $$robo$$com_android_internal_telephony_PhoneProxy$setCdmaRoamingPreference(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setCdmaSubscription(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaSubscription", $$robo$$com_android_internal_telephony_PhoneProxy$setCdmaSubscription(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public SimulatedRadioControl getSimulatedRadioControl() {
        return InvokeDynamicSupport.bootstrap("getSimulatedRadioControl", $$robo$$com_android_internal_telephony_PhoneProxy$getSimulatedRadioControl(), 0, this);
    }

    @Override
    public boolean isDataConnectivityPossible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataConnectivityPossible", $$robo$$com_android_internal_telephony_PhoneProxy$isDataConnectivityPossible(), 0, this);
    }

    @Override
    public boolean isDataConnectivityPossible(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataConnectivityPossible", $$robo$$com_android_internal_telephony_PhoneProxy$isDataConnectivityPossible(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getDeviceId() {
        return InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$com_android_internal_telephony_PhoneProxy$getDeviceId(), 0, this);
    }

    @Override
    public String getDeviceSvn() {
        return InvokeDynamicSupport.bootstrap("getDeviceSvn", $$robo$$com_android_internal_telephony_PhoneProxy$getDeviceSvn(), 0, this);
    }

    @Override
    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$com_android_internal_telephony_PhoneProxy$getSubscriberId(), 0, this);
    }

    @Override
    public String getGroupIdLevel1() {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1", $$robo$$com_android_internal_telephony_PhoneProxy$getGroupIdLevel1(), 0, this);
    }

    @Override
    public String getIccSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getIccSerialNumber", $$robo$$com_android_internal_telephony_PhoneProxy$getIccSerialNumber(), 0, this);
    }

    @Override
    public String getEsn() {
        return InvokeDynamicSupport.bootstrap("getEsn", $$robo$$com_android_internal_telephony_PhoneProxy$getEsn(), 0, this);
    }

    @Override
    public String getMeid() {
        return InvokeDynamicSupport.bootstrap("getMeid", $$robo$$com_android_internal_telephony_PhoneProxy$getMeid(), 0, this);
    }

    @Override
    public String getMsisdn() {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$com_android_internal_telephony_PhoneProxy$getMsisdn(), 0, this);
    }

    @Override
    public String getImei() {
        return InvokeDynamicSupport.bootstrap("getImei", $$robo$$com_android_internal_telephony_PhoneProxy$getImei(), 0, this);
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return InvokeDynamicSupport.bootstrap("getPhoneSubInfo", $$robo$$com_android_internal_telephony_PhoneProxy$getPhoneSubInfo(), 0, this);
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return InvokeDynamicSupport.bootstrap("getIccPhoneBookInterfaceManager", $$robo$$com_android_internal_telephony_PhoneProxy$getIccPhoneBookInterfaceManager(), 0, this);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setTTYMode", $$robo$$com_android_internal_telephony_PhoneProxy$setTTYMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void queryTTYMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryTTYMode", $$robo$$com_android_internal_telephony_PhoneProxy$queryTTYMode(android.os.Message ), 0, this, message);
    }

    @Override
    public void activateCellBroadcastSms(int n, Message message) {
        InvokeDynamicSupport.bootstrap("activateCellBroadcastSms", $$robo$$com_android_internal_telephony_PhoneProxy$activateCellBroadcastSms(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getCellBroadcastSmsConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getCellBroadcastSmsConfig", $$robo$$com_android_internal_telephony_PhoneProxy$getCellBroadcastSmsConfig(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] nArray, Message message) {
        InvokeDynamicSupport.bootstrap("setCellBroadcastSmsConfig", $$robo$$com_android_internal_telephony_PhoneProxy$setCellBroadcastSmsConfig(int[] android.os.Message ), 0, this, nArray, message);
    }

    @Override
    public void notifyDataActivity() {
        InvokeDynamicSupport.bootstrap("notifyDataActivity", $$robo$$com_android_internal_telephony_PhoneProxy$notifyDataActivity(), 0, this);
    }

    @Override
    public void getSmscAddress(Message message) {
        InvokeDynamicSupport.bootstrap("getSmscAddress", $$robo$$com_android_internal_telephony_PhoneProxy$getSmscAddress(android.os.Message ), 0, this, message);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setSmscAddress", $$robo$$com_android_internal_telephony_PhoneProxy$setSmscAddress(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public int getCdmaEriIconIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$com_android_internal_telephony_PhoneProxy$getCdmaEriIconIndex(), 0, this);
    }

    @Override
    public String getCdmaEriText() {
        return InvokeDynamicSupport.bootstrap("getCdmaEriText", $$robo$$com_android_internal_telephony_PhoneProxy$getCdmaEriText(), 0, this);
    }

    @Override
    public int getCdmaEriIconMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$com_android_internal_telephony_PhoneProxy$getCdmaEriIconMode(), 0, this);
    }

    public Phone getActivePhone() {
        return InvokeDynamicSupport.bootstrap("getActivePhone", $$robo$$com_android_internal_telephony_PhoneProxy$getActivePhone(), 0, this);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_PhoneProxy$sendBurstDtmf(java.lang.String int int android.os.Message ), 0, this, string2, n, n2, message);
    }

    @Override
    public void exitEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_PhoneProxy$exitEmergencyCallbackMode(), 0, this);
    }

    @Override
    public boolean needsOtaServiceProvisioning() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsOtaServiceProvisioning", $$robo$$com_android_internal_telephony_PhoneProxy$needsOtaServiceProvisioning(), 0, this);
    }

    @Override
    public boolean isOtaSpNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOtaSpNumber", $$robo$$com_android_internal_telephony_PhoneProxy$isOtaSpNumber(java.lang.String ), 0, this, string2);
    }

    @Override
    public void registerForCallWaiting(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCallWaiting", $$robo$$com_android_internal_telephony_PhoneProxy$registerForCallWaiting(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForCallWaiting(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCallWaiting", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForCallWaiting(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSignalInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSignalInfo", $$robo$$com_android_internal_telephony_PhoneProxy$registerForSignalInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSignalInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSignalInfo", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForSignalInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForDisplayInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDisplayInfo", $$robo$$com_android_internal_telephony_PhoneProxy$registerForDisplayInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForDisplayInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDisplayInfo", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForDisplayInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForNumberInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNumberInfo", $$robo$$com_android_internal_telephony_PhoneProxy$registerForNumberInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForNumberInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNumberInfo", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForNumberInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForRedirectedNumberInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRedirectedNumberInfo", $$robo$$com_android_internal_telephony_PhoneProxy$registerForRedirectedNumberInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForRedirectedNumberInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRedirectedNumberInfo", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForRedirectedNumberInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForLineControlInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForLineControlInfo", $$robo$$com_android_internal_telephony_PhoneProxy$registerForLineControlInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForLineControlInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForLineControlInfo", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForLineControlInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerFoT53ClirlInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerFoT53ClirlInfo", $$robo$$com_android_internal_telephony_PhoneProxy$registerFoT53ClirlInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForT53ClirInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForT53ClirInfo", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForT53ClirInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForT53AudioControlInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForT53AudioControlInfo", $$robo$$com_android_internal_telephony_PhoneProxy$registerForT53AudioControlInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForT53AudioControlInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForT53AudioControlInfo", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForT53AudioControlInfo(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_PhoneProxy$setOnEcbModeExitResponse(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler handler) {
        InvokeDynamicSupport.bootstrap("unsetOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_PhoneProxy$unsetOnEcbModeExitResponse(android.os.Handler ), 0, this, handler);
    }

    @Override
    public boolean isCspPlmnEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCspPlmnEnabled", $$robo$$com_android_internal_telephony_PhoneProxy$isCspPlmnEnabled(), 0, this);
    }

    @Override
    public IsimRecords getIsimRecords() {
        return InvokeDynamicSupport.bootstrap("getIsimRecords", $$robo$$com_android_internal_telephony_PhoneProxy$getIsimRecords(), 0, this);
    }

    @Override
    public int getLteOnCdmaMode() {
        return (int)InvokeDynamicSupport.bootstrap("getLteOnCdmaMode", $$robo$$com_android_internal_telephony_PhoneProxy$getLteOnCdmaMode(), 0, this);
    }

    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVoiceMessageWaiting", $$robo$$com_android_internal_telephony_PhoneProxy$setVoiceMessageWaiting(int int ), 0, this, n, n2);
    }

    @Override
    public UsimServiceTable getUsimServiceTable() {
        return InvokeDynamicSupport.bootstrap("getUsimServiceTable", $$robo$$com_android_internal_telephony_PhoneProxy$getUsimServiceTable(), 0, this);
    }

    @Override
    public UiccCard getUiccCard() {
        return InvokeDynamicSupport.bootstrap("getUiccCard", $$robo$$com_android_internal_telephony_PhoneProxy$getUiccCard(), 0, this);
    }

    @Override
    public void nvReadItem(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvReadItem", $$robo$$com_android_internal_telephony_PhoneProxy$nvReadItem(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void nvWriteItem(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteItem", $$robo$$com_android_internal_telephony_PhoneProxy$nvWriteItem(int java.lang.String android.os.Message ), 0, this, n, string2, message);
    }

    @Override
    public void nvWriteCdmaPrl(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteCdmaPrl", $$robo$$com_android_internal_telephony_PhoneProxy$nvWriteCdmaPrl(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Override
    public void nvResetConfig(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvResetConfig", $$robo$$com_android_internal_telephony_PhoneProxy$nvResetConfig(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_PhoneProxy$dispose(), 0, this);
    }

    @Override
    public void removeReferences() {
        InvokeDynamicSupport.bootstrap("removeReferences", $$robo$$com_android_internal_telephony_PhoneProxy$removeReferences(), 0, this);
    }

    public boolean updateCurrentCarrierInProvider() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateCurrentCarrierInProvider", $$robo$$com_android_internal_telephony_PhoneProxy$updateCurrentCarrierInProvider(), 0, this);
    }

    public void updateDataConnectionTracker() {
        InvokeDynamicSupport.bootstrap("updateDataConnectionTracker", $$robo$$com_android_internal_telephony_PhoneProxy$updateDataConnectionTracker(), 0, this);
    }

    public void setInternalDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInternalDataEnabled", $$robo$$com_android_internal_telephony_PhoneProxy$setInternalDataEnabled(boolean ), 0, this, bl);
    }

    public boolean setInternalDataEnabledFlag(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setInternalDataEnabledFlag", $$robo$$com_android_internal_telephony_PhoneProxy$setInternalDataEnabledFlag(boolean ), 0, this, bl);
    }

    public void setInternalDataEnabled(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setInternalDataEnabled", $$robo$$com_android_internal_telephony_PhoneProxy$setInternalDataEnabled(boolean android.os.Message ), 0, this, bl, message);
    }

    public void registerForAllDataDisconnected(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForAllDataDisconnected", $$robo$$com_android_internal_telephony_PhoneProxy$registerForAllDataDisconnected(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForAllDataDisconnected(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForAllDataDisconnected", $$robo$$com_android_internal_telephony_PhoneProxy$unregisterForAllDataDisconnected(android.os.Handler ), 0, this, handler);
    }

    @Override
    public long getSubId() {
        return (long)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$com_android_internal_telephony_PhoneProxy$getSubId(), 0, this);
    }

    @Override
    public int getPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$com_android_internal_telephony_PhoneProxy$getPhoneId(), 0, this);
    }

    @Override
    public String[] getPcscfAddress(String string2) {
        return InvokeDynamicSupport.bootstrap("getPcscfAddress", $$robo$$com_android_internal_telephony_PhoneProxy$getPcscfAddress(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setImsRegistrationState(boolean bl) {
        InvokeDynamicSupport.bootstrap("setImsRegistrationState", $$robo$$com_android_internal_telephony_PhoneProxy$setImsRegistrationState(boolean ), 0, this, bl);
    }

    @Override
    public Phone getImsPhone() {
        return InvokeDynamicSupport.bootstrap("getImsPhone", $$robo$$com_android_internal_telephony_PhoneProxy$getImsPhone(), 0, this);
    }

    @Override
    public ImsPhone relinquishOwnershipOfImsPhone() {
        return InvokeDynamicSupport.bootstrap("relinquishOwnershipOfImsPhone", $$robo$$com_android_internal_telephony_PhoneProxy$relinquishOwnershipOfImsPhone(), 0, this);
    }

    @Override
    public void acquireOwnershipOfImsPhone(ImsPhone imsPhone) {
        InvokeDynamicSupport.bootstrap("acquireOwnershipOfImsPhone", $$robo$$com_android_internal_telephony_PhoneProxy$acquireOwnershipOfImsPhone(com.android.internal.telephony.imsphone.ImsPhone ), 0, this, imsPhone);
    }

    @Override
    public int getVoicePhoneServiceState() {
        return (int)InvokeDynamicSupport.bootstrap("getVoicePhoneServiceState", $$robo$$com_android_internal_telephony_PhoneProxy$getVoicePhoneServiceState(), 0, this);
    }

    @Override
    public boolean setOperatorBrandOverride(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$com_android_internal_telephony_PhoneProxy$setOperatorBrandOverride(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isRadioAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRadioAvailable", $$robo$$com_android_internal_telephony_PhoneProxy$isRadioAvailable(), 0, this);
    }

    @Override
    public void shutdownRadio() {
        InvokeDynamicSupport.bootstrap("shutdownRadio", $$robo$$com_android_internal_telephony_PhoneProxy$shutdownRadio(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(PhoneProxy.class);
    }

    public /* synthetic */ PhoneProxy() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneProxy)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

