/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Message;
import android.os.Parcel;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.RIL;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RILRequest
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "RilRequest";
    static Random sRandom;
    static AtomicInteger sNextSerial;
    private static Object sPoolSync;
    private static RILRequest sPool;
    private static int sPoolSize;
    private static int MAX_POOL_SIZE = 4;
    private Context mContext;
    int mSerial;
    int mRequest;
    Message mResult;
    Parcel mParcel;
    RILRequest mNext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final RILRequest $$robo$$com_android_internal_telephony_RILRequest$obtain(int request, Message result) {
        RILRequest rr = null;
        Object object = sPoolSync;
        synchronized (object) {
            if (sPool != null) {
                rr = sPool;
                sPool = rr.mNext;
                rr.mNext = null;
                --sPoolSize;
            }
        }
        if (rr == null) {
            rr = new RILRequest();
        }
        rr.mSerial = sNextSerial.getAndIncrement();
        rr.mRequest = request;
        rr.mResult = result;
        rr.mParcel = Parcel.obtain();
        if (result != null && result.getTarget() == null) {
            throw new NullPointerException("Message target must not be null");
        }
        rr.mParcel.writeInt(request);
        rr.mParcel.writeInt(rr.mSerial);
        return rr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RILRequest$release() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 4) {
                this.mNext = sPool;
                sPool = this;
                ++sPoolSize;
                this.mResult = null;
            }
        }
    }

    private void $$robo$$com_android_internal_telephony_RILRequest$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_telephony_RILRequest$resetSerial() {
        sNextSerial.set(sRandom.nextInt());
    }

    private final String $$robo$$com_android_internal_telephony_RILRequest$serialString() {
        StringBuilder sb = new StringBuilder(8);
        long adjustedSerial = ((long)this.mSerial - Integer.MIN_VALUE) % 10000L;
        String sn = Long.toString(adjustedSerial);
        sb.append('[');
        int s = sn.length();
        for (int i = 0; i < 4 - s; ++i) {
            sb.append('0');
        }
        sb.append(sn);
        sb.append(']');
        return sb.toString();
    }

    private final void $$robo$$com_android_internal_telephony_RILRequest$onError(int error, Object ret) {
        CommandException ex = CommandException.fromRilErrno(error);
        Rlog.d("RilRequest", this.serialString() + "< " + RIL.requestToString(this.mRequest) + " error: " + ex + " ret=" + RIL.retToString(this.mRequest, ret));
        if (this.mResult != null) {
            AsyncResult.forMessage(this.mResult, ret, ex);
            this.mResult.sendToTarget();
        }
        if (this.mParcel != null) {
            this.mParcel.recycle();
            this.mParcel = null;
        }
    }

    static void __staticInitializer__() {
        sRandom = new Random();
        sNextSerial = new AtomicInteger(0);
        sPoolSync = new Object();
        sPool = null;
        sPoolSize = 0;
    }

    static RILRequest obtain(int n, Message message) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$com_android_internal_telephony_RILRequest$obtain(int android.os.Message ), 0, (int)n, (Message)message);
    }

    void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$com_android_internal_telephony_RILRequest$release(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_RILRequest$__constructor__();
    }

    private RILRequest() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RILRequest$__constructor__(), 0, this);
    }

    static void resetSerial() {
        InvokeDynamicSupport.bootstrapStatic("resetSerial", $$robo$$com_android_internal_telephony_RILRequest$resetSerial(), 0);
    }

    String serialString() {
        return InvokeDynamicSupport.bootstrap("serialString", $$robo$$com_android_internal_telephony_RILRequest$serialString(), 0, this);
    }

    void onError(int n, Object object) {
        InvokeDynamicSupport.bootstrap("onError", $$robo$$com_android_internal_telephony_RILRequest$onError(int java.lang.Object ), 0, this, n, object);
    }

    static {
        RobolectricInternals.classInitializing(RILRequest.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RILRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

