/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Random;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RetryManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String LOG_TAG = "RetryManager";
    public static boolean DBG = false;
    public static boolean VDBG = false;
    private ArrayList<RetryRec> mRetryArray;
    private boolean mRetryForever;
    private int mMaxRetryCount;
    private int mCurMaxRetryCount;
    private int mRetryCount;
    private Random mRng;
    private String mConfig;

    private void $$robo$$com_android_internal_telephony_RetryManager$__constructor__() {
        this.mRetryArray = new ArrayList();
        this.mRng = new Random();
    }

    private final String $$robo$$com_android_internal_telephony_RetryManager$toString() {
        String ret = "RetryManager: { forever=" + this.mRetryForever + " maxRetry=" + this.mMaxRetryCount + " curMaxRetry=" + this.mCurMaxRetryCount + " retry=" + this.mRetryCount + " config={" + this.mConfig + "} retryArray={";
        for (RetryRec r : this.mRetryArray) {
            ret = ret + r.mDelayTime + ":" + r.mRandomizationTime + " ";
        }
        ret = ret + "}}";
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_RetryManager$configure(int maxRetryCount, int retryTime, int randomizationTime) {
        if (!this.validateNonNegativeInt("maxRetryCount", maxRetryCount)) {
            return false;
        }
        if (!this.validateNonNegativeInt("retryTime", retryTime)) {
            return false;
        }
        if (!this.validateNonNegativeInt("randomizationTime", randomizationTime)) {
            return false;
        }
        this.mCurMaxRetryCount = this.mMaxRetryCount = maxRetryCount;
        this.resetRetryCount();
        this.mRetryArray.clear();
        this.mRetryArray.add(new RetryRec(retryTime, randomizationTime));
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_RetryManager$configure(String configStr) {
        if (configStr.startsWith("\"") && configStr.endsWith("\"")) {
            configStr = configStr.substring(1, configStr.length() - 1);
        }
        this.mConfig = configStr;
        if (!TextUtils.isEmpty(configStr)) {
            int defaultRandomization = 0;
            this.mMaxRetryCount = 0;
            this.resetRetryCount();
            this.mRetryArray.clear();
            String[] strArray = configStr.split(",");
            for (int i = 0; i < strArray.length; ++i) {
                Pair<Boolean, Integer> value;
                String[] splitStr = strArray[i].split("=", 2);
                splitStr[0] = splitStr[0].trim();
                if (splitStr.length > 1) {
                    splitStr[1] = splitStr[1].trim();
                    if (TextUtils.equals(splitStr[0], "default_randomization")) {
                        value = this.parseNonNegativeInt(splitStr[0], splitStr[1]);
                        if (!((Boolean)value.first).booleanValue()) {
                            return false;
                        }
                        defaultRandomization = (Integer)value.second;
                        continue;
                    }
                    if (TextUtils.equals(splitStr[0], "max_retries")) {
                        if (TextUtils.equals("infinite", splitStr[1])) {
                            this.mRetryForever = true;
                            continue;
                        }
                        value = this.parseNonNegativeInt(splitStr[0], splitStr[1]);
                        if (!((Boolean)value.first).booleanValue()) {
                            return false;
                        }
                        this.mMaxRetryCount = (Integer)value.second;
                        continue;
                    }
                    Rlog.e("RetryManager", "Unrecognized configuration name value pair: " + strArray[i]);
                    return false;
                }
                splitStr = strArray[i].split(":", 2);
                splitStr[0] = splitStr[0].trim();
                RetryRec rr = new RetryRec(0, 0);
                value = this.parseNonNegativeInt("delayTime", splitStr[0]);
                if (!((Boolean)value.first).booleanValue()) {
                    return false;
                }
                rr.mDelayTime = (Integer)value.second;
                if (splitStr.length > 1) {
                    splitStr[1] = splitStr[1].trim();
                    value = this.parseNonNegativeInt("randomizationTime", splitStr[1]);
                    if (!((Boolean)value.first).booleanValue()) {
                        return false;
                    }
                    rr.mRandomizationTime = (Integer)value.second;
                } else {
                    rr.mRandomizationTime = defaultRandomization;
                }
                this.mRetryArray.add(rr);
            }
            if (this.mRetryArray.size() > this.mMaxRetryCount) {
                this.mMaxRetryCount = this.mRetryArray.size();
            }
            this.mCurMaxRetryCount = this.mMaxRetryCount;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_RetryManager$isRetryNeeded() {
        boolean retVal = this.mRetryForever || this.mRetryCount < this.mCurMaxRetryCount;
        return retVal;
    }

    private final int $$robo$$com_android_internal_telephony_RetryManager$getRetryTimer() {
        int index = this.mRetryCount < this.mRetryArray.size() ? this.mRetryCount : this.mRetryArray.size() - 1;
        int retVal = index >= 0 && index < this.mRetryArray.size() ? this.mRetryArray.get((int)index).mDelayTime + this.nextRandomizationTime(index) : 0;
        return retVal;
    }

    private final int $$robo$$com_android_internal_telephony_RetryManager$getRetryCount() {
        return this.mRetryCount;
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$increaseRetryCount() {
        ++this.mRetryCount;
        if (this.mRetryCount > this.mCurMaxRetryCount) {
            this.mRetryCount = this.mCurMaxRetryCount;
        }
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$setRetryCount(int count) {
        this.mRetryCount = count;
        if (this.mRetryCount > this.mCurMaxRetryCount) {
            this.mRetryCount = this.mCurMaxRetryCount;
        }
        if (this.mRetryCount < 0) {
            this.mRetryCount = 0;
        }
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$setCurMaxRetryCount(int count) {
        this.mCurMaxRetryCount = count;
        if (this.mCurMaxRetryCount < 0) {
            this.mCurMaxRetryCount = 0;
        }
        this.setRetryCount(this.mRetryCount);
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$restoreCurMaxRetryCount() {
        this.mCurMaxRetryCount = this.mMaxRetryCount;
        this.setRetryCount(this.mRetryCount);
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$setRetryForever(boolean retryForever) {
        this.mRetryForever = retryForever;
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$resetRetryCount() {
        this.mRetryCount = 0;
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$retryForeverUsingLastTimeout() {
        this.mRetryCount = this.mCurMaxRetryCount;
        this.mRetryForever = true;
    }

    private final boolean $$robo$$com_android_internal_telephony_RetryManager$isRetryForever() {
        return this.mRetryForever;
    }

    private final Pair<Boolean, Integer> $$robo$$com_android_internal_telephony_RetryManager$parseNonNegativeInt(String name, String stringValue) {
        Pair<Boolean, Integer> retVal;
        try {
            int value = Integer.parseInt(stringValue);
            retVal = new Pair<Boolean, Integer>(this.validateNonNegativeInt(name, value), value);
        }
        catch (NumberFormatException e) {
            Rlog.e("RetryManager", name + " bad value: " + stringValue, e);
            retVal = new Pair<Boolean, Integer>(false, 0);
        }
        return retVal;
    }

    private final boolean $$robo$$com_android_internal_telephony_RetryManager$validateNonNegativeInt(String name, int value) {
        boolean retVal;
        if (value < 0) {
            Rlog.e("RetryManager", name + " bad value: is < 0");
            retVal = false;
        } else {
            retVal = true;
        }
        return retVal;
    }

    private final int $$robo$$com_android_internal_telephony_RetryManager$nextRandomizationTime(int index) {
        int randomTime = this.mRetryArray.get((int)index).mRandomizationTime;
        if (randomTime == 0) {
            return 0;
        }
        return this.mRng.nextInt(randomTime);
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$log(String s) {
        Rlog.d("RetryManager", "[RM] " + s);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_RetryManager$__constructor__();
    }

    public RetryManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RetryManager$__constructor__(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_RetryManager$toString(), 0, this);
    }

    public boolean configure(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("configure", $$robo$$com_android_internal_telephony_RetryManager$configure(int int int ), 0, this, n, n2, n3);
    }

    public boolean configure(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("configure", $$robo$$com_android_internal_telephony_RetryManager$configure(java.lang.String ), 0, this, string2);
    }

    public boolean isRetryNeeded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRetryNeeded", $$robo$$com_android_internal_telephony_RetryManager$isRetryNeeded(), 0, this);
    }

    public int getRetryTimer() {
        return (int)InvokeDynamicSupport.bootstrap("getRetryTimer", $$robo$$com_android_internal_telephony_RetryManager$getRetryTimer(), 0, this);
    }

    public int getRetryCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRetryCount", $$robo$$com_android_internal_telephony_RetryManager$getRetryCount(), 0, this);
    }

    public void increaseRetryCount() {
        InvokeDynamicSupport.bootstrap("increaseRetryCount", $$robo$$com_android_internal_telephony_RetryManager$increaseRetryCount(), 0, this);
    }

    public void setRetryCount(int n) {
        InvokeDynamicSupport.bootstrap("setRetryCount", $$robo$$com_android_internal_telephony_RetryManager$setRetryCount(int ), 0, this, n);
    }

    public void setCurMaxRetryCount(int n) {
        InvokeDynamicSupport.bootstrap("setCurMaxRetryCount", $$robo$$com_android_internal_telephony_RetryManager$setCurMaxRetryCount(int ), 0, this, n);
    }

    public void restoreCurMaxRetryCount() {
        InvokeDynamicSupport.bootstrap("restoreCurMaxRetryCount", $$robo$$com_android_internal_telephony_RetryManager$restoreCurMaxRetryCount(), 0, this);
    }

    public void setRetryForever(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRetryForever", $$robo$$com_android_internal_telephony_RetryManager$setRetryForever(boolean ), 0, this, bl);
    }

    public void resetRetryCount() {
        InvokeDynamicSupport.bootstrap("resetRetryCount", $$robo$$com_android_internal_telephony_RetryManager$resetRetryCount(), 0, this);
    }

    public void retryForeverUsingLastTimeout() {
        InvokeDynamicSupport.bootstrap("retryForeverUsingLastTimeout", $$robo$$com_android_internal_telephony_RetryManager$retryForeverUsingLastTimeout(), 0, this);
    }

    public boolean isRetryForever() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRetryForever", $$robo$$com_android_internal_telephony_RetryManager$isRetryForever(), 0, this);
    }

    private Pair<Boolean, Integer> parseNonNegativeInt(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("parseNonNegativeInt", $$robo$$com_android_internal_telephony_RetryManager$parseNonNegativeInt(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private boolean validateNonNegativeInt(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("validateNonNegativeInt", $$robo$$com_android_internal_telephony_RetryManager$validateNonNegativeInt(java.lang.String int ), 0, this, string2, n);
    }

    private int nextRandomizationTime(int n) {
        return (int)InvokeDynamicSupport.bootstrap("nextRandomizationTime", $$robo$$com_android_internal_telephony_RetryManager$nextRandomizationTime(int ), 0, this, n);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_RetryManager$log(java.lang.String ), 0, this, string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RetryManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class RetryRec
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mDelayTime;
        int mRandomizationTime;

        private void $$robo$$com_android_internal_telephony_RetryManager_RetryRec$__constructor__(int delayTime, int randomizationTime) {
            this.mDelayTime = delayTime;
            this.mRandomizationTime = randomizationTime;
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_telephony_RetryManager_RetryRec$__constructor__(n, n2);
        }

        RetryRec(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RetryManager_RetryRec$__constructor__(int int ), 0, this, n, n2);
        }

        public /* synthetic */ RetryRec() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RetryRec)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

