/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.EventLog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.ImsSMSDispatcher;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SMSDispatcher
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "SMSDispatcher";
    static boolean DBG = false;
    private static String SEND_NEXT_MSG_EXTRA = "SendNextMsg";
    private static String SEND_SMS_NO_CONFIRMATION_PERMISSION = "android.permission.SEND_SMS_NO_CONFIRMATION";
    private static int PREMIUM_RULE_USE_SIM = 1;
    private static int PREMIUM_RULE_USE_NETWORK = 2;
    private static int PREMIUM_RULE_USE_BOTH = 3;
    private AtomicInteger mPremiumSmsRule;
    private SettingsObserver mSettingsObserver;
    protected static int EVENT_SEND_SMS_COMPLETE = 2;
    private static int EVENT_SEND_RETRY = 3;
    private static int EVENT_SEND_LIMIT_REACHED_CONFIRMATION = 4;
    static int EVENT_SEND_CONFIRMED_SMS = 5;
    static int EVENT_STOP_SENDING = 7;
    private static int EVENT_CONFIRM_SEND_TO_POSSIBLE_PREMIUM_SHORT_CODE = 8;
    private static int EVENT_CONFIRM_SEND_TO_PREMIUM_SHORT_CODE = 9;
    protected static int EVENT_HANDLE_STATUS_REPORT = 10;
    protected static int EVENT_RADIO_ON = 11;
    protected static int EVENT_IMS_STATE_CHANGED = 12;
    protected static int EVENT_IMS_STATE_DONE = 13;
    protected static int EVENT_NEW_ICC_SMS = 14;
    protected static int EVENT_ICC_CHANGED = 15;
    protected PhoneBase mPhone;
    protected Context mContext;
    protected ContentResolver mResolver;
    protected CommandsInterface mCi;
    protected TelephonyManager mTelephonyManager;
    private static int MAX_SEND_RETRIES = 3;
    private static int SEND_RETRY_DELAY = 2000;
    private static int SINGLE_PART_SMS = 1;
    private static int MO_MSG_QUEUE_LIMIT = 5;
    private static int sConcatenatedRef;
    private SmsUsageMonitor mUsageMonitor;
    private ImsSMSDispatcher mImsSMSDispatcher;
    private int mPendingTrackerCount;
    protected boolean mSmsCapable;
    protected boolean mSmsSendDisabled;
    protected ArrayList<SmsTracker> deliveryPendingList;
    protected List<SmsTracker> sendPendingList;

    private static final int $$robo$$com_android_internal_telephony_SMSDispatcher$getNextConcatenatedRef() {
        return ++sConcatenatedRef;
    }

    private void $$robo$$com_android_internal_telephony_SMSDispatcher$__constructor__(PhoneBase phone, SmsUsageMonitor usageMonitor, ImsSMSDispatcher imsSMSDispatcher) {
        this.mPremiumSmsRule = new AtomicInteger(1);
        this.mSmsCapable = true;
        this.deliveryPendingList = new ArrayList();
        this.sendPendingList = Collections.synchronizedList(new ArrayList());
        this.mPhone = phone;
        this.mImsSMSDispatcher = imsSMSDispatcher;
        this.mContext = phone.getContext();
        this.mResolver = this.mContext.getContentResolver();
        this.mCi = phone.mCi;
        this.mUsageMonitor = usageMonitor;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mSettingsObserver = new SettingsObserver(this, this.mPremiumSmsRule, this.mContext);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("sms_short_code_rule"), false, this.mSettingsObserver);
        this.mSmsCapable = this.mContext.getResources().getBoolean(17956932);
        this.mSmsSendDisabled = !SystemProperties.getBoolean("telephony.sms.send", this.mSmsCapable);
        Rlog.d("SMSDispatcher", "SMSDispatcher: ctor mSmsCapable=" + this.mSmsCapable + " format=" + this.getFormat() + " mSmsSendDisabled=" + this.mSmsSendDisabled);
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$updatePhoneObject(PhoneBase phone) {
        this.mPhone = phone;
        this.mUsageMonitor = phone.mSmsUsageMonitor;
        Rlog.d("SMSDispatcher", "Active phone changed to " + this.mPhone.getPhoneName());
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$dispose() {
        this.mContext.getContentResolver().unregisterContentObserver(this.mSettingsObserver);
    }

    protected abstract String getFormat();

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleStatusReport(Object o) {
        Rlog.d("SMSDispatcher", "handleStatusReport() called with no subclass.");
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleMessage(Message msg) {
        switch (msg.what) {
            case 2: {
                this.handleSendComplete((AsyncResult)msg.obj);
                break;
            }
            case 3: {
                Rlog.d("SMSDispatcher", "SMS retry..");
                this.sendRetrySms((SmsTracker)msg.obj);
                break;
            }
            case 4: {
                this.handleReachSentLimit((SmsTracker)msg.obj);
                break;
            }
            case 8: {
                this.handleConfirmShortCode(false, (SmsTracker)msg.obj);
                break;
            }
            case 9: {
                this.handleConfirmShortCode(true, (SmsTracker)msg.obj);
                break;
            }
            case 5: {
                SmsTracker tracker = (SmsTracker)msg.obj;
                if (tracker.isMultipart()) {
                    this.sendMultipartSms(tracker);
                } else {
                    tracker.mExpectMore = this.mPendingTrackerCount > 1;
                    this.sendSms(tracker);
                }
                --this.mPendingTrackerCount;
                break;
            }
            case 7: {
                SmsTracker tracker = (SmsTracker)msg.obj;
                tracker.onFailed(this.mContext, 5, 0);
                --this.mPendingTrackerCount;
                break;
            }
            case 10: {
                this.handleStatusReport(msg.obj);
                break;
            }
            default: {
                Rlog.e("SMSDispatcher", "handleMessage() ignoring message of unexpected type " + msg.what);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleSendComplete(AsyncResult ar) {
        SmsTracker tracker = (SmsTracker)ar.userObj;
        PendingIntent sentIntent = tracker.mSentIntent;
        if (ar.result != null) {
            tracker.mMessageRef = ((SmsResponse)ar.result).mMessageRef;
        } else {
            Rlog.d("SMSDispatcher", "SmsResponse was null");
        }
        if (ar.exception == null) {
            if (tracker.mDeliveryIntent != null) {
                this.deliveryPendingList.add(tracker);
            }
            tracker.onSent(this.mContext);
        } else {
            int ss = this.mPhone.getServiceState().getState();
            if (tracker.mImsRetry > 0 && ss != 0) {
                tracker.mRetryCount = 3;
                Rlog.d("SMSDispatcher", "handleSendComplete: Skipping retry:  isIms()=" + this.isIms() + " mRetryCount=" + tracker.mRetryCount + " mImsRetry=" + tracker.mImsRetry + " mMessageRef=" + tracker.mMessageRef + " SS= " + this.mPhone.getServiceState().getState());
            }
            if (!this.isIms() && ss != 0) {
                tracker.onFailed(this.mContext, SMSDispatcher.getNotInServiceError(ss), 0);
            } else if (((CommandException)ar.exception).getCommandError() == CommandException.Error.SMS_FAIL_RETRY && tracker.mRetryCount < 3) {
                ++tracker.mRetryCount;
                Message retryMsg = this.obtainMessage(3, tracker);
                this.sendMessageDelayed(retryMsg, 2000L);
            } else {
                int errorCode = 0;
                if (ar.result != null) {
                    errorCode = ((SmsResponse)ar.result).mErrorCode;
                }
                int error = 1;
                if (((CommandException)ar.exception).getCommandError() == CommandException.Error.FDN_CHECK_FAILURE) {
                    error = 6;
                }
                tracker.onFailed(this.mContext, error, errorCode);
            }
        }
    }

    private static final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleNotInService(int ss, PendingIntent sentIntent) {
        if (sentIntent != null) {
            try {
                if (ss == 3) {
                    sentIntent.send(2);
                } else {
                    sentIntent.send(4);
                }
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    private static final int $$robo$$com_android_internal_telephony_SMSDispatcher$getNotInServiceError(int ss) {
        if (ss == 3) {
            return 2;
        }
        return 4;
    }

    protected abstract void sendData(String var1, String var2, int var3, byte[] var4, PendingIntent var5, PendingIntent var6);

    protected abstract void sendText(String var1, String var2, String var3, PendingIntent var4, PendingIntent var5, Uri var6, String var7);

    protected abstract void injectSmsPdu(byte[] var1, String var2, PendingIntent var3);

    protected abstract GsmAlphabet.TextEncodingDetails calculateLength(CharSequence var1, boolean var2);

    protected abstract void updateSmsSendStatus(int var1, boolean var2);

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendMultipartText(String destAddr, String scAddr, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents, Uri messageUri, String callingPkg) {
        if (messageUri == null) {
            if (SmsApplication.shouldWriteMessageForPackage(callingPkg, this.mContext)) {
                messageUri = this.writeOutboxMessage(this.getSubId(), destAddr, this.getMultipartMessageText(parts), deliveryIntents != null && deliveryIntents.size() > 0, callingPkg);
            }
        } else {
            this.moveToOutbox(this.getSubId(), messageUri, callingPkg);
        }
        int refNumber = SMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int msgCount = parts.size();
        int encoding = 0;
        GsmAlphabet.TextEncodingDetails[] encodingForParts = new GsmAlphabet.TextEncodingDetails[msgCount];
        for (int i = 0; i < msgCount; ++i) {
            GsmAlphabet.TextEncodingDetails details = this.calculateLength(parts.get(i), false);
            if (encoding != details.codeUnitSize && (encoding == 0 || encoding == 1)) {
                encoding = details.codeUnitSize;
            }
            encodingForParts[i] = details;
        }
        AtomicInteger unsentPartCount = new AtomicInteger(msgCount);
        AtomicBoolean anyPartFailed = new AtomicBoolean(false);
        for (int i = 0; i < msgCount; ++i) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = refNumber;
            concatRef.seqNumber = i + 1;
            concatRef.msgCount = msgCount;
            concatRef.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            if (encoding == 1) {
                smsHeader.languageTable = encodingForParts[i].languageTable;
                smsHeader.languageShiftTable = encodingForParts[i].languageShiftTable;
            }
            PendingIntent sentIntent = null;
            if (sentIntents != null && sentIntents.size() > i) {
                sentIntent = sentIntents.get(i);
            }
            PendingIntent deliveryIntent = null;
            if (deliveryIntents != null && deliveryIntents.size() > i) {
                deliveryIntent = deliveryIntents.get(i);
            }
            this.sendNewSubmitPdu(destAddr, scAddr, parts.get(i), smsHeader, encoding, sentIntent, deliveryIntent, i == msgCount - 1, unsentPartCount, anyPartFailed, messageUri);
        }
    }

    protected abstract void sendNewSubmitPdu(String var1, String var2, String var3, SmsHeader var4, int var5, PendingIntent var6, PendingIntent var7, boolean var8, AtomicInteger var9, AtomicBoolean var10, Uri var11);

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendRawPdu(SmsTracker tracker) {
        PackageInfo appInfo;
        HashMap<String, Object> map = tracker.mData;
        byte[] pdu = (byte[])map.get("pdu");
        if (this.mSmsSendDisabled) {
            Rlog.e("SMSDispatcher", "Device does not support sending sms.");
            tracker.onFailed(this.mContext, 4, 0);
            return;
        }
        if (pdu == null) {
            Rlog.e("SMSDispatcher", "Empty PDU");
            tracker.onFailed(this.mContext, 3, 0);
            return;
        }
        PackageManager pm = this.mContext.getPackageManager();
        String[] packageNames = pm.getPackagesForUid(Binder.getCallingUid());
        if (packageNames == null || packageNames.length == 0) {
            Rlog.e("SMSDispatcher", "Can't get calling app package name: refusing to send SMS");
            tracker.onFailed(this.mContext, 1, 0);
            return;
        }
        try {
            appInfo = pm.getPackageInfo(packageNames[0], 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e("SMSDispatcher", "Can't get calling app package info: refusing to send SMS");
            tracker.onFailed(this.mContext, 1, 0);
            return;
        }
        if (this.checkDestination(tracker)) {
            if (!this.mUsageMonitor.check(appInfo.packageName, 1)) {
                this.sendMessage(this.obtainMessage(4, tracker));
                return;
            }
            this.sendSms(tracker);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_SMSDispatcher$checkDestination(SmsTracker tracker) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.SEND_SMS_NO_CONFIRMATION") == 0) {
            return true;
        }
        int rule = this.mPremiumSmsRule.get();
        int smsCategory = 0;
        if (rule == 1 || rule == 3) {
            String simCountryIso = this.mTelephonyManager.getSimCountryIso();
            if (simCountryIso == null || simCountryIso.length() != 2) {
                Rlog.e("SMSDispatcher", "Can't get SIM country Iso: trying network country Iso");
                simCountryIso = this.mTelephonyManager.getNetworkCountryIso();
            }
            smsCategory = this.mUsageMonitor.checkDestination(tracker.mDestAddress, simCountryIso);
        }
        if (rule == 2 || rule == 3) {
            String networkCountryIso = this.mTelephonyManager.getNetworkCountryIso();
            if (networkCountryIso == null || networkCountryIso.length() != 2) {
                Rlog.e("SMSDispatcher", "Can't get Network country Iso: trying SIM country Iso");
                networkCountryIso = this.mTelephonyManager.getSimCountryIso();
            }
            smsCategory = SmsUsageMonitor.mergeShortCodeCategories(smsCategory, this.mUsageMonitor.checkDestination(tracker.mDestAddress, networkCountryIso));
        }
        if (smsCategory == 0 || smsCategory == 1 || smsCategory == 2) {
            return true;
        }
        int premiumSmsPermission = this.mUsageMonitor.getPremiumSmsPermission(tracker.mAppInfo.packageName);
        if (premiumSmsPermission == 0) {
            premiumSmsPermission = 1;
        }
        switch (premiumSmsPermission) {
            case 3: {
                Rlog.d("SMSDispatcher", "User approved this app to send to premium SMS");
                return true;
            }
            case 2: {
                Rlog.w("SMSDispatcher", "User denied this app from sending to premium SMS");
                this.sendMessage(this.obtainMessage(7, tracker));
                return false;
            }
        }
        int event = smsCategory == 3 ? 8 : 9;
        this.sendMessage(this.obtainMessage(event, tracker));
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_SMSDispatcher$denyIfQueueLimitReached(SmsTracker tracker) {
        if (this.mPendingTrackerCount >= 5) {
            Rlog.e("SMSDispatcher", "Denied because queue limit reached");
            tracker.onFailed(this.mContext, 5, 0);
            return true;
        }
        ++this.mPendingTrackerCount;
        return false;
    }

    private final CharSequence $$robo$$com_android_internal_telephony_SMSDispatcher$getAppLabel(String appPackage) {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(appPackage, 0);
            return appInfo.loadLabel(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e("SMSDispatcher", "PackageManager Name Not Found for package " + appPackage);
            return appPackage;
        }
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleReachSentLimit(SmsTracker tracker) {
        if (this.denyIfQueueLimitReached(tracker)) {
            return;
        }
        CharSequence appLabel = this.getAppLabel(tracker.mAppInfo.packageName);
        Resources r = Resources.getSystem();
        Spanned messageText = Html.fromHtml(r.getString(17040571, appLabel));
        ConfirmDialogListener listener = new ConfirmDialogListener(this, tracker, null);
        AlertDialog d = new AlertDialog.Builder(this.mContext).setTitle(17040570).setIcon(17301642).setMessage(messageText).setPositiveButton(r.getString(17040572), (DialogInterface.OnClickListener)listener).setNegativeButton(r.getString(17040573), (DialogInterface.OnClickListener)listener).setOnCancelListener(listener).create();
        d.getWindow().setType(2003);
        d.show();
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleConfirmShortCode(boolean isPremium, SmsTracker tracker) {
        if (this.denyIfQueueLimitReached(tracker)) {
            return;
        }
        int detailsId = isPremium ? 17040576 : 17040575;
        CharSequence appLabel = this.getAppLabel(tracker.mAppInfo.packageName);
        Resources r = Resources.getSystem();
        Spanned messageText = Html.fromHtml(r.getString(17040574, appLabel, tracker.mDestAddress));
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View layout2 = inflater.inflate(17367245, null);
        ConfirmDialogListener listener = new ConfirmDialogListener(this, tracker, (TextView)layout2.findViewById(16909197));
        TextView messageView = (TextView)layout2.findViewById(16909191);
        messageView.setText(messageText);
        ViewGroup detailsLayout = (ViewGroup)layout2.findViewById(16909192);
        TextView detailsView = (TextView)detailsLayout.findViewById(16909194);
        detailsView.setText(detailsId);
        CheckBox rememberChoice = (CheckBox)layout2.findViewById(16909195);
        rememberChoice.setOnCheckedChangeListener(listener);
        AlertDialog d = new AlertDialog.Builder(this.mContext).setView(layout2).setPositiveButton(r.getString(17040577), (DialogInterface.OnClickListener)listener).setNegativeButton(r.getString(17040578), (DialogInterface.OnClickListener)listener).setOnCancelListener(listener).create();
        d.getWindow().setType(2003);
        d.show();
        listener.setPositiveButton(d.getButton(-1));
        listener.setNegativeButton(d.getButton(-2));
    }

    private final int $$robo$$com_android_internal_telephony_SMSDispatcher$getPremiumSmsPermission(String packageName) {
        return this.mUsageMonitor.getPremiumSmsPermission(packageName);
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$setPremiumSmsPermission(String packageName, int permission2) {
        this.mUsageMonitor.setPremiumSmsPermission(packageName, permission2);
    }

    protected abstract void sendSms(SmsTracker var1);

    protected abstract void sendSmsByPstn(SmsTracker var1);

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendRetrySms(SmsTracker tracker) {
        if (this.mImsSMSDispatcher != null) {
            this.mImsSMSDispatcher.sendRetrySms(tracker);
        } else {
            Rlog.e("SMSDispatcher", this.mImsSMSDispatcher + " is null. Retry failed");
        }
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendMultipartSms(SmsTracker tracker) {
        HashMap<String, Object> map = tracker.mData;
        String destinationAddress = (String)map.get("destination");
        String scAddress = (String)map.get("scaddress");
        ArrayList parts = (ArrayList)map.get("parts");
        ArrayList sentIntents = (ArrayList)map.get("sentIntents");
        ArrayList deliveryIntents = (ArrayList)map.get("deliveryIntents");
        int ss = this.mPhone.getServiceState().getState();
        if (!this.isIms() && ss != 0) {
            int count = parts.size();
            for (int i = 0; i < count; ++i) {
                PendingIntent sentIntent = null;
                if (sentIntents != null && sentIntents.size() > i) {
                    sentIntent = (PendingIntent)sentIntents.get(i);
                }
                SMSDispatcher.handleNotInService(ss, sentIntent);
            }
            return;
        }
        this.sendMultipartText(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, null, null);
    }

    private final SmsTracker $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTracker(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, String format, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri, SmsHeader smsHeader, boolean isExpectMore) {
        PackageManager pm = this.mContext.getPackageManager();
        String[] packageNames = pm.getPackagesForUid(Binder.getCallingUid());
        PackageInfo appInfo = null;
        if (packageNames != null && packageNames.length > 0) {
            try {
                appInfo = pm.getPackageInfo(packageNames[0], 64);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        String destAddr = PhoneNumberUtils.extractNetworkPortion((String)data.get("destAddr"));
        return new SmsTracker(data, sentIntent, deliveryIntent, appInfo, destAddr, format, unsentPartCount, anyPartFailed, messageUri, smsHeader, isExpectMore);
    }

    private final SmsTracker $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTracker(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, String format, Uri messageUri, boolean isExpectMore) {
        return this.getSmsTracker(data, sentIntent, deliveryIntent, format, null, null, messageUri, null, isExpectMore);
    }

    private final HashMap<String, Object> $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTrackerMap(String destAddr, String scAddr, String text, SmsMessageBase.SubmitPduBase pdu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destAddr", destAddr);
        map.put("scAddr", scAddr);
        map.put("text", text);
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        return map;
    }

    private final HashMap<String, Object> $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTrackerMap(String destAddr, String scAddr, int destPort, byte[] data, SmsMessageBase.SubmitPduBase pdu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destAddr", destAddr);
        map.put("scAddr", scAddr);
        map.put("destPort", destPort);
        map.put("data", data);
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        return map;
    }

    private final boolean $$robo$$com_android_internal_telephony_SMSDispatcher$isIms() {
        if (this.mImsSMSDispatcher != null) {
            return this.mImsSMSDispatcher.isIms();
        }
        Rlog.e("SMSDispatcher", this.mImsSMSDispatcher + " is null");
        return false;
    }

    private final String $$robo$$com_android_internal_telephony_SMSDispatcher$getImsSmsFormat() {
        if (this.mImsSMSDispatcher != null) {
            return this.mImsSMSDispatcher.getImsSmsFormat();
        }
        Rlog.e("SMSDispatcher", this.mImsSMSDispatcher + " is null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Uri $$robo$$com_android_internal_telephony_SMSDispatcher$writeOutboxMessage(long subId, String address, String text, boolean requireDeliveryReport, String creator) {
        ContentValues values = new ContentValues(8);
        values.put("sub_id", subId);
        values.put("address", address);
        values.put("body", text);
        values.put("date", (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        values.put("seen", 1);
        values.put("read", 1);
        if (!TextUtils.isEmpty(creator)) {
            values.put("creator", creator);
        }
        if (requireDeliveryReport) {
            values.put("status", 32);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Uri uri;
            Uri uri2 = uri = this.mContext.getContentResolver().insert(Telephony.Sms.Outbox.CONTENT_URI, values);
            return uri2;
        }
        catch (Exception e) {
            Rlog.e("SMSDispatcher", "writeOutboxMessage: Failed to persist outbox message", e);
            Uri uri = null;
            return uri;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$moveToOutbox(long subId, Uri messageUri, String creator) {
        ContentValues values = new ContentValues(4);
        values.put("sub_id", subId);
        if (!TextUtils.isEmpty(creator)) {
            values.put("creator", creator);
        }
        values.put("date", (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        values.put("type", 4);
        long identity = Binder.clearCallingIdentity();
        try {
            if (this.mContext.getContentResolver().update(messageUri, values, null, null) != 1) {
                Rlog.e("SMSDispatcher", "moveToOutbox: failed to update message " + messageUri);
            }
        }
        catch (Exception e) {
            Rlog.e("SMSDispatcher", "moveToOutbox: Failed to update message", e);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private final String $$robo$$com_android_internal_telephony_SMSDispatcher$getMultipartMessageText(ArrayList<String> parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part == null) continue;
            sb.append(part);
        }
        return sb.toString();
    }

    private final String $$robo$$com_android_internal_telephony_SMSDispatcher$getCarrierAppPackageName(Intent intent) {
        UiccCard card = UiccController.getInstance().getUiccCard();
        if (card == null) {
            return null;
        }
        List<String> carrierPackages = card.getCarrierPackageNamesForIntent(this.mContext.getPackageManager(), intent);
        return carrierPackages != null && carrierPackages.size() == 1 ? carrierPackages.get(0) : null;
    }

    private final long $$robo$$com_android_internal_telephony_SMSDispatcher$getSubId() {
        return SubscriptionController.getInstance().getSubIdUsingPhoneId(this.mPhone.mPhoneId);
    }

    static void __staticInitializer__() {
        sConcatenatedRef = new Random().nextInt(256);
    }

    protected static int getNextConcatenatedRef() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNextConcatenatedRef", $$robo$$com_android_internal_telephony_SMSDispatcher$getNextConcatenatedRef(), 0);
    }

    private void __constructor__(PhoneBase phoneBase, SmsUsageMonitor smsUsageMonitor, ImsSMSDispatcher imsSMSDispatcher) {
        this.$$robo$$com_android_internal_telephony_SMSDispatcher$__constructor__(phoneBase, smsUsageMonitor, imsSMSDispatcher);
    }

    protected SMSDispatcher(PhoneBase phoneBase, SmsUsageMonitor smsUsageMonitor, ImsSMSDispatcher imsSMSDispatcher) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher$__constructor__(com.android.internal.telephony.PhoneBase com.android.internal.telephony.SmsUsageMonitor com.android.internal.telephony.ImsSMSDispatcher ), 0, this, phoneBase, smsUsageMonitor, imsSMSDispatcher);
    }

    protected void updatePhoneObject(PhoneBase phoneBase) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_SMSDispatcher$updatePhoneObject(com.android.internal.telephony.PhoneBase ), 0, this, phoneBase);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_SMSDispatcher$dispose(), 0, this);
    }

    protected void handleStatusReport(Object object) {
        InvokeDynamicSupport.bootstrap("handleStatusReport", $$robo$$com_android_internal_telephony_SMSDispatcher$handleStatusReport(java.lang.Object ), 0, this, object);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_SMSDispatcher$handleMessage(android.os.Message ), 0, this, message);
    }

    protected void handleSendComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleSendComplete", $$robo$$com_android_internal_telephony_SMSDispatcher$handleSendComplete(android.os.AsyncResult ), 0, this, asyncResult);
    }

    protected static void handleNotInService(int n, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrapStatic("handleNotInService", $$robo$$com_android_internal_telephony_SMSDispatcher$handleNotInService(int android.app.PendingIntent ), 0, (int)n, (PendingIntent)pendingIntent);
    }

    protected static int getNotInServiceError(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNotInServiceError", $$robo$$com_android_internal_telephony_SMSDispatcher$getNotInServiceError(int ), 0, (int)n);
    }

    protected void sendMultipartText(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3, Uri uri, String string4) {
        InvokeDynamicSupport.bootstrap("sendMultipartText", $$robo$$com_android_internal_telephony_SMSDispatcher$sendMultipartText(java.lang.String java.lang.String java.util.ArrayList<java.lang.String> java.util.ArrayList<android.app.PendingIntent> java.util.ArrayList<android.app.PendingIntent> android.net.Uri java.lang.String ), 0, this, string2, string3, arrayList, arrayList2, arrayList3, uri, string4);
    }

    protected void sendRawPdu(SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendRawPdu", $$robo$$com_android_internal_telephony_SMSDispatcher$sendRawPdu(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    boolean checkDestination(SmsTracker smsTracker) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkDestination", $$robo$$com_android_internal_telephony_SMSDispatcher$checkDestination(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    private boolean denyIfQueueLimitReached(SmsTracker smsTracker) {
        return (boolean)InvokeDynamicSupport.bootstrap("denyIfQueueLimitReached", $$robo$$com_android_internal_telephony_SMSDispatcher$denyIfQueueLimitReached(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    private CharSequence getAppLabel(String string2) {
        return InvokeDynamicSupport.bootstrap("getAppLabel", $$robo$$com_android_internal_telephony_SMSDispatcher$getAppLabel(java.lang.String ), 0, this, string2);
    }

    protected void handleReachSentLimit(SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("handleReachSentLimit", $$robo$$com_android_internal_telephony_SMSDispatcher$handleReachSentLimit(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    protected void handleConfirmShortCode(boolean bl, SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("handleConfirmShortCode", $$robo$$com_android_internal_telephony_SMSDispatcher$handleConfirmShortCode(boolean com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, bl, smsTracker);
    }

    public int getPremiumSmsPermission(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getPremiumSmsPermission", $$robo$$com_android_internal_telephony_SMSDispatcher$getPremiumSmsPermission(java.lang.String ), 0, this, string2);
    }

    public void setPremiumSmsPermission(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setPremiumSmsPermission", $$robo$$com_android_internal_telephony_SMSDispatcher$setPremiumSmsPermission(java.lang.String int ), 0, this, string2, n);
    }

    public void sendRetrySms(SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendRetrySms", $$robo$$com_android_internal_telephony_SMSDispatcher$sendRetrySms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    private void sendMultipartSms(SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendMultipartSms", $$robo$$com_android_internal_telephony_SMSDispatcher$sendMultipartSms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    protected SmsTracker getSmsTracker(HashMap<String, Object> hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, String string2, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, SmsHeader smsHeader, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getSmsTracker", $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTracker(java.util.HashMap<java.lang.String, java.lang.Object> android.app.PendingIntent android.app.PendingIntent java.lang.String java.util.concurrent.atomic.AtomicInteger java.util.concurrent.atomic.AtomicBoolean android.net.Uri com.android.internal.telephony.SmsHeader boolean ), 0, this, hashMap, pendingIntent, pendingIntent2, string2, atomicInteger, atomicBoolean, uri, smsHeader, bl);
    }

    protected SmsTracker getSmsTracker(HashMap<String, Object> hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, String string2, Uri uri, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getSmsTracker", $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTracker(java.util.HashMap<java.lang.String, java.lang.Object> android.app.PendingIntent android.app.PendingIntent java.lang.String android.net.Uri boolean ), 0, this, hashMap, pendingIntent, pendingIntent2, string2, uri, bl);
    }

    protected HashMap<String, Object> getSmsTrackerMap(String string2, String string3, String string4, SmsMessageBase.SubmitPduBase submitPduBase) {
        return InvokeDynamicSupport.bootstrap("getSmsTrackerMap", $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTrackerMap(java.lang.String java.lang.String java.lang.String com.android.internal.telephony.SmsMessageBase$SubmitPduBase ), 0, this, string2, string3, string4, submitPduBase);
    }

    protected HashMap<String, Object> getSmsTrackerMap(String string2, String string3, int n, byte[] byArray, SmsMessageBase.SubmitPduBase submitPduBase) {
        return InvokeDynamicSupport.bootstrap("getSmsTrackerMap", $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTrackerMap(java.lang.String java.lang.String int byte[] com.android.internal.telephony.SmsMessageBase$SubmitPduBase ), 0, this, string2, string3, n, byArray, submitPduBase);
    }

    public boolean isIms() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIms", $$robo$$com_android_internal_telephony_SMSDispatcher$isIms(), 0, this);
    }

    public String getImsSmsFormat() {
        return InvokeDynamicSupport.bootstrap("getImsSmsFormat", $$robo$$com_android_internal_telephony_SMSDispatcher$getImsSmsFormat(), 0, this);
    }

    protected Uri writeOutboxMessage(long l, String string2, String string3, boolean bl, String string4) {
        return InvokeDynamicSupport.bootstrap("writeOutboxMessage", $$robo$$com_android_internal_telephony_SMSDispatcher$writeOutboxMessage(long java.lang.String java.lang.String boolean java.lang.String ), 0, this, l, string2, string3, bl, string4);
    }

    protected void moveToOutbox(long l, Uri uri, String string2) {
        InvokeDynamicSupport.bootstrap("moveToOutbox", $$robo$$com_android_internal_telephony_SMSDispatcher$moveToOutbox(long android.net.Uri java.lang.String ), 0, this, l, uri, string2);
    }

    private String getMultipartMessageText(ArrayList<String> arrayList) {
        return InvokeDynamicSupport.bootstrap("getMultipartMessageText", $$robo$$com_android_internal_telephony_SMSDispatcher$getMultipartMessageText(java.util.ArrayList<java.lang.String> ), 0, this, arrayList);
    }

    protected String getCarrierAppPackageName(Intent intent) {
        return InvokeDynamicSupport.bootstrap("getCarrierAppPackageName", $$robo$$com_android_internal_telephony_SMSDispatcher$getCarrierAppPackageName(android.content.Intent ), 0, this, intent);
    }

    protected long getSubId() {
        return (long)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$com_android_internal_telephony_SMSDispatcher$getSubId(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(SMSDispatcher.class);
    }

    public /* synthetic */ SMSDispatcher() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SMSDispatcher)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ConfirmDialogListener
    implements DialogInterface.OnClickListener,
    DialogInterface.OnCancelListener,
    CompoundButton.OnCheckedChangeListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SmsTracker mTracker;
        private Button mPositiveButton;
        private Button mNegativeButton;
        private boolean mRememberChoice;
        private TextView mRememberUndoInstruction;
        /* synthetic */ SMSDispatcher this$0;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$__constructor__(SMSDispatcher sMSDispatcher, SmsTracker tracker, TextView textView) {
            this.mTracker = tracker;
            this.mRememberUndoInstruction = textView;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$setPositiveButton(Button button) {
            this.mPositiveButton = button;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$setNegativeButton(Button button) {
            this.mNegativeButton = button;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onClick(DialogInterface dialog, int which) {
            int newSmsPermission = 1;
            if (which == -1) {
                Rlog.d("SMSDispatcher", "CONFIRM sending SMS");
                EventLog.writeEvent(50128, this.mTracker.mAppInfo.applicationInfo == null ? -1 : this.mTracker.mAppInfo.applicationInfo.uid);
                this.this$0.sendMessage(this.this$0.obtainMessage(5, this.mTracker));
                if (this.mRememberChoice) {
                    newSmsPermission = 3;
                }
            } else if (which == -2) {
                Rlog.d("SMSDispatcher", "DENY sending SMS");
                EventLog.writeEvent(50125, this.mTracker.mAppInfo.applicationInfo == null ? -1 : this.mTracker.mAppInfo.applicationInfo.uid);
                this.this$0.sendMessage(this.this$0.obtainMessage(7, this.mTracker));
                if (this.mRememberChoice) {
                    newSmsPermission = 2;
                }
            }
            this.this$0.setPremiumSmsPermission(this.mTracker.mAppInfo.packageName, newSmsPermission);
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onCancel(DialogInterface dialog) {
            Rlog.d("SMSDispatcher", "dialog dismissed: don't send SMS");
            this.this$0.sendMessage(this.this$0.obtainMessage(7, this.mTracker));
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            Rlog.d("SMSDispatcher", "remember this choice: " + isChecked);
            this.mRememberChoice = isChecked;
            if (isChecked) {
                this.mPositiveButton.setText(17040581);
                this.mNegativeButton.setText(17040582);
                if (this.mRememberUndoInstruction != null) {
                    this.mRememberUndoInstruction.setText(17040580);
                    this.mRememberUndoInstruction.setPadding(0, 0, 0, 32);
                }
            } else {
                this.mPositiveButton.setText(17040577);
                this.mNegativeButton.setText(17040578);
                if (this.mRememberUndoInstruction != null) {
                    this.mRememberUndoInstruction.setText("");
                    this.mRememberUndoInstruction.setPadding(0, 0, 0, 0);
                }
            }
        }

        private void __constructor__(SMSDispatcher sMSDispatcher, SmsTracker smsTracker, TextView textView) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$__constructor__(sMSDispatcher, smsTracker, textView);
        }

        ConfirmDialogListener(SMSDispatcher sMSDispatcher, SmsTracker smsTracker, TextView textView) {
            this.this$0 = sMSDispatcher;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$__constructor__(com.android.internal.telephony.SMSDispatcher com.android.internal.telephony.SMSDispatcher$SmsTracker android.widget.TextView ), 0, this, sMSDispatcher, smsTracker, textView);
        }

        void setPositiveButton(Button button) {
            InvokeDynamicSupport.bootstrap("setPositiveButton", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$setPositiveButton(android.widget.Button ), 0, this, button);
        }

        void setNegativeButton(Button button) {
            InvokeDynamicSupport.bootstrap("setNegativeButton", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$setNegativeButton(android.widget.Button ), 0, this, button);
        }

        @Override
        public void onClick(DialogInterface dialogInterface, int n) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
        }

        @Override
        public void onCancel(DialogInterface dialogInterface) {
            InvokeDynamicSupport.bootstrap("onCancel", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onCancel(android.content.DialogInterface ), 0, this, dialogInterface);
        }

        @Override
        public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
            InvokeDynamicSupport.bootstrap("onCheckedChanged", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onCheckedChanged(android.widget.CompoundButton boolean ), 0, this, compoundButton, bl);
        }

        public /* synthetic */ ConfirmDialogListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfirmDialogListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    protected static final class SmsTracker
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public HashMap<String, Object> mData;
        public int mRetryCount;
        public int mImsRetry;
        public int mMessageRef;
        public boolean mExpectMore;
        String mFormat;
        public PendingIntent mSentIntent;
        public PendingIntent mDeliveryIntent;
        public PackageInfo mAppInfo;
        public String mDestAddress;
        public SmsHeader mSmsHeader;
        private long mTimestamp;
        public Uri mMessageUri;
        private AtomicInteger mUnsentPartCount;
        private AtomicBoolean mAnyPartFailed;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$__constructor__(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, PackageInfo appInfo, String destAddr, String format, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri, SmsHeader smsHeader, boolean isExpectMore) {
            this.mTimestamp = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.mData = data;
            this.mSentIntent = sentIntent;
            this.mDeliveryIntent = deliveryIntent;
            this.mRetryCount = 0;
            this.mAppInfo = appInfo;
            this.mDestAddress = destAddr;
            this.mFormat = format;
            this.mExpectMore = isExpectMore;
            this.mImsRetry = 0;
            this.mMessageRef = 0;
            this.mUnsentPartCount = unsentPartCount;
            this.mAnyPartFailed = anyPartFailed;
            this.mMessageUri = messageUri;
            this.mSmsHeader = smsHeader;
        }

        private final boolean $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$isMultipart() {
            return this.mData.containsKey("parts");
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$writeSentMessage(Context context) {
            String text = (String)this.mData.get("text");
            if (text != null) {
                boolean deliveryReport = this.mDeliveryIntent != null;
                this.mMessageUri = Telephony.Sms.addMessageToUri(context.getContentResolver(), Telephony.Sms.Sent.CONTENT_URI, this.mDestAddress, text, null, this.mTimestamp, true, deliveryReport, 0L);
            }
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$updateSentMessageStatus(Context context, int status) {
            if (this.mMessageUri != null) {
                ContentValues values = new ContentValues(1);
                values.put("status", status);
                SqliteWrapper.update(context, context.getContentResolver(), this.mMessageUri, values, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$updateMessageErrorCode(Context context, int errorCode) {
            if (this.mMessageUri == null) {
                return;
            }
            ContentValues values = new ContentValues(1);
            values.put("error_code", errorCode);
            long identity = Binder.clearCallingIdentity();
            try {
                if (SqliteWrapper.update(context, context.getContentResolver(), this.mMessageUri, values, null, null) != 1) {
                    Rlog.e("SMSDispatcher", "Failed to update message error code");
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$setMessageFinalState(Context context, int messageType) {
            if (this.mMessageUri == null) {
                return;
            }
            ContentValues values = new ContentValues(1);
            values.put("type", messageType);
            long identity = Binder.clearCallingIdentity();
            try {
                if (SqliteWrapper.update(context, context.getContentResolver(), this.mMessageUri, values, null, null) != 1) {
                    Rlog.e("SMSDispatcher", "Failed to move message to " + messageType);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$onFailed(Context context, int error, int errorCode) {
            if (this.mAnyPartFailed != null) {
                this.mAnyPartFailed.set(true);
            }
            boolean isSinglePartOrLastPart = true;
            if (this.mUnsentPartCount != null) {
                boolean bl = isSinglePartOrLastPart = this.mUnsentPartCount.decrementAndGet() == 0;
            }
            if (errorCode != 0) {
                this.updateMessageErrorCode(context, errorCode);
            }
            if (isSinglePartOrLastPart) {
                this.setMessageFinalState(context, 5);
            }
            if (this.mSentIntent != null) {
                try {
                    Intent fillIn = new Intent();
                    if (this.mMessageUri != null) {
                        fillIn.putExtra("uri", this.mMessageUri.toString());
                    }
                    if (errorCode != 0) {
                        fillIn.putExtra("errorCode", errorCode);
                    }
                    if (this.mUnsentPartCount != null && isSinglePartOrLastPart) {
                        fillIn.putExtra("SendNextMsg", true);
                    }
                    this.mSentIntent.send(context, error, fillIn);
                }
                catch (PendingIntent.CanceledException ex) {
                    Rlog.e("SMSDispatcher", "Failed to send result");
                }
            }
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$onSent(Context context) {
            boolean isSinglePartOrLastPart = true;
            if (this.mUnsentPartCount != null) {
                boolean bl = isSinglePartOrLastPart = this.mUnsentPartCount.decrementAndGet() == 0;
            }
            if (isSinglePartOrLastPart) {
                boolean success = true;
                if (this.mAnyPartFailed != null && this.mAnyPartFailed.get()) {
                    success = false;
                }
                if (success) {
                    this.setMessageFinalState(context, 2);
                } else {
                    this.setMessageFinalState(context, 5);
                }
            }
            if (this.mSentIntent != null) {
                try {
                    Intent fillIn = new Intent();
                    if (this.mMessageUri != null) {
                        fillIn.putExtra("uri", this.mMessageUri.toString());
                    }
                    if (this.mUnsentPartCount != null && isSinglePartOrLastPart) {
                        fillIn.putExtra("SendNextMsg", true);
                    }
                    this.mSentIntent.send(context, -1, fillIn);
                }
                catch (PendingIntent.CanceledException ex) {
                    Rlog.e("SMSDispatcher", "Failed to send result");
                }
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$__constructor__(HashMap x0, PendingIntent x1, PendingIntent x2, PackageInfo x3, String x4, String x5, AtomicInteger x6, AtomicBoolean x7, Uri x8, SmsHeader x9, boolean x10, 1 x11) {
        }

        private void __constructor__(HashMap<String, Object> hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, PackageInfo packageInfo, String string2, String string3, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, SmsHeader smsHeader, boolean bl) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$__constructor__(hashMap, pendingIntent, pendingIntent2, packageInfo, string2, string3, atomicInteger, atomicBoolean, uri, smsHeader, bl);
        }

        private SmsTracker(HashMap<String, Object> hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, PackageInfo packageInfo, String string2, String string3, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, SmsHeader smsHeader, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$__constructor__(java.util.HashMap<java.lang.String, java.lang.Object> android.app.PendingIntent android.app.PendingIntent android.content.pm.PackageInfo java.lang.String java.lang.String java.util.concurrent.atomic.AtomicInteger java.util.concurrent.atomic.AtomicBoolean android.net.Uri com.android.internal.telephony.SmsHeader boolean ), 0, this, hashMap, pendingIntent, pendingIntent2, packageInfo, string2, string3, atomicInteger, atomicBoolean, uri, smsHeader, bl);
        }

        boolean isMultipart() {
            return (boolean)InvokeDynamicSupport.bootstrap("isMultipart", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$isMultipart(), 0, this);
        }

        void writeSentMessage(Context context) {
            InvokeDynamicSupport.bootstrap("writeSentMessage", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$writeSentMessage(android.content.Context ), 0, this, context);
        }

        public void updateSentMessageStatus(Context context, int n) {
            InvokeDynamicSupport.bootstrap("updateSentMessageStatus", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$updateSentMessageStatus(android.content.Context int ), 0, this, context, n);
        }

        private void updateMessageErrorCode(Context context, int n) {
            InvokeDynamicSupport.bootstrap("updateMessageErrorCode", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$updateMessageErrorCode(android.content.Context int ), 0, this, context, n);
        }

        private void setMessageFinalState(Context context, int n) {
            InvokeDynamicSupport.bootstrap("setMessageFinalState", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$setMessageFinalState(android.content.Context int ), 0, this, context, n);
        }

        public void onFailed(Context context, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onFailed", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$onFailed(android.content.Context int int ), 0, this, context, n, n2);
        }

        public void onSent(Context context) {
            InvokeDynamicSupport.bootstrap("onSent", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$onSent(android.content.Context ), 0, this, context);
        }

        private /* synthetic */ void __constructor__(HashMap hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, PackageInfo packageInfo, String string2, String string3, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, SmsHeader smsHeader, boolean bl, 1 var12_12) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$__constructor__(hashMap, pendingIntent, pendingIntent2, packageInfo, string2, string3, atomicInteger, atomicBoolean, uri, smsHeader, bl, var12_12);
        }

        public /* synthetic */ SmsTracker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    protected final class SMSDispatcherReceiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SmsTracker mTracker;
        /* synthetic */ SMSDispatcher this$0;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_SMSDispatcherReceiver$__constructor__(SMSDispatcher sMSDispatcher, SmsTracker tracker) {
            this.mTracker = tracker;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SMSDispatcherReceiver$onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.provider.Telephony.SMS_SEND")) {
                int rc = this.getResultCode();
                if (rc == -1) {
                    Rlog.d("SMSDispatcher", "Sending SMS by IP pending.");
                    Bundle resultExtras = this.getResultExtras(false);
                    if (resultExtras != null && resultExtras.containsKey("messageref")) {
                        this.mTracker.mMessageRef = resultExtras.getInt("messageref");
                        Rlog.d("SMSDispatcher", "messageref = " + this.mTracker.mMessageRef);
                    } else {
                        Rlog.e("SMSDispatcher", "Can't find messageref in result extras.");
                    }
                    this.this$0.sendPendingList.add(this.mTracker);
                } else {
                    Rlog.d("SMSDispatcher", "Sending SMS by IP failed.");
                    this.this$0.sendSmsByPstn(this.mTracker);
                }
            } else {
                Rlog.e("SMSDispatcher", "unexpected BroadcastReceiver action: " + action);
            }
        }

        private void __constructor__(SMSDispatcher sMSDispatcher, SmsTracker smsTracker) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_SMSDispatcherReceiver$__constructor__(sMSDispatcher, smsTracker);
        }

        public SMSDispatcherReceiver(SMSDispatcher sMSDispatcher, SmsTracker smsTracker) {
            this.this$0 = sMSDispatcher;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_SMSDispatcherReceiver$__constructor__(com.android.internal.telephony.SMSDispatcher com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, sMSDispatcher, smsTracker);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_SMSDispatcher_SMSDispatcherReceiver$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
        }

        public /* synthetic */ SMSDispatcherReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SMSDispatcherReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SettingsObserver
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AtomicInteger mPremiumSmsRule;
        private Context mContext;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_SettingsObserver$__constructor__(Handler handler, AtomicInteger premiumSmsRule, Context context) {
            this.mPremiumSmsRule = premiumSmsRule;
            this.mContext = context;
            this.onChange(false);
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SettingsObserver$onChange(boolean selfChange) {
            this.mPremiumSmsRule.set(Settings.Global.getInt(this.mContext.getContentResolver(), "sms_short_code_rule", 1));
        }

        private void __constructor__(Handler handler, AtomicInteger atomicInteger, Context context) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_SettingsObserver$__constructor__(handler, atomicInteger, context);
        }

        SettingsObserver(Handler handler, AtomicInteger atomicInteger, Context context) {
            super(handler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_SettingsObserver$__constructor__(android.os.Handler java.util.concurrent.atomic.AtomicInteger android.content.Context ), 0, this, handler, atomicInteger, context);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_telephony_SMSDispatcher_SettingsObserver$onChange(boolean ), 0, this, bl);
        }

        public /* synthetic */ SettingsObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SettingsObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

