/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.Context;
import android.content.IntentFilter;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.telephony.CellInfo;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Pair;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.RestrictedState;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ServiceStateTracker
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static boolean DBG = true;
    protected static boolean VDBG = false;
    protected static String PROP_FORCE_ROAMING = "telephony.test.forceRoaming";
    protected CommandsInterface mCi;
    protected UiccController mUiccController;
    protected UiccCardApplication mUiccApplcation;
    protected IccRecords mIccRecords;
    protected PhoneBase mPhoneBase;
    protected boolean mVoiceCapable;
    public ServiceState mSS;
    protected ServiceState mNewSS;
    private static long LAST_CELL_INFO_LIST_MAX_AGE_MS = 2000L;
    protected long mLastCellInfoListTime;
    protected List<CellInfo> mLastCellInfoList;
    protected CellInfo mCellInfo;
    protected SignalStrength mSignalStrength;
    public RestrictedState mRestrictedState;
    public static int OTASP_UNINITIALIZED = 0;
    public static int OTASP_UNKNOWN = 1;
    public static int OTASP_NEEDED = 2;
    public static int OTASP_NOT_NEEDED = 3;
    protected int[] mPollingContext;
    protected boolean mDesiredPowerState;
    protected boolean mDontPollSignalStrength;
    protected RegistrantList mRoamingOnRegistrants;
    protected RegistrantList mRoamingOffRegistrants;
    protected RegistrantList mAttachedRegistrants;
    protected RegistrantList mDetachedRegistrants;
    protected RegistrantList mDataRegStateOrRatChangedRegistrants;
    protected RegistrantList mNetworkAttachedRegistrants;
    protected RegistrantList mPsRestrictEnabledRegistrants;
    protected RegistrantList mPsRestrictDisabledRegistrants;
    protected boolean mPendingRadioPowerOffAfterDataOff;
    protected int mPendingRadioPowerOffAfterDataOffTag;
    protected static int POLL_PERIOD_MILLIS = 20000;
    public static int DEFAULT_GPRS_CHECK_PERIOD_MILLIS = 60000;
    protected static int EVENT_RADIO_STATE_CHANGED = 1;
    protected static int EVENT_NETWORK_STATE_CHANGED = 2;
    protected static int EVENT_GET_SIGNAL_STRENGTH = 3;
    protected static int EVENT_POLL_STATE_REGISTRATION = 4;
    protected static int EVENT_POLL_STATE_GPRS = 5;
    protected static int EVENT_POLL_STATE_OPERATOR = 6;
    protected static int EVENT_POLL_SIGNAL_STRENGTH = 10;
    protected static int EVENT_NITZ_TIME = 11;
    protected static int EVENT_SIGNAL_STRENGTH_UPDATE = 12;
    protected static int EVENT_RADIO_AVAILABLE = 13;
    protected static int EVENT_POLL_STATE_NETWORK_SELECTION_MODE = 14;
    protected static int EVENT_GET_LOC_DONE = 15;
    protected static int EVENT_SIM_RECORDS_LOADED = 16;
    protected static int EVENT_SIM_READY = 17;
    protected static int EVENT_LOCATION_UPDATES_ENABLED = 18;
    protected static int EVENT_GET_PREFERRED_NETWORK_TYPE = 19;
    protected static int EVENT_SET_PREFERRED_NETWORK_TYPE = 20;
    protected static int EVENT_RESET_PREFERRED_NETWORK_TYPE = 21;
    protected static int EVENT_CHECK_REPORT_GPRS = 22;
    protected static int EVENT_RESTRICTED_STATE_CHANGED = 23;
    protected static int EVENT_POLL_STATE_REGISTRATION_CDMA = 24;
    protected static int EVENT_POLL_STATE_OPERATOR_CDMA = 25;
    protected static int EVENT_RUIM_READY = 26;
    protected static int EVENT_RUIM_RECORDS_LOADED = 27;
    protected static int EVENT_POLL_SIGNAL_STRENGTH_CDMA = 28;
    protected static int EVENT_GET_SIGNAL_STRENGTH_CDMA = 29;
    protected static int EVENT_NETWORK_STATE_CHANGED_CDMA = 30;
    protected static int EVENT_GET_LOC_DONE_CDMA = 31;
    protected static int EVENT_NV_LOADED = 33;
    protected static int EVENT_POLL_STATE_CDMA_SUBSCRIPTION = 34;
    protected static int EVENT_NV_READY = 35;
    protected static int EVENT_ERI_FILE_LOADED = 36;
    protected static int EVENT_OTA_PROVISION_STATUS_CHANGE = 37;
    protected static int EVENT_SET_RADIO_POWER_OFF = 38;
    protected static int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 39;
    protected static int EVENT_CDMA_PRL_VERSION_CHANGED = 40;
    protected static int EVENT_RADIO_ON = 41;
    public static int EVENT_ICC_CHANGED = 42;
    protected static int EVENT_GET_CELL_INFO_LIST = 43;
    protected static int EVENT_UNSOL_CELL_INFO_LIST = 44;
    protected static int EVENT_CHANGE_IMS_STATE = 45;
    protected static String TIMEZONE_PROPERTY = "persist.sys.timezone";
    protected static String[] GMT_COUNTRY_CODES;
    protected static String REGISTRATION_DENIED_GEN = "General";
    protected static String REGISTRATION_DENIED_AUTH = "Authentication Failure";
    protected boolean mImsRegistrationOnOff;
    protected boolean mAlarmSwitch;
    protected IntentFilter mIntentFilter;
    protected PendingIntent mRadioOffIntent;
    protected static String ACTION_RADIO_OFF = "android.intent.action.ACTION_RADIO_OFF";
    protected boolean mPowerOffDelayNeed;
    protected boolean mDeviceShuttingDown;
    private SignalStrength mLastSignalStrength;
    private boolean mWantContinuousLocationUpdates;
    private boolean mWantSingleLocationUpdate;

    private void $$robo$$com_android_internal_telephony_ServiceStateTracker$__constructor__(PhoneBase phoneBase, CommandsInterface ci, CellInfo cellInfo) {
        this.mUiccController = null;
        this.mUiccApplcation = null;
        this.mIccRecords = null;
        this.mSS = new ServiceState();
        this.mNewSS = new ServiceState();
        this.mLastCellInfoList = null;
        this.mSignalStrength = new SignalStrength();
        this.mRestrictedState = new RestrictedState();
        this.mDontPollSignalStrength = false;
        this.mRoamingOnRegistrants = new RegistrantList();
        this.mRoamingOffRegistrants = new RegistrantList();
        this.mAttachedRegistrants = new RegistrantList();
        this.mDetachedRegistrants = new RegistrantList();
        this.mDataRegStateOrRatChangedRegistrants = new RegistrantList();
        this.mNetworkAttachedRegistrants = new RegistrantList();
        this.mPsRestrictEnabledRegistrants = new RegistrantList();
        this.mPsRestrictDisabledRegistrants = new RegistrantList();
        this.mPendingRadioPowerOffAfterDataOff = false;
        this.mPendingRadioPowerOffAfterDataOffTag = 0;
        this.mImsRegistrationOnOff = false;
        this.mAlarmSwitch = false;
        this.mIntentFilter = null;
        this.mRadioOffIntent = null;
        this.mPowerOffDelayNeed = true;
        this.mDeviceShuttingDown = false;
        this.mLastSignalStrength = null;
        this.mPhoneBase = phoneBase;
        this.mCellInfo = cellInfo;
        this.mCi = ci;
        this.mVoiceCapable = this.mPhoneBase.getContext().getResources().getBoolean(17956931);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 42, null);
        this.mCi.setOnSignalStrengthUpdate(this, 12, null);
        this.mCi.registerForCellInfoList(this, 44, null);
        this.mPhoneBase.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(0));
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$requestShutdown() {
        if (this.mDeviceShuttingDown) {
            return;
        }
        this.mDeviceShuttingDown = true;
        this.mDesiredPowerState = false;
        this.setPowerStateToDesired();
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$dispose() {
        this.mCi.unSetOnSignalStrengthUpdate(this);
        this.mUiccController.unregisterForIccChanged(this);
        this.mCi.unregisterForCellInfoList(this);
    }

    private final boolean $$robo$$com_android_internal_telephony_ServiceStateTracker$getDesiredPowerState() {
        return this.mDesiredPowerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_ServiceStateTracker$notifySignalStrength() {
        boolean notified = false;
        CellInfo cellInfo = this.mCellInfo;
        synchronized (cellInfo) {
            if (!this.mSignalStrength.equals(this.mLastSignalStrength)) {
                try {
                    this.mPhoneBase.notifySignalStrength();
                    notified = true;
                }
                catch (NullPointerException ex) {
                    this.loge("updateSignalStrength() Phone already destroyed: " + ex + "SignalStrength not notified");
                }
            }
        }
        return notified;
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$notifyDataRegStateRilRadioTechnologyChanged() {
        int rat = this.mSS.getRilDataRadioTechnology();
        int drs = this.mSS.getDataRegState();
        this.log("notifyDataRegStateRilRadioTechnologyChanged: drs=" + drs + " rat=" + rat);
        this.mPhoneBase.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(rat));
        this.mDataRegStateOrRatChangedRegistrants.notifyResult(new Pair<Integer, Integer>(drs, rat));
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$useDataRegStateForDataOnlyDevices() {
        if (!this.mVoiceCapable) {
            this.log("useDataRegStateForDataOnlyDevice: VoiceRegState=" + this.mNewSS.getVoiceRegState() + " DataRegState=" + this.mNewSS.getDataRegState());
            this.mNewSS.setVoiceRegState(this.mNewSS.getDataRegState());
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$updatePhoneObject() {
        if (this.mPhoneBase.getContext().getResources().getBoolean(17956986)) {
            this.mPhoneBase.updatePhoneObject(this.mSS.getRilVoiceRadioTechnology());
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForRoamingOn(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mRoamingOnRegistrants.add(r);
        if (this.mSS.getRoaming()) {
            r.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForRoamingOn(Handler h) {
        this.mRoamingOnRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForRoamingOff(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mRoamingOffRegistrants.add(r);
        if (!this.mSS.getRoaming()) {
            r.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForRoamingOff(Handler h) {
        this.mRoamingOffRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$reRegisterNetwork(Message onComplete) {
        this.mCi.getPreferredNetworkType(this.obtainMessage(19, onComplete));
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$setRadioPower(boolean power) {
        this.mDesiredPowerState = power;
        this.setPowerStateToDesired();
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$enableSingleLocationUpdate() {
        if (this.mWantSingleLocationUpdate || this.mWantContinuousLocationUpdates) {
            return;
        }
        this.mWantSingleLocationUpdate = true;
        this.mCi.setLocationUpdates(true, this.obtainMessage(18));
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$enableLocationUpdates() {
        if (this.mWantSingleLocationUpdate || this.mWantContinuousLocationUpdates) {
            return;
        }
        this.mWantContinuousLocationUpdates = true;
        this.mCi.setLocationUpdates(true, this.obtainMessage(18));
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$disableSingleLocationUpdate() {
        this.mWantSingleLocationUpdate = false;
        if (!this.mWantSingleLocationUpdate && !this.mWantContinuousLocationUpdates) {
            this.mCi.setLocationUpdates(false, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$disableLocationUpdates() {
        this.mWantContinuousLocationUpdates = false;
        if (!this.mWantSingleLocationUpdate && !this.mWantContinuousLocationUpdates) {
            this.mCi.setLocationUpdates(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$handleMessage(Message msg) {
        switch (msg.what) {
            case 38: {
                ServiceStateTracker serviceStateTracker = this;
                synchronized (serviceStateTracker) {
                    if (this.mPendingRadioPowerOffAfterDataOff && msg.arg1 == this.mPendingRadioPowerOffAfterDataOffTag) {
                        this.log("EVENT_SET_RADIO_OFF, turn radio off now.");
                        this.hangupAndPowerOff();
                        ++this.mPendingRadioPowerOffAfterDataOffTag;
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    } else {
                        this.log("EVENT_SET_RADIO_OFF is stale arg1=" + msg.arg1 + "!= tag=" + this.mPendingRadioPowerOffAfterDataOffTag);
                    }
                    break;
                }
            }
            case 42: {
                this.onUpdateIccAvailability();
                break;
            }
            case 43: {
                AsyncResult ar = (AsyncResult)msg.obj;
                CellInfoResult result = (CellInfoResult)ar.userObj;
                Object object = result.lockObj;
                synchronized (object) {
                    if (ar.exception != null) {
                        this.log("EVENT_GET_CELL_INFO_LIST: error ret null, e=" + ar.exception);
                        result.list = null;
                    } else {
                        result.list = (List)ar.result;
                    }
                    this.mLastCellInfoListTime = SystemClock.elapsedRealtime();
                    this.mLastCellInfoList = result.list;
                    result.lockObj.notify();
                    break;
                }
            }
            case 44: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    this.log("EVENT_UNSOL_CELL_INFO_LIST: error ignoring, e=" + ar.exception);
                    break;
                }
                List list = (List)ar.result;
                this.log("EVENT_UNSOL_CELL_INFO_LIST: size=" + list.size() + " list=" + list);
                this.mLastCellInfoListTime = SystemClock.elapsedRealtime();
                this.mLastCellInfoList = list;
                this.mPhoneBase.notifyCellInfo(list);
                break;
            }
            default: {
                this.log("Unhandled message with number: " + msg.what);
            }
        }
    }

    protected abstract Phone getPhone();

    protected abstract void handlePollStateResult(int var1, AsyncResult var2);

    protected abstract void updateSpnDisplay();

    protected abstract void setPowerStateToDesired();

    protected abstract void onUpdateIccAvailability();

    protected abstract void log(String var1);

    protected abstract void loge(String var1);

    public abstract int getCurrentDataConnectionState();

    public abstract boolean isConcurrentVoiceAndDataAllowed();

    public abstract void setImsRegistrationState(boolean var1);

    public abstract void pollState();

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForDataConnectionAttached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mAttachedRegistrants.add(r);
        if (this.getCurrentDataConnectionState() == 0) {
            r.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForDataConnectionAttached(Handler h) {
        this.mAttachedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForDataConnectionDetached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mDetachedRegistrants.add(r);
        if (this.getCurrentDataConnectionState() != 0) {
            r.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForDataConnectionDetached(Handler h) {
        this.mDetachedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForDataRegStateOrRatChanged(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mDataRegStateOrRatChangedRegistrants.add(r);
        this.notifyDataRegStateRilRadioTechnologyChanged();
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForDataRegStateOrRatChanged(Handler h) {
        this.mDataRegStateOrRatChangedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForNetworkAttached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkAttachedRegistrants.add(r);
        if (this.mSS.getVoiceRegState() == 0) {
            r.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForNetworkAttached(Handler h) {
        this.mNetworkAttachedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForPsRestrictedEnabled(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mPsRestrictEnabledRegistrants.add(r);
        if (this.mRestrictedState.isPsRestricted()) {
            r.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForPsRestrictedEnabled(Handler h) {
        this.mPsRestrictEnabledRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForPsRestrictedDisabled(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mPsRestrictDisabledRegistrants.add(r);
        if (this.mRestrictedState.isPsRestricted()) {
            r.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForPsRestrictedDisabled(Handler h) {
        this.mPsRestrictDisabledRegistrants.remove(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$powerOffRadioSafely(DcTrackerBase dcTracker) {
        ServiceStateTracker serviceStateTracker = this;
        synchronized (serviceStateTracker) {
            if (!this.mPendingRadioPowerOffAfterDataOff) {
                String[] networkNotClearData = this.mPhoneBase.getContext().getResources().getStringArray(17236028);
                String currentNetwork = this.mSS.getOperatorNumeric();
                if (networkNotClearData != null && currentNetwork != null) {
                    for (int i = 0; i < networkNotClearData.length; ++i) {
                        if (!currentNetwork.equals(networkNotClearData[i])) continue;
                        this.log("Not disconnecting data for " + currentNetwork);
                        this.hangupAndPowerOff();
                        return;
                    }
                }
                if (dcTracker.isDisconnected()) {
                    dcTracker.cleanUpAllConnections("radioTurnedOff");
                    this.log("Data disconnected, turn off radio right away.");
                    this.hangupAndPowerOff();
                } else {
                    dcTracker.cleanUpAllConnections("radioTurnedOff");
                    Message msg = Message.obtain(this);
                    msg.what = 38;
                    msg.arg1 = ++this.mPendingRadioPowerOffAfterDataOffTag;
                    if (this.sendMessageDelayed(msg, 30000L)) {
                        this.log("Wait upto 30s for data to disconnect, then turn off radio.");
                        this.mPendingRadioPowerOffAfterDataOff = true;
                    } else {
                        this.log("Cannot send delayed Msg, turn off radio right away.");
                        this.hangupAndPowerOff();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_ServiceStateTracker$processPendingRadioPowerOffAfterDataOff() {
        ServiceStateTracker serviceStateTracker = this;
        synchronized (serviceStateTracker) {
            if (this.mPendingRadioPowerOffAfterDataOff) {
                this.log("Process pending request to turn radio off.");
                ++this.mPendingRadioPowerOffAfterDataOffTag;
                this.hangupAndPowerOff();
                this.mPendingRadioPowerOffAfterDataOff = false;
                return true;
            }
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_ServiceStateTracker$onSignalStrengthResult(AsyncResult ar, boolean isGsm) {
        SignalStrength oldSignalStrength = this.mSignalStrength;
        if (ar.exception == null && ar.result != null) {
            this.mSignalStrength = (SignalStrength)ar.result;
            this.mSignalStrength.validateInput();
            this.mSignalStrength.setGsm(isGsm);
        } else {
            this.log("onSignalStrengthResult() Exception from RIL : " + ar.exception);
            this.mSignalStrength = new SignalStrength(isGsm);
        }
        return this.notifySignalStrength();
    }

    protected abstract void hangupAndPowerOff();

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$cancelPollState() {
        this.mPollingContext = new int[1];
    }

    private final boolean $$robo$$com_android_internal_telephony_ServiceStateTracker$shouldFixTimeZoneNow(PhoneBase phoneBase, String operatorNumeric, String prevOperatorNumeric, boolean needToFixTimeZone) {
        int prevMcc;
        int mcc;
        try {
            mcc = Integer.parseInt(operatorNumeric.substring(0, 3));
        }
        catch (Exception e) {
            this.log("shouldFixTimeZoneNow: no mcc, operatorNumeric=" + operatorNumeric + " retVal=false");
            return false;
        }
        try {
            prevMcc = Integer.parseInt(prevOperatorNumeric.substring(0, 3));
        }
        catch (Exception e) {
            prevMcc = mcc + 1;
        }
        boolean iccCardExist = false;
        if (this.mUiccApplcation != null) {
            iccCardExist = this.mUiccApplcation.getState() != IccCardApplicationStatus.AppState.APPSTATE_UNKNOWN;
        }
        boolean retVal = iccCardExist && mcc != prevMcc || needToFixTimeZone;
        CallSite ctm = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.log("shouldFixTimeZoneNow: retVal=" + retVal + " iccCardExist=" + iccCardExist + " operatorNumeric=" + operatorNumeric + " mcc=" + mcc + " prevOperatorNumeric=" + prevOperatorNumeric + " prevMcc=" + prevMcc + " needToFixTimeZone=" + needToFixTimeZone + " ltod=" + TimeUtils.logTimeOfDay((long)ctm));
        return retVal;
    }

    private final String $$robo$$com_android_internal_telephony_ServiceStateTracker$getSystemProperty(String property, String defValue) {
        return TelephonyManager.getTelephonyProperty(property, this.mPhoneBase.getSubId(), defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<CellInfo> $$robo$$com_android_internal_telephony_ServiceStateTracker$getAllCellInfo() {
        CellInfoResult result = new CellInfoResult(this);
        int ver = this.mCi.getRilVersion();
        if (ver >= 8) {
            if (this.isCallerOnDifferentThread()) {
                if (SystemClock.elapsedRealtime() - this.mLastCellInfoListTime > 2000L) {
                    Message msg = this.obtainMessage(43, result);
                    Object object = result.lockObj;
                    synchronized (object) {
                        result.list = null;
                        this.mCi.getCellInfoList(msg);
                        try {
                            result.lockObj.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.log("SST.getAllCellInfo(): return last, back to back calls");
                result.list = this.mLastCellInfoList;
            } else {
                this.log("SST.getAllCellInfo(): return last, same thread can't block");
                result.list = this.mLastCellInfoList;
            }
        } else {
            this.log("SST.getAllCellInfo(): not implemented");
            result.list = null;
        }
        Object object = result.lockObj;
        synchronized (object) {
            if (result.list != null) {
                this.log("SST.getAllCellInfo(): X size=" + result.list.size() + " list=" + result.list);
                return result.list;
            }
            this.log("SST.getAllCellInfo(): X size=0 list=null");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SignalStrength $$robo$$com_android_internal_telephony_ServiceStateTracker$getSignalStrength() {
        CellInfo cellInfo = this.mCellInfo;
        synchronized (cellInfo) {
            return this.mSignalStrength;
        }
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ServiceStateTracker:");
        pw.println(" mSS=" + this.mSS);
        pw.println(" mNewSS=" + this.mNewSS);
        pw.println(" mCellInfo=" + this.mCellInfo);
        pw.println(" mRestrictedState=" + this.mRestrictedState);
        pw.println(" mPollingContext=" + this.mPollingContext);
        pw.println(" mDesiredPowerState=" + this.mDesiredPowerState);
        pw.println(" mDontPollSignalStrength=" + this.mDontPollSignalStrength);
        pw.println(" mPendingRadioPowerOffAfterDataOff=" + this.mPendingRadioPowerOffAfterDataOff);
        pw.println(" mPendingRadioPowerOffAfterDataOffTag=" + this.mPendingRadioPowerOffAfterDataOffTag);
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$checkCorrectThread() {
        if (Thread.currentThread() != this.getLooper().getThread()) {
            throw new RuntimeException("ServiceStateTracker must be used from within one thread");
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_ServiceStateTracker$isCallerOnDifferentThread() {
        boolean value = Thread.currentThread() != this.getLooper().getThread();
        return value;
    }

    private final void $$robo$$com_android_internal_telephony_ServiceStateTracker$updateCarrierMccMncConfiguration(String newOp, String oldOp, Context context) {
        if (newOp == null && !TextUtils.isEmpty(oldOp) || newOp != null && !newOp.equals(oldOp)) {
            this.log("update mccmnc=" + newOp + " fromServiceState=true");
            MccTable.updateMccMncConfiguration(context, newOp, true);
        }
    }

    static void __staticInitializer__() {
        GMT_COUNTRY_CODES = new String[]{"bf", "ci", "eh", "fo", "gb", "gh", "gm", "gn", "gw", "ie", "lr", "is", "ma", "ml", "mr", "pt", "sl", "sn", "st", "tg"};
    }

    private void __constructor__(PhoneBase phoneBase, CommandsInterface commandsInterface, CellInfo cellInfo) {
        this.$$robo$$com_android_internal_telephony_ServiceStateTracker$__constructor__(phoneBase, commandsInterface, cellInfo);
    }

    protected ServiceStateTracker(PhoneBase phoneBase, CommandsInterface commandsInterface, CellInfo cellInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ServiceStateTracker$__constructor__(com.android.internal.telephony.PhoneBase com.android.internal.telephony.CommandsInterface android.telephony.CellInfo ), 0, this, phoneBase, commandsInterface, cellInfo);
    }

    void requestShutdown() {
        InvokeDynamicSupport.bootstrap("requestShutdown", $$robo$$com_android_internal_telephony_ServiceStateTracker$requestShutdown(), 0, this);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_ServiceStateTracker$dispose(), 0, this);
    }

    public boolean getDesiredPowerState() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDesiredPowerState", $$robo$$com_android_internal_telephony_ServiceStateTracker$getDesiredPowerState(), 0, this);
    }

    protected boolean notifySignalStrength() {
        return (boolean)InvokeDynamicSupport.bootstrap("notifySignalStrength", $$robo$$com_android_internal_telephony_ServiceStateTracker$notifySignalStrength(), 0, this);
    }

    protected void notifyDataRegStateRilRadioTechnologyChanged() {
        InvokeDynamicSupport.bootstrap("notifyDataRegStateRilRadioTechnologyChanged", $$robo$$com_android_internal_telephony_ServiceStateTracker$notifyDataRegStateRilRadioTechnologyChanged(), 0, this);
    }

    protected void useDataRegStateForDataOnlyDevices() {
        InvokeDynamicSupport.bootstrap("useDataRegStateForDataOnlyDevices", $$robo$$com_android_internal_telephony_ServiceStateTracker$useDataRegStateForDataOnlyDevices(), 0, this);
    }

    protected void updatePhoneObject() {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_ServiceStateTracker$updatePhoneObject(), 0, this);
    }

    public void registerForRoamingOn(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRoamingOn", $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForRoamingOn(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForRoamingOn(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRoamingOn", $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForRoamingOn(android.os.Handler ), 0, this, handler);
    }

    public void registerForRoamingOff(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRoamingOff", $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForRoamingOff(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForRoamingOff(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRoamingOff", $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForRoamingOff(android.os.Handler ), 0, this, handler);
    }

    public void reRegisterNetwork(Message message) {
        InvokeDynamicSupport.bootstrap("reRegisterNetwork", $$robo$$com_android_internal_telephony_ServiceStateTracker$reRegisterNetwork(android.os.Message ), 0, this, message);
    }

    public void setRadioPower(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRadioPower", $$robo$$com_android_internal_telephony_ServiceStateTracker$setRadioPower(boolean ), 0, this, bl);
    }

    public void enableSingleLocationUpdate() {
        InvokeDynamicSupport.bootstrap("enableSingleLocationUpdate", $$robo$$com_android_internal_telephony_ServiceStateTracker$enableSingleLocationUpdate(), 0, this);
    }

    public void enableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("enableLocationUpdates", $$robo$$com_android_internal_telephony_ServiceStateTracker$enableLocationUpdates(), 0, this);
    }

    protected void disableSingleLocationUpdate() {
        InvokeDynamicSupport.bootstrap("disableSingleLocationUpdate", $$robo$$com_android_internal_telephony_ServiceStateTracker$disableSingleLocationUpdate(), 0, this);
    }

    public void disableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("disableLocationUpdates", $$robo$$com_android_internal_telephony_ServiceStateTracker$disableLocationUpdates(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_ServiceStateTracker$handleMessage(android.os.Message ), 0, this, message);
    }

    public void registerForDataConnectionAttached(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDataConnectionAttached", $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForDataConnectionAttached(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForDataConnectionAttached(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDataConnectionAttached", $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForDataConnectionAttached(android.os.Handler ), 0, this, handler);
    }

    public void registerForDataConnectionDetached(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDataConnectionDetached", $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForDataConnectionDetached(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForDataConnectionDetached(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDataConnectionDetached", $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForDataConnectionDetached(android.os.Handler ), 0, this, handler);
    }

    public void registerForDataRegStateOrRatChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDataRegStateOrRatChanged", $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForDataRegStateOrRatChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForDataRegStateOrRatChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDataRegStateOrRatChanged", $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForDataRegStateOrRatChanged(android.os.Handler ), 0, this, handler);
    }

    public void registerForNetworkAttached(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNetworkAttached", $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForNetworkAttached(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForNetworkAttached(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNetworkAttached", $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForNetworkAttached(android.os.Handler ), 0, this, handler);
    }

    public void registerForPsRestrictedEnabled(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForPsRestrictedEnabled", $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForPsRestrictedEnabled(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForPsRestrictedEnabled(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForPsRestrictedEnabled", $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForPsRestrictedEnabled(android.os.Handler ), 0, this, handler);
    }

    public void registerForPsRestrictedDisabled(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForPsRestrictedDisabled", $$robo$$com_android_internal_telephony_ServiceStateTracker$registerForPsRestrictedDisabled(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForPsRestrictedDisabled(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForPsRestrictedDisabled", $$robo$$com_android_internal_telephony_ServiceStateTracker$unregisterForPsRestrictedDisabled(android.os.Handler ), 0, this, handler);
    }

    public void powerOffRadioSafely(DcTrackerBase dcTrackerBase) {
        InvokeDynamicSupport.bootstrap("powerOffRadioSafely", $$robo$$com_android_internal_telephony_ServiceStateTracker$powerOffRadioSafely(com.android.internal.telephony.dataconnection.DcTrackerBase ), 0, this, dcTrackerBase);
    }

    public boolean processPendingRadioPowerOffAfterDataOff() {
        return (boolean)InvokeDynamicSupport.bootstrap("processPendingRadioPowerOffAfterDataOff", $$robo$$com_android_internal_telephony_ServiceStateTracker$processPendingRadioPowerOffAfterDataOff(), 0, this);
    }

    protected boolean onSignalStrengthResult(AsyncResult asyncResult, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSignalStrengthResult", $$robo$$com_android_internal_telephony_ServiceStateTracker$onSignalStrengthResult(android.os.AsyncResult boolean ), 0, this, asyncResult, bl);
    }

    protected void cancelPollState() {
        InvokeDynamicSupport.bootstrap("cancelPollState", $$robo$$com_android_internal_telephony_ServiceStateTracker$cancelPollState(), 0, this);
    }

    protected boolean shouldFixTimeZoneNow(PhoneBase phoneBase, String string2, String string3, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldFixTimeZoneNow", $$robo$$com_android_internal_telephony_ServiceStateTracker$shouldFixTimeZoneNow(com.android.internal.telephony.PhoneBase java.lang.String java.lang.String boolean ), 0, this, phoneBase, string2, string3, bl);
    }

    public String getSystemProperty(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getSystemProperty", $$robo$$com_android_internal_telephony_ServiceStateTracker$getSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public List<CellInfo> getAllCellInfo() {
        return InvokeDynamicSupport.bootstrap("getAllCellInfo", $$robo$$com_android_internal_telephony_ServiceStateTracker$getAllCellInfo(), 0, this);
    }

    public SignalStrength getSignalStrength() {
        return InvokeDynamicSupport.bootstrap("getSignalStrength", $$robo$$com_android_internal_telephony_ServiceStateTracker$getSignalStrength(), 0, this);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_ServiceStateTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    protected void checkCorrectThread() {
        InvokeDynamicSupport.bootstrap("checkCorrectThread", $$robo$$com_android_internal_telephony_ServiceStateTracker$checkCorrectThread(), 0, this);
    }

    protected boolean isCallerOnDifferentThread() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCallerOnDifferentThread", $$robo$$com_android_internal_telephony_ServiceStateTracker$isCallerOnDifferentThread(), 0, this);
    }

    protected void updateCarrierMccMncConfiguration(String string2, String string3, Context context) {
        InvokeDynamicSupport.bootstrap("updateCarrierMccMncConfiguration", $$robo$$com_android_internal_telephony_ServiceStateTracker$updateCarrierMccMncConfiguration(java.lang.String java.lang.String android.content.Context ), 0, this, string2, string3, context);
    }

    static {
        RobolectricInternals.classInitializing(ServiceStateTracker.class);
    }

    public /* synthetic */ ServiceStateTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceStateTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CellInfoResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        List<CellInfo> list;
        Object lockObj;
        /* synthetic */ ServiceStateTracker this$0;

        private void $$robo$$com_android_internal_telephony_ServiceStateTracker_CellInfoResult$__constructor__(ServiceStateTracker serviceStateTracker) {
            this.lockObj = new Object();
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_ServiceStateTracker_CellInfoResult$__constructor__(ServiceStateTracker x0, 1 x1) {
        }

        private void __constructor__(ServiceStateTracker serviceStateTracker) {
            this.$$robo$$com_android_internal_telephony_ServiceStateTracker_CellInfoResult$__constructor__(serviceStateTracker);
        }

        private CellInfoResult(ServiceStateTracker serviceStateTracker) {
            this.this$0 = serviceStateTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ServiceStateTracker_CellInfoResult$__constructor__(com.android.internal.telephony.ServiceStateTracker ), 0, this, serviceStateTracker);
        }

        private /* synthetic */ void __constructor__(ServiceStateTracker serviceStateTracker, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_ServiceStateTracker_CellInfoResult$__constructor__(serviceStateTracker, var2_2);
        }

        public /* synthetic */ CellInfoResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellInfoResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

