/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.SparseIntArray;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.util.XmlUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Sms7BitEncodingTranslator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Sms7BitEncodingTranslator";
    private static boolean DBG;
    private static boolean mIs7BitTranslationTableLoaded;
    private static SparseIntArray mTranslationTable;
    private static SparseIntArray mTranslationTableCommon;
    private static SparseIntArray mTranslationTableGSM;
    private static SparseIntArray mTranslationTableCDMA;
    private static String XML_START_TAG = "SmsEnforce7BitTranslationTable";
    private static String XML_TRANSLATION_TYPE_TAG = "TranslationType";
    private static String XML_CHARACTOR_TAG = "Character";
    private static String XML_FROM_TAG = "from";
    private static String XML_TO_TAG = "to";

    private void $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$__constructor__() {
    }

    private static final String $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$translate(CharSequence message) {
        if (message == null) {
            Rlog.w("Sms7BitEncodingTranslator", "Null message can not be translated");
            return null;
        }
        int size = message.length();
        if (size <= 0) {
            return "";
        }
        if (!mIs7BitTranslationTableLoaded) {
            mTranslationTableCommon = new SparseIntArray();
            mTranslationTableGSM = new SparseIntArray();
            mTranslationTableCDMA = new SparseIntArray();
            Sms7BitEncodingTranslator.load7BitTranslationTableFromXml();
            mIs7BitTranslationTableLoaded = true;
        }
        if (mTranslationTableCommon != null && mTranslationTableCommon.size() > 0 || mTranslationTableGSM != null && mTranslationTableGSM.size() > 0 || mTranslationTableCDMA != null && mTranslationTableCDMA.size() > 0) {
            char[] output = new char[size];
            for (int i = 0; i < size; ++i) {
                output[i] = Sms7BitEncodingTranslator.translateIfNeeded(message.charAt(i));
            }
            return String.valueOf(output);
        }
        return null;
    }

    private static final char $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$translateIfNeeded(char c) {
        if (Sms7BitEncodingTranslator.noTranslationNeeded(c)) {
            if (DBG) {
                Rlog.v("Sms7BitEncodingTranslator", "No translation needed for " + Integer.toHexString(c));
            }
            return c;
        }
        int translation = -1;
        if (mTranslationTableCommon != null) {
            translation = mTranslationTableCommon.get(c, -1);
        }
        if (translation == -1) {
            if (Sms7BitEncodingTranslator.useCdmaFormatForMoSms()) {
                if (mTranslationTableCDMA != null) {
                    translation = mTranslationTableCDMA.get(c, -1);
                }
            } else if (mTranslationTableGSM != null) {
                translation = mTranslationTableGSM.get(c, -1);
            }
        }
        if (translation != -1) {
            if (DBG) {
                Rlog.v("Sms7BitEncodingTranslator", Integer.toHexString(c) + " (" + c + ")" + " translated to " + Integer.toHexString(translation) + " (" + (char)translation + ")");
            }
            return (char)translation;
        }
        if (DBG) {
            Rlog.w("Sms7BitEncodingTranslator", "No translation found for " + Integer.toHexString(c) + "! Replacing for empty space");
        }
        return ' ';
    }

    private static final boolean $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$noTranslationNeeded(char c) {
        if (Sms7BitEncodingTranslator.useCdmaFormatForMoSms()) {
            return GsmAlphabet.isGsmSeptets(c) && UserData.charToAscii.get(c, -1) != -1;
        }
        return GsmAlphabet.isGsmSeptets(c);
    }

    private static final boolean $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$useCdmaFormatForMoSms() {
        if (!SmsManager.getDefault().isImsSmsSupported()) {
            return TelephonyManager.getDefault().getCurrentPhoneType() == 2;
        }
        return "3gpp2".equals(SmsManager.getDefault().getImsSmsFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$load7BitTranslationTableFromXml() {
        XmlResourceParser parser = null;
        Resources r = Resources.getSystem();
        if (parser == null) {
            if (DBG) {
                Rlog.d("Sms7BitEncodingTranslator", "load7BitTranslationTableFromXml: open normal file");
            }
            parser = r.getXml(0x1110010);
        }
        try {
            XmlUtils.beginDocument(parser, "SmsEnforce7BitTranslationTable");
            while (true) {
                XmlUtils.nextElement(parser);
                String tag = parser.getName();
                if (DBG) {
                    Rlog.d("Sms7BitEncodingTranslator", "tag: " + tag);
                }
                if ("TranslationType".equals(tag)) {
                    String type = parser.getAttributeValue(null, "Type");
                    if (DBG) {
                        Rlog.d("Sms7BitEncodingTranslator", "type: " + type);
                    }
                    if (type.equals("common")) {
                        mTranslationTable = mTranslationTableCommon;
                        continue;
                    }
                    if (type.equals("gsm")) {
                        mTranslationTable = mTranslationTableGSM;
                        continue;
                    }
                    if (type.equals("cdma")) {
                        mTranslationTable = mTranslationTableCDMA;
                        continue;
                    }
                    Rlog.e("Sms7BitEncodingTranslator", "Error Parsing 7BitTranslationTable: found incorrect type" + type);
                    continue;
                }
                if (!"Character".equals(tag) || mTranslationTable == null) break;
                int from = parser.getAttributeUnsignedIntValue(null, "from", -1);
                int to = parser.getAttributeUnsignedIntValue(null, "to", -1);
                if (from != -1 && to != -1) {
                    if (DBG) {
                        Rlog.d("Sms7BitEncodingTranslator", "Loading mapping " + Integer.toHexString(from).toUpperCase() + " -> " + Integer.toHexString(to).toUpperCase());
                    }
                    mTranslationTable.put(from, to);
                    continue;
                }
                Rlog.d("Sms7BitEncodingTranslator", "Invalid translation table file format");
            }
            if (DBG) {
                Rlog.d("Sms7BitEncodingTranslator", "load7BitTranslationTableFromXml: parsing successful, file loaded");
            }
        }
        catch (Exception e) {
            Rlog.e("Sms7BitEncodingTranslator", "Got exception while loading 7BitTranslationTable file.", e);
        }
        finally {
            if (parser instanceof XmlResourceParser) {
                parser.close();
            }
        }
    }

    static void __staticInitializer__() {
        DBG = Build.IS_DEBUGGABLE;
        mIs7BitTranslationTableLoaded = false;
        mTranslationTable = null;
        mTranslationTableCommon = null;
        mTranslationTableGSM = null;
        mTranslationTableCDMA = null;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$__constructor__();
    }

    public Sms7BitEncodingTranslator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$__constructor__(), 0, this);
    }

    public static String translate(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("translate", $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$translate(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    private static char translateIfNeeded(char c) {
        return (char)InvokeDynamicSupport.bootstrapStatic("translateIfNeeded", $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$translateIfNeeded(char ), 0, (char)c);
    }

    private static boolean noTranslationNeeded(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("noTranslationNeeded", $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$noTranslationNeeded(char ), 0, (char)c);
    }

    private static boolean useCdmaFormatForMoSms() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("useCdmaFormatForMoSms", $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$useCdmaFormatForMoSms(), 0);
    }

    private static void load7BitTranslationTableFromXml() {
        InvokeDynamicSupport.bootstrapStatic("load7BitTranslationTableFromXml", $$robo$$com_android_internal_telephony_Sms7BitEncodingTranslator$load7BitTranslationTableFromXml(), 0);
    }

    static {
        RobolectricInternals.classInitializing(Sms7BitEncodingTranslator.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Sms7BitEncodingTranslator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

