/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Binder;
import android.os.Process;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import com.android.internal.content.PackageMonitor;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SmsApplication
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "SmsApplication";
    private static String PHONE_PACKAGE_NAME = "com.android.phone";
    private static String BLUETOOTH_PACKAGE_NAME = "com.android.bluetooth";
    private static String MMS_SERVICE_PACKAGE_NAME = "com.android.mms.service";
    private static String SCHEME_SMS = "sms";
    private static String SCHEME_SMSTO = "smsto";
    private static String SCHEME_MMS = "mms";
    private static String SCHEME_MMSTO = "mmsto";
    private static boolean DEBUG_MULTIUSER = false;
    private static SmsPackageMonitor sSmsPackageMonitor;

    private void $$robo$$com_android_internal_telephony_SmsApplication$__constructor__() {
    }

    private static final int $$robo$$com_android_internal_telephony_SmsApplication$getIncomingUserId(Context context) {
        int contextUserId = context.getUserId();
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callingUid) < 10000) {
            return contextUserId;
        }
        return UserHandle.getUserId(callingUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Collection<SmsApplicationData> $$robo$$com_android_internal_telephony_SmsApplication$getApplicationCollection(Context context) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            Collection<SmsApplicationData> collection = SmsApplication.getApplicationCollectionInternal(context, userId);
            return collection;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static final Collection<SmsApplicationData> $$robo$$com_android_internal_telephony_SmsApplication$getApplicationCollectionInternal(Context context, int userId) {
        String packageName;
        SmsApplicationData smsApplicationData;
        ActivityInfo activityInfo;
        SmsApplicationData smsApplicationData2;
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.provider.Telephony.SMS_DELIVER");
        List<ResolveInfo> smsReceivers = packageManager.queryBroadcastReceivers(intent, 0, userId);
        HashMap<String, SmsApplicationData> receivers = new HashMap<String, SmsApplicationData>();
        for (ResolveInfo resolveInfo : smsReceivers) {
            String packageName2;
            ActivityInfo activityInfo2 = resolveInfo.activityInfo;
            if (activityInfo2 == null || !"android.permission.BROADCAST_SMS".equals(activityInfo2.permission) || receivers.containsKey(packageName2 = activityInfo2.packageName)) continue;
            String applicationName = resolveInfo.loadLabel(packageManager).toString();
            smsApplicationData2 = new SmsApplicationData(applicationName, packageName2, activityInfo2.applicationInfo.uid);
            smsApplicationData2.mSmsReceiverClass = activityInfo2.name;
            receivers.put(packageName2, smsApplicationData2);
        }
        intent = new Intent("android.provider.Telephony.WAP_PUSH_DELIVER");
        intent.setDataAndType(null, "application/vnd.wap.mms-message");
        List<ResolveInfo> mmsReceivers = packageManager.queryBroadcastReceivers(intent, 0, userId);
        for (ResolveInfo resolveInfo : mmsReceivers) {
            String packageName3;
            ActivityInfo activityInfo3 = resolveInfo.activityInfo;
            if (activityInfo3 == null || !"android.permission.BROADCAST_WAP_PUSH".equals(activityInfo3.permission) || (smsApplicationData2 = (SmsApplicationData)receivers.get(packageName3 = activityInfo3.packageName)) == null) continue;
            smsApplicationData2.mMmsReceiverClass = activityInfo3.name;
        }
        intent = new Intent("android.intent.action.RESPOND_VIA_MESSAGE", Uri.fromParts("smsto", "", null));
        List<ResolveInfo> respondServices = packageManager.queryIntentServicesAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : respondServices) {
            String packageName4;
            SmsApplicationData smsApplicationData3;
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null || !"android.permission.SEND_RESPOND_VIA_MESSAGE".equals(serviceInfo.permission) || (smsApplicationData3 = (SmsApplicationData)receivers.get(packageName4 = serviceInfo.packageName)) == null) continue;
            smsApplicationData3.mRespondViaMessageClass = serviceInfo.name;
        }
        intent = new Intent("android.intent.action.SENDTO", Uri.fromParts("smsto", "", null));
        List<ResolveInfo> sendToActivities = packageManager.queryIntentActivitiesAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : sendToActivities) {
            activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || (smsApplicationData = (SmsApplicationData)receivers.get(packageName = activityInfo.packageName)) == null) continue;
            smsApplicationData.mSendToClass = activityInfo.name;
        }
        for (ResolveInfo resolveInfo : smsReceivers) {
            activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || (smsApplicationData = (SmsApplicationData)receivers.get(packageName = activityInfo.packageName)) == null || smsApplicationData.isComplete()) continue;
            receivers.remove(packageName);
        }
        return receivers.values();
    }

    private static final SmsApplicationData $$robo$$com_android_internal_telephony_SmsApplication$getApplicationForPackage(Collection<SmsApplicationData> applications, String packageName) {
        if (packageName == null) {
            return null;
        }
        for (SmsApplicationData application : applications) {
            if (!application.mPackageName.contentEquals(packageName)) continue;
            return application;
        }
        return null;
    }

    private static final SmsApplicationData $$robo$$com_android_internal_telephony_SmsApplication$getApplication(Context context, boolean updateIfNeeded, int userId) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (!tm.isSmsCapable()) {
            return null;
        }
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollectionInternal(context, userId);
        String defaultApplication = Settings.Secure.getStringForUser(context.getContentResolver(), "sms_default_application", userId);
        SmsApplicationData applicationData = null;
        if (defaultApplication != null) {
            applicationData = SmsApplication.getApplicationForPackage(applications, defaultApplication);
        }
        if (updateIfNeeded && applicationData == null) {
            Resources r = context.getResources();
            String defaultPackage = r.getString(17039399);
            applicationData = SmsApplication.getApplicationForPackage(applications, defaultPackage);
            if (applicationData == null && applications.size() != 0) {
                applicationData = (SmsApplicationData)applications.toArray()[0];
            }
            if (applicationData != null) {
                SmsApplication.setDefaultApplicationInternal(applicationData.mPackageName, context, userId);
            }
        }
        if (applicationData != null) {
            int mode;
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            if ((updateIfNeeded || applicationData.mUid == Process.myUid()) && (mode = appOps.checkOp(15, applicationData.mUid, applicationData.mPackageName)) != 0) {
                Rlog.e("SmsApplication", applicationData.mPackageName + " lost OP_WRITE_SMS: " + (updateIfNeeded ? " (fixing)" : " (no permission to fix)"));
                if (updateIfNeeded) {
                    appOps.setMode(15, applicationData.mUid, applicationData.mPackageName, 0);
                } else {
                    applicationData = null;
                }
            }
            if (updateIfNeeded) {
                int mode2;
                PackageInfo info;
                PackageManager packageManager = context.getPackageManager();
                SmsApplication.configurePreferredActivity(packageManager, new ComponentName(applicationData.mPackageName, applicationData.mSendToClass), userId);
                try {
                    info = packageManager.getPackageInfo("com.android.phone", 0);
                    mode2 = appOps.checkOp(15, info.applicationInfo.uid, "com.android.phone");
                    if (mode2 != 0) {
                        Rlog.e("SmsApplication", "com.android.phone lost OP_WRITE_SMS:  (fixing)");
                        appOps.setMode(15, info.applicationInfo.uid, "com.android.phone", 0);
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    Rlog.e("SmsApplication", "Phone package not found: com.android.phone");
                    applicationData = null;
                }
                try {
                    info = packageManager.getPackageInfo("com.android.bluetooth", 0);
                    mode2 = appOps.checkOp(15, info.applicationInfo.uid, "com.android.bluetooth");
                    if (mode2 != 0) {
                        Rlog.e("SmsApplication", "com.android.bluetooth lost OP_WRITE_SMS:  (fixing)");
                        appOps.setMode(15, info.applicationInfo.uid, "com.android.bluetooth", 0);
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    Rlog.e("SmsApplication", "Bluetooth package not found: com.android.bluetooth");
                }
                try {
                    info = packageManager.getPackageInfo("com.android.mms.service", 0);
                    mode2 = appOps.checkOp(15, info.applicationInfo.uid, "com.android.mms.service");
                    if (mode2 != 0) {
                        Rlog.e("SmsApplication", "com.android.mms.service lost OP_WRITE_SMS:  (fixing)");
                        appOps.setMode(15, info.applicationInfo.uid, "com.android.mms.service", 0);
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    Rlog.e("SmsApplication", "MmsService package not found: com.android.mms.service");
                    applicationData = null;
                }
            }
        }
        return applicationData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_SmsApplication$setDefaultApplication(String packageName, Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (!tm.isSmsCapable()) {
            return;
        }
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            SmsApplication.setDefaultApplicationInternal(packageName, context, userId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_SmsApplication$setDefaultApplicationInternal(String packageName, Context context, int userId) {
        String oldPackageName = Settings.Secure.getStringForUser(context.getContentResolver(), "sms_default_application", userId);
        if (packageName != null && oldPackageName != null && packageName.equals(oldPackageName)) {
            return;
        }
        PackageManager packageManager = context.getPackageManager();
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollection(context);
        SmsApplicationData applicationData = SmsApplication.getApplicationForPackage(applications, packageName);
        if (applicationData != null) {
            PackageInfo info;
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            if (oldPackageName != null) {
                try {
                    info = packageManager.getPackageInfo(oldPackageName, 8192);
                    appOps.setMode(15, info.applicationInfo.uid, oldPackageName, 1);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Rlog.w("SmsApplication", "Old SMS package not found: " + oldPackageName);
                }
            }
            Settings.Secure.putStringForUser(context.getContentResolver(), "sms_default_application", applicationData.mPackageName, userId);
            SmsApplication.configurePreferredActivity(packageManager, new ComponentName(applicationData.mPackageName, applicationData.mSendToClass), userId);
            appOps.setMode(15, applicationData.mUid, applicationData.mPackageName, 0);
            try {
                info = packageManager.getPackageInfo("com.android.phone", 0);
                appOps.setMode(15, info.applicationInfo.uid, "com.android.phone", 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Rlog.e("SmsApplication", "Phone package not found: com.android.phone");
            }
            try {
                info = packageManager.getPackageInfo("com.android.bluetooth", 0);
                appOps.setMode(15, info.applicationInfo.uid, "com.android.bluetooth", 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Rlog.e("SmsApplication", "Bluetooth package not found: com.android.bluetooth");
            }
            try {
                info = packageManager.getPackageInfo("com.android.mms.service", 0);
                appOps.setMode(15, info.applicationInfo.uid, "com.android.mms.service", 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Rlog.e("SmsApplication", "MmsService package not found: com.android.mms.service");
            }
        }
    }

    private static final void $$robo$$com_android_internal_telephony_SmsApplication$initSmsPackageMonitor(Context context) {
        sSmsPackageMonitor = new SmsPackageMonitor(context);
        sSmsPackageMonitor.register(context, context.getMainLooper(), UserHandle.ALL, false);
    }

    private static final void $$robo$$com_android_internal_telephony_SmsApplication$configurePreferredActivity(PackageManager packageManager, ComponentName componentName, int userId) {
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, "sms");
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, "smsto");
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, "mms");
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, "mmsto");
    }

    private static final void $$robo$$com_android_internal_telephony_SmsApplication$replacePreferredActivity(PackageManager packageManager, ComponentName componentName, int userId, String scheme) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.fromParts(scheme, "", null));
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentActivitiesAsUser(intent, 65600, userId);
        int n = resolveInfoList.size();
        ComponentName[] set = new ComponentName[n];
        for (int i = 0; i < n; ++i) {
            ResolveInfo info = resolveInfoList.get(i);
            set[i] = new ComponentName(info.activityInfo.packageName, info.activityInfo.name);
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SENDTO");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        intentFilter.addDataScheme(scheme);
        packageManager.replacePreferredActivityAsUser(intentFilter, 0x208000, set, componentName, userId);
    }

    private static final SmsApplicationData $$robo$$com_android_internal_telephony_SmsApplication$getSmsApplicationData(String packageName, Context context) {
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollection(context);
        return SmsApplication.getApplicationForPackage(applications, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ComponentName $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSmsApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSmsReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ComponentName $$robo$$com_android_internal_telephony_SmsApplication$getDefaultMmsApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mMmsReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ComponentName $$robo$$com_android_internal_telephony_SmsApplication$getDefaultRespondViaMessageApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mRespondViaMessageClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ComponentName $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSendToApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSendToClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static final boolean $$robo$$com_android_internal_telephony_SmsApplication$shouldWriteMessageForPackage(String packageName, Context context) {
        if (packageName == null) {
            return true;
        }
        if (SmsManager.getDefault().getAutoPersisting()) {
            return true;
        }
        String defaultSmsPackage = null;
        ComponentName component = SmsApplication.getDefaultSmsApplication(context, false);
        if (component != null) {
            defaultSmsPackage = component.getPackageName();
        }
        return (defaultSmsPackage == null || !defaultSmsPackage.equals(packageName)) && !packageName.equals("com.android.bluetooth");
    }

    static void __staticInitializer__() {
        sSmsPackageMonitor = null;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_SmsApplication$__constructor__();
    }

    public SmsApplication() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsApplication$__constructor__(), 0, this);
    }

    private static int getIncomingUserId(Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIncomingUserId", $$robo$$com_android_internal_telephony_SmsApplication$getIncomingUserId(android.content.Context ), 0, (Context)context);
    }

    public static Collection<SmsApplicationData> getApplicationCollection(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getApplicationCollection", $$robo$$com_android_internal_telephony_SmsApplication$getApplicationCollection(android.content.Context ), 0, (Context)context);
    }

    private static Collection<SmsApplicationData> getApplicationCollectionInternal(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getApplicationCollectionInternal", $$robo$$com_android_internal_telephony_SmsApplication$getApplicationCollectionInternal(android.content.Context int ), 0, (Context)context, (int)n);
    }

    private static SmsApplicationData getApplicationForPackage(Collection<SmsApplicationData> collection, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getApplicationForPackage", $$robo$$com_android_internal_telephony_SmsApplication$getApplicationForPackage(java.util.Collection<com.android.internal.telephony.SmsApplication$SmsApplicationData> java.lang.String ), 0, collection, (String)string2);
    }

    private static SmsApplicationData getApplication(Context context, boolean bl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getApplication", $$robo$$com_android_internal_telephony_SmsApplication$getApplication(android.content.Context boolean int ), 0, (Context)context, (boolean)bl, (int)n);
    }

    public static void setDefaultApplication(String string2, Context context) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultApplication", $$robo$$com_android_internal_telephony_SmsApplication$setDefaultApplication(java.lang.String android.content.Context ), 0, (String)string2, (Context)context);
    }

    private static void setDefaultApplicationInternal(String string2, Context context, int n) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultApplicationInternal", $$robo$$com_android_internal_telephony_SmsApplication$setDefaultApplicationInternal(java.lang.String android.content.Context int ), 0, (String)string2, (Context)context, (int)n);
    }

    public static void initSmsPackageMonitor(Context context) {
        InvokeDynamicSupport.bootstrapStatic("initSmsPackageMonitor", $$robo$$com_android_internal_telephony_SmsApplication$initSmsPackageMonitor(android.content.Context ), 0, (Context)context);
    }

    private static void configurePreferredActivity(PackageManager packageManager, ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrapStatic("configurePreferredActivity", $$robo$$com_android_internal_telephony_SmsApplication$configurePreferredActivity(android.content.pm.PackageManager android.content.ComponentName int ), 0, (PackageManager)packageManager, (ComponentName)componentName, (int)n);
    }

    private static void replacePreferredActivity(PackageManager packageManager, ComponentName componentName, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("replacePreferredActivity", $$robo$$com_android_internal_telephony_SmsApplication$replacePreferredActivity(android.content.pm.PackageManager android.content.ComponentName int java.lang.String ), 0, (PackageManager)packageManager, (ComponentName)componentName, (int)n, (String)string2);
    }

    public static SmsApplicationData getSmsApplicationData(String string2, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getSmsApplicationData", $$robo$$com_android_internal_telephony_SmsApplication$getSmsApplicationData(java.lang.String android.content.Context ), 0, (String)string2, (Context)context);
    }

    public static ComponentName getDefaultSmsApplication(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultSmsApplication", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSmsApplication(android.content.Context boolean ), 0, (Context)context, (boolean)bl);
    }

    public static ComponentName getDefaultMmsApplication(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultMmsApplication", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultMmsApplication(android.content.Context boolean ), 0, (Context)context, (boolean)bl);
    }

    public static ComponentName getDefaultRespondViaMessageApplication(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultRespondViaMessageApplication", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultRespondViaMessageApplication(android.content.Context boolean ), 0, (Context)context, (boolean)bl);
    }

    public static ComponentName getDefaultSendToApplication(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultSendToApplication", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSendToApplication(android.content.Context boolean ), 0, (Context)context, (boolean)bl);
    }

    public static boolean shouldWriteMessageForPackage(String string2, Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldWriteMessageForPackage", $$robo$$com_android_internal_telephony_SmsApplication$shouldWriteMessageForPackage(java.lang.String android.content.Context ), 0, (String)string2, (Context)context);
    }

    static {
        RobolectricInternals.classInitializing(SmsApplication.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsApplication)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SmsPackageMonitor
    extends PackageMonitor
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Context mContext;

        private void $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$__constructor__(Context context) {
            this.mContext = context;
        }

        private final void $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageDisappeared(String packageName, int reason) {
            this.onPackageChanged(packageName);
        }

        private final void $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageAppeared(String packageName, int reason) {
            this.onPackageChanged(packageName);
        }

        private final void $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageModified(String packageName) {
            this.onPackageChanged(packageName);
        }

        private final void $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageChanged(String packageName) {
            ComponentName componentName;
            PackageManager packageManager = this.mContext.getPackageManager();
            Context userContext = this.mContext;
            int userId = this.getSendingUserId();
            if (userId != 0) {
                try {
                    userContext = this.mContext.createPackageContextAsUser(this.mContext.getPackageName(), 0, new UserHandle(userId));
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if ((componentName = SmsApplication.getDefaultSendToApplication(userContext, true)) != null) {
                SmsApplication.configurePreferredActivity(packageManager, componentName, userId);
            }
        }

        private void __constructor__(Context context) {
            this.$$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$__constructor__(context);
        }

        public SmsPackageMonitor(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$__constructor__(android.content.Context ), 0, this, context);
        }

        @Override
        public void onPackageDisappeared(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onPackageDisappeared", $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageDisappeared(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public void onPackageAppeared(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onPackageAppeared", $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageAppeared(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public void onPackageModified(String string2) {
            InvokeDynamicSupport.bootstrap("onPackageModified", $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageModified(java.lang.String ), 0, this, string2);
        }

        private void onPackageChanged(String string2) {
            InvokeDynamicSupport.bootstrap("onPackageChanged", $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageChanged(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ SmsPackageMonitor() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsPackageMonitor)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SmsApplicationData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String mApplicationName;
        public String mPackageName;
        public String mSmsReceiverClass;
        public String mMmsReceiverClass;
        public String mRespondViaMessageClass;
        public String mSendToClass;
        public int mUid;

        private final boolean $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$isComplete() {
            return this.mSmsReceiverClass != null && this.mMmsReceiverClass != null && this.mRespondViaMessageClass != null && this.mSendToClass != null;
        }

        private void $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$__constructor__(String applicationName, String packageName, int uid) {
            this.mApplicationName = applicationName;
            this.mPackageName = packageName;
            this.mUid = uid;
        }

        public boolean isComplete() {
            return (boolean)InvokeDynamicSupport.bootstrap("isComplete", $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$isComplete(), 0, this);
        }

        private void __constructor__(String string2, String string3, int n) {
            this.$$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$__constructor__(string2, string3, n);
        }

        public SmsApplicationData(String string2, String string3, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$__constructor__(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
        }

        public /* synthetic */ SmsApplicationData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsApplicationData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

