/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.provider.Telephony;
import android.telephony.Rlog;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.cdma.CdmaInboundSmsHandler;
import com.android.internal.telephony.gsm.GsmInboundSmsHandler;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SmsBroadcastUndelivered
implements Runnable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SmsBroadcastUndelivered";
    private static boolean DBG = true;
    static long PARTIAL_SEGMENT_EXPIRE_AGE = 2592000000L;
    private static String[] PDU_PENDING_MESSAGE_PROJECTION;
    private static Uri sRawUri;
    private ContentResolver mResolver;
    private GsmInboundSmsHandler mGsmInboundSmsHandler;
    private CdmaInboundSmsHandler mCdmaInboundSmsHandler;

    private void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$__constructor__(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        this.mResolver = context.getContentResolver();
        this.mGsmInboundSmsHandler = gsmInboundSmsHandler;
        this.mCdmaInboundSmsHandler = cdmaInboundSmsHandler;
    }

    private final void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$run() {
        Rlog.d("SmsBroadcastUndelivered", "scanning raw table for undelivered messages");
        this.scanRawTable();
        if (this.mGsmInboundSmsHandler != null) {
            this.mGsmInboundSmsHandler.sendMessage(6);
        }
        if (this.mCdmaInboundSmsHandler != null) {
            this.mCdmaInboundSmsHandler.sendMessage(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$scanRawTable() {
        CallSite startTime = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
        HashMap<SmsReferenceKey, Integer> multiPartReceivedCount = new HashMap<SmsReferenceKey, Integer>(4);
        HashSet<SmsReferenceKey> oldMultiPartMessages = new HashSet<SmsReferenceKey>(4);
        Cursor cursor = null;
        try {
            cursor = this.mResolver.query(sRawUri, PDU_PENDING_MESSAGE_PROJECTION, null, null, null);
            if (cursor == null) {
                Rlog.e("SmsBroadcastUndelivered", "error getting pending message cursor");
                return;
            }
            boolean isCurrentFormat3gpp2 = InboundSmsHandler.isCurrentFormat3gpp2();
            while (cursor.moveToNext()) {
                InboundSmsTracker tracker;
                try {
                    tracker = new InboundSmsTracker(cursor, isCurrentFormat3gpp2);
                }
                catch (IllegalArgumentException e) {
                    Rlog.e("SmsBroadcastUndelivered", "error loading SmsTracker: " + e);
                    continue;
                }
                if (tracker.getMessageCount() == 1) {
                    this.broadcastSms(tracker);
                    continue;
                }
                SmsReferenceKey reference = new SmsReferenceKey(tracker);
                Integer receivedCount = (Integer)multiPartReceivedCount.get(reference);
                if (receivedCount == null) {
                    multiPartReceivedCount.put(reference, 1);
                    if (tracker.getTimestamp() >= InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - 2592000000L) continue;
                    oldMultiPartMessages.add(reference);
                    continue;
                }
                int newCount = receivedCount + 1;
                if (newCount == tracker.getMessageCount()) {
                    Rlog.d("SmsBroadcastUndelivered", "found complete multi-part message");
                    this.broadcastSms(tracker);
                    oldMultiPartMessages.remove(reference);
                    continue;
                }
                multiPartReceivedCount.put(reference, newCount);
            }
            for (SmsReferenceKey message : oldMultiPartMessages) {
                int rows = this.mResolver.delete(sRawUri, "address=? AND reference_number=? AND count=?", message.getDeleteWhereArgs());
                if (rows == 0) {
                    Rlog.e("SmsBroadcastUndelivered", "No rows were deleted from raw table!");
                    continue;
                }
                Rlog.d("SmsBroadcastUndelivered", "Deleted " + rows + " rows from raw table for incomplete " + message.mMessageCount + " part message");
            }
        }
        catch (SQLException e) {
            Rlog.e("SmsBroadcastUndelivered", "error reading pending SMS messages", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            Rlog.d("SmsBroadcastUndelivered", "finished scanning raw table in " + (long)((InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System") - startTime) / 1000000L) + " ms");
        }
    }

    private final void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$broadcastSms(InboundSmsTracker tracker) {
        InboundSmsHandler handler = tracker.is3gpp2() ? this.mCdmaInboundSmsHandler : this.mGsmInboundSmsHandler;
        if (handler != null) {
            handler.sendMessage(2, tracker);
        } else {
            Rlog.e("SmsBroadcastUndelivered", "null handler for " + tracker.getFormat() + " format, can't deliver.");
        }
    }

    static void __staticInitializer__() {
        PDU_PENDING_MESSAGE_PROJECTION = new String[]{"pdu", "sequence", "destination_port", "date", "reference_number", "count", "address", "_id"};
        sRawUri = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw");
    }

    private void __constructor__(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        this.$$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$__constructor__(context, gsmInboundSmsHandler, cdmaInboundSmsHandler);
    }

    public SmsBroadcastUndelivered(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$__constructor__(android.content.Context com.android.internal.telephony.gsm.GsmInboundSmsHandler com.android.internal.telephony.cdma.CdmaInboundSmsHandler ), 0, this, context, gsmInboundSmsHandler, cdmaInboundSmsHandler);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$run(), 0, this);
    }

    private void scanRawTable() {
        InvokeDynamicSupport.bootstrap("scanRawTable", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$scanRawTable(), 0, this);
    }

    private void broadcastSms(InboundSmsTracker inboundSmsTracker) {
        InvokeDynamicSupport.bootstrap("broadcastSms", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$broadcastSms(com.android.internal.telephony.InboundSmsTracker ), 0, this, inboundSmsTracker);
    }

    static {
        RobolectricInternals.classInitializing(SmsBroadcastUndelivered.class);
    }

    public /* synthetic */ SmsBroadcastUndelivered() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsBroadcastUndelivered)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SmsReferenceKey
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mAddress;
        int mReferenceNumber;
        int mMessageCount;

        private void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$__constructor__(InboundSmsTracker tracker) {
            this.mAddress = tracker.getAddress();
            this.mReferenceNumber = tracker.getReferenceNumber();
            this.mMessageCount = tracker.getMessageCount();
        }

        private final String[] $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$getDeleteWhereArgs() {
            return new String[]{this.mAddress, Integer.toString(this.mReferenceNumber), Integer.toString(this.mMessageCount)};
        }

        private final int $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$hashCode() {
            return (this.mReferenceNumber * 31 + this.mMessageCount) * 31 + this.mAddress.hashCode();
        }

        private final boolean $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$equals(Object o) {
            if (o instanceof SmsReferenceKey) {
                SmsReferenceKey other = (SmsReferenceKey)o;
                return other.mAddress.equals(this.mAddress) && other.mReferenceNumber == this.mReferenceNumber && other.mMessageCount == this.mMessageCount;
            }
            return false;
        }

        private void __constructor__(InboundSmsTracker inboundSmsTracker) {
            this.$$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$__constructor__(inboundSmsTracker);
        }

        SmsReferenceKey(InboundSmsTracker inboundSmsTracker) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$__constructor__(com.android.internal.telephony.InboundSmsTracker ), 0, this, inboundSmsTracker);
        }

        String[] getDeleteWhereArgs() {
            return InvokeDynamicSupport.bootstrap("getDeleteWhereArgs", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$getDeleteWhereArgs(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$equals(java.lang.Object ), 0, this, object);
        }

        public /* synthetic */ SmsReferenceKey() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsReferenceKey)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

