/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.PhoneBase;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SmsStorageMonitor
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SmsStorageMonitor";
    private static int EVENT_ICC_FULL = 1;
    private static int EVENT_REPORT_MEMORY_STATUS_DONE = 2;
    private static int EVENT_RADIO_ON = 3;
    private Context mContext;
    private PowerManager.WakeLock mWakeLock;
    private boolean mReportMemoryStatusPending;
    PhoneBase mPhone;
    CommandsInterface mCi;
    boolean mStorageAvailable;
    private static int WAKE_LOCK_TIMEOUT = 5000;
    private BroadcastReceiver mResultReceiver;

    private void $$robo$$com_android_internal_telephony_SmsStorageMonitor$__constructor__(PhoneBase phone) {
        this.mStorageAvailable = true;
        this.mResultReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SmsStorageMonitor this$0;

            private void $$robo$$com_android_internal_telephony_SmsStorageMonitor_1$__constructor__(SmsStorageMonitor smsStorageMonitor) {
            }

            private final void $$robo$$com_android_internal_telephony_SmsStorageMonitor_1$onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.DEVICE_STORAGE_FULL")) {
                    this.this$0.mStorageAvailable = false;
                    this.this$0.mCi.reportSmsMemoryStatus(false, this.this$0.obtainMessage(2));
                } else if (intent.getAction().equals("android.intent.action.DEVICE_STORAGE_NOT_FULL")) {
                    this.this$0.mStorageAvailable = true;
                    this.this$0.mCi.reportSmsMemoryStatus(true, this.this$0.obtainMessage(2));
                }
            }

            private void __constructor__(SmsStorageMonitor smsStorageMonitor) {
                this.$$robo$$com_android_internal_telephony_SmsStorageMonitor_1$__constructor__(smsStorageMonitor);
            }
            {
                this.this$0 = smsStorageMonitor;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsStorageMonitor_1$__constructor__(com.android.internal.telephony.SmsStorageMonitor ), 0, this, smsStorageMonitor);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_SmsStorageMonitor_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mCi = phone.mCi;
        this.createWakelock();
        this.mCi.setOnIccSmsFull(this, 1, null);
        this.mCi.registerForOn(this, 3, null);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.DEVICE_STORAGE_FULL");
        filter.addAction("android.intent.action.DEVICE_STORAGE_NOT_FULL");
        this.mContext.registerReceiver(this.mResultReceiver, filter);
    }

    private final void $$robo$$com_android_internal_telephony_SmsStorageMonitor$dispose() {
        this.mCi.unSetOnIccSmsFull(this);
        this.mCi.unregisterForOn(this);
        this.mContext.unregisterReceiver(this.mResultReceiver);
    }

    private final void $$robo$$com_android_internal_telephony_SmsStorageMonitor$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.handleIccFull();
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    this.mReportMemoryStatusPending = true;
                    Rlog.v("SmsStorageMonitor", "Memory status report to modem pending : mStorageAvailable = " + this.mStorageAvailable);
                    break;
                }
                this.mReportMemoryStatusPending = false;
                break;
            }
            case 3: {
                if (!this.mReportMemoryStatusPending) break;
                Rlog.v("SmsStorageMonitor", "Sending pending memory status report : mStorageAvailable = " + this.mStorageAvailable);
                this.mCi.reportSmsMemoryStatus(this.mStorageAvailable, this.obtainMessage(2));
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_SmsStorageMonitor$createWakelock() {
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "SmsStorageMonitor");
        this.mWakeLock.setReferenceCounted(true);
    }

    private final void $$robo$$com_android_internal_telephony_SmsStorageMonitor$handleIccFull() {
        Intent intent = new Intent("android.provider.Telephony.SIM_FULL");
        this.mWakeLock.acquire(5000L);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
        this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    private final boolean $$robo$$com_android_internal_telephony_SmsStorageMonitor$isStorageAvailable() {
        return this.mStorageAvailable;
    }

    private void __constructor__(PhoneBase phoneBase) {
        this.$$robo$$com_android_internal_telephony_SmsStorageMonitor$__constructor__(phoneBase);
    }

    public SmsStorageMonitor(PhoneBase phoneBase) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsStorageMonitor$__constructor__(com.android.internal.telephony.PhoneBase ), 0, this, phoneBase);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_SmsStorageMonitor$dispose(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_SmsStorageMonitor$handleMessage(android.os.Message ), 0, this, message);
    }

    private void createWakelock() {
        InvokeDynamicSupport.bootstrap("createWakelock", $$robo$$com_android_internal_telephony_SmsStorageMonitor$createWakelock(), 0, this);
    }

    private void handleIccFull() {
        InvokeDynamicSupport.bootstrap("handleIccFull", $$robo$$com_android_internal_telephony_SmsStorageMonitor$handleIccFull(), 0, this);
    }

    public boolean isStorageAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStorageAvailable", $$robo$$com_android_internal_telephony_SmsStorageMonitor$isStorageAvailable(), 0, this);
    }

    public /* synthetic */ SmsStorageMonitor() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsStorageMonitor)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

