/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SubInfoRecord;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.format.Time;
import android.util.Log;
import com.android.internal.telephony.CallManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.uicc.SpnOverride;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubscriptionController
extends ISub.Stub
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "SubController";
    static boolean DBG = true;
    static boolean VDBG = false;
    static int MAX_LOCAL_LOG_LINES = 500;
    private ScLocalLog mLocalLog;
    protected Object mLock;
    protected boolean mSuccess;
    private static SubscriptionController sInstance;
    protected static PhoneProxy[] sProxyPhones;
    protected Context mContext;
    protected CallManager mCM;
    private static int RES_TYPE_BACKGROUND_DARK = 0;
    private static int RES_TYPE_BACKGROUND_LIGHT = 1;
    private static int[] sSimBackgroundDarkRes;
    private static int[] sSimBackgroundLightRes;
    private static HashMap<Integer, Long> mSimInfo;
    private static long mDefaultVoiceSubId;
    private static int mDefaultPhoneId;
    private static int EVENT_WRITE_MSISDN_DONE = 1;
    protected Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SubscriptionController $$robo$$com_android_internal_telephony_SubscriptionController$init(Phone phone) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new SubscriptionController(phone);
            } else {
                Log.wtf("SubController", "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SubscriptionController $$robo$$com_android_internal_telephony_SubscriptionController$init(Context c, CommandsInterface[] ci) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new SubscriptionController(c);
            } else {
                Log.wtf("SubController", "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    private static final SubscriptionController $$robo$$com_android_internal_telephony_SubscriptionController$getInstance() {
        if (sInstance == null) {
            Log.wtf("SubController", "getInstance null");
        }
        return sInstance;
    }

    private void $$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(Context c) {
        this.mLocalLog = new ScLocalLog(500);
        this.mLock = new Object();
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SubscriptionController this$0;

            private void $$robo$$com_android_internal_telephony_SubscriptionController_1$__constructor__(SubscriptionController subscriptionController) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_SubscriptionController_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            this.this$0.mSuccess = ar.exception == null;
                            this.this$0.logd("EVENT_WRITE_MSISDN_DONE, mSuccess = " + this.this$0.mSuccess);
                            this.this$0.mLock.notifyAll();
                            break;
                        }
                    }
                }
            }

            private void __constructor__(SubscriptionController subscriptionController) {
                this.$$robo$$com_android_internal_telephony_SubscriptionController_1$__constructor__(subscriptionController);
            }
            {
                this.this$0 = subscriptionController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionController_1$__constructor__(com.android.internal.telephony.SubscriptionController ), 0, this, subscriptionController);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_SubscriptionController_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = c;
        this.mCM = CallManager.getInstance();
        if (ServiceManager.getService("isub") == null) {
            ServiceManager.addService("isub", this);
        }
        this.logdl("[SubscriptionController] init by Context");
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionController$isSubInfoReady() {
        return mSimInfo.size() > 0;
    }

    private void $$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(Phone phone) {
        this.mLocalLog = new ScLocalLog(500);
        this.mLock = new Object();
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        this.mContext = phone.getContext();
        this.mCM = CallManager.getInstance();
        if (ServiceManager.getService("isub") == null) {
            ServiceManager.addService("isub", this);
        }
        this.logdl("[SubscriptionController] init by Phone");
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$enforceSubscriptionPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", "Requires READ_PHONE_STATE");
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$broadcastSimInfoContentChanged(long subId, String columnName, int intContent, String stringContent) {
        Intent intent = new Intent("android.intent.action.ACTION_SUBINFO_CONTENT_CHANGE");
        intent.putExtra("_id", subId);
        intent.putExtra("columnName", columnName);
        intent.putExtra("intContent", intContent);
        intent.putExtra("stringContent", stringContent);
        if (intContent != -100) {
            this.logd("[broadcastSimInfoContentChanged] subId" + subId + " changed, " + columnName + " -> " + intContent);
        } else {
            this.logd("[broadcastSimInfoContentChanged] subId" + subId + " changed, " + columnName + " -> " + stringContent);
        }
        this.mContext.sendBroadcast(intent);
    }

    private final SubInfoRecord $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoRecord(Cursor cursor) {
        SubInfoRecord info = new SubInfoRecord();
        info.subId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
        info.iccId = cursor.getString(cursor.getColumnIndexOrThrow("icc_id"));
        info.slotId = cursor.getInt(cursor.getColumnIndexOrThrow("sim_id"));
        info.displayName = cursor.getString(cursor.getColumnIndexOrThrow("display_name"));
        info.nameSource = cursor.getInt(cursor.getColumnIndexOrThrow("name_source"));
        info.color = cursor.getInt(cursor.getColumnIndexOrThrow("color"));
        info.number = cursor.getString(cursor.getColumnIndexOrThrow("number"));
        info.displayNumberFormat = cursor.getInt(cursor.getColumnIndexOrThrow("display_number_format"));
        info.dataRoaming = cursor.getInt(cursor.getColumnIndexOrThrow("data_roaming"));
        int size = sSimBackgroundDarkRes.length;
        if (info.color >= 0 && info.color < size) {
            info.simIconRes[0] = sSimBackgroundDarkRes[info.color];
            info.simIconRes[1] = sSimBackgroundLightRes[info.color];
        }
        info.mcc = cursor.getInt(cursor.getColumnIndexOrThrow("mcc"));
        info.mnc = cursor.getInt(cursor.getColumnIndexOrThrow("mnc"));
        this.logd("[getSubInfoRecord] SubId:" + info.subId + " iccid:" + info.iccId + " slotId:" + info.slotId + " displayName:" + info.displayName + " color:" + info.color + " mcc/mnc:" + info.mcc + "/" + info.mnc);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SubInfoRecord> $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfo(String selection, Object queryKey) {
        this.logd("selection:" + selection + " " + queryKey);
        String[] selectionArgs = null;
        if (queryKey != null) {
            selectionArgs = new String[]{queryKey.toString()};
        }
        ArrayList<SubInfoRecord> subList = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, selection, selectionArgs, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    SubInfoRecord subInfo = this.getSubInfoRecord(cursor);
                    if (subInfo == null) continue;
                    if (subList == null) {
                        subList = new ArrayList<SubInfoRecord>();
                    }
                    subList.add(subInfo);
                }
            } else {
                this.logd("Query fail");
            }
        }
        return subList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubInfoRecord $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoForSubscriber(long subId) {
        this.logd("[getSubInfoForSubscriberx]+ subId:" + subId);
        this.enforceSubscriptionPermission();
        if (subId == Long.MAX_VALUE) {
            subId = this.getDefaultSubId();
        }
        if (!SubscriptionManager.isValidSubId(subId) || !this.isSubInfoReady()) {
            this.logd("[getSubInfoForSubscriberx]- invalid subId or not ready");
            return null;
        }
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, "_id=?", new String[]{Long.toString(subId)}, null);){
            if (cursor != null && cursor.moveToFirst()) {
                this.logd("[getSubInfoForSubscriberx]- Info detail:");
                SubInfoRecord subInfoRecord = this.getSubInfoRecord(cursor);
                return subInfoRecord;
            }
        }
        this.logd("[getSubInfoForSubscriber]- null info return");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SubInfoRecord> $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoUsingIccId(String iccId) {
        this.logd("[getSubInfoUsingIccId]+ iccId:" + iccId);
        this.enforceSubscriptionPermission();
        if (iccId == null || !this.isSubInfoReady()) {
            this.logd("[getSubInfoUsingIccId]- null iccid or not ready");
            return null;
        }
        ArrayList<SubInfoRecord> subList = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, "icc_id=?", new String[]{iccId}, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    SubInfoRecord subInfo = this.getSubInfoRecord(cursor);
                    if (subInfo == null) continue;
                    if (subList == null) {
                        subList = new ArrayList<SubInfoRecord>();
                    }
                    subList.add(subInfo);
                }
            } else {
                this.logd("Query fail");
            }
        }
        return subList;
    }

    private final List<SubInfoRecord> $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoUsingSlotId(int slotId) {
        return this.getSubInfoUsingSlotIdWithCheck(slotId, true);
    }

    private final List<SubInfoRecord> $$robo$$com_android_internal_telephony_SubscriptionController$getAllSubInfoList() {
        this.logd("[getAllSubInfoList]+");
        this.enforceSubscriptionPermission();
        List<SubInfoRecord> subList = null;
        subList = this.getSubInfo(null, null);
        if (subList != null) {
            this.logd("[getAllSubInfoList]- " + subList.size() + " infos return");
        } else {
            this.logd("[getAllSubInfoList]- no info return");
        }
        return subList;
    }

    private final List<SubInfoRecord> $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubInfoList() {
        this.enforceSubscriptionPermission();
        this.logdl("[getActiveSubInfoList]+");
        List<SubInfoRecord> subList = null;
        if (!this.isSubInfoReady()) {
            this.logdl("[getActiveSubInfoList] Sub Controller not ready");
            return subList;
        }
        subList = this.getSubInfo("sim_id!=-1000", null);
        if (subList != null) {
            this.logdl("[getActiveSubInfoList]- " + subList.size() + " infos return");
        } else {
            this.logdl("[getActiveSubInfoList]- no info return");
        }
        return subList;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubInfoCount() {
        this.logd("[getActiveSubInfoCount]+");
        List<SubInfoRecord> records = this.getActiveSubInfoList();
        if (records == null) {
            this.logd("[getActiveSubInfoCount] records null");
            return 0;
        }
        this.logd("[getActiveSubInfoCount]- count: " + records.size());
        return records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getAllSubInfoCount() {
        this.logd("[getAllSubInfoCount]+");
        this.enforceSubscriptionPermission();
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, null, null, null);){
            if (cursor != null) {
                int count = cursor.getCount();
                this.logd("[getAllSubInfoCount]- " + count + " SUB(s) in DB");
                int n = count;
                return n;
            }
        }
        this.logd("[getAllSubInfoCount]- no SUB in DB");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$addSubInfoRecord(String iccId, int slotId) {
        String nameToSet;
        long[] subIds;
        this.logdl("[addSubInfoRecord]+ iccId:" + iccId + " slotId:" + slotId);
        this.enforceSubscriptionPermission();
        if (iccId == null) {
            this.logdl("[addSubInfoRecord]- null iccId");
        }
        if ((subIds = this.getSubId(slotId)) == null || subIds.length == 0) {
            this.logdl("[addSubInfoRecord]- getSubId fail");
            return 0;
        }
        SpnOverride mSpnOverride = new SpnOverride();
        String CarrierName = TelephonyManager.getDefault().getSimOperator(subIds[0]);
        this.logdl("[addSubInfoRecord] CarrierName = " + CarrierName);
        if (mSpnOverride.containsCarrier(CarrierName)) {
            nameToSet = mSpnOverride.getSpn(CarrierName) + " 0" + Integer.toString(slotId + 1);
            this.logdl("[addSubInfoRecord] Found, name = " + nameToSet);
        } else {
            nameToSet = "SUB 0" + Integer.toString(slotId + 1);
            this.logdl("[addSubInfoRecord] Not found, name = " + nameToSet);
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        try (Cursor cursor = resolver.query(SubscriptionManager.CONTENT_URI, new String[]{"_id", "sim_id", "name_source"}, "icc_id=?", new String[]{iccId}, null);){
            if (cursor == null || !cursor.moveToFirst()) {
                ContentValues value = new ContentValues();
                value.put("icc_id", iccId);
                value.put("color", slotId);
                value.put("sim_id", slotId);
                value.put("display_name", nameToSet);
                Uri uri = resolver.insert(SubscriptionManager.CONTENT_URI, value);
                this.logdl("[addSubInfoRecord]- New record created: " + uri);
            } else {
                long subId = cursor.getLong(0);
                int oldSimInfoId = cursor.getInt(1);
                int nameSource = cursor.getInt(2);
                ContentValues value = new ContentValues();
                if (slotId != oldSimInfoId) {
                    value.put("sim_id", slotId);
                }
                if (nameSource != 2) {
                    value.put("display_name", nameToSet);
                }
                if (value.size() > 0) {
                    resolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
                }
                this.logdl("[addSubInfoRecord]- Record already exist");
            }
        }
        cursor = resolver.query(SubscriptionManager.CONTENT_URI, null, "sim_id=?", new String[]{String.valueOf(slotId)}, null);
        try {
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    long subId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                    Long currentSubId = mSimInfo.get(slotId);
                    if (currentSubId == null || !SubscriptionManager.isValidSubId(currentSubId)) {
                        mSimInfo.put(slotId, subId);
                        int simCount = TelephonyManager.getDefault().getSimCount();
                        long defaultSubId = this.getDefaultSubId();
                        this.logdl("[addSubInfoRecord] mSimInfo.size=" + mSimInfo.size() + " slotId=" + slotId + " subId=" + subId + " defaultSubId=" + defaultSubId + " simCount=" + simCount);
                        if (!SubscriptionManager.isValidSubId(defaultSubId) || simCount == 1) {
                            this.setDefaultSubId(subId);
                        }
                        if (simCount == 1) {
                            this.logdl("[addSubInfoRecord] one sim set defaults to subId=" + subId);
                            this.setDefaultDataSubId(subId);
                            this.setDefaultSmsSubId(subId);
                            this.setDefaultVoiceSubId(subId);
                        }
                    } else {
                        this.logdl("[addSubInfoRecord] currentSubId != null && currentSubId is valid, IGNORE");
                    }
                    this.logdl("[addSubInfoRecord]- hashmap(" + slotId + "," + subId + ")");
                } while (cursor.moveToNext());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        int size = mSimInfo.size();
        this.logdl("[addSubInfoRecord]- info size=" + size);
        this.updateAllDataConnectionTrackers();
        return 1;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setColor(int color2, long subId) {
        this.logd("[setColor]+ color:" + color2 + " subId:" + subId);
        this.enforceSubscriptionPermission();
        this.validateSubId(subId);
        int size = sSimBackgroundDarkRes.length;
        if (color2 < 0 || color2 >= size) {
            this.logd("[setColor]- fail");
            return -1;
        }
        ContentValues value = new ContentValues(1);
        value.put("color", color2);
        this.logd("[setColor]- color:" + color2 + " set");
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.broadcastSimInfoContentChanged(subId, "color", color2, "N/A");
        return result;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayName(String displayName, long subId) {
        return this.setDisplayNameUsingSrc(displayName, subId, -1L);
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayNameUsingSrc(String displayName, long subId, long nameSource) {
        this.logd("[setDisplayName]+  displayName:" + displayName + " subId:" + subId + " nameSource:" + nameSource);
        this.enforceSubscriptionPermission();
        this.validateSubId(subId);
        String nameToSet = displayName == null ? this.mContext.getString(17039374) : displayName;
        ContentValues value = new ContentValues(1);
        value.put("display_name", nameToSet);
        if (nameSource >= 0L) {
            this.logd("Set nameSource=" + nameSource);
            value.put("name_source", nameSource);
        }
        this.logd("[setDisplayName]- mDisplayName:" + nameToSet + " set");
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.broadcastSimInfoContentChanged(subId, "display_name", -100, nameToSet);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayNumber(String number, long subId) {
        this.logd("[setDisplayNumber]+ number:" + number + " subId:" + subId);
        this.enforceSubscriptionPermission();
        this.validateSubId(subId);
        int result = 0;
        int phoneId = this.getPhoneId(subId);
        if (number == null || phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            this.logd("[setDispalyNumber]- fail");
            return -1;
        }
        ContentValues value = new ContentValues(1);
        value.put("number", number);
        this.logd("[setDisplayNumber]- number:" + number + " set");
        PhoneProxy phone = sProxyPhones[phoneId];
        String alphaTag = TelephonyManager.getDefault().getLine1AlphaTagForSubscriber(subId);
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(1);
            phone.setLine1Number(alphaTag, number, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.loge("interrupted while trying to write MSISDN");
            }
        }
        if (this.mSuccess) {
            result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.logd("[setDisplayNumber]- update result :" + result);
            this.broadcastSimInfoContentChanged(subId, "number", -100, number);
        }
        return result;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayNumberFormat(int format, long subId) {
        this.logd("[setDisplayNumberFormat]+ format:" + format + " subId:" + subId);
        this.enforceSubscriptionPermission();
        this.validateSubId(subId);
        if (format < 0) {
            this.logd("[setDisplayNumberFormat]- fail, return -1");
            return -1;
        }
        ContentValues value = new ContentValues(1);
        value.put("display_number_format", format);
        this.logd("[setDisplayNumberFormat]- format:" + format + " set");
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.broadcastSimInfoContentChanged(subId, "display_number_format", format, "N/A");
        return result;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setDataRoaming(int roaming, long subId) {
        this.logd("[setDataRoaming]+ roaming:" + roaming + " subId:" + subId);
        this.enforceSubscriptionPermission();
        this.validateSubId(subId);
        if (roaming < 0) {
            this.logd("[setDataRoaming]- fail");
            return -1;
        }
        ContentValues value = new ContentValues(1);
        value.put("data_roaming", roaming);
        this.logd("[setDataRoaming]- roaming:" + roaming + " set");
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.broadcastSimInfoContentChanged(subId, "data_roaming", roaming, "N/A");
        return result;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$setMccMnc(String mccMnc, long subId) {
        int mcc = 0;
        int mnc = 0;
        try {
            mcc = Integer.parseInt(mccMnc.substring(0, 3));
            mnc = Integer.parseInt(mccMnc.substring(3));
        }
        catch (NumberFormatException e) {
            this.logd("[setMccMnc] - couldn't parse mcc/mnc: " + mccMnc);
        }
        this.logd("[setMccMnc]+ mcc/mnc:" + mcc + "/" + mnc + " subId:" + subId);
        ContentValues value = new ContentValues(2);
        value.put("mcc", mcc);
        value.put("mnc", mnc);
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.broadcastSimInfoContentChanged(subId, "mcc", mcc, null);
        return result;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getSlotId(long subId) {
        if (subId == Long.MAX_VALUE) {
            subId = this.getDefaultSubId();
        }
        if (!SubscriptionManager.isValidSubId(subId)) {
            this.logd("[getSlotId]- subId invalid");
            return -1000;
        }
        int size = mSimInfo.size();
        if (size == 0) {
            this.logd("[getSlotId]- size == 0, return SIM_NOT_INSERTED instead");
            return -1;
        }
        for (Map.Entry<Integer, Long> entry : mSimInfo.entrySet()) {
            int sim = entry.getKey();
            long sub = entry.getValue();
            if (subId != sub) continue;
            return sim;
        }
        this.logd("[getSlotId]- return fail");
        return -1000;
    }

    @Deprecated
    private final long[] $$robo$$com_android_internal_telephony_SubscriptionController$getSubId(int slotId) {
        if (slotId == Integer.MAX_VALUE) {
            this.logd("[getSubId]- default slotId");
            slotId = this.getSlotId(this.getDefaultSubId());
        }
        long[] DUMMY_VALUES = new long[]{-1 - slotId, -1 - slotId};
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            this.logd("[getSubId]- invalid slotId");
            return null;
        }
        if (slotId < 0) {
            this.logd("[getSubId]- slotId < 0, return dummy instead");
            return DUMMY_VALUES;
        }
        int size = mSimInfo.size();
        if (size == 0) {
            this.logd("[getSubId]- size == 0, return dummy instead");
            return DUMMY_VALUES;
        }
        ArrayList<Long> subIds = new ArrayList<Long>();
        for (Map.Entry<Integer, Long> entry : mSimInfo.entrySet()) {
            int slot = entry.getKey();
            long sub = entry.getValue();
            if (slotId != slot) continue;
            subIds.add(sub);
        }
        int numSubIds = subIds.size();
        if (numSubIds == 0) {
            this.logd("[getSubId]- numSubIds == 0, return dummy instead");
            return DUMMY_VALUES;
        }
        long[] subIdArr = new long[numSubIds];
        for (int i = 0; i < numSubIds; ++i) {
            subIdArr[i] = (Long)subIds.get(i);
        }
        return subIdArr;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$getPhoneId(long subId) {
        if (subId == Long.MAX_VALUE) {
            subId = this.getDefaultSubId();
            this.logdl("[getPhoneId] asked for default subId=" + subId);
        }
        if (!SubscriptionManager.isValidSubId(subId)) {
            this.logdl("[getPhoneId]- invalid subId return=-1000");
            return -1000;
        }
        if (subId < 0L) {
            int phoneId = (int)(-1L - subId);
            return phoneId;
        }
        int size = mSimInfo.size();
        if (size == 0) {
            int phoneId = mDefaultPhoneId;
            this.logdl("[getPhoneId]- no sims, returning default phoneId=" + phoneId);
            return phoneId;
        }
        for (Map.Entry<Integer, Long> entry : mSimInfo.entrySet()) {
            int sim = entry.getKey();
            long sub = entry.getValue();
            if (subId != sub) continue;
            return sim;
        }
        int phoneId = mDefaultPhoneId;
        this.logdl("[getPhoneId]- subId=" + subId + " not found return default phoneId=" + phoneId);
        return phoneId;
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionController$clearSubInfo() {
        this.enforceSubscriptionPermission();
        this.logd("[clearSubInfo]+");
        int size = mSimInfo.size();
        if (size == 0) {
            this.logdl("[clearSubInfo]- no simInfo size=" + size);
            return 0;
        }
        mSimInfo.clear();
        this.logdl("[clearSubInfo]- clear size=" + size);
        return size;
    }

    private static final int[] $$robo$$com_android_internal_telephony_SubscriptionController$setSimResource(int type) {
        int[] simResource = null;
        switch (type) {
            case 0: {
                simResource = new int[]{17303045, 17303047, 17303046, 17303048};
                break;
            }
            case 1: {
                simResource = new int[]{17303049, 17303051, 17303050, 17303052};
            }
        }
        return simResource;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$logvl(String msg) {
        this.logv(msg);
        this.mLocalLog.log(msg);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$logv(String msg) {
        Rlog.v("SubController", msg);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$logdl(String msg) {
        this.logd(msg);
        this.mLocalLog.log(msg);
    }

    private static final void $$robo$$com_android_internal_telephony_SubscriptionController$slogd(String msg) {
        Rlog.d("SubController", msg);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$logd(String msg) {
        Rlog.d("SubController", msg);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$logel(String msg) {
        this.loge(msg);
        this.mLocalLog.log(msg);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$loge(String msg) {
        Rlog.e("SubController", msg);
    }

    @Deprecated
    private final long $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultSubId() {
        long subId = mDefaultVoiceSubId;
        return subId;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultSmsSubId(long subId) {
        if (subId == Long.MAX_VALUE) {
            throw new RuntimeException("setDefaultSmsSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultSmsSubId] subId=" + subId);
        Settings.Global.putLong(this.mContext.getContentResolver(), "multi_sim_sms", subId);
        this.broadcastDefaultSmsSubIdChanged(subId);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultSmsSubIdChanged(long subId) {
        this.logdl("[broadcastDefaultSmsSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_SMS_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x20000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private final long $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultSmsSubId() {
        long subId = Settings.Global.getLong(this.mContext.getContentResolver(), "multi_sim_sms", -1000L);
        return subId;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultVoiceSubId(long subId) {
        if (subId == Long.MAX_VALUE) {
            throw new RuntimeException("setDefaultVoiceSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultVoiceSubId] subId=" + subId);
        Settings.Global.putLong(this.mContext.getContentResolver(), "multi_sim_voice_call", subId);
        this.broadcastDefaultVoiceSubIdChanged(subId);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultVoiceSubIdChanged(long subId) {
        this.logdl("[broadcastDefaultVoiceSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_VOICE_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x20000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private final long $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultVoiceSubId() {
        long subId = Settings.Global.getLong(this.mContext.getContentResolver(), "multi_sim_voice_call", -1000L);
        return subId;
    }

    private final long $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultDataSubId() {
        long subId = Settings.Global.getLong(this.mContext.getContentResolver(), "multi_sim_data_call", -1000L);
        return subId;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultDataSubId(long subId) {
        if (subId == Long.MAX_VALUE) {
            throw new RuntimeException("setDefaultDataSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultDataSubId] subId=" + subId);
        Settings.Global.putLong(this.mContext.getContentResolver(), "multi_sim_data_call", subId);
        this.broadcastDefaultDataSubIdChanged(subId);
        this.updateAllDataConnectionTrackers();
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$updateAllDataConnectionTrackers() {
        int len = sProxyPhones.length;
        this.logdl("[updateAllDataConnectionTrackers] sProxyPhones.length=" + len);
        for (int phoneId = 0; phoneId < len; ++phoneId) {
            this.logdl("[updateAllDataConnectionTrackers] phoneId=" + phoneId);
            sProxyPhones[phoneId].updateDataConnectionTracker();
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultDataSubIdChanged(long subId) {
        this.logdl("[broadcastDefaultDataSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x20000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultSubId(long subId) {
        int phoneId;
        if (subId == Long.MAX_VALUE) {
            throw new RuntimeException("setDefaultSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultSubId] subId=" + subId);
        if (SubscriptionManager.isValidSubId(subId) && (phoneId = this.getPhoneId(subId)) >= 0 && (phoneId < TelephonyManager.getDefault().getPhoneCount() || TelephonyManager.getDefault().getSimCount() == 1)) {
            this.logdl("[setDefaultSubId] set mDefaultVoiceSubId=" + subId);
            mDefaultVoiceSubId = subId;
            String defaultMccMnc = TelephonyManager.getDefault().getSimOperator(phoneId);
            MccTable.updateMccMncConfiguration(this.mContext, defaultMccMnc, false);
            Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_SUBSCRIPTION_CHANGED");
            intent.addFlags(0x20000000);
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subId);
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$clearDefaultsForInactiveSubIds() {
        List<SubInfoRecord> records = this.getActiveSubInfoList();
        this.logdl("[clearDefaultsForInactiveSubIds] records: " + records);
        if (this.shouldDefaultBeCleared(records, this.getDefaultDataSubId())) {
            this.logd("[clearDefaultsForInactiveSubIds] clearing default data sub id");
            this.setDefaultDataSubId(-1000L);
        }
        if (this.shouldDefaultBeCleared(records, this.getDefaultSmsSubId())) {
            this.logdl("[clearDefaultsForInactiveSubIds] clearing default sms sub id");
            this.setDefaultSmsSubId(-1000L);
        }
        if (this.shouldDefaultBeCleared(records, this.getDefaultVoiceSubId())) {
            this.logdl("[clearDefaultsForInactiveSubIds] clearing default voice sub id");
            this.setDefaultVoiceSubId(-1000L);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionController$shouldDefaultBeCleared(List<SubInfoRecord> records, long subId) {
        this.logdl("[shouldDefaultBeCleared: subId] " + subId);
        if (records == null) {
            this.logdl("[shouldDefaultBeCleared] return true no records subId=" + subId);
            return true;
        }
        if (subId == -1001L && records.size() > 1) {
            this.logdl("[shouldDefaultBeCleared] return false only one subId, subId=" + subId);
            return false;
        }
        for (SubInfoRecord record : records) {
            this.logdl("[shouldDefaultBeCleared] Record.subId: " + record.subId);
            if (record.subId != subId) continue;
            this.logdl("[shouldDefaultBeCleared] return false subId is active, subId=" + subId);
            return false;
        }
        this.logdl("[shouldDefaultBeCleared] return true not active subId=" + subId);
        return true;
    }

    private final long $$robo$$com_android_internal_telephony_SubscriptionController$getSubIdUsingPhoneId(int phoneId) {
        long[] subIds = this.getSubId(phoneId);
        if (subIds == null || subIds.length == 0) {
            return -1000L;
        }
        return subIds[0];
    }

    private final long[] $$robo$$com_android_internal_telephony_SubscriptionController$getSubIdUsingSlotId(int slotId) {
        return this.getSubId(slotId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SubInfoRecord> $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoUsingSlotIdWithCheck(int slotId, boolean needCheck) {
        this.logd("[getSubInfoUsingSlotIdWithCheck]+ slotId:" + slotId);
        this.enforceSubscriptionPermission();
        if (slotId == Integer.MAX_VALUE) {
            slotId = this.getSlotId(this.getDefaultSubId());
        }
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            this.logd("[getSubInfoUsingSlotIdWithCheck]- invalid slotId");
            return null;
        }
        if (needCheck && !this.isSubInfoReady()) {
            this.logd("[getSubInfoUsingSlotIdWithCheck]- not ready");
            return null;
        }
        ArrayList<SubInfoRecord> subList = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, "sim_id=?", new String[]{String.valueOf(slotId)}, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    SubInfoRecord subInfo = this.getSubInfoRecord(cursor);
                    if (subInfo == null) continue;
                    if (subList == null) {
                        subList = new ArrayList<SubInfoRecord>();
                    }
                    subList.add(subInfo);
                }
            }
        }
        this.logd("[getSubInfoUsingSlotId]- null info return");
        return subList;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$validateSubId(long subId) {
        this.logd("validateSubId subId: " + subId);
        if (!SubscriptionManager.isValidSubId(subId)) {
            throw new RuntimeException("Invalid sub id passed as parameter");
        }
        if (subId == Long.MAX_VALUE) {
            throw new RuntimeException("Default sub id passed as parameter");
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$updatePhonesAvailability(PhoneProxy[] phones) {
        sProxyPhones = phones;
    }

    private final long[] $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubIdList() {
        Set<Map.Entry<Integer, Long>> simInfoSet = mSimInfo.entrySet();
        this.logdl("[getActiveSubIdList] simInfoSet=" + simInfoSet);
        long[] subIdArr = new long[simInfoSet.size()];
        int i = 0;
        for (Map.Entry<Integer, Long> entry : simInfoSet) {
            long sub;
            subIdArr[i] = sub = entry.getValue().longValue();
            ++i;
        }
        this.logdl("[getActiveSubIdList] X subIdArr.length=" + subIdArr.length);
        return subIdArr;
    }

    private static final void $$robo$$com_android_internal_telephony_SubscriptionController$printStackTrace(String msg) {
        RuntimeException re = new RuntimeException();
        SubscriptionController.slogd("StackTrace - " + msg);
        StackTraceElement[] st = re.getStackTrace();
        boolean first = true;
        for (StackTraceElement ste : st) {
            if (first) {
                first = false;
                continue;
            }
            SubscriptionController.slogd(ste.toString());
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionController$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        pw.println("SubscriptionController:");
        pw.println(" defaultSubId=" + this.getDefaultSubId());
        pw.println(" defaultDataSubId=" + this.getDefaultDataSubId());
        pw.println(" defaultVoiceSubId=" + this.getDefaultVoiceSubId());
        pw.println(" defaultSmsSubId=" + this.getDefaultSmsSubId());
        pw.println(" defaultDataPhoneId=" + SubscriptionManager.getDefaultDataPhoneId());
        pw.println(" defaultVoicePhoneId=" + SubscriptionManager.getDefaultVoicePhoneId());
        pw.println(" defaultSmsPhoneId=" + SubscriptionManager.getDefaultSmsPhoneId());
        pw.flush();
        for (Map.Entry<Integer, Long> entry : mSimInfo.entrySet()) {
            pw.println(" mSimInfo[" + entry.getKey() + "]: subId=" + entry.getValue());
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        List<SubInfoRecord> sirl = this.getActiveSubInfoList();
        if (sirl != null) {
            pw.println(" ActiveSubInfoList:");
            for (SubInfoRecord entry : sirl) {
                pw.println("  " + entry.toString());
            }
        } else {
            pw.println(" ActiveSubInfoList: is null");
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        sirl = this.getAllSubInfoList();
        if (sirl != null) {
            pw.println(" AllSubInfoList:");
            for (SubInfoRecord entry : sirl) {
                pw.println("  " + entry.toString());
            }
        } else {
            pw.println(" AllSubInfoList: is null");
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        this.mLocalLog.dump(fd, pw, args);
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.flush();
    }

    static void __staticInitializer__() {
        sInstance = null;
        sSimBackgroundDarkRes = SubscriptionController.setSimResource(0);
        sSimBackgroundLightRes = SubscriptionController.setSimResource(1);
        mSimInfo = new HashMap();
        mDefaultVoiceSubId = -1000L;
        mDefaultPhoneId = Integer.MAX_VALUE;
    }

    public static SubscriptionController init(Phone phone) {
        return InvokeDynamicSupport.bootstrapStatic("init", $$robo$$com_android_internal_telephony_SubscriptionController$init(com.android.internal.telephony.Phone ), 0, (Phone)phone);
    }

    public static SubscriptionController init(Context context, CommandsInterface[] commandsInterfaceArray) {
        return InvokeDynamicSupport.bootstrapStatic("init", $$robo$$com_android_internal_telephony_SubscriptionController$init(android.content.Context com.android.internal.telephony.CommandsInterface[] ), 0, (Context)context, (CommandsInterface[])commandsInterfaceArray);
    }

    public static SubscriptionController getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_SubscriptionController$getInstance(), 0);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(context);
    }

    private SubscriptionController(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(android.content.Context ), 0, this, context);
    }

    private boolean isSubInfoReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSubInfoReady", $$robo$$com_android_internal_telephony_SubscriptionController$isSubInfoReady(), 0, this);
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(phone);
    }

    private SubscriptionController(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionController$__constructor__(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    private void enforceSubscriptionPermission() {
        InvokeDynamicSupport.bootstrap("enforceSubscriptionPermission", $$robo$$com_android_internal_telephony_SubscriptionController$enforceSubscriptionPermission(), 0, this);
    }

    private void broadcastSimInfoContentChanged(long l, String string2, int n, String string3) {
        InvokeDynamicSupport.bootstrap("broadcastSimInfoContentChanged", $$robo$$com_android_internal_telephony_SubscriptionController$broadcastSimInfoContentChanged(long java.lang.String int java.lang.String ), 0, this, l, string2, n, string3);
    }

    private SubInfoRecord getSubInfoRecord(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("getSubInfoRecord", $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoRecord(android.database.Cursor ), 0, this, cursor);
    }

    private List<SubInfoRecord> getSubInfo(String string2, Object object) {
        return InvokeDynamicSupport.bootstrap("getSubInfo", $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfo(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    @Override
    public SubInfoRecord getSubInfoForSubscriber(long l) {
        return InvokeDynamicSupport.bootstrap("getSubInfoForSubscriber", $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoForSubscriber(long ), 0, this, l);
    }

    @Override
    public List<SubInfoRecord> getSubInfoUsingIccId(String string2) {
        return InvokeDynamicSupport.bootstrap("getSubInfoUsingIccId", $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoUsingIccId(java.lang.String ), 0, this, string2);
    }

    @Override
    public List<SubInfoRecord> getSubInfoUsingSlotId(int n) {
        return InvokeDynamicSupport.bootstrap("getSubInfoUsingSlotId", $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoUsingSlotId(int ), 0, this, n);
    }

    @Override
    public List<SubInfoRecord> getAllSubInfoList() {
        return InvokeDynamicSupport.bootstrap("getAllSubInfoList", $$robo$$com_android_internal_telephony_SubscriptionController$getAllSubInfoList(), 0, this);
    }

    @Override
    public List<SubInfoRecord> getActiveSubInfoList() {
        return InvokeDynamicSupport.bootstrap("getActiveSubInfoList", $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubInfoList(), 0, this);
    }

    @Override
    public int getActiveSubInfoCount() {
        return (int)InvokeDynamicSupport.bootstrap("getActiveSubInfoCount", $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubInfoCount(), 0, this);
    }

    @Override
    public int getAllSubInfoCount() {
        return (int)InvokeDynamicSupport.bootstrap("getAllSubInfoCount", $$robo$$com_android_internal_telephony_SubscriptionController$getAllSubInfoCount(), 0, this);
    }

    @Override
    public int addSubInfoRecord(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("addSubInfoRecord", $$robo$$com_android_internal_telephony_SubscriptionController$addSubInfoRecord(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public int setColor(int n, long l) {
        return (int)InvokeDynamicSupport.bootstrap("setColor", $$robo$$com_android_internal_telephony_SubscriptionController$setColor(int long ), 0, this, n, l);
    }

    @Override
    public int setDisplayName(String string2, long l) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayName", $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayName(java.lang.String long ), 0, this, string2, l);
    }

    @Override
    public int setDisplayNameUsingSrc(String string2, long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayNameUsingSrc", $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayNameUsingSrc(java.lang.String long long ), 0, this, string2, l, l2);
    }

    @Override
    public int setDisplayNumber(String string2, long l) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayNumber", $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayNumber(java.lang.String long ), 0, this, string2, l);
    }

    @Override
    public int setDisplayNumberFormat(int n, long l) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayNumberFormat", $$robo$$com_android_internal_telephony_SubscriptionController$setDisplayNumberFormat(int long ), 0, this, n, l);
    }

    @Override
    public int setDataRoaming(int n, long l) {
        return (int)InvokeDynamicSupport.bootstrap("setDataRoaming", $$robo$$com_android_internal_telephony_SubscriptionController$setDataRoaming(int long ), 0, this, n, l);
    }

    public int setMccMnc(String string2, long l) {
        return (int)InvokeDynamicSupport.bootstrap("setMccMnc", $$robo$$com_android_internal_telephony_SubscriptionController$setMccMnc(java.lang.String long ), 0, this, string2, l);
    }

    @Override
    public int getSlotId(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getSlotId", $$robo$$com_android_internal_telephony_SubscriptionController$getSlotId(long ), 0, this, l);
    }

    @Override
    @Deprecated
    public long[] getSubId(int n) {
        return InvokeDynamicSupport.bootstrap("getSubId", $$robo$$com_android_internal_telephony_SubscriptionController$getSubId(int ), 0, this, n);
    }

    @Override
    public int getPhoneId(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$com_android_internal_telephony_SubscriptionController$getPhoneId(long ), 0, this, l);
    }

    @Override
    public int clearSubInfo() {
        return (int)InvokeDynamicSupport.bootstrap("clearSubInfo", $$robo$$com_android_internal_telephony_SubscriptionController$clearSubInfo(), 0, this);
    }

    private static int[] setSimResource(int n) {
        return InvokeDynamicSupport.bootstrapStatic("setSimResource", $$robo$$com_android_internal_telephony_SubscriptionController$setSimResource(int ), 0, (int)n);
    }

    private void logvl(String string2) {
        InvokeDynamicSupport.bootstrap("logvl", $$robo$$com_android_internal_telephony_SubscriptionController$logvl(java.lang.String ), 0, this, string2);
    }

    private void logv(String string2) {
        InvokeDynamicSupport.bootstrap("logv", $$robo$$com_android_internal_telephony_SubscriptionController$logv(java.lang.String ), 0, this, string2);
    }

    private void logdl(String string2) {
        InvokeDynamicSupport.bootstrap("logdl", $$robo$$com_android_internal_telephony_SubscriptionController$logdl(java.lang.String ), 0, this, string2);
    }

    private static void slogd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("slogd", $$robo$$com_android_internal_telephony_SubscriptionController$slogd(java.lang.String ), 0, (String)string2);
    }

    private void logd(String string2) {
        InvokeDynamicSupport.bootstrap("logd", $$robo$$com_android_internal_telephony_SubscriptionController$logd(java.lang.String ), 0, this, string2);
    }

    private void logel(String string2) {
        InvokeDynamicSupport.bootstrap("logel", $$robo$$com_android_internal_telephony_SubscriptionController$logel(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_SubscriptionController$loge(java.lang.String ), 0, this, string2);
    }

    @Override
    @Deprecated
    public long getDefaultSubId() {
        return (long)InvokeDynamicSupport.bootstrap("getDefaultSubId", $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultSubId(), 0, this);
    }

    @Override
    public void setDefaultSmsSubId(long l) {
        InvokeDynamicSupport.bootstrap("setDefaultSmsSubId", $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultSmsSubId(long ), 0, this, l);
    }

    private void broadcastDefaultSmsSubIdChanged(long l) {
        InvokeDynamicSupport.bootstrap("broadcastDefaultSmsSubIdChanged", $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultSmsSubIdChanged(long ), 0, this, l);
    }

    @Override
    public long getDefaultSmsSubId() {
        return (long)InvokeDynamicSupport.bootstrap("getDefaultSmsSubId", $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultSmsSubId(), 0, this);
    }

    @Override
    public void setDefaultVoiceSubId(long l) {
        InvokeDynamicSupport.bootstrap("setDefaultVoiceSubId", $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultVoiceSubId(long ), 0, this, l);
    }

    private void broadcastDefaultVoiceSubIdChanged(long l) {
        InvokeDynamicSupport.bootstrap("broadcastDefaultVoiceSubIdChanged", $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultVoiceSubIdChanged(long ), 0, this, l);
    }

    @Override
    public long getDefaultVoiceSubId() {
        return (long)InvokeDynamicSupport.bootstrap("getDefaultVoiceSubId", $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultVoiceSubId(), 0, this);
    }

    @Override
    public long getDefaultDataSubId() {
        return (long)InvokeDynamicSupport.bootstrap("getDefaultDataSubId", $$robo$$com_android_internal_telephony_SubscriptionController$getDefaultDataSubId(), 0, this);
    }

    @Override
    public void setDefaultDataSubId(long l) {
        InvokeDynamicSupport.bootstrap("setDefaultDataSubId", $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultDataSubId(long ), 0, this, l);
    }

    private void updateAllDataConnectionTrackers() {
        InvokeDynamicSupport.bootstrap("updateAllDataConnectionTrackers", $$robo$$com_android_internal_telephony_SubscriptionController$updateAllDataConnectionTrackers(), 0, this);
    }

    private void broadcastDefaultDataSubIdChanged(long l) {
        InvokeDynamicSupport.bootstrap("broadcastDefaultDataSubIdChanged", $$robo$$com_android_internal_telephony_SubscriptionController$broadcastDefaultDataSubIdChanged(long ), 0, this, l);
    }

    public void setDefaultSubId(long l) {
        InvokeDynamicSupport.bootstrap("setDefaultSubId", $$robo$$com_android_internal_telephony_SubscriptionController$setDefaultSubId(long ), 0, this, l);
    }

    @Override
    public void clearDefaultsForInactiveSubIds() {
        InvokeDynamicSupport.bootstrap("clearDefaultsForInactiveSubIds", $$robo$$com_android_internal_telephony_SubscriptionController$clearDefaultsForInactiveSubIds(), 0, this);
    }

    private boolean shouldDefaultBeCleared(List<SubInfoRecord> list, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDefaultBeCleared", $$robo$$com_android_internal_telephony_SubscriptionController$shouldDefaultBeCleared(java.util.List<android.telephony.SubInfoRecord> long ), 0, this, list, l);
    }

    public long getSubIdUsingPhoneId(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getSubIdUsingPhoneId", $$robo$$com_android_internal_telephony_SubscriptionController$getSubIdUsingPhoneId(int ), 0, this, n);
    }

    public long[] getSubIdUsingSlotId(int n) {
        return InvokeDynamicSupport.bootstrap("getSubIdUsingSlotId", $$robo$$com_android_internal_telephony_SubscriptionController$getSubIdUsingSlotId(int ), 0, this, n);
    }

    public List<SubInfoRecord> getSubInfoUsingSlotIdWithCheck(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getSubInfoUsingSlotIdWithCheck", $$robo$$com_android_internal_telephony_SubscriptionController$getSubInfoUsingSlotIdWithCheck(int boolean ), 0, this, n, bl);
    }

    private void validateSubId(long l) {
        InvokeDynamicSupport.bootstrap("validateSubId", $$robo$$com_android_internal_telephony_SubscriptionController$validateSubId(long ), 0, this, l);
    }

    public void updatePhonesAvailability(PhoneProxy[] phoneProxyArray) {
        InvokeDynamicSupport.bootstrap("updatePhonesAvailability", $$robo$$com_android_internal_telephony_SubscriptionController$updatePhonesAvailability(com.android.internal.telephony.PhoneProxy[] ), 0, this, phoneProxyArray);
    }

    @Override
    public long[] getActiveSubIdList() {
        return InvokeDynamicSupport.bootstrap("getActiveSubIdList", $$robo$$com_android_internal_telephony_SubscriptionController$getActiveSubIdList(), 0, this);
    }

    private static void printStackTrace(String string2) {
        InvokeDynamicSupport.bootstrapStatic("printStackTrace", $$robo$$com_android_internal_telephony_SubscriptionController$printStackTrace(java.lang.String ), 0, (String)string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_SubscriptionController$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(SubscriptionController.class);
    }

    public /* synthetic */ SubscriptionController() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ScLocalLog
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private LinkedList<String> mLog;
        private int mMaxLines;
        private Time mNow;

        private void $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$__constructor__(int maxLines) {
            this.mLog = new LinkedList();
            this.mMaxLines = maxLines;
            this.mNow = new Time();
        }

        private final synchronized void $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$log(String msg) {
            if (this.mMaxLines > 0) {
                int pid = Process.myPid();
                int tid = Process.myTid();
                this.mNow.setToNow();
                this.mLog.add(this.mNow.format("%m-%d %H:%M:%S") + " pid=" + pid + " tid=" + tid + " " + msg);
                while (this.mLog.size() > this.mMaxLines) {
                    this.mLog.remove();
                }
            }
        }

        private final synchronized void $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            int LOOPS_PER_FLUSH = 10;
            ListIterator<String> itr = this.mLog.listIterator(0);
            int i = 0;
            while (itr.hasNext()) {
                pw.println(Integer.toString(i++) + ": " + (String)itr.next());
                if (i % 10 != 0) continue;
                pw.flush();
            }
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$__constructor__(n);
        }

        public ScLocalLog(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$__constructor__(int ), 0, this, n);
        }

        public synchronized void log(String string2) {
            InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$log(java.lang.String ), 0, this, string2);
        }

        public synchronized void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_SubscriptionController_ScLocalLog$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
        }

        public /* synthetic */ ScLocalLog() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScLocalLog)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

