/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.SubscriptionManager;
import android.util.Log;
import com.android.internal.telephony.IWapPushManager;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.WspTypeDecoder;
import com.android.internal.telephony.uicc.IccUtils;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.DeliveryInd;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.PduParser;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.ReadOrigInd;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WapPushOverSms
implements ServiceConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WAP PUSH";
    private static boolean DBG = true;
    private Context mContext;
    private volatile IWapPushManager mWapPushManager;
    private static String THREAD_ID_SELECTION = "m_id=? AND m_type=?";
    private static String LOCATION_SELECTION = "m_type=? AND ct_l =?";

    private final void $$robo$$com_android_internal_telephony_WapPushOverSms$onServiceConnected(ComponentName name, IBinder service) {
        this.mWapPushManager = IWapPushManager.Stub.asInterface(service);
        Rlog.v("WAP PUSH", "wappush manager connected to " + this.hashCode());
    }

    private final void $$robo$$com_android_internal_telephony_WapPushOverSms$onServiceDisconnected(ComponentName name) {
        this.mWapPushManager = null;
        Rlog.v("WAP PUSH", "wappush manager disconnected.");
    }

    private void $$robo$$com_android_internal_telephony_WapPushOverSms$__constructor__(Context context) {
        this.mContext = context;
        Intent intent = new Intent(IWapPushManager.class.getName());
        ComponentName comp = intent.resolveSystemService(context.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !context.bindService(intent, this, 1)) {
            Rlog.e("WAP PUSH", "bindService() for wappush manager failed");
        } else {
            Rlog.v("WAP PUSH", "bindService() for wappush manager succeeded");
        }
    }

    private final void $$robo$$com_android_internal_telephony_WapPushOverSms$dispose() {
        if (this.mWapPushManager != null) {
            Rlog.v("WAP PUSH", "dispose: unbind wappush manager");
            this.mContext.unbindService(this);
        } else {
            Rlog.e("WAP PUSH", "dispose: not bound to a wappush manager");
        }
    }

    private final int $$robo$$com_android_internal_telephony_WapPushOverSms$dispatchWapPdu(byte[] pdu, BroadcastReceiver receiver, InboundSmsHandler handler) {
        Rlog.d("WAP PUSH", "Rx: " + IccUtils.bytesToHexString(pdu));
        try {
            int appOp;
            String permission2;
            byte[] intentData;
            WspTypeDecoder pduDecoder;
            int index = 0;
            int transactionId = pdu[index++] & 0xFF;
            int pduType = pdu[index++] & 0xFF;
            int phoneId = handler.getPhone().getPhoneId();
            if (pduType != 6 && pduType != 7) {
                index = this.mContext.getResources().getInteger(17694835);
                if (index != -1) {
                    transactionId = pdu[index++] & 0xFF;
                    pduType = pdu[index++] & 0xFF;
                    Rlog.d("WAP PUSH", "index = " + index + " PDU Type = " + pduType + " transactionID = " + transactionId);
                    if (pduType != 6 && pduType != 7) {
                        Rlog.w("WAP PUSH", "Received non-PUSH WAP PDU. Type = " + pduType);
                        return 1;
                    }
                } else {
                    Rlog.w("WAP PUSH", "Received non-PUSH WAP PDU. Type = " + pduType);
                    return 1;
                }
            }
            if (!(pduDecoder = new WspTypeDecoder(pdu)).decodeUintvarInteger(index)) {
                Rlog.w("WAP PUSH", "Received PDU. Header Length error.");
                return 2;
            }
            int headerLength = (int)pduDecoder.getValue32();
            int headerStartIndex = index += pduDecoder.getDecodedDataLength();
            if (!pduDecoder.decodeContentType(index)) {
                Rlog.w("WAP PUSH", "Received PDU. Header Content-Type error.");
                return 2;
            }
            String mimeType = pduDecoder.getValueString();
            long binaryContentType = pduDecoder.getValue32();
            index += pduDecoder.getDecodedDataLength();
            byte[] header = new byte[headerLength];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])pdu, (int)headerStartIndex, (byte[])header, (int)0, (int)header.length);
            if (mimeType != null && mimeType.equals("application/vnd.wap.coc")) {
                intentData = pdu;
            } else {
                int dataIndex = headerStartIndex + headerLength;
                intentData = new byte[pdu.length - dataIndex];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])pdu, (int)dataIndex, (byte[])intentData, (int)0, (int)intentData.length);
            }
            if (SmsManager.getDefault().getAutoPersisting()) {
                long[] subIds = SubscriptionManager.getSubId(phoneId);
                long subId = subIds != null && subIds.length > 0 ? subIds[0] : SmsManager.getDefaultSmsSubId();
                this.writeInboxMessage(subId, intentData);
            }
            if (pduDecoder.seekXWapApplicationId(index, index + headerLength - 1)) {
                index = (int)pduDecoder.getValue32();
                pduDecoder.decodeXWapApplicationId(index);
                String wapAppId = pduDecoder.getValueString();
                if (wapAppId == null) {
                    wapAppId = Integer.toString((int)pduDecoder.getValue32());
                }
                String contentType = mimeType == null ? Long.toString(binaryContentType) : mimeType;
                Rlog.v("WAP PUSH", "appid found: " + wapAppId + ":" + contentType);
                try {
                    boolean processFurther = true;
                    IWapPushManager wapPushMan = this.mWapPushManager;
                    if (wapPushMan == null) {
                        Rlog.w("WAP PUSH", "wap push manager not found!");
                    } else {
                        Intent intent = new Intent();
                        intent.putExtra("transactionId", transactionId);
                        intent.putExtra("pduType", pduType);
                        intent.putExtra("header", header);
                        intent.putExtra("data", intentData);
                        intent.putExtra("contentTypeParameters", pduDecoder.getContentParameters());
                        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId);
                        int procRet = wapPushMan.processMessage(wapAppId, contentType, intent);
                        Rlog.v("WAP PUSH", "procRet:" + procRet);
                        if ((procRet & 1) > 0 && (procRet & 0x8000) == 0) {
                            processFurther = false;
                        }
                    }
                    if (!processFurther) {
                        return 1;
                    }
                }
                catch (RemoteException e) {
                    Rlog.w("WAP PUSH", "remote func failed...");
                }
            }
            Rlog.v("WAP PUSH", "fall back to existing handler");
            if (mimeType == null) {
                Rlog.w("WAP PUSH", "Header Content-Type error.");
                return 2;
            }
            if (mimeType.equals("application/vnd.wap.mms-message")) {
                permission2 = "android.permission.RECEIVE_MMS";
                appOp = 18;
            } else {
                permission2 = "android.permission.RECEIVE_WAP_PUSH";
                appOp = 19;
            }
            Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_DELIVER");
            intent.setType(mimeType);
            intent.putExtra("transactionId", transactionId);
            intent.putExtra("pduType", pduType);
            intent.putExtra("header", header);
            intent.putExtra("data", intentData);
            intent.putExtra("contentTypeParameters", pduDecoder.getContentParameters());
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId);
            ComponentName componentName = SmsApplication.getDefaultMmsApplication(this.mContext, true);
            if (componentName != null) {
                intent.setComponent(componentName);
                Rlog.v("WAP PUSH", "Delivering MMS to: " + componentName.getPackageName() + " " + componentName.getClassName());
            }
            handler.dispatchIntent(intent, permission2, appOp, receiver, UserHandle.OWNER);
            return -1;
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            Rlog.e("WAP PUSH", "ignoring dispatchWapPdu() array index exception: " + aie);
            return 2;
        }
    }

    private final void $$robo$$com_android_internal_telephony_WapPushOverSms$writeInboxMessage(long subId, byte[] pushData) {
        GenericPdu pdu = new PduParser(pushData).parse();
        if (pdu == null) {
            Rlog.e("WAP PUSH", "Invalid PUSH PDU");
        }
        PduPersister persister = PduPersister.getPduPersister(this.mContext);
        int type = pdu.getMessageType();
        try {
            switch (type) {
                case 134: 
                case 136: {
                    long threadId = WapPushOverSms.getDeliveryOrReadReportThreadId(this.mContext, pdu);
                    if (threadId == -1L) {
                        Rlog.e("WAP PUSH", "Failed to find delivery or read report's thread id");
                        break;
                    }
                    Uri uri = persister.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI, true, true, null);
                    if (uri == null) {
                        Rlog.e("WAP PUSH", "Failed to persist delivery or read report");
                        break;
                    }
                    ContentValues values = new ContentValues(1);
                    values.put("thread_id", threadId);
                    if (SqliteWrapper.update(this.mContext, this.mContext.getContentResolver(), uri, values, null, null) != 1) {
                        Rlog.e("WAP PUSH", "Failed to update delivery or read report thread id");
                    }
                    break;
                }
                case 130: {
                    byte[] contentLocation;
                    NotificationInd nInd = (NotificationInd)pdu;
                    Bundle configs = SmsManager.getSmsManagerForSubscriber(subId).getCarrierConfigValues();
                    if (configs != null && configs.getBoolean("enabledTransID", false) && 61 == (contentLocation = nInd.getContentLocation())[contentLocation.length - 1]) {
                        byte[] transactionId = nInd.getTransactionId();
                        byte[] contentLocationWithId = new byte[contentLocation.length + transactionId.length];
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])contentLocation, (int)0, (byte[])contentLocationWithId, (int)0, (int)contentLocation.length);
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])transactionId, (int)0, (byte[])contentLocationWithId, (int)contentLocation.length, (int)transactionId.length);
                        nInd.setContentLocation(contentLocationWithId);
                    }
                    if (!WapPushOverSms.isDuplicateNotification(this.mContext, nInd)) {
                        Uri uri = persister.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI, true, true, null);
                        if (uri == null) {
                            Rlog.e("WAP PUSH", "Failed to save MMS WAP push notification ind");
                        }
                        break;
                    }
                    Rlog.d("WAP PUSH", "Skip storing duplicate MMS WAP push notification ind: " + new String(nInd.getContentLocation()));
                    break;
                }
                default: {
                    Log.e("WAP PUSH", "Received unrecognized WAP Push PDU.");
                }
            }
        }
        catch (MmsException e) {
            Log.e("WAP PUSH", "Failed to save MMS WAP push data: type=" + type, e);
        }
        catch (RuntimeException e) {
            Log.e("WAP PUSH", "Unexpected RuntimeException in persisting MMS WAP push data", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long $$robo$$com_android_internal_telephony_WapPushOverSms$getDeliveryOrReadReportThreadId(Context context, GenericPdu pdu) {
        String messageId;
        if (pdu instanceof DeliveryInd) {
            messageId = new String(((DeliveryInd)pdu).getMessageId());
        } else if (pdu instanceof ReadOrigInd) {
            messageId = new String(((ReadOrigInd)pdu).getMessageId());
        } else {
            Rlog.e("WAP PUSH", "WAP Push data is neither delivery or read report type: " + pdu.getClass().getCanonicalName());
            return -1L;
        }
        try (Cursor cursor = null;){
            cursor = SqliteWrapper.query(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, new String[]{"thread_id"}, "m_id=? AND m_type=?", new String[]{DatabaseUtils.sqlEscapeString(messageId), Integer.toString(128)}, null);
            if (cursor != null && cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$com_android_internal_telephony_WapPushOverSms$isDuplicateNotification(Context context, NotificationInd nInd) {
        byte[] rawLocation = nInd.getContentLocation();
        if (rawLocation != null) {
            String location = new String(rawLocation);
            String[] selectionArgs = new String[]{location};
            try (Cursor cursor = null;){
                cursor = SqliteWrapper.query(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, new String[]{"_id"}, "m_type=? AND ct_l =?", new String[]{Integer.toString(130), new String(rawLocation)}, null);
                if (cursor != null && cursor.getCount() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    @Override
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_telephony_WapPushOverSms$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
    }

    @Override
    public void onServiceDisconnected(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_telephony_WapPushOverSms$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_WapPushOverSms$__constructor__(context);
    }

    public WapPushOverSms(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_WapPushOverSms$__constructor__(android.content.Context ), 0, this, context);
    }

    void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_WapPushOverSms$dispose(), 0, this);
    }

    public int dispatchWapPdu(byte[] byArray, BroadcastReceiver broadcastReceiver, InboundSmsHandler inboundSmsHandler) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchWapPdu", $$robo$$com_android_internal_telephony_WapPushOverSms$dispatchWapPdu(byte[] android.content.BroadcastReceiver com.android.internal.telephony.InboundSmsHandler ), 0, this, byArray, broadcastReceiver, inboundSmsHandler);
    }

    private void writeInboxMessage(long l, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("writeInboxMessage", $$robo$$com_android_internal_telephony_WapPushOverSms$writeInboxMessage(long byte[] ), 0, this, l, byArray);
    }

    private static long getDeliveryOrReadReportThreadId(Context context, GenericPdu genericPdu) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDeliveryOrReadReportThreadId", $$robo$$com_android_internal_telephony_WapPushOverSms$getDeliveryOrReadReportThreadId(android.content.Context com.google.android.mms.pdu.GenericPdu ), 0, (Context)context, (GenericPdu)genericPdu);
    }

    private static boolean isDuplicateNotification(Context context, NotificationInd notificationInd) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDuplicateNotification", $$robo$$com_android_internal_telephony_WapPushOverSms$isDuplicateNotification(android.content.Context com.google.android.mms.pdu.NotificationInd ), 0, (Context)context, (NotificationInd)notificationInd);
    }

    public /* synthetic */ WapPushOverSms() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WapPushOverSms)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

