/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemProperties;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.cat.AppInterface;
import com.android.internal.telephony.cat.BIPClientParams;
import com.android.internal.telephony.cat.CallSetupParams;
import com.android.internal.telephony.cat.CatCmdMessage;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.CatResponseMessage;
import com.android.internal.telephony.cat.CommandDetails;
import com.android.internal.telephony.cat.CommandParams;
import com.android.internal.telephony.cat.ComprehensionTlvTag;
import com.android.internal.telephony.cat.DTTZResponseData;
import com.android.internal.telephony.cat.DisplayTextParams;
import com.android.internal.telephony.cat.Duration;
import com.android.internal.telephony.cat.GetInkeyInputResponseData;
import com.android.internal.telephony.cat.Input;
import com.android.internal.telephony.cat.LanguageResponseData;
import com.android.internal.telephony.cat.LaunchBrowserParams;
import com.android.internal.telephony.cat.Menu;
import com.android.internal.telephony.cat.ResponseData;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.RilMessage;
import com.android.internal.telephony.cat.RilMessageDecoder;
import com.android.internal.telephony.cat.SelectItemResponseData;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CatService
extends Handler
implements AppInterface,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static IccRecords mIccRecords;
    private static UiccCardApplication mUiccApplication;
    private static Object sInstanceLock;
    private static CatService sInstance;
    private CommandsInterface mCmdIf;
    private Context mContext;
    private CatCmdMessage mCurrntCmd;
    private CatCmdMessage mMenuCmd;
    private RilMessageDecoder mMsgDecoder;
    private boolean mStkAppInstalled;
    private UiccController mUiccController;
    private IccCardStatus.CardState mCardState;
    protected static int MSG_ID_SESSION_END = 1;
    protected static int MSG_ID_PROACTIVE_COMMAND = 2;
    protected static int MSG_ID_EVENT_NOTIFY = 3;
    protected static int MSG_ID_CALL_SETUP = 4;
    static int MSG_ID_REFRESH = 5;
    static int MSG_ID_RESPONSE = 6;
    static int MSG_ID_SIM_READY = 7;
    protected static int MSG_ID_ICC_CHANGED = 8;
    protected static int MSG_ID_ALPHA_NOTIFY = 9;
    static int MSG_ID_RIL_MSG_DECODED = 10;
    private static int MSG_ID_ICC_RECORDS_LOADED = 20;
    private static int MSG_ID_ICC_REFRESH = 30;
    private static int DEV_ID_KEYPAD = 1;
    private static int DEV_ID_UICC = 129;
    private static int DEV_ID_TERMINAL = 130;
    private static int DEV_ID_NETWORK = 131;
    static String STK_DEFAULT = "Default Message";
    private HandlerThread mHandlerThread;
    private int mSlotId;

    private void $$robo$$com_android_internal_telephony_cat_CatService$__constructor__(CommandsInterface ci, UiccCardApplication ca, IccRecords ir, Context context, IccFileHandler fh, UiccCard ic, int slotId) {
        this.mCurrntCmd = null;
        this.mMenuCmd = null;
        this.mMsgDecoder = null;
        this.mStkAppInstalled = false;
        this.mCardState = IccCardStatus.CardState.CARDSTATE_ABSENT;
        if (ci == null || ca == null || ir == null || context == null || fh == null || ic == null) {
            throw new NullPointerException("Service: Input parameters must not be null");
        }
        this.mCmdIf = ci;
        this.mContext = context;
        this.mSlotId = slotId;
        this.mHandlerThread = new HandlerThread("Cat Telephony service" + slotId);
        this.mHandlerThread.start();
        this.mMsgDecoder = RilMessageDecoder.getInstance(this, fh, slotId);
        if (null == this.mMsgDecoder) {
            CatLog.d(this, "Null RilMessageDecoder instance");
            return;
        }
        this.mMsgDecoder.start();
        this.mCmdIf.setOnCatSessionEnd(this, 1, null);
        this.mCmdIf.setOnCatProactiveCmd(this, 2, null);
        this.mCmdIf.setOnCatEvent(this, 3, null);
        this.mCmdIf.setOnCatCallSetUp(this, 4, null);
        this.mCmdIf.registerForIccRefresh(this, 30, null);
        mIccRecords = ir;
        mUiccApplication = ca;
        CatLog.d(this, "registerForReady slotid: " + this.mSlotId + "instance : " + this);
        mIccRecords.registerForRecordsLoaded(this, 20, null);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 8, null);
        this.mStkAppInstalled = this.isStkAppInstalled();
        CatLog.d(this, "Running CAT service on Slotid: " + this.mSlotId + ". STK app installed:" + this.mStkAppInstalled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CatService $$robo$$com_android_internal_telephony_cat_CatService$getInstance(CommandsInterface ci, Context context, UiccCard ic, int slotId) {
        UiccCardApplication ca = null;
        IccFileHandler fh = null;
        IccRecords ir = null;
        if (ic != null && (ca = ic.getApplicationIndex(0)) != null) {
            fh = ca.getIccFileHandler();
            ir = ca.getIccRecords();
        }
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                if (ci == null || ca == null || ir == null || context == null || fh == null || ic == null) {
                    return null;
                }
                sInstance = new CatService(ci, ca, ir, context, fh, ic, slotId);
            } else if (ir != null && mIccRecords != ir) {
                if (mIccRecords != null) {
                    mIccRecords.unregisterForRecordsLoaded(sInstance);
                }
                mIccRecords = ir;
                mUiccApplication = ca;
                mIccRecords.registerForRecordsLoaded(sInstance, 20, null);
            }
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cat_CatService$dispose() {
        Object object = sInstanceLock;
        synchronized (object) {
            CatLog.d(this, "Disposing CatService object");
            mIccRecords.unregisterForRecordsLoaded(this);
            this.broadcastCardStateAndIccRefreshResp(IccCardStatus.CardState.CARDSTATE_ABSENT, null);
            this.mCmdIf.unSetOnCatSessionEnd(this);
            this.mCmdIf.unSetOnCatProactiveCmd(this);
            this.mCmdIf.unSetOnCatEvent(this);
            this.mCmdIf.unSetOnCatCallSetUp(this);
            this.mCmdIf.unregisterForIccRefresh(this);
            if (this.mUiccController != null) {
                this.mUiccController.unregisterForIccChanged(this);
                this.mUiccController = null;
            }
            if (mUiccApplication != null) {
                mUiccApplication.unregisterForReady(this);
            }
            this.mMsgDecoder.dispose();
            this.mMsgDecoder = null;
            this.mHandlerThread.quit();
            this.mHandlerThread = null;
            this.removeCallbacksAndMessages(null);
            sInstance = null;
        }
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$finalize() {
        CatLog.d(this, "Service finalized");
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$handleRilMsg(RilMessage rilMsg) {
        if (rilMsg == null) {
            return;
        }
        CommandParams cmdParams = null;
        switch (rilMsg.mId) {
            case 3: {
                if (rilMsg.mResCode != ResultCode.OK || (cmdParams = (CommandParams)rilMsg.mData) == null) break;
                this.handleCommand(cmdParams, false);
                break;
            }
            case 2: {
                try {
                    cmdParams = (CommandParams)rilMsg.mData;
                }
                catch (ClassCastException e) {
                    CatLog.d(this, "Fail to parse proactive command");
                    if (this.mCurrntCmd == null) break;
                    this.sendTerminalResponse(this.mCurrntCmd.mCmdDet, ResultCode.CMD_DATA_NOT_UNDERSTOOD, false, 0, null);
                    break;
                }
                if (cmdParams == null) break;
                if (rilMsg.mResCode == ResultCode.OK) {
                    this.handleCommand(cmdParams, true);
                    break;
                }
                this.sendTerminalResponse(cmdParams.mCmdDet, rilMsg.mResCode, false, 0, null);
                break;
            }
            case 5: {
                cmdParams = (CommandParams)rilMsg.mData;
                if (cmdParams == null) break;
                this.handleCommand(cmdParams, false);
                break;
            }
            case 1: {
                this.handleSessionEnd();
                break;
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$handleCommand(CommandParams cmdParams, boolean isProactiveCmd) {
        CatLog.d(this, cmdParams.getCommandType().name());
        CatCmdMessage cmdMsg = new CatCmdMessage(cmdParams);
        switch (1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[cmdParams.getCommandType().ordinal()]) {
            case 1: {
                this.mMenuCmd = this.removeMenu(cmdMsg.getMenu()) ? null : cmdMsg;
                this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, null);
                break;
            }
            case 2: {
                if (cmdMsg.geTextMessage().responseNeeded) break;
                this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, null);
                break;
            }
            case 3: {
                cmdParams.mCmdDet.typeOfCommand = AppInterface.CommandType.SET_UP_IDLE_MODE_TEXT.value();
                break;
            }
            case 4: {
                this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, null);
                break;
            }
            case 5: {
                switch (cmdParams.mCmdDet.commandQualifier) {
                    case 3: {
                        DTTZResponseData resp = new DTTZResponseData(null);
                        this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, resp);
                        break;
                    }
                    case 4: {
                        LanguageResponseData resp = new LanguageResponseData(Locale.getDefault().getLanguage());
                        this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, resp);
                        break;
                    }
                    default: {
                        this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, null);
                    }
                }
                return;
            }
            case 6: {
                if (((LaunchBrowserParams)cmdParams).mConfirmMsg.text == null || !((LaunchBrowserParams)cmdParams).mConfirmMsg.text.equals("Default Message")) break;
                CharSequence message = this.mContext.getText(17040820);
                ((LaunchBrowserParams)cmdParams).mConfirmMsg.text = message.toString();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                if (((DisplayTextParams)cmdParams).mTextMsg.text == null || !((DisplayTextParams)cmdParams).mTextMsg.text.equals("Default Message")) break;
                CharSequence message = this.mContext.getText(17040819);
                ((DisplayTextParams)cmdParams).mTextMsg.text = message.toString();
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                if (((CallSetupParams)cmdParams).mConfirmMsg.text == null || !((CallSetupParams)cmdParams).mConfirmMsg.text.equals("Default Message")) break;
                CharSequence message = this.mContext.getText(17040821);
                ((CallSetupParams)cmdParams).mConfirmMsg.text = message.toString();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                BIPClientParams cmd = (BIPClientParams)cmdParams;
                boolean noAlphaUsrCnf = false;
                try {
                    noAlphaUsrCnf = this.mContext.getResources().getBoolean(17956970);
                }
                catch (Resources.NotFoundException e) {
                    noAlphaUsrCnf = false;
                }
                if (cmd.mTextMsg.text == null && (cmd.mHasAlphaId || noAlphaUsrCnf)) {
                    CatLog.d(this, "cmd " + (Object)((Object)cmdParams.getCommandType()) + " with null alpha id");
                    if (isProactiveCmd) {
                        this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, null);
                    } else if (cmdParams.getCommandType() == AppInterface.CommandType.OPEN_CHANNEL) {
                        this.mCmdIf.handleCallSetupRequestFromSim(true, null);
                    }
                    return;
                }
                if (!this.mStkAppInstalled) {
                    CatLog.d(this, "No STK application found.");
                    if (isProactiveCmd) {
                        this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.BEYOND_TERMINAL_CAPABILITY, false, 0, null);
                        return;
                    }
                }
                if (!isProactiveCmd || cmdParams.getCommandType() != AppInterface.CommandType.CLOSE_CHANNEL && cmdParams.getCommandType() != AppInterface.CommandType.RECEIVE_DATA && cmdParams.getCommandType() != AppInterface.CommandType.SEND_DATA) break;
                this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, null);
                break;
            }
            default: {
                CatLog.d(this, "Unsupported command");
                return;
            }
        }
        this.mCurrntCmd = cmdMsg;
        this.broadcastCatCmdIntent(cmdMsg);
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$broadcastCatCmdIntent(CatCmdMessage cmdMsg) {
        Intent intent = new Intent("android.intent.action.stk.command");
        intent.putExtra("STK CMD", cmdMsg);
        intent.putExtra("SLOT_ID", this.mSlotId);
        CatLog.d(this, "Sending CmdMsg: " + cmdMsg + " on slotid:" + this.mSlotId);
        this.mContext.sendBroadcast(intent);
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$handleSessionEnd() {
        CatLog.d(this, "SESSION END on " + this.mSlotId);
        this.mCurrntCmd = this.mMenuCmd;
        Intent intent = new Intent("android.intent.action.stk.session_end");
        intent.putExtra("SLOT_ID", this.mSlotId);
        this.mContext.sendBroadcast(intent);
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$sendTerminalResponse(CommandDetails cmdDet, ResultCode resultCode, boolean includeAdditionalInfo, int additionalInfo, ResponseData resp) {
        if (cmdDet == null) {
            return;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        Input cmdInput = null;
        if (this.mCurrntCmd != null) {
            cmdInput = this.mCurrntCmd.geInput();
        }
        int tag = ComprehensionTlvTag.COMMAND_DETAILS.value();
        if (cmdDet.compRequired) {
            tag |= 0x80;
        }
        buf.write(tag);
        buf.write(3);
        buf.write(cmdDet.commandNumber);
        buf.write(cmdDet.typeOfCommand);
        buf.write(cmdDet.commandQualifier);
        tag = ComprehensionTlvTag.DEVICE_IDENTITIES.value();
        buf.write(tag);
        buf.write(2);
        buf.write(130);
        buf.write(129);
        tag = ComprehensionTlvTag.RESULT.value();
        if (cmdDet.compRequired) {
            tag |= 0x80;
        }
        buf.write(tag);
        int length = includeAdditionalInfo ? 2 : 1;
        buf.write(length);
        buf.write(resultCode.value());
        if (includeAdditionalInfo) {
            buf.write(additionalInfo);
        }
        if (resp != null) {
            resp.format(buf);
        } else {
            this.encodeOptionalTags(cmdDet, resultCode, cmdInput, buf);
        }
        byte[] rawData = buf.toByteArray();
        String hexString = IccUtils.bytesToHexString(rawData);
        this.mCmdIf.sendTerminalResponse(hexString, null);
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$encodeOptionalTags(CommandDetails cmdDet, ResultCode resultCode, Input cmdInput, ByteArrayOutputStream buf) {
        block7: {
            block6: {
                AppInterface.CommandType cmdType = AppInterface.CommandType.fromInt(cmdDet.typeOfCommand);
                if (cmdType == null) break block6;
                switch (1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[cmdType.ordinal()]) {
                    case 9: {
                        if (resultCode.value() == ResultCode.NO_RESPONSE_FROM_USER.value() && cmdInput != null && cmdInput.duration != null) {
                            this.getInKeyResponse(buf, cmdInput);
                            break;
                        }
                        break block7;
                    }
                    case 5: {
                        if (cmdDet.commandQualifier == 4 && resultCode.value() == ResultCode.OK.value()) {
                            this.getPliResponse(buf);
                            break;
                        }
                        break block7;
                    }
                    default: {
                        CatLog.d(this, "encodeOptionalTags() Unsupported Cmd details=" + cmdDet);
                        break;
                    }
                }
                break block7;
            }
            CatLog.d(this, "encodeOptionalTags() bad Cmd details=" + cmdDet);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$getInKeyResponse(ByteArrayOutputStream buf, Input cmdInput) {
        int tag = ComprehensionTlvTag.DURATION.value();
        buf.write(tag);
        buf.write(2);
        Duration.TimeUnit cfr_ignored_0 = cmdInput.duration.timeUnit;
        buf.write(Duration.TimeUnit.SECOND.value());
        buf.write(cmdInput.duration.timeInterval);
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$getPliResponse(ByteArrayOutputStream buf) {
        String lang = SystemProperties.get("persist.sys.language");
        if (lang != null) {
            int tag = ComprehensionTlvTag.LANGUAGE.value();
            buf.write(tag);
            ResponseData.writeLength(buf, lang.length());
            buf.write(lang.getBytes(), 0, lang.length());
        }
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$sendMenuSelection(int menuId, boolean helpRequired) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int tag = 211;
        buf.write(tag);
        buf.write(0);
        tag = 0x80 | ComprehensionTlvTag.DEVICE_IDENTITIES.value();
        buf.write(tag);
        buf.write(2);
        buf.write(1);
        buf.write(129);
        tag = 0x80 | ComprehensionTlvTag.ITEM_ID.value();
        buf.write(tag);
        buf.write(1);
        buf.write(menuId);
        if (helpRequired) {
            tag = ComprehensionTlvTag.HELP_REQUEST.value();
            buf.write(tag);
            buf.write(0);
        }
        byte[] rawData = buf.toByteArray();
        int len = rawData.length - 2;
        rawData[1] = (byte)len;
        String hexString = IccUtils.bytesToHexString(rawData);
        this.mCmdIf.sendEnvelope(hexString, null);
    }

    private static final AppInterface $$robo$$com_android_internal_telephony_cat_CatService$getInstance() {
        int slotId = 0;
        SubscriptionController sControl = SubscriptionController.getInstance();
        if (sControl != null) {
            slotId = sControl.getSlotId(sControl.getDefaultSubId());
        }
        return CatService.getInstance(null, null, null, slotId);
    }

    private static final AppInterface $$robo$$com_android_internal_telephony_cat_CatService$getInstance(int slotId) {
        return CatService.getInstance(null, null, null, slotId);
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$handleMessage(Message msg) {
        CatLog.d(this, "handleMessage[" + msg.what + "]");
        switch (msg.what) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                AsyncResult ar;
                CatLog.d(this, "ril message arrived,slotid:" + this.mSlotId);
                String data = null;
                if (msg.obj != null && (ar = (AsyncResult)msg.obj) != null && ar.result != null) {
                    try {
                        data = (String)ar.result;
                    }
                    catch (ClassCastException e) {
                        break;
                    }
                }
                this.mMsgDecoder.sendStartDecodingMessageParams(new RilMessage(msg.what, data));
                break;
            }
            case 4: {
                this.mMsgDecoder.sendStartDecodingMessageParams(new RilMessage(msg.what, null));
                break;
            }
            case 20: {
                break;
            }
            case 10: {
                this.handleRilMsg((RilMessage)msg.obj);
                break;
            }
            case 6: {
                this.handleCmdResponse((CatResponseMessage)msg.obj);
                break;
            }
            case 8: {
                CatLog.d(this, "MSG_ID_ICC_CHANGED");
                this.updateIccAvailability();
                break;
            }
            case 30: {
                if (msg.obj != null) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar != null && ar.result != null) {
                        this.broadcastCardStateAndIccRefreshResp(IccCardStatus.CardState.CARDSTATE_PRESENT, (IccRefreshResponse)ar.result);
                        break;
                    }
                    CatLog.d(this, "Icc REFRESH with exception: " + ar.exception);
                    break;
                }
                CatLog.d(this, "IccRefresh Message is null");
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized CAT command: " + msg.what));
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$broadcastCardStateAndIccRefreshResp(IccCardStatus.CardState cardState, IccRefreshResponse iccRefreshState) {
        boolean cardPresent;
        Intent intent = new Intent("android.intent.action.stk.icc_status_change");
        boolean bl = cardPresent = cardState == IccCardStatus.CardState.CARDSTATE_PRESENT;
        if (iccRefreshState != null) {
            intent.putExtra("refresh_result", iccRefreshState.refreshResult);
            CatLog.d(this, "Sending IccResult with Result: " + iccRefreshState.refreshResult);
        }
        intent.putExtra("card_status", cardPresent);
        CatLog.d(this, "Sending Card Status: " + (Object)((Object)cardState) + " " + "cardPresent: " + cardPresent);
        this.mContext.sendBroadcast(intent);
    }

    private final synchronized void $$robo$$com_android_internal_telephony_cat_CatService$onCmdResponse(CatResponseMessage resMsg) {
        if (resMsg == null) {
            return;
        }
        Message msg = this.obtainMessage(6, resMsg);
        msg.sendToTarget();
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CatService$validateResponse(CatResponseMessage resMsg) {
        if (this.mCurrntCmd != null) {
            return resMsg.mCmdDet.compareTo(this.mCurrntCmd.mCmdDet);
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CatService$removeMenu(Menu menu2) {
        try {
            if (menu2.items.size() == 1 && menu2.items.get(0) == null) {
                return true;
            }
        }
        catch (NullPointerException e) {
            CatLog.d(this, "Unable to get Menu's items size");
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$handleCmdResponse(CatResponseMessage resMsg) {
        if (!this.validateResponse(resMsg)) {
            return;
        }
        ResponseData resp = null;
        boolean helpRequired = false;
        CommandDetails cmdDet = resMsg.getCmdDetails();
        AppInterface.CommandType type = AppInterface.CommandType.fromInt(cmdDet.typeOfCommand);
        block0 : switch (1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[resMsg.mResCode.ordinal()]) {
            case 1: {
                helpRequired = true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                switch (1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[type.ordinal()]) {
                    case 1: {
                        helpRequired = resMsg.mResCode == ResultCode.HELP_INFO_REQUIRED;
                        this.sendMenuSelection(resMsg.mUsersMenuSelection, helpRequired);
                        return;
                    }
                    case 7: {
                        resp = new SelectItemResponseData(resMsg.mUsersMenuSelection);
                        break;
                    }
                    case 8: 
                    case 9: {
                        Input input = this.mCurrntCmd.geInput();
                        if (!input.yesNo) {
                            if (helpRequired) break block0;
                            resp = new GetInkeyInputResponseData(resMsg.mUsersInput, input.ucs2, input.packed);
                            break;
                        }
                        resp = new GetInkeyInputResponseData(resMsg.mUsersYesNoSelection);
                        break;
                    }
                    case 2: 
                    case 6: {
                        break;
                    }
                    case 15: 
                    case 16: {
                        this.mCmdIf.handleCallSetupRequestFromSim(resMsg.mUsersConfirm, null);
                        this.mCurrntCmd = null;
                        return;
                    }
                }
                break;
            }
            case 13: 
            case 14: {
                if (type == AppInterface.CommandType.SET_UP_CALL || type == AppInterface.CommandType.OPEN_CHANNEL) {
                    this.mCmdIf.handleCallSetupRequestFromSim(false, null);
                    this.mCurrntCmd = null;
                    return;
                }
                resp = null;
                break;
            }
            case 15: 
            case 16: {
                resp = null;
                break;
            }
            default: {
                return;
            }
        }
        this.sendTerminalResponse(cmdDet, resMsg.mResCode, resMsg.mIncludeAdditionalInfo, resMsg.mAdditionalInfo, resp);
        this.mCurrntCmd = null;
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_CatService$isStkAppInstalled() {
        Intent intent = new Intent("android.intent.action.stk.command");
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> broadcastReceivers = pm.queryBroadcastReceivers(intent, 128);
        int numReceiver = broadcastReceivers == null ? 0 : broadcastReceivers.size();
        return numReceiver > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cat_CatService$update(CommandsInterface ci, Context context, UiccCard ic) {
        UiccCardApplication ca = null;
        IccRecords ir = null;
        if (ic != null && (ca = ic.getApplicationIndex(0)) != null) {
            ir = ca.getIccRecords();
        }
        Object object = sInstanceLock;
        synchronized (object) {
            if (ir != null && mIccRecords != ir) {
                if (mIccRecords != null) {
                    mIccRecords.unregisterForRecordsLoaded(this);
                }
                if (mUiccApplication != null) {
                    CatLog.d(this, "unregisterForReady slotid: " + this.mSlotId + "instance : " + this);
                    mUiccApplication.unregisterForReady(this);
                }
                CatLog.d(this, "Reinitialize the Service with SIMRecords and UiccCardApplication");
                mIccRecords = ir;
                mUiccApplication = ca;
                mIccRecords.registerForRecordsLoaded(this, 20, null);
                CatLog.d(this, "registerForReady slotid: " + this.mSlotId + "instance : " + this);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cat_CatService$updateIccAvailability() {
        if (null == this.mUiccController) {
            return;
        }
        IccCardStatus.CardState newState = IccCardStatus.CardState.CARDSTATE_ABSENT;
        UiccCard newCard = this.mUiccController.getUiccCard(this.mSlotId);
        if (newCard != null) {
            newState = newCard.getCardState();
        }
        IccCardStatus.CardState oldState = this.mCardState;
        this.mCardState = newState;
        CatLog.d(this, "New Card State = " + (Object)((Object)newState) + " " + "Old Card State = " + (Object)((Object)oldState));
        if (oldState == IccCardStatus.CardState.CARDSTATE_PRESENT && newState != IccCardStatus.CardState.CARDSTATE_PRESENT) {
            this.broadcastCardStateAndIccRefreshResp(newState, null);
        } else if (oldState != IccCardStatus.CardState.CARDSTATE_PRESENT && newState == IccCardStatus.CardState.CARDSTATE_PRESENT) {
            this.mCmdIf.reportStkServiceIsRunning(null);
        }
    }

    static void __staticInitializer__() {
        sInstanceLock = new Object();
    }

    private void __constructor__(CommandsInterface commandsInterface, UiccCardApplication uiccCardApplication, IccRecords iccRecords, Context context, IccFileHandler iccFileHandler, UiccCard uiccCard, int n) {
        this.$$robo$$com_android_internal_telephony_cat_CatService$__constructor__(commandsInterface, uiccCardApplication, iccRecords, context, iccFileHandler, uiccCard, n);
    }

    private CatService(CommandsInterface commandsInterface, UiccCardApplication uiccCardApplication, IccRecords iccRecords, Context context, IccFileHandler iccFileHandler, UiccCard uiccCard, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_CatService$__constructor__(com.android.internal.telephony.CommandsInterface com.android.internal.telephony.uicc.UiccCardApplication com.android.internal.telephony.uicc.IccRecords android.content.Context com.android.internal.telephony.uicc.IccFileHandler com.android.internal.telephony.uicc.UiccCard int ), 0, this, commandsInterface, uiccCardApplication, iccRecords, context, iccFileHandler, uiccCard, n);
    }

    public static CatService getInstance(CommandsInterface commandsInterface, Context context, UiccCard uiccCard, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_cat_CatService$getInstance(com.android.internal.telephony.CommandsInterface android.content.Context com.android.internal.telephony.uicc.UiccCard int ), 0, (CommandsInterface)commandsInterface, (Context)context, (UiccCard)uiccCard, (int)n);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cat_CatService$dispose(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_cat_CatService$finalize(), 0, this);
    }

    private void handleRilMsg(RilMessage rilMessage) {
        InvokeDynamicSupport.bootstrap("handleRilMsg", $$robo$$com_android_internal_telephony_cat_CatService$handleRilMsg(com.android.internal.telephony.cat.RilMessage ), 0, this, rilMessage);
    }

    private void handleCommand(CommandParams commandParams, boolean bl) {
        InvokeDynamicSupport.bootstrap("handleCommand", $$robo$$com_android_internal_telephony_cat_CatService$handleCommand(com.android.internal.telephony.cat.CommandParams boolean ), 0, this, commandParams, bl);
    }

    private void broadcastCatCmdIntent(CatCmdMessage catCmdMessage) {
        InvokeDynamicSupport.bootstrap("broadcastCatCmdIntent", $$robo$$com_android_internal_telephony_cat_CatService$broadcastCatCmdIntent(com.android.internal.telephony.cat.CatCmdMessage ), 0, this, catCmdMessage);
    }

    private void handleSessionEnd() {
        InvokeDynamicSupport.bootstrap("handleSessionEnd", $$robo$$com_android_internal_telephony_cat_CatService$handleSessionEnd(), 0, this);
    }

    private void sendTerminalResponse(CommandDetails commandDetails, ResultCode resultCode, boolean bl, int n, ResponseData responseData) {
        InvokeDynamicSupport.bootstrap("sendTerminalResponse", $$robo$$com_android_internal_telephony_cat_CatService$sendTerminalResponse(com.android.internal.telephony.cat.CommandDetails com.android.internal.telephony.cat.ResultCode boolean int com.android.internal.telephony.cat.ResponseData ), 0, this, commandDetails, resultCode, bl, n, responseData);
    }

    private void encodeOptionalTags(CommandDetails commandDetails, ResultCode resultCode, Input input, ByteArrayOutputStream byteArrayOutputStream) {
        InvokeDynamicSupport.bootstrap("encodeOptionalTags", $$robo$$com_android_internal_telephony_cat_CatService$encodeOptionalTags(com.android.internal.telephony.cat.CommandDetails com.android.internal.telephony.cat.ResultCode com.android.internal.telephony.cat.Input java.io.ByteArrayOutputStream ), 0, this, commandDetails, resultCode, input, byteArrayOutputStream);
    }

    private void getInKeyResponse(ByteArrayOutputStream byteArrayOutputStream, Input input) {
        InvokeDynamicSupport.bootstrap("getInKeyResponse", $$robo$$com_android_internal_telephony_cat_CatService$getInKeyResponse(java.io.ByteArrayOutputStream com.android.internal.telephony.cat.Input ), 0, this, byteArrayOutputStream, input);
    }

    private void getPliResponse(ByteArrayOutputStream byteArrayOutputStream) {
        InvokeDynamicSupport.bootstrap("getPliResponse", $$robo$$com_android_internal_telephony_cat_CatService$getPliResponse(java.io.ByteArrayOutputStream ), 0, this, byteArrayOutputStream);
    }

    private void sendMenuSelection(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendMenuSelection", $$robo$$com_android_internal_telephony_cat_CatService$sendMenuSelection(int boolean ), 0, this, n, bl);
    }

    public static AppInterface getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_cat_CatService$getInstance(), 0);
    }

    public static AppInterface getInstance(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_cat_CatService$getInstance(int ), 0, (int)n);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_cat_CatService$handleMessage(android.os.Message ), 0, this, message);
    }

    private void broadcastCardStateAndIccRefreshResp(IccCardStatus.CardState cardState, IccRefreshResponse iccRefreshResponse) {
        InvokeDynamicSupport.bootstrap("broadcastCardStateAndIccRefreshResp", $$robo$$com_android_internal_telephony_cat_CatService$broadcastCardStateAndIccRefreshResp(com.android.internal.telephony.uicc.IccCardStatus$CardState com.android.internal.telephony.uicc.IccRefreshResponse ), 0, this, cardState, iccRefreshResponse);
    }

    @Override
    public synchronized void onCmdResponse(CatResponseMessage catResponseMessage) {
        InvokeDynamicSupport.bootstrap("onCmdResponse", $$robo$$com_android_internal_telephony_cat_CatService$onCmdResponse(com.android.internal.telephony.cat.CatResponseMessage ), 0, this, catResponseMessage);
    }

    private boolean validateResponse(CatResponseMessage catResponseMessage) {
        return (boolean)InvokeDynamicSupport.bootstrap("validateResponse", $$robo$$com_android_internal_telephony_cat_CatService$validateResponse(com.android.internal.telephony.cat.CatResponseMessage ), 0, this, catResponseMessage);
    }

    private boolean removeMenu(Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeMenu", $$robo$$com_android_internal_telephony_cat_CatService$removeMenu(com.android.internal.telephony.cat.Menu ), 0, this, menu2);
    }

    private void handleCmdResponse(CatResponseMessage catResponseMessage) {
        InvokeDynamicSupport.bootstrap("handleCmdResponse", $$robo$$com_android_internal_telephony_cat_CatService$handleCmdResponse(com.android.internal.telephony.cat.CatResponseMessage ), 0, this, catResponseMessage);
    }

    private boolean isStkAppInstalled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStkAppInstalled", $$robo$$com_android_internal_telephony_cat_CatService$isStkAppInstalled(), 0, this);
    }

    public void update(CommandsInterface commandsInterface, Context context, UiccCard uiccCard) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_cat_CatService$update(com.android.internal.telephony.CommandsInterface android.content.Context com.android.internal.telephony.uicc.UiccCard ), 0, this, commandsInterface, context, uiccCard);
    }

    void updateIccAvailability() {
        InvokeDynamicSupport.bootstrap("updateIccAvailability", $$robo$$com_android_internal_telephony_cat_CatService$updateIccAvailability(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(CatService.class);
    }

    public /* synthetic */ CatService() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CatService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$cat$ResultCode;

        static void __staticInitializer__() {
            $SwitchMap$com$android$internal$telephony$cat$ResultCode = new int[ResultCode.values().length];
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.HELP_INFO_REQUIRED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.OK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.PRFRMD_WITH_PARTIAL_COMPREHENSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.PRFRMD_WITH_MISSING_INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.PRFRMD_WITH_ADDITIONAL_EFS_READ.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.PRFRMD_ICON_NOT_DISPLAYED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.PRFRMD_MODIFIED_BY_NAA.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.PRFRMD_LIMITED_SERVICE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.PRFRMD_WITH_MODIFICATION.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.PRFRMD_NAA_NOT_ACTIVE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.PRFRMD_TONE_NOT_PLAYED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.TERMINAL_CRNTLY_UNABLE_TO_PROCESS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.BACKWARD_MOVE_BY_USER.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.USER_NOT_ACCEPT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.NO_RESPONSE_FROM_USER.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$ResultCode[ResultCode.UICC_SESSION_TERM_BY_USER.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType = new int[AppInterface.CommandType.values().length];
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.SET_UP_MENU.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.DISPLAY_TEXT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.REFRESH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.SET_UP_IDLE_MODE_TEXT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.PROVIDE_LOCAL_INFORMATION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.LAUNCH_BROWSER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.SELECT_ITEM.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.GET_INPUT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.GET_INKEY.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.SEND_DTMF.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.SEND_SMS.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.SEND_SS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.SEND_USSD.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.PLAY_TONE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.SET_UP_CALL.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.OPEN_CHANNEL.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.CLOSE_CHANNEL.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.RECEIVE_DATA.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$cat$AppInterface$CommandType[AppInterface.CommandType.SEND_DATA.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

