/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.os.SystemProperties;
import android.text.TextUtils;
import com.android.internal.telephony.cat.AppInterface;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.ResponseData;
import java.io.ByteArrayOutputStream;
import java.util.Calendar;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DTTZResponseData
extends ResponseData
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Calendar mCalendar;

    private void $$robo$$com_android_internal_telephony_cat_DTTZResponseData$__constructor__(Calendar cal) {
        this.mCalendar = cal;
    }

    private final void $$robo$$com_android_internal_telephony_cat_DTTZResponseData$format(ByteArrayOutputStream buf) {
        if (buf == null) {
            return;
        }
        int tag = 0x80 | AppInterface.CommandType.PROVIDE_LOCAL_INFORMATION.value();
        buf.write(tag);
        byte[] data = new byte[8];
        data[0] = 7;
        if (this.mCalendar == null) {
            this.mCalendar = Calendar.getInstance();
        }
        data[1] = this.byteToBCD(this.mCalendar.get(1) % 100);
        data[2] = this.byteToBCD(this.mCalendar.get(2) + 1);
        data[3] = this.byteToBCD(this.mCalendar.get(5));
        data[4] = this.byteToBCD(this.mCalendar.get(11));
        data[5] = this.byteToBCD(this.mCalendar.get(12));
        data[6] = this.byteToBCD(this.mCalendar.get(13));
        String tz = SystemProperties.get("persist.sys.timezone", "");
        if (TextUtils.isEmpty(tz)) {
            data[7] = -1;
        } else {
            TimeZone zone = TimeZone.getTimeZone(tz);
            int zoneOffset = zone.getRawOffset() + zone.getDSTSavings();
            data[7] = this.getTZOffSetByte(zoneOffset);
        }
        for (byte b : data) {
            buf.write(b);
        }
    }

    private final byte $$robo$$com_android_internal_telephony_cat_DTTZResponseData$byteToBCD(int value) {
        if (value < 0 && value > 99) {
            CatLog.d(this, "Err: byteToBCD conversion Value is " + value + " Value has to be between 0 and 99");
            return 0;
        }
        return (byte)(value / 10 | value % 10 << 4);
    }

    private final byte $$robo$$com_android_internal_telephony_cat_DTTZResponseData$getTZOffSetByte(long offSetVal) {
        boolean isNegative = offSetVal < 0L;
        long tzOffset = offSetVal / 900000L;
        tzOffset = (long)(isNegative ? -1 : 1) * tzOffset;
        byte bcdVal = this.byteToBCD((int)tzOffset);
        return isNegative ? (bcdVal = (byte)(bcdVal | 8)) : bcdVal;
    }

    private void __constructor__(Calendar calendar) {
        this.$$robo$$com_android_internal_telephony_cat_DTTZResponseData$__constructor__(calendar);
    }

    public DTTZResponseData(Calendar calendar) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_DTTZResponseData$__constructor__(java.util.Calendar ), 0, this, calendar);
    }

    @Override
    public void format(ByteArrayOutputStream byteArrayOutputStream) {
        InvokeDynamicSupport.bootstrap("format", $$robo$$com_android_internal_telephony_cat_DTTZResponseData$format(java.io.ByteArrayOutputStream ), 0, this, byteArrayOutputStream);
    }

    private byte byteToBCD(int n) {
        return (byte)InvokeDynamicSupport.bootstrap("byteToBCD", $$robo$$com_android_internal_telephony_cat_DTTZResponseData$byteToBCD(int ), 0, this, n);
    }

    private byte getTZOffSetByte(long l) {
        return (byte)InvokeDynamicSupport.bootstrap("getTZOffSetByte", $$robo$$com_android_internal_telephony_cat_DTTZResponseData$getTZOffSetByte(long ), 0, this, l);
    }

    public /* synthetic */ DTTZResponseData() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DTTZResponseData)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

