/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.ContentValues;
import android.content.Context;
import android.database.SQLException;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaLteServiceStateTracker;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.cdma.EriManager;
import com.android.internal.telephony.cdma.RuimPhoneBookInterfaceManager;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.IsimUiccRecords;
import com.android.internal.telephony.uicc.RuimRecords;
import com.android.internal.telephony.uicc.SIMRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CDMALTEPhone
extends CDMAPhone
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_LTE_TAG = "CDMALTEPhone";
    private static boolean DBG = true;
    private SIMRecords mSimRecords;
    private IsimUiccRecords mIsimUiccRecords;

    private void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier, int phoneId) {
    }

    private void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier, boolean unitTestMode, int phoneId) {
        Rlog.d("CDMAPhone", "CDMALTEPhone: constructor: sub = " + this.mPhoneId);
        this.mDcTracker = new DcTracker(this);
    }

    private void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier) {
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$handleMessage(Message msg) {
        switch (msg.what) {
            case 500: {
                this.log("EVENT_SUBSCRIPTION_ACTIVATED");
                this.onSubscriptionActivated();
                break;
            }
            case 501: {
                this.log("EVENT_SUBSCRIPTION_DEACTIVATED");
                this.onSubscriptionDeactivated();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$initSstIcc() {
        this.mSST = new CdmaLteServiceStateTracker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            super.dispose();
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$removeReferences() {
        super.removeReferences();
    }

    private final PhoneConstants.DataState $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getDataConnectionState(String apnType) {
        PhoneConstants.DataState ret = PhoneConstants.DataState.DISCONNECTED;
        if (this.mSST == null) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (!this.mDcTracker.isApnTypeEnabled(apnType)) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else {
            switch (1.$SwitchMap$com$android$internal$telephony$DctConstants$State[this.mDcTracker.getState(apnType).ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    ret = PhoneConstants.DataState.DISCONNECTED;
                    break;
                }
                case 4: 
                case 5: {
                    if (this.mCT.mState != PhoneConstants.State.IDLE && !this.mSST.isConcurrentVoiceAndDataAllowed()) {
                        ret = PhoneConstants.DataState.SUSPENDED;
                        break;
                    }
                    ret = PhoneConstants.DataState.CONNECTED;
                    break;
                }
                case 6: 
                case 7: {
                    ret = PhoneConstants.DataState.CONNECTING;
                }
            }
        }
        this.log("getDataConnectionState apnType=" + apnType + " ret=" + (Object)((Object)ret));
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$updateCurrentCarrierInProvider(String operatorNumeric) {
        boolean retVal;
        if (this.mUiccController.getUiccCardApplication(this.mPhoneId, 1) == null) {
            this.log("updateCurrentCarrierInProvider APP_FAM_3GPP == null");
            retVal = super.updateCurrentCarrierInProvider(operatorNumeric);
        } else {
            this.log("updateCurrentCarrierInProvider not updated");
            retVal = true;
        }
        this.log("updateCurrentCarrierInProvider X retVal=" + retVal);
        return retVal;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$updateCurrentCarrierInProvider() {
        long currentDds = SubscriptionManager.getDefaultDataSubId();
        String operatorNumeric = this.getOperatorNumeric();
        Rlog.d("CDMAPhone", "updateCurrentCarrierInProvider: mSubscription = " + this.getSubId() + " currentDds = " + currentDds + " operatorNumeric = " + operatorNumeric);
        if (!TextUtils.isEmpty(operatorNumeric) && this.getSubId() == currentDds) {
            try {
                Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                ContentValues map = new ContentValues();
                map.put("numeric", operatorNumeric);
                this.mContext.getContentResolver().insert(uri, map);
                return true;
            }
            catch (SQLException e) {
                Rlog.e("CDMAPhone", "Can't store current operator", e);
            }
        }
        return false;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getSubscriberId() {
        return this.mSimRecords != null ? this.mSimRecords.getIMSI() : "";
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getGroupIdLevel1() {
        return this.mSimRecords != null ? this.mSimRecords.getGid1() : "";
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getImei() {
        return this.mImei;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getDeviceSvn() {
        return this.mImeiSv;
    }

    private final IsimRecords $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getIsimRecords() {
        return this.mIsimUiccRecords;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getMsisdn() {
        return this.mSimRecords != null ? this.mSimRecords.getMsisdnNumber() : null;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getAvailableNetworks(Message response) {
        this.mCi.getAvailableNetworks(response);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$onUpdateIccAvailability() {
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 3);
        IsimUiccRecords newIsimUiccRecords = null;
        if (newUiccApplication != null) {
            newIsimUiccRecords = (IsimUiccRecords)newUiccApplication.getIccRecords();
        }
        this.mIsimUiccRecords = newIsimUiccRecords;
        newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
        SIMRecords newSimRecords = null;
        if (newUiccApplication != null) {
            newSimRecords = (SIMRecords)newUiccApplication.getIccRecords();
        }
        this.mSimRecords = newSimRecords;
        super.onUpdateIccAvailability();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$init(Context context, PhoneNotifier notifier) {
        this.mCi.setPhoneType(2);
        this.mCT = new CdmaCallTracker(this);
        this.mCdmaSSM = CdmaSubscriptionSourceManager.getInstance(context, this.mCi, this, 27, null);
        this.mRuimPhoneBookInterfaceManager = new RuimPhoneBookInterfaceManager(this);
        this.mSubInfo = new PhoneSubInfo(this);
        this.mEriManager = new EriManager(this, context, 0);
        this.mCi.registerForAvailable(this, 1, null);
        this.mCi.registerForOffOrNotAvailable(this, 8, null);
        this.mCi.registerForOn(this, 5, null);
        this.mCi.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttached(this, 19, null);
        this.mCi.setEmergencyCallbackMode(this, 25, null);
        this.mCi.registerForExitEmergencyCallbackMode(this, 26, null);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "CDMAPhone");
        String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
        this.mIsPhoneInEcmState = inEcm.equals("true");
        if (this.mIsPhoneInEcmState) {
            this.mCi.exitEmergencyCallbackMode(this.obtainMessage(26));
        }
        this.mCarrierOtaSpNumSchema = SystemProperties.get("ro.cdma.otaspnumschema", "");
        this.setProperties();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$onSubscriptionActivated() {
        this.log("SUBSCRIPTION ACTIVATED : slotId : " + this.mSubscriptionData.slotId + " appid : " + this.mSubscriptionData.m3gpp2Index + " subId : " + this.mSubscriptionData.subId + " subStatus : " + (Object)((Object)this.mSubscriptionData.subStatus));
        this.setProperties();
        this.onUpdateIccAvailability();
        this.mSST.sendMessage(this.mSST.obtainMessage(42));
        ((CdmaLteServiceStateTracker)this.mSST).updateCdmaSubscription();
        ((DcTracker)this.mDcTracker).updateRecords();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$onSubscriptionDeactivated() {
        this.log("SUBSCRIPTION DEACTIVATED");
        this.mSubscriptionData = null;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$setProperties() {
        this.setSystemProperty("gsm.current.phone-type", new Integer(2).toString());
        String operatorAlpha = SystemProperties.get("ro.cdma.home.operator.alpha");
        if (!TextUtils.isEmpty(operatorAlpha)) {
            this.setSystemProperty("gsm.sim.operator.alpha", operatorAlpha);
        }
        String operatorNumeric = SystemProperties.get(PROPERTY_CDMA_HOME_OPERATOR_NUMERIC);
        this.log("update icc_operator_numeric=" + operatorNumeric);
        if (!TextUtils.isEmpty(operatorNumeric)) {
            this.setSystemProperty("gsm.sim.operator.numeric", operatorNumeric);
            SubscriptionController.getInstance().setMccMnc(operatorNumeric, this.getSubId());
            this.setIsoCountryProperty(operatorNumeric);
            this.log("update mccmnc=" + operatorNumeric);
            MccTable.updateMccMncConfiguration(this.mContext, operatorNumeric, false);
        }
        this.updateCurrentCarrierInProvider();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$setSystemProperty(String property, String value) {
        if (this.getUnitTestMode()) {
            return;
        }
        TelephonyManager.setTelephonyProperty(property, this.getSubId(), value);
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getSystemProperty(String property, String defValue) {
        if (this.getUnitTestMode()) {
            return null;
        }
        return TelephonyManager.getTelephonyProperty(property, this.getSubId(), defValue);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$updateDataConnectionTracker() {
        ((DcTracker)this.mDcTracker).update();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$setInternalDataEnabled(boolean enable, Message onCompleteMsg) {
        ((DcTracker)this.mDcTracker).setInternalDataEnabled(enable, onCompleteMsg);
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$setInternalDataEnabledFlag(boolean enable) {
        return ((DcTracker)this.mDcTracker).setInternalDataEnabledFlag(enable);
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getOperatorNumeric() {
        String operatorNumeric = null;
        IccRecords curIccRecords = null;
        if (this.mCdmaSubscriptionSource == 1) {
            operatorNumeric = SystemProperties.get("ro.cdma.home.operator.numeric");
        } else if (this.mCdmaSubscriptionSource == 0) {
            curIccRecords = this.mSimRecords;
            if (curIccRecords != null) {
                operatorNumeric = curIccRecords.getOperatorNumeric();
            } else {
                curIccRecords = (IccRecords)this.mIccRecords.get();
                if (curIccRecords != null && curIccRecords instanceof RuimRecords) {
                    RuimRecords csim = (RuimRecords)curIccRecords;
                    operatorNumeric = csim.getRUIMOperatorNumeric();
                }
            }
        }
        if (operatorNumeric == null) {
            Rlog.e("CDMAPhone", "getOperatorNumeric: Cannot retrieve operatorNumeric: mCdmaSubscriptionSource = " + this.mCdmaSubscriptionSource + " mIccRecords = " + (curIccRecords != null ? Boolean.valueOf(curIccRecords.getRecordsLoaded()) : null));
        }
        Rlog.d("CDMAPhone", "getOperatorNumeric: mCdmaSubscriptionSource = " + this.mCdmaSubscriptionSource + " operatorNumeric = " + operatorNumeric);
        return operatorNumeric;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$registerForAllDataDisconnected(Handler h, int what, Object obj) {
        ((DcTracker)this.mDcTracker).registerForAllDataDisconnected(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$unregisterForAllDataDisconnected(Handler h) {
        ((DcTracker)this.mDcTracker).unregisterForAllDataDisconnected(h);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$log(String s) {
        Rlog.d("CDMALTEPhone", s);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$loge(String s) {
        Rlog.e("CDMALTEPhone", s);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$loge(String s, Throwable e) {
        Rlog.e("CDMALTEPhone", s, e);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CDMALTEPhone extends:");
        super.dump(fd, pw, args);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, int n) {
        this.$$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$__constructor__(context, commandsInterface, phoneNotifier, n);
    }

    public CDMALTEPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, int n) {
        this(context, commandsInterface, phoneNotifier, false, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier int ), 0, this, context, commandsInterface, phoneNotifier, n);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl, int n) {
        this.$$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$__constructor__(context, commandsInterface, phoneNotifier, bl, n);
    }

    public CDMALTEPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl, int n) {
        super(context, commandsInterface, phoneNotifier, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier boolean int ), 0, this, context, commandsInterface, phoneNotifier, bl, n);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier) {
        this.$$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$__constructor__(context, commandsInterface, phoneNotifier);
    }

    public CDMALTEPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier) {
        super(context, commandsInterface, phoneNotifier, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier ), 0, this, context, commandsInterface, phoneNotifier);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$handleMessage(android.os.Message ), 0, this, message);
    }

    @Override
    protected void initSstIcc() {
        InvokeDynamicSupport.bootstrap("initSstIcc", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$initSstIcc(), 0, this);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$dispose(), 0, this);
    }

    @Override
    public void removeReferences() {
        InvokeDynamicSupport.bootstrap("removeReferences", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$removeReferences(), 0, this);
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState(String string2) {
        return InvokeDynamicSupport.bootstrap("getDataConnectionState", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getDataConnectionState(java.lang.String ), 0, this, string2);
    }

    @Override
    boolean updateCurrentCarrierInProvider(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateCurrentCarrierInProvider", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$updateCurrentCarrierInProvider(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean updateCurrentCarrierInProvider() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateCurrentCarrierInProvider", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$updateCurrentCarrierInProvider(), 0, this);
    }

    @Override
    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getSubscriberId(), 0, this);
    }

    @Override
    public String getGroupIdLevel1() {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getGroupIdLevel1(), 0, this);
    }

    @Override
    public String getImei() {
        return InvokeDynamicSupport.bootstrap("getImei", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getImei(), 0, this);
    }

    @Override
    public String getDeviceSvn() {
        return InvokeDynamicSupport.bootstrap("getDeviceSvn", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getDeviceSvn(), 0, this);
    }

    @Override
    public IsimRecords getIsimRecords() {
        return InvokeDynamicSupport.bootstrap("getIsimRecords", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getIsimRecords(), 0, this);
    }

    @Override
    public String getMsisdn() {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getMsisdn(), 0, this);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        InvokeDynamicSupport.bootstrap("getAvailableNetworks", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getAvailableNetworks(android.os.Message ), 0, this, message);
    }

    @Override
    protected void onUpdateIccAvailability() {
        InvokeDynamicSupport.bootstrap("onUpdateIccAvailability", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$onUpdateIccAvailability(), 0, this);
    }

    @Override
    protected void init(Context context, PhoneNotifier phoneNotifier) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$init(android.content.Context com.android.internal.telephony.PhoneNotifier ), 0, this, context, phoneNotifier);
    }

    private void onSubscriptionActivated() {
        InvokeDynamicSupport.bootstrap("onSubscriptionActivated", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$onSubscriptionActivated(), 0, this);
    }

    private void onSubscriptionDeactivated() {
        InvokeDynamicSupport.bootstrap("onSubscriptionDeactivated", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$onSubscriptionDeactivated(), 0, this);
    }

    private void setProperties() {
        InvokeDynamicSupport.bootstrap("setProperties", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$setProperties(), 0, this);
    }

    @Override
    public void setSystemProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSystemProperty", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$setSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public String getSystemProperty(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getSystemProperty", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void updateDataConnectionTracker() {
        InvokeDynamicSupport.bootstrap("updateDataConnectionTracker", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$updateDataConnectionTracker(), 0, this);
    }

    public void setInternalDataEnabled(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setInternalDataEnabled", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$setInternalDataEnabled(boolean android.os.Message ), 0, this, bl, message);
    }

    public boolean setInternalDataEnabledFlag(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setInternalDataEnabledFlag", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$setInternalDataEnabledFlag(boolean ), 0, this, bl);
    }

    public String getOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getOperatorNumeric", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$getOperatorNumeric(), 0, this);
    }

    public void registerForAllDataDisconnected(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForAllDataDisconnected", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$registerForAllDataDisconnected(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForAllDataDisconnected(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForAllDataDisconnected", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$unregisterForAllDataDisconnected(android.os.Handler ), 0, this, handler);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$log(java.lang.String ), 0, this, string2);
    }

    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$loge(java.lang.String ), 0, this, string2);
    }

    protected void loge(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$loge(java.lang.String java.lang.Throwable ), 0, this, string2, throwable);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_cdma_CDMALTEPhone$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ CDMALTEPhone() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CDMALTEPhone)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$DctConstants$State;

        static void __staticInitializer__() {
            $SwitchMap$com$android$internal$telephony$DctConstants$State = new int[DctConstants.State.values().length];
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.RETRYING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.IDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.CONNECTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.DISCONNECTING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.CONNECTING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.SCANNING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

