/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.ActivityManagerNative;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import com.android.ims.ImsManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaMmiCode;
import com.android.internal.telephony.cdma.CdmaServiceStateTracker;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.cdma.EriManager;
import com.android.internal.telephony.cdma.RuimPhoneBookInterfaceManager;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CDMAPhone
extends PhoneBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "CDMAPhone";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static int DEFAULT_ECM_EXIT_TIMER_VALUE = 300000;
    static String VM_COUNT_CDMA = "vm_count_key_cdma";
    private static String VM_NUMBER_CDMA = "vm_number_key_cdma";
    private String mVmNumber;
    static int RESTART_ECM_TIMER = 0;
    static int CANCEL_ECM_TIMER = 1;
    CdmaCallTracker mCT;
    CdmaServiceStateTracker mSST;
    CdmaSubscriptionSourceManager mCdmaSSM;
    ArrayList<CdmaMmiCode> mPendingMmis;
    RuimPhoneBookInterfaceManager mRuimPhoneBookInterfaceManager;
    int mCdmaSubscriptionSource;
    PhoneSubInfo mSubInfo;
    EriManager mEriManager;
    PowerManager.WakeLock mWakeLock;
    private RegistrantList mEriFileLoadedRegistrants;
    private RegistrantList mEcmTimerResetRegistrants;
    protected boolean mIsPhoneInEcmState;
    private Registrant mEcmExitRespRegistrant;
    protected String mImei;
    protected String mImeiSv;
    private String mEsn;
    private String mMeid;
    protected String mCarrierOtaSpNumSchema;
    private Runnable mExitEcmRunnable;
    Registrant mPostDialHandler;
    static String PROPERTY_CDMA_HOME_OPERATOR_NUMERIC;
    private static String IS683A_FEATURE_CODE = "*228";
    private static int IS683A_FEATURE_CODE_NUM_DIGITS = 4;
    private static int IS683A_SYS_SEL_CODE_NUM_DIGITS = 2;
    private static int IS683A_SYS_SEL_CODE_OFFSET = 4;
    private static int IS683_CONST_800MHZ_A_BAND = 0;
    private static int IS683_CONST_800MHZ_B_BAND = 1;
    private static int IS683_CONST_1900MHZ_A_BLOCK = 2;
    private static int IS683_CONST_1900MHZ_B_BLOCK = 3;
    private static int IS683_CONST_1900MHZ_C_BLOCK = 4;
    private static int IS683_CONST_1900MHZ_D_BLOCK = 5;
    private static int IS683_CONST_1900MHZ_E_BLOCK = 6;
    private static int IS683_CONST_1900MHZ_F_BLOCK = 7;
    private static int INVALID_SYSTEM_SELECTION_CODE = -1;
    private static Pattern pOtaSpNumSchema;

    private void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier) {
        this.mVmNumber = null;
        this.mPendingMmis = new ArrayList();
        this.mCdmaSubscriptionSource = -1;
        this.mEriFileLoadedRegistrants = new RegistrantList();
        this.mEcmTimerResetRegistrants = new RegistrantList();
        this.mExitEcmRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CDMAPhone this$0;

            private void $$robo$$com_android_internal_telephony_cdma_CDMAPhone_1$__constructor__(CDMAPhone cDMAPhone) {
            }

            private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone_1$run() {
                this.this$0.exitEmergencyCallbackMode();
            }

            private void __constructor__(CDMAPhone cDMAPhone) {
                this.$$robo$$com_android_internal_telephony_cdma_CDMAPhone_1$__constructor__(cDMAPhone);
            }
            {
                this.this$0 = cDMAPhone;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CDMAPhone_1$__constructor__(com.android.internal.telephony.cdma.CDMAPhone ), 0, this, cDMAPhone);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_cdma_CDMAPhone_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.initSstIcc();
        this.init(context, notifier);
    }

    private void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier, int phoneId) {
        this.mVmNumber = null;
        this.mPendingMmis = new ArrayList();
        this.mCdmaSubscriptionSource = -1;
        this.mEriFileLoadedRegistrants = new RegistrantList();
        this.mEcmTimerResetRegistrants = new RegistrantList();
        this.mExitEcmRunnable = new /* invalid duplicate definition of identical inner class */;
        this.initSstIcc();
        this.init(context, notifier);
    }

    private void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier, boolean unitTestMode) {
        this.mVmNumber = null;
        this.mPendingMmis = new ArrayList();
        this.mCdmaSubscriptionSource = -1;
        this.mEriFileLoadedRegistrants = new RegistrantList();
        this.mEcmTimerResetRegistrants = new RegistrantList();
        this.mExitEcmRunnable = new /* invalid duplicate definition of identical inner class */;
        this.initSstIcc();
        this.init(context, notifier);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$initSstIcc() {
        this.mSST = new CdmaServiceStateTracker(this);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$init(Context context, PhoneNotifier notifier) {
        this.mCi.setPhoneType(2);
        this.mCT = new CdmaCallTracker(this);
        this.mCdmaSSM = CdmaSubscriptionSourceManager.getInstance(context, this.mCi, this, 27, null);
        this.mDcTracker = new DcTracker(this);
        this.mRuimPhoneBookInterfaceManager = new RuimPhoneBookInterfaceManager(this);
        this.mSubInfo = new PhoneSubInfo(this);
        this.mEriManager = new EriManager(this, context, 0);
        this.mCi.registerForAvailable(this, 1, null);
        this.mCi.registerForOffOrNotAvailable(this, 8, null);
        this.mCi.registerForOn(this, 5, null);
        this.mCi.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttached(this, 19, null);
        this.mCi.setEmergencyCallbackMode(this, 25, null);
        this.mCi.registerForExitEmergencyCallbackMode(this, 26, null);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "CDMAPhone");
        SystemProperties.set("gsm.current.phone-type", Integer.toString(2));
        String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
        this.mIsPhoneInEcmState = inEcm.equals("true");
        if (this.mIsPhoneInEcmState) {
            this.mCi.exitEmergencyCallbackMode(this.obtainMessage(26));
        }
        this.mCarrierOtaSpNumSchema = SystemProperties.get("ro.cdma.otaspnumschema", "");
        String operatorAlpha = SystemProperties.get("ro.cdma.home.operator.alpha");
        String operatorNumeric = SystemProperties.get(PROPERTY_CDMA_HOME_OPERATOR_NUMERIC);
        this.log("init: operatorAlpha='" + operatorAlpha + "' operatorNumeric='" + operatorNumeric + "'");
        if (this.mUiccController.getUiccCardApplication(this.mPhoneId, 1) == null) {
            this.log("init: APP_FAM_3GPP == NULL");
            if (!TextUtils.isEmpty(operatorAlpha)) {
                this.log("init: set 'gsm.sim.operator.alpha' to operator='" + operatorAlpha + "'");
                this.setSystemProperty("gsm.sim.operator.alpha", operatorAlpha);
            }
            if (!TextUtils.isEmpty(operatorNumeric)) {
                this.log("init: set 'gsm.sim.operator.numeric' to operator='" + operatorNumeric + "'");
                this.log("update icc_operator_numeric=" + operatorNumeric);
                this.setSystemProperty("gsm.sim.operator.numeric", operatorNumeric);
                SubscriptionController.getInstance().setMccMnc(operatorNumeric, this.getSubId());
            }
            this.setIsoCountryProperty(operatorNumeric);
        }
        this.updateCurrentCarrierInProvider(operatorNumeric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            super.dispose();
            this.log("dispose");
            this.unregisterForRuimRecordEvents();
            this.mCi.unregisterForAvailable(this);
            this.mCi.unregisterForOffOrNotAvailable(this);
            this.mCi.unregisterForOn(this);
            this.mSST.unregisterForNetworkAttached(this);
            this.mCi.unSetOnSuppServiceNotification(this);
            this.mCi.unregisterForExitEmergencyCallbackMode(this);
            this.removeCallbacks(this.mExitEcmRunnable);
            this.mPendingMmis.clear();
            this.mCT.dispose();
            this.mDcTracker.dispose();
            this.mSST.dispose();
            this.mCdmaSSM.dispose(this);
            this.mRuimPhoneBookInterfaceManager.dispose();
            this.mSubInfo.dispose();
            this.mEriManager.dispose();
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$removeReferences() {
        this.log("removeReferences");
        this.mRuimPhoneBookInterfaceManager = null;
        this.mSubInfo = null;
        this.mCT = null;
        this.mSST = null;
        this.mEriManager = null;
        this.mExitEcmRunnable = null;
        super.removeReferences();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$finalize() {
        Rlog.d("CDMAPhone", "CDMAPhone finalized");
        if (this.mWakeLock.isHeld()) {
            Rlog.e("CDMAPhone", "UNEXPECTED; mWakeLock is held when finalizing.");
            this.mWakeLock.release();
        }
    }

    private final ServiceState $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getServiceState() {
        if ((this.mSST == null || this.mSST.mSS.getState() != 0) && this.mImsPhone != null && this.mImsPhone.getServiceState().getState() == 0) {
            return this.mImsPhone.getServiceState();
        }
        if (this.mSST != null) {
            return this.mSST.mSS;
        }
        return new ServiceState();
    }

    private final CallTracker $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCallTracker() {
        return this.mCT;
    }

    private final PhoneConstants.State $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getState() {
        return this.mCT.mState;
    }

    private final ServiceStateTracker $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getServiceStateTracker() {
        return this.mSST;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getPhoneType() {
        return 2;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$canTransfer() {
        Rlog.e("CDMAPhone", "canTransfer: not possible in CDMA");
        return false;
    }

    private final Call $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getRingingCall() {
        ImsPhone imPhone = this.mImsPhone;
        if (this.mCT.mRingingCall != null && this.mCT.mRingingCall.isRinging()) {
            return this.mCT.mRingingCall;
        }
        if (imPhone != null) {
            return imPhone.getRingingCall();
        }
        return this.mCT.mRingingCall;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getMute() {
        return this.mCT.getMute();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$conference() {
        if (this.mImsPhone != null && this.mImsPhone.canConference()) {
            this.log("conference() - delegated to IMS phone");
            this.mImsPhone.conference();
            return;
        }
        Rlog.e("CDMAPhone", "conference: not possible in CDMA");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
        this.mCi.setPreferredVoicePrivacy(enable, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getEnhancedVoicePrivacy(Message onComplete) {
        this.mCi.getPreferredVoicePrivacy(onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    private final Phone.DataActivityState $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDataActivityState() {
        Phone.DataActivityState ret = Phone.DataActivityState.NONE;
        if (this.mSST.getCurrentDataConnectionState() == 0) {
            switch (2.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[this.mDcTracker.getActivity().ordinal()]) {
                case 1: {
                    ret = Phone.DataActivityState.DATAIN;
                    break;
                }
                case 2: {
                    ret = Phone.DataActivityState.DATAOUT;
                    break;
                }
                case 3: {
                    ret = Phone.DataActivityState.DATAINANDOUT;
                    break;
                }
                case 4: {
                    ret = Phone.DataActivityState.DORMANT;
                    break;
                }
                default: {
                    ret = Phone.DataActivityState.NONE;
                }
            }
        }
        return ret;
    }

    private final Connection $$robo$$com_android_internal_telephony_cdma_CDMAPhone$dial(String dialString, int videoState) throws CallStateException {
        block4: {
            boolean imsUseEnabled;
            ImsPhone imsPhone = this.mImsPhone;
            boolean bl = imsUseEnabled = ImsManager.isEnhanced4gLteModeSettingEnabledByPlatform((Context)this.mContext) && ImsManager.isEnhanced4gLteModeSettingEnabledByUser((Context)this.mContext);
            if (!imsUseEnabled) {
                Rlog.w("CDMAPhone", "IMS is disabled: forced to CS");
            }
            if (imsUseEnabled && imsPhone != null && (imsPhone.getServiceState().getState() == 0 && !PhoneNumberUtils.isEmergencyNumber(dialString) || PhoneNumberUtils.isEmergencyNumber(dialString) && this.mContext.getResources().getBoolean(17956977))) {
                try {
                    Rlog.d("CDMAPhone", "Trying IMS PS call");
                    return imsPhone.dial(dialString, videoState);
                }
                catch (CallStateException e) {
                    Rlog.d("CDMAPhone", "IMS PS call exception " + e);
                    if ("cs_fallback".equals(e.getMessage())) break block4;
                    CallStateException ce = new CallStateException(e.getMessage());
                    ce.setStackTrace(e.getStackTrace());
                    throw ce;
                }
            }
        }
        Rlog.d("CDMAPhone", "Trying (non-IMS) CS call");
        return this.dialInternal(dialString, null, videoState);
    }

    private final Connection $$robo$$com_android_internal_telephony_cdma_CDMAPhone$dialInternal(String dialString, UUSInfo uusInfo, int videoState) throws CallStateException {
        String newDialString = PhoneNumberUtils.stripSeparators(dialString);
        return this.mCT.dial(newDialString);
    }

    private final Connection $$robo$$com_android_internal_telephony_cdma_CDMAPhone$dial(String dialString, UUSInfo uusInfo, int videoState) throws CallStateException {
        throw new CallStateException("Sending UUS information NOT supported in CDMA!");
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getMessageWaitingIndicator() {
        return this.getVoiceMessageCount() > 0;
    }

    private final List<? extends MmiCode> $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getPendingMmiCodes() {
        return this.mPendingMmis;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForSuppServiceNotification(Handler h, int what, Object obj) {
        Rlog.e("CDMAPhone", "method registerForSuppServiceNotification is NOT supported in CDMA!");
    }

    private final CdmaCall $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getBackgroundCall() {
        return this.mCT.mBackgroundCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleInCallMmiCommands(String dialString) {
        Rlog.e("CDMAPhone", "method handleInCallMmiCommands is NOT supported in CDMA!");
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForSuppServiceNotification(Handler h) {
        Rlog.e("CDMAPhone", "method unregisterForSuppServiceNotification is NOT supported in CDMA!");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$acceptCall(int videoState) throws CallStateException {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getRingingCall().isRinging()) {
            imsPhone.acceptCall(videoState);
        } else {
            this.mCT.acceptCall();
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getIccSerialNumber() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            r = this.mUiccController.getIccRecords(this.mPhoneId, 1);
        }
        return r != null ? r.getIccId() : null;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getLine1Number() {
        return this.mSST.getMdnNumber();
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCdmaPrlVersion() {
        return this.mSST.getPrlVersion();
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCdmaMin() {
        return this.mSST.getCdmaMin();
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isMinInfoReady() {
        return this.mSST.isMinInfoReady();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCallWaiting(Message onComplete) {
        this.mCi.queryCallWaiting(1, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setRadioPower(boolean power) {
        this.mSST.setRadioPower(power);
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getEsn() {
        return this.mEsn;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getMeid() {
        return this.mMeid;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDeviceId() {
        String id2 = this.getMeid();
        if (id2 == null || id2.matches("^0*$")) {
            Rlog.d("CDMAPhone", "getDeviceId(): MEID is not initialized use ESN");
            id2 = this.getEsn();
        }
        return id2;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDeviceSvn() {
        Rlog.d("CDMAPhone", "getDeviceSvn(): return 0");
        return "0";
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getSubscriberId() {
        return this.mSST.getImsi();
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getGroupIdLevel1() {
        Rlog.e("CDMAPhone", "GID1 is not available in CDMA");
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getImei() {
        Rlog.e("CDMAPhone", "getImei() called for CDMAPhone");
        return this.mImei;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$canConference() {
        if (this.mImsPhone != null && this.mImsPhone.canConference()) {
            return true;
        }
        Rlog.e("CDMAPhone", "canConference: not possible in CDMA");
        return false;
    }

    private final CellLocation $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCellLocation() {
        CdmaCellLocation loc = this.mSST.mCellLoc;
        int mode = Settings.Secure.getInt(this.getContext().getContentResolver(), "location_mode", 0);
        if (mode == 0) {
            CdmaCellLocation privateLoc = new CdmaCellLocation();
            privateLoc.setCellLocationData(loc.getBaseStationId(), Integer.MAX_VALUE, Integer.MAX_VALUE, loc.getSystemId(), loc.getNetworkId());
            loc = privateLoc;
        }
        return loc;
    }

    private final CdmaCall $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getForegroundCall() {
        return this.mCT.mForegroundCall;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setOnPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialHandler = new Registrant(h, what, obj);
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handlePinMmi(String dialString) {
        CdmaMmiCode mmi = CdmaMmiCode.newFromDialString(dialString, this, (UiccCardApplication)this.mUiccApplication.get());
        if (mmi == null) {
            Rlog.e("CDMAPhone", "Mmi is NULL!");
            return false;
        }
        if (mmi.isPinPukCommand()) {
            this.mPendingMmis.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            mmi.processCode();
            return true;
        }
        Rlog.e("CDMAPhone", "Unrecognized mmi!");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$onMMIDone(CdmaMmiCode mmi) {
        if (this.mPendingMmis.remove(mmi)) {
            this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setLine1Number(String alphaTag, String number, Message onComplete) {
        Rlog.e("CDMAPhone", "setLine1Number: not possible in CDMA");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setCallWaiting(boolean enable, Message onComplete) {
        Rlog.e("CDMAPhone", "method setCallWaiting is NOT supported in CDMA!");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$updateServiceLocation() {
        this.mSST.enableSingleLocationUpdate();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setDataRoamingEnabled(boolean enable) {
        this.mDcTracker.setDataOnRoamingEnabled(enable);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        this.mCi.registerForCdmaOtaProvision(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForCdmaOtaStatusChange(Handler h) {
        this.mCi.unregisterForCdmaOtaProvision(h);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        this.mSST.registerForSubscriptionInfoReady(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForSubscriptionInfoReady(Handler h) {
        this.mSST.unregisterForSubscriptionInfoReady(h);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        this.mEcmExitRespRegistrant = new Registrant(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unsetOnEcbModeExitResponse(Handler h) {
        this.mEcmExitRespRegistrant.clear();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForCallWaiting(Handler h, int what, Object obj) {
        this.mCT.registerForCallWaiting(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForCallWaiting(Handler h) {
        this.mCT.unregisterForCallWaiting(h);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getNeighboringCids(Message response) {
        if (response != null) {
            CommandException ce = new CommandException(CommandException.Error.REQUEST_NOT_SUPPORTED);
            AsyncResult.forMessage((Message)response).exception = ce;
            response.sendToTarget();
        }
    }

    private final PhoneConstants.DataState $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDataConnectionState(String apnType) {
        PhoneConstants.DataState ret = PhoneConstants.DataState.DISCONNECTED;
        if (this.mSST == null) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (this.mSST.getCurrentDataConnectionState() != 0) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (!this.mDcTracker.isApnTypeEnabled(apnType) || !this.mDcTracker.isApnTypeActive(apnType)) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else {
            switch (2.$SwitchMap$com$android$internal$telephony$DctConstants$State[this.mDcTracker.getState(apnType).ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    ret = PhoneConstants.DataState.DISCONNECTED;
                    break;
                }
                case 4: 
                case 5: {
                    if (this.mCT.mState != PhoneConstants.State.IDLE && !this.mSST.isConcurrentVoiceAndDataAllowed()) {
                        ret = PhoneConstants.DataState.SUSPENDED;
                        break;
                    }
                    ret = PhoneConstants.DataState.CONNECTED;
                    break;
                }
                case 6: 
                case 7: {
                    ret = PhoneConstants.DataState.CONNECTING;
                }
            }
        }
        this.log("getDataConnectionState apnType=" + apnType + " ret=" + (Object)((Object)ret));
        return ret;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$sendUssdResponse(String ussdMessge) {
        Rlog.e("CDMAPhone", "sendUssdResponse: not possible in CDMA");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e("CDMAPhone", "sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.mState == PhoneConstants.State.OFFHOOK) {
            this.mCi.sendDtmf(c, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e("CDMAPhone", "startDtmf called with invalid character '" + c + "'");
        } else {
            this.mCi.startDtmf(c, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$stopDtmf() {
        this.mCi.stopDtmf(null);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        boolean check = true;
        for (int itr = 0; itr < dtmfString.length(); ++itr) {
            if (PhoneNumberUtils.is12Key(dtmfString.charAt(itr))) continue;
            Rlog.e("CDMAPhone", "sendDtmf called with invalid character '" + dtmfString.charAt(itr) + "'");
            check = false;
            break;
        }
        if (this.mCT.mState == PhoneConstants.State.OFFHOOK && check) {
            this.mCi.sendBurstDtmf(dtmfString, on, off, onComplete);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getAvailableNetworks(Message response) {
        Rlog.e("CDMAPhone", "getAvailableNetworks: not possible in CDMA");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        Rlog.e("CDMAPhone", "setOutgoingCallerIdDisplay: not possible in CDMA");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$enableLocationUpdates() {
        this.mSST.enableLocationUpdates();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$disableLocationUpdates() {
        this.mSST.disableLocationUpdates();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDataCallList(Message response) {
        this.mCi.getDataCallList(response);
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDataRoamingEnabled() {
        return this.mDcTracker.getDataOnRoamingEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setDataEnabled(boolean enable) {
        this.mDcTracker.setDataEnabled(enable);
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDataEnabled() {
        return this.mDcTracker.getDataEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setVoiceMailNumber(String alphaTag, String voiceMailNumber, Message onComplete) {
        this.mVmNumber = voiceMailNumber;
        Message resp = this.obtainMessage(20, 0, 0, onComplete);
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            r.setVoiceMailNumber(alphaTag, this.mVmNumber, resp);
        }
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getVoiceMailNumber() {
        String[] listArray;
        String number = null;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        number = sp.getString("vm_number_key_cdma" + this.getPhoneId(), null);
        if (TextUtils.isEmpty(number) && (listArray = this.getContext().getResources().getStringArray(17236026)) != null && listArray.length > 0) {
            for (int i = 0; i < listArray.length; ++i) {
                String[] defaultVMNumberArray;
                if (TextUtils.isEmpty(listArray[i]) || (defaultVMNumberArray = listArray[i].split(";")) == null || defaultVMNumberArray.length <= 0) continue;
                if (defaultVMNumberArray.length == 1) {
                    number = defaultVMNumberArray[0];
                    continue;
                }
                if (defaultVMNumberArray.length != 2 || TextUtils.isEmpty(defaultVMNumberArray[1]) || !defaultVMNumberArray[1].equalsIgnoreCase(this.getGroupIdLevel1())) continue;
                number = defaultVMNumberArray[0];
                break;
            }
        }
        if (TextUtils.isEmpty(number)) {
            number = this.getContext().getResources().getBoolean(17956938) ? this.getLine1Number() : "*86";
        }
        return number;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getVoiceMessageCount() {
        int voicemailCount;
        IccRecords r = (IccRecords)this.mIccRecords.get();
        int n = voicemailCount = r != null ? r.getVoiceMessageCount() : 0;
        if (voicemailCount == 0) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
            voicemailCount = sp.getInt("vm_count_key_cdma" + this.getPhoneId(), 0);
        }
        return voicemailCount;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getVoiceMailAlphaTag() {
        String ret = "";
        if (ret == null || ret.length() == 0) {
            return this.mContext.getText(0x1040004).toString();
        }
        return ret;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        Rlog.e("CDMAPhone", "getCallForwardingOption: not possible in CDMA");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        Rlog.e("CDMAPhone", "setCallForwardingOption: not possible in CDMA");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getOutgoingCallerIdDisplay(Message onComplete) {
        Rlog.e("CDMAPhone", "getOutgoingCallerIdDisplay: not possible in CDMA");
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCallForwardingIndicator() {
        Rlog.e("CDMAPhone", "getCallForwardingIndicator: not possible in CDMA");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$explicitCallTransfer() {
        Rlog.e("CDMAPhone", "explicitCallTransfer: not possible in CDMA");
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getLine1AlphaTag() {
        Rlog.e("CDMAPhone", "getLine1AlphaTag: not possible in CDMA");
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyServiceStateChanged(ServiceState ss) {
        super.notifyServiceStateChangedP(ss);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyLocationChanged() {
        this.mNotifier.notifyCellLocation(this);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyNewRingingConnection(Connection c) {
        super.notifyNewRingingConnectionP(c);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyDisconnect(Connection cn) {
        this.mDisconnectRegistrants.notifyResult(cn);
        this.mNotifier.notifyDisconnectCause(cn.getDisconnectCause(), cn.getPreciseDisconnectCause());
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyUnknownConnection(Connection connection) {
        this.mUnknownConnectionRegistrants.notifyResult(connection);
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isInEmergencyCall() {
        return this.mCT.isInEmergencyCall();
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isInEcm() {
        return this.mIsPhoneInEcmState;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$sendEmergencyCallbackModeChange() {
        Intent intent = new Intent("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        intent.putExtra("phoneinECMState", this.mIsPhoneInEcmState);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.getPhoneId());
        ActivityManagerNative.broadcastStickyIntent(intent, null, -1);
        Rlog.d("CDMAPhone", "sendEmergencyCallbackModeChange");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$exitEmergencyCallbackMode() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        this.mCi.exitEmergencyCallbackMode(this.obtainMessage(26));
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleEnterEmergencyCallbackMode(Message msg) {
        Rlog.d("CDMAPhone", "handleEnterEmergencyCallbackMode,mIsPhoneInEcmState= " + this.mIsPhoneInEcmState);
        if (!this.mIsPhoneInEcmState) {
            this.mIsPhoneInEcmState = true;
            this.sendEmergencyCallbackModeChange();
            this.setSystemProperty("ril.cdma.inecmmode", "true");
            long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
            this.postDelayed(this.mExitEcmRunnable, delayInMillis);
            this.mWakeLock.acquire();
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleExitEmergencyCallbackMode(Message msg) {
        AsyncResult ar = (AsyncResult)msg.obj;
        Rlog.d("CDMAPhone", "handleExitEmergencyCallbackMode,ar.exception , mIsPhoneInEcmState " + ar.exception + this.mIsPhoneInEcmState);
        this.removeCallbacks(this.mExitEcmRunnable);
        if (this.mEcmExitRespRegistrant != null) {
            this.mEcmExitRespRegistrant.notifyRegistrant(ar);
        }
        if (ar.exception == null) {
            if (this.mIsPhoneInEcmState) {
                this.mIsPhoneInEcmState = false;
                this.setSystemProperty("ril.cdma.inecmmode", "false");
            }
            this.sendEmergencyCallbackModeChange();
            this.mDcTracker.setInternalDataEnabled(true);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleTimerInEmergencyCallbackMode(int action) {
        switch (action) {
            case 1: {
                this.removeCallbacks(this.mExitEcmRunnable);
                this.mEcmTimerResetRegistrants.notifyResult(Boolean.TRUE);
                break;
            }
            case 0: {
                long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
                this.postDelayed(this.mExitEcmRunnable, delayInMillis);
                this.mEcmTimerResetRegistrants.notifyResult(Boolean.FALSE);
                break;
            }
            default: {
                Rlog.e("CDMAPhone", "handleTimerInEmergencyCallbackMode, unsupported action " + action);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyEcbmTimerReset(Boolean flag) {
        this.mEcmTimerResetRegistrants.notifyResult(flag);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForEcmTimerReset(Handler h, int what, Object obj) {
        this.mEcmTimerResetRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForEcmTimerReset(Handler h) {
        this.mEcmTimerResetRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleMessage(Message msg) {
        if (!this.mIsTheCurrentActivePhone) {
            Rlog.e("CDMAPhone", "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        switch (msg.what) {
            case 1: {
                this.mCi.getBasebandVersion(this.obtainMessage(6));
                this.mCi.getDeviceIdentity(this.obtainMessage(21));
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                Rlog.d("CDMAPhone", "Baseband version: " + ar.result);
                this.setSystemProperty("gsm.version.baseband", (String)ar.result);
                break;
            }
            case 21: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                String[] respId = (String[])ar.result;
                this.mImei = respId[0];
                this.mImeiSv = respId[1];
                this.mEsn = respId[2];
                this.mMeid = respId[3];
                break;
            }
            case 25: {
                this.handleEnterEmergencyCallbackMode(msg);
                break;
            }
            case 29: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.processIccRecordEvents((Integer)ar.result);
                break;
            }
            case 26: {
                this.handleExitEmergencyCallbackMode(msg);
                break;
            }
            case 22: {
                Rlog.d("CDMAPhone", "Event EVENT_RUIM_RECORDS_LOADED Received");
                this.updateCurrentCarrierInProvider();
                this.log("notifyMessageWaitingChanged");
                this.mNotifier.notifyMessageWaitingChanged(this);
                break;
            }
            case 8: {
                Rlog.d("CDMAPhone", "Event EVENT_RADIO_OFF_OR_NOT_AVAILABLE Received");
                ImsPhone imsPhone = this.mImsPhone;
                if (imsPhone == null) break;
                imsPhone.getServiceState().setStateOff();
                break;
            }
            case 5: {
                Rlog.d("CDMAPhone", "Event EVENT_RADIO_ON Received");
                this.handleCdmaSubscriptionSource(this.mCdmaSSM.getCdmaSubscriptionSource());
                break;
            }
            case 27: {
                Rlog.d("CDMAPhone", "EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED");
                this.handleCdmaSubscriptionSource(this.mCdmaSSM.getCdmaSubscriptionSource());
                break;
            }
            case 2: {
                Rlog.d("CDMAPhone", "Event EVENT_SSN Received");
                break;
            }
            case 19: {
                Rlog.d("CDMAPhone", "Event EVENT_REGISTERED_TO_NETWORK Received");
                break;
            }
            case 23: {
                Rlog.d("CDMAPhone", "Event EVENT_NV_READY Received");
                this.prepareEri();
                this.log("notifyMessageWaitingChanged");
                this.mNotifier.notifyMessageWaitingChanged(this);
                break;
            }
            case 20: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (IccException.class.isInstance(ar.exception)) {
                    this.storeVoiceMailNumber(this.mVmNumber);
                    ar.exception = null;
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final UiccCardApplication $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getUiccCardApplication() {
        return this.mUiccController.getUiccCardApplication(this.mPhoneId, 2);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$onUpdateIccAvailability() {
        UiccCardApplication app;
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.getUiccCardApplication();
        if (newUiccApplication == null) {
            this.log("can't find 3GPP2 application; trying APP_FAM_3GPP");
            newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
        }
        if ((app = (UiccCardApplication)this.mUiccApplication.get()) != newUiccApplication) {
            if (app != null) {
                this.log("Removing stale icc objects.");
                if (this.mIccRecords.get() != null) {
                    this.unregisterForRuimRecordEvents();
                }
                this.mIccRecords.set(null);
                this.mUiccApplication.set(null);
            }
            if (newUiccApplication != null) {
                this.log("New Uicc application found");
                this.mUiccApplication.set(newUiccApplication);
                this.mIccRecords.set(newUiccApplication.getIccRecords());
                this.registerForRuimRecordEvents();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$processIccRecordEvents(int eventCode) {
        switch (eventCode) {
            case 0: {
                this.notifyMessageWaitingIndicator();
                break;
            }
            default: {
                Rlog.e("CDMAPhone", "Unknown icc records event code " + eventCode);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleCdmaSubscriptionSource(int newSubscriptionSource) {
        if (newSubscriptionSource != this.mCdmaSubscriptionSource) {
            this.mCdmaSubscriptionSource = newSubscriptionSource;
            if (newSubscriptionSource == 1) {
                this.sendMessage(this.obtainMessage(23));
            }
        }
    }

    private final PhoneSubInfo $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getPhoneSubInfo() {
        return this.mSubInfo;
    }

    private final IccPhoneBookInterfaceManager $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getIccPhoneBookInterfaceManager() {
        return this.mRuimPhoneBookInterfaceManager;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForEriFileLoaded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mEriFileLoadedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForEriFileLoaded(Handler h) {
        this.mEriFileLoadedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setSystemProperty(String property, String value) {
        super.setSystemProperty(property, value);
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getSystemProperty(String property, String defValue) {
        return super.getSystemProperty(property, defValue);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$activateCellBroadcastSms(int activate, Message response) {
        Rlog.e("CDMAPhone", "[CDMAPhone] activateCellBroadcastSms() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCellBroadcastSmsConfig(Message response) {
        Rlog.e("CDMAPhone", "[CDMAPhone] getCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setCellBroadcastSmsConfig(int[] configValuesArray, Message response) {
        Rlog.e("CDMAPhone", "[CDMAPhone] setCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$needsOtaServiceProvisioning() {
        return this.mSST.getOtasp() != 3;
    }

    private static final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isIs683OtaSpDialStr(String dialStr) {
        boolean isOtaspDialString = false;
        int dialStrLen = dialStr.length();
        if (dialStrLen == 4) {
            if (dialStr.equals("*228")) {
                isOtaspDialString = true;
            }
        } else {
            int sysSelCodeInt = CDMAPhone.extractSelCodeFromOtaSpNum(dialStr);
            switch (sysSelCodeInt) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    isOtaspDialString = true;
                    break;
                }
            }
        }
        return isOtaspDialString;
    }

    private static final int $$robo$$com_android_internal_telephony_cdma_CDMAPhone$extractSelCodeFromOtaSpNum(String dialStr) {
        int dialStrLen = dialStr.length();
        int sysSelCodeInt = -1;
        if (dialStr.regionMatches(0, "*228", 0, 4) && dialStrLen >= 6) {
            sysSelCodeInt = Integer.parseInt(dialStr.substring(4, 6));
        }
        Rlog.d("CDMAPhone", "extractSelCodeFromOtaSpNum " + sysSelCodeInt);
        return sysSelCodeInt;
    }

    private static final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$checkOtaSpNumBasedOnSysSelCode(int sysSelCodeInt, String[] sch) {
        boolean isOtaSpNum = false;
        try {
            int selRc = Integer.parseInt(sch[1]);
            for (int i = 0; i < selRc; ++i) {
                if (TextUtils.isEmpty(sch[i + 2]) || TextUtils.isEmpty(sch[i + 3])) continue;
                int selMin = Integer.parseInt(sch[i + 2]);
                int selMax = Integer.parseInt(sch[i + 3]);
                if (sysSelCodeInt < selMin || sysSelCodeInt > selMax) continue;
                isOtaSpNum = true;
                break;
            }
        }
        catch (NumberFormatException ex) {
            Rlog.e("CDMAPhone", "checkOtaSpNumBasedOnSysSelCode, error", ex);
        }
        return isOtaSpNum;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isCarrierOtaSpNum(String dialStr) {
        boolean isOtaSpNum = false;
        int sysSelCodeInt = CDMAPhone.extractSelCodeFromOtaSpNum(dialStr);
        if (sysSelCodeInt == -1) {
            return isOtaSpNum;
        }
        if (!TextUtils.isEmpty(this.mCarrierOtaSpNumSchema)) {
            Matcher m = pOtaSpNumSchema.matcher(this.mCarrierOtaSpNumSchema);
            Rlog.d("CDMAPhone", "isCarrierOtaSpNum,schema" + this.mCarrierOtaSpNumSchema);
            if (m.find()) {
                String[] sch = pOtaSpNumSchema.split(this.mCarrierOtaSpNumSchema);
                if (!TextUtils.isEmpty(sch[0]) && sch[0].equals("SELC")) {
                    if (sysSelCodeInt != -1) {
                        isOtaSpNum = CDMAPhone.checkOtaSpNumBasedOnSysSelCode(sysSelCodeInt, sch);
                    } else {
                        Rlog.d("CDMAPhone", "isCarrierOtaSpNum,sysSelCodeInt is invalid");
                    }
                } else if (!TextUtils.isEmpty(sch[0]) && sch[0].equals("FC")) {
                    String fc = sch[2];
                    int fcLen = Integer.parseInt(sch[1]);
                    if (dialStr.regionMatches(0, fc, 0, fcLen)) {
                        isOtaSpNum = true;
                    } else {
                        Rlog.d("CDMAPhone", "isCarrierOtaSpNum,not otasp number");
                    }
                } else {
                    Rlog.d("CDMAPhone", "isCarrierOtaSpNum,ota schema not supported" + sch[0]);
                }
            } else {
                Rlog.d("CDMAPhone", "isCarrierOtaSpNum,ota schema pattern not right" + this.mCarrierOtaSpNumSchema);
            }
        } else {
            Rlog.d("CDMAPhone", "isCarrierOtaSpNum,ota schema pattern empty");
        }
        return isOtaSpNum;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isOtaSpNumber(String dialStr) {
        boolean isOtaSpNum = false;
        String dialableStr = PhoneNumberUtils.extractNetworkPortionAlt(dialStr);
        if (dialableStr != null && !(isOtaSpNum = CDMAPhone.isIs683OtaSpDialStr(dialableStr))) {
            isOtaSpNum = this.isCarrierOtaSpNum(dialableStr);
        }
        Rlog.d("CDMAPhone", "isOtaSpNumber " + isOtaSpNum);
        return isOtaSpNum;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCdmaEriIconIndex() {
        return this.getServiceState().getCdmaEriIconIndex();
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCdmaEriIconMode() {
        return this.getServiceState().getCdmaEriIconMode();
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCdmaEriText() {
        int roamInd = this.getServiceState().getCdmaRoamingIndicator();
        int defRoamInd = this.getServiceState().getCdmaDefaultRoamingIndicator();
        return this.mEriManager.getCdmaEriText(roamInd, defRoamInd);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$storeVoiceMailNumber(String number) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("vm_number_key_cdma" + this.getPhoneId(), number);
        editor.apply();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setIsoCountryProperty(String operatorNumeric) {
        if (TextUtils.isEmpty(operatorNumeric)) {
            this.log("setIsoCountryProperty: clear 'gsm.sim.operator.iso-country'");
            this.setSystemProperty("gsm.sim.operator.iso-country", "");
        } else {
            String iso = "";
            try {
                iso = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
            }
            catch (NumberFormatException ex) {
                this.loge("setIsoCountryProperty: countryCodeForMcc error", ex);
            }
            catch (StringIndexOutOfBoundsException ex) {
                this.loge("setIsoCountryProperty: countryCodeForMcc error", ex);
            }
            this.log("setIsoCountryProperty: set 'gsm.sim.operator.iso-country' to iso=" + iso);
            this.setSystemProperty("gsm.sim.operator.iso-country", iso);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$updateCurrentCarrierInProvider(String operatorNumeric) {
        this.log("CDMAPhone: updateCurrentCarrierInProvider called");
        if (!TextUtils.isEmpty(operatorNumeric)) {
            try {
                Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                ContentValues map = new ContentValues();
                map.put("numeric", operatorNumeric);
                this.log("updateCurrentCarrierInProvider from system: numeric=" + operatorNumeric);
                this.getContext().getContentResolver().insert(uri, map);
                this.log("update mccmnc=" + operatorNumeric);
                MccTable.updateMccMncConfiguration(this.mContext, operatorNumeric, false);
                return true;
            }
            catch (SQLException e) {
                Rlog.e("CDMAPhone", "Can't store current operator", e);
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$updateCurrentCarrierInProvider() {
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$prepareEri() {
        if (this.mEriManager == null) {
            Rlog.e("CDMAPhone", "PrepareEri: Trying to access stale objects");
            return;
        }
        this.mEriManager.loadEriFile();
        if (this.mEriManager.isEriFileLoaded()) {
            this.log("ERI read, notify registrants");
            this.mEriFileLoadedRegistrants.notifyRegistrants();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isEriFileLoaded() {
        return this.mEriManager.isEriFileLoaded();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForRuimRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        r.registerForRecordsEvents(this, 29, null);
        r.registerForRecordsLoaded(this, 22, null);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForRuimRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        r.unregisterForRecordsEvents(this);
        r.unregisterForRecordsLoaded(this);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$log(String s) {
        Rlog.d("CDMAPhone", s);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$loge(String s, Exception e) {
        Rlog.e("CDMAPhone", s, e);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CDMAPhone$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CDMAPhone extends:");
        super.dump(fd, pw, args);
        pw.println(" mVmNumber=" + this.mVmNumber);
        pw.println(" mCT=" + this.mCT);
        pw.println(" mSST=" + this.mSST);
        pw.println(" mCdmaSSM=" + this.mCdmaSSM);
        pw.println(" mPendingMmis=" + this.mPendingMmis);
        pw.println(" mRuimPhoneBookInterfaceManager=" + this.mRuimPhoneBookInterfaceManager);
        pw.println(" mCdmaSubscriptionSource=" + this.mCdmaSubscriptionSource);
        pw.println(" mSubInfo=" + this.mSubInfo);
        pw.println(" mEriManager=" + this.mEriManager);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" mIsPhoneInEcmState=" + this.mIsPhoneInEcmState);
        pw.println(" mCarrierOtaSpNumSchema=" + this.mCarrierOtaSpNumSchema);
        pw.println(" getCdmaEriIconIndex()=" + this.getCdmaEriIconIndex());
        pw.println(" getCdmaEriIconMode()=" + this.getCdmaEriIconMode());
        pw.println(" getCdmaEriText()=" + this.getCdmaEriText());
        pw.println(" isMinInfoReady()=" + this.isMinInfoReady());
        pw.println(" isCspPlmnEnabled()=" + this.isCspPlmnEnabled());
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setOperatorBrandOverride(String brand) {
        if (this.mUiccController == null) {
            return false;
        }
        UiccCard card = this.mUiccController.getUiccCard();
        if (card == null) {
            return false;
        }
        boolean status = card.setOperatorBrandOverride(brand);
        if (status) {
            IccRecords iccRecords = (IccRecords)this.mIccRecords.get();
            if (iccRecords != null) {
                SystemProperties.set("gsm.sim.operator.alpha", iccRecords.getServiceProviderName());
            }
            if (this.mSST != null) {
                this.mSST.pollState();
            }
        }
        return status;
    }

    static void __staticInitializer__() {
        PROPERTY_CDMA_HOME_OPERATOR_NUMERIC = "ro.cdma.home.operator.numeric";
        pOtaSpNumSchema = Pattern.compile("[,\\s]+");
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier) {
        this.$$robo$$com_android_internal_telephony_cdma_CDMAPhone$__constructor__(context, commandsInterface, phoneNotifier);
    }

    public CDMAPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier) {
        super("CDMA", phoneNotifier, context, commandsInterface, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier ), 0, this, context, commandsInterface, phoneNotifier);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, int n) {
        this.$$robo$$com_android_internal_telephony_cdma_CDMAPhone$__constructor__(context, commandsInterface, phoneNotifier, n);
    }

    public CDMAPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, int n) {
        super("CDMA", phoneNotifier, context, commandsInterface, false, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier int ), 0, this, context, commandsInterface, phoneNotifier, n);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl) {
        this.$$robo$$com_android_internal_telephony_cdma_CDMAPhone$__constructor__(context, commandsInterface, phoneNotifier, bl);
    }

    public CDMAPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl) {
        super("CDMA", phoneNotifier, context, commandsInterface, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier boolean ), 0, this, context, commandsInterface, phoneNotifier, bl);
    }

    protected void initSstIcc() {
        InvokeDynamicSupport.bootstrap("initSstIcc", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$initSstIcc(), 0, this);
    }

    protected void init(Context context, PhoneNotifier phoneNotifier) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$init(android.content.Context com.android.internal.telephony.PhoneNotifier ), 0, this, context, phoneNotifier);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$dispose(), 0, this);
    }

    @Override
    public void removeReferences() {
        InvokeDynamicSupport.bootstrap("removeReferences", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$removeReferences(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$finalize(), 0, this);
    }

    @Override
    public ServiceState getServiceState() {
        return InvokeDynamicSupport.bootstrap("getServiceState", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getServiceState(), 0, this);
    }

    @Override
    public CallTracker getCallTracker() {
        return InvokeDynamicSupport.bootstrap("getCallTracker", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCallTracker(), 0, this);
    }

    @Override
    public PhoneConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getState(), 0, this);
    }

    @Override
    public ServiceStateTracker getServiceStateTracker() {
        return InvokeDynamicSupport.bootstrap("getServiceStateTracker", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getServiceStateTracker(), 0, this);
    }

    @Override
    public int getPhoneType() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneType", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getPhoneType(), 0, this);
    }

    @Override
    public boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$canTransfer(), 0, this);
    }

    @Override
    public Call getRingingCall() {
        return InvokeDynamicSupport.bootstrap("getRingingCall", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getRingingCall(), 0, this);
    }

    @Override
    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setMute(boolean ), 0, this, bl);
    }

    @Override
    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getMute(), 0, this);
    }

    @Override
    public void conference() {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$conference(), 0, this);
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("enableEnhancedVoicePrivacy", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$enableEnhancedVoicePrivacy(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getEnhancedVoicePrivacy(Message message) {
        InvokeDynamicSupport.bootstrap("getEnhancedVoicePrivacy", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getEnhancedVoicePrivacy(android.os.Message ), 0, this, message);
    }

    @Override
    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$clearDisconnected(), 0, this);
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        return InvokeDynamicSupport.bootstrap("getDataActivityState", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDataActivityState(), 0, this);
    }

    @Override
    public Connection dial(String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$dial(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    protected Connection dialInternal(String string2, UUSInfo uUSInfo, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$dialInternal(java.lang.String com.android.internal.telephony.UUSInfo int ), 0, this, string2, uUSInfo, n);
    }

    @Override
    public Connection dial(String string2, UUSInfo uUSInfo, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$dial(java.lang.String com.android.internal.telephony.UUSInfo int ), 0, this, string2, uUSInfo, n);
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMessageWaitingIndicator", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getMessageWaitingIndicator(), 0, this);
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return InvokeDynamicSupport.bootstrap("getPendingMmiCodes", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getPendingMmiCodes(), 0, this);
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSuppServiceNotification", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForSuppServiceNotification(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public CdmaCall getBackgroundCall() {
        return InvokeDynamicSupport.bootstrap("getBackgroundCall", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getBackgroundCall(), 0, this);
    }

    @Override
    public boolean handleInCallMmiCommands(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleInCallMmiCommands", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleInCallMmiCommands(java.lang.String ), 0, this, string2);
    }

    boolean isInCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInCall", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isInCall(), 0, this);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSuppServiceNotification", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForSuppServiceNotification(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void acceptCall(int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$acceptCall(int ), 0, this, n);
    }

    @Override
    public void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$rejectCall(), 0, this);
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchHoldingAndActive", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$switchHoldingAndActive(), 0, this);
    }

    @Override
    public String getIccSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getIccSerialNumber", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getIccSerialNumber(), 0, this);
    }

    @Override
    public String getLine1Number() {
        return InvokeDynamicSupport.bootstrap("getLine1Number", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getLine1Number(), 0, this);
    }

    @Override
    public String getCdmaPrlVersion() {
        return InvokeDynamicSupport.bootstrap("getCdmaPrlVersion", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCdmaPrlVersion(), 0, this);
    }

    @Override
    public String getCdmaMin() {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCdmaMin(), 0, this);
    }

    @Override
    public boolean isMinInfoReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMinInfoReady", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isMinInfoReady(), 0, this);
    }

    @Override
    public void getCallWaiting(Message message) {
        InvokeDynamicSupport.bootstrap("getCallWaiting", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCallWaiting(android.os.Message ), 0, this, message);
    }

    @Override
    public void setRadioPower(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRadioPower", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setRadioPower(boolean ), 0, this, bl);
    }

    @Override
    public String getEsn() {
        return InvokeDynamicSupport.bootstrap("getEsn", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getEsn(), 0, this);
    }

    @Override
    public String getMeid() {
        return InvokeDynamicSupport.bootstrap("getMeid", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getMeid(), 0, this);
    }

    @Override
    public String getDeviceId() {
        return InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDeviceId(), 0, this);
    }

    @Override
    public String getDeviceSvn() {
        return InvokeDynamicSupport.bootstrap("getDeviceSvn", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDeviceSvn(), 0, this);
    }

    @Override
    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getSubscriberId(), 0, this);
    }

    @Override
    public String getGroupIdLevel1() {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getGroupIdLevel1(), 0, this);
    }

    @Override
    public String getImei() {
        return InvokeDynamicSupport.bootstrap("getImei", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getImei(), 0, this);
    }

    @Override
    public boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$canConference(), 0, this);
    }

    @Override
    public CellLocation getCellLocation() {
        return InvokeDynamicSupport.bootstrap("getCellLocation", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCellLocation(), 0, this);
    }

    @Override
    public CdmaCall getForegroundCall() {
        return InvokeDynamicSupport.bootstrap("getForegroundCall", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getForegroundCall(), 0, this);
    }

    @Override
    public void setOnPostDialCharacter(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnPostDialCharacter", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setOnPostDialCharacter(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public boolean handlePinMmi(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePinMmi", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handlePinMmi(java.lang.String ), 0, this, string2);
    }

    void onMMIDone(CdmaMmiCode cdmaMmiCode) {
        InvokeDynamicSupport.bootstrap("onMMIDone", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$onMMIDone(com.android.internal.telephony.cdma.CdmaMmiCode ), 0, this, cdmaMmiCode);
    }

    @Override
    public void setLine1Number(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setLine1Number", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setLine1Number(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setCallWaiting", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setCallWaiting(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void updateServiceLocation() {
        InvokeDynamicSupport.bootstrap("updateServiceLocation", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$updateServiceLocation(), 0, this);
    }

    @Override
    public void setDataRoamingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataRoamingEnabled", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setDataRoamingEnabled(boolean ), 0, this, bl);
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForCdmaOtaStatusChange(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForCdmaOtaStatusChange(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForSubscriptionInfoReady(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForSubscriptionInfoReady(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setOnEcbModeExitResponse(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler handler) {
        InvokeDynamicSupport.bootstrap("unsetOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unsetOnEcbModeExitResponse(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForCallWaiting(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCallWaiting", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForCallWaiting(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForCallWaiting(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCallWaiting", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForCallWaiting(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void getNeighboringCids(Message message) {
        InvokeDynamicSupport.bootstrap("getNeighboringCids", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getNeighboringCids(android.os.Message ), 0, this, message);
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState(String string2) {
        return InvokeDynamicSupport.bootstrap("getDataConnectionState", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDataConnectionState(java.lang.String ), 0, this, string2);
    }

    @Override
    public void sendUssdResponse(String string2) {
        InvokeDynamicSupport.bootstrap("sendUssdResponse", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$sendUssdResponse(java.lang.String ), 0, this, string2);
    }

    @Override
    public void sendDtmf(char c) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$sendDtmf(char ), 0, this, c);
    }

    @Override
    public void startDtmf(char c) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$startDtmf(char ), 0, this, c);
    }

    @Override
    public void stopDtmf() {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$stopDtmf(), 0, this);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$sendBurstDtmf(java.lang.String int int android.os.Message ), 0, this, string2, n, n2, message);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        InvokeDynamicSupport.bootstrap("getAvailableNetworks", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getAvailableNetworks(android.os.Message ), 0, this, message);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setOutgoingCallerIdDisplay(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void enableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("enableLocationUpdates", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$enableLocationUpdates(), 0, this);
    }

    @Override
    public void disableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("disableLocationUpdates", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$disableLocationUpdates(), 0, this);
    }

    @Override
    public void getDataCallList(Message message) {
        InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDataCallList(android.os.Message ), 0, this, message);
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataRoamingEnabled", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDataRoamingEnabled(), 0, this);
    }

    @Override
    public void setDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataEnabled", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setDataEnabled(boolean ), 0, this, bl);
    }

    @Override
    public boolean getDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataEnabled", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getDataEnabled(), 0, this);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setVoiceMailNumber(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public String getVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getVoiceMailNumber(), 0, this);
    }

    @Override
    public int getVoiceMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getVoiceMessageCount(), 0, this);
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getVoiceMailAlphaTag(), 0, this);
    }

    @Override
    public void getCallForwardingOption(int n, Message message) {
        InvokeDynamicSupport.bootstrap("getCallForwardingOption", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCallForwardingOption(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
        InvokeDynamicSupport.bootstrap("setCallForwardingOption", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setCallForwardingOption(int int java.lang.String int android.os.Message ), 0, this, n, n2, string2, n3, message);
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        InvokeDynamicSupport.bootstrap("getOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getOutgoingCallerIdDisplay(android.os.Message ), 0, this, message);
    }

    @Override
    public boolean getCallForwardingIndicator() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCallForwardingIndicator", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCallForwardingIndicator(), 0, this);
    }

    @Override
    public void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$explicitCallTransfer(), 0, this);
    }

    @Override
    public String getLine1AlphaTag() {
        return InvokeDynamicSupport.bootstrap("getLine1AlphaTag", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getLine1AlphaTag(), 0, this);
    }

    void notifyPhoneStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyPhoneStateChanged", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyPhoneStateChanged(), 0, this);
    }

    void notifyPreciseCallStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyPreciseCallStateChanged", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyPreciseCallStateChanged(), 0, this);
    }

    void notifyServiceStateChanged(ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("notifyServiceStateChanged", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyServiceStateChanged(android.telephony.ServiceState ), 0, this, serviceState);
    }

    void notifyLocationChanged() {
        InvokeDynamicSupport.bootstrap("notifyLocationChanged", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyLocationChanged(), 0, this);
    }

    public void notifyNewRingingConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyNewRingingConnection", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyNewRingingConnection(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    void notifyDisconnect(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyDisconnect", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyDisconnect(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    void notifyUnknownConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyUnknownConnection", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyUnknownConnection(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    @Override
    public boolean isInEmergencyCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEmergencyCall", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isInEmergencyCall(), 0, this);
    }

    @Override
    public boolean isInEcm() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEcm", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isInEcm(), 0, this);
    }

    void sendEmergencyCallbackModeChange() {
        InvokeDynamicSupport.bootstrap("sendEmergencyCallbackModeChange", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$sendEmergencyCallbackModeChange(), 0, this);
    }

    @Override
    public void exitEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$exitEmergencyCallbackMode(), 0, this);
    }

    private void handleEnterEmergencyCallbackMode(Message message) {
        InvokeDynamicSupport.bootstrap("handleEnterEmergencyCallbackMode", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleEnterEmergencyCallbackMode(android.os.Message ), 0, this, message);
    }

    private void handleExitEmergencyCallbackMode(Message message) {
        InvokeDynamicSupport.bootstrap("handleExitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleExitEmergencyCallbackMode(android.os.Message ), 0, this, message);
    }

    void handleTimerInEmergencyCallbackMode(int n) {
        InvokeDynamicSupport.bootstrap("handleTimerInEmergencyCallbackMode", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleTimerInEmergencyCallbackMode(int ), 0, this, n);
    }

    public void notifyEcbmTimerReset(Boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyEcbmTimerReset", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$notifyEcbmTimerReset(java.lang.Boolean ), 0, this, bl);
    }

    @Override
    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEcmTimerReset", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForEcmTimerReset(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEcmTimerReset", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForEcmTimerReset(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleMessage(android.os.Message ), 0, this, message);
    }

    protected UiccCardApplication getUiccCardApplication() {
        return InvokeDynamicSupport.bootstrap("getUiccCardApplication", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getUiccCardApplication(), 0, this);
    }

    @Override
    protected void onUpdateIccAvailability() {
        InvokeDynamicSupport.bootstrap("onUpdateIccAvailability", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$onUpdateIccAvailability(), 0, this);
    }

    private void processIccRecordEvents(int n) {
        InvokeDynamicSupport.bootstrap("processIccRecordEvents", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$processIccRecordEvents(int ), 0, this, n);
    }

    private void handleCdmaSubscriptionSource(int n) {
        InvokeDynamicSupport.bootstrap("handleCdmaSubscriptionSource", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$handleCdmaSubscriptionSource(int ), 0, this, n);
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return InvokeDynamicSupport.bootstrap("getPhoneSubInfo", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getPhoneSubInfo(), 0, this);
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return InvokeDynamicSupport.bootstrap("getIccPhoneBookInterfaceManager", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getIccPhoneBookInterfaceManager(), 0, this);
    }

    public void registerForEriFileLoaded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEriFileLoaded", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForEriFileLoaded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForEriFileLoaded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEriFileLoaded", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForEriFileLoaded(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void setSystemProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSystemProperty", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public String getSystemProperty(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getSystemProperty", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void activateCellBroadcastSms(int n, Message message) {
        InvokeDynamicSupport.bootstrap("activateCellBroadcastSms", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$activateCellBroadcastSms(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getCellBroadcastSmsConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getCellBroadcastSmsConfig", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCellBroadcastSmsConfig(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] nArray, Message message) {
        InvokeDynamicSupport.bootstrap("setCellBroadcastSmsConfig", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setCellBroadcastSmsConfig(int[] android.os.Message ), 0, this, nArray, message);
    }

    @Override
    public boolean needsOtaServiceProvisioning() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsOtaServiceProvisioning", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$needsOtaServiceProvisioning(), 0, this);
    }

    private static boolean isIs683OtaSpDialStr(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isIs683OtaSpDialStr", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isIs683OtaSpDialStr(java.lang.String ), 0, (String)string2);
    }

    private static int extractSelCodeFromOtaSpNum(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("extractSelCodeFromOtaSpNum", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$extractSelCodeFromOtaSpNum(java.lang.String ), 0, (String)string2);
    }

    private static boolean checkOtaSpNumBasedOnSysSelCode(int n, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkOtaSpNumBasedOnSysSelCode", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$checkOtaSpNumBasedOnSysSelCode(int java.lang.String[] ), 0, (int)n, (String[])stringArray);
    }

    private boolean isCarrierOtaSpNum(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCarrierOtaSpNum", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isCarrierOtaSpNum(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isOtaSpNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOtaSpNumber", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isOtaSpNumber(java.lang.String ), 0, this, string2);
    }

    @Override
    public int getCdmaEriIconIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCdmaEriIconIndex(), 0, this);
    }

    @Override
    public int getCdmaEriIconMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCdmaEriIconMode(), 0, this);
    }

    @Override
    public String getCdmaEriText() {
        return InvokeDynamicSupport.bootstrap("getCdmaEriText", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$getCdmaEriText(), 0, this);
    }

    private void storeVoiceMailNumber(String string2) {
        InvokeDynamicSupport.bootstrap("storeVoiceMailNumber", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$storeVoiceMailNumber(java.lang.String ), 0, this, string2);
    }

    protected void setIsoCountryProperty(String string2) {
        InvokeDynamicSupport.bootstrap("setIsoCountryProperty", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setIsoCountryProperty(java.lang.String ), 0, this, string2);
    }

    boolean updateCurrentCarrierInProvider(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateCurrentCarrierInProvider", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$updateCurrentCarrierInProvider(java.lang.String ), 0, this, string2);
    }

    boolean updateCurrentCarrierInProvider() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateCurrentCarrierInProvider", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$updateCurrentCarrierInProvider(), 0, this);
    }

    public void prepareEri() {
        InvokeDynamicSupport.bootstrap("prepareEri", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$prepareEri(), 0, this);
    }

    public boolean isEriFileLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEriFileLoaded", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$isEriFileLoaded(), 0, this);
    }

    protected void registerForRuimRecordEvents() {
        InvokeDynamicSupport.bootstrap("registerForRuimRecordEvents", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$registerForRuimRecordEvents(), 0, this);
    }

    protected void unregisterForRuimRecordEvents() {
        InvokeDynamicSupport.bootstrap("unregisterForRuimRecordEvents", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$unregisterForRuimRecordEvents(), 0, this);
    }

    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$log(java.lang.String ), 0, this, string2);
    }

    protected void loge(String string2, Exception exception) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$loge(java.lang.String java.lang.Exception ), 0, this, string2, exception);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public boolean setOperatorBrandOverride(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$com_android_internal_telephony_cdma_CDMAPhone$setOperatorBrandOverride(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(CDMAPhone.class);
    }

    public /* synthetic */ CDMAPhone() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CDMAPhone)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 2
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$DctConstants$Activity;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$DctConstants$State;

        static void __staticInitializer__() {
            $SwitchMap$com$android$internal$telephony$DctConstants$State = new int[DctConstants.State.values().length];
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.RETRYING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.IDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.CONNECTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.DISCONNECTING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.CONNECTING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.SCANNING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $SwitchMap$com$android$internal$telephony$DctConstants$Activity = new int[DctConstants.Activity.values().length];
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[DctConstants.Activity.DATAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[DctConstants.Activity.DATAOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[DctConstants.Activity.DATAINANDOUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[DctConstants.Activity.DORMANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(2.class);
        }

        public /* synthetic */ 2() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (2)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

