/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaConnection;
import com.google.errorprone.annotations.DoNotMock;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CdmaCall
extends Call
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    CdmaCallTracker mOwner;

    private static final Call.State $$robo$$com_android_internal_telephony_cdma_CdmaCall$stateFromDCState(DriverCall.State dcState) {
        switch (1.$SwitchMap$com$android$internal$telephony$DriverCall$State[dcState.ordinal()]) {
            case 1: {
                return Call.State.ACTIVE;
            }
            case 2: {
                return Call.State.HOLDING;
            }
            case 3: {
                return Call.State.DIALING;
            }
            case 4: {
                return Call.State.ALERTING;
            }
            case 5: {
                return Call.State.INCOMING;
            }
            case 6: {
                return Call.State.WAITING;
            }
        }
        throw new RuntimeException("illegal call state:" + (Object)((Object)dcState));
    }

    private void $$robo$$com_android_internal_telephony_cdma_CdmaCall$__constructor__(CdmaCallTracker owner) {
        this.mOwner = owner;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCall$dispose() {
    }

    private final List<Connection> $$robo$$com_android_internal_telephony_cdma_CdmaCall$getConnections() {
        return this.mConnections;
    }

    private final Phone $$robo$$com_android_internal_telephony_cdma_CdmaCall$getPhone() {
        return this.mOwner.mPhone;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaCall$isMultiparty() {
        return this.mConnections.size() > 1;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCall$hangup() throws CallStateException {
        this.mOwner.hangup(this);
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CdmaCall$toString() {
        return this.mState.toString();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCall$attach(Connection conn, DriverCall dc) {
        this.mConnections.add(conn);
        this.mState = CdmaCall.stateFromDCState(dc.state);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCall$attachFake(Connection conn, Call.State state) {
        this.mConnections.add(conn);
        this.mState = state;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaCall$connectionDisconnected(CdmaConnection conn) {
        if (this.mState != Call.State.DISCONNECTED) {
            boolean hasOnlyDisconnectedConnections = true;
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                if (((Connection)this.mConnections.get(i)).getState() == Call.State.DISCONNECTED) continue;
                hasOnlyDisconnectedConnections = false;
                break;
            }
            if (hasOnlyDisconnectedConnections) {
                this.mState = Call.State.DISCONNECTED;
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCall$detach(CdmaConnection conn) {
        this.mConnections.remove(conn);
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaCall$update(CdmaConnection conn, DriverCall dc) {
        boolean changed = false;
        Call.State newState = CdmaCall.stateFromDCState(dc.state);
        if (newState != this.mState) {
            this.mState = newState;
            changed = true;
        }
        return changed;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaCall$isFull() {
        return this.mConnections.size() == 1;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCall$onHangupLocal() {
        int s = this.mConnections.size();
        for (int i = 0; i < s; ++i) {
            CdmaConnection cn = (CdmaConnection)this.mConnections.get(i);
            cn.onHangupLocal();
        }
        this.mState = Call.State.DISCONNECTING;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCall$clearDisconnected() {
        for (int i = this.mConnections.size() - 1; i >= 0; --i) {
            CdmaConnection cn = (CdmaConnection)this.mConnections.get(i);
            if (cn.getState() != Call.State.DISCONNECTED) continue;
            this.mConnections.remove(i);
        }
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }

    static Call.State stateFromDCState(DriverCall.State state) {
        return InvokeDynamicSupport.bootstrapStatic("stateFromDCState", $$robo$$com_android_internal_telephony_cdma_CdmaCall$stateFromDCState(com.android.internal.telephony.DriverCall$State ), 0, (DriverCall.State)state);
    }

    private void __constructor__(CdmaCallTracker cdmaCallTracker) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaCall$__constructor__(cdmaCallTracker);
    }

    CdmaCall(CdmaCallTracker cdmaCallTracker) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaCall$__constructor__(com.android.internal.telephony.cdma.CdmaCallTracker ), 0, this, cdmaCallTracker);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cdma_CdmaCall$dispose(), 0, this);
    }

    @Override
    public List<Connection> getConnections() {
        return InvokeDynamicSupport.bootstrap("getConnections", $$robo$$com_android_internal_telephony_cdma_CdmaCall$getConnections(), 0, this);
    }

    @Override
    public Phone getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_cdma_CdmaCall$getPhone(), 0, this);
    }

    @Override
    public boolean isMultiparty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiparty", $$robo$$com_android_internal_telephony_cdma_CdmaCall$isMultiparty(), 0, this);
    }

    @Override
    public void hangup() throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_cdma_CdmaCall$hangup(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_cdma_CdmaCall$toString(), 0, this);
    }

    void attach(Connection connection, DriverCall driverCall) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$com_android_internal_telephony_cdma_CdmaCall$attach(com.android.internal.telephony.Connection com.android.internal.telephony.DriverCall ), 0, this, connection, driverCall);
    }

    void attachFake(Connection connection, Call.State state) {
        InvokeDynamicSupport.bootstrap("attachFake", $$robo$$com_android_internal_telephony_cdma_CdmaCall$attachFake(com.android.internal.telephony.Connection com.android.internal.telephony.Call$State ), 0, this, connection, state);
    }

    boolean connectionDisconnected(CdmaConnection cdmaConnection) {
        return (boolean)InvokeDynamicSupport.bootstrap("connectionDisconnected", $$robo$$com_android_internal_telephony_cdma_CdmaCall$connectionDisconnected(com.android.internal.telephony.cdma.CdmaConnection ), 0, this, cdmaConnection);
    }

    void detach(CdmaConnection cdmaConnection) {
        InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_telephony_cdma_CdmaCall$detach(com.android.internal.telephony.cdma.CdmaConnection ), 0, this, cdmaConnection);
    }

    boolean update(CdmaConnection cdmaConnection, DriverCall driverCall) {
        return (boolean)InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_cdma_CdmaCall$update(com.android.internal.telephony.cdma.CdmaConnection com.android.internal.telephony.DriverCall ), 0, this, cdmaConnection, driverCall);
    }

    boolean isFull() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFull", $$robo$$com_android_internal_telephony_cdma_CdmaCall$isFull(), 0, this);
    }

    void onHangupLocal() {
        InvokeDynamicSupport.bootstrap("onHangupLocal", $$robo$$com_android_internal_telephony_cdma_CdmaCall$onHangupLocal(), 0, this);
    }

    void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_cdma_CdmaCall$clearDisconnected(), 0, this);
    }

    public /* synthetic */ CdmaCall() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CdmaCall)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$DriverCall$State;

        static void __staticInitializer__() {
            $SwitchMap$com$android$internal$telephony$DriverCall$State = new int[DriverCall.State.values().length];
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.ACTIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.HOLDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.DIALING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.ALERTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.INCOMING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.WAITING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

