/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaConnection;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CdmaCallTracker
extends CallTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "CdmaCallTracker";
    private static boolean REPEAT_POLLING = false;
    private static boolean DBG_POLL = false;
    static int MAX_CONNECTIONS = 8;
    static int MAX_CONNECTIONS_PER_CALL = 1;
    CdmaConnection[] mConnections;
    RegistrantList mVoiceCallEndedRegistrants;
    RegistrantList mVoiceCallStartedRegistrants;
    RegistrantList mCallWaitingRegistrants;
    ArrayList<CdmaConnection> mDroppedDuringPoll;
    CdmaCall mRingingCall;
    CdmaCall mForegroundCall;
    CdmaCall mBackgroundCall;
    CdmaConnection mPendingMO;
    boolean mHangupPendingMO;
    boolean mPendingCallInEcm;
    boolean mIsInEmergencyCall;
    CDMAPhone mPhone;
    boolean mDesiredMute;
    int mPendingCallClirMode;
    PhoneConstants.State mState;
    private boolean mIsEcmTimerCanceled;
    private int m3WayCallFlashDelay;

    private void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$__constructor__(CDMAPhone phone) {
        this.mConnections = new CdmaConnection[8];
        this.mVoiceCallEndedRegistrants = new RegistrantList();
        this.mVoiceCallStartedRegistrants = new RegistrantList();
        this.mCallWaitingRegistrants = new RegistrantList();
        this.mDroppedDuringPoll = new ArrayList(8);
        this.mRingingCall = new CdmaCall(this);
        this.mForegroundCall = new CdmaCall(this);
        this.mBackgroundCall = new CdmaCall(this);
        this.mPendingCallInEcm = false;
        this.mIsInEmergencyCall = false;
        this.mDesiredMute = false;
        this.mState = PhoneConstants.State.IDLE;
        this.mIsEcmTimerCanceled = false;
        this.m3WayCallFlashDelay = 0;
        this.mPhone = phone;
        this.mCi = phone.mCi;
        this.mCi.registerForCallStateChanged(this, 2, null);
        this.mCi.registerForOn(this, 9, null);
        this.mCi.registerForNotAvailable(this, 10, null);
        this.mCi.registerForCallWaitingInfo(this, 15, null);
        this.mForegroundCall.setGeneric(false);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$dispose() {
        Rlog.d("CdmaCallTracker", "CdmaCallTracker dispose");
        this.mCi.unregisterForLineControlInfo(this);
        this.mCi.unregisterForCallStateChanged(this);
        this.mCi.unregisterForOn(this);
        this.mCi.unregisterForNotAvailable(this);
        this.mCi.unregisterForCallWaitingInfo(this);
        this.clearDisconnected();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$finalize() {
        Rlog.d("CdmaCallTracker", "CdmaCallTracker finalized");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
        if (this.mState != PhoneConstants.State.IDLE) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$registerForCallWaiting(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mCallWaitingRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$unregisterForCallWaiting(Handler h) {
        this.mCallWaitingRegistrants.remove(h);
    }

    private final Connection $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$dial(String dialString, int clirMode) throws CallStateException {
        boolean internationalRoaming;
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        String origNumber = dialString;
        String operatorIsoContry = this.mPhone.getSystemProperty("gsm.operator.iso-country", "");
        String simIsoContry = this.mPhone.getSystemProperty("gsm.sim.operator.iso-country", "");
        boolean bl = internationalRoaming = !TextUtils.isEmpty(operatorIsoContry) && !TextUtils.isEmpty(simIsoContry) && !simIsoContry.equals(operatorIsoContry);
        if (internationalRoaming) {
            if ("us".equals(simIsoContry)) {
                internationalRoaming = internationalRoaming && !"vi".equals(operatorIsoContry);
            } else if ("vi".equals(simIsoContry)) {
                boolean bl2 = internationalRoaming = internationalRoaming && !"us".equals(operatorIsoContry);
            }
        }
        if (internationalRoaming) {
            dialString = this.convertNumberIfNecessary(this.mPhone, dialString);
        }
        String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
        boolean isPhoneInEcmMode = inEcm.equals("true");
        boolean isEmergencyCall = PhoneNumberUtils.isLocalEmergencyNumber(this.mPhone.getContext(), dialString);
        if (isPhoneInEcmMode && isEmergencyCall) {
            this.handleEcmTimer(1);
        }
        this.mForegroundCall.setGeneric(false);
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            return this.dialThreeWay(dialString);
        }
        this.mPendingMO = new CdmaConnection(this.mPhone.getContext(), this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall);
        this.mHangupPendingMO = false;
        if (this.mPendingMO.getAddress() == null || this.mPendingMO.getAddress().length() == 0 || this.mPendingMO.getAddress().indexOf(78) >= 0) {
            this.mPendingMO.mCause = 7;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.disableDataCallInEmergencyCall(dialString);
            if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyCall) {
                this.mCi.dial(this.mPendingMO.getAddress(), clirMode, this.obtainCompleteMessage());
            } else {
                this.mPhone.exitEmergencyCallbackMode();
                this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                this.mPendingCallClirMode = clirMode;
                this.mPendingCallInEcm = true;
            }
        }
        if (this.mNumberConverted) {
            this.mPendingMO.setConverted(origNumber);
            this.mNumberConverted = false;
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    private final Connection $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$dial(String dialString) throws CallStateException {
        return this.dial(dialString, 0);
    }

    private final Connection $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$dialThreeWay(String dialString) {
        if (!this.mForegroundCall.isIdle()) {
            this.disableDataCallInEmergencyCall(dialString);
            this.mPendingMO = new CdmaConnection(this.mPhone.getContext(), this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall);
            this.m3WayCallFlashDelay = this.mPhone.getContext().getResources().getInteger(17694837);
            if (this.m3WayCallFlashDelay > 0) {
                this.mCi.sendCDMAFeatureCode("", this.obtainMessage(20));
            } else {
                this.mCi.sendCDMAFeatureCode(this.mPendingMO.getAddress(), this.obtainMessage(16));
            }
            return this.mPendingMO;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$acceptCall() throws CallStateException {
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            Rlog.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            this.mCi.acceptCall(this.obtainCompleteMessage());
        } else if (this.mRingingCall.getState() == Call.State.WAITING) {
            CdmaConnection cwConn = (CdmaConnection)this.mRingingCall.getLatestConnection();
            cwConn.updateParent(this.mRingingCall, this.mForegroundCall);
            cwConn.onConnectedInOrOut();
            this.updatePhoneState();
            this.switchWaitingOrHoldingAndActive();
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$rejectCall() throws CallStateException {
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.mCi.rejectCall(this.obtainCompleteMessage());
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$switchWaitingOrHoldingAndActive() throws CallStateException {
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.mForegroundCall.getConnections().size() > 1) {
            this.flashAndSetGenericTrue();
        } else {
            this.mCi.sendCDMAFeatureCode("", this.obtainMessage(8));
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$conference() {
        this.flashAndSetGenericTrue();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$explicitCallTransfer() {
        this.mCi.explicitCallTransfer(this.obtainCompleteMessage(13));
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$canDial() {
        boolean ret;
        int serviceState = this.mPhone.getServiceState().getState();
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean bl = ret = serviceState != 3 && this.mPendingMO == null && !this.mRingingCall.isRinging() && !disableCall.equals("true") && (!this.mForegroundCall.getState().isAlive() || this.mForegroundCall.getState() == Call.State.ACTIVE || !this.mBackgroundCall.getState().isAlive());
        if (!ret) {
            this.log(String.format("canDial is false\n((serviceState=%d) != ServiceState.STATE_POWER_OFF)::=%s\n&& pendingMO == null::=%s\n&& !ringingCall.isRinging()::=%s\n&& !disableCall.equals(\"true\")::=%s\n&& (!foregroundCall.getState().isAlive()::=%s\n   || foregroundCall.getState() == CdmaCall.State.ACTIVE::=%s\n   ||!backgroundCall.getState().isAlive())::=%s)", serviceState, serviceState != 3, this.mPendingMO == null, !this.mRingingCall.isRinging(), !disableCall.equals("true"), !this.mForegroundCall.getState().isAlive(), this.mForegroundCall.getState() == Call.State.ACTIVE, !this.mBackgroundCall.getState().isAlive()));
        }
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$canTransfer() {
        Rlog.e("CdmaCallTracker", "canTransfer: not possible in CDMA");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
    }

    private final Message $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    private final Message $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$obtainCompleteMessage(int what) {
        ++this.mPendingOperations;
        this.mLastRelevantPoll = null;
        this.mNeedsPoll = true;
        return this.obtainMessage(what);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$operationComplete() {
        --this.mPendingOperations;
        if (this.mPendingOperations == 0 && this.mNeedsPoll) {
            this.mLastRelevantPoll = this.obtainMessage(1);
            this.mCi.getCurrentCalls(this.mLastRelevantPoll);
        } else if (this.mPendingOperations < 0) {
            Rlog.e("CdmaCallTracker", "CdmaCallTracker.pendingOperations < 0");
            this.mPendingOperations = 0;
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$updatePhoneState() {
        PhoneConstants.State oldState = this.mState;
        this.mState = this.mRingingCall.isRinging() ? PhoneConstants.State.RINGING : (this.mPendingMO != null || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle() ? PhoneConstants.State.OFFHOOK : PhoneConstants.State.IDLE);
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("update phone state, old=" + (Object)((Object)oldState) + " new=" + (Object)((Object)this.mState));
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$handlePollCalls(AsyncResult ar) {
        int i;
        ArrayList polledCalls;
        if (ar.exception == null) {
            polledCalls = (ArrayList)ar.result;
        } else if (this.isCommandExceptionRadioNotAvailable(ar.exception)) {
            polledCalls = new ArrayList();
        } else {
            this.pollCallsAfterDelay();
            return;
        }
        Connection newRinging = null;
        CdmaConnection newUnknown = null;
        boolean hasNonHangupStateChanged = false;
        boolean hasAnyCallDisconnected = false;
        boolean needsPollDelay = false;
        boolean unknownConnectionAppeared = false;
        int curDC = 0;
        int dcSize = polledCalls.size();
        for (i = 0; i < this.mConnections.length; ++i) {
            CdmaConnection conn = this.mConnections[i];
            DriverCall dc = null;
            if (curDC < dcSize) {
                dc = (DriverCall)polledCalls.get(curDC);
                if (dc.index == i + 1) {
                    ++curDC;
                } else {
                    dc = null;
                }
            }
            if (conn == null && dc != null) {
                if (this.mPendingMO != null && this.mPendingMO.compareTo(dc)) {
                    this.mConnections[i] = this.mPendingMO;
                    this.mPendingMO.mIndex = i;
                    this.mPendingMO.update(dc);
                    this.mPendingMO = null;
                    if (this.mHangupPendingMO) {
                        this.mHangupPendingMO = false;
                        if (this.mIsEcmTimerCanceled) {
                            this.handleEcmTimer(0);
                        }
                        try {
                            this.log("poll: hangupPendingMO, hangup conn " + i);
                            this.hangup(this.mConnections[i]);
                        }
                        catch (CallStateException ex) {
                            Rlog.e("CdmaCallTracker", "unexpected error on hangup");
                        }
                        return;
                    }
                } else {
                    this.log("pendingMo=" + this.mPendingMO + ", dc=" + dc);
                    this.mConnections[i] = new CdmaConnection(this.mPhone.getContext(), dc, this, i);
                    if (this.mHandoverConnection != null) {
                        this.mPhone.migrateFrom((PhoneBase)this.mPhone.getImsPhone());
                        this.mConnections[i].migrateFrom(this.mHandoverConnection);
                        this.mPhone.notifyHandoverStateChanged(this.mConnections[i]);
                        this.mHandoverConnection = null;
                    } else {
                        newRinging = this.checkMtFindNewRinging(dc, i);
                        if (newRinging == null) {
                            unknownConnectionAppeared = true;
                        }
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn != null && dc == null) {
                CdmaConnection cn;
                int n;
                int count = this.mForegroundCall.mConnections.size();
                for (n = 0; n < count; ++n) {
                    this.log("adding fgCall cn " + n + " to droppedDuringPoll");
                    cn = (CdmaConnection)this.mForegroundCall.mConnections.get(n);
                    this.mDroppedDuringPoll.add(cn);
                }
                count = this.mRingingCall.mConnections.size();
                for (n = 0; n < count; ++n) {
                    this.log("adding rgCall cn " + n + " to droppedDuringPoll");
                    cn = (CdmaConnection)this.mRingingCall.mConnections.get(n);
                    this.mDroppedDuringPoll.add(cn);
                }
                this.mForegroundCall.setGeneric(false);
                this.mRingingCall.setGeneric(false);
                if (this.mIsEcmTimerCanceled) {
                    this.handleEcmTimer(0);
                }
                this.checkAndEnableDataCallAfterEmergencyCallDropped();
                this.mConnections[i] = null;
                continue;
            }
            if (conn == null || dc == null) continue;
            if (conn.isIncoming() != dc.isMT) {
                if (dc.isMT) {
                    this.mDroppedDuringPoll.add(conn);
                    newRinging = this.checkMtFindNewRinging(dc, i);
                    if (newRinging == null) {
                        unknownConnectionAppeared = true;
                        newUnknown = conn;
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                    continue;
                }
                Rlog.e("CdmaCallTracker", "Error in RIL, Phantom call appeared " + dc);
                continue;
            }
            boolean changed = conn.update(dc);
            hasNonHangupStateChanged = hasNonHangupStateChanged || changed;
        }
        if (this.mPendingMO != null) {
            Rlog.d("CdmaCallTracker", "Pending MO dropped before poll fg state:" + (Object)((Object)this.mForegroundCall.getState()));
            this.mDroppedDuringPoll.add(this.mPendingMO);
            this.mPendingMO = null;
            this.mHangupPendingMO = false;
            if (this.mPendingCallInEcm) {
                this.mPendingCallInEcm = false;
            }
        }
        if (newRinging != null) {
            this.mPhone.notifyNewRingingConnection(newRinging);
        }
        for (i = this.mDroppedDuringPoll.size() - 1; i >= 0; --i) {
            CdmaConnection conn = this.mDroppedDuringPoll.get(i);
            if (conn.isIncoming() && conn.getConnectTime() == 0L) {
                int cause = conn.mCause == 3 ? 16 : 1;
                this.log("missed/rejected call, conn.cause=" + conn.mCause);
                this.log("setting cause to " + cause);
                this.mDroppedDuringPoll.remove(i);
                hasAnyCallDisconnected |= conn.onDisconnect(cause);
                continue;
            }
            if (conn.mCause != 3 && conn.mCause != 7) continue;
            this.mDroppedDuringPoll.remove(i);
            hasAnyCallDisconnected |= conn.onDisconnect(conn.mCause);
        }
        if (this.mDroppedDuringPoll.size() > 0) {
            this.mCi.getLastCallFailCause(this.obtainNoPollCompleteMessage(5));
        }
        if (needsPollDelay) {
            this.pollCallsAfterDelay();
        }
        if (newRinging != null || hasNonHangupStateChanged || hasAnyCallDisconnected) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (unknownConnectionAppeared) {
            this.mPhone.notifyUnknownConnection(newUnknown);
        }
        if (hasNonHangupStateChanged || newRinging != null || hasAnyCallDisconnected) {
            this.mPhone.notifyPreciseCallStateChanged();
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangup(CdmaConnection conn) throws CallStateException {
        if (conn.mOwner != this) {
            throw new CallStateException("CdmaConnection " + conn + "does not belong to CdmaCallTracker " + this);
        }
        if (conn == this.mPendingMO) {
            this.log("hangup: set hangupPendingMO to true");
            this.mHangupPendingMO = true;
        } else {
            if (conn.getCall() == this.mRingingCall && this.mRingingCall.getState() == Call.State.WAITING) {
                conn.onLocalDisconnect();
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                return;
            }
            try {
                this.mCi.hangupConnection(conn.getCDMAIndex(), this.obtainCompleteMessage());
            }
            catch (CallStateException ex) {
                Rlog.w("CdmaCallTracker", "CdmaCallTracker WARN: hangup() on absent connection " + conn);
            }
        }
        conn.onHangupLocal();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$separate(CdmaConnection conn) throws CallStateException {
        if (conn.mOwner != this) {
            throw new CallStateException("CdmaConnection " + conn + "does not belong to CdmaCallTracker " + this);
        }
        try {
            this.mCi.separateConnection(conn.getCDMAIndex(), this.obtainCompleteMessage(12));
        }
        catch (CallStateException ex) {
            Rlog.w("CdmaCallTracker", "CdmaCallTracker WARN: separate() on absent connection " + conn);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mCi.setMute(this.mDesiredMute, null);
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$getMute() {
        return this.mDesiredMute;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangup(CdmaCall call) throws CallStateException {
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup waiting or background");
            this.mCi.hangupWaitingOrBackground(this.obtainCompleteMessage());
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
                this.hangup((CdmaConnection)call.getConnections().get(0));
            } else {
                this.hangupForegroundResumeBackground();
            }
        } else if (call == this.mBackgroundCall) {
            if (this.mRingingCall.isRinging()) {
                this.log("hangup all conns in background call");
                this.hangupAllConnections(call);
            } else {
                this.hangupWaitingOrBackground();
            }
        } else {
            throw new RuntimeException("CdmaCall " + call + "does not belong to CdmaCallTracker " + this);
        }
        call.onHangupLocal();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        this.mCi.hangupWaitingOrBackground(this.obtainCompleteMessage());
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        this.mCi.hangupForegroundResumeBackground(this.obtainCompleteMessage());
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangupConnectionByIndex(CdmaCall call, int index) throws CallStateException {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            CdmaConnection cn = (CdmaConnection)call.mConnections.get(i);
            if (cn.getCDMAIndex() != index) continue;
            this.mCi.hangupConnection(index, this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("no gsm index found");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangupAllConnections(CdmaCall call) {
        try {
            int count = call.mConnections.size();
            for (int i = 0; i < count; ++i) {
                CdmaConnection cn = (CdmaConnection)call.mConnections.get(i);
                this.mCi.hangupConnection(cn.getCDMAIndex(), this.obtainCompleteMessage());
            }
        }
        catch (CallStateException ex) {
            Rlog.e("CdmaCallTracker", "hangupConnectionByIndex caught " + ex);
        }
    }

    private final CdmaConnection $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$getConnectionByIndex(CdmaCall call, int index) throws CallStateException {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            CdmaConnection cn = (CdmaConnection)call.mConnections.get(i);
            if (cn.getCDMAIndex() != index) continue;
            return cn;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$flashAndSetGenericTrue() {
        this.mCi.sendCDMAFeatureCode("", this.obtainMessage(8));
        this.mForegroundCall.setGeneric(true);
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$notifyCallWaitingInfo(CdmaCallWaitingNotification obj) {
        if (this.mCallWaitingRegistrants != null) {
            this.mCallWaitingRegistrants.notifyRegistrants(new AsyncResult(null, obj, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$handleCallWaitingInfo(CdmaCallWaitingNotification cw) {
        if (this.mForegroundCall.mConnections.size() > 1) {
            this.mForegroundCall.setGeneric(true);
        }
        this.mRingingCall.setGeneric(false);
        new CdmaConnection(this.mPhone.getContext(), cw, this, this.mRingingCall);
        this.updatePhoneState();
        this.notifyCallWaitingInfo(cw);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$handleMessage(Message msg) {
        if (!this.mPhone.mIsTheCurrentActivePhone) {
            Rlog.w("CdmaCallTracker", "Ignoring events received on inactive CdmaPhone");
            return;
        }
        switch (msg.what) {
            case 1: {
                Rlog.d("CdmaCallTracker", "Event EVENT_POLL_CALLS_RESULT Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (msg != this.mLastRelevantPoll) break;
                this.mNeedsPoll = false;
                this.mLastRelevantPoll = null;
                this.handlePollCalls((AsyncResult)msg.obj);
                break;
            }
            case 4: {
                this.operationComplete();
                break;
            }
            case 8: {
                break;
            }
            case 5: {
                int causeCode;
                AsyncResult ar = (AsyncResult)msg.obj;
                this.operationComplete();
                if (ar.exception != null) {
                    causeCode = 16;
                    Rlog.i("CdmaCallTracker", "Exception during getLastCallFailCause, assuming normal disconnect");
                } else {
                    causeCode = ((int[])ar.result)[0];
                }
                int s = this.mDroppedDuringPoll.size();
                for (int i = 0; i < s; ++i) {
                    CdmaConnection conn = this.mDroppedDuringPoll.get(i);
                    conn.onRemoteDisconnect(causeCode);
                }
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                this.mDroppedDuringPoll.clear();
                break;
            }
            case 2: 
            case 3: {
                this.pollCallsWhenSafe();
                break;
            }
            case 9: {
                this.handleRadioAvailable();
                break;
            }
            case 10: {
                this.handleRadioNotAvailable();
                break;
            }
            case 14: {
                if (this.mPendingCallInEcm) {
                    this.mCi.dial(this.mPendingMO.getAddress(), this.mPendingCallClirMode, this.obtainCompleteMessage());
                    this.mPendingCallInEcm = false;
                }
                this.mPhone.unsetOnEcbModeExitResponse(this);
                break;
            }
            case 15: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.handleCallWaitingInfo((CdmaCallWaitingNotification)ar.result);
                Rlog.d("CdmaCallTracker", "Event EVENT_CALL_WAITING_INFO_CDMA Received");
                break;
            }
            case 16: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mPendingMO.onConnectedInOrOut();
                this.mPendingMO = null;
                break;
            }
            case 20: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.postDelayed(new Runnable(this){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ CdmaCallTracker this$0;

                        private void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker_1$__constructor__(CdmaCallTracker cdmaCallTracker) {
                        }

                        private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker_1$run() {
                            if (this.this$0.mPendingMO != null) {
                                this.this$0.mCi.sendCDMAFeatureCode(this.this$0.mPendingMO.getAddress(), this.this$0.obtainMessage(16));
                            }
                        }

                        private void __constructor__(CdmaCallTracker cdmaCallTracker) {
                            this.$$robo$$com_android_internal_telephony_cdma_CdmaCallTracker_1$__constructor__(cdmaCallTracker);
                        }
                        {
                            this.this$0 = cdmaCallTracker;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker_1$__constructor__(com.android.internal.telephony.cdma.CdmaCallTracker ), 0, this, cdmaCallTracker);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker_1$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    }, this.m3WayCallFlashDelay);
                    break;
                }
                this.mPendingMO = null;
                Rlog.w("CdmaCallTracker", "exception happened on Blank Flash for 3-way call");
                break;
            }
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$handleEcmTimer(int action) {
        this.mPhone.handleTimerInEmergencyCallbackMode(action);
        switch (action) {
            case 1: {
                this.mIsEcmTimerCanceled = true;
                break;
            }
            case 0: {
                this.mIsEcmTimerCanceled = false;
                break;
            }
            default: {
                Rlog.e("CdmaCallTracker", "handleEcmTimer, unsupported action " + action);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$disableDataCallInEmergencyCall(String dialString) {
        if (PhoneNumberUtils.isLocalEmergencyNumber(this.mPhone.getContext(), dialString)) {
            this.log("disableDataCallInEmergencyCall");
            this.mIsInEmergencyCall = true;
            this.mPhone.mDcTracker.setInternalDataEnabled(false);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$checkAndEnableDataCallAfterEmergencyCallDropped() {
        if (this.mIsInEmergencyCall) {
            this.mIsInEmergencyCall = false;
            String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
            this.log("checkAndEnableDataCallAfterEmergencyCallDropped,inEcm=" + inEcm);
            if (inEcm.compareTo("false") == 0) {
                this.mPhone.mDcTracker.setInternalDataEnabled(true);
            }
        }
    }

    private final Connection $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$checkMtFindNewRinging(DriverCall dc, int i) {
        CdmaConnection newRinging = null;
        if (this.mConnections[i].getCall() == this.mRingingCall) {
            newRinging = this.mConnections[i];
            this.log("Notify new ring " + dc);
        } else {
            Rlog.e("CdmaCallTracker", "Phantom call appeared " + dc);
            if (dc.state != DriverCall.State.ALERTING && dc.state != DriverCall.State.DIALING) {
                this.mConnections[i].onConnectedInOrOut();
                if (dc.state == DriverCall.State.HOLDING) {
                    this.mConnections[i].onStartedHolding();
                }
            }
        }
        return newRinging;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$log(String msg) {
        Rlog.d("CdmaCallTracker", "[CdmaCallTracker] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("GsmCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println("droppedDuringPoll: length=" + this.mConnections.length);
        for (i = 0; i < this.mConnections.length; ++i) {
            pw.printf(" mConnections[%d]=%s\n", i, this.mConnections[i]);
        }
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        pw.println(" mCallWaitingRegistrants=" + this.mCallWaitingRegistrants);
        pw.println("droppedDuringPoll: size=" + this.mDroppedDuringPoll.size());
        for (i = 0; i < this.mDroppedDuringPoll.size(); ++i) {
            pw.printf(" mDroppedDuringPoll[%d]=%s\n", i, this.mDroppedDuringPoll.get(i));
        }
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mHangupPendingMO=" + this.mHangupPendingMO);
        pw.println(" mPendingCallInEcm=" + this.mPendingCallInEcm);
        pw.println(" mIsInEmergencyCall=" + this.mIsInEmergencyCall);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mPendingCallClirMode=" + this.mPendingCallClirMode);
        pw.println(" mState=" + (Object)((Object)this.mState));
        pw.println(" mIsEcmTimerCanceled=" + this.mIsEcmTimerCanceled);
    }

    private void __constructor__(CDMAPhone cDMAPhone) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$__constructor__(cDMAPhone);
    }

    CdmaCallTracker(CDMAPhone cDMAPhone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$__constructor__(com.android.internal.telephony.cdma.CDMAPhone ), 0, this, cDMAPhone);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$dispose(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$finalize(), 0, this);
    }

    @Override
    public void registerForVoiceCallStarted(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallStarted", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$registerForVoiceCallStarted(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallStarted", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$unregisterForVoiceCallStarted(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForVoiceCallEnded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallEnded", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$registerForVoiceCallEnded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallEnded", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$unregisterForVoiceCallEnded(android.os.Handler ), 0, this, handler);
    }

    public void registerForCallWaiting(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCallWaiting", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$registerForCallWaiting(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForCallWaiting(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCallWaiting", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$unregisterForCallWaiting(android.os.Handler ), 0, this, handler);
    }

    Connection dial(String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$dial(java.lang.String int ), 0, this, string2, n);
    }

    Connection dial(String string2) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$dial(java.lang.String ), 0, this, string2);
    }

    private Connection dialThreeWay(String string2) {
        return InvokeDynamicSupport.bootstrap("dialThreeWay", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$dialThreeWay(java.lang.String ), 0, this, string2);
    }

    void acceptCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$acceptCall(), 0, this);
    }

    void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$rejectCall(), 0, this);
    }

    void switchWaitingOrHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchWaitingOrHoldingAndActive", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$switchWaitingOrHoldingAndActive(), 0, this);
    }

    void conference() {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$conference(), 0, this);
    }

    void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$explicitCallTransfer(), 0, this);
    }

    void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$clearDisconnected(), 0, this);
    }

    boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$canConference(), 0, this);
    }

    boolean canDial() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDial", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$canDial(), 0, this);
    }

    boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$canTransfer(), 0, this);
    }

    private void internalClearDisconnected() {
        InvokeDynamicSupport.bootstrap("internalClearDisconnected", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$internalClearDisconnected(), 0, this);
    }

    private Message obtainCompleteMessage() {
        return InvokeDynamicSupport.bootstrap("obtainCompleteMessage", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$obtainCompleteMessage(), 0, this);
    }

    private Message obtainCompleteMessage(int n) {
        return InvokeDynamicSupport.bootstrap("obtainCompleteMessage", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$obtainCompleteMessage(int ), 0, this, n);
    }

    private void operationComplete() {
        InvokeDynamicSupport.bootstrap("operationComplete", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$operationComplete(), 0, this);
    }

    private void updatePhoneState() {
        InvokeDynamicSupport.bootstrap("updatePhoneState", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$updatePhoneState(), 0, this);
    }

    @Override
    protected void handlePollCalls(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handlePollCalls", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$handlePollCalls(android.os.AsyncResult ), 0, this, asyncResult);
    }

    void hangup(CdmaConnection cdmaConnection) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangup(com.android.internal.telephony.cdma.CdmaConnection ), 0, this, cdmaConnection);
    }

    void separate(CdmaConnection cdmaConnection) throws CallStateException {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$separate(com.android.internal.telephony.cdma.CdmaConnection ), 0, this, cdmaConnection);
    }

    void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$setMute(boolean ), 0, this, bl);
    }

    boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$getMute(), 0, this);
    }

    void hangup(CdmaCall cdmaCall) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangup(com.android.internal.telephony.cdma.CdmaCall ), 0, this, cdmaCall);
    }

    void hangupWaitingOrBackground() {
        InvokeDynamicSupport.bootstrap("hangupWaitingOrBackground", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangupWaitingOrBackground(), 0, this);
    }

    void hangupForegroundResumeBackground() {
        InvokeDynamicSupport.bootstrap("hangupForegroundResumeBackground", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangupForegroundResumeBackground(), 0, this);
    }

    void hangupConnectionByIndex(CdmaCall cdmaCall, int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangupConnectionByIndex", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangupConnectionByIndex(com.android.internal.telephony.cdma.CdmaCall int ), 0, this, cdmaCall, n);
    }

    void hangupAllConnections(CdmaCall cdmaCall) {
        InvokeDynamicSupport.bootstrap("hangupAllConnections", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$hangupAllConnections(com.android.internal.telephony.cdma.CdmaCall ), 0, this, cdmaCall);
    }

    CdmaConnection getConnectionByIndex(CdmaCall cdmaCall, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("getConnectionByIndex", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$getConnectionByIndex(com.android.internal.telephony.cdma.CdmaCall int ), 0, this, cdmaCall, n);
    }

    private void flashAndSetGenericTrue() {
        InvokeDynamicSupport.bootstrap("flashAndSetGenericTrue", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$flashAndSetGenericTrue(), 0, this);
    }

    private void handleRadioNotAvailable() {
        InvokeDynamicSupport.bootstrap("handleRadioNotAvailable", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$handleRadioNotAvailable(), 0, this);
    }

    private void notifyCallWaitingInfo(CdmaCallWaitingNotification cdmaCallWaitingNotification) {
        InvokeDynamicSupport.bootstrap("notifyCallWaitingInfo", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$notifyCallWaitingInfo(com.android.internal.telephony.cdma.CdmaCallWaitingNotification ), 0, this, cdmaCallWaitingNotification);
    }

    private void handleCallWaitingInfo(CdmaCallWaitingNotification cdmaCallWaitingNotification) {
        InvokeDynamicSupport.bootstrap("handleCallWaitingInfo", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$handleCallWaitingInfo(com.android.internal.telephony.cdma.CdmaCallWaitingNotification ), 0, this, cdmaCallWaitingNotification);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$handleMessage(android.os.Message ), 0, this, message);
    }

    private void handleEcmTimer(int n) {
        InvokeDynamicSupport.bootstrap("handleEcmTimer", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$handleEcmTimer(int ), 0, this, n);
    }

    private void disableDataCallInEmergencyCall(String string2) {
        InvokeDynamicSupport.bootstrap("disableDataCallInEmergencyCall", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$disableDataCallInEmergencyCall(java.lang.String ), 0, this, string2);
    }

    private void checkAndEnableDataCallAfterEmergencyCallDropped() {
        InvokeDynamicSupport.bootstrap("checkAndEnableDataCallAfterEmergencyCallDropped", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$checkAndEnableDataCallAfterEmergencyCallDropped(), 0, this);
    }

    private Connection checkMtFindNewRinging(DriverCall driverCall, int n) {
        return InvokeDynamicSupport.bootstrap("checkMtFindNewRinging", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$checkMtFindNewRinging(com.android.internal.telephony.DriverCall int ), 0, this, driverCall, n);
    }

    boolean isInEmergencyCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEmergencyCall", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$isInEmergencyCall(), 0, this);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$log(java.lang.String ), 0, this, string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_cdma_CdmaCallTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ CdmaCallTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CdmaCallTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

