/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CdmaConnection
extends Connection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "CdmaConnection";
    private static boolean VDBG = false;
    CdmaCallTracker mOwner;
    CdmaCall mParent;
    String mPostDialString;
    boolean mDisconnected;
    int mIndex;
    long mDisconnectTime;
    int mNextPostDialChar;
    int mCause;
    Connection.PostDialState mPostDialState;
    int mPreciseCause;
    Handler mHandler;
    private PowerManager.WakeLock mPartialWakeLock;
    static int EVENT_DTMF_DONE = 1;
    static int EVENT_PAUSE_DONE = 2;
    static int EVENT_NEXT_POST_DIAL = 3;
    static int EVENT_WAKE_LOCK_TIMEOUT = 4;
    static int WAKE_LOCK_TIMEOUT_MILLIS = 60000;
    static int PAUSE_DELAY_MILLIS = 2000;

    private void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$__constructor__(Context context, DriverCall dc, CdmaCallTracker ct, int index) {
        this.mCause = 0;
        this.mPostDialState = Connection.PostDialState.NOT_STARTED;
        this.mPreciseCause = 0;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mAddress = dc.number;
        this.mIsIncoming = dc.isMT;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mCnapName = dc.name;
        this.mCnapNamePresentation = dc.namePresentation;
        this.mNumberPresentation = dc.numberPresentation;
        this.mIndex = index;
        this.mParent = this.parentFromDCState(dc.state);
        this.mParent.attach(this, dc);
    }

    private void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$__constructor__(Context context, String dialString, CdmaCallTracker ct, CdmaCall parent) {
        this.mCause = 0;
        this.mPostDialState = Connection.PostDialState.NOT_STARTED;
        this.mPreciseCause = 0;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mDialString = dialString;
        Rlog.d("CdmaConnection", "[CDMAConn] CdmaConnection: dialString=" + dialString);
        dialString = CdmaConnection.formatDialString(dialString);
        Rlog.d("CdmaConnection", "[CDMAConn] CdmaConnection:formated dialString=" + dialString);
        this.mAddress = PhoneNumberUtils.extractNetworkPortionAlt(dialString);
        this.mPostDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.mIndex = -1;
        this.mIsIncoming = false;
        this.mCnapName = null;
        this.mCnapNamePresentation = 1;
        this.mNumberPresentation = 1;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (parent != null) {
            this.mParent = parent;
            if (parent.mState == Call.State.ACTIVE) {
                parent.attachFake(this, Call.State.ACTIVE);
            } else {
                parent.attachFake(this, Call.State.DIALING);
            }
        }
    }

    private void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$__constructor__(Context context, CdmaCallWaitingNotification cw, CdmaCallTracker ct, CdmaCall parent) {
        this.mCause = 0;
        this.mPostDialState = Connection.PostDialState.NOT_STARTED;
        this.mPreciseCause = 0;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mAddress = cw.number;
        this.mNumberPresentation = cw.numberPresentation;
        this.mCnapName = cw.name;
        this.mCnapNamePresentation = cw.namePresentation;
        this.mIndex = -1;
        this.mIsIncoming = true;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mConnectTime = 0L;
        this.mParent = parent;
        parent.attachFake(this, Call.State.WAITING);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$dispose() {
    }

    private static final boolean $$robo$$com_android_internal_telephony_cdma_CdmaConnection$equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaConnection$compareTo(DriverCall c) {
        if (!this.mIsIncoming && !c.isMT) {
            return true;
        }
        String cAddress = PhoneNumberUtils.stringFromStringAndTOA(c.number, c.TOA);
        return this.mIsIncoming == c.isMT && CdmaConnection.equalsHandlesNulls(this.mAddress, cAddress);
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getOrigDialString() {
        return this.mDialString;
    }

    private final CdmaCall $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getCall() {
        return this.mParent;
    }

    private final long $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getDisconnectTime() {
        return this.mDisconnectTime;
    }

    private final long $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.mHoldingStartTime;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getDisconnectCause() {
        return this.mCause;
    }

    private final Call.State $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getState() {
        if (this.mDisconnected) {
            return Call.State.DISCONNECTED;
        }
        return super.getState();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$hangup() throws CallStateException {
        if (this.mDisconnected) {
            throw new CallStateException("disconnected");
        }
        this.mOwner.hangup(this);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$separate() throws CallStateException {
        if (this.mDisconnected) {
            throw new CallStateException("disconnected");
        }
        this.mOwner.separate(this);
    }

    private final Connection.PostDialState $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getPostDialState() {
        return this.mPostDialState;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$proceedAfterWaitChar() {
        if (this.mPostDialState != Connection.PostDialState.WAIT) {
            Rlog.w("CdmaConnection", "CdmaConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        this.processNextPostDialChar();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$proceedAfterWildChar(String str) {
        if (this.mPostDialState != Connection.PostDialState.WILD) {
            Rlog.w("CdmaConnection", "CdmaConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        StringBuilder buf = new StringBuilder(str);
        buf.append(this.mPostDialString.substring(this.mNextPostDialChar));
        this.mPostDialString = buf.toString();
        this.mNextPostDialChar = 0;
        this.log("proceedAfterWildChar: new postDialString is " + this.mPostDialString);
        this.processNextPostDialChar();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$cancelPostDial() {
        this.setPostDialState(Connection.PostDialState.CANCELLED);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onHangupLocal() {
        this.mCause = 3;
        this.mPreciseCause = 0;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CdmaConnection$disconnectCauseFromCode(int causeCode) {
        IccCardApplicationStatus.AppState uiccAppState;
        switch (causeCode) {
            case 17: {
                return 4;
            }
            case 34: {
                return 5;
            }
            case 68: {
                return 15;
            }
            case 240: {
                return 20;
            }
            case 241: {
                return 21;
            }
            case 1000: {
                return 26;
            }
            case 1001: {
                return 27;
            }
            case 1002: {
                return 28;
            }
            case 1003: {
                return 29;
            }
            case 1004: {
                return 30;
            }
            case 1005: {
                return 31;
            }
            case 1006: {
                return 32;
            }
            case 1007: {
                return 33;
            }
            case 1008: {
                return 34;
            }
            case 1009: {
                return 35;
            }
        }
        CDMAPhone phone = this.mOwner.mPhone;
        int serviceState = phone.getServiceState().getState();
        UiccCardApplication app = UiccController.getInstance().getUiccCardApplication(2);
        IccCardApplicationStatus.AppState appState = uiccAppState = app != null ? app.getState() : IccCardApplicationStatus.AppState.APPSTATE_UNKNOWN;
        if (serviceState == 3) {
            return 17;
        }
        if (serviceState == 1 || serviceState == 2) {
            return 18;
        }
        if (phone.mCdmaSubscriptionSource == 0 && uiccAppState != IccCardApplicationStatus.AppState.APPSTATE_READY) {
            return 19;
        }
        if (causeCode == 16) {
            return 2;
        }
        return 36;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onRemoteDisconnect(int causeCode) {
        this.mPreciseCause = causeCode;
        this.onDisconnect(this.disconnectCauseFromCode(causeCode));
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onDisconnect(int cause) {
        boolean changed = false;
        this.mCause = cause;
        if (!this.mDisconnected) {
            this.doDisconnect();
            this.mOwner.mPhone.notifyDisconnect(this);
            if (this.mParent != null) {
                changed = this.mParent.connectionDisconnected(this);
            }
        }
        this.releaseWakeLock();
        return changed;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onLocalDisconnect() {
        if (!this.mDisconnected) {
            this.doDisconnect();
            if (this.mParent != null) {
                this.mParent.detach(this);
            }
        }
        this.releaseWakeLock();
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaConnection$update(DriverCall dc) {
        boolean changed = false;
        boolean wasConnectingInOrOut = this.isConnectingInOrOut();
        boolean wasHolding = this.getState() == Call.State.HOLDING;
        CdmaCall newParent = this.parentFromDCState(dc.state);
        this.log("parent= " + this.mParent + ", newParent= " + newParent);
        this.log(" mNumberConverted " + this.mNumberConverted);
        if (!(CdmaConnection.equalsHandlesNulls(this.mAddress, dc.number) || this.mNumberConverted && CdmaConnection.equalsHandlesNulls(this.mConvertedNumber, dc.number))) {
            this.log("update: phone # changed!");
            this.mAddress = dc.number;
            changed = true;
        }
        if (TextUtils.isEmpty(dc.name)) {
            if (!TextUtils.isEmpty(this.mCnapName)) {
                changed = true;
                this.mCnapName = "";
            }
        } else if (!dc.name.equals(this.mCnapName)) {
            changed = true;
            this.mCnapName = dc.name;
        }
        this.log("--dssds----" + this.mCnapName);
        this.mCnapNamePresentation = dc.namePresentation;
        this.mNumberPresentation = dc.numberPresentation;
        if (newParent != this.mParent) {
            if (this.mParent != null) {
                this.mParent.detach(this);
            }
            newParent.attach(this, dc);
            this.mParent = newParent;
            changed = true;
        } else {
            boolean parentStateChange = this.mParent.update(this, dc);
            changed = changed || parentStateChange;
        }
        this.log("Update, wasConnectingInOrOut=" + wasConnectingInOrOut + ", wasHolding=" + wasHolding + ", isConnectingInOrOut=" + this.isConnectingInOrOut() + ", changed=" + changed);
        if (wasConnectingInOrOut && !this.isConnectingInOrOut()) {
            this.onConnectedInOrOut();
        }
        if (changed && !wasHolding && this.getState() == Call.State.HOLDING) {
            this.onStartedHolding();
        }
        return changed;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$fakeHoldBeforeDial() {
        if (this.mParent != null) {
            this.mParent.detach(this);
        }
        this.mParent = this.mOwner.mBackgroundCall;
        this.mParent.attachFake(this, Call.State.HOLDING);
        this.onStartedHolding();
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getCDMAIndex() throws CallStateException {
        if (this.mIndex >= 0) {
            return this.mIndex + 1;
        }
        throw new CallStateException("CDMA connection index not assigned");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onConnectedInOrOut() {
        this.mConnectTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mConnectTimeReal = SystemClock.elapsedRealtime();
        this.mDuration = 0L;
        this.log("onConnectedInOrOut: connectTime=" + this.mConnectTime);
        if (!this.mIsIncoming) {
            this.processNextPostDialChar();
        } else {
            this.releaseWakeLock();
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$doDisconnect() {
        this.mIndex = -1;
        this.mDisconnectTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mDuration = SystemClock.elapsedRealtime() - this.mConnectTimeReal;
        this.mDisconnected = true;
        this.clearPostDialListeners();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onStartedHolding() {
        this.mHoldingStartTime = SystemClock.elapsedRealtime();
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaConnection$processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            this.mOwner.mCi.sendDtmf(c, this.mHandler.obtainMessage(1));
        } else if (c == ',') {
            this.setPostDialState(Connection.PostDialState.PAUSE);
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 2000L);
        } else if (c == ';') {
            this.setPostDialState(Connection.PostDialState.WAIT);
        } else if (c == 'N') {
            this.setPostDialState(Connection.PostDialState.WILD);
        } else {
            return false;
        }
        return true;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getRemainingPostDialString() {
        if (this.mPostDialState == Connection.PostDialState.CANCELLED || this.mPostDialState == Connection.PostDialState.COMPLETE || this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            return "";
        }
        String subStr = this.mPostDialString.substring(this.mNextPostDialChar);
        if (subStr != null) {
            int wIndex = subStr.indexOf(59);
            int pIndex = subStr.indexOf(44);
            if (wIndex > 0 && (wIndex < pIndex || pIndex <= 0)) {
                subStr = subStr.substring(0, wIndex);
            } else if (pIndex > 0) {
                subStr = subStr.substring(0, pIndex);
            }
        }
        return subStr;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$updateParent(CdmaCall oldParent, CdmaCall newParent) {
        if (newParent != oldParent) {
            if (oldParent != null) {
                oldParent.detach(this);
            }
            newParent.attachFake(this, Call.State.ACTIVE);
            this.mParent = newParent;
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$finalize() {
        if (this.mPartialWakeLock.isHeld()) {
            Rlog.e("CdmaConnection", "[CdmaConn] UNEXPECTED; mPartialWakeLock is held when finalizing.");
        }
        this.releaseWakeLock();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$processNextPostDialChar() {
        Message notifyMessage;
        char c = '\u0000';
        if (this.mPostDialState == Connection.PostDialState.CANCELLED) {
            this.releaseWakeLock();
            return;
        }
        if (this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            this.setPostDialState(Connection.PostDialState.COMPLETE);
            this.releaseWakeLock();
            c = '\u0000';
        } else {
            this.setPostDialState(Connection.PostDialState.STARTED);
            c = this.mPostDialString.charAt(this.mNextPostDialChar++);
            boolean isValid = this.processPostDialChar(c);
            if (!isValid) {
                this.mHandler.obtainMessage(3).sendToTarget();
                Rlog.e("CDMA", "processNextPostDialChar: c=" + c + " isn't valid!");
                return;
            }
        }
        Registrant postDialHandler = this.mOwner.mPhone.mPostDialHandler;
        if (postDialHandler != null && (notifyMessage = postDialHandler.messageForRegistrant()) != null) {
            Connection.PostDialState state = this.mPostDialState;
            AsyncResult ar = AsyncResult.forMessage(notifyMessage);
            ar.result = this;
            ar.userObj = state;
            notifyMessage.arg1 = c;
            notifyMessage.sendToTarget();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaConnection$isConnectingInOrOut() {
        return this.mParent == null || this.mParent == this.mOwner.mRingingCall || this.mParent.mState == Call.State.DIALING || this.mParent.mState == Call.State.ALERTING;
    }

    private final CdmaCall $$robo$$com_android_internal_telephony_cdma_CdmaConnection$parentFromDCState(DriverCall.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$DriverCall$State[state.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return this.mOwner.mForegroundCall;
            }
            case 4: {
                return this.mOwner.mBackgroundCall;
            }
            case 5: 
            case 6: {
                return this.mOwner.mRingingCall;
            }
        }
        throw new RuntimeException("illegal call state: " + (Object)((Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$setPostDialState(Connection.PostDialState s) {
        if (s == Connection.PostDialState.STARTED || s == Connection.PostDialState.PAUSE) {
            PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
            synchronized (wakeLock) {
                if (this.mPartialWakeLock.isHeld()) {
                    this.mHandler.removeMessages(4);
                } else {
                    this.acquireWakeLock();
                }
                Message msg = this.mHandler.obtainMessage(4);
                this.mHandler.sendMessageDelayed(msg, 60000L);
            }
        } else {
            this.mHandler.removeMessages(4);
            this.releaseWakeLock();
        }
        this.mPostDialState = s;
        this.notifyPostDialListeners();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$createWakeLock(Context context) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mPartialWakeLock = pm.newWakeLock(1, "CdmaConnection");
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$acquireWakeLock() {
        this.log("acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$releaseWakeLock() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            if (this.mPartialWakeLock.isHeld()) {
                this.log("releaseWakeLock");
                this.mPartialWakeLock.release();
            }
        }
    }

    private static final boolean $$robo$$com_android_internal_telephony_cdma_CdmaConnection$isPause(char c) {
        return c == ',';
    }

    private static final boolean $$robo$$com_android_internal_telephony_cdma_CdmaConnection$isWait(char c) {
        return c == ';';
    }

    private static final int $$robo$$com_android_internal_telephony_cdma_CdmaConnection$findNextPCharOrNonPOrNonWCharIndex(String phoneNumber, int currIndex) {
        int index;
        boolean wMatched = CdmaConnection.isWait(phoneNumber.charAt(currIndex));
        int length = phoneNumber.length();
        for (index = currIndex + 1; index < length; ++index) {
            char cNext = phoneNumber.charAt(index);
            if (CdmaConnection.isWait(cNext)) {
                wMatched = true;
            }
            if (!CdmaConnection.isWait(cNext) && !CdmaConnection.isPause(cNext)) break;
        }
        if (index < length && index > currIndex + 1 && !wMatched && CdmaConnection.isPause(phoneNumber.charAt(currIndex))) {
            return currIndex + 1;
        }
        return index;
    }

    private static final char $$robo$$com_android_internal_telephony_cdma_CdmaConnection$findPOrWCharToAppend(String phoneNumber, int currPwIndex, int nextNonPwCharIndex) {
        char ret;
        char c = phoneNumber.charAt(currPwIndex);
        char c2 = ret = CdmaConnection.isPause(c) ? (char)',' : ';';
        if (nextNonPwCharIndex > currPwIndex + 1) {
            ret = ';';
        }
        return ret;
    }

    private static final String $$robo$$com_android_internal_telephony_cdma_CdmaConnection$formatDialString(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int length = phoneNumber.length();
        StringBuilder ret = new StringBuilder();
        for (int currIndex = 0; currIndex < length; ++currIndex) {
            char c = phoneNumber.charAt(currIndex);
            if (CdmaConnection.isPause(c) || CdmaConnection.isWait(c)) {
                if (currIndex >= length - 1) continue;
                int nextIndex = CdmaConnection.findNextPCharOrNonPOrNonWCharIndex(phoneNumber, currIndex);
                if (nextIndex < length) {
                    char pC = CdmaConnection.findPOrWCharToAppend(phoneNumber, currIndex, nextIndex);
                    ret.append(pC);
                    if (nextIndex <= currIndex + 1) continue;
                    currIndex = nextIndex - 1;
                    continue;
                }
                if (nextIndex != length) continue;
                currIndex = length - 1;
                continue;
            }
            ret.append(c);
        }
        return PhoneNumberUtils.cdmaCheckAndProcessPlusCode(ret.toString());
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection$log(String msg) {
        Rlog.d("CdmaConnection", "[CDMAConn] " + msg);
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getNumberPresentation() {
        return this.mNumberPresentation;
    }

    private final UUSInfo $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getUUSInfo() {
        return null;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getPreciseDisconnectCause() {
        return this.mPreciseCause;
    }

    private final Connection $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getOrigConnection() {
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaConnection$isMultiparty() {
        return false;
    }

    private void __constructor__(Context context, DriverCall driverCall, CdmaCallTracker cdmaCallTracker, int n) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaConnection$__constructor__(context, driverCall, cdmaCallTracker, n);
    }

    CdmaConnection(Context context, DriverCall driverCall, CdmaCallTracker cdmaCallTracker, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$__constructor__(android.content.Context com.android.internal.telephony.DriverCall com.android.internal.telephony.cdma.CdmaCallTracker int ), 0, this, context, driverCall, cdmaCallTracker, n);
    }

    private void __constructor__(Context context, String string2, CdmaCallTracker cdmaCallTracker, CdmaCall cdmaCall) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaConnection$__constructor__(context, string2, cdmaCallTracker, cdmaCall);
    }

    CdmaConnection(Context context, String string2, CdmaCallTracker cdmaCallTracker, CdmaCall cdmaCall) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$__constructor__(android.content.Context java.lang.String com.android.internal.telephony.cdma.CdmaCallTracker com.android.internal.telephony.cdma.CdmaCall ), 0, this, context, string2, cdmaCallTracker, cdmaCall);
    }

    private void __constructor__(Context context, CdmaCallWaitingNotification cdmaCallWaitingNotification, CdmaCallTracker cdmaCallTracker, CdmaCall cdmaCall) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaConnection$__constructor__(context, cdmaCallWaitingNotification, cdmaCallTracker, cdmaCall);
    }

    CdmaConnection(Context context, CdmaCallWaitingNotification cdmaCallWaitingNotification, CdmaCallTracker cdmaCallTracker, CdmaCall cdmaCall) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$__constructor__(android.content.Context com.android.internal.telephony.cdma.CdmaCallWaitingNotification com.android.internal.telephony.cdma.CdmaCallTracker com.android.internal.telephony.cdma.CdmaCall ), 0, this, context, cdmaCallWaitingNotification, cdmaCallTracker, cdmaCall);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$dispose(), 0, this);
    }

    static boolean equalsHandlesNulls(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equalsHandlesNulls", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$equalsHandlesNulls(java.lang.Object java.lang.Object ), 0, (Object)object, (Object)object2);
    }

    boolean compareTo(DriverCall driverCall) {
        return (boolean)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$compareTo(com.android.internal.telephony.DriverCall ), 0, this, driverCall);
    }

    @Override
    public String getOrigDialString() {
        return InvokeDynamicSupport.bootstrap("getOrigDialString", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getOrigDialString(), 0, this);
    }

    @Override
    public CdmaCall getCall() {
        return InvokeDynamicSupport.bootstrap("getCall", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getCall(), 0, this);
    }

    @Override
    public long getDisconnectTime() {
        return (long)InvokeDynamicSupport.bootstrap("getDisconnectTime", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getDisconnectTime(), 0, this);
    }

    @Override
    public long getHoldDurationMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getHoldDurationMillis", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getHoldDurationMillis(), 0, this);
    }

    @Override
    public int getDisconnectCause() {
        return (int)InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getDisconnectCause(), 0, this);
    }

    @Override
    public Call.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getState(), 0, this);
    }

    @Override
    public void hangup() throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$hangup(), 0, this);
    }

    @Override
    public void separate() throws CallStateException {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$separate(), 0, this);
    }

    @Override
    public Connection.PostDialState getPostDialState() {
        return InvokeDynamicSupport.bootstrap("getPostDialState", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getPostDialState(), 0, this);
    }

    @Override
    public void proceedAfterWaitChar() {
        InvokeDynamicSupport.bootstrap("proceedAfterWaitChar", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$proceedAfterWaitChar(), 0, this);
    }

    @Override
    public void proceedAfterWildChar(String string2) {
        InvokeDynamicSupport.bootstrap("proceedAfterWildChar", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$proceedAfterWildChar(java.lang.String ), 0, this, string2);
    }

    @Override
    public void cancelPostDial() {
        InvokeDynamicSupport.bootstrap("cancelPostDial", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$cancelPostDial(), 0, this);
    }

    void onHangupLocal() {
        InvokeDynamicSupport.bootstrap("onHangupLocal", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onHangupLocal(), 0, this);
    }

    int disconnectCauseFromCode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("disconnectCauseFromCode", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$disconnectCauseFromCode(int ), 0, this, n);
    }

    void onRemoteDisconnect(int n) {
        InvokeDynamicSupport.bootstrap("onRemoteDisconnect", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onRemoteDisconnect(int ), 0, this, n);
    }

    boolean onDisconnect(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onDisconnect(int ), 0, this, n);
    }

    void onLocalDisconnect() {
        InvokeDynamicSupport.bootstrap("onLocalDisconnect", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onLocalDisconnect(), 0, this);
    }

    boolean update(DriverCall driverCall) {
        return (boolean)InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$update(com.android.internal.telephony.DriverCall ), 0, this, driverCall);
    }

    void fakeHoldBeforeDial() {
        InvokeDynamicSupport.bootstrap("fakeHoldBeforeDial", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$fakeHoldBeforeDial(), 0, this);
    }

    int getCDMAIndex() throws CallStateException {
        return (int)InvokeDynamicSupport.bootstrap("getCDMAIndex", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getCDMAIndex(), 0, this);
    }

    void onConnectedInOrOut() {
        InvokeDynamicSupport.bootstrap("onConnectedInOrOut", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onConnectedInOrOut(), 0, this);
    }

    private void doDisconnect() {
        InvokeDynamicSupport.bootstrap("doDisconnect", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$doDisconnect(), 0, this);
    }

    void onStartedHolding() {
        InvokeDynamicSupport.bootstrap("onStartedHolding", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$onStartedHolding(), 0, this);
    }

    private boolean processPostDialChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("processPostDialChar", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$processPostDialChar(char ), 0, this, c);
    }

    @Override
    public String getRemainingPostDialString() {
        return InvokeDynamicSupport.bootstrap("getRemainingPostDialString", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getRemainingPostDialString(), 0, this);
    }

    public void updateParent(CdmaCall cdmaCall, CdmaCall cdmaCall2) {
        InvokeDynamicSupport.bootstrap("updateParent", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$updateParent(com.android.internal.telephony.cdma.CdmaCall com.android.internal.telephony.cdma.CdmaCall ), 0, this, cdmaCall, cdmaCall2);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$finalize(), 0, this);
    }

    void processNextPostDialChar() {
        InvokeDynamicSupport.bootstrap("processNextPostDialChar", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$processNextPostDialChar(), 0, this);
    }

    private boolean isConnectingInOrOut() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectingInOrOut", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$isConnectingInOrOut(), 0, this);
    }

    private CdmaCall parentFromDCState(DriverCall.State state) {
        return InvokeDynamicSupport.bootstrap("parentFromDCState", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$parentFromDCState(com.android.internal.telephony.DriverCall$State ), 0, this, state);
    }

    private void setPostDialState(Connection.PostDialState postDialState) {
        InvokeDynamicSupport.bootstrap("setPostDialState", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$setPostDialState(com.android.internal.telephony.Connection$PostDialState ), 0, this, postDialState);
    }

    private void createWakeLock(Context context) {
        InvokeDynamicSupport.bootstrap("createWakeLock", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$createWakeLock(android.content.Context ), 0, this, context);
    }

    private void acquireWakeLock() {
        InvokeDynamicSupport.bootstrap("acquireWakeLock", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$acquireWakeLock(), 0, this);
    }

    private void releaseWakeLock() {
        InvokeDynamicSupport.bootstrap("releaseWakeLock", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$releaseWakeLock(), 0, this);
    }

    private static boolean isPause(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPause", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$isPause(char ), 0, (char)c);
    }

    private static boolean isWait(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWait", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$isWait(char ), 0, (char)c);
    }

    private static int findNextPCharOrNonPOrNonWCharIndex(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findNextPCharOrNonPOrNonWCharIndex", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$findNextPCharOrNonPOrNonWCharIndex(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static char findPOrWCharToAppend(String string2, int n, int n2) {
        return (char)InvokeDynamicSupport.bootstrapStatic("findPOrWCharToAppend", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$findPOrWCharToAppend(java.lang.String int int ), 0, (String)string2, (int)n, (int)n2);
    }

    public static String formatDialString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("formatDialString", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$formatDialString(java.lang.String ), 0, (String)string2);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$log(java.lang.String ), 0, this, string2);
    }

    @Override
    public int getNumberPresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberPresentation", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getNumberPresentation(), 0, this);
    }

    @Override
    public UUSInfo getUUSInfo() {
        return InvokeDynamicSupport.bootstrap("getUUSInfo", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getUUSInfo(), 0, this);
    }

    @Override
    public int getPreciseDisconnectCause() {
        return (int)InvokeDynamicSupport.bootstrap("getPreciseDisconnectCause", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getPreciseDisconnectCause(), 0, this);
    }

    @Override
    public Connection getOrigConnection() {
        return InvokeDynamicSupport.bootstrap("getOrigConnection", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$getOrigConnection(), 0, this);
    }

    @Override
    public boolean isMultiparty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiparty", $$robo$$com_android_internal_telephony_cdma_CdmaConnection$isMultiparty(), 0, this);
    }

    public /* synthetic */ CdmaConnection() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CdmaConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$DriverCall$State;

        static void __staticInitializer__() {
            $SwitchMap$com$android$internal$telephony$DriverCall$State = new int[DriverCall.State.values().length];
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.ACTIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.DIALING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.ALERTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.HOLDING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.INCOMING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.WAITING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CdmaConnection this$0;

        private void $$robo$$com_android_internal_telephony_cdma_CdmaConnection_MyHandler$__constructor__(CdmaConnection cdmaConnection, Looper l) {
        }

        private final void $$robo$$com_android_internal_telephony_cdma_CdmaConnection_MyHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: 
                case 3: {
                    this.this$0.processNextPostDialChar();
                    break;
                }
                case 4: {
                    this.this$0.releaseWakeLock();
                }
            }
        }

        private void __constructor__(CdmaConnection cdmaConnection, Looper looper) {
            this.$$robo$$com_android_internal_telephony_cdma_CdmaConnection_MyHandler$__constructor__(cdmaConnection, looper);
        }

        MyHandler(CdmaConnection cdmaConnection, Looper looper) {
            this.this$0 = cdmaConnection;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaConnection_MyHandler$__constructor__(com.android.internal.telephony.cdma.CdmaConnection android.os.Looper ), 0, this, cdmaConnection, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_cdma_CdmaConnection_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

