/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Message;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telephony.SmsCbMessage;
import com.android.internal.telephony.CellBroadcastHandler;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SmsConstants;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.WspTypeDecoder;
import com.android.internal.telephony.cdma.CdmaSMSDispatcher;
import com.android.internal.telephony.cdma.CdmaServiceCategoryProgramHandler;
import com.android.internal.telephony.cdma.SmsMessage;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CdmaInboundSmsHandler
extends InboundSmsHandler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private CdmaSMSDispatcher mSmsDispatcher;
    private CdmaServiceCategoryProgramHandler mServiceCategoryProgramHandler;
    private byte[] mLastDispatchedSmsFingerprint;
    private byte[] mLastAcknowledgedSmsFingerprint;
    private boolean mCheckForDuplicatePortsInOmadmWapPush;

    private void $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$__constructor__(Context context, SmsStorageMonitor storageMonitor, PhoneBase phone, CdmaSMSDispatcher smsDispatcher) {
        this.mCheckForDuplicatePortsInOmadmWapPush = Resources.getSystem().getBoolean(17956942);
        this.mSmsDispatcher = smsDispatcher;
        this.mServiceCategoryProgramHandler = CdmaServiceCategoryProgramHandler.makeScpHandler(context, phone.mCi);
        phone.mCi.setOnNewCdmaSms(this.getHandler(), 1, null);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$onQuitting() {
        this.mPhone.mCi.unSetOnNewCdmaSms(this.getHandler());
        this.mCellBroadcastHandler.dispose();
        this.log("unregistered for 3GPP2 SMS");
        super.onQuitting();
    }

    private static final CdmaInboundSmsHandler $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$makeInboundSmsHandler(Context context, SmsStorageMonitor storageMonitor, PhoneBase phone, CdmaSMSDispatcher smsDispatcher) {
        CdmaInboundSmsHandler handler = new CdmaInboundSmsHandler(context, storageMonitor, phone, smsDispatcher);
        handler.start();
        return handler;
    }

    private static final boolean $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$isInEmergencyCallMode() {
        String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
        return "true".equals(inEcm);
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$is3gpp2() {
        return true;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$dispatchMessageRadioSpecific(SmsMessageBase smsb) {
        boolean isBroadcastType;
        if (CdmaInboundSmsHandler.isInEmergencyCallMode()) {
            return -1;
        }
        SmsMessage sms = (SmsMessage)smsb;
        boolean bl = isBroadcastType = 1 == sms.getMessageType();
        if (isBroadcastType) {
            this.log("Broadcast type message");
            SmsCbMessage cbMessage = sms.parseBroadcastSms();
            if (cbMessage != null) {
                this.mCellBroadcastHandler.dispatchSmsMessage(cbMessage);
            } else {
                this.loge("error trying to parse broadcast SMS");
            }
            return 1;
        }
        this.mLastDispatchedSmsFingerprint = sms.getIncomingSmsFingerprint();
        if (this.mLastAcknowledgedSmsFingerprint != null && Arrays.equals(this.mLastDispatchedSmsFingerprint, this.mLastAcknowledgedSmsFingerprint)) {
            return 1;
        }
        sms.parseSms();
        int teleService = sms.getTeleService();
        switch (teleService) {
            case 4099: 
            case 262144: {
                this.handleVoicemailTeleservice(sms);
                return 1;
            }
            case 4098: 
            case 4101: {
                if (!sms.isStatusReportMessage()) break;
                this.mSmsDispatcher.sendStatusReportMessage(sms);
                return 1;
            }
            case 4102: {
                this.mServiceCategoryProgramHandler.dispatchSmsMessage(sms);
                return 1;
            }
            case 4100: {
                break;
            }
            default: {
                this.loge("unsupported teleservice 0x" + Integer.toHexString(teleService));
                return 4;
            }
        }
        if (!this.mStorageMonitor.isStorageAvailable() && sms.getMessageClass() != SmsConstants.MessageClass.CLASS_0) {
            return 3;
        }
        if (4100 == teleService) {
            return this.processCdmaWapPdu(sms.getUserData(), sms.mMessageRef, sms.getOriginatingAddress(), sms.getTimestampMillis());
        }
        return this.dispatchNormalMessage(smsb);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$acknowledgeLastIncomingSms(boolean success, int result, Message response) {
        if (CdmaInboundSmsHandler.isInEmergencyCallMode()) {
            return;
        }
        int causeCode = CdmaInboundSmsHandler.resultToCause(result);
        this.mPhone.mCi.acknowledgeLastIncomingCdmaSms(success, causeCode, response);
        if (causeCode == 0) {
            this.mLastAcknowledgedSmsFingerprint = this.mLastDispatchedSmsFingerprint;
        }
        this.mLastDispatchedSmsFingerprint = null;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$onUpdatePhoneObject(PhoneBase phone) {
        super.onUpdatePhoneObject(phone);
        this.mCellBroadcastHandler.updatePhoneObject(phone);
    }

    private static final int $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$resultToCause(int rc) {
        switch (rc) {
            case -1: 
            case 1: {
                return 0;
            }
            case 3: {
                return 35;
            }
            case 4: {
                return 4;
            }
        }
        return 96;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$handleVoicemailTeleservice(SmsMessage sms) {
        int voicemailCount = sms.getNumOfVoicemails();
        this.log("Voicemail count=" + voicemailCount);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("vm_count_key_cdma" + this.mPhone.getPhoneId(), voicemailCount);
        editor.apply();
        this.mPhone.setVoiceMessageWaiting(1, voicemailCount);
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$processCdmaWapPdu(byte[] pdu, int referenceNumber, String address, long timestamp) {
        int totalSegments;
        int segment;
        int msgType;
        int index = 0;
        if ((msgType = 0xFF & pdu[index++]) != 0) {
            this.log("Received a WAP SMS which is not WDP. Discard.");
            return 1;
        }
        if ((segment = 0xFF & pdu[index++]) >= (totalSegments = 0xFF & pdu[index++])) {
            this.loge("WDP bad segment #" + segment + " expecting 0-" + (totalSegments - 1));
            return 1;
        }
        int sourcePort = 0;
        int destinationPort = 0;
        if (segment == 0) {
            sourcePort = (0xFF & pdu[index++]) << 8;
            sourcePort |= 0xFF & pdu[index++];
            destinationPort = (0xFF & pdu[index++]) << 8;
            destinationPort |= 0xFF & pdu[index++];
            if (this.mCheckForDuplicatePortsInOmadmWapPush && CdmaInboundSmsHandler.checkDuplicatePortOmadmWapPush(pdu, index)) {
                index += 4;
            }
        }
        this.log("Received WAP PDU. Type = " + msgType + ", originator = " + address + ", src-port = " + sourcePort + ", dst-port = " + destinationPort + ", ID = " + referenceNumber + ", segment# = " + segment + '/' + totalSegments);
        byte[] userData = new byte[pdu.length - index];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])pdu, (int)index, (byte[])userData, (int)0, (int)(pdu.length - index));
        InboundSmsTracker tracker = new InboundSmsTracker(userData, timestamp, destinationPort, true, address, referenceNumber, segment, totalSegments, true);
        return this.addTrackerToRawTableAndSendMessage(tracker);
    }

    private static final boolean $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$checkDuplicatePortOmadmWapPush(byte[] origPdu, int index) {
        byte[] omaPdu = new byte[origPdu.length - (index += 4)];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])origPdu, (int)index, (byte[])omaPdu, (int)0, (int)omaPdu.length);
        WspTypeDecoder pduDecoder = new WspTypeDecoder(omaPdu);
        int wspIndex = 2;
        if (!pduDecoder.decodeUintvarInteger(wspIndex)) {
            return false;
        }
        if (!pduDecoder.decodeContentType(wspIndex += pduDecoder.getDecodedDataLength())) {
            return false;
        }
        String mimeType = pduDecoder.getValueString();
        return "application/vnd.syncml.notification".equals(mimeType);
    }

    private void __constructor__(Context context, SmsStorageMonitor smsStorageMonitor, PhoneBase phoneBase, CdmaSMSDispatcher cdmaSMSDispatcher) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$__constructor__(context, smsStorageMonitor, phoneBase, cdmaSMSDispatcher);
    }

    private CdmaInboundSmsHandler(Context context, SmsStorageMonitor smsStorageMonitor, PhoneBase phoneBase, CdmaSMSDispatcher cdmaSMSDispatcher) {
        super("CdmaInboundSmsHandler", context, smsStorageMonitor, phoneBase, CellBroadcastHandler.makeCellBroadcastHandler(context, phoneBase));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$__constructor__(android.content.Context com.android.internal.telephony.SmsStorageMonitor com.android.internal.telephony.PhoneBase com.android.internal.telephony.cdma.CdmaSMSDispatcher ), 0, this, context, smsStorageMonitor, phoneBase, cdmaSMSDispatcher);
    }

    @Override
    protected void onQuitting() {
        InvokeDynamicSupport.bootstrap("onQuitting", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$onQuitting(), 0, this);
    }

    public static CdmaInboundSmsHandler makeInboundSmsHandler(Context context, SmsStorageMonitor smsStorageMonitor, PhoneBase phoneBase, CdmaSMSDispatcher cdmaSMSDispatcher) {
        return InvokeDynamicSupport.bootstrapStatic("makeInboundSmsHandler", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$makeInboundSmsHandler(android.content.Context com.android.internal.telephony.SmsStorageMonitor com.android.internal.telephony.PhoneBase com.android.internal.telephony.cdma.CdmaSMSDispatcher ), 0, (Context)context, (SmsStorageMonitor)smsStorageMonitor, (PhoneBase)phoneBase, (CdmaSMSDispatcher)cdmaSMSDispatcher);
    }

    private static boolean isInEmergencyCallMode() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInEmergencyCallMode", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$isInEmergencyCallMode(), 0);
    }

    @Override
    protected boolean is3gpp2() {
        return (boolean)InvokeDynamicSupport.bootstrap("is3gpp2", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$is3gpp2(), 0, this);
    }

    @Override
    protected int dispatchMessageRadioSpecific(SmsMessageBase smsMessageBase) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchMessageRadioSpecific", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$dispatchMessageRadioSpecific(com.android.internal.telephony.SmsMessageBase ), 0, this, smsMessageBase);
    }

    @Override
    protected void acknowledgeLastIncomingSms(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeLastIncomingSms", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$acknowledgeLastIncomingSms(boolean int android.os.Message ), 0, this, bl, n, message);
    }

    @Override
    protected void onUpdatePhoneObject(PhoneBase phoneBase) {
        InvokeDynamicSupport.bootstrap("onUpdatePhoneObject", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$onUpdatePhoneObject(com.android.internal.telephony.PhoneBase ), 0, this, phoneBase);
    }

    private static int resultToCause(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resultToCause", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$resultToCause(int ), 0, (int)n);
    }

    private void handleVoicemailTeleservice(SmsMessage smsMessage) {
        InvokeDynamicSupport.bootstrap("handleVoicemailTeleservice", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$handleVoicemailTeleservice(com.android.internal.telephony.cdma.SmsMessage ), 0, this, smsMessage);
    }

    private int processCdmaWapPdu(byte[] byArray, int n, String string2, long l) {
        return (int)InvokeDynamicSupport.bootstrap("processCdmaWapPdu", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$processCdmaWapPdu(byte[] int java.lang.String long ), 0, this, byArray, n, string2, l);
    }

    private static boolean checkDuplicatePortOmadmWapPush(byte[] byArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkDuplicatePortOmadmWapPush", $$robo$$com_android_internal_telephony_cdma_CdmaInboundSmsHandler$checkDuplicatePortOmadmWapPush(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    public /* synthetic */ CdmaInboundSmsHandler() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CdmaInboundSmsHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

