/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.telephony.CellIdentityLte;
import android.telephony.CellInfo;
import android.telephony.CellInfoLte;
import android.telephony.CellSignalStrengthLte;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.ProxyController;
import com.android.internal.telephony.cdma.CDMALTEPhone;
import com.android.internal.telephony.cdma.CdmaServiceStateTracker;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.RuimRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CdmaLteServiceStateTracker
extends CdmaServiceStateTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private CDMALTEPhone mCdmaLtePhone;
    private CellInfoLte mCellInfoLte;
    private static int EVENT_ALL_DATA_DISCONNECTED = 1001;
    private CellIdentityLte mNewCellIdentityLte;
    private CellIdentityLte mLasteCellIdentityLte;

    private void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$__constructor__(CDMALTEPhone phone) {
        this.mNewCellIdentityLte = new CellIdentityLte();
        this.mLasteCellIdentityLte = new CellIdentityLte();
        this.mCdmaLtePhone = phone;
        this.mCellInfoLte = (CellInfoLte)this.mCellInfo;
        ((CellInfoLte)this.mCellInfo).setCellSignalStrength(new CellSignalStrengthLte());
        ((CellInfoLte)this.mCellInfo).setCellIdentity(new CellIdentityLte());
        this.log("CdmaLteServiceStateTracker Constructors");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$handleMessage(Message msg) {
        if (!this.mPhone.mIsTheCurrentActivePhone) {
            this.loge("Received message " + msg + "[" + msg.what + "]" + " while being destroyed. Ignoring.");
            return;
        }
        this.log("handleMessage: " + msg.what);
        switch (msg.what) {
            case 5: {
                this.log("handleMessage EVENT_POLL_STATE_GPRS");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handlePollStateResult(msg.what, ar);
                break;
            }
            case 27: {
                this.updatePhoneObject();
                RuimRecords ruim = (RuimRecords)this.mIccRecords;
                if (ruim != null) {
                    if (ruim.isProvisioned()) {
                        this.mMdn = ruim.getMdn();
                        this.mMin = ruim.getMin();
                        this.parseSidNid(ruim.getSid(), ruim.getNid());
                        this.mPrlVersion = ruim.getPrlVersion();
                        this.mIsMinInfoReady = true;
                    }
                    this.updateOtaspState();
                }
                this.mPhone.prepareEri();
                this.pollState();
                break;
            }
            case 1001: {
                long dds = SubscriptionManager.getDefaultDataSubId();
                ProxyController.getInstance().unregisterForAllDataDisconnected(dds, this);
                CdmaLteServiceStateTracker cdmaLteServiceStateTracker = this;
                synchronized (cdmaLteServiceStateTracker) {
                    if (this.mPendingRadioPowerOffAfterDataOff) {
                        this.log("EVENT_ALL_DATA_DISCONNECTED, turn radio off now.");
                        this.hangupAndPowerOff();
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    } else {
                        this.log("EVENT_ALL_DATA_DISCONNECTED is stale");
                    }
                    break;
                }
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$handlePollStateResultMessage(int what, AsyncResult ar) {
        if (what == 5) {
            String[] states = (String[])ar.result;
            this.log("handlePollStateResultMessage: EVENT_POLL_STATE_GPRS states.length=" + states.length + " states=" + states);
            int type = 0;
            int regState = -1;
            if (states.length > 0) {
                try {
                    regState = Integer.parseInt(states[0]);
                    if (states.length >= 4 && states[3] != null) {
                        type = Integer.parseInt(states[3]);
                    }
                }
                catch (NumberFormatException ex) {
                    this.loge("handlePollStateResultMessage: error parsing GprsRegistrationState: " + ex);
                }
                if (states.length >= 10) {
                    int eci;
                    int pci;
                    int tac;
                    int mnc;
                    int mcc;
                    String operatorNumeric = null;
                    try {
                        operatorNumeric = this.mNewSS.getOperatorNumeric();
                        mcc = Integer.parseInt(operatorNumeric.substring(0, 3));
                    }
                    catch (Exception e) {
                        try {
                            operatorNumeric = this.mSS.getOperatorNumeric();
                            mcc = Integer.parseInt(operatorNumeric.substring(0, 3));
                        }
                        catch (Exception ex) {
                            this.loge("handlePollStateResultMessage: bad mcc operatorNumeric=" + operatorNumeric + " ex=" + ex);
                            operatorNumeric = "";
                            mcc = Integer.MAX_VALUE;
                        }
                    }
                    try {
                        mnc = Integer.parseInt(operatorNumeric.substring(3));
                    }
                    catch (Exception e) {
                        this.loge("handlePollStateResultMessage: bad mnc operatorNumeric=" + operatorNumeric + " e=" + e);
                        mnc = Integer.MAX_VALUE;
                    }
                    try {
                        tac = Integer.decode(states[6]);
                    }
                    catch (Exception e) {
                        this.loge("handlePollStateResultMessage: bad tac states[6]=" + states[6] + " e=" + e);
                        tac = Integer.MAX_VALUE;
                    }
                    try {
                        pci = Integer.decode(states[7]);
                    }
                    catch (Exception e) {
                        this.loge("handlePollStateResultMessage: bad pci states[7]=" + states[7] + " e=" + e);
                        pci = Integer.MAX_VALUE;
                    }
                    try {
                        eci = Integer.decode(states[8]);
                    }
                    catch (Exception e) {
                        this.loge("handlePollStateResultMessage: bad eci states[8]=" + states[8] + " e=" + e);
                        eci = Integer.MAX_VALUE;
                    }
                    try {
                        int csgid = Integer.decode(states[9]);
                    }
                    catch (Exception e) {
                        int csgid = Integer.MAX_VALUE;
                    }
                    this.mNewCellIdentityLte = new CellIdentityLte(mcc, mnc, eci, pci, tac);
                    this.log("handlePollStateResultMessage: mNewLteCellIdentity=" + this.mNewCellIdentityLte);
                }
            }
            this.mNewSS.setRilDataRadioTechnology(type);
            int dataRegState = this.regCodeToServiceState(regState);
            this.mNewSS.setDataRegState(dataRegState);
            this.log("handlPollStateResultMessage: CdmaLteSST setDataRegState=" + dataRegState + " regState=" + regState + " dataRadioTechnology=" + type);
        } else {
            super.handlePollStateResultMessage(what, ar);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$pollState() {
        this.mPollingContext = new int[1];
        this.mPollingContext[0] = 0;
        switch (1.$SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState[this.mCi.getRadioState().ordinal()]) {
            case 1: {
                this.mNewSS.setStateOutOfService();
                this.mNewCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            case 2: {
                this.mNewSS.setStateOff();
                this.mNewCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            default: {
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getOperator(this.obtainMessage(25, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getVoiceRegistrationState(this.obtainMessage(24, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getDataRegistrationState(this.obtainMessage(5, this.mPollingContext));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$pollStateDone() {
        this.log("pollStateDone: lte 1 ss=[" + this.mSS + "] newSS=[" + this.mNewSS + "]");
        this.useDataRegStateForDataOnlyDevices();
        boolean hasRegistered = this.mSS.getVoiceRegState() != 0 && this.mNewSS.getVoiceRegState() == 0;
        boolean hasDeregistered = this.mSS.getVoiceRegState() == 0 && this.mNewSS.getVoiceRegState() != 0;
        boolean hasCdmaDataConnectionAttached = this.mSS.getDataRegState() != 0 && this.mNewSS.getDataRegState() == 0;
        boolean hasCdmaDataConnectionDetached = this.mSS.getDataRegState() == 0 && this.mNewSS.getDataRegState() != 0;
        boolean hasCdmaDataConnectionChanged = this.mSS.getDataRegState() != this.mNewSS.getDataRegState();
        boolean hasVoiceRadioTechnologyChanged = this.mSS.getRilVoiceRadioTechnology() != this.mNewSS.getRilVoiceRadioTechnology();
        boolean hasDataRadioTechnologyChanged = this.mSS.getRilDataRadioTechnology() != this.mNewSS.getRilDataRadioTechnology();
        boolean hasChanged = !this.mNewSS.equals(this.mSS);
        boolean hasRoamingOn = !this.mSS.getRoaming() && this.mNewSS.getRoaming();
        boolean hasRoamingOff = this.mSS.getRoaming() && !this.mNewSS.getRoaming();
        boolean hasLocationChanged = !this.mNewCellLoc.equals(this.mCellLoc);
        boolean has4gHandoff = this.mNewSS.getDataRegState() == 0 && (this.mSS.getRilDataRadioTechnology() == 14 && this.mNewSS.getRilDataRadioTechnology() == 13 || this.mSS.getRilDataRadioTechnology() == 13 && this.mNewSS.getRilDataRadioTechnology() == 14);
        boolean hasMultiApnSupport = (this.mNewSS.getRilDataRadioTechnology() == 14 || this.mNewSS.getRilDataRadioTechnology() == 13) && this.mSS.getRilDataRadioTechnology() != 14 && this.mSS.getRilDataRadioTechnology() != 13;
        boolean hasLostMultiApnSupport = this.mNewSS.getRilDataRadioTechnology() >= 4 && this.mNewSS.getRilDataRadioTechnology() <= 8;
        this.log("pollStateDone: hasRegistered=" + hasRegistered + " hasDeegistered=" + hasDeregistered + " hasCdmaDataConnectionAttached=" + hasCdmaDataConnectionAttached + " hasCdmaDataConnectionDetached=" + hasCdmaDataConnectionDetached + " hasCdmaDataConnectionChanged=" + hasCdmaDataConnectionChanged + " hasVoiceRadioTechnologyChanged= " + hasVoiceRadioTechnologyChanged + " hasDataRadioTechnologyChanged=" + hasDataRadioTechnologyChanged + " hasChanged=" + hasChanged + " hasRoamingOn=" + hasRoamingOn + " hasRoamingOff=" + hasRoamingOff + " hasLocationChanged=" + hasLocationChanged + " has4gHandoff = " + has4gHandoff + " hasMultiApnSupport=" + hasMultiApnSupport + " hasLostMultiApnSupport=" + hasLostMultiApnSupport);
        if (this.mSS.getVoiceRegState() != this.mNewSS.getVoiceRegState() || this.mSS.getDataRegState() != this.mNewSS.getDataRegState()) {
            EventLog.writeEvent(50116, this.mSS.getVoiceRegState(), this.mSS.getDataRegState(), this.mNewSS.getVoiceRegState(), this.mNewSS.getDataRegState());
        }
        ServiceState tss = this.mSS;
        this.mSS = this.mNewSS;
        this.mNewSS = tss;
        this.mNewSS.setStateOutOfService();
        CdmaCellLocation tcl = this.mCellLoc;
        this.mCellLoc = this.mNewCellLoc;
        this.mNewCellLoc = tcl;
        this.mNewSS.setStateOutOfService();
        if (hasVoiceRadioTechnologyChanged) {
            this.updatePhoneObject();
        }
        if (hasDataRadioTechnologyChanged) {
            this.mPhone.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(this.mSS.getRilDataRadioTechnology()));
        }
        if (hasRegistered) {
            this.mNetworkAttachedRegistrants.notifyRegistrants();
        }
        if (hasChanged) {
            boolean hasBrandOverride;
            boolean bl = this.mUiccController.getUiccCard() == null ? false : (hasBrandOverride = this.mUiccController.getUiccCard().getOperatorBrandOverride() != null);
            if (!hasBrandOverride && this.mCi.getRadioState().isOn() && this.mPhone.isEriFileLoaded()) {
                String eriText;
                if (this.mSS.getVoiceRegState() == 0) {
                    eriText = this.mPhone.getCdmaEriText();
                } else if (this.mSS.getVoiceRegState() == 3) {
                    String string2 = eriText = this.mIccRecords != null ? this.mIccRecords.getServiceProviderName() : null;
                    if (TextUtils.isEmpty(eriText)) {
                        eriText = SystemProperties.get("ro.cdma.home.operator.alpha");
                    }
                } else {
                    eriText = this.mPhone.getContext().getText(17039557).toString();
                }
                this.mSS.setOperatorAlphaLong(eriText);
            }
            if (this.mUiccApplcation != null && this.mUiccApplcation.getState() == IccCardApplicationStatus.AppState.APPSTATE_READY && this.mIccRecords != null) {
                boolean showSpn = ((RuimRecords)this.mIccRecords).getCsimSpnDisplayCondition();
                int iconIndex = this.mSS.getCdmaEriIconIndex();
                if (showSpn && iconIndex == 1 && this.isInHomeSidNid(this.mSS.getSystemId(), this.mSS.getNetworkId()) && this.mIccRecords != null) {
                    this.mSS.setOperatorAlphaLong(this.mIccRecords.getServiceProviderName());
                }
            }
            this.mPhone.setSystemProperty("gsm.operator.alpha", this.mSS.getOperatorAlphaLong());
            String prevOperatorNumeric = SystemProperties.get("gsm.operator.numeric", "");
            String operatorNumeric = this.mSS.getOperatorNumeric();
            if (this.isInvalidOperatorNumeric(operatorNumeric)) {
                int sid = this.mSS.getSystemId();
                operatorNumeric = this.fixUnknownMcc(operatorNumeric, sid);
            }
            this.mPhone.setSystemProperty("gsm.operator.numeric", operatorNumeric);
            this.updateCarrierMccMncConfiguration(operatorNumeric, prevOperatorNumeric, this.mPhone.getContext());
            if (this.isInvalidOperatorNumeric(operatorNumeric)) {
                this.log("operatorNumeric is null");
                this.mPhone.setSystemProperty("gsm.operator.iso-country", "");
                this.mGotCountryCode = false;
            } else {
                String isoCountryCode = "";
                String mcc = operatorNumeric.substring(0, 3);
                try {
                    isoCountryCode = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
                }
                catch (NumberFormatException ex) {
                    this.loge("countryCodeForMcc error" + ex);
                }
                catch (StringIndexOutOfBoundsException ex) {
                    this.loge("countryCodeForMcc error" + ex);
                }
                this.mPhone.setSystemProperty("gsm.operator.iso-country", isoCountryCode);
                this.mGotCountryCode = true;
                this.setOperatorIdd(operatorNumeric);
                if (this.shouldFixTimeZoneNow(this.mPhone, operatorNumeric, prevOperatorNumeric, this.mNeedFixZone)) {
                    this.fixTimeZone(isoCountryCode);
                }
            }
            this.mPhone.setSystemProperty("gsm.operator.isroaming", this.mSS.getRoaming() ? "true" : "false");
            this.updateSpnDisplay();
            this.mPhone.notifyServiceStateChanged(this.mSS);
        }
        if (hasCdmaDataConnectionAttached || has4gHandoff) {
            this.mAttachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionDetached) {
            this.mDetachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionChanged || hasDataRadioTechnologyChanged) {
            this.notifyDataRegStateRilRadioTechnologyChanged();
            this.mPhone.notifyDataConnection(null);
        }
        if (hasRoamingOn) {
            this.mRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasRoamingOff) {
            this.mRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasLocationChanged) {
            this.mPhone.notifyLocationChanged();
        }
        ArrayList<CellInfo> arrayCi = new ArrayList<CellInfo>();
        CellInfo cellInfo = this.mCellInfo;
        synchronized (cellInfo) {
            boolean cidChanged;
            CellInfoLte cil = (CellInfoLte)this.mCellInfo;
            boolean bl = cidChanged = !this.mNewCellIdentityLte.equals(this.mLasteCellIdentityLte);
            if (hasRegistered || hasDeregistered || cidChanged) {
                long timeStamp = SystemClock.elapsedRealtime() * 1000L;
                boolean registered = this.mSS.getVoiceRegState() == 0;
                this.mLasteCellIdentityLte = this.mNewCellIdentityLte;
                cil.setRegistered(registered);
                cil.setCellIdentity(this.mLasteCellIdentityLte);
                this.log("pollStateDone: hasRegistered=" + hasRegistered + " hasDeregistered=" + hasDeregistered + " cidChanged=" + cidChanged + " mCellInfo=" + this.mCellInfo);
                arrayCi.add(this.mCellInfo);
            }
            this.mPhoneBase.notifyCellInfo(arrayCi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$onSignalStrengthResult(AsyncResult ar, boolean isGsm) {
        if (this.mSS.getRilDataRadioTechnology() == 14) {
            isGsm = true;
        }
        boolean ssChanged = super.onSignalStrengthResult(ar, isGsm);
        CellInfo cellInfo = this.mCellInfo;
        synchronized (cellInfo) {
            if (this.mSS.getRilDataRadioTechnology() == 14) {
                this.mCellInfoLte.setTimeStamp(SystemClock.elapsedRealtime() * 1000L);
                this.mCellInfoLte.setTimeStampType(4);
                this.mCellInfoLte.getCellSignalStrength().initialize(this.mSignalStrength, Integer.MAX_VALUE);
            }
            if (this.mCellInfoLte.getCellIdentity() != null) {
                ArrayList<CellInfo> arrayCi = new ArrayList<CellInfo>();
                arrayCi.add(this.mCellInfoLte);
                this.mPhoneBase.notifyCellInfo(arrayCi);
            }
        }
        return ssChanged;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$isConcurrentVoiceAndDataAllowed() {
        return this.mSS.getCssIndicator() == 1;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$isInHomeSidNid(int sid, int nid) {
        if (this.isSidsAllZeros()) {
            return true;
        }
        if (this.mHomeSystemId.length != this.mHomeNetworkId.length) {
            return true;
        }
        if (sid == 0) {
            return true;
        }
        for (int i = 0; i < this.mHomeSystemId.length; ++i) {
            if (this.mHomeSystemId[i] != sid || this.mHomeNetworkId[i] != 0 && this.mHomeNetworkId[i] != 65535 && nid != 0 && nid != 65535 && this.mHomeNetworkId[i] != nid) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<CellInfo> $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$getAllCellInfo() {
        if (this.mCi.getRilVersion() >= 8) {
            return super.getAllCellInfo();
        }
        ArrayList<CellInfo> arrayList = new ArrayList<CellInfo>();
        CellInfo cellInfo = this.mCellInfo;
        synchronized (cellInfo) {
            arrayList.add(this.mCellInfoLte);
        }
        this.log("getAllCellInfo: arrayList=" + arrayList);
        return arrayList;
    }

    private final UiccCardApplication $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$getUiccCardApplication() {
        return this.mUiccController.getUiccCardApplication(((CDMALTEPhone)this.mPhone).getPhoneId(), 2);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$updateCdmaSubscription() {
        this.mCi.getCDMASubscription(this.obtainMessage(34));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$powerOffRadioSafely(DcTrackerBase dcTracker) {
        CdmaLteServiceStateTracker cdmaLteServiceStateTracker = this;
        synchronized (cdmaLteServiceStateTracker) {
            if (!this.mPendingRadioPowerOffAfterDataOff) {
                long dds = SubscriptionManager.getDefaultDataSubId();
                if (dcTracker.isDisconnected() && (dds == this.mPhone.getSubId() || dds != this.mPhone.getSubId() && ProxyController.getInstance().isDataDisconnected(dds))) {
                    dcTracker.cleanUpAllConnections("radioTurnedOff");
                    this.log("Data disconnected, turn off radio right away.");
                    this.hangupAndPowerOff();
                } else {
                    dcTracker.cleanUpAllConnections("radioTurnedOff");
                    if (dds != this.mPhone.getSubId() && !ProxyController.getInstance().isDataDisconnected(dds)) {
                        this.log("Data is active on DDS.  Wait for all data disconnect");
                        ProxyController.getInstance().registerForAllDataDisconnected(dds, this, 1001, null);
                        this.mPendingRadioPowerOffAfterDataOff = true;
                    }
                    Message msg = Message.obtain(this);
                    msg.what = 38;
                    msg.arg1 = ++this.mPendingRadioPowerOffAfterDataOffTag;
                    if (this.sendMessageDelayed(msg, 30000L)) {
                        this.log("Wait upto 30s for data to disconnect, then turn off radio.");
                        this.mPendingRadioPowerOffAfterDataOff = true;
                    } else {
                        this.log("Cannot send delayed Msg, turn off radio right away.");
                        this.hangupAndPowerOff();
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    }
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$updatePhoneObject() {
        int voiceRat = this.mSS.getRilVoiceRadioTechnology();
        if (this.mPhone.getContext().getResources().getBoolean(17956986)) {
            int volteReplacementRat = this.mPhoneBase.getContext().getResources().getInteger(17694809);
            Rlog.d("CdmaSST", "updatePhoneObject: volteReplacementRat=" + volteReplacementRat);
            if (voiceRat == 14 && volteReplacementRat == 0) {
                voiceRat = 6;
            }
            this.mPhoneBase.updatePhoneObject(voiceRat);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$log(String s) {
        Rlog.d("CdmaSST", "[CdmaLteSST] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$loge(String s) {
        Rlog.e("CdmaSST", "[CdmaLteSST] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CdmaLteServiceStateTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mCdmaLtePhone=" + this.mCdmaLtePhone);
    }

    private void __constructor__(CDMALTEPhone cDMALTEPhone) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$__constructor__(cDMALTEPhone);
    }

    public CdmaLteServiceStateTracker(CDMALTEPhone cDMALTEPhone) {
        super(cDMALTEPhone, new CellInfoLte());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$__constructor__(com.android.internal.telephony.cdma.CDMALTEPhone ), 0, this, cDMALTEPhone);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$handleMessage(android.os.Message ), 0, this, message);
    }

    @Override
    protected void handlePollStateResultMessage(int n, AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handlePollStateResultMessage", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$handlePollStateResultMessage(int android.os.AsyncResult ), 0, this, n, asyncResult);
    }

    @Override
    public void pollState() {
        InvokeDynamicSupport.bootstrap("pollState", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$pollState(), 0, this);
    }

    @Override
    protected void pollStateDone() {
        InvokeDynamicSupport.bootstrap("pollStateDone", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$pollStateDone(), 0, this);
    }

    @Override
    protected boolean onSignalStrengthResult(AsyncResult asyncResult, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSignalStrengthResult", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$onSignalStrengthResult(android.os.AsyncResult boolean ), 0, this, asyncResult, bl);
    }

    @Override
    public boolean isConcurrentVoiceAndDataAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConcurrentVoiceAndDataAllowed", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$isConcurrentVoiceAndDataAllowed(), 0, this);
    }

    private boolean isInHomeSidNid(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isInHomeSidNid", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$isInHomeSidNid(int int ), 0, this, n, n2);
    }

    @Override
    public List<CellInfo> getAllCellInfo() {
        return InvokeDynamicSupport.bootstrap("getAllCellInfo", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$getAllCellInfo(), 0, this);
    }

    @Override
    protected UiccCardApplication getUiccCardApplication() {
        return InvokeDynamicSupport.bootstrap("getUiccCardApplication", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$getUiccCardApplication(), 0, this);
    }

    protected void updateCdmaSubscription() {
        InvokeDynamicSupport.bootstrap("updateCdmaSubscription", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$updateCdmaSubscription(), 0, this);
    }

    @Override
    public void powerOffRadioSafely(DcTrackerBase dcTrackerBase) {
        InvokeDynamicSupport.bootstrap("powerOffRadioSafely", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$powerOffRadioSafely(com.android.internal.telephony.dataconnection.DcTrackerBase ), 0, this, dcTrackerBase);
    }

    @Override
    protected void updatePhoneObject() {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$updatePhoneObject(), 0, this);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$log(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$loge(java.lang.String ), 0, this, string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_cdma_CdmaLteServiceStateTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ CdmaLteServiceStateTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CdmaLteServiceStateTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState;

        static void __staticInitializer__() {
            $SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState = new int[CommandsInterface.RadioState.values().length];
            try {
                1.$SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState[CommandsInterface.RadioState.RADIO_UNAVAILABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState[CommandsInterface.RadioState.RADIO_OFF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

