/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApnSetting
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String V2_FORMAT_REGEX = "^\\[ApnSettingV2\\]\\s*";
    static String V3_FORMAT_REGEX = "^\\[ApnSettingV3\\]\\s*";
    public String carrier;
    public String apn;
    public String proxy;
    public String port;
    public String mmsc;
    public String mmsProxy;
    public String mmsPort;
    public String user;
    public String password;
    public int authType;
    public String[] types;
    public int id;
    public String numeric;
    public String protocol;
    public String roamingProtocol;
    public int mtu;
    public boolean carrierEnabled;
    public int bearer;
    public int profileId;
    public boolean modemCognitive;
    public int maxConns;
    public int waitTime;
    public int maxConnsTime;
    public String mvnoType;
    public String mvnoMatchData;

    private void $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$__constructor__(int id2, String numeric, String carrier, String apn, String proxy, String port, String mmsc, String mmsProxy, String mmsPort, String user, String password, int authType, String[] types, String protocol, String roamingProtocol, boolean carrierEnabled, int bearer, int profileId, boolean modemCognitive, int maxConns, int waitTime, int maxConnsTime, int mtu, String mvnoType, String mvnoMatchData) {
        this.id = id2;
        this.numeric = numeric;
        this.carrier = carrier;
        this.apn = apn;
        this.proxy = proxy;
        this.port = port;
        this.mmsc = mmsc;
        this.mmsProxy = mmsProxy;
        this.mmsPort = mmsPort;
        this.user = user;
        this.password = password;
        this.authType = authType;
        this.types = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.types[i] = types[i].toLowerCase(Locale.ROOT);
        }
        this.protocol = protocol;
        this.roamingProtocol = roamingProtocol;
        this.carrierEnabled = carrierEnabled;
        this.bearer = bearer;
        this.profileId = profileId;
        this.modemCognitive = modemCognitive;
        this.maxConns = maxConns;
        this.waitTime = waitTime;
        this.maxConnsTime = maxConnsTime;
        this.mtu = mtu;
        this.mvnoType = mvnoType;
        this.mvnoMatchData = mvnoMatchData;
    }

    private static final ApnSetting $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$fromString(String data) {
        boolean carrierEnabled;
        String roamingProtocol;
        String protocol;
        String[] typeArray;
        int authType;
        int version;
        if (data == null) {
            return null;
        }
        if (data.matches("^\\[ApnSettingV3\\]\\s*.*")) {
            version = 3;
            data = data.replaceFirst("^\\[ApnSettingV3\\]\\s*", "");
        } else if (data.matches("^\\[ApnSettingV2\\]\\s*.*")) {
            version = 2;
            data = data.replaceFirst("^\\[ApnSettingV2\\]\\s*", "");
        } else {
            version = 1;
        }
        String[] a = data.split("\\s*,\\s*");
        if (a.length < 14) {
            return null;
        }
        try {
            authType = Integer.parseInt(a[12]);
        }
        catch (NumberFormatException e) {
            authType = 0;
        }
        int bearer = 0;
        int profileId = 0;
        boolean modemCognitive = false;
        int maxConns = 0;
        int waitTime = 0;
        int maxConnsTime = 0;
        int mtu = 0;
        String mvnoType = "";
        String mvnoMatchData = "";
        if (version == 1) {
            typeArray = new String[a.length - 13];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)a, (int)13, (Object)typeArray, (int)0, (int)(a.length - 13));
            protocol = "IP";
            roamingProtocol = "IP";
            carrierEnabled = true;
            bearer = 0;
        } else {
            if (a.length < 18) {
                return null;
            }
            typeArray = a[13].split("\\s*\\|\\s*");
            protocol = a[14];
            roamingProtocol = a[15];
            carrierEnabled = Boolean.parseBoolean(a[16]);
            try {
                bearer = Integer.parseInt(a[17]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (a.length > 22) {
                modemCognitive = Boolean.parseBoolean(a[19]);
                try {
                    profileId = Integer.parseInt(a[18]);
                    maxConns = Integer.parseInt(a[20]);
                    waitTime = Integer.parseInt(a[21]);
                    maxConnsTime = Integer.parseInt(a[22]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (a.length > 23) {
                try {
                    mtu = Integer.parseInt(a[23]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (a.length > 25) {
                mvnoType = a[24];
                mvnoMatchData = a[25];
            }
        }
        return new ApnSetting(-1, a[10] + a[11], a[0], a[1], a[2], a[3], a[7], a[8], a[9], a[4], a[5], authType, typeArray, protocol, roamingProtocol, carrierEnabled, bearer, profileId, modemCognitive, maxConns, waitTime, maxConnsTime, mtu, mvnoType, mvnoMatchData);
    }

    private static final List<ApnSetting> $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$arrayFromString(String data) {
        String[] apnStrings;
        ArrayList<ApnSetting> retVal = new ArrayList<ApnSetting>();
        if (TextUtils.isEmpty(data)) {
            return retVal;
        }
        for (String apnString : apnStrings = data.split("\\s*;\\s*")) {
            ApnSetting apn = ApnSetting.fromString(apnString);
            if (apn == null) continue;
            retVal.add(apn);
        }
        return retVal;
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ApnSettingV3] ").append(this.carrier).append(", ").append(this.id).append(", ").append(this.numeric).append(", ").append(this.apn).append(", ").append(this.proxy).append(", ").append(this.mmsc).append(", ").append(this.mmsProxy).append(", ").append(this.mmsPort).append(", ").append(this.port).append(", ").append(this.authType).append(", ");
        for (int i = 0; i < this.types.length; ++i) {
            sb.append(this.types[i]);
            if (i >= this.types.length - 1) continue;
            sb.append(" | ");
        }
        sb.append(", ").append(this.protocol);
        sb.append(", ").append(this.roamingProtocol);
        sb.append(", ").append(this.carrierEnabled);
        sb.append(", ").append(this.bearer);
        sb.append(", ").append(this.profileId);
        sb.append(", ").append(this.modemCognitive);
        sb.append(", ").append(this.maxConns);
        sb.append(", ").append(this.waitTime);
        sb.append(", ").append(this.maxConnsTime);
        sb.append(", ").append(this.mtu);
        sb.append(", ").append(this.mvnoType);
        sb.append(", ").append(this.mvnoMatchData);
        return sb.toString();
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$hasMvnoParams() {
        return !TextUtils.isEmpty(this.mvnoType) && !TextUtils.isEmpty(this.mvnoMatchData);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$canHandleType(String type) {
        if (!this.carrierEnabled) {
            return false;
        }
        for (String t : this.types) {
            if (!t.equalsIgnoreCase(type) && !t.equalsIgnoreCase("*") && (!t.equalsIgnoreCase("default") || !type.equalsIgnoreCase("hipri"))) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$equals(Object o) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    private void __constructor__(int n, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, int n2, String[] stringArray, String string12, String string13, boolean bl, int n3, int n4, boolean bl2, int n5, int n6, int n7, int n8, String string14, String string15) {
        this.$$robo$$com_android_internal_telephony_dataconnection_ApnSetting$__constructor__(n, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, n2, stringArray, string12, string13, bl, n3, n4, bl2, n5, n6, n7, n8, string14, string15);
    }

    public ApnSetting(int n, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, int n2, String[] stringArray, String string12, String string13, boolean bl, int n3, int n4, boolean bl2, int n5, int n6, int n7, int n8, String string14, String string15) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$__constructor__(int java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String int java.lang.String[] java.lang.String java.lang.String boolean int int boolean int int int int java.lang.String java.lang.String ), 0, this, n, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, n2, stringArray, string12, string13, bl, n3, n4, bl2, n5, n6, n7, n8, string14, string15);
    }

    public static ApnSetting fromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fromString", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$fromString(java.lang.String ), 0, (String)string2);
    }

    public static List<ApnSetting> arrayFromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("arrayFromString", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$arrayFromString(java.lang.String ), 0, (String)string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$toString(), 0, this);
    }

    public boolean hasMvnoParams() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMvnoParams", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$hasMvnoParams(), 0, this);
    }

    public boolean canHandleType(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("canHandleType", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$canHandleType(java.lang.String ), 0, this, string2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$equals(java.lang.Object ), 0, this, object);
    }

    public /* synthetic */ ApnSetting() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApnSetting)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

