/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.PendingIntent;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkAgent;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.ProxyInfo;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Patterns;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.ApnSetting;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.dataconnection.DcAsyncChannel;
import com.android.internal.telephony.dataconnection.DcController;
import com.android.internal.telephony.dataconnection.DcFailCause;
import com.android.internal.telephony.dataconnection.DcRetryAlarmController;
import com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DataConnection
extends StateMachine
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = true;
    private static boolean VDBG = true;
    private static String DEFAULT_DATA_RETRY_CONFIG = "default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000";
    private static String SECONDARY_DATA_RETRY_CONFIG = "max_retries=3, 5000, 5000, 5000";
    private static String NETWORK_TYPE = "MOBILE";
    private DcController mDcController;
    private DcTesterFailBringUpAll mDcTesterFailBringUpAll;
    private static AtomicInteger mInstanceNumber;
    private AsyncChannel mAc;
    private DcRetryAlarmController mDcRetryAlarmController;
    private DcTrackerBase mDct;
    protected String[] mPcscfAddr;
    private ApnSetting mApnSetting;
    private ConnectionParams mConnectionParams;
    private DisconnectParams mDisconnectParams;
    private DcFailCause mDcFailCause;
    private PhoneBase mPhone;
    private LinkProperties mLinkProperties;
    private long mCreateTime;
    private long mLastFailTime;
    private DcFailCause mLastFailCause;
    private static String NULL_IP = "0.0.0.0";
    private Object mUserData;
    private int mRilRat;
    private int mDataRegState;
    private NetworkInfo mNetworkInfo;
    private NetworkAgent mNetworkAgent;
    int mTag;
    int mCid;
    List<ApnContext> mApnContexts;
    PendingIntent mReconnectIntent;
    RetryManager mRetryManager;
    static int BASE = 262144;
    static int EVENT_CONNECT = 262144;
    static int EVENT_SETUP_DATA_CONNECTION_DONE = 262145;
    static int EVENT_GET_LAST_FAIL_DONE = 262146;
    static int EVENT_DEACTIVATE_DONE = 262147;
    static int EVENT_DISCONNECT = 262148;
    static int EVENT_RIL_CONNECTED = 262149;
    static int EVENT_DISCONNECT_ALL = 262150;
    static int EVENT_DATA_STATE_CHANGED = 262151;
    static int EVENT_TEAR_DOWN_NOW = 262152;
    static int EVENT_LOST_CONNECTION = 262153;
    static int EVENT_RETRY_CONNECTION = 262154;
    static int EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED = 262155;
    static int EVENT_DATA_CONNECTION_ROAM_ON = 262156;
    static int EVENT_DATA_CONNECTION_ROAM_OFF = 262157;
    private static int CMD_TO_STRING_COUNT = 14;
    private static String[] sCmdToString;
    private int mId;
    private static String TCP_BUFFER_SIZES_GPRS = "4092,8760,48000,4096,8760,48000";
    private static String TCP_BUFFER_SIZES_EDGE = "4093,26280,70800,4096,16384,70800";
    private static String TCP_BUFFER_SIZES_UMTS = "58254,349525,1048576,58254,349525,1048576";
    private static String TCP_BUFFER_SIZES_1XRTT = "16384,32768,131072,4096,16384,102400";
    private static String TCP_BUFFER_SIZES_EVDO = "4094,87380,262144,4096,16384,262144";
    private static String TCP_BUFFER_SIZES_EHRPD = "131072,262144,1048576,4096,16384,524288";
    private static String TCP_BUFFER_SIZES_HSDPA = "61167,367002,1101005,8738,52429,262114";
    private static String TCP_BUFFER_SIZES_HSPA = "40778,244668,734003,16777,100663,301990";
    private static String TCP_BUFFER_SIZES_LTE = "524288,1048576,2097152,262144,524288,1048576";
    private static String TCP_BUFFER_SIZES_HSPAP = "122334,734003,2202010,32040,192239,576717";
    private DcDefaultState mDefaultState;
    private DcInactiveState mInactiveState;
    private DcRetryingState mRetryingState;
    private DcActivatingState mActivatingState;
    private DcActiveState mActiveState;
    private DcDisconnectingState mDisconnectingState;
    private DcDisconnectionErrorCreatingConnection mDisconnectingErrorCreatingConnection;

    private static final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$cmdToString(int cmd) {
        String value;
        if ((value = (cmd -= 262144) >= 0 && cmd < sCmdToString.length ? sCmdToString[cmd] : DcAsyncChannel.cmdToString(cmd + 262144)) == null) {
            value = "0x" + Integer.toHexString(cmd + 262144);
        }
        return value;
    }

    private static final DataConnection $$robo$$com_android_internal_telephony_dataconnection_DataConnection$makeDataConnection(PhoneBase phone, int id2, DcTrackerBase dct, DcTesterFailBringUpAll failBringUpAll, DcController dcc) {
        DataConnection dc = new DataConnection(phone, "DC-" + mInstanceNumber.incrementAndGet(), id2, dct, failBringUpAll, dcc);
        dc.start();
        dc.log("Made " + dc.getName());
        return dc;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$dispose() {
        this.log("dispose: call quiteNow()");
        this.quitNow();
    }

    private final NetworkCapabilities $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getCopyNetworkCapabilities() {
        return this.makeNetworkCapabilities();
    }

    private final LinkProperties $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getCopyLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getIsInactive() {
        return this.getCurrentState() == this.mInactiveState;
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getCid() {
        return this.mCid;
    }

    private final ApnSetting $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getApnSetting() {
        return this.mApnSetting;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$setLinkPropertiesHttpProxy(ProxyInfo proxy) {
        this.mLinkProperties.setHttpProxy(proxy);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpv4Connected() {
        boolean ret = false;
        List<InetAddress> addresses = this.mLinkProperties.getAddresses();
        for (InetAddress addr : addresses) {
            Inet4Address i4addr;
            if (!(addr instanceof Inet4Address) || (i4addr = (Inet4Address)addr).isAnyLocalAddress() || i4addr.isLinkLocalAddress() || i4addr.isLoopbackAddress() || i4addr.isMulticastAddress()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpv6Connected() {
        boolean ret = false;
        List<InetAddress> addresses = this.mLinkProperties.getAddresses();
        for (InetAddress addr : addresses) {
            Inet6Address i6addr;
            if (!(addr instanceof Inet6Address) || (i6addr = (Inet6Address)addr).isAnyLocalAddress() || i6addr.isLinkLocalAddress() || i6addr.isLoopbackAddress() || i6addr.isMulticastAddress()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private final UpdateLinkPropertyResult $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateLinkProperty(DataCallResponse newState) {
        UpdateLinkPropertyResult result = new UpdateLinkPropertyResult(this.mLinkProperties);
        if (newState == null) {
            return result;
        }
        result.newLp = new LinkProperties();
        result.setupResult = this.setLinkProperties(newState, result.newLp);
        if (result.setupResult != DataCallResponse.SetupResult.SUCCESS) {
            this.log("updateLinkProperty failed : " + (Object)((Object)result.setupResult));
            return result;
        }
        result.newLp.setHttpProxy(this.mLinkProperties.getHttpProxy());
        this.checkSetMtu(this.mApnSetting, result.newLp);
        this.mLinkProperties = result.newLp;
        this.updateTcpBufferSizes(this.mRilRat);
        if (!result.oldLp.equals(result.newLp)) {
            this.log("updateLinkProperty old LP=" + result.oldLp);
            this.log("updateLinkProperty new LP=" + result.newLp);
        }
        if (!result.newLp.equals(result.oldLp) && this.mNetworkAgent != null) {
            this.mNetworkAgent.sendLinkProperties(this.mLinkProperties);
        }
        return result;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$checkSetMtu(ApnSetting apn, LinkProperties lp) {
        if (lp == null) {
            return;
        }
        if (apn == null || lp == null) {
            return;
        }
        if (lp.getMtu() != 0) {
            this.log("MTU set by call response to: " + lp.getMtu());
            return;
        }
        if (apn != null && apn.mtu != 0) {
            lp.setMtu(apn.mtu);
            this.log("MTU set by APN to: " + apn.mtu);
            return;
        }
        int mtu = this.mPhone.getContext().getResources().getInteger(17694832);
        if (mtu != 0) {
            lp.setMtu(mtu);
            this.log("MTU set by config resource to: " + mtu);
        }
    }

    private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$__constructor__(PhoneBase phone, String name, int id2, DcTrackerBase dct, DcTesterFailBringUpAll failBringUpAll, DcController dcc) {
        this.mDct = null;
        this.mLinkProperties = new LinkProperties();
        this.mRilRat = Integer.MAX_VALUE;
        this.mDataRegState = Integer.MAX_VALUE;
        this.mApnContexts = null;
        this.mReconnectIntent = null;
        this.mRetryManager = new RetryManager();
        this.mDefaultState = new DcDefaultState(this);
        this.mInactiveState = new DcInactiveState(this);
        this.mRetryingState = new DcRetryingState(this);
        this.mActivatingState = new DcActivatingState(this);
        this.mActiveState = new DcActiveState(this);
        this.mDisconnectingState = new DcDisconnectingState(this);
        this.mDisconnectingErrorCreatingConnection = new DcDisconnectionErrorCreatingConnection(this);
        this.setLogRecSize(300);
        this.setLogOnlyTransitions(true);
        this.log("DataConnection constructor E");
        this.mPhone = phone;
        this.mDct = dct;
        this.mDcTesterFailBringUpAll = failBringUpAll;
        this.mDcController = dcc;
        this.mId = id2;
        this.mCid = -1;
        this.mDcRetryAlarmController = new DcRetryAlarmController(this.mPhone, this);
        ServiceState ss = this.mPhone.getServiceState();
        this.mRilRat = ss.getRilDataRadioTechnology();
        this.mDataRegState = this.mPhone.getServiceState().getDataRegState();
        int networkType = ss.getDataNetworkType();
        this.mNetworkInfo = new NetworkInfo(0, networkType, "MOBILE", TelephonyManager.getNetworkTypeName(networkType));
        this.mNetworkInfo.setRoaming(ss.getRoaming());
        this.mNetworkInfo.setIsAvailable(true);
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActivatingState, this.mDefaultState);
        this.addState(this.mRetryingState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.addState(this.mDisconnectingState, this.mDefaultState);
        this.addState(this.mDisconnectingErrorCreatingConnection, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
        this.mApnContexts = new ArrayList<ApnContext>();
        this.log("DataConnection constructor X");
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getRetryConfig(boolean forDefault) {
        String config;
        int nt = this.mPhone.getServiceState().getNetworkType();
        if (Build.IS_DEBUGGABLE && !TextUtils.isEmpty(config = SystemProperties.get("test.data_retry_config"))) {
            return config;
        }
        if (nt == 4 || nt == 7 || nt == 5 || nt == 6 || nt == 12 || nt == 14) {
            return SystemProperties.get("ro.cdma.data_retry_config");
        }
        if (forDefault) {
            return SystemProperties.get("ro.gsm.data_retry_config");
        }
        return SystemProperties.get("ro.gsm.2nd_data_retry_config");
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$configureRetry(boolean forDefault) {
        String retryConfig = this.getRetryConfig(forDefault);
        if (!this.mRetryManager.configure(retryConfig)) {
            if (forDefault) {
                if (!this.mRetryManager.configure("default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000")) {
                    this.loge("configureRetry: Could not configure using DEFAULT_DATA_RETRY_CONFIG=default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000");
                    this.mRetryManager.configure(5, 2000, 1000);
                }
            } else if (!this.mRetryManager.configure("max_retries=3, 5000, 5000, 5000")) {
                this.loge("configureRetry: Could note configure using SECONDARY_DATA_RETRY_CONFIG=max_retries=3, 5000, 5000, 5000");
                this.mRetryManager.configure(5, 2000, 1000);
            }
        }
        this.log("configureRetry: forDefault=" + forDefault + " mRetryManager=" + this.mRetryManager);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$onConnect(ConnectionParams cp) {
        this.log("onConnect: carrier='" + this.mApnSetting.carrier + "' APN='" + this.mApnSetting.apn + "' proxy='" + this.mApnSetting.proxy + "' port='" + this.mApnSetting.port + "'");
        if (this.mDcTesterFailBringUpAll.getDcFailBringUp().mCounter > 0) {
            DataCallResponse response = new DataCallResponse();
            response.version = this.mPhone.mCi.getRilVersion();
            response.status = this.mDcTesterFailBringUpAll.getDcFailBringUp().mFailCause.getErrorCode();
            response.cid = 0;
            response.active = 0;
            response.type = "";
            response.ifname = "";
            response.addresses = new String[0];
            response.dnses = new String[0];
            response.gateways = new String[0];
            response.suggestedRetryTime = this.mDcTesterFailBringUpAll.getDcFailBringUp().mSuggestedRetryTime;
            response.pcscf = new String[0];
            response.mtu = 0;
            Message msg = this.obtainMessage(262145, cp);
            AsyncResult.forMessage(msg, response, null);
            this.sendMessage(msg);
            this.log("onConnect: FailBringUpAll=" + this.mDcTesterFailBringUpAll.getDcFailBringUp() + " send error response=" + response);
            --this.mDcTesterFailBringUpAll.getDcFailBringUp().mCounter;
            return;
        }
        this.mCreateTime = -1L;
        this.mLastFailTime = -1L;
        this.mLastFailCause = DcFailCause.NONE;
        Message msg = this.obtainMessage(262145, cp);
        msg.obj = cp;
        int authType = this.mApnSetting.authType;
        if (authType == -1) {
            authType = TextUtils.isEmpty(this.mApnSetting.user) ? 0 : 3;
        }
        String protocol = this.mPhone.getServiceState().getRoaming() ? this.mApnSetting.roamingProtocol : this.mApnSetting.protocol;
        this.mPhone.mCi.setupDataCall(Integer.toString(cp.mRilRat + 2), Integer.toString(cp.mProfileId), this.mApnSetting.apn, this.mApnSetting.user, this.mApnSetting.password, Integer.toString(authType), protocol, msg);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$tearDownData(Object o) {
        int discReason = 0;
        if (o != null && o instanceof DisconnectParams) {
            DisconnectParams dp = (DisconnectParams)o;
            if (TextUtils.equals(dp.mReason, "radioTurnedOff")) {
                discReason = 1;
            } else if (TextUtils.equals(dp.mReason, "pdpReset")) {
                discReason = 2;
            }
        }
        if (this.mPhone.mCi.getRadioState().isOn()) {
            this.log("tearDownData radio is on, call deactivateDataCall");
            this.mPhone.mCi.deactivateDataCall(this.mCid, discReason, this.obtainMessage(262147, this.mTag, 0, o));
        } else {
            this.log("tearDownData radio is off sendMessage EVENT_DEACTIVATE_DONE immediately");
            AsyncResult ar = new AsyncResult(o, null, null);
            this.sendMessage(this.obtainMessage(262147, this.mTag, 0, ar));
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllWithEvent(ApnContext alreadySent, int event, String reason) {
        this.mNetworkInfo.setDetailedState(this.mNetworkInfo.getDetailedState(), reason, this.mNetworkInfo.getExtraInfo());
        for (ApnContext apnContext : this.mApnContexts) {
            if (apnContext == alreadySent) continue;
            if (reason != null) {
                apnContext.setReason(reason);
            }
            Message msg = this.mDct.obtainMessage(event, apnContext);
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllOfConnected(String reason) {
        this.notifyAllWithEvent(null, 270336, reason);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllOfDisconnectDcRetrying(String reason) {
        this.notifyAllWithEvent(null, 270370, reason);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllDisconnectCompleted(DcFailCause cause) {
        this.notifyAllWithEvent(null, 270351, cause.toString());
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyConnectCompleted(ConnectionParams cp, DcFailCause cause, boolean sendAll) {
        ApnContext alreadySent = null;
        if (cp != null && cp.mOnCompletedMsg != null) {
            Message connectionCompletedMsg = cp.mOnCompletedMsg;
            cp.mOnCompletedMsg = null;
            if (connectionCompletedMsg.obj instanceof ApnContext) {
                alreadySent = (ApnContext)connectionCompletedMsg.obj;
            }
            CallSite timeStamp = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            connectionCompletedMsg.arg1 = this.mCid;
            if (cause == DcFailCause.NONE) {
                this.mCreateTime = (long)timeStamp;
                AsyncResult.forMessage(connectionCompletedMsg);
            } else {
                this.mLastFailCause = cause;
                this.mLastFailTime = (long)timeStamp;
                if (cause == null) {
                    cause = DcFailCause.UNKNOWN;
                }
                AsyncResult.forMessage(connectionCompletedMsg, (Object)cause, new Throwable(cause.toString()));
            }
            this.log("notifyConnectCompleted at " + (long)timeStamp + " cause=" + (Object)((Object)cause) + " connectionCompletedMsg=" + DataConnection.msgToString(connectionCompletedMsg));
            connectionCompletedMsg.sendToTarget();
        }
        if (sendAll) {
            this.notifyAllWithEvent(alreadySent, 270371, cause.toString());
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyDisconnectCompleted(DisconnectParams dp, boolean sendAll) {
        this.log("NotifyDisconnectCompleted");
        ApnContext alreadySent = null;
        String reason = null;
        if (dp != null && dp.mOnCompletedMsg != null) {
            Message msg = dp.mOnCompletedMsg;
            dp.mOnCompletedMsg = null;
            if (msg.obj instanceof ApnContext) {
                alreadySent = (ApnContext)msg.obj;
            }
            reason = dp.mReason;
            this.log(String.format("msg=%s msg.obj=%s", msg.toString(), msg.obj instanceof String ? (String)msg.obj : "<no-reason>"));
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
        if (sendAll) {
            if (reason == null) {
                reason = DcFailCause.UNKNOWN.toString();
            }
            this.notifyAllWithEvent(alreadySent, 270351, reason);
        }
        this.log("NotifyDisconnectCompleted DisconnectParams=" + dp);
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getDataConnectionId() {
        return this.mId;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$clearSettings() {
        this.log("clearSettings");
        this.mCreateTime = -1L;
        this.mLastFailTime = -1L;
        this.mLastFailCause = DcFailCause.NONE;
        this.mCid = -1;
        this.mPcscfAddr = new String[5];
        this.mLinkProperties = new LinkProperties();
        this.mApnContexts.clear();
        this.mApnSetting = null;
        this.mDcFailCause = null;
    }

    private final DataCallResponse.SetupResult $$robo$$com_android_internal_telephony_dataconnection_DataConnection$onSetupConnectionCompleted(AsyncResult ar) {
        DataCallResponse.SetupResult result;
        DataCallResponse response = (DataCallResponse)ar.result;
        ConnectionParams cp = (ConnectionParams)ar.userObj;
        if (cp.mTag != this.mTag) {
            this.log("onSetupConnectionCompleted stale cp.tag=" + cp.mTag + ", mtag=" + this.mTag);
            result = DataCallResponse.SetupResult.ERR_Stale;
        } else if (ar.exception != null) {
            this.log("onSetupConnectionCompleted failed, ar.exception=" + ar.exception + " response=" + response);
            if (ar.exception instanceof CommandException && ((CommandException)ar.exception).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE) {
                result = DataCallResponse.SetupResult.ERR_BadCommand;
                result.mFailCause = DcFailCause.RADIO_NOT_AVAILABLE;
            } else if (response == null || response.version < 4) {
                result = DataCallResponse.SetupResult.ERR_GetLastErrorFromRil;
            } else {
                result = DataCallResponse.SetupResult.ERR_RilError;
                result.mFailCause = DcFailCause.fromInt(response.status);
            }
        } else if (response.status != 0) {
            result = DataCallResponse.SetupResult.ERR_RilError;
            result.mFailCause = DcFailCause.fromInt(response.status);
        } else {
            this.log("onSetupConnectionCompleted received DataCallResponse: " + response);
            this.mCid = response.cid;
            this.mPcscfAddr = response.pcscf;
            result = this.updateLinkProperty((DataCallResponse)response).setupResult;
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isDnsOk(String[] domainNameServers) {
        if (!(!"0.0.0.0".equals(domainNameServers[0]) || !"0.0.0.0".equals(domainNameServers[1]) || this.mPhone.isDnsCheckDisabled() || this.mApnSetting.types[0].equals("mms") && this.isIpAddress(this.mApnSetting.mmsProxy))) {
            this.log(String.format("isDnsOk: return false apn.types[0]=%s APN_TYPE_MMS=%s isIpAddress(%s)=%s", this.mApnSetting.types[0], "mms", this.mApnSetting.mmsProxy, this.isIpAddress(this.mApnSetting.mmsProxy)));
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateTcpBufferSizes(int rilRat) {
        String sizes = null;
        String ratName = ServiceState.rilRadioTechnologyToString(rilRat).toLowerCase(Locale.ROOT);
        if (rilRat == 7 || rilRat == 8 || rilRat == 12) {
            ratName = "evdo";
        }
        String[] configOverride = this.mPhone.getContext().getResources().getStringArray(17236012);
        for (int i = 0; i < configOverride.length; ++i) {
            String[] split = configOverride[i].split(":");
            if (!ratName.equals(split[0]) || split.length != 2) continue;
            sizes = split[1];
            break;
        }
        if (sizes == null) {
            switch (rilRat) {
                case 1: {
                    sizes = "4092,8760,48000,4096,8760,48000";
                    break;
                }
                case 2: {
                    sizes = "4093,26280,70800,4096,16384,70800";
                    break;
                }
                case 3: {
                    sizes = "58254,349525,1048576,58254,349525,1048576";
                    break;
                }
                case 6: {
                    sizes = "16384,32768,131072,4096,16384,102400";
                    break;
                }
                case 7: 
                case 8: 
                case 12: {
                    sizes = "4094,87380,262144,4096,16384,262144";
                    break;
                }
                case 13: {
                    sizes = "131072,262144,1048576,4096,16384,524288";
                    break;
                }
                case 9: {
                    sizes = "61167,367002,1101005,8738,52429,262114";
                    break;
                }
                case 10: 
                case 11: {
                    sizes = "40778,244668,734003,16777,100663,301990";
                    break;
                }
                case 14: {
                    sizes = "524288,1048576,2097152,262144,524288,1048576";
                    break;
                }
                case 15: {
                    sizes = "122334,734003,2202010,32040,192239,576717";
                    break;
                }
            }
        }
        this.mLinkProperties.setTcpBufferSizes(sizes);
    }

    private final NetworkCapabilities $$robo$$com_android_internal_telephony_dataconnection_DataConnection$makeNetworkCapabilities() {
        NetworkCapabilities result = new NetworkCapabilities();
        result.addTransportType(0);
        if (this.mApnSetting != null) {
            String[] arr$ = this.mApnSetting.types;
            int len$ = arr$.length;
            block38: for (int i$ = 0; i$ < len$; ++i$) {
                String type;
                switch (type = arr$[i$]) {
                    case "*": {
                        result.addCapability(12);
                        result.addCapability(0);
                        result.addCapability(1);
                        result.addCapability(3);
                        result.addCapability(4);
                        result.addCapability(5);
                        result.addCapability(7);
                        continue block38;
                    }
                    case "default": {
                        result.addCapability(12);
                        continue block38;
                    }
                    case "mms": {
                        result.addCapability(0);
                        continue block38;
                    }
                    case "supl": {
                        result.addCapability(1);
                        continue block38;
                    }
                    case "dun": {
                        ApnSetting securedDunApn = this.mDct.fetchDunApn();
                        if (securedDunApn != null && !securedDunApn.equals(this.mApnSetting)) continue block38;
                        result.addCapability(2);
                        continue block38;
                    }
                    case "fota": {
                        result.addCapability(3);
                        continue block38;
                    }
                    case "ims": {
                        result.addCapability(4);
                        continue block38;
                    }
                    case "cbs": {
                        result.addCapability(5);
                        continue block38;
                    }
                    case "ia": {
                        result.addCapability(7);
                        continue block38;
                    }
                }
            }
            ConnectivityManager.maybeMarkCapabilitiesRestricted(result);
        }
        int up = 14;
        int down = 14;
        switch (this.mRilRat) {
            case 1: {
                up = 80;
                down = 80;
                break;
            }
            case 2: {
                up = 59;
                down = 236;
                break;
            }
            case 3: {
                up = 384;
                down = 384;
                break;
            }
            case 4: 
            case 5: {
                up = 14;
                down = 14;
                break;
            }
            case 7: {
                up = 153;
                down = 2457;
                break;
            }
            case 8: {
                up = 1843;
                down = 3174;
                break;
            }
            case 6: {
                up = 100;
                down = 100;
                break;
            }
            case 9: {
                up = 2048;
                down = 14336;
                break;
            }
            case 10: {
                up = 5898;
                down = 14336;
                break;
            }
            case 11: {
                up = 5898;
                down = 14336;
                break;
            }
            case 12: {
                up = 1843;
                down = 5017;
                break;
            }
            case 14: {
                up = 51200;
                down = 102400;
                break;
            }
            case 13: {
                up = 153;
                down = 2516;
                break;
            }
            case 15: {
                up = 11264;
                down = 43008;
                break;
            }
        }
        result.setLinkUpstreamBandwidthKbps(up);
        result.setLinkDownstreamBandwidthKbps(down);
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpAddress(String address) {
        if (address == null) {
            return false;
        }
        return Patterns.IP_ADDRESS.matcher(address).matches();
    }

    private final DataCallResponse.SetupResult $$robo$$com_android_internal_telephony_dataconnection_DataConnection$setLinkProperties(DataCallResponse response, LinkProperties lp) {
        boolean okToUseSystemPropertyDns = false;
        String propertyPrefix = "net." + response.ifname + ".";
        String[] dnsServers = new String[]{SystemProperties.get(propertyPrefix + "dns1"), SystemProperties.get(propertyPrefix + "dns2")};
        okToUseSystemPropertyDns = this.isDnsOk(dnsServers);
        return response.setLinkProperties(lp, okToUseSystemPropertyDns);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$initConnection(ConnectionParams cp) {
        ApnContext apnContext = cp.mApnContext;
        if (this.mApnSetting == null) {
            this.mApnSetting = apnContext.getApnSetting();
        } else if (!this.mApnSetting.canHandleType(apnContext.getApnType())) {
            this.log("initConnection: incompatible apnSetting in ConnectionParams cp=" + cp + " dc=" + this);
            return false;
        }
        ++this.mTag;
        this.mConnectionParams = cp;
        this.mConnectionParams.mTag = this.mTag;
        if (!this.mApnContexts.contains(apnContext)) {
            this.mApnContexts.add(apnContext);
        }
        this.configureRetry(this.mApnSetting.canHandleType("default"));
        this.mRetryManager.setRetryCount(0);
        this.mRetryManager.setCurMaxRetryCount(this.mConnectionParams.mInitialMaxRetry);
        this.mRetryManager.setRetryForever(false);
        this.log("initConnection:  RefCount=" + this.mApnContexts.size() + " mApnList=" + this.mApnContexts + " mConnectionParams=" + this.mConnectionParams);
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$tearDownNow() {
        this.log("tearDownNow()");
        this.sendMessage(this.obtainMessage(262152));
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getWhatToString(int what) {
        return DataConnection.cmdToString(what);
    }

    private static final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$msgToString(Message msg) {
        String retVal;
        if (msg == null) {
            retVal = "null";
        } else {
            StringBuilder b = new StringBuilder();
            b.append("{what=");
            b.append(DataConnection.cmdToString(msg.what));
            b.append(" when=");
            TimeUtils.formatDuration(msg.getWhen() - SystemClock.uptimeMillis(), b);
            if (msg.arg1 != 0) {
                b.append(" arg1=");
                b.append(msg.arg1);
            }
            if (msg.arg2 != 0) {
                b.append(" arg2=");
                b.append(msg.arg2);
            }
            if (msg.obj != null) {
                b.append(" obj=");
                b.append(msg.obj);
            }
            b.append(" target=");
            b.append(msg.getTarget());
            b.append(" replyTo=");
            b.append(msg.replyTo);
            b.append("}");
            retVal = b.toString();
        }
        return retVal;
    }

    private static final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$slog(String s) {
        Rlog.d("DC", s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$log(String s) {
        Rlog.d(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logd(String s) {
        Rlog.d(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logv(String s) {
        Rlog.v(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logi(String s) {
        Rlog.i(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logw(String s) {
        Rlog.w(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$loge(String s) {
        Rlog.e(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$loge(String s, Throwable e) {
        Rlog.e(this.getName(), s, e);
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$toStringSimple() {
        return this.getName() + ": State=" + this.getCurrentState().getName() + " mApnSetting=" + this.mApnSetting + " RefCount=" + this.mApnContexts.size() + " mCid=" + this.mCid + " mCreateTime=" + this.mCreateTime + " mLastastFailTime=" + this.mLastFailTime + " mLastFailCause=" + (Object)((Object)this.mLastFailCause) + " mTag=" + this.mTag + " mRetryManager=" + this.mRetryManager + " mLinkProperties=" + this.mLinkProperties + " linkCapabilities=" + this.makeNetworkCapabilities();
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$toString() {
        return "{" + this.toStringSimple() + " mApnContexts=" + this.mApnContexts + "}";
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.print("DataConnection ");
        super.dump(fd, pw, args);
        pw.println(" mApnContexts.size=" + this.mApnContexts.size());
        pw.println(" mApnContexts=" + this.mApnContexts);
        pw.flush();
        pw.println(" mDataConnectionTracker=" + this.mDct);
        pw.println(" mApnSetting=" + this.mApnSetting);
        pw.println(" mTag=" + this.mTag);
        pw.println(" mCid=" + this.mCid);
        pw.println(" mRetryManager=" + this.mRetryManager);
        pw.println(" mConnectionParams=" + this.mConnectionParams);
        pw.println(" mDisconnectParams=" + this.mDisconnectParams);
        pw.println(" mDcFailCause=" + (Object)((Object)this.mDcFailCause));
        pw.flush();
        pw.println(" mPhone=" + this.mPhone);
        pw.flush();
        pw.println(" mLinkProperties=" + this.mLinkProperties);
        pw.flush();
        pw.println(" mDataRegState=" + this.mDataRegState);
        pw.println(" mRilRat=" + this.mRilRat);
        pw.println(" mNetworkCapabilities=" + this.makeNetworkCapabilities());
        pw.println(" mCreateTime=" + TimeUtils.logTimeOfDay(this.mCreateTime));
        pw.println(" mLastFailTime=" + TimeUtils.logTimeOfDay(this.mLastFailTime));
        pw.println(" mLastFailCause=" + (Object)((Object)this.mLastFailCause));
        pw.flush();
        pw.println(" mUserData=" + this.mUserData);
        pw.println(" mInstanceNumber=" + mInstanceNumber);
        pw.println(" mAc=" + this.mAc);
        pw.println(" mDcRetryAlarmController=" + this.mDcRetryAlarmController);
        pw.flush();
    }

    static void __staticInitializer__() {
        mInstanceNumber = new AtomicInteger(0);
        sCmdToString = new String[14];
        DataConnection.sCmdToString[0] = "EVENT_CONNECT";
        DataConnection.sCmdToString[1] = "EVENT_SETUP_DATA_CONNECTION_DONE";
        DataConnection.sCmdToString[2] = "EVENT_GET_LAST_FAIL_DONE";
        DataConnection.sCmdToString[3] = "EVENT_DEACTIVATE_DONE";
        DataConnection.sCmdToString[4] = "EVENT_DISCONNECT";
        DataConnection.sCmdToString[5] = "EVENT_RIL_CONNECTED";
        DataConnection.sCmdToString[6] = "EVENT_DISCONNECT_ALL";
        DataConnection.sCmdToString[7] = "EVENT_DATA_STATE_CHANGED";
        DataConnection.sCmdToString[8] = "EVENT_TEAR_DOWN_NOW";
        DataConnection.sCmdToString[9] = "EVENT_LOST_CONNECTION";
        DataConnection.sCmdToString[10] = "EVENT_RETRY_CONNECTION";
        DataConnection.sCmdToString[11] = "EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED";
        DataConnection.sCmdToString[12] = "EVENT_DATA_CONNECTION_ROAM_ON";
        DataConnection.sCmdToString[13] = "EVENT_DATA_CONNECTION_ROAM_OFF";
    }

    static String cmdToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("cmdToString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$cmdToString(int ), 0, (int)n);
    }

    static DataConnection makeDataConnection(PhoneBase phoneBase, int n, DcTrackerBase dcTrackerBase, DcTesterFailBringUpAll dcTesterFailBringUpAll, DcController dcController) {
        return InvokeDynamicSupport.bootstrapStatic("makeDataConnection", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$makeDataConnection(com.android.internal.telephony.PhoneBase int com.android.internal.telephony.dataconnection.DcTrackerBase com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll com.android.internal.telephony.dataconnection.DcController ), 0, (PhoneBase)phoneBase, (int)n, (DcTrackerBase)dcTrackerBase, (DcTesterFailBringUpAll)dcTesterFailBringUpAll, (DcController)dcController);
    }

    void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$dispose(), 0, this);
    }

    NetworkCapabilities getCopyNetworkCapabilities() {
        return InvokeDynamicSupport.bootstrap("getCopyNetworkCapabilities", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getCopyNetworkCapabilities(), 0, this);
    }

    LinkProperties getCopyLinkProperties() {
        return InvokeDynamicSupport.bootstrap("getCopyLinkProperties", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getCopyLinkProperties(), 0, this);
    }

    boolean getIsInactive() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIsInactive", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getIsInactive(), 0, this);
    }

    int getCid() {
        return (int)InvokeDynamicSupport.bootstrap("getCid", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getCid(), 0, this);
    }

    ApnSetting getApnSetting() {
        return InvokeDynamicSupport.bootstrap("getApnSetting", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getApnSetting(), 0, this);
    }

    void setLinkPropertiesHttpProxy(ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setLinkPropertiesHttpProxy", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$setLinkPropertiesHttpProxy(android.net.ProxyInfo ), 0, this, proxyInfo);
    }

    public boolean isIpv4Connected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIpv4Connected", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpv4Connected(), 0, this);
    }

    public boolean isIpv6Connected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIpv6Connected", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpv6Connected(), 0, this);
    }

    UpdateLinkPropertyResult updateLinkProperty(DataCallResponse dataCallResponse) {
        return InvokeDynamicSupport.bootstrap("updateLinkProperty", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateLinkProperty(com.android.internal.telephony.dataconnection.DataCallResponse ), 0, this, dataCallResponse);
    }

    private void checkSetMtu(ApnSetting apnSetting, LinkProperties linkProperties) {
        InvokeDynamicSupport.bootstrap("checkSetMtu", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$checkSetMtu(com.android.internal.telephony.dataconnection.ApnSetting android.net.LinkProperties ), 0, this, apnSetting, linkProperties);
    }

    private void __constructor__(PhoneBase phoneBase, String string2, int n, DcTrackerBase dcTrackerBase, DcTesterFailBringUpAll dcTesterFailBringUpAll, DcController dcController) {
        this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection$__constructor__(phoneBase, string2, n, dcTrackerBase, dcTesterFailBringUpAll, dcController);
    }

    private DataConnection(PhoneBase phoneBase, String string2, int n, DcTrackerBase dcTrackerBase, DcTesterFailBringUpAll dcTesterFailBringUpAll, DcController dcController) {
        super(string2, dcController.getHandler());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$__constructor__(com.android.internal.telephony.PhoneBase java.lang.String int com.android.internal.telephony.dataconnection.DcTrackerBase com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll com.android.internal.telephony.dataconnection.DcController ), 0, this, phoneBase, string2, n, dcTrackerBase, dcTesterFailBringUpAll, dcController);
    }

    private String getRetryConfig(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getRetryConfig", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getRetryConfig(boolean ), 0, this, bl);
    }

    private void configureRetry(boolean bl) {
        InvokeDynamicSupport.bootstrap("configureRetry", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$configureRetry(boolean ), 0, this, bl);
    }

    private void onConnect(ConnectionParams connectionParams) {
        InvokeDynamicSupport.bootstrap("onConnect", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$onConnect(com.android.internal.telephony.dataconnection.DataConnection$ConnectionParams ), 0, this, connectionParams);
    }

    private void tearDownData(Object object) {
        InvokeDynamicSupport.bootstrap("tearDownData", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$tearDownData(java.lang.Object ), 0, this, object);
    }

    private void notifyAllWithEvent(ApnContext apnContext, int n, String string2) {
        InvokeDynamicSupport.bootstrap("notifyAllWithEvent", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllWithEvent(com.android.internal.telephony.dataconnection.ApnContext int java.lang.String ), 0, this, apnContext, n, string2);
    }

    private void notifyAllOfConnected(String string2) {
        InvokeDynamicSupport.bootstrap("notifyAllOfConnected", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllOfConnected(java.lang.String ), 0, this, string2);
    }

    private void notifyAllOfDisconnectDcRetrying(String string2) {
        InvokeDynamicSupport.bootstrap("notifyAllOfDisconnectDcRetrying", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllOfDisconnectDcRetrying(java.lang.String ), 0, this, string2);
    }

    private void notifyAllDisconnectCompleted(DcFailCause dcFailCause) {
        InvokeDynamicSupport.bootstrap("notifyAllDisconnectCompleted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllDisconnectCompleted(com.android.internal.telephony.dataconnection.DcFailCause ), 0, this, dcFailCause);
    }

    private void notifyConnectCompleted(ConnectionParams connectionParams, DcFailCause dcFailCause, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyConnectCompleted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyConnectCompleted(com.android.internal.telephony.dataconnection.DataConnection$ConnectionParams com.android.internal.telephony.dataconnection.DcFailCause boolean ), 0, this, connectionParams, dcFailCause, bl);
    }

    private void notifyDisconnectCompleted(DisconnectParams disconnectParams, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyDisconnectCompleted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyDisconnectCompleted(com.android.internal.telephony.dataconnection.DataConnection$DisconnectParams boolean ), 0, this, disconnectParams, bl);
    }

    public int getDataConnectionId() {
        return (int)InvokeDynamicSupport.bootstrap("getDataConnectionId", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getDataConnectionId(), 0, this);
    }

    private void clearSettings() {
        InvokeDynamicSupport.bootstrap("clearSettings", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$clearSettings(), 0, this);
    }

    private DataCallResponse.SetupResult onSetupConnectionCompleted(AsyncResult asyncResult) {
        return InvokeDynamicSupport.bootstrap("onSetupConnectionCompleted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$onSetupConnectionCompleted(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private boolean isDnsOk(String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDnsOk", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isDnsOk(java.lang.String[] ), 0, this, stringArray);
    }

    private void updateTcpBufferSizes(int n) {
        InvokeDynamicSupport.bootstrap("updateTcpBufferSizes", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateTcpBufferSizes(int ), 0, this, n);
    }

    private NetworkCapabilities makeNetworkCapabilities() {
        return InvokeDynamicSupport.bootstrap("makeNetworkCapabilities", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$makeNetworkCapabilities(), 0, this);
    }

    private boolean isIpAddress(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIpAddress", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpAddress(java.lang.String ), 0, this, string2);
    }

    private DataCallResponse.SetupResult setLinkProperties(DataCallResponse dataCallResponse, LinkProperties linkProperties) {
        return InvokeDynamicSupport.bootstrap("setLinkProperties", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$setLinkProperties(com.android.internal.telephony.dataconnection.DataCallResponse android.net.LinkProperties ), 0, this, dataCallResponse, linkProperties);
    }

    private boolean initConnection(ConnectionParams connectionParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("initConnection", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$initConnection(com.android.internal.telephony.dataconnection.DataConnection$ConnectionParams ), 0, this, connectionParams);
    }

    void tearDownNow() {
        InvokeDynamicSupport.bootstrap("tearDownNow", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$tearDownNow(), 0, this);
    }

    @Override
    protected String getWhatToString(int n) {
        return InvokeDynamicSupport.bootstrap("getWhatToString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getWhatToString(int ), 0, this, n);
    }

    private static String msgToString(Message message) {
        return InvokeDynamicSupport.bootstrapStatic("msgToString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$msgToString(android.os.Message ), 0, (Message)message);
    }

    static void slog(String string2) {
        InvokeDynamicSupport.bootstrapStatic("slog", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$slog(java.lang.String ), 0, (String)string2);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$log(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void logd(String string2) {
        InvokeDynamicSupport.bootstrap("logd", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logd(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void logv(String string2) {
        InvokeDynamicSupport.bootstrap("logv", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logv(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void logi(String string2) {
        InvokeDynamicSupport.bootstrap("logi", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logi(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void logw(String string2) {
        InvokeDynamicSupport.bootstrap("logw", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logw(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$loge(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void loge(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$loge(java.lang.String java.lang.Throwable ), 0, this, string2, throwable);
    }

    public String toStringSimple() {
        return InvokeDynamicSupport.bootstrap("toStringSimple", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$toStringSimple(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$toString(), 0, this);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(DataConnection.class);
    }

    public /* synthetic */ DataConnection() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class DcNetworkAgent
    extends NetworkAgent
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$__constructor__(DataConnection dataConnection, Looper l, Context c, String TAG, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$unwanted() {
            if (this.this$0.mNetworkAgent != this) {
                this.log("unwanted found mNetworkAgent=" + this.this$0.mNetworkAgent + ", which isn't me.  Aborting unwanted");
                return;
            }
            if (this.this$0.mApnContexts == null) {
                return;
            }
            for (ApnContext apnContext : this.this$0.mApnContexts) {
                Message msg = this.this$0.mDct.obtainMessage(270351, apnContext);
                DisconnectParams dp = new DisconnectParams(apnContext, apnContext.getReason(), msg);
                this.this$0.sendMessage(this.this$0.obtainMessage(262148, dp));
            }
        }

        private void __constructor__(DataConnection dataConnection, Looper looper, Context context, String string2, NetworkInfo networkInfo, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, int n) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$__constructor__(dataConnection, looper, context, string2, networkInfo, networkCapabilities, linkProperties, n);
        }

        public DcNetworkAgent(DataConnection dataConnection, Looper looper, Context context, String string2, NetworkInfo networkInfo, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, int n) {
            this.this$0 = dataConnection;
            super(looper, context, string2, networkInfo, networkCapabilities, linkProperties, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$__constructor__(com.android.internal.telephony.dataconnection.DataConnection android.os.Looper android.content.Context java.lang.String android.net.NetworkInfo android.net.NetworkCapabilities android.net.LinkProperties int ), 0, this, dataConnection, looper, context, string2, networkInfo, networkCapabilities, linkProperties, n);
        }

        @Override
        protected void unwanted() {
            InvokeDynamicSupport.bootstrap("unwanted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$unwanted(), 0, this);
        }

        public /* synthetic */ DcNetworkAgent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcNetworkAgent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcDisconnectionErrorCreatingConnection
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(DataConnection dataConnection) {
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262147: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    if (cp.mTag == this.this$0.mTag) {
                        this.this$0.log("DcDisconnectionErrorCreatingConnection msg.what=EVENT_DEACTIVATE_DONE");
                        this.this$0.mInactiveState.setEnterNotificationParams(cp, DcFailCause.UNACCEPTABLE_NETWORK_PARAMETER);
                        this.this$0.transitionTo(this.this$0.mInactiveState);
                    } else {
                        this.this$0.log("DcDisconnectionErrorCreatingConnection stale EVENT_DEACTIVATE_DONE dp.tag=" + cp.mTag + ", mTag=" + this.this$0.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcDisconnectionErrorCreatingConnection not handled msg.what=" + this.this$0.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(dataConnection);
        }

        private DcDisconnectionErrorCreatingConnection(DataConnection dataConnection) {
            this.this$0 = dataConnection;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), 0, this, dataConnection);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcDisconnectionErrorCreatingConnection() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcDisconnectionErrorCreatingConnection)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcDisconnectingState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(DataConnection dataConnection) {
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    this.this$0.log("DcDisconnectingState msg.what=EVENT_CONNECT. Defer. RefCount = " + this.this$0.mApnContexts.size());
                    this.this$0.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 262147: {
                    this.this$0.log("DcDisconnectingState msg.what=EVENT_DEACTIVATE_DONE RefCount=" + this.this$0.mApnContexts.size());
                    AsyncResult ar = (AsyncResult)msg.obj;
                    DisconnectParams dp = (DisconnectParams)ar.userObj;
                    if (dp.mTag == this.this$0.mTag) {
                        this.this$0.mInactiveState.setEnterNotificationParams((DisconnectParams)ar.userObj);
                        this.this$0.transitionTo(this.this$0.mInactiveState);
                    } else {
                        this.this$0.log("DcDisconnectState stale EVENT_DEACTIVATE_DONE dp.tag=" + dp.mTag + " mTag=" + this.this$0.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcDisconnectingState not handled msg.what=" + this.this$0.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(dataConnection);
        }

        private DcDisconnectingState(DataConnection dataConnection) {
            this.this$0 = dataConnection;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), 0, this, dataConnection);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcDisconnectingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcDisconnectingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcActiveState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(DataConnection dataConnection) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$enter() {
            this.this$0.log("DcActiveState: enter dc=" + this.this$0);
            if (this.this$0.mRetryManager.getRetryCount() != 0) {
                this.this$0.log("DcActiveState: connected after retrying call notifyAllOfConnected");
                this.this$0.mRetryManager.setRetryCount(0);
            }
            this.this$0.notifyAllOfConnected("connected");
            this.this$0.mRetryManager.restoreCurMaxRetryCount();
            this.this$0.mDcController.addActiveDcByCid(this.this$0);
            this.this$0.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, this.this$0.mNetworkInfo.getReason(), null);
            this.this$0.mNetworkInfo.setExtraInfo(((DataConnection)this.this$0).mApnSetting.apn);
            this.this$0.updateTcpBufferSizes(this.this$0.mRilRat);
            this.this$0.mNetworkAgent = new DcNetworkAgent(this.this$0, this.this$0.getHandler().getLooper(), this.this$0.mPhone.getContext(), "DcNetworkAgent", this.this$0.mNetworkInfo, this.this$0.makeNetworkCapabilities(), this.this$0.mLinkProperties, 50);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$exit() {
            this.this$0.log("DcActiveState: exit dc=" + this);
            this.this$0.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, this.this$0.mNetworkInfo.getReason(), this.this$0.mNetworkInfo.getExtraInfo());
            this.this$0.mNetworkAgent.sendNetworkInfo(this.this$0.mNetworkInfo);
            this.this$0.mNetworkAgent = null;
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    this.this$0.log("DcActiveState: EVENT_CONNECT cp=" + cp + " dc=" + this.this$0);
                    if (this.this$0.mApnContexts.contains(cp.mApnContext)) {
                        this.this$0.log("DcActiveState ERROR already added apnContext=" + cp.mApnContext);
                    } else {
                        this.this$0.mApnContexts.add(cp.mApnContext);
                        this.this$0.log("DcActiveState msg.what=EVENT_CONNECT RefCount=" + this.this$0.mApnContexts.size());
                    }
                    this.this$0.notifyConnectCompleted(cp, DcFailCause.NONE, false);
                    retVal = true;
                    break;
                }
                case 262148: {
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    this.this$0.log("DcActiveState: EVENT_DISCONNECT dp=" + dp + " dc=" + this.this$0);
                    if (this.this$0.mApnContexts.contains(dp.mApnContext)) {
                        this.this$0.log("DcActiveState msg.what=EVENT_DISCONNECT RefCount=" + this.this$0.mApnContexts.size());
                        if (this.this$0.mApnContexts.size() == 1) {
                            this.this$0.mApnContexts.clear();
                            this.this$0.mDisconnectParams = dp;
                            this.this$0.mConnectionParams = null;
                            dp.mTag = this.this$0.mTag;
                            this.this$0.tearDownData(dp);
                            this.this$0.transitionTo(this.this$0.mDisconnectingState);
                        } else {
                            this.this$0.mApnContexts.remove(dp.mApnContext);
                            this.this$0.notifyDisconnectCompleted(dp, false);
                        }
                    } else {
                        this.this$0.log("DcActiveState ERROR no such apnContext=" + dp.mApnContext + " in this dc=" + this.this$0);
                        this.this$0.notifyDisconnectCompleted(dp, false);
                    }
                    retVal = true;
                    break;
                }
                case 262150: {
                    this.this$0.log("DcActiveState EVENT_DISCONNECT clearing apn contexts, dc=" + this.this$0);
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    this.this$0.mDisconnectParams = dp;
                    this.this$0.mConnectionParams = null;
                    dp.mTag = this.this$0.mTag;
                    this.this$0.tearDownData(dp);
                    this.this$0.transitionTo(this.this$0.mDisconnectingState);
                    retVal = true;
                    break;
                }
                case 262153: {
                    this.this$0.log("DcActiveState EVENT_LOST_CONNECTION dc=" + this.this$0);
                    if (this.this$0.mRetryManager.isRetryNeeded()) {
                        int delayMillis = this.this$0.mRetryManager.getRetryTimer();
                        this.this$0.log("DcActiveState EVENT_LOST_CONNECTION startRetryAlarm mTag=" + this.this$0.mTag + " delay=" + delayMillis + "ms");
                        this.this$0.mDcRetryAlarmController.startRetryAlarm(262154, this.this$0.mTag, delayMillis);
                        this.this$0.transitionTo(this.this$0.mRetryingState);
                    } else {
                        this.this$0.mInactiveState.setEnterNotificationParams(DcFailCause.LOST_CONNECTION);
                        this.this$0.transitionTo(this.this$0.mInactiveState);
                    }
                    retVal = true;
                    break;
                }
                case 262156: {
                    this.this$0.mNetworkInfo.setRoaming(true);
                    this.this$0.mNetworkAgent.sendNetworkInfo(this.this$0.mNetworkInfo);
                    retVal = true;
                    break;
                }
                case 262157: {
                    this.this$0.mNetworkInfo.setRoaming(false);
                    this.this$0.mNetworkAgent.sendNetworkInfo(this.this$0.mNetworkInfo);
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcActiveState not handled msg.what=" + this.this$0.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(dataConnection);
        }

        private DcActiveState(DataConnection dataConnection) {
            this.this$0 = dataConnection;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), 0, this, dataConnection);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$enter(), 0, this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$exit(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcActiveState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcActiveState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcActivatingState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(DataConnection dataConnection) {
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$processMessage(Message msg) {
            boolean retVal;
            this.this$0.log("DcActivatingState: msg=" + DataConnection.msgToString(msg));
            switch (msg.what) {
                case 262144: 
                case 262155: {
                    this.this$0.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 262145: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    DataCallResponse.SetupResult result = this.this$0.onSetupConnectionCompleted(ar);
                    if (result != DataCallResponse.SetupResult.ERR_Stale && this.this$0.mConnectionParams != cp) {
                        this.this$0.loge("DcActivatingState: WEIRD mConnectionsParams:" + this.this$0.mConnectionParams + " != cp:" + cp);
                    }
                    this.this$0.log("DcActivatingState onSetupConnectionCompleted result=" + (Object)((Object)result) + " dc=" + this.this$0);
                    switch (1.$SwitchMap$com$android$internal$telephony$dataconnection$DataCallResponse$SetupResult[result.ordinal()]) {
                        case 1: {
                            this.this$0.mDcFailCause = DcFailCause.NONE;
                            this.this$0.transitionTo(this.this$0.mActiveState);
                            break;
                        }
                        case 2: {
                            this.this$0.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            this.this$0.transitionTo(this.this$0.mInactiveState);
                            break;
                        }
                        case 3: {
                            this.this$0.tearDownData(cp);
                            this.this$0.transitionTo(this.this$0.mDisconnectingErrorCreatingConnection);
                            break;
                        }
                        case 4: {
                            ((DataConnection)this.this$0).mPhone.mCi.getLastDataCallFailCause(this.this$0.obtainMessage(262146, cp));
                            break;
                        }
                        case 5: {
                            int delay = this.this$0.mDcRetryAlarmController.getSuggestedRetryTime(this.this$0, ar);
                            this.this$0.log("DcActivatingState: ERR_RilError  delay=" + delay + " isRetryNeeded=" + this.this$0.mRetryManager.isRetryNeeded() + " result=" + (Object)((Object)result) + " result.isRestartRadioFail=" + result.mFailCause.isRestartRadioFail() + " result.isPermanentFail=" + this.this$0.mDct.isPermanentFail(result.mFailCause));
                            if (result.mFailCause.isRestartRadioFail()) {
                                this.this$0.log("DcActivatingState: ERR_RilError restart radio");
                                this.this$0.mDct.sendRestartRadio();
                                this.this$0.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                                this.this$0.transitionTo(this.this$0.mInactiveState);
                                break;
                            }
                            if (this.this$0.mDct.isPermanentFail(result.mFailCause)) {
                                this.this$0.log("DcActivatingState: ERR_RilError perm error");
                                this.this$0.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                                this.this$0.transitionTo(this.this$0.mInactiveState);
                                break;
                            }
                            if (delay >= 0) {
                                this.this$0.log("DcActivatingState: ERR_RilError retry");
                                this.this$0.mDcRetryAlarmController.startRetryAlarm(262154, this.this$0.mTag, delay);
                                this.this$0.transitionTo(this.this$0.mRetryingState);
                                break;
                            }
                            this.this$0.log("DcActivatingState: ERR_RilError no retry");
                            this.this$0.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            this.this$0.transitionTo(this.this$0.mInactiveState);
                            break;
                        }
                        case 6: {
                            this.this$0.loge("DcActivatingState: stale EVENT_SETUP_DATA_CONNECTION_DONE tag:" + cp.mTag + " != mTag:" + this.this$0.mTag);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown SetupResult, should not happen");
                        }
                    }
                    retVal = true;
                    break;
                }
                case 262146: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    if (cp.mTag == this.this$0.mTag) {
                        int rilFailCause;
                        if (this.this$0.mConnectionParams != cp) {
                            this.this$0.loge("DcActivatingState: WEIRD mConnectionsParams:" + this.this$0.mConnectionParams + " != cp:" + cp);
                        }
                        DcFailCause cause = DcFailCause.UNKNOWN;
                        if (ar.exception == null && (cause = DcFailCause.fromInt(rilFailCause = ((int[])ar.result)[0])) == DcFailCause.NONE) {
                            this.this$0.log("DcActivatingState msg.what=EVENT_GET_LAST_FAIL_DONE BAD: error was NONE, change to UNKNOWN");
                            cause = DcFailCause.UNKNOWN;
                        }
                        this.this$0.mDcFailCause = cause;
                        int retryDelay = this.this$0.mRetryManager.getRetryTimer();
                        this.this$0.log("DcActivatingState msg.what=EVENT_GET_LAST_FAIL_DONE cause=" + (Object)((Object)cause) + " retryDelay=" + retryDelay + " isRetryNeeded=" + this.this$0.mRetryManager.isRetryNeeded() + " dc=" + this.this$0);
                        if (cause.isRestartRadioFail()) {
                            this.this$0.log("DcActivatingState: EVENT_GET_LAST_FAIL_DONE restart radio");
                            this.this$0.mDct.sendRestartRadio();
                            this.this$0.mInactiveState.setEnterNotificationParams(cp, cause);
                            this.this$0.transitionTo(this.this$0.mInactiveState);
                        } else if (this.this$0.mDct.isPermanentFail(cause)) {
                            this.this$0.log("DcActivatingState: EVENT_GET_LAST_FAIL_DONE perm er");
                            this.this$0.mInactiveState.setEnterNotificationParams(cp, cause);
                            this.this$0.transitionTo(this.this$0.mInactiveState);
                        } else if (retryDelay >= 0 && this.this$0.mRetryManager.isRetryNeeded()) {
                            this.this$0.log("DcActivatingState: EVENT_GET_LAST_FAIL_DONE retry");
                            this.this$0.mDcRetryAlarmController.startRetryAlarm(262154, this.this$0.mTag, retryDelay);
                            this.this$0.transitionTo(this.this$0.mRetryingState);
                        } else {
                            this.this$0.log("DcActivatingState: EVENT_GET_LAST_FAIL_DONE no retry");
                            this.this$0.mInactiveState.setEnterNotificationParams(cp, cause);
                            this.this$0.transitionTo(this.this$0.mInactiveState);
                        }
                    } else {
                        this.this$0.loge("DcActivatingState: stale EVENT_GET_LAST_FAIL_DONE tag:" + cp.mTag + " != mTag:" + this.this$0.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcActivatingState not handled msg.what=" + this.this$0.getWhatToString(msg.what) + " RefCount=" + this.this$0.mApnContexts.size());
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(dataConnection);
        }

        private DcActivatingState(DataConnection dataConnection) {
            this.this$0 = dataConnection;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), 0, this, dataConnection);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcActivatingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcActivatingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcRetryingState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcRetryingState$__constructor__(DataConnection dataConnection) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcRetryingState$enter() {
            if (((DataConnection)this.this$0).mConnectionParams.mRilRat != this.this$0.mRilRat || this.this$0.mDataRegState != 0) {
                String s = "DcRetryingState: enter() not retrying rat changed, mConnectionParams.mRilRat=" + ((DataConnection)this.this$0).mConnectionParams.mRilRat + " != mRilRat:" + this.this$0.mRilRat + " transitionTo(mInactiveState)";
                this.this$0.logAndAddLogRec(s);
                this.this$0.mInactiveState.setEnterNotificationParams(DcFailCause.LOST_CONNECTION);
                this.this$0.transitionTo(this.this$0.mInactiveState);
            } else {
                this.this$0.log("DcRetryingState: enter() mTag=" + this.this$0.mTag + ", call notifyAllOfDisconnectDcRetrying lostConnection");
                this.this$0.notifyAllOfDisconnectDcRetrying("lostDataConnection");
                this.this$0.mDcController.removeActiveDcByCid(this.this$0);
                this.this$0.mCid = -1;
            }
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcRetryingState$processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262155: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Pair drsRatPair = (Pair)ar.result;
                    int drs = (Integer)drsRatPair.first;
                    int rat = (Integer)drsRatPair.second;
                    if (rat == this.this$0.mRilRat && drs == this.this$0.mDataRegState) {
                        this.this$0.log("DcRetryingState: EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED strange no change in drs=" + drs + " rat=" + rat + " ignoring");
                    } else {
                        if (((DataConnection)this.this$0).mConnectionParams.mRetryWhenSSChange) {
                            retVal = false;
                            break;
                        }
                        this.this$0.mInactiveState.setEnterNotificationParams(DcFailCause.LOST_CONNECTION);
                        this.this$0.deferMessage(msg);
                        this.this$0.transitionTo(this.this$0.mInactiveState);
                        String s = "DcRetryingState: EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED giving up changed from " + this.this$0.mRilRat + " to rat=" + rat + " or drs changed from " + this.this$0.mDataRegState + " to drs=" + drs;
                        this.this$0.logAndAddLogRec(s);
                        this.this$0.mDataRegState = drs;
                        this.this$0.mRilRat = rat;
                        ServiceState ss = this.this$0.mPhone.getServiceState();
                        int networkType = ss.getDataNetworkType();
                        this.this$0.mNetworkInfo.setSubtype(networkType, TelephonyManager.getNetworkTypeName(networkType));
                    }
                    retVal = true;
                    break;
                }
                case 262154: {
                    if (msg.arg1 == this.this$0.mTag) {
                        this.this$0.mRetryManager.increaseRetryCount();
                        this.this$0.log("DcRetryingState EVENT_RETRY_CONNECTION RetryCount=" + this.this$0.mRetryManager.getRetryCount() + " mConnectionParams=" + this.this$0.mConnectionParams);
                        this.this$0.onConnect(this.this$0.mConnectionParams);
                        this.this$0.transitionTo(this.this$0.mActivatingState);
                    } else {
                        this.this$0.log("DcRetryingState stale EVENT_RETRY_CONNECTION tag:" + msg.arg1 + " != mTag:" + this.this$0.mTag);
                    }
                    retVal = true;
                    break;
                }
                case 266252: {
                    this.this$0.log("DcRetryingState: msg.what=RSP_RESET, ignore we're already reset");
                    this.this$0.mInactiveState.setEnterNotificationParams(this.this$0.mConnectionParams, DcFailCause.RESET_BY_FRAMEWORK);
                    this.this$0.transitionTo(this.this$0.mInactiveState);
                    retVal = true;
                    break;
                }
                case 262144: {
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    this.this$0.log("DcRetryingState: msg.what=EVENT_CONNECT RefCount=" + this.this$0.mApnContexts.size() + " cp=" + cp + " mConnectionParams=" + this.this$0.mConnectionParams);
                    if (this.this$0.initConnection(cp)) {
                        this.this$0.onConnect(this.this$0.mConnectionParams);
                        this.this$0.transitionTo(this.this$0.mActivatingState);
                    } else {
                        this.this$0.log("DcRetryingState: msg.what=EVENT_CONNECT initConnection failed");
                        this.this$0.notifyConnectCompleted(cp, DcFailCause.UNACCEPTABLE_NETWORK_PARAMETER, false);
                    }
                    retVal = true;
                    break;
                }
                case 262148: {
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    if (this.this$0.mApnContexts.remove(dp.mApnContext) && this.this$0.mApnContexts.size() == 0) {
                        this.this$0.log("DcRetryingState msg.what=EVENT_DISCONNECT  RefCount=" + this.this$0.mApnContexts.size() + " dp=" + dp);
                        this.this$0.mInactiveState.setEnterNotificationParams(dp);
                        this.this$0.transitionTo(this.this$0.mInactiveState);
                    } else {
                        this.this$0.log("DcRetryingState: msg.what=EVENT_DISCONNECT");
                        this.this$0.notifyDisconnectCompleted(dp, false);
                    }
                    retVal = true;
                    break;
                }
                case 262150: {
                    this.this$0.log("DcRetryingState msg.what=EVENT_DISCONNECT/DISCONNECT_ALL RefCount=" + this.this$0.mApnContexts.size());
                    this.this$0.mInactiveState.setEnterNotificationParams(DcFailCause.LOST_CONNECTION);
                    this.this$0.transitionTo(this.this$0.mInactiveState);
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcRetryingState nothandled msg.what=" + this.this$0.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcRetryingState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcRetryingState$__constructor__(dataConnection);
        }

        private DcRetryingState(DataConnection dataConnection) {
            this.this$0 = dataConnection;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcRetryingState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), 0, this, dataConnection);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcRetryingState$enter(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcRetryingState$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcRetryingState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcRetryingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcRetryingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcInactiveState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(DataConnection dataConnection) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(ConnectionParams cp, DcFailCause cause) {
            this.this$0.log("DcInactiveState: setEnterNoticationParams cp,cause");
            this.this$0.mConnectionParams = cp;
            this.this$0.mDisconnectParams = null;
            this.this$0.mDcFailCause = cause;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(DisconnectParams dp) {
            this.this$0.log("DcInactiveState: setEnterNoticationParams dp");
            this.this$0.mConnectionParams = null;
            this.this$0.mDisconnectParams = dp;
            this.this$0.mDcFailCause = DcFailCause.NONE;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(DcFailCause cause) {
            this.this$0.mConnectionParams = null;
            this.this$0.mDisconnectParams = null;
            this.this$0.mDcFailCause = cause;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$enter() {
            ++this.this$0.mTag;
            this.this$0.log("DcInactiveState: enter() mTag=" + this.this$0.mTag);
            if (this.this$0.mConnectionParams != null) {
                this.this$0.log("DcInactiveState: enter notifyConnectCompleted +ALL failCause=" + (Object)((Object)this.this$0.mDcFailCause));
                this.this$0.notifyConnectCompleted(this.this$0.mConnectionParams, this.this$0.mDcFailCause, true);
            }
            if (this.this$0.mDisconnectParams != null) {
                this.this$0.log("DcInactiveState: enter notifyDisconnectCompleted +ALL failCause=" + (Object)((Object)this.this$0.mDcFailCause));
                this.this$0.notifyDisconnectCompleted(this.this$0.mDisconnectParams, true);
            }
            if (this.this$0.mDisconnectParams == null && this.this$0.mConnectionParams == null && this.this$0.mDcFailCause != null) {
                this.this$0.log("DcInactiveState: enter notifyAllDisconnectCompleted failCause=" + (Object)((Object)this.this$0.mDcFailCause));
                this.this$0.notifyAllDisconnectCompleted(this.this$0.mDcFailCause);
            }
            this.this$0.mDcController.removeActiveDcByCid(this.this$0);
            this.this$0.clearSettings();
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$exit() {
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 266252: {
                    this.this$0.log("DcInactiveState: msg.what=RSP_RESET, ignore we're already reset");
                    retVal = true;
                    break;
                }
                case 262144: {
                    this.this$0.log("DcInactiveState: mag.what=EVENT_CONNECT");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    if (this.this$0.initConnection(cp)) {
                        this.this$0.onConnect(this.this$0.mConnectionParams);
                        this.this$0.transitionTo(this.this$0.mActivatingState);
                    } else {
                        this.this$0.log("DcInactiveState: msg.what=EVENT_CONNECT initConnection failed");
                        this.this$0.notifyConnectCompleted(cp, DcFailCause.UNACCEPTABLE_NETWORK_PARAMETER, false);
                    }
                    retVal = true;
                    break;
                }
                case 262148: {
                    this.this$0.log("DcInactiveState: msg.what=EVENT_DISCONNECT");
                    this.this$0.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    retVal = true;
                    break;
                }
                case 262150: {
                    this.this$0.log("DcInactiveState: msg.what=EVENT_DISCONNECT_ALL");
                    this.this$0.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcInactiveState nothandled msg.what=" + this.this$0.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(dataConnection);
        }

        private DcInactiveState(DataConnection dataConnection) {
            this.this$0 = dataConnection;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), 0, this, dataConnection);
        }

        public void setEnterNotificationParams(ConnectionParams connectionParams, DcFailCause dcFailCause) {
            InvokeDynamicSupport.bootstrap("setEnterNotificationParams", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(com.android.internal.telephony.dataconnection.DataConnection$ConnectionParams com.android.internal.telephony.dataconnection.DcFailCause ), 0, this, connectionParams, dcFailCause);
        }

        public void setEnterNotificationParams(DisconnectParams disconnectParams) {
            InvokeDynamicSupport.bootstrap("setEnterNotificationParams", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(com.android.internal.telephony.dataconnection.DataConnection$DisconnectParams ), 0, this, disconnectParams);
        }

        public void setEnterNotificationParams(DcFailCause dcFailCause) {
            InvokeDynamicSupport.bootstrap("setEnterNotificationParams", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(com.android.internal.telephony.dataconnection.DcFailCause ), 0, this, dcFailCause);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$enter(), 0, this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$exit(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcInactiveState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcInactiveState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcDefaultState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(DataConnection dataConnection) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$enter() {
            this.this$0.log("DcDefaultState: enter");
            this.this$0.mPhone.getServiceStateTracker().registerForDataRegStateOrRatChanged(this.this$0.getHandler(), 262155, null);
            this.this$0.mPhone.getServiceStateTracker().registerForRoamingOn(this.this$0.getHandler(), 262156, null);
            this.this$0.mPhone.getServiceStateTracker().registerForRoamingOff(this.this$0.getHandler(), 262157, null);
            this.this$0.mDcController.addDc(this.this$0);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$exit() {
            this.this$0.log("DcDefaultState: exit");
            this.this$0.mPhone.getServiceStateTracker().unregisterForDataRegStateOrRatChanged(this.this$0.getHandler());
            this.this$0.mPhone.getServiceStateTracker().unregisterForRoamingOn(this.this$0.getHandler());
            this.this$0.mPhone.getServiceStateTracker().unregisterForRoamingOff(this.this$0.getHandler());
            this.this$0.mDcController.removeDc(this.this$0);
            if (this.this$0.mAc != null) {
                this.this$0.mAc.disconnected();
                this.this$0.mAc = null;
            }
            this.this$0.mDcRetryAlarmController.dispose();
            this.this$0.mDcRetryAlarmController = null;
            this.this$0.mApnContexts = null;
            this.this$0.mReconnectIntent = null;
            this.this$0.mDct = null;
            this.this$0.mApnSetting = null;
            this.this$0.mPhone = null;
            this.this$0.mLinkProperties = null;
            this.this$0.mLastFailCause = null;
            this.this$0.mUserData = null;
            this.this$0.mDcController = null;
            this.this$0.mDcTesterFailBringUpAll = null;
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$processMessage(Message msg) {
            boolean retVal = true;
            this.this$0.log("DcDefault msg=" + this.this$0.getWhatToString(msg.what) + " RefCount=" + this.this$0.mApnContexts.size());
            switch (msg.what) {
                case 69633: {
                    if (this.this$0.mAc != null) {
                        this.this$0.log("Disconnecting to previous connection mAc=" + this.this$0.mAc);
                        this.this$0.mAc.replyToMessage(msg, 69634, 3);
                        break;
                    }
                    this.this$0.mAc = new AsyncChannel();
                    this.this$0.mAc.connected(null, this.this$0.getHandler(), msg.replyTo);
                    this.this$0.log("DcDefaultState: FULL_CONNECTION reply connected");
                    this.this$0.mAc.replyToMessage(msg, 69634, 0, this.this$0.mId, "hi");
                    break;
                }
                case 69636: {
                    this.this$0.log("CMD_CHANNEL_DISCONNECTED");
                    this.this$0.quit();
                    break;
                }
                case 266240: {
                    boolean val = this.this$0.getIsInactive();
                    this.this$0.log("REQ_IS_INACTIVE  isInactive=" + val);
                    this.this$0.mAc.replyToMessage(msg, 266241, val ? 1 : 0);
                    break;
                }
                case 266242: {
                    int cid = this.this$0.getCid();
                    this.this$0.log("REQ_GET_CID  cid=" + cid);
                    this.this$0.mAc.replyToMessage(msg, 266243, cid);
                    break;
                }
                case 266244: {
                    ApnSetting apnSetting = this.this$0.getApnSetting();
                    this.this$0.log("REQ_GET_APNSETTING  mApnSetting=" + apnSetting);
                    this.this$0.mAc.replyToMessage(msg, 266245, apnSetting);
                    break;
                }
                case 266246: {
                    LinkProperties lp = this.this$0.getCopyLinkProperties();
                    this.this$0.log("REQ_GET_LINK_PROPERTIES linkProperties" + lp);
                    this.this$0.mAc.replyToMessage(msg, 266247, lp);
                    break;
                }
                case 266248: {
                    ProxyInfo proxy = (ProxyInfo)msg.obj;
                    this.this$0.log("REQ_SET_LINK_PROPERTIES_HTTP_PROXY proxy=" + proxy);
                    this.this$0.setLinkPropertiesHttpProxy(proxy);
                    this.this$0.mAc.replyToMessage(msg, 266249);
                    break;
                }
                case 266250: {
                    NetworkCapabilities nc = this.this$0.getCopyNetworkCapabilities();
                    this.this$0.log("REQ_GET_NETWORK_CAPABILITIES networkCapabilities" + nc);
                    this.this$0.mAc.replyToMessage(msg, 266251, nc);
                    break;
                }
                case 266252: {
                    this.this$0.log("DcDefaultState: msg.what=REQ_RESET");
                    this.this$0.transitionTo(this.this$0.mInactiveState);
                    break;
                }
                case 262144: {
                    this.this$0.log("DcDefaultState: msg.what=EVENT_CONNECT, fail not expected");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    this.this$0.notifyConnectCompleted(cp, DcFailCause.UNKNOWN, false);
                    break;
                }
                case 262148: {
                    this.this$0.log("DcDefaultState deferring msg.what=EVENT_DISCONNECT RefCount=" + this.this$0.mApnContexts.size());
                    this.this$0.deferMessage(msg);
                    break;
                }
                case 262150: {
                    this.this$0.log("DcDefaultState deferring msg.what=EVENT_DISCONNECT_ALL RefCount=" + this.this$0.mApnContexts.size());
                    this.this$0.deferMessage(msg);
                    break;
                }
                case 262152: {
                    this.this$0.log("DcDefaultState EVENT_TEAR_DOWN_NOW");
                    ((DataConnection)this.this$0).mPhone.mCi.deactivateDataCall(this.this$0.mCid, 0, null);
                    break;
                }
                case 262153: {
                    String s = "DcDefaultState ignore EVENT_LOST_CONNECTION tag=" + msg.arg1 + ":mTag=" + this.this$0.mTag;
                    this.this$0.logAndAddLogRec(s);
                    break;
                }
                case 262154: {
                    String s = "DcDefaultState ignore EVENT_RETRY_CONNECTION tag=" + msg.arg1 + ":mTag=" + this.this$0.mTag;
                    this.this$0.logAndAddLogRec(s);
                    break;
                }
                case 262155: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Pair drsRatPair = (Pair)ar.result;
                    this.this$0.mDataRegState = (Integer)drsRatPair.first;
                    if (this.this$0.mRilRat != (Integer)drsRatPair.second) {
                        this.this$0.updateTcpBufferSizes((Integer)drsRatPair.second);
                    }
                    this.this$0.mRilRat = (Integer)drsRatPair.second;
                    this.this$0.log("DcDefaultState: EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED drs=" + this.this$0.mDataRegState + " mRilRat=" + this.this$0.mRilRat);
                    ServiceState ss = this.this$0.mPhone.getServiceState();
                    int networkType = ss.getDataNetworkType();
                    this.this$0.mNetworkInfo.setSubtype(networkType, TelephonyManager.getNetworkTypeName(networkType));
                    if (this.this$0.mNetworkAgent == null) break;
                    this.this$0.mNetworkAgent.sendNetworkCapabilities(this.this$0.makeNetworkCapabilities());
                    this.this$0.mNetworkAgent.sendNetworkInfo(this.this$0.mNetworkInfo);
                    this.this$0.mNetworkAgent.sendLinkProperties(this.this$0.mLinkProperties);
                    break;
                }
                case 262156: {
                    this.this$0.mNetworkInfo.setRoaming(true);
                    break;
                }
                case 262157: {
                    this.this$0.mNetworkInfo.setRoaming(false);
                    break;
                }
                default: {
                    this.this$0.log("DcDefaultState: shouldn't happen but ignore msg.what=" + this.this$0.getWhatToString(msg.what));
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(dataConnection);
        }

        private DcDefaultState(DataConnection dataConnection) {
            this.this$0 = dataConnection;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), 0, this, dataConnection);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$enter(), 0, this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$exit(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcDefaultState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcDefaultState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class UpdateLinkPropertyResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public DataCallResponse.SetupResult setupResult;
        public LinkProperties oldLp;
        public LinkProperties newLp;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_UpdateLinkPropertyResult$__constructor__(LinkProperties curLp) {
            this.setupResult = DataCallResponse.SetupResult.SUCCESS;
            this.oldLp = curLp;
            this.newLp = curLp;
        }

        private void __constructor__(LinkProperties linkProperties) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_UpdateLinkPropertyResult$__constructor__(linkProperties);
        }

        public UpdateLinkPropertyResult(LinkProperties linkProperties) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_UpdateLinkPropertyResult$__constructor__(android.net.LinkProperties ), 0, this, linkProperties);
        }

        public /* synthetic */ UpdateLinkPropertyResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UpdateLinkPropertyResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class DisconnectParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mTag;
        ApnContext mApnContext;
        String mReason;
        Message mOnCompletedMsg;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DisconnectParams$__constructor__(ApnContext apnContext, String reason, Message onCompletedMsg) {
            this.mApnContext = apnContext;
            this.mReason = reason;
            this.mOnCompletedMsg = onCompletedMsg;
        }

        private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DisconnectParams$toString() {
            return "{mTag=" + this.mTag + " mApnContext=" + this.mApnContext + " mReason=" + this.mReason + " mOnCompletedMsg=" + DataConnection.msgToString(this.mOnCompletedMsg) + "}";
        }

        private void __constructor__(ApnContext apnContext, String string2, Message message) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DisconnectParams$__constructor__(apnContext, string2, message);
        }

        DisconnectParams(ApnContext apnContext, String string2, Message message) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DisconnectParams$__constructor__(com.android.internal.telephony.dataconnection.ApnContext java.lang.String android.os.Message ), 0, this, apnContext, string2, message);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DisconnectParams$toString(), 0, this);
        }

        public /* synthetic */ DisconnectParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisconnectParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ConnectionParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mTag;
        ApnContext mApnContext;
        int mInitialMaxRetry;
        int mProfileId;
        int mRilRat;
        boolean mRetryWhenSSChange;
        Message mOnCompletedMsg;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_ConnectionParams$__constructor__(ApnContext apnContext, int initialMaxRetry, int profileId, int rilRadioTechnology, boolean retryWhenSSChange, Message onCompletedMsg) {
            this.mApnContext = apnContext;
            this.mInitialMaxRetry = initialMaxRetry;
            this.mProfileId = profileId;
            this.mRilRat = rilRadioTechnology;
            this.mRetryWhenSSChange = retryWhenSSChange;
            this.mOnCompletedMsg = onCompletedMsg;
        }

        private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection_ConnectionParams$toString() {
            return "{mTag=" + this.mTag + " mApnContext=" + this.mApnContext + " mInitialMaxRetry=" + this.mInitialMaxRetry + " mProfileId=" + this.mProfileId + " mRat=" + this.mRilRat + " mOnCompletedMsg=" + DataConnection.msgToString(this.mOnCompletedMsg) + "}";
        }

        private void __constructor__(ApnContext apnContext, int n, int n2, int n3, boolean bl, Message message) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_ConnectionParams$__constructor__(apnContext, n, n2, n3, bl, message);
        }

        ConnectionParams(ApnContext apnContext, int n, int n2, int n3, boolean bl, Message message) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_ConnectionParams$__constructor__(com.android.internal.telephony.dataconnection.ApnContext int int int boolean android.os.Message ), 0, this, apnContext, n, n2, n3, bl, message);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_ConnectionParams$toString(), 0, this);
        }

        public /* synthetic */ ConnectionParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

