/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncResult;
import android.os.SystemClock;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.dataconnection.DataConnection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DcRetryAlarmController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mLogTag;
    private static boolean DBG = true;
    private PhoneBase mPhone;
    private DataConnection mDc;
    private AlarmManager mAlarmManager;
    private String mActionRetry;
    private static String INTENT_RETRY_ALARM_WHAT = "what";
    private static String INTENT_RETRY_ALARM_TAG = "tag";
    private BroadcastReceiver mIntentReceiver;

    private void $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$__constructor__(PhoneBase phone, DataConnection dc) {
        this.mLogTag = "DcRac";
        this.mIntentReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ DcRetryAlarmController this$0;

            private void $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController_1$__constructor__(DcRetryAlarmController dcRetryAlarmController) {
            }

            private final void $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (TextUtils.isEmpty(action)) {
                    this.this$0.log("onReceive: ignore empty action='" + action + "'");
                    return;
                }
                if (TextUtils.equals(action, this.this$0.mActionRetry)) {
                    if (!intent.hasExtra("what")) {
                        throw new RuntimeException(this.this$0.mActionRetry + " has no INTENT_RETRY_ALRAM_WHAT");
                    }
                    if (!intent.hasExtra("tag")) {
                        throw new RuntimeException(this.this$0.mActionRetry + " has no INTENT_RETRY_ALRAM_TAG");
                    }
                    int what = intent.getIntExtra("what", Integer.MAX_VALUE);
                    int tag = intent.getIntExtra("tag", Integer.MAX_VALUE);
                    this.this$0.log("onReceive: action=" + action + " sendMessage(what:" + this.this$0.mDc.getWhatToString(what) + ", tag:" + tag + ")");
                    this.this$0.mDc.sendMessage(this.this$0.mDc.obtainMessage(what, tag, 0));
                } else {
                    this.this$0.log("onReceive: unknown action=" + action);
                }
            }

            private void __constructor__(DcRetryAlarmController dcRetryAlarmController) {
                this.$$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController_1$__constructor__(dcRetryAlarmController);
            }
            {
                this.this$0 = dcRetryAlarmController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController_1$__constructor__(com.android.internal.telephony.dataconnection.DcRetryAlarmController ), 0, this, dcRetryAlarmController);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mLogTag = dc.getName();
        this.mPhone = phone;
        this.mDc = dc;
        this.mAlarmManager = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
        this.mActionRetry = this.mDc.getClass().getCanonicalName() + "." + this.mDc.getName() + ".action_retry";
        IntentFilter filter = new IntentFilter();
        filter.addAction(this.mActionRetry);
        this.log("DcRetryAlarmController: register for intent action=" + this.mActionRetry);
        this.mPhone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mDc.getHandler());
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$dispose() {
        this.log("dispose");
        this.mPhone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.mPhone = null;
        this.mDc = null;
        this.mAlarmManager = null;
        this.mActionRetry = null;
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$getSuggestedRetryTime(DataConnection dc, AsyncResult ar) {
        DataCallResponse response = (DataCallResponse)ar.result;
        int retryDelay = response.suggestedRetryTime;
        if (retryDelay == Integer.MAX_VALUE) {
            this.log("getSuggestedRetryTime: suggestedRetryTime is MAX_INT, retry NOT needed");
            retryDelay = -1;
        } else if (retryDelay >= 0) {
            this.log("getSuggestedRetryTime: suggestedRetryTime is >= 0 use it");
        } else if (dc.mRetryManager.isRetryNeeded()) {
            retryDelay = dc.mRetryManager.getRetryTimer();
            if (retryDelay < 0) {
                retryDelay = 0;
            }
            this.log("getSuggestedRetryTime: retry is needed");
        } else {
            this.log("getSuggestedRetryTime: retry is NOT needed");
            retryDelay = -1;
        }
        this.log("getSuggestedRetryTime: " + retryDelay + " response=" + response + " dc=" + dc);
        return retryDelay;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$startRetryAlarm(int what, int tag, int delay) {
        Intent intent = new Intent(this.mActionRetry);
        intent.putExtra("what", what);
        intent.putExtra("tag", tag);
        this.log("startRetryAlarm: next attempt in " + delay / 1000 + "s" + " what=" + what + " tag=" + tag);
        PendingIntent retryIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
        this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + (long)delay, retryIntent);
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mLogTag).append(" [dcRac] ");
        sb.append(" mPhone=").append(this.mPhone);
        sb.append(" mDc=").append(this.mDc);
        sb.append(" mAlaramManager=").append(this.mAlarmManager);
        sb.append(" mActionRetry=").append(this.mActionRetry);
        return sb.toString();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$log(String s) {
        Rlog.d(this.mLogTag, "[dcRac] " + s);
    }

    private void __constructor__(PhoneBase phoneBase, DataConnection dataConnection) {
        this.$$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$__constructor__(phoneBase, dataConnection);
    }

    DcRetryAlarmController(PhoneBase phoneBase, DataConnection dataConnection) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$__constructor__(com.android.internal.telephony.PhoneBase com.android.internal.telephony.dataconnection.DataConnection ), 0, this, phoneBase, dataConnection);
    }

    void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$dispose(), 0, this);
    }

    int getSuggestedRetryTime(DataConnection dataConnection, AsyncResult asyncResult) {
        return (int)InvokeDynamicSupport.bootstrap("getSuggestedRetryTime", $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$getSuggestedRetryTime(com.android.internal.telephony.dataconnection.DataConnection android.os.AsyncResult ), 0, this, dataConnection, asyncResult);
    }

    public void startRetryAlarm(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("startRetryAlarm", $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$startRetryAlarm(int int int ), 0, this, n, n2, n3);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$toString(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_dataconnection_DcRetryAlarmController$log(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ DcRetryAlarmController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcRetryAlarmController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

