/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkFactory;
import android.net.NetworkRequest;
import android.net.NetworkUtils;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RegistrantList;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.CellLocation;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.cdma.CDMALTEPhone;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.ApnSetting;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.telephony.dataconnection.DcAsyncChannel;
import com.android.internal.telephony.dataconnection.DcFailCause;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.util.ArrayUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DcTracker
extends DcTrackerBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected String LOG_TAG = "DCT";
    private ArrayList<Message> mDisconnectAllCompleteMsgList;
    private RegistrantList mAllDataDisconnectedRegistrants;
    protected int mDisconnectPendingCount;
    private boolean mReregisterOnReconnectFailure;
    private static String PUPPET_MASTER_RADIO_STRESS_TEST = "gsm.defaultpdpcontext.active";
    private static int POLL_PDP_MILLIS = 5000;
    private static int PROVISIONING_SPINNER_TIMEOUT_MILLIS = 120000;
    static Uri PREFERAPN_NO_UPDATE_URI;
    static String APN_ID = "apn_id";
    private boolean mCanSetPreferApn;
    private AtomicBoolean mAttached;
    private ApnChangeObserver mApnObserver;
    private String mProvisionActionName;
    private BroadcastReceiver mProvisionBroadcastReceiver;
    private ProgressDialog mProvisioningSpinner;
    private Messenger mNetworkFactoryMessenger;
    private NetworkFactory mNetworkFactory;
    private NetworkCapabilities mNetworkFilter;
    public boolean mImsRegistrationState;
    private ApnContext mWaitCleanUpApnContext;
    private boolean mDeregistrationAlarmState;
    private PendingIntent mImsDeregistrationDelayIntent;

    private void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$__constructor__(PhoneBase p) {
        this.LOG_TAG = "DCT";
        this.mDisconnectAllCompleteMsgList = new ArrayList();
        this.mAllDataDisconnectedRegistrants = new RegistrantList();
        this.mDisconnectPendingCount = 0;
        this.mReregisterOnReconnectFailure = false;
        this.mCanSetPreferApn = false;
        this.mAttached = new AtomicBoolean(false);
        this.mImsRegistrationState = false;
        this.mWaitCleanUpApnContext = null;
        this.mDeregistrationAlarmState = false;
        this.mImsDeregistrationDelayIntent = null;
        this.log("GsmDCT.constructor");
        this.mDataConnectionTracker = this;
        this.update();
        this.mApnObserver = new ApnChangeObserver(this);
        p.getContext().getContentResolver().registerContentObserver(Telephony.Carriers.CONTENT_URI, true, this.mApnObserver);
        this.initApnContexts();
        for (ApnContext apnContext : this.mApnContexts.values()) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("com.android.internal.telephony.data-reconnect." + apnContext.getApnType());
            filter.addAction("com.android.internal.telephony.data-restart-trysetup." + apnContext.getApnType());
            this.mPhone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mPhone);
        }
        ConnectivityManager cm = (ConnectivityManager)p.getContext().getSystemService("connectivity");
        this.mNetworkFilter = new NetworkCapabilities();
        this.mNetworkFilter.addTransportType(0);
        this.mNetworkFilter.addCapability(0);
        this.mNetworkFilter.addCapability(1);
        this.mNetworkFilter.addCapability(2);
        this.mNetworkFilter.addCapability(3);
        this.mNetworkFilter.addCapability(4);
        this.mNetworkFilter.addCapability(5);
        this.mNetworkFilter.addCapability(7);
        this.mNetworkFilter.addCapability(8);
        this.mNetworkFilter.addCapability(9);
        this.mNetworkFilter.addCapability(10);
        this.mNetworkFilter.addCapability(13);
        this.mNetworkFilter.addCapability(12);
        this.mNetworkFactory = new TelephonyNetworkFactory(this, this.getLooper(), p.getContext(), "TelephonyNetworkFactory", this.mNetworkFilter);
        this.mNetworkFactory.setScoreFilter(50);
        this.mNetworkFactoryMessenger = new Messenger(this.mNetworkFactory);
        cm.registerNetworkFactory(this.mNetworkFactoryMessenger, "Telephony");
        this.initEmergencyApnSetting();
        this.addEmergencyApnSetting();
        this.mProvisionActionName = "com.android.internal.telephony.PROVISION" + p.getPhoneId();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$registerForAllEvents() {
        this.mPhone.mCi.registerForAvailable(this, 270337, null);
        this.mPhone.mCi.registerForOffOrNotAvailable(this, 270342, null);
        this.mPhone.mCi.registerForDataNetworkStateChanged(this, 270340, null);
        this.mPhone.getCallTracker().registerForVoiceCallEnded(this, 270344, null);
        this.mPhone.getCallTracker().registerForVoiceCallStarted(this, 270343, null);
        this.mPhone.getServiceStateTracker().registerForDataConnectionAttached(this, 270352, null);
        this.mPhone.getServiceStateTracker().registerForDataConnectionDetached(this, 270345, null);
        this.mPhone.getServiceStateTracker().registerForRoamingOn(this, 270347, null);
        this.mPhone.getServiceStateTracker().registerForRoamingOff(this, 270348, null);
        this.mPhone.getServiceStateTracker().registerForPsRestrictedEnabled(this, 270358, null);
        this.mPhone.getServiceStateTracker().registerForPsRestrictedDisabled(this, 270359, null);
        this.mPhone.getServiceStateTracker().registerForDataRegStateOrRatChanged(this, 270377, null);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$dispose() {
        this.log("GsmDCT.dispose");
        if (this.mProvisionBroadcastReceiver != null) {
            this.mPhone.getContext().unregisterReceiver(this.mProvisionBroadcastReceiver);
            this.mProvisionBroadcastReceiver = null;
        }
        if (this.mProvisioningSpinner != null) {
            this.mProvisioningSpinner.dismiss();
            this.mProvisioningSpinner = null;
        }
        ConnectivityManager cm = (ConnectivityManager)this.mPhone.getContext().getSystemService("connectivity");
        cm.unregisterNetworkFactory(this.mNetworkFactoryMessenger);
        this.mNetworkFactoryMessenger = null;
        this.cleanUpAllConnections(true, null);
        super.dispose();
        this.mPhone.getContext().getContentResolver().unregisterContentObserver(this.mApnObserver);
        this.mApnContexts.clear();
        this.mPrioritySortedApnContexts.clear();
        this.destroyDataConnections();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$unregisterForAllEvents() {
        this.mPhone.mCi.unregisterForAvailable(this);
        this.mPhone.mCi.unregisterForOffOrNotAvailable(this);
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            r.unregisterForRecordsLoaded(this);
            this.mIccRecords.set(null);
        }
        this.mPhone.mCi.unregisterForDataNetworkStateChanged(this);
        this.mPhone.getCallTracker().unregisterForVoiceCallEnded(this);
        this.mPhone.getCallTracker().unregisterForVoiceCallStarted(this);
        this.mPhone.getServiceStateTracker().unregisterForDataConnectionAttached(this);
        this.mPhone.getServiceStateTracker().unregisterForDataConnectionDetached(this);
        this.mPhone.getServiceStateTracker().unregisterForRoamingOn(this);
        this.mPhone.getServiceStateTracker().unregisterForRoamingOff(this);
        this.mPhone.getServiceStateTracker().unregisterForPsRestrictedEnabled(this);
        this.mPhone.getServiceStateTracker().unregisterForPsRestrictedDisabled(this);
    }

    private final ApnContext $$robo$$com_android_internal_telephony_dataconnection_DcTracker$apnContextForNetworkRequest(NetworkRequest nr) {
        NetworkCapabilities nc = nr.networkCapabilities;
        if (nc.getTransportTypes().length > 0 && !nc.hasTransport(0)) {
            return null;
        }
        int type = -1;
        String name = null;
        boolean error = false;
        if (nc.hasCapability(12)) {
            if (name != null) {
                error = true;
            }
            name = "default";
            type = 0;
        }
        if (nc.hasCapability(0)) {
            if (name != null) {
                error = true;
            }
            name = "mms";
            type = 2;
        }
        if (nc.hasCapability(1)) {
            if (name != null) {
                error = true;
            }
            name = "supl";
            type = 3;
        }
        if (nc.hasCapability(2)) {
            if (name != null) {
                error = true;
            }
            name = "dun";
            type = 4;
        }
        if (nc.hasCapability(3)) {
            if (name != null) {
                error = true;
            }
            name = "fota";
            type = 10;
        }
        if (nc.hasCapability(4)) {
            if (name != null) {
                error = true;
            }
            name = "ims";
            type = 11;
        }
        if (nc.hasCapability(5)) {
            if (name != null) {
                error = true;
            }
            name = "cbs";
            type = 12;
        }
        if (nc.hasCapability(7)) {
            if (name != null) {
                error = true;
            }
            name = "ia";
            type = 14;
        }
        if (nc.hasCapability(8)) {
            if (name != null) {
                error = true;
            }
            name = null;
            this.loge("RCS APN type not yet supported");
        }
        if (nc.hasCapability(9)) {
            if (name != null) {
                error = true;
            }
            name = null;
            this.loge("XCAP APN type not yet supported");
        }
        if (nc.hasCapability(10)) {
            if (name != null) {
                error = true;
            }
            name = null;
            this.loge("EIMS APN type not yet supported");
        }
        if (error) {
            this.loge("Multiple apn types specified in request - result is unspecified!");
        }
        if (type == -1 || name == null) {
            this.loge("Unsupported NetworkRequest in Telephony: " + nr);
            return null;
        }
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(name);
        if (apnContext == null) {
            this.loge("Request for unsupported mobile type: " + type);
        }
        return apnContext;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setRadio(boolean on) {
        ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
        try {
            phone.setRadio(on);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isApnTypeActive(String type) {
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(type);
        if (apnContext == null) {
            return false;
        }
        return apnContext.getDcAc() != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isDataPossible(String apnType) {
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(apnType);
        if (apnContext == null) {
            return false;
        }
        boolean apnContextIsEnabled = apnContext.isEnabled();
        DctConstants.State apnContextState = apnContext.getState();
        boolean apnTypePossible = !apnContextIsEnabled || apnContextState != DctConstants.State.FAILED;
        boolean isEmergencyApn = apnContext.getApnType().equals("emergency");
        boolean dataAllowed = isEmergencyApn || this.isDataAllowed();
        boolean possible = dataAllowed && apnTypePossible;
        return possible;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$finalize() {
        this.log("finalize");
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$supplyMessenger() {
        if (!this.isActiveDataSubscription()) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)this.mPhone.getContext().getSystemService("connectivity");
        cm.supplyMessenger(0, new Messenger(this));
        cm.supplyMessenger(2, new Messenger(this));
        cm.supplyMessenger(3, new Messenger(this));
        cm.supplyMessenger(4, new Messenger(this));
        cm.supplyMessenger(5, new Messenger(this));
        cm.supplyMessenger(10, new Messenger(this));
        cm.supplyMessenger(11, new Messenger(this));
        cm.supplyMessenger(12, new Messenger(this));
        cm.supplyMessenger(15, new Messenger(this));
    }

    private final ApnContext $$robo$$com_android_internal_telephony_dataconnection_DcTracker$addApnContext(String type, NetworkConfig networkConfig) {
        ApnContext apnContext = new ApnContext(this.mPhone.getContext(), type, "DCT", networkConfig, this);
        this.mApnContexts.put(type, apnContext);
        this.mPrioritySortedApnContexts.add(apnContext);
        return apnContext;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$initApnContexts() {
        String[] networkConfigStrings;
        this.log("initApnContexts: E");
        block12: for (String networkConfigString : networkConfigStrings = this.mPhone.getContext().getResources().getStringArray(17235980)) {
            NetworkConfig networkConfig = new NetworkConfig(networkConfigString);
            ApnContext apnContext = null;
            switch (networkConfig.type) {
                case 0: {
                    apnContext = this.addApnContext("default", networkConfig);
                    break;
                }
                case 2: {
                    apnContext = this.addApnContext("mms", networkConfig);
                    break;
                }
                case 3: {
                    apnContext = this.addApnContext("supl", networkConfig);
                    break;
                }
                case 4: {
                    apnContext = this.addApnContext("dun", networkConfig);
                    break;
                }
                case 5: {
                    apnContext = this.addApnContext("hipri", networkConfig);
                    break;
                }
                case 10: {
                    apnContext = this.addApnContext("fota", networkConfig);
                    break;
                }
                case 11: {
                    apnContext = this.addApnContext("ims", networkConfig);
                    break;
                }
                case 12: {
                    apnContext = this.addApnContext("cbs", networkConfig);
                    break;
                }
                case 14: {
                    apnContext = this.addApnContext("ia", networkConfig);
                    break;
                }
                case 15: {
                    apnContext = this.addApnContext("emergency", networkConfig);
                    break;
                }
                default: {
                    this.log("initApnContexts: skipping unknown type=" + networkConfig.type);
                    continue block12;
                }
            }
            this.log("initApnContexts: apnContext=" + apnContext);
        }
        this.log("initApnContexts: X mApnContexts=" + this.mApnContexts);
    }

    private final LinkProperties $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getLinkProperties(String apnType) {
        DcAsyncChannel dcac;
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(apnType);
        if (apnContext != null && (dcac = apnContext.getDcAc()) != null) {
            this.log("return link properites for " + apnType);
            return dcac.getLinkPropertiesSync();
        }
        this.log("return new LinkProperties");
        return new LinkProperties();
    }

    private final NetworkCapabilities $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getNetworkCapabilities(String apnType) {
        DcAsyncChannel dataConnectionAc;
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(apnType);
        if (apnContext != null && (dataConnectionAc = apnContext.getDcAc()) != null) {
            this.log("get active pdp is not null, return NetworkCapabilities for " + apnType);
            return dataConnectionAc.getNetworkCapabilitiesSync();
        }
        this.log("return new NetworkCapabilities");
        return new NetworkCapabilities();
    }

    private final String[] $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getActiveApnTypes() {
        this.log("get all active apn types");
        ArrayList<String> result = new ArrayList<String>();
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (!this.mAttached.get() || !apnContext.isReady()) continue;
            result.add(apnContext.getApnType());
        }
        return result.toArray(new String[0]);
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getActiveApnString(String apnType) {
        ApnSetting apnSetting;
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(apnType);
        if (apnContext != null && (apnSetting = apnContext.getApnSetting()) != null) {
            return apnSetting.apn;
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isApnTypeEnabled(String apnType) {
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(apnType);
        if (apnContext == null) {
            return false;
        }
        return apnContext.isEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setState(DctConstants.State s) {
        this.log("setState should not be used in GSM" + (Object)((Object)s));
    }

    private final DctConstants.State $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getState(String apnType) {
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(apnType);
        if (apnContext != null) {
            return apnContext.getState();
        }
        return DctConstants.State.FAILED;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isProvisioningApn(String apnType) {
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(apnType);
        if (apnContext != null) {
            return apnContext.isProvisioningApn();
        }
        return false;
    }

    private final DctConstants.State $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getOverallState() {
        boolean isConnecting = false;
        boolean isFailed = true;
        boolean isAnyEnabled = false;
        block5: for (ApnContext apnContext : this.mApnContexts.values()) {
            if (!apnContext.isEnabled()) continue;
            isAnyEnabled = true;
            switch (1.$SwitchMap$com$android$internal$telephony$DctConstants$State[apnContext.getState().ordinal()]) {
                case 1: 
                case 2: {
                    this.log("overall state is CONNECTED");
                    return DctConstants.State.CONNECTED;
                }
                case 3: 
                case 4: {
                    isConnecting = true;
                    isFailed = false;
                    continue block5;
                }
                case 5: 
                case 6: {
                    isFailed = false;
                    continue block5;
                }
            }
            isAnyEnabled = true;
        }
        if (!isAnyEnabled) {
            this.log("overall state is IDLE");
            return DctConstants.State.IDLE;
        }
        if (isConnecting) {
            this.log("overall state is CONNECTING");
            return DctConstants.State.CONNECTING;
        }
        if (!isFailed) {
            this.log("overall state is IDLE");
            return DctConstants.State.IDLE;
        }
        this.log("overall state is FAILED");
        return DctConstants.State.FAILED;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isApnTypeAvailable(String type) {
        if (type.equals("dun") && this.fetchDunApn() != null) {
            return true;
        }
        if (this.mAllApnSettings != null) {
            for (ApnSetting apn : this.mAllApnSettings) {
                if (!apn.canHandleType(type)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getAnyDataEnabled() {
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            if (!(this.mInternalDataEnabled && this.mUserDataEnabled && sPolicyDataEnabled)) {
                return false;
            }
            for (ApnContext apnContext : this.mApnContexts.values()) {
                if (!this.isDataAllowed(apnContext)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getAnyDataEnabled(boolean checkUserDataEnabled) {
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            if (!this.mInternalDataEnabled || checkUserDataEnabled && !this.mUserDataEnabled || checkUserDataEnabled && !sPolicyDataEnabled) {
                return false;
            }
            for (ApnContext apnContext : this.mApnContexts.values()) {
                if (!this.isDataAllowed(apnContext)) continue;
                return true;
            }
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isDataAllowed(ApnContext apnContext) {
        return apnContext.isReady() && this.isDataAllowed();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDataConnectionDetached() {
        this.log("onDataConnectionDetached: stop polling and notify detached");
        this.stopNetStatPoll();
        this.stopDataStallAlarm();
        this.notifyDataConnection("dataDetached");
        this.mAttached.set(false);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDataConnectionAttached() {
        this.log("onDataConnectionAttached");
        this.mAttached.set(true);
        if (this.getOverallState() == DctConstants.State.CONNECTED) {
            this.log("onDataConnectionAttached: start polling notify attached");
            this.startNetStatPoll();
            this.startDataStallAlarm(false);
            this.notifyDataConnection("dataAttached");
        } else {
            this.notifyOffApnsOfAvailability("dataAttached");
        }
        if (this.mAutoAttachOnCreationConfig) {
            this.mAutoAttachOnCreation = true;
        }
        this.setupDataOnConnectableApns("dataAttached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isDataAllowed() {
        boolean allowed;
        boolean internalDataEnabled;
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            internalDataEnabled = this.mInternalDataEnabled;
        }
        boolean attachedState = this.mAttached.get();
        boolean desiredPowerState = this.mPhone.getServiceStateTracker().getDesiredPowerState();
        IccRecords r = (IccRecords)this.mIccRecords.get();
        boolean recordsLoaded = r != null ? r.getRecordsLoaded() : false;
        boolean psRestricted = this.mIsPsRestricted;
        int phoneNum = TelephonyManager.getDefault().getPhoneCount();
        if (phoneNum > 1) {
            attachedState = true;
            psRestricted = false;
        }
        boolean bl = allowed = !(!attachedState && !this.mAutoAttachOnCreation || !recordsLoaded || this.mPhone.getState() != PhoneConstants.State.IDLE && !this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed() || !internalDataEnabled || this.mPhone.getServiceState().getRoaming() && !this.getDataOnRoamingEnabled() || psRestricted || !desiredPowerState);
        if (!allowed) {
            String reason = "";
            if (!attachedState && !this.mAutoAttachOnCreation) {
                reason = reason + " - Attached= " + attachedState;
            }
            if (!recordsLoaded) {
                reason = reason + " - SIM not loaded";
            }
            if (this.mPhone.getState() != PhoneConstants.State.IDLE && !this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
                reason = reason + " - PhoneState= " + (Object)((Object)this.mPhone.getState());
                reason = reason + " - Concurrent voice and data not allowed";
            }
            if (!internalDataEnabled) {
                reason = reason + " - mInternalDataEnabled= false";
            }
            if (this.mPhone.getServiceState().getRoaming() && !this.getDataOnRoamingEnabled()) {
                reason = reason + " - Roaming and data roaming not enabled";
            }
            if (this.mIsPsRestricted) {
                reason = reason + " - mIsPsRestricted= true";
            }
            if (!desiredPowerState) {
                reason = reason + " - desiredPowerState= false";
            }
            this.log("isDataAllowed: not allowed due to" + reason);
        }
        return allowed;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setupDataOnConnectableApns(String reason) {
        this.log("setupDataOnConnectableApns: " + reason);
        for (ApnContext apnContext : this.mPrioritySortedApnContexts) {
            this.log("setupDataOnConnectableApns: apnContext " + apnContext);
            if (apnContext.getState() == DctConstants.State.FAILED) {
                apnContext.setState(DctConstants.State.IDLE);
            }
            if (!apnContext.isConnectable()) continue;
            this.log("setupDataOnConnectableApns: isConnectable() call trySetupData");
            apnContext.setReason(reason);
            this.trySetupData(apnContext);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$trySetupData(ApnContext apnContext) {
        boolean checkUserDataEnabled;
        this.log("trySetupData for type:" + apnContext.getApnType() + " due to " + apnContext.getReason() + " apnContext=" + apnContext);
        this.log("trySetupData with mIsPsRestricted=" + this.mIsPsRestricted);
        if (this.mPhone.getSimulatedRadioControl() != null) {
            apnContext.setState(DctConstants.State.CONNECTED);
            this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
            this.log("trySetupData: X We're on the simulator; assuming connected retValue=true");
            return true;
        }
        boolean isEmergencyApn = apnContext.getApnType().equals("emergency");
        boolean desiredPowerState = this.mPhone.getServiceStateTracker().getDesiredPowerState();
        boolean bl = checkUserDataEnabled = !apnContext.getApnType().equals("ims");
        if (apnContext.isConnectable() && (isEmergencyApn || this.isDataAllowed(apnContext) && this.getAnyDataEnabled(checkUserDataEnabled) && !this.isEmergency())) {
            if (apnContext.getState() == DctConstants.State.FAILED) {
                this.log("trySetupData: make a FAILED ApnContext IDLE so its reusable");
                apnContext.setState(DctConstants.State.IDLE);
            }
            int radioTech = this.mPhone.getServiceState().getRilDataRadioTechnology();
            if (apnContext.getState() == DctConstants.State.IDLE) {
                ArrayList<ApnSetting> waitingApns = this.buildWaitingApns(apnContext.getApnType(), radioTech);
                if (waitingApns.isEmpty()) {
                    this.notifyNoData(DcFailCause.MISSING_UNKNOWN_APN, apnContext);
                    this.notifyOffApnsOfAvailability(apnContext.getReason());
                    this.log("trySetupData: X No APN found retValue=false");
                    return false;
                }
                apnContext.setWaitingApns(waitingApns);
                this.log("trySetupData: Create from mAllApnSettings : " + this.apnListToString(this.mAllApnSettings));
            }
            this.log("trySetupData: call setupData, waitingApns : " + this.apnListToString(apnContext.getWaitingApns()));
            boolean retValue = this.setupData(apnContext, radioTech);
            this.notifyOffApnsOfAvailability(apnContext.getReason());
            this.log("trySetupData: X retValue=" + retValue);
            return retValue;
        }
        if (!apnContext.getApnType().equals("default") && apnContext.isConnectable()) {
            this.mPhone.notifyDataConnectionFailed(apnContext.getReason(), apnContext.getApnType());
        }
        this.notifyOffApnsOfAvailability(apnContext.getReason());
        this.log("trySetupData: X apnContext not 'ready' retValue=false");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$notifyOffApnsOfAvailability(String reason) {
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (this.mAttached.get() && apnContext.isReady()) continue;
            this.mPhone.notifyDataConnection(reason != null ? reason : apnContext.getReason(), apnContext.getApnType(), PhoneConstants.DataState.DISCONNECTED);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$cleanUpAllConnections(boolean tearDown, String reason) {
        this.log("cleanUpAllConnections: tearDown=" + tearDown + " reason=" + reason);
        boolean didDisconnect = false;
        boolean specificdisable = false;
        if (!TextUtils.isEmpty(reason)) {
            specificdisable = reason.equals("specificDisabled");
        }
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (!apnContext.isDisconnected()) {
                didDisconnect = true;
            }
            if (specificdisable) {
                if (apnContext.getApnType().equals("ims")) continue;
                this.log("ApnConextType: " + apnContext.getApnType());
                apnContext.setReason(reason);
                this.cleanUpConnection(tearDown, apnContext);
                continue;
            }
            apnContext.setReason(reason);
            this.cleanUpConnection(tearDown, apnContext);
        }
        this.stopNetStatPoll();
        this.stopDataStallAlarm();
        this.mRequestedApnType = "default";
        this.log("cleanUpConnection: mDisconnectPendingCount = " + this.mDisconnectPendingCount);
        if (tearDown && this.mDisconnectPendingCount == 0) {
            this.notifyDataDisconnectComplete();
            this.notifyAllDataDisconnected();
        }
        return didDisconnect;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onCleanUpAllConnections(String cause) {
        this.cleanUpAllConnections(true, cause);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$cleanUpConnection(boolean tearDown, ApnContext apnContext) {
        if (apnContext == null) {
            this.log("cleanUpConnection: apn context is null");
            return;
        }
        DcAsyncChannel dcac = apnContext.getDcAc();
        this.log("cleanUpConnection: E tearDown=" + tearDown + " reason=" + apnContext.getReason() + " apnContext=" + apnContext);
        if (tearDown) {
            if (apnContext.isDisconnected()) {
                apnContext.setState(DctConstants.State.IDLE);
                if (!apnContext.isReady()) {
                    if (dcac != null) {
                        dcac.tearDown(apnContext, "", null);
                    }
                    apnContext.setDataConnectionAc(null);
                }
            } else if (dcac != null) {
                if (apnContext.getState() != DctConstants.State.DISCONNECTING) {
                    boolean disconnectAll = false;
                    if ("dun".equals(apnContext.getApnType()) && this.teardownForDun()) {
                        this.log("tearing down dedicated DUN connection");
                        disconnectAll = true;
                    }
                    this.log("cleanUpConnection: tearing down" + (disconnectAll ? " all" : ""));
                    Message msg = this.obtainMessage(270351, apnContext);
                    if (disconnectAll) {
                        apnContext.getDcAc().tearDownAll(apnContext.getReason(), msg);
                    } else {
                        apnContext.getDcAc().tearDown(apnContext, apnContext.getReason(), msg);
                    }
                    apnContext.setState(DctConstants.State.DISCONNECTING);
                    ++this.mDisconnectPendingCount;
                }
            } else {
                apnContext.setState(DctConstants.State.IDLE);
                this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
            }
        } else {
            if (dcac != null) {
                dcac.reqReset();
            }
            apnContext.setState(DctConstants.State.IDLE);
            this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
            apnContext.setDataConnectionAc(null);
        }
        if (dcac != null) {
            this.cancelReconnectAlarm(apnContext);
        }
        this.log("cleanUpConnection: X tearDown=" + tearDown + " reason=" + apnContext.getReason() + " apnContext=" + apnContext + " dcac=" + apnContext.getDcAc());
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$teardownForDun() {
        int rilRat = this.mPhone.getServiceState().getRilDataRadioTechnology();
        if (ServiceState.isCdma(rilRat)) {
            return true;
        }
        return this.fetchDunApn() != null;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$cancelReconnectAlarm(ApnContext apnContext) {
        if (apnContext == null) {
            return;
        }
        PendingIntent intent = apnContext.getReconnectIntent();
        if (intent != null) {
            AlarmManager am = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
            am.cancel(intent);
            apnContext.setReconnectIntent(null);
        }
    }

    private final String[] $$robo$$com_android_internal_telephony_dataconnection_DcTracker$parseTypes(String types) {
        String[] result = types == null || types.equals("") ? new String[]{"*"} : types.split(",");
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$imsiMatches(String imsiDB, String imsiSIM) {
        int len = imsiDB.length();
        boolean idxCompare = false;
        if (len <= 0) {
            return false;
        }
        if (len > imsiSIM.length()) {
            return false;
        }
        for (int idx = 0; idx < len; ++idx) {
            char c = imsiDB.charAt(idx);
            if (c == 'x' || c == 'X' || c == imsiSIM.charAt(idx)) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$mvnoMatches(IccRecords r, String mvnoType, String mvnoMatchData) {
        if (mvnoType.equalsIgnoreCase("spn")) {
            if (r.getServiceProviderName() != null && r.getServiceProviderName().equalsIgnoreCase(mvnoMatchData)) {
                return true;
            }
        } else if (mvnoType.equalsIgnoreCase("imsi")) {
            String imsiSIM = r.getIMSI();
            if (imsiSIM != null && this.imsiMatches(mvnoMatchData, imsiSIM)) {
                return true;
            }
        } else if (mvnoType.equalsIgnoreCase("gid")) {
            String gid1 = r.getGid1();
            int mvno_match_data_length = mvnoMatchData.length();
            if (gid1 != null && gid1.length() >= mvno_match_data_length && gid1.substring(0, mvno_match_data_length).equalsIgnoreCase(mvnoMatchData)) {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isPermanentFail(DcFailCause dcFailCause) {
        return dcFailCause.isPermanentFail() && (!this.mAttached.get() || dcFailCause != DcFailCause.SIGNAL_LOST);
    }

    private final ApnSetting $$robo$$com_android_internal_telephony_dataconnection_DcTracker$makeApnSetting(Cursor cursor) {
        String[] types = this.parseTypes(cursor.getString(cursor.getColumnIndexOrThrow("type")));
        ApnSetting apn = new ApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), NetworkUtils.trimV4AddrZeros(cursor.getString(cursor.getColumnIndexOrThrow("proxy"))), cursor.getString(cursor.getColumnIndexOrThrow("port")), NetworkUtils.trimV4AddrZeros(cursor.getString(cursor.getColumnIndexOrThrow("mmsc"))), NetworkUtils.trimV4AddrZeros(cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy"))), cursor.getString(cursor.getColumnIndexOrThrow("mmsport")), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), cursor.getInt(cursor.getColumnIndexOrThrow("authtype")), types, cursor.getString(cursor.getColumnIndexOrThrow("protocol")), cursor.getString(cursor.getColumnIndexOrThrow("roaming_protocol")), cursor.getInt(cursor.getColumnIndexOrThrow("carrier_enabled")) == 1, cursor.getInt(cursor.getColumnIndexOrThrow("bearer")), cursor.getInt(cursor.getColumnIndexOrThrow("profile_id")), cursor.getInt(cursor.getColumnIndexOrThrow("modem_cognitive")) == 1, cursor.getInt(cursor.getColumnIndexOrThrow("max_conns")), cursor.getInt(cursor.getColumnIndexOrThrow("wait_time")), cursor.getInt(cursor.getColumnIndexOrThrow("max_conns_time")), cursor.getInt(cursor.getColumnIndexOrThrow("mtu")), cursor.getString(cursor.getColumnIndexOrThrow("mvno_type")), cursor.getString(cursor.getColumnIndexOrThrow("mvno_match_data")));
        return apn;
    }

    private final ArrayList<ApnSetting> $$robo$$com_android_internal_telephony_dataconnection_DcTracker$createApnList(Cursor cursor) {
        ArrayList<ApnSetting> mnoApns = new ArrayList<ApnSetting>();
        ArrayList<ApnSetting> mvnoApns = new ArrayList<ApnSetting>();
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (cursor.moveToFirst()) {
            do {
                ApnSetting apn;
                if ((apn = this.makeApnSetting(cursor)) == null) continue;
                if (apn.hasMvnoParams()) {
                    if (r == null || !this.mvnoMatches(r, apn.mvnoType, apn.mvnoMatchData)) continue;
                    mvnoApns.add(apn);
                    continue;
                }
                mnoApns.add(apn);
            } while (cursor.moveToNext());
        }
        ArrayList<ApnSetting> result = mvnoApns.isEmpty() ? mnoApns : mvnoApns;
        this.log("createApnList: X result=" + result);
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$dataConnectionNotInUse(DcAsyncChannel dcac) {
        this.log("dataConnectionNotInUse: check if dcac is inuse dcac=" + dcac);
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (apnContext.getDcAc() != dcac) continue;
            this.log("dataConnectionNotInUse: in use by apnContext=" + apnContext);
            return false;
        }
        this.log("dataConnectionNotInUse: tearDownAll");
        dcac.tearDownAll("No connection", null);
        this.log("dataConnectionNotInUse: not in use return true");
        return true;
    }

    private final DcAsyncChannel $$robo$$com_android_internal_telephony_dataconnection_DcTracker$findFreeDataConnection() {
        for (DcAsyncChannel dcac : this.mDataConnectionAcHashMap.values()) {
            if (!dcac.isInactiveSync() || !this.dataConnectionNotInUse(dcac)) continue;
            this.log("findFreeDataConnection: found free DataConnection= dcac=" + dcac);
            return dcac;
        }
        this.log("findFreeDataConnection: NO free DataConnection");
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setupData(ApnContext apnContext, int radioTech) {
        ApnSetting dcacApnSetting;
        this.log("setupData: apnContext=" + apnContext);
        DcAsyncChannel dcac = null;
        ApnSetting apnSetting = apnContext.getNextWaitingApn();
        if (apnSetting == null) {
            this.log("setupData: return for no apn found!");
            return false;
        }
        int profileId = apnSetting.profileId;
        if (profileId == 0) {
            profileId = this.getApnProfileID(apnContext.getApnType());
        }
        if (!(apnContext.getApnType() == "dun" && this.teardownForDun() || (dcac = this.checkForCompatibleConnectedApnContext(apnContext)) == null || (dcacApnSetting = dcac.getApnSettingSync()) == null)) {
            apnSetting = dcacApnSetting;
        }
        if (dcac == null) {
            if (this.isOnlySingleDcAllowed(radioTech)) {
                if (this.isHigherPriorityApnContextActive(apnContext)) {
                    this.log("setupData: Higher priority ApnContext active.  Ignoring call");
                    return false;
                }
                if (this.cleanUpAllConnections(true, "SinglePdnArbitration")) {
                    this.log("setupData: Some calls are disconnecting first.  Wait and retry");
                    return false;
                }
                this.log("setupData: Single pdp. Continue setting up data call.");
            }
            if ((dcac = this.findFreeDataConnection()) == null) {
                dcac = this.createDataConnection();
            }
            if (dcac == null) {
                this.log("setupData: No free DataConnection and couldn't create one, WEIRD");
                return false;
            }
        }
        this.log("setupData: dcac=" + dcac + " apnSetting=" + apnSetting);
        apnContext.setDataConnectionAc(dcac);
        apnContext.setApnSetting(apnSetting);
        apnContext.setState(DctConstants.State.CONNECTING);
        this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
        Message msg = this.obtainMessage();
        msg.what = 270336;
        msg.obj = apnContext;
        dcac.bringUp(apnContext, this.getInitialMaxRetry(), profileId, radioTech, this.mAutoAttachOnCreation, msg);
        this.log("setupData: initing!");
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onApnChanged() {
        boolean isDisconnected;
        DctConstants.State overallState = this.getOverallState();
        boolean bl = isDisconnected = overallState == DctConstants.State.IDLE || overallState == DctConstants.State.FAILED;
        if (this.mPhone instanceof GSMPhone) {
            ((GSMPhone)this.mPhone).updateCurrentCarrierInProvider();
        }
        this.log("onApnChanged: createAllApnList and cleanUpAllConnections");
        this.createAllApnList();
        this.setInitialAttachApn();
        this.cleanUpAllConnections(!isDisconnected, "apnChanged");
        this.setupDataOnConnectableApns("apnChanged");
    }

    private final DcAsyncChannel $$robo$$com_android_internal_telephony_dataconnection_DcTracker$findDataConnectionAcByCid(int cid) {
        for (DcAsyncChannel dcac : this.mDataConnectionAcHashMap.values()) {
            if (dcac.getCidSync() != cid) continue;
            return dcac;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$gotoIdleAndNotifyDataConnection(String reason) {
        this.log("gotoIdleAndNotifyDataConnection: reason=" + reason);
        this.notifyDataConnection(reason);
        this.mActiveApn = null;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isHigherPriorityApnContextActive(ApnContext apnContext) {
        for (ApnContext otherContext : this.mPrioritySortedApnContexts) {
            if (apnContext.getApnType().equalsIgnoreCase(otherContext.getApnType())) {
                return false;
            }
            if (!otherContext.isEnabled() || otherContext.getState() == DctConstants.State.FAILED) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isOnlySingleDcAllowed(int rilRadioTech) {
        int[] singleDcRats = this.mPhone.getContext().getResources().getIntArray(17236013);
        boolean onlySingleDcAllowed = false;
        if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean("persist.telephony.test.singleDc", false)) {
            onlySingleDcAllowed = true;
        }
        if (singleDcRats != null) {
            for (int i = 0; i < singleDcRats.length && !onlySingleDcAllowed; ++i) {
                if (rilRadioTech != singleDcRats[i]) continue;
                onlySingleDcAllowed = true;
            }
        }
        this.log("isOnlySingleDcAllowed(" + rilRadioTech + "): " + onlySingleDcAllowed);
        return onlySingleDcAllowed;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$restartRadio() {
        this.log("restartRadio: ************TURN OFF RADIO**************");
        this.cleanUpAllConnections(true, "radioTurnedOff");
        this.mPhone.getServiceStateTracker().powerOffRadioSafely(this);
        int reset = Integer.parseInt(SystemProperties.get("net.ppp.reset-by-timeout", "0"));
        SystemProperties.set("net.ppp.reset-by-timeout", String.valueOf(reset + 1));
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$retryAfterDisconnected(ApnContext apnContext) {
        boolean retry = true;
        String reason = apnContext.getReason();
        if ("radioTurnedOff".equals(reason) || this.isOnlySingleDcAllowed(this.mPhone.getServiceState().getRilDataRadioTechnology()) && this.isHigherPriorityApnContextActive(apnContext)) {
            retry = false;
        }
        return retry;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$startAlarmForReconnect(int delay, ApnContext apnContext) {
        String apnType = apnContext.getApnType();
        Intent intent = new Intent("com.android.internal.telephony.data-reconnect." + apnType);
        intent.putExtra("reconnect_alarm_extra_reason", apnContext.getReason());
        intent.putExtra("reconnect_alarm_extra_type", apnType);
        long subId = SubscriptionManager.getDefaultDataSubId();
        intent.putExtra("subscription", subId);
        this.log("startAlarmForReconnect: delay=" + delay + " action=" + intent.getAction() + " apn=" + apnContext);
        PendingIntent alarmIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
        apnContext.setReconnectIntent(alarmIntent);
        this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + (long)delay, alarmIntent);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$startAlarmForRestartTrySetup(int delay, ApnContext apnContext) {
        String apnType = apnContext.getApnType();
        Intent intent = new Intent("com.android.internal.telephony.data-restart-trysetup." + apnType);
        intent.putExtra("restart_trysetup_alarm_extra_type", apnType);
        this.log("startAlarmForRestartTrySetup: delay=" + delay + " action=" + intent.getAction() + " apn=" + apnContext);
        PendingIntent alarmIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
        apnContext.setReconnectIntent(alarmIntent);
        this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + (long)delay, alarmIntent);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$notifyNoData(DcFailCause lastFailCauseCode, ApnContext apnContext) {
        this.log("notifyNoData: type=" + apnContext.getApnType());
        if (this.isPermanentFail(lastFailCauseCode) && !apnContext.getApnType().equals("default")) {
            this.mPhone.notifyDataConnectionFailed(apnContext.getReason(), apnContext.getApnType());
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onRecordsLoaded() {
        this.log("onRecordsLoaded: createAllApnList");
        this.mAutoAttachOnCreationConfig = this.mPhone.getContext().getResources().getBoolean(17956983);
        this.createAllApnList();
        this.setInitialAttachApn();
        if (this.mPhone.mCi.getRadioState().isOn()) {
            this.log("onRecordsLoaded: notifying data availability");
            this.notifyOffApnsOfAvailability("simLoaded");
        }
        this.setupDataOnConnectableApns("simLoaded");
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onSetDependencyMet(String apnType, boolean met) {
        if ("hipri".equals(apnType)) {
            return;
        }
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(apnType);
        if (apnContext == null) {
            this.loge("onSetDependencyMet: ApnContext not found in onSetDependencyMet(" + apnType + ", " + met + ")");
            return;
        }
        this.applyNewState(apnContext, apnContext.isEnabled(), met);
        if ("default".equals(apnType) && (apnContext = (ApnContext)this.mApnContexts.get("hipri")) != null) {
            this.applyNewState(apnContext, apnContext.isEnabled(), met);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$applyNewState(ApnContext apnContext, boolean enabled, boolean met) {
        boolean cleanup = false;
        boolean trySetup = false;
        this.log("applyNewState(" + apnContext.getApnType() + ", " + enabled + "(" + apnContext.isEnabled() + "), " + met + "(" + apnContext.getDependencyMet() + "))");
        if (apnContext.isReady()) {
            cleanup = true;
            if (enabled && met) {
                DctConstants.State state = apnContext.getState();
                switch (1.$SwitchMap$com$android$internal$telephony$DctConstants$State[state.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 6: {
                        this.log("applyNewState: 'ready' so return");
                        return;
                    }
                    case 3: 
                    case 5: 
                    case 7: {
                        trySetup = true;
                        apnContext.setReason("dataEnabled");
                    }
                }
            } else if (met) {
                apnContext.setReason("dataDisabled");
                cleanup = apnContext.getApnType() == "dun" && this.teardownForDun();
            } else {
                apnContext.setReason("dependencyUnmet");
            }
        } else if (enabled && met) {
            if (apnContext.isEnabled()) {
                apnContext.setReason("dependencyMet");
            } else {
                apnContext.setReason("dataEnabled");
            }
            if (apnContext.getState() == DctConstants.State.FAILED) {
                apnContext.setState(DctConstants.State.IDLE);
            }
            trySetup = true;
        }
        apnContext.setEnabled(enabled);
        apnContext.setDependencyMet(met);
        if (cleanup) {
            this.cleanUpConnection(true, apnContext);
        }
        if (trySetup) {
            this.trySetupData(apnContext);
        }
    }

    private final DcAsyncChannel $$robo$$com_android_internal_telephony_dataconnection_DcTracker$checkForCompatibleConnectedApnContext(ApnContext apnContext) {
        String apnType = apnContext.getApnType();
        ApnSetting dunSetting = null;
        if ("dun".equals(apnType)) {
            dunSetting = this.fetchDunApn();
        }
        this.log("checkForCompatibleConnectedApnContext: apnContext=" + apnContext);
        DcAsyncChannel potentialDcac = null;
        ApnContext potentialApnCtx = null;
        for (ApnContext curApnCtx : this.mApnContexts.values()) {
            DcAsyncChannel curDcac = curApnCtx.getDcAc();
            this.log("curDcac: " + curDcac);
            if (curDcac == null) continue;
            ApnSetting apnSetting = curApnCtx.getApnSetting();
            this.log("apnSetting: " + apnSetting);
            if (dunSetting != null) {
                if (!dunSetting.equals(apnSetting)) continue;
                switch (1.$SwitchMap$com$android$internal$telephony$DctConstants$State[curApnCtx.getState().ordinal()]) {
                    case 1: {
                        this.log("checkForCompatibleConnectedApnContext: found dun conn=" + curDcac + " curApnCtx=" + curApnCtx);
                        return curDcac;
                    }
                    case 3: 
                    case 4: {
                        potentialDcac = curDcac;
                        potentialApnCtx = curApnCtx;
                    }
                }
                continue;
            }
            if (apnSetting == null || !apnSetting.canHandleType(apnType)) continue;
            switch (1.$SwitchMap$com$android$internal$telephony$DctConstants$State[curApnCtx.getState().ordinal()]) {
                case 1: {
                    this.log("checkForCompatibleConnectedApnContext: found canHandle conn=" + curDcac + " curApnCtx=" + curApnCtx);
                    return curDcac;
                }
                case 3: 
                case 4: {
                    potentialDcac = curDcac;
                    potentialApnCtx = curApnCtx;
                }
            }
        }
        if (potentialDcac != null) {
            this.log("checkForCompatibleConnectedApnContext: found potential conn=" + potentialDcac + " curApnCtx=" + potentialApnCtx);
            return potentialDcac;
        }
        this.log("checkForCompatibleConnectedApnContext: NO conn apnContext=" + apnContext);
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onEnableApn(int apnId, int enabled) {
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(this.apnIdToType(apnId));
        if (apnContext == null) {
            this.loge("onEnableApn(" + apnId + ", " + enabled + "): NO ApnContext");
            return;
        }
        this.log("onEnableApn: apnContext=" + apnContext + " call applyNewState");
        this.applyNewState(apnContext, enabled == 1, apnContext.getDependencyMet());
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onTrySetupData(String reason) {
        this.log("onTrySetupData: reason=" + reason);
        this.setupDataOnConnectableApns(reason);
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onTrySetupData(ApnContext apnContext) {
        this.log("onTrySetupData: apnContext=" + apnContext);
        return this.trySetupData(apnContext);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onRoamingOff() {
        this.log("onRoamingOff");
        if (!this.mUserDataEnabled) {
            return;
        }
        if (!this.getDataOnRoamingEnabled()) {
            this.notifyOffApnsOfAvailability("roamingOff");
            this.setupDataOnConnectableApns("roamingOff");
        } else {
            this.notifyDataConnection("roamingOff");
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onRoamingOn() {
        if (!this.mUserDataEnabled) {
            return;
        }
        if (this.getDataOnRoamingEnabled()) {
            this.log("onRoamingOn: setup data on roaming");
            this.setupDataOnConnectableApns("roamingOn");
            this.notifyDataConnection("roamingOn");
        } else {
            this.log("onRoamingOn: Tear down data connection on roaming.");
            this.cleanUpAllConnections(true, "roamingOn");
            this.notifyOffApnsOfAvailability("roamingOn");
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onRadioAvailable() {
        IccRecords r;
        this.log("onRadioAvailable");
        if (this.mPhone.getSimulatedRadioControl() != null) {
            this.notifyDataConnection(null);
            this.log("onRadioAvailable: We're on the simulator; assuming data is connected");
        }
        if ((r = (IccRecords)this.mIccRecords.get()) != null && r.getRecordsLoaded()) {
            this.notifyOffApnsOfAvailability(null);
        }
        if (this.getOverallState() != DctConstants.State.IDLE) {
            this.cleanUpConnection(true, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onRadioOffOrNotAvailable() {
        this.mReregisterOnReconnectFailure = false;
        if (this.mPhone.getSimulatedRadioControl() != null) {
            this.log("We're on the simulator; assuming radio off is meaningless");
        } else {
            this.log("onRadioOffOrNotAvailable: is off and clean up all connections");
            this.cleanUpAllConnections(false, "radioTurnedOff");
        }
        this.notifyOffApnsOfAvailability(null);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$completeConnection(ApnContext apnContext) {
        boolean isProvApn = apnContext.isProvisioningApn();
        this.log("completeConnection: successful, notify the world apnContext=" + apnContext);
        if (this.mIsProvisioning && !TextUtils.isEmpty(this.mProvisioningUrl)) {
            this.log("completeConnection: MOBILE_PROVISIONING_ACTION url=" + this.mProvisioningUrl);
            Intent newIntent = Intent.makeMainSelectorActivity("android.intent.action.MAIN", "android.intent.category.APP_BROWSER");
            newIntent.setData(Uri.parse(this.mProvisioningUrl));
            newIntent.setFlags(0x10400000);
            try {
                this.mPhone.getContext().startActivity(newIntent);
            }
            catch (ActivityNotFoundException e) {
                this.loge("completeConnection: startActivityAsUser failed" + e);
            }
        }
        this.mIsProvisioning = false;
        this.mProvisioningUrl = null;
        if (this.mProvisioningSpinner != null) {
            this.sendMessage(this.obtainMessage(270378, this.mProvisioningSpinner));
        }
        this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
        this.startNetStatPoll();
        this.startDataStallAlarm(false);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDataSetupComplete(AsyncResult ar) {
        DcFailCause cause = DcFailCause.UNKNOWN;
        boolean handleError = false;
        ApnContext apnContext = null;
        if (!(ar.userObj instanceof ApnContext)) {
            throw new RuntimeException("onDataSetupComplete: No apnContext");
        }
        apnContext = (ApnContext)ar.userObj;
        if (ar.exception == null) {
            DcAsyncChannel dcac = apnContext.getDcAc();
            if (dcac == null) {
                this.log("onDataSetupComplete: no connection to DC, handle as error");
                cause = DcFailCause.CONNECTION_TO_DATACONNECTIONAC_BROKEN;
                handleError = true;
            } else {
                ApnSetting apn = apnContext.getApnSetting();
                this.log("onDataSetupComplete: success apn=" + (apn == null ? "unknown" : apn.apn));
                if (apn != null && apn.proxy != null && apn.proxy.length() != 0) {
                    try {
                        String port = apn.port;
                        if (TextUtils.isEmpty(port)) {
                            port = "8080";
                        }
                        ProxyInfo proxy = new ProxyInfo(apn.proxy, Integer.parseInt(port), null);
                        dcac.setLinkPropertiesHttpProxySync(proxy);
                    }
                    catch (NumberFormatException e) {
                        this.loge("onDataSetupComplete: NumberFormatException making ProxyProperties (" + apn.port + "): " + e);
                    }
                }
                if (TextUtils.equals(apnContext.getApnType(), "default")) {
                    SystemProperties.set("gsm.defaultpdpcontext.active", "true");
                    if (this.mCanSetPreferApn && this.mPreferredApn == null) {
                        this.log("onDataSetupComplete: PREFERED APN is null");
                        this.mPreferredApn = apn;
                        if (this.mPreferredApn != null) {
                            this.setPreferredApn(this.mPreferredApn.id);
                        }
                    }
                } else {
                    SystemProperties.set("gsm.defaultpdpcontext.active", "false");
                }
                apnContext.setState(DctConstants.State.CONNECTED);
                boolean isProvApn = apnContext.isProvisioningApn();
                ConnectivityManager cm = ConnectivityManager.from(this.mPhone.getContext());
                if (this.mProvisionBroadcastReceiver != null) {
                    this.mPhone.getContext().unregisterReceiver(this.mProvisionBroadcastReceiver);
                    this.mProvisionBroadcastReceiver = null;
                }
                if (!isProvApn || this.mIsProvisioning) {
                    cm.setProvisioningNotificationVisible(false, 0, this.mProvisionActionName);
                    this.completeConnection(apnContext);
                } else {
                    NetworkCapabilities networkCapabilities;
                    this.log("onDataSetupComplete: successful, BUT send connected to prov apn as mIsProvisioning:" + this.mIsProvisioning + " == false" + " && (isProvisioningApn:" + isProvApn + " == true");
                    this.mProvisionBroadcastReceiver = new ProvisionNotificationBroadcastReceiver(this, cm.getMobileProvisioningUrl(), TelephonyManager.getDefault().getNetworkOperatorName());
                    this.mPhone.getContext().registerReceiver(this.mProvisionBroadcastReceiver, new IntentFilter(this.mProvisionActionName));
                    cm.setProvisioningNotificationVisible(true, 0, this.mProvisionActionName);
                    this.setRadio(false);
                    Intent intent = new Intent("android.intent.action.DATA_CONNECTION_CONNECTED_TO_PROVISIONING_APN");
                    intent.putExtra("apn", apnContext.getApnSetting().apn);
                    intent.putExtra("apnType", apnContext.getApnType());
                    String apnType = apnContext.getApnType();
                    LinkProperties linkProperties = this.getLinkProperties(apnType);
                    if (linkProperties != null) {
                        intent.putExtra("linkProperties", linkProperties);
                        String iface = linkProperties.getInterfaceName();
                        if (iface != null) {
                            intent.putExtra("iface", iface);
                        }
                    }
                    if ((networkCapabilities = this.getNetworkCapabilities(apnType)) != null) {
                        intent.putExtra("networkCapabilities", networkCapabilities);
                    }
                    this.mPhone.getContext().sendBroadcastAsUser(intent, UserHandle.ALL);
                }
                this.log("onDataSetupComplete: SETUP complete type=" + apnContext.getApnType() + ", reason:" + apnContext.getReason());
            }
        } else {
            cause = (DcFailCause)((Object)ar.result);
            ApnSetting apn = apnContext.getApnSetting();
            this.log(String.format("onDataSetupComplete: error apn=%s cause=%s", new Object[]{apn == null ? "unknown" : apn.apn, cause}));
            if (cause.isEventLoggable()) {
                int cid = this.getCellLocationId();
                EventLog.writeEvent(50105, cause.ordinal(), cid, TelephonyManager.getDefault().getNetworkType());
            }
            apn = apnContext.getApnSetting();
            this.mPhone.notifyPreciseDataConnectionFailed(apnContext.getReason(), apnContext.getApnType(), apn != null ? apn.apn : "unknown", cause.toString());
            if (this.isPermanentFail(cause)) {
                apnContext.decWaitingApnsPermFailCount();
            }
            apnContext.removeWaitingApn(apnContext.getApnSetting());
            this.log(String.format("onDataSetupComplete: WaitingApns.size=%d WaitingApnsPermFailureCountDown=%d", apnContext.getWaitingApns().size(), apnContext.getWaitingApnsPermFailCount()));
            handleError = true;
        }
        if (handleError) {
            this.onDataSetupCompleteError(ar);
        }
        if (!this.mInternalDataEnabled) {
            this.cleanUpAllConnections(null);
        }
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getApnDelay() {
        if (this.mFailFast) {
            return SystemProperties.getInt("persist.radio.apn_ff_delay", 3000);
        }
        return SystemProperties.getInt("persist.radio.apn_delay", 20000);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDataSetupCompleteError(AsyncResult ar) {
        String reason = "";
        ApnContext apnContext = null;
        if (!(ar.userObj instanceof ApnContext)) {
            throw new RuntimeException("onDataSetupCompleteError: No apnContext");
        }
        apnContext = (ApnContext)ar.userObj;
        if (apnContext.getWaitingApns().isEmpty()) {
            apnContext.setState(DctConstants.State.FAILED);
            this.mPhone.notifyDataConnection("apnFailed", apnContext.getApnType());
            apnContext.setDataConnectionAc(null);
            if (apnContext.getWaitingApnsPermFailCount() == 0) {
                this.log("onDataSetupCompleteError: All APN's had permanent failures, stop retrying");
            } else {
                int delay = this.getApnDelay();
                this.log("onDataSetupCompleteError: Not all APN's had permanent failures delay=" + delay);
                this.startAlarmForRestartTrySetup(delay, apnContext);
            }
        } else {
            this.log("onDataSetupCompleteError: Try next APN");
            apnContext.setState(DctConstants.State.SCANNING);
            this.startAlarmForReconnect(this.getApnDelay(), apnContext);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDisconnectDone(int connId, AsyncResult ar) {
        ApnContext apnContext = null;
        if (!(ar.userObj instanceof ApnContext)) {
            this.loge("onDisconnectDone: Invalid ar in onDisconnectDone, ignore");
            return;
        }
        apnContext = (ApnContext)ar.userObj;
        this.log("onDisconnectDone: EVENT_DISCONNECT_DONE apnContext=" + apnContext);
        apnContext.setState(DctConstants.State.IDLE);
        this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
        if (this.isDisconnected() && this.mPhone.getServiceStateTracker().processPendingRadioPowerOffAfterDataOff()) {
            this.log("onDisconnectDone: radio will be turned off, no retries");
            apnContext.setApnSetting(null);
            apnContext.setDataConnectionAc(null);
            if (this.mDisconnectPendingCount > 0) {
                --this.mDisconnectPendingCount;
            }
            if (this.mDisconnectPendingCount == 0) {
                this.notifyDataDisconnectComplete();
                this.notifyAllDataDisconnected();
            }
            return;
        }
        if (this.mAttached.get() && apnContext.isReady() && this.retryAfterDisconnected(apnContext)) {
            SystemProperties.set("gsm.defaultpdpcontext.active", "false");
            this.log("onDisconnectDone: attached, ready and retry after disconnect");
            this.startAlarmForReconnect(this.getApnDelay(), apnContext);
        } else {
            boolean restartRadioAfterProvisioning = this.mPhone.getContext().getResources().getBoolean(17956965);
            if (apnContext.isProvisioningApn() && restartRadioAfterProvisioning) {
                this.log("onDisconnectDone: restartRadio after provisioning");
                this.restartRadio();
            }
            apnContext.setApnSetting(null);
            apnContext.setDataConnectionAc(null);
            if (this.isOnlySingleDcAllowed(this.mPhone.getServiceState().getRilDataRadioTechnology())) {
                this.log("onDisconnectDone: isOnlySigneDcAllowed true so setup single apn");
                this.setupDataOnConnectableApns("SinglePdnArbitration");
            } else {
                this.log("onDisconnectDone: not retrying");
            }
        }
        if (this.mDisconnectPendingCount > 0) {
            --this.mDisconnectPendingCount;
        }
        if (this.mDisconnectPendingCount == 0) {
            this.notifyDataDisconnectComplete();
            this.notifyAllDataDisconnected();
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDisconnectDcRetrying(int connId, AsyncResult ar) {
        ApnContext apnContext = null;
        if (!(ar.userObj instanceof ApnContext)) {
            this.loge("onDisconnectDcRetrying: Invalid ar in onDisconnectDone, ignore");
            return;
        }
        apnContext = (ApnContext)ar.userObj;
        apnContext.setState(DctConstants.State.RETRYING);
        this.log("onDisconnectDcRetrying: apnContext=" + apnContext);
        this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onVoiceCallStarted() {
        this.log("onVoiceCallStarted");
        this.mInVoiceCall = true;
        if (this.isConnected() && !this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
            this.log("onVoiceCallStarted stop polling");
            this.stopNetStatPoll();
            this.stopDataStallAlarm();
            this.notifyDataConnection("2GVoiceCallStarted");
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onVoiceCallEnded() {
        this.log("onVoiceCallEnded");
        this.mInVoiceCall = false;
        if (this.isConnected()) {
            if (!this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
                this.startNetStatPoll();
                this.startDataStallAlarm(false);
                this.notifyDataConnection("2GVoiceCallEnded");
            } else {
                this.resetPollStats();
            }
        }
        this.setupDataOnConnectableApns("2GVoiceCallEnded");
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onCleanUpConnection(boolean tearDown, int apnId, String reason) {
        this.log("onCleanUpConnection");
        ApnContext apnContext = (ApnContext)this.mApnContexts.get(this.apnIdToType(apnId));
        if (apnContext != null) {
            apnContext.setReason(reason);
            this.cleanUpConnection(tearDown, apnContext);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isConnected() {
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (apnContext.getState() != DctConstants.State.CONNECTED) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isDisconnected() {
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (apnContext.isDisconnected()) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$notifyDataConnection(String reason) {
        this.log("notifyDataConnection: reason=" + reason);
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (!this.mAttached.get() || !apnContext.isReady()) continue;
            this.log("notifyDataConnection: type:" + apnContext.getApnType());
            this.mPhone.notifyDataConnection(reason != null ? reason : apnContext.getReason(), apnContext.getApnType());
        }
        this.notifyOffApnsOfAvailability(reason);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$createAllApnList() {
        String operator;
        this.mAllApnSettings = new ArrayList();
        IccRecords r = (IccRecords)this.mIccRecords.get();
        String string2 = operator = r != null ? r.getOperatorNumeric() : "";
        if (operator != null) {
            String selection = "numeric = '" + operator + "'";
            this.log("createAllApnList: selection=" + selection);
            Cursor cursor = this.mPhone.getContext().getContentResolver().query(Telephony.Carriers.CONTENT_URI, null, selection, null, null);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    this.mAllApnSettings = this.createApnList(cursor);
                }
                cursor.close();
            }
        }
        this.addEmergencyApnSetting();
        this.dedupeApnSettings();
        if (this.mAllApnSettings.isEmpty()) {
            this.log("createAllApnList: No APN found for carrier: " + operator);
            this.mPreferredApn = null;
        } else {
            this.mPreferredApn = this.getPreferredApn();
            if (this.mPreferredApn != null && !this.mPreferredApn.numeric.equals(operator)) {
                this.mPreferredApn = null;
                this.setPreferredApn(-1);
            }
            this.log("createAllApnList: mPreferredApn=" + this.mPreferredApn);
        }
        this.log("createAllApnList: X mAllApnSettings=" + this.mAllApnSettings);
        this.setDataProfilesAsNeeded();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$dedupeApnSettings() {
        ArrayList resultApns = new ArrayList();
        for (int i = 0; i < this.mAllApnSettings.size() - 1; ++i) {
            ApnSetting first = (ApnSetting)this.mAllApnSettings.get(i);
            ApnSetting second = null;
            int j = i + 1;
            while (j < this.mAllApnSettings.size()) {
                second = (ApnSetting)this.mAllApnSettings.get(j);
                if (this.apnsSimilar(first, second)) {
                    ApnSetting newApn = this.mergeApns(first, second);
                    this.mAllApnSettings.set(i, newApn);
                    first = newApn;
                    this.mAllApnSettings.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$apnTypeSameAny(ApnSetting first, ApnSetting second) {
        for (int index1 = 0; index1 < first.types.length; ++index1) {
            for (int index2 = 0; index2 < second.types.length; ++index2) {
                if (!first.types[index1].equals("*") && !second.types[index2].equals("*") && !first.types[index1].equals(second.types[index2])) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$apnsSimilar(ApnSetting first, ApnSetting second) {
        return !first.canHandleType("dun") && !second.canHandleType("dun") && Objects.equals(first.apn, second.apn) && !this.apnTypeSameAny(first, second) && this.xorEquals(first.proxy, second.proxy) && this.xorEquals(first.port, second.port) && first.carrierEnabled == second.carrierEnabled && first.bearer == second.bearer && first.profileId == second.profileId && Objects.equals(first.mvnoType, second.mvnoType) && Objects.equals(first.mvnoMatchData, second.mvnoMatchData) && this.xorEquals(first.mmsc, second.mmsc) && this.xorEquals(first.mmsProxy, second.mmsProxy) && this.xorEquals(first.mmsPort, second.mmsPort);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$xorEquals(String first, String second) {
        return Objects.equals(first, second) || TextUtils.isEmpty(first) || TextUtils.isEmpty(second);
    }

    private final ApnSetting $$robo$$com_android_internal_telephony_dataconnection_DcTracker$mergeApns(ApnSetting dest, ApnSetting src) {
        ArrayList<String> resultTypes = new ArrayList<String>();
        resultTypes.addAll(Arrays.asList(dest.types));
        for (String srcType : src.types) {
            if (resultTypes.contains(srcType)) continue;
            resultTypes.add(srcType);
        }
        String mmsc = TextUtils.isEmpty(dest.mmsc) ? src.mmsc : dest.mmsc;
        String mmsProxy = TextUtils.isEmpty(dest.mmsProxy) ? src.mmsProxy : dest.mmsProxy;
        String mmsPort = TextUtils.isEmpty(dest.mmsPort) ? src.mmsPort : dest.mmsPort;
        String proxy = TextUtils.isEmpty(dest.proxy) ? src.proxy : dest.proxy;
        String port = TextUtils.isEmpty(dest.port) ? src.port : dest.port;
        String protocol = src.protocol.equals("IPV4V6") ? src.protocol : dest.protocol;
        String roamingProtocol = src.roamingProtocol.equals("IPV4V6") ? src.roamingProtocol : dest.roamingProtocol;
        return new ApnSetting(dest.id, dest.numeric, dest.carrier, dest.apn, proxy, port, mmsc, mmsProxy, mmsPort, dest.user, dest.password, dest.authType, resultTypes.toArray(new String[0]), protocol, roamingProtocol, dest.carrierEnabled, dest.bearer, dest.profileId, dest.modemCognitive || src.modemCognitive, dest.maxConns, dest.waitTime, dest.maxConnsTime, dest.mtu, dest.mvnoType, dest.mvnoMatchData);
    }

    private final DcAsyncChannel $$robo$$com_android_internal_telephony_dataconnection_DcTracker$createDataConnection() {
        this.log("createDataConnection E");
        int id2 = this.mUniqueIdGenerator.getAndIncrement();
        DataConnection conn = DataConnection.makeDataConnection(this.mPhone, id2, this, this.mDcTesterFailBringUpAll, this.mDcc);
        this.mDataConnections.put(id2, conn);
        DcAsyncChannel dcac = new DcAsyncChannel(conn, "DCT");
        int status = dcac.fullyConnectSync(this.mPhone.getContext(), this, conn.getHandler());
        if (status == 0) {
            this.mDataConnectionAcHashMap.put(dcac.getDataConnectionIdSync(), dcac);
        } else {
            this.loge("createDataConnection: Could not connect to dcac=" + dcac + " status=" + status);
        }
        this.log("createDataConnection() X id=" + id2 + " dc=" + conn);
        return dcac;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$destroyDataConnections() {
        if (this.mDataConnections != null) {
            this.log("destroyDataConnections: clear mDataConnectionList");
            this.mDataConnections.clear();
        } else {
            this.log("destroyDataConnections: mDataConnecitonList is empty, ignore");
        }
    }

    private final ArrayList<ApnSetting> $$robo$$com_android_internal_telephony_dataconnection_DcTracker$buildWaitingApns(String requestedApnType, int radioTech) {
        ApnSetting dun;
        this.log("buildWaitingApns: E requestedApnType=" + requestedApnType);
        ArrayList<ApnSetting> apnList = new ArrayList<ApnSetting>();
        if (requestedApnType.equals("dun") && (dun = this.fetchDunApn()) != null) {
            apnList.add(dun);
            this.log("buildWaitingApns: X added APN_TYPE_DUN apnList=" + apnList);
            return apnList;
        }
        IccRecords r = (IccRecords)this.mIccRecords.get();
        String operator = r != null ? r.getOperatorNumeric() : "";
        boolean usePreferred = true;
        try {
            usePreferred = !this.mPhone.getContext().getResources().getBoolean(17956964);
        }
        catch (Resources.NotFoundException e) {
            this.log("buildWaitingApns: usePreferred NotFoundException set to true");
            usePreferred = true;
        }
        this.log("buildWaitingApns: usePreferred=" + usePreferred + " canSetPreferApn=" + this.mCanSetPreferApn + " mPreferredApn=" + this.mPreferredApn + " operator=" + operator + " radioTech=" + radioTech + " IccRecords r=" + r);
        if (usePreferred && this.mCanSetPreferApn && this.mPreferredApn != null && this.mPreferredApn.canHandleType(requestedApnType)) {
            this.log("buildWaitingApns: Preferred APN:" + operator + ":" + this.mPreferredApn.numeric + ":" + this.mPreferredApn);
            if (this.mPreferredApn.numeric.equals(operator)) {
                if (this.mPreferredApn.bearer == 0 || this.mPreferredApn.bearer == radioTech) {
                    apnList.add(this.mPreferredApn);
                    this.log("buildWaitingApns: X added preferred apnList=" + apnList);
                    return apnList;
                }
                this.log("buildWaitingApns: no preferred APN");
                this.setPreferredApn(-1);
                this.mPreferredApn = null;
            } else {
                this.log("buildWaitingApns: no preferred APN");
                this.setPreferredApn(-1);
                this.mPreferredApn = null;
            }
        }
        if (this.mAllApnSettings != null) {
            this.log("buildWaitingApns: mAllApnSettings=" + this.mAllApnSettings);
            for (ApnSetting apn : this.mAllApnSettings) {
                this.log("buildWaitingApns: apn=" + apn);
                if (apn.canHandleType(requestedApnType)) {
                    if (apn.bearer == 0 || apn.bearer == radioTech) {
                        this.log("buildWaitingApns: adding apn=" + apn.toString());
                        apnList.add(apn);
                        continue;
                    }
                    this.log("buildWaitingApns: bearer:" + apn.bearer + " != " + "radioTech:" + radioTech);
                    continue;
                }
                this.log("buildWaitingApns: couldn't handle requesedApnType=" + requestedApnType);
            }
        } else {
            this.loge("mAllApnSettings is empty!");
        }
        this.log("buildWaitingApns: X apnList=" + apnList);
        return apnList;
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DcTracker$apnListToString(ArrayList<ApnSetting> apns) {
        StringBuilder result = new StringBuilder();
        int size = apns.size();
        for (int i = 0; i < size; ++i) {
            result.append('[').append(apns.get(i).toString()).append(']');
        }
        return result.toString();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setPreferredApn(int pos) {
        if (!this.mCanSetPreferApn) {
            this.log("setPreferredApn: X !canSEtPreferApn");
            return;
        }
        this.log("setPreferredApn: delete");
        ContentResolver resolver = this.mPhone.getContext().getContentResolver();
        resolver.delete(PREFERAPN_NO_UPDATE_URI, null, null);
        if (pos >= 0) {
            this.log("setPreferredApn: insert");
            ContentValues values = new ContentValues();
            values.put("apn_id", pos);
            resolver.insert(PREFERAPN_NO_UPDATE_URI, values);
        }
    }

    private final ApnSetting $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getPreferredApn() {
        if (this.mAllApnSettings.isEmpty()) {
            this.log("getPreferredApn: X not found mAllApnSettings.isEmpty");
            return null;
        }
        Cursor cursor = this.mPhone.getContext().getContentResolver().query(PREFERAPN_NO_UPDATE_URI, new String[]{"_id", "name", "apn"}, null, null, "name ASC");
        this.mCanSetPreferApn = cursor != null;
        this.log("getPreferredApn: mRequestedApnType=" + this.mRequestedApnType + " cursor=" + cursor + " cursor.count=" + (cursor != null ? cursor.getCount() : 0));
        if (this.mCanSetPreferApn && cursor.getCount() > 0) {
            cursor.moveToFirst();
            int pos = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            for (ApnSetting p : this.mAllApnSettings) {
                this.log("getPreferredApn: apnSetting=" + p);
                if (p.id != pos || !p.canHandleType(this.mRequestedApnType)) continue;
                this.log("getPreferredApn: X found apnSetting" + p);
                cursor.close();
                return p;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        this.log("getPreferredApn: X not found");
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$handleMessage(Message msg) {
        this.log("handleMessage msg=" + msg);
        if (!this.mPhone.mIsTheCurrentActivePhone || this.mIsDisposed) {
            this.loge("handleMessage: Ignore GSM msgs since GSM phone is inactive");
            return;
        }
        if (!this.isActiveDataSubscription()) {
            this.loge("Ignore msgs since phone is not the current DDS");
            return;
        }
        switch (msg.what) {
            case 270338: {
                this.onRecordsLoaded();
                break;
            }
            case 270345: {
                this.onDataConnectionDetached();
                break;
            }
            case 270352: {
                this.onDataConnectionAttached();
                break;
            }
            case 270354: {
                this.doRecovery();
                break;
            }
            case 270355: {
                this.onApnChanged();
                break;
            }
            case 270358: {
                this.log("EVENT_PS_RESTRICT_ENABLED " + this.mIsPsRestricted);
                this.stopNetStatPoll();
                this.stopDataStallAlarm();
                this.mIsPsRestricted = true;
                break;
            }
            case 270359: {
                ApnContext apnContext;
                this.log("EVENT_PS_RESTRICT_DISABLED " + this.mIsPsRestricted);
                this.mIsPsRestricted = false;
                if (this.isConnected()) {
                    this.startNetStatPoll();
                    this.startDataStallAlarm(false);
                    break;
                }
                if (this.mState == DctConstants.State.FAILED) {
                    this.cleanUpAllConnections(false, "psRestrictEnabled");
                    this.mReregisterOnReconnectFailure = false;
                }
                if ((apnContext = (ApnContext)this.mApnContexts.get("default")) != null) {
                    apnContext.setReason("psRestrictEnabled");
                    this.trySetupData(apnContext);
                    break;
                }
                this.loge("**** Default ApnContext not found ****");
                if (!Build.IS_DEBUGGABLE) break;
                throw new RuntimeException("Default ApnContext not found");
            }
            case 270339: {
                if (msg.obj instanceof ApnContext) {
                    this.onTrySetupData((ApnContext)msg.obj);
                    break;
                }
                if (msg.obj instanceof String) {
                    this.onTrySetupData((String)msg.obj);
                    break;
                }
                this.loge("EVENT_TRY_SETUP request w/o apnContext or String");
                break;
            }
            case 270360: {
                boolean tearDown = msg.arg1 != 0;
                this.log("EVENT_CLEAN_UP_CONNECTION tearDown=" + tearDown);
                if (msg.obj instanceof ApnContext) {
                    this.cleanUpConnection(tearDown, (ApnContext)msg.obj);
                    break;
                }
                this.loge("EVENT_CLEAN_UP_CONNECTION request w/o apn context, call super");
                super.handleMessage(msg);
                break;
            }
            case 270363: {
                boolean enabled = msg.arg1 == 1;
                this.onSetInternalDataEnabled(enabled, (Message)msg.obj);
                break;
            }
            case 270365: {
                Message mCause = this.obtainMessage(270365, null);
                if (msg.obj != null && msg.obj instanceof String) {
                    mCause.obj = msg.obj;
                }
                super.handleMessage(mCause);
                break;
            }
            case 270377: {
                this.setupDataOnConnectableApns("nwTypeChanged");
                break;
            }
            case 270378: {
                if (this.mProvisioningSpinner != msg.obj) break;
                this.mProvisioningSpinner.dismiss();
                this.mProvisioningSpinner = null;
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getApnProfileID(String apnType) {
        if (TextUtils.equals(apnType, "ims")) {
            return 2;
        }
        if (TextUtils.equals(apnType, "fota")) {
            return 3;
        }
        if (TextUtils.equals(apnType, "cbs")) {
            return 4;
        }
        if (TextUtils.equals(apnType, "ia")) {
            return 0;
        }
        if (TextUtils.equals(apnType, "dun")) {
            return 1;
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getCellLocationId() {
        int cid = -1;
        CellLocation loc = this.mPhone.getCellLocation();
        if (loc != null) {
            if (loc instanceof GsmCellLocation) {
                cid = ((GsmCellLocation)loc).getCid();
            } else if (loc instanceof CdmaCellLocation) {
                cid = ((CdmaCellLocation)loc).getBaseStationId();
            }
        }
        return cid;
    }

    private final IccRecords $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getUiccRecords(int appFamily) {
        return this.mUiccController.getIccRecords(this.mPhone.getPhoneId(), appFamily);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onUpdateIcc() {
        if (this.mUiccController == null) {
            return;
        }
        IccRecords newIccRecords = this.getUiccRecords(1);
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != newIccRecords) {
            if (r != null) {
                this.log("Removing stale icc objects.");
                r.unregisterForRecordsLoaded(this);
                this.mIccRecords.set(null);
            }
            if (newIccRecords != null) {
                this.log("New records found");
                this.mIccRecords.set(newIccRecords);
                newIccRecords.registerForRecordsLoaded(this, 270338, null);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$update() {
        this.log("update sub = " + this.mPhone.getSubId());
        if (this.isActiveDataSubscription()) {
            this.log("update(): Active DDS, register for all events now!");
            this.registerForAllEvents();
            this.onUpdateIcc();
            boolean bl = this.mUserDataEnabled = Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "mobile_data", 1) == 1;
            if (this.mPhone instanceof CDMALTEPhone) {
                ((CDMALTEPhone)this.mPhone).updateCurrentCarrierInProvider();
                this.supplyMessenger();
            } else if (this.mPhone instanceof GSMPhone) {
                ((GSMPhone)this.mPhone).updateCurrentCarrierInProvider();
                this.supplyMessenger();
            } else {
                this.log("Phone object is not MultiSim. This should not hit!!!!");
            }
        } else {
            this.unregisterForAllEvents();
            this.log("update(): NOT the active DDS, unregister for all events!");
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$cleanUpAllConnections(String cause) {
        this.cleanUpAllConnections(cause, null);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$updateRecords() {
        if (this.isActiveDataSubscription()) {
            this.onUpdateIcc();
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$cleanUpAllConnections(String cause, Message disconnectAllCompleteMsg) {
        this.log("cleanUpAllConnections");
        if (disconnectAllCompleteMsg != null) {
            this.mDisconnectAllCompleteMsgList.add(disconnectAllCompleteMsg);
        }
        Message msg = this.obtainMessage(270365);
        msg.obj = cause;
        this.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$notifyDataDisconnectComplete() {
        this.log("notifyDataDisconnectComplete");
        for (Message m : this.mDisconnectAllCompleteMsgList) {
            m.sendToTarget();
        }
        this.mDisconnectAllCompleteMsgList.clear();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$notifyAllDataDisconnected() {
        sEnableFailFastRefCounter = 0;
        this.mFailFast = false;
        this.mAllDataDisconnectedRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$registerForAllDataDisconnected(Handler h, int what, Object obj) {
        this.mAllDataDisconnectedRegistrants.addUnique(h, what, obj);
        if (this.isDisconnected()) {
            this.log("notify All Data Disconnected");
            this.notifyAllDataDisconnected();
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$unregisterForAllDataDisconnected(Handler h) {
        this.mAllDataDisconnectedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onSetInternalDataEnabled(boolean enable) {
        this.onSetInternalDataEnabled(enable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onSetInternalDataEnabled(boolean enabled, Message onCompleteMsg) {
        boolean sendOnComplete = true;
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            this.mInternalDataEnabled = enabled;
            if (enabled) {
                this.log("onSetInternalDataEnabled: changed to enabled, try to setup data call");
                this.onTrySetupData("dataEnabled");
            } else {
                sendOnComplete = false;
                this.log("onSetInternalDataEnabled: changed to disabled, cleanUpAllConnections");
                this.cleanUpAllConnections(null, onCompleteMsg);
            }
        }
        if (sendOnComplete && onCompleteMsg != null) {
            onCompleteMsg.sendToTarget();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setInternalDataEnabledFlag(boolean enable) {
        this.log("setInternalDataEnabledFlag(" + enable + ")");
        if (this.mInternalDataEnabled != enable) {
            this.mInternalDataEnabled = enable;
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setInternalDataEnabled(boolean enable) {
        return this.setInternalDataEnabled(enable, null);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setInternalDataEnabled(boolean enable, Message onCompleteMsg) {
        this.log("setInternalDataEnabled(" + enable + ")");
        Message msg = this.obtainMessage(270363, onCompleteMsg);
        msg.arg1 = enable ? 1 : 0;
        this.sendMessage(msg);
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isActiveDataSubscription() {
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setDataAllowed(boolean enable, Message response) {
        mIsCleanupRequired = !enable;
        this.mPhone.mCi.setDataAllowed(enable, response);
        this.mInternalDataEnabled = enable;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$log(String s) {
        Rlog.d("DCT", "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$loge(String s) {
        Rlog.e("DCT", "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("DataConnectionTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mReregisterOnReconnectFailure=" + this.mReregisterOnReconnectFailure);
        pw.println(" canSetPreferApn=" + this.mCanSetPreferApn);
        pw.println(" mApnObserver=" + this.mApnObserver);
        pw.println(" getOverallState=" + (Object)((Object)this.getOverallState()));
        pw.println(" mDataConnectionAsyncChannels=%s\n" + this.mDataConnectionAcHashMap);
        pw.println(" mAttached=" + this.mAttached.get());
    }

    private final String[] $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getPcscfAddress(String apnType) {
        this.log("getPcscfAddress()");
        ApnContext apnContext = null;
        if (apnType == null) {
            this.log("apnType is null, return null");
            return null;
        }
        if (TextUtils.equals(apnType, "emergency")) {
            apnContext = (ApnContext)this.mApnContexts.get("emergency");
        } else if (TextUtils.equals(apnType, "ims")) {
            apnContext = (ApnContext)this.mApnContexts.get("ims");
        } else {
            this.log("apnType is invalid, return null");
            return null;
        }
        if (apnContext == null) {
            this.log("apnContext is null, return null");
            return null;
        }
        DcAsyncChannel dcac = apnContext.getDcAc();
        String[] result = null;
        if (dcac != null) {
            result = dcac.getPcscfAddr();
            for (int i = 0; i < result.length; ++i) {
                this.log("Pcscf[" + i + "]: " + result[i]);
            }
            return result;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setImsRegistrationState(boolean registered) {
        this.log("setImsRegistrationState - mImsRegistrationState(before): " + this.mImsRegistrationState + ", registered(current) : " + registered);
        if (this.mPhone == null) {
            return;
        }
        ServiceStateTracker sst = this.mPhone.getServiceStateTracker();
        if (sst == null) {
            return;
        }
        sst.setImsRegistrationState(registered);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$initEmergencyApnSetting() {
        String selection = "type=\"emergency\"";
        Cursor cursor = this.mPhone.getContext().getContentResolver().query(Telephony.Carriers.CONTENT_URI, null, selection, null, null);
        if (cursor != null) {
            if (cursor.getCount() > 0 && cursor.moveToFirst()) {
                this.mEmergencyApn = this.makeApnSetting(cursor);
            }
            cursor.close();
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker$addEmergencyApnSetting() {
        if (this.mEmergencyApn != null) {
            if (this.mAllApnSettings == null) {
                this.mAllApnSettings = new ArrayList();
            } else {
                boolean hasEmergencyApn = false;
                for (ApnSetting apn : this.mAllApnSettings) {
                    if (!ArrayUtils.contains(apn.types, "emergency")) continue;
                    hasEmergencyApn = true;
                    break;
                }
                if (!hasEmergencyApn) {
                    this.mAllApnSettings.add(this.mEmergencyApn);
                } else {
                    this.log("addEmergencyApnSetting - E-APN setting is already present");
                }
            }
        }
    }

    static void __staticInitializer__() {
        PREFERAPN_NO_UPDATE_URI = Uri.parse("content://telephony/carriers/preferapn_no_update");
    }

    private void __constructor__(PhoneBase phoneBase) {
        this.$$robo$$com_android_internal_telephony_dataconnection_DcTracker$__constructor__(phoneBase);
    }

    public DcTracker(PhoneBase phoneBase) {
        super(phoneBase);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$__constructor__(com.android.internal.telephony.PhoneBase ), 0, this, phoneBase);
    }

    protected void registerForAllEvents() {
        InvokeDynamicSupport.bootstrap("registerForAllEvents", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$registerForAllEvents(), 0, this);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$dispose(), 0, this);
    }

    protected void unregisterForAllEvents() {
        InvokeDynamicSupport.bootstrap("unregisterForAllEvents", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$unregisterForAllEvents(), 0, this);
    }

    private ApnContext apnContextForNetworkRequest(NetworkRequest networkRequest) {
        return InvokeDynamicSupport.bootstrap("apnContextForNetworkRequest", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$apnContextForNetworkRequest(android.net.NetworkRequest ), 0, this, networkRequest);
    }

    private void setRadio(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRadio", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setRadio(boolean ), 0, this, bl);
    }

    @Override
    public boolean isApnTypeActive(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isApnTypeActive", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isApnTypeActive(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isDataPossible(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataPossible", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isDataPossible(java.lang.String ), 0, this, string2);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$finalize(), 0, this);
    }

    protected void supplyMessenger() {
        InvokeDynamicSupport.bootstrap("supplyMessenger", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$supplyMessenger(), 0, this);
    }

    private ApnContext addApnContext(String string2, NetworkConfig networkConfig) {
        return InvokeDynamicSupport.bootstrap("addApnContext", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$addApnContext(java.lang.String android.net.NetworkConfig ), 0, this, string2, networkConfig);
    }

    protected void initApnContexts() {
        InvokeDynamicSupport.bootstrap("initApnContexts", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$initApnContexts(), 0, this);
    }

    @Override
    public LinkProperties getLinkProperties(String string2) {
        return InvokeDynamicSupport.bootstrap("getLinkProperties", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getLinkProperties(java.lang.String ), 0, this, string2);
    }

    @Override
    public NetworkCapabilities getNetworkCapabilities(String string2) {
        return InvokeDynamicSupport.bootstrap("getNetworkCapabilities", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getNetworkCapabilities(java.lang.String ), 0, this, string2);
    }

    @Override
    public String[] getActiveApnTypes() {
        return InvokeDynamicSupport.bootstrap("getActiveApnTypes", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getActiveApnTypes(), 0, this);
    }

    @Override
    public String getActiveApnString(String string2) {
        return InvokeDynamicSupport.bootstrap("getActiveApnString", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getActiveApnString(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isApnTypeEnabled(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isApnTypeEnabled", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isApnTypeEnabled(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void setState(DctConstants.State state) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setState(com.android.internal.telephony.DctConstants$State ), 0, this, state);
    }

    @Override
    public DctConstants.State getState(String string2) {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getState(java.lang.String ), 0, this, string2);
    }

    @Override
    protected boolean isProvisioningApn(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isProvisioningApn", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isProvisioningApn(java.lang.String ), 0, this, string2);
    }

    @Override
    public DctConstants.State getOverallState() {
        return InvokeDynamicSupport.bootstrap("getOverallState", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getOverallState(), 0, this);
    }

    @Override
    protected boolean isApnTypeAvailable(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isApnTypeAvailable", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isApnTypeAvailable(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean getAnyDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAnyDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getAnyDataEnabled(), 0, this);
    }

    public boolean getAnyDataEnabled(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getAnyDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getAnyDataEnabled(boolean ), 0, this, bl);
    }

    private boolean isDataAllowed(ApnContext apnContext) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataAllowed", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isDataAllowed(com.android.internal.telephony.dataconnection.ApnContext ), 0, this, apnContext);
    }

    protected void onDataConnectionDetached() {
        InvokeDynamicSupport.bootstrap("onDataConnectionDetached", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDataConnectionDetached(), 0, this);
    }

    private void onDataConnectionAttached() {
        InvokeDynamicSupport.bootstrap("onDataConnectionAttached", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDataConnectionAttached(), 0, this);
    }

    @Override
    protected boolean isDataAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataAllowed", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isDataAllowed(), 0, this);
    }

    private void setupDataOnConnectableApns(String string2) {
        InvokeDynamicSupport.bootstrap("setupDataOnConnectableApns", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setupDataOnConnectableApns(java.lang.String ), 0, this, string2);
    }

    private boolean trySetupData(ApnContext apnContext) {
        return (boolean)InvokeDynamicSupport.bootstrap("trySetupData", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$trySetupData(com.android.internal.telephony.dataconnection.ApnContext ), 0, this, apnContext);
    }

    @Override
    protected void notifyOffApnsOfAvailability(String string2) {
        InvokeDynamicSupport.bootstrap("notifyOffApnsOfAvailability", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$notifyOffApnsOfAvailability(java.lang.String ), 0, this, string2);
    }

    protected boolean cleanUpAllConnections(boolean bl, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("cleanUpAllConnections", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$cleanUpAllConnections(boolean java.lang.String ), 0, this, bl, string2);
    }

    @Override
    protected void onCleanUpAllConnections(String string2) {
        InvokeDynamicSupport.bootstrap("onCleanUpAllConnections", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onCleanUpAllConnections(java.lang.String ), 0, this, string2);
    }

    protected void cleanUpConnection(boolean bl, ApnContext apnContext) {
        InvokeDynamicSupport.bootstrap("cleanUpConnection", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$cleanUpConnection(boolean com.android.internal.telephony.dataconnection.ApnContext ), 0, this, bl, apnContext);
    }

    private boolean teardownForDun() {
        return (boolean)InvokeDynamicSupport.bootstrap("teardownForDun", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$teardownForDun(), 0, this);
    }

    private void cancelReconnectAlarm(ApnContext apnContext) {
        InvokeDynamicSupport.bootstrap("cancelReconnectAlarm", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$cancelReconnectAlarm(com.android.internal.telephony.dataconnection.ApnContext ), 0, this, apnContext);
    }

    private String[] parseTypes(String string2) {
        return InvokeDynamicSupport.bootstrap("parseTypes", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$parseTypes(java.lang.String ), 0, this, string2);
    }

    private boolean imsiMatches(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("imsiMatches", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$imsiMatches(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    protected boolean mvnoMatches(IccRecords iccRecords, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("mvnoMatches", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$mvnoMatches(com.android.internal.telephony.uicc.IccRecords java.lang.String java.lang.String ), 0, this, iccRecords, string2, string3);
    }

    @Override
    protected boolean isPermanentFail(DcFailCause dcFailCause) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPermanentFail", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isPermanentFail(com.android.internal.telephony.dataconnection.DcFailCause ), 0, this, dcFailCause);
    }

    private ApnSetting makeApnSetting(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("makeApnSetting", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$makeApnSetting(android.database.Cursor ), 0, this, cursor);
    }

    private ArrayList<ApnSetting> createApnList(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("createApnList", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$createApnList(android.database.Cursor ), 0, this, cursor);
    }

    private boolean dataConnectionNotInUse(DcAsyncChannel dcAsyncChannel) {
        return (boolean)InvokeDynamicSupport.bootstrap("dataConnectionNotInUse", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$dataConnectionNotInUse(com.android.internal.telephony.dataconnection.DcAsyncChannel ), 0, this, dcAsyncChannel);
    }

    private DcAsyncChannel findFreeDataConnection() {
        return InvokeDynamicSupport.bootstrap("findFreeDataConnection", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$findFreeDataConnection(), 0, this);
    }

    private boolean setupData(ApnContext apnContext, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setupData", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setupData(com.android.internal.telephony.dataconnection.ApnContext int ), 0, this, apnContext, n);
    }

    private void onApnChanged() {
        InvokeDynamicSupport.bootstrap("onApnChanged", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onApnChanged(), 0, this);
    }

    private DcAsyncChannel findDataConnectionAcByCid(int n) {
        return InvokeDynamicSupport.bootstrap("findDataConnectionAcByCid", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$findDataConnectionAcByCid(int ), 0, this, n);
    }

    @Override
    protected void gotoIdleAndNotifyDataConnection(String string2) {
        InvokeDynamicSupport.bootstrap("gotoIdleAndNotifyDataConnection", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$gotoIdleAndNotifyDataConnection(java.lang.String ), 0, this, string2);
    }

    private boolean isHigherPriorityApnContextActive(ApnContext apnContext) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHigherPriorityApnContextActive", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isHigherPriorityApnContextActive(com.android.internal.telephony.dataconnection.ApnContext ), 0, this, apnContext);
    }

    private boolean isOnlySingleDcAllowed(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOnlySingleDcAllowed", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isOnlySingleDcAllowed(int ), 0, this, n);
    }

    @Override
    protected void restartRadio() {
        InvokeDynamicSupport.bootstrap("restartRadio", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$restartRadio(), 0, this);
    }

    private boolean retryAfterDisconnected(ApnContext apnContext) {
        return (boolean)InvokeDynamicSupport.bootstrap("retryAfterDisconnected", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$retryAfterDisconnected(com.android.internal.telephony.dataconnection.ApnContext ), 0, this, apnContext);
    }

    private void startAlarmForReconnect(int n, ApnContext apnContext) {
        InvokeDynamicSupport.bootstrap("startAlarmForReconnect", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$startAlarmForReconnect(int com.android.internal.telephony.dataconnection.ApnContext ), 0, this, n, apnContext);
    }

    private void startAlarmForRestartTrySetup(int n, ApnContext apnContext) {
        InvokeDynamicSupport.bootstrap("startAlarmForRestartTrySetup", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$startAlarmForRestartTrySetup(int com.android.internal.telephony.dataconnection.ApnContext ), 0, this, n, apnContext);
    }

    private void notifyNoData(DcFailCause dcFailCause, ApnContext apnContext) {
        InvokeDynamicSupport.bootstrap("notifyNoData", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$notifyNoData(com.android.internal.telephony.dataconnection.DcFailCause com.android.internal.telephony.dataconnection.ApnContext ), 0, this, dcFailCause, apnContext);
    }

    private void onRecordsLoaded() {
        InvokeDynamicSupport.bootstrap("onRecordsLoaded", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onRecordsLoaded(), 0, this);
    }

    @Override
    protected void onSetDependencyMet(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("onSetDependencyMet", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onSetDependencyMet(java.lang.String boolean ), 0, this, string2, bl);
    }

    private void applyNewState(ApnContext apnContext, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("applyNewState", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$applyNewState(com.android.internal.telephony.dataconnection.ApnContext boolean boolean ), 0, this, apnContext, bl, bl2);
    }

    private DcAsyncChannel checkForCompatibleConnectedApnContext(ApnContext apnContext) {
        return InvokeDynamicSupport.bootstrap("checkForCompatibleConnectedApnContext", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$checkForCompatibleConnectedApnContext(com.android.internal.telephony.dataconnection.ApnContext ), 0, this, apnContext);
    }

    @Override
    protected void onEnableApn(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onEnableApn", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onEnableApn(int int ), 0, this, n, n2);
    }

    @Override
    protected boolean onTrySetupData(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTrySetupData", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onTrySetupData(java.lang.String ), 0, this, string2);
    }

    protected boolean onTrySetupData(ApnContext apnContext) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTrySetupData", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onTrySetupData(com.android.internal.telephony.dataconnection.ApnContext ), 0, this, apnContext);
    }

    @Override
    protected void onRoamingOff() {
        InvokeDynamicSupport.bootstrap("onRoamingOff", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onRoamingOff(), 0, this);
    }

    @Override
    protected void onRoamingOn() {
        InvokeDynamicSupport.bootstrap("onRoamingOn", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onRoamingOn(), 0, this);
    }

    @Override
    protected void onRadioAvailable() {
        InvokeDynamicSupport.bootstrap("onRadioAvailable", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onRadioAvailable(), 0, this);
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        InvokeDynamicSupport.bootstrap("onRadioOffOrNotAvailable", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onRadioOffOrNotAvailable(), 0, this);
    }

    @Override
    protected void completeConnection(ApnContext apnContext) {
        InvokeDynamicSupport.bootstrap("completeConnection", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$completeConnection(com.android.internal.telephony.dataconnection.ApnContext ), 0, this, apnContext);
    }

    @Override
    protected void onDataSetupComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onDataSetupComplete", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDataSetupComplete(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private int getApnDelay() {
        return (int)InvokeDynamicSupport.bootstrap("getApnDelay", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getApnDelay(), 0, this);
    }

    @Override
    protected void onDataSetupCompleteError(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onDataSetupCompleteError", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDataSetupCompleteError(android.os.AsyncResult ), 0, this, asyncResult);
    }

    @Override
    protected void onDisconnectDone(int n, AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onDisconnectDone", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDisconnectDone(int android.os.AsyncResult ), 0, this, n, asyncResult);
    }

    @Override
    protected void onDisconnectDcRetrying(int n, AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onDisconnectDcRetrying", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onDisconnectDcRetrying(int android.os.AsyncResult ), 0, this, n, asyncResult);
    }

    @Override
    protected void onVoiceCallStarted() {
        InvokeDynamicSupport.bootstrap("onVoiceCallStarted", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onVoiceCallStarted(), 0, this);
    }

    @Override
    protected void onVoiceCallEnded() {
        InvokeDynamicSupport.bootstrap("onVoiceCallEnded", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onVoiceCallEnded(), 0, this);
    }

    @Override
    protected void onCleanUpConnection(boolean bl, int n, String string2) {
        InvokeDynamicSupport.bootstrap("onCleanUpConnection", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onCleanUpConnection(boolean int java.lang.String ), 0, this, bl, n, string2);
    }

    @Override
    protected boolean isConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isConnected(), 0, this);
    }

    @Override
    public boolean isDisconnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDisconnected", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isDisconnected(), 0, this);
    }

    @Override
    protected void notifyDataConnection(String string2) {
        InvokeDynamicSupport.bootstrap("notifyDataConnection", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$notifyDataConnection(java.lang.String ), 0, this, string2);
    }

    private void createAllApnList() {
        InvokeDynamicSupport.bootstrap("createAllApnList", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$createAllApnList(), 0, this);
    }

    private void dedupeApnSettings() {
        InvokeDynamicSupport.bootstrap("dedupeApnSettings", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$dedupeApnSettings(), 0, this);
    }

    private boolean apnTypeSameAny(ApnSetting apnSetting, ApnSetting apnSetting2) {
        return (boolean)InvokeDynamicSupport.bootstrap("apnTypeSameAny", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$apnTypeSameAny(com.android.internal.telephony.dataconnection.ApnSetting com.android.internal.telephony.dataconnection.ApnSetting ), 0, this, apnSetting, apnSetting2);
    }

    private boolean apnsSimilar(ApnSetting apnSetting, ApnSetting apnSetting2) {
        return (boolean)InvokeDynamicSupport.bootstrap("apnsSimilar", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$apnsSimilar(com.android.internal.telephony.dataconnection.ApnSetting com.android.internal.telephony.dataconnection.ApnSetting ), 0, this, apnSetting, apnSetting2);
    }

    private boolean xorEquals(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("xorEquals", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$xorEquals(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private ApnSetting mergeApns(ApnSetting apnSetting, ApnSetting apnSetting2) {
        return InvokeDynamicSupport.bootstrap("mergeApns", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$mergeApns(com.android.internal.telephony.dataconnection.ApnSetting com.android.internal.telephony.dataconnection.ApnSetting ), 0, this, apnSetting, apnSetting2);
    }

    private DcAsyncChannel createDataConnection() {
        return InvokeDynamicSupport.bootstrap("createDataConnection", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$createDataConnection(), 0, this);
    }

    private void destroyDataConnections() {
        InvokeDynamicSupport.bootstrap("destroyDataConnections", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$destroyDataConnections(), 0, this);
    }

    private ArrayList<ApnSetting> buildWaitingApns(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("buildWaitingApns", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$buildWaitingApns(java.lang.String int ), 0, this, string2, n);
    }

    private String apnListToString(ArrayList<ApnSetting> arrayList) {
        return InvokeDynamicSupport.bootstrap("apnListToString", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$apnListToString(java.util.ArrayList<com.android.internal.telephony.dataconnection.ApnSetting> ), 0, this, arrayList);
    }

    private void setPreferredApn(int n) {
        InvokeDynamicSupport.bootstrap("setPreferredApn", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setPreferredApn(int ), 0, this, n);
    }

    private ApnSetting getPreferredApn() {
        return InvokeDynamicSupport.bootstrap("getPreferredApn", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getPreferredApn(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$handleMessage(android.os.Message ), 0, this, message);
    }

    protected int getApnProfileID(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getApnProfileID", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getApnProfileID(java.lang.String ), 0, this, string2);
    }

    private int getCellLocationId() {
        return (int)InvokeDynamicSupport.bootstrap("getCellLocationId", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getCellLocationId(), 0, this);
    }

    private IccRecords getUiccRecords(int n) {
        return InvokeDynamicSupport.bootstrap("getUiccRecords", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getUiccRecords(int ), 0, this, n);
    }

    @Override
    protected void onUpdateIcc() {
        InvokeDynamicSupport.bootstrap("onUpdateIcc", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onUpdateIcc(), 0, this);
    }

    public void update() {
        InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$update(), 0, this);
    }

    @Override
    public void cleanUpAllConnections(String string2) {
        InvokeDynamicSupport.bootstrap("cleanUpAllConnections", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$cleanUpAllConnections(java.lang.String ), 0, this, string2);
    }

    public void updateRecords() {
        InvokeDynamicSupport.bootstrap("updateRecords", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$updateRecords(), 0, this);
    }

    public void cleanUpAllConnections(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("cleanUpAllConnections", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$cleanUpAllConnections(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    protected void notifyDataDisconnectComplete() {
        InvokeDynamicSupport.bootstrap("notifyDataDisconnectComplete", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$notifyDataDisconnectComplete(), 0, this);
    }

    protected void notifyAllDataDisconnected() {
        InvokeDynamicSupport.bootstrap("notifyAllDataDisconnected", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$notifyAllDataDisconnected(), 0, this);
    }

    public void registerForAllDataDisconnected(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForAllDataDisconnected", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$registerForAllDataDisconnected(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForAllDataDisconnected(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForAllDataDisconnected", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$unregisterForAllDataDisconnected(android.os.Handler ), 0, this, handler);
    }

    @Override
    protected void onSetInternalDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("onSetInternalDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onSetInternalDataEnabled(boolean ), 0, this, bl);
    }

    protected void onSetInternalDataEnabled(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("onSetInternalDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$onSetInternalDataEnabled(boolean android.os.Message ), 0, this, bl, message);
    }

    public boolean setInternalDataEnabledFlag(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setInternalDataEnabledFlag", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setInternalDataEnabledFlag(boolean ), 0, this, bl);
    }

    @Override
    public boolean setInternalDataEnabled(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setInternalDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setInternalDataEnabled(boolean ), 0, this, bl);
    }

    public boolean setInternalDataEnabled(boolean bl, Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("setInternalDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setInternalDataEnabled(boolean android.os.Message ), 0, this, bl, message);
    }

    protected boolean isActiveDataSubscription() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveDataSubscription", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$isActiveDataSubscription(), 0, this);
    }

    @Override
    public void setDataAllowed(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setDataAllowed", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setDataAllowed(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$log(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$loge(java.lang.String ), 0, this, string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public String[] getPcscfAddress(String string2) {
        return InvokeDynamicSupport.bootstrap("getPcscfAddress", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$getPcscfAddress(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setImsRegistrationState(boolean bl) {
        InvokeDynamicSupport.bootstrap("setImsRegistrationState", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$setImsRegistrationState(boolean ), 0, this, bl);
    }

    private void initEmergencyApnSetting() {
        InvokeDynamicSupport.bootstrap("initEmergencyApnSetting", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$initEmergencyApnSetting(), 0, this);
    }

    private void addEmergencyApnSetting() {
        InvokeDynamicSupport.bootstrap("addEmergencyApnSetting", $$robo$$com_android_internal_telephony_dataconnection_DcTracker$addEmergencyApnSetting(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(DcTracker.class);
    }

    public /* synthetic */ DcTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$DctConstants$State;

        static void __staticInitializer__() {
            $SwitchMap$com$android$internal$telephony$DctConstants$State = new int[DctConstants.State.values().length];
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.CONNECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.DISCONNECTING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.RETRYING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.CONNECTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.IDLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.SCANNING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.FAILED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ProvisionNotificationBroadcastReceiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mNetworkOperator;
        private String mProvisionUrl;
        /* synthetic */ DcTracker this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ProvisionNotificationBroadcastReceiver$__constructor__(DcTracker dcTracker, String provisionUrl, String networkOperator) {
            this.mNetworkOperator = networkOperator;
            this.mProvisionUrl = provisionUrl;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ProvisionNotificationBroadcastReceiver$setEnableFailFastMobileData(int enabled) {
            this.this$0.sendMessage(this.this$0.obtainMessage(270372, enabled, 0));
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ProvisionNotificationBroadcastReceiver$enableMobileProvisioning() {
            Message msg = this.this$0.obtainMessage(270373);
            msg.setData(Bundle.forPair("provisioningUrl", this.mProvisionUrl));
            this.this$0.sendMessage(msg);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ProvisionNotificationBroadcastReceiver$onReceive(Context context, Intent intent) {
            this.this$0.mProvisioningSpinner = new ProgressDialog(context);
            this.this$0.mProvisioningSpinner.setTitle(this.mNetworkOperator);
            this.this$0.mProvisioningSpinner.setMessage(context.getText(17040839));
            this.this$0.mProvisioningSpinner.setIndeterminate(true);
            this.this$0.mProvisioningSpinner.setCancelable(true);
            this.this$0.mProvisioningSpinner.getWindow().setType(2009);
            this.this$0.mProvisioningSpinner.show();
            this.this$0.sendMessageDelayed(this.this$0.obtainMessage(270378, this.this$0.mProvisioningSpinner), 120000L);
            this.this$0.setRadio(true);
            this.setEnableFailFastMobileData(1);
            this.enableMobileProvisioning();
        }

        private void __constructor__(DcTracker dcTracker, String string2, String string3) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DcTracker_ProvisionNotificationBroadcastReceiver$__constructor__(dcTracker, string2, string3);
        }

        public ProvisionNotificationBroadcastReceiver(DcTracker dcTracker, String string2, String string3) {
            this.this$0 = dcTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ProvisionNotificationBroadcastReceiver$__constructor__(com.android.internal.telephony.dataconnection.DcTracker java.lang.String java.lang.String ), 0, this, dcTracker, string2, string3);
        }

        private void setEnableFailFastMobileData(int n) {
            InvokeDynamicSupport.bootstrap("setEnableFailFastMobileData", $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ProvisionNotificationBroadcastReceiver$setEnableFailFastMobileData(int ), 0, this, n);
        }

        private void enableMobileProvisioning() {
            InvokeDynamicSupport.bootstrap("enableMobileProvisioning", $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ProvisionNotificationBroadcastReceiver$enableMobileProvisioning(), 0, this);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ProvisionNotificationBroadcastReceiver$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
        }

        public /* synthetic */ ProvisionNotificationBroadcastReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProvisionNotificationBroadcastReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TelephonyNetworkFactory
    extends NetworkFactory
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DcTracker this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DcTracker_TelephonyNetworkFactory$__constructor__(DcTracker dcTracker, Looper l, Context c, String TAG, NetworkCapabilities nc) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker_TelephonyNetworkFactory$needNetworkFor(NetworkRequest networkRequest, int score) {
            this.log("Cellular needs Network for " + networkRequest);
            ApnContext apnContext = this.this$0.apnContextForNetworkRequest(networkRequest);
            if (apnContext != null) {
                apnContext.incRefCount();
            }
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker_TelephonyNetworkFactory$releaseNetworkFor(NetworkRequest networkRequest) {
            this.log("Cellular releasing Network for " + networkRequest);
            ApnContext apnContext = this.this$0.apnContextForNetworkRequest(networkRequest);
            if (apnContext != null) {
                apnContext.decRefCount();
            }
        }

        private void __constructor__(DcTracker dcTracker, Looper looper, Context context, String string2, NetworkCapabilities networkCapabilities) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DcTracker_TelephonyNetworkFactory$__constructor__(dcTracker, looper, context, string2, networkCapabilities);
        }

        public TelephonyNetworkFactory(DcTracker dcTracker, Looper looper, Context context, String string2, NetworkCapabilities networkCapabilities) {
            this.this$0 = dcTracker;
            super(looper, context, string2, networkCapabilities);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DcTracker_TelephonyNetworkFactory$__constructor__(com.android.internal.telephony.dataconnection.DcTracker android.os.Looper android.content.Context java.lang.String android.net.NetworkCapabilities ), 0, this, dcTracker, looper, context, string2, networkCapabilities);
        }

        @Override
        protected void needNetworkFor(NetworkRequest networkRequest, int n) {
            InvokeDynamicSupport.bootstrap("needNetworkFor", $$robo$$com_android_internal_telephony_dataconnection_DcTracker_TelephonyNetworkFactory$needNetworkFor(android.net.NetworkRequest int ), 0, this, networkRequest, n);
        }

        @Override
        protected void releaseNetworkFor(NetworkRequest networkRequest) {
            InvokeDynamicSupport.bootstrap("releaseNetworkFor", $$robo$$com_android_internal_telephony_dataconnection_DcTracker_TelephonyNetworkFactory$releaseNetworkFor(android.net.NetworkRequest ), 0, this, networkRequest);
        }

        public /* synthetic */ TelephonyNetworkFactory() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyNetworkFactory)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ApnChangeObserver
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DcTracker this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ApnChangeObserver$__constructor__(DcTracker dcTracker) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ApnChangeObserver$onChange(boolean selfChange) {
            this.this$0.sendMessage(this.this$0.obtainMessage(270355));
        }

        private void __constructor__(DcTracker dcTracker) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DcTracker_ApnChangeObserver$__constructor__(dcTracker);
        }

        public ApnChangeObserver(DcTracker dcTracker) {
            this.this$0 = dcTracker;
            super(dcTracker.mDataConnectionTracker);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ApnChangeObserver$__constructor__(com.android.internal.telephony.dataconnection.DcTracker ), 0, this, dcTracker);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_telephony_dataconnection_DcTracker_ApnChangeObserver$onChange(boolean ), 0, this, bl);
        }

        public /* synthetic */ ApnChangeObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApnChangeObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

