/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.ims.ImsManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmCallTracker;
import com.android.internal.telephony.gsm.GsmConnection;
import com.android.internal.telephony.gsm.GsmMmiCode;
import com.android.internal.telephony.gsm.GsmServiceStateTracker;
import com.android.internal.telephony.gsm.SimPhoneBookInterfaceManager;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccVmNotSupportedException;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.IsimUiccRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GSMPhone
extends PhoneBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "GSMPhone";
    private static boolean LOCAL_DEBUG = true;
    private static boolean VDBG = false;
    public static String CIPHERING_KEY = "ciphering_key";
    public static String VM_NUMBER = "vm_number_key";
    public static String VM_SIM_IMSI = "vm_sim_imsi_key";
    GsmCallTracker mCT;
    GsmServiceStateTracker mSST;
    ArrayList<GsmMmiCode> mPendingMMIs;
    SimPhoneBookInterfaceManager mSimPhoneBookIntManager;
    PhoneSubInfo mSubInfo;
    Registrant mPostDialHandler;
    RegistrantList mSsnRegistrants;
    private RegistrantList mEcmTimerResetRegistrants;
    private String mImei;
    private String mImeiSv;
    private String mVmNumber;
    private IsimUiccRecords mIsimUiccRecords;

    private void $$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier) {
    }

    private void $$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier, boolean unitTestMode) {
        this.mPendingMMIs = new ArrayList();
        this.mSsnRegistrants = new RegistrantList();
        this.mEcmTimerResetRegistrants = new RegistrantList();
        if (ci instanceof SimulatedRadioControl) {
            this.mSimulatedRadioControl = (SimulatedRadioControl)((Object)ci);
        }
        this.mCi.setPhoneType(1);
        this.mCT = new GsmCallTracker(this);
        this.mSST = new GsmServiceStateTracker(this);
        this.mDcTracker = new DcTracker(this);
        if (!unitTestMode) {
            this.mSimPhoneBookIntManager = new SimPhoneBookInterfaceManager(this);
            this.mSubInfo = new PhoneSubInfo(this);
        }
        this.mCi.registerForAvailable(this, 1, null);
        this.mCi.registerForOffOrNotAvailable(this, 8, null);
        this.mCi.registerForOn(this, 5, null);
        this.mCi.setOnUSSD(this, 7, null);
        this.mCi.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttached(this, 19, null);
        this.setProperties();
    }

    private void $$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier, int phoneId) {
    }

    private void $$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier, boolean unitTestMode, int phoneId) {
        this.mPendingMMIs = new ArrayList();
        this.mSsnRegistrants = new RegistrantList();
        this.mEcmTimerResetRegistrants = new RegistrantList();
        if (ci instanceof SimulatedRadioControl) {
            this.mSimulatedRadioControl = (SimulatedRadioControl)((Object)ci);
        }
        this.mCi.setPhoneType(1);
        this.mCT = new GsmCallTracker(this);
        this.mSST = new GsmServiceStateTracker(this);
        this.mDcTracker = new DcTracker(this);
        if (!unitTestMode) {
            this.mSimPhoneBookIntManager = new SimPhoneBookInterfaceManager(this);
            this.mSubInfo = new PhoneSubInfo(this);
        }
        this.mCi.registerForAvailable(this, 1, null);
        this.mCi.registerForOffOrNotAvailable(this, 8, null);
        this.mCi.registerForOn(this, 5, null);
        this.mCi.setOnUSSD(this, 7, null);
        this.mCi.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttached(this, 19, null);
        this.setProperties();
        this.log("GSMPhone: constructor: sub = " + this.mPhoneId);
        this.setProperties();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setProperties() {
        TelephonyManager.setTelephonyProperty("gsm.current.phone-type", this.getSubId(), new Integer(1).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            super.dispose();
            this.mCi.unregisterForAvailable(this);
            this.unregisterForSimRecordEvents();
            this.mCi.unregisterForOffOrNotAvailable(this);
            this.mCi.unregisterForOn(this);
            this.mSST.unregisterForNetworkAttached(this);
            this.mCi.unSetOnUSSD(this);
            this.mCi.unSetOnSuppServiceNotification(this);
            this.mPendingMMIs.clear();
            this.mCT.dispose();
            this.mDcTracker.dispose();
            this.mSST.dispose();
            this.mSimPhoneBookIntManager.dispose();
            this.mSubInfo.dispose();
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$removeReferences() {
        Rlog.d("GSMPhone", "removeReferences");
        this.mSimulatedRadioControl = null;
        this.mSimPhoneBookIntManager = null;
        this.mSubInfo = null;
        this.mCT = null;
        this.mSST = null;
        super.removeReferences();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$finalize() {
        Rlog.d("GSMPhone", "GSMPhone finalized");
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$onSubscriptionActivated() {
        this.log("SUBSCRIPTION ACTIVATED : slotId : " + this.mSubscriptionData.slotId + " appid : " + this.mSubscriptionData.m3gppIndex + " subId : " + this.mSubscriptionData.subId + " subStatus : " + (Object)((Object)this.mSubscriptionData.subStatus));
        this.setProperties();
        this.onUpdateIccAvailability();
        this.mSST.sendMessage(this.mSST.obtainMessage(42));
        ((DcTracker)this.mDcTracker).updateRecords();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$onSubscriptionDeactivated() {
        this.log("SUBSCRIPTION DEACTIVATED");
        this.mSubscriptionData = null;
        this.resetSubSpecifics();
    }

    private final ServiceState $$robo$$com_android_internal_telephony_gsm_GSMPhone$getServiceState() {
        if ((this.mSST == null || this.mSST.mSS.getState() != 0) && this.mImsPhone != null && this.mImsPhone.getServiceState().getState() == 0) {
            return this.mImsPhone.getServiceState();
        }
        if (this.mSST != null) {
            return this.mSST.mSS;
        }
        return new ServiceState();
    }

    private final CellLocation $$robo$$com_android_internal_telephony_gsm_GSMPhone$getCellLocation() {
        return this.mSST.getCellLocation();
    }

    private final PhoneConstants.State $$robo$$com_android_internal_telephony_gsm_GSMPhone$getState() {
        return this.mCT.mState;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_GSMPhone$getPhoneType() {
        return 1;
    }

    private final ServiceStateTracker $$robo$$com_android_internal_telephony_gsm_GSMPhone$getServiceStateTracker() {
        return this.mSST;
    }

    private final CallTracker $$robo$$com_android_internal_telephony_gsm_GSMPhone$getCallTracker() {
        return this.mCT;
    }

    private final List<? extends MmiCode> $$robo$$com_android_internal_telephony_gsm_GSMPhone$getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    private final PhoneConstants.DataState $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDataConnectionState(String apnType) {
        PhoneConstants.DataState ret = PhoneConstants.DataState.DISCONNECTED;
        if (this.mSST == null) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (!apnType.equals("emergency") && this.mSST.getCurrentDataConnectionState() != 0) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (!this.mDcTracker.isApnTypeEnabled(apnType) || !this.mDcTracker.isApnTypeActive(apnType)) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else {
            switch (1.$SwitchMap$com$android$internal$telephony$DctConstants$State[this.mDcTracker.getState(apnType).ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    ret = PhoneConstants.DataState.DISCONNECTED;
                    break;
                }
                case 4: 
                case 5: {
                    if (this.mCT.mState != PhoneConstants.State.IDLE && !this.mSST.isConcurrentVoiceAndDataAllowed()) {
                        ret = PhoneConstants.DataState.SUSPENDED;
                        break;
                    }
                    ret = PhoneConstants.DataState.CONNECTED;
                    break;
                }
                case 6: 
                case 7: {
                    ret = PhoneConstants.DataState.CONNECTING;
                }
            }
        }
        return ret;
    }

    private final Phone.DataActivityState $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDataActivityState() {
        Phone.DataActivityState ret = Phone.DataActivityState.NONE;
        if (this.mSST.getCurrentDataConnectionState() == 0) {
            switch (1.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[this.mDcTracker.getActivity().ordinal()]) {
                case 1: {
                    ret = Phone.DataActivityState.DATAIN;
                    break;
                }
                case 2: {
                    ret = Phone.DataActivityState.DATAOUT;
                    break;
                }
                case 3: {
                    ret = Phone.DataActivityState.DATAINANDOUT;
                    break;
                }
                case 4: {
                    ret = Phone.DataActivityState.DORMANT;
                    break;
                }
                default: {
                    ret = Phone.DataActivityState.NONE;
                }
            }
        }
        return ret;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyNewRingingConnection(Connection c) {
        super.notifyNewRingingConnectionP(c);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyDisconnect(Connection cn) {
        this.mDisconnectRegistrants.notifyResult(cn);
        this.mNotifier.notifyDisconnectCause(cn.getDisconnectCause(), cn.getPreciseDisconnectCause());
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyUnknownConnection(Connection cn) {
        this.mUnknownConnectionRegistrants.notifyResult(cn);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifySuppServiceFailed(Phone.SuppService code) {
        this.mSuppServiceFailedRegistrants.notifyResult((Object)code);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyServiceStateChanged(ServiceState ss) {
        super.notifyServiceStateChangedP(ss);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyLocationChanged() {
        this.mNotifier.notifyCellLocation(this);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyCallForwardingIndicator() {
        this.mNotifier.notifyCallForwardingChanged(this);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setSystemProperty(String property, String value) {
        TelephonyManager.setTelephonyProperty(property, this.getSubId(), value);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$registerForSuppServiceNotification(Handler h, int what, Object obj) {
        this.mSsnRegistrants.addUnique(h, what, obj);
        if (this.mSsnRegistrants.size() == 1) {
            this.mCi.setSuppServiceNotifications(true, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$unregisterForSuppServiceNotification(Handler h) {
        this.mSsnRegistrants.remove(h);
        if (this.mSsnRegistrants.size() == 0) {
            this.mCi.setSuppServiceNotifications(false, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$registerForSimRecordsLoaded(Handler h, int what, Object obj) {
        this.mSimRecordsLoadedRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$unregisterForSimRecordsLoaded(Handler h) {
        this.mSimRecordsLoadedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$acceptCall(int videoState) throws CallStateException {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getRingingCall().isRinging()) {
            imsPhone.acceptCall(videoState);
        } else {
            this.mCT.acceptCall();
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$canConference() {
        boolean canImsConference = false;
        if (this.mImsPhone != null) {
            canImsConference = this.mImsPhone.canConference();
        }
        return this.mCT.canConference() || canImsConference;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$canDial() {
        return this.mCT.canDial();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$conference() {
        if (this.mImsPhone != null && this.mImsPhone.canConference()) {
            this.log("conference() - delegated to IMS phone");
            this.mImsPhone.conference();
            return;
        }
        this.mCT.conference();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$canTransfer() {
        return this.mCT.canTransfer();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$explicitCallTransfer() {
        this.mCT.explicitCallTransfer();
    }

    private final GsmCall $$robo$$com_android_internal_telephony_gsm_GSMPhone$getForegroundCall() {
        return this.mCT.mForegroundCall;
    }

    private final GsmCall $$robo$$com_android_internal_telephony_gsm_GSMPhone$getBackgroundCall() {
        return this.mCT.mBackgroundCall;
    }

    private final Call $$robo$$com_android_internal_telephony_gsm_GSMPhone$getRingingCall() {
        ImsPhone imsPhone = this.mImsPhone;
        if (this.mCT.mRingingCall != null && this.mCT.mRingingCall.isRinging()) {
            return this.mCT.mRingingCall;
        }
        if (imsPhone != null) {
            return imsPhone.getRingingCall();
        }
        return this.mCT.mRingingCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleCallDeflectionIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        if (this.getRingingCall().getState() != Call.State.IDLE) {
            Rlog.d("GSMPhone", "MmiCode 0: rejectCall");
            try {
                this.mCT.rejectCall();
            }
            catch (CallStateException e) {
                Rlog.d("GSMPhone", "reject failed", e);
                this.notifySuppServiceFailed(Phone.SuppService.REJECT);
            }
        } else if (this.getBackgroundCall().getState() != Call.State.IDLE) {
            Rlog.d("GSMPhone", "MmiCode 0: hangupWaitingOrBackground");
            this.mCT.hangupWaitingOrBackground();
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleCallWaitingIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        Call call = this.getForegroundCall();
        try {
            if (len > 1) {
                char ch = dialString.charAt(1);
                int callIndex = ch - 48;
                if (callIndex >= 1 && callIndex <= 7) {
                    Rlog.d("GSMPhone", "MmiCode 1: hangupConnectionByIndex " + callIndex);
                    this.mCT.hangupConnectionByIndex((GsmCall)call, callIndex);
                }
            } else if (call.getState() != Call.State.IDLE) {
                Rlog.d("GSMPhone", "MmiCode 1: hangup foreground");
                this.mCT.hangup((GsmCall)call);
            } else {
                Rlog.d("GSMPhone", "MmiCode 1: switchWaitingOrHoldingAndActive");
                this.mCT.switchWaitingOrHoldingAndActive();
            }
        }
        catch (CallStateException e) {
            Rlog.d("GSMPhone", "hangup failed", e);
            this.notifySuppServiceFailed(Phone.SuppService.HANGUP);
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleCallHoldIncallSupplementaryService(String dialString) {
        block10: {
            int len = dialString.length();
            if (len > 2) {
                return false;
            }
            Call call = this.getForegroundCall();
            if (len > 1) {
                try {
                    char ch = dialString.charAt(1);
                    int callIndex = ch - 48;
                    GsmConnection conn = this.mCT.getConnectionByIndex((GsmCall)call, callIndex);
                    if (conn != null && callIndex >= 1 && callIndex <= 7) {
                        Rlog.d("GSMPhone", "MmiCode 2: separate call " + callIndex);
                        this.mCT.separate(conn);
                        break block10;
                    }
                    Rlog.d("GSMPhone", "separate: invalid call index " + callIndex);
                    this.notifySuppServiceFailed(Phone.SuppService.SEPARATE);
                }
                catch (CallStateException e) {
                    Rlog.d("GSMPhone", "separate failed", e);
                    this.notifySuppServiceFailed(Phone.SuppService.SEPARATE);
                }
            } else {
                try {
                    if (this.getRingingCall().getState() != Call.State.IDLE) {
                        Rlog.d("GSMPhone", "MmiCode 2: accept ringing call");
                        this.mCT.acceptCall();
                    } else {
                        Rlog.d("GSMPhone", "MmiCode 2: switchWaitingOrHoldingAndActive");
                        this.mCT.switchWaitingOrHoldingAndActive();
                    }
                }
                catch (CallStateException e) {
                    Rlog.d("GSMPhone", "switch failed", e);
                    this.notifySuppServiceFailed(Phone.SuppService.SWITCH);
                }
            }
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleMultipartyIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.d("GSMPhone", "MmiCode 3: merge calls");
        this.conference();
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleEctIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len != 1) {
            return false;
        }
        Rlog.d("GSMPhone", "MmiCode 4: explicit call transfer");
        this.explicitCallTransfer();
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleCcbsIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.i("GSMPhone", "MmiCode 5: CCBS not supported!");
        this.notifySuppServiceFailed(Phone.SuppService.UNKNOWN);
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleInCallMmiCommands(String dialString) throws CallStateException {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            return imsPhone.handleInCallMmiCommands(dialString);
        }
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(dialString)) {
            return false;
        }
        boolean result = false;
        char ch = dialString.charAt(0);
        switch (ch) {
            case '0': {
                result = this.handleCallDeflectionIncallSupplementaryService(dialString);
                break;
            }
            case '1': {
                result = this.handleCallWaitingIncallSupplementaryService(dialString);
                break;
            }
            case '2': {
                result = this.handleCallHoldIncallSupplementaryService(dialString);
                break;
            }
            case '3': {
                result = this.handleMultipartyIncallSupplementaryService(dialString);
                break;
            }
            case '4': {
                result = this.handleEctIncallSupplementaryService(dialString);
                break;
            }
            case '5': {
                result = this.handleCcbsIncallSupplementaryService(dialString);
                break;
            }
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    private final Connection $$robo$$com_android_internal_telephony_gsm_GSMPhone$dial(String dialString, int videoState) throws CallStateException {
        return this.dial(dialString, null, videoState);
    }

    private final Connection $$robo$$com_android_internal_telephony_gsm_GSMPhone$dial(String dialString, UUSInfo uusInfo, int videoState) throws CallStateException {
        block4: {
            boolean imsUseEnabled;
            ImsPhone imsPhone = this.mImsPhone;
            boolean bl = imsUseEnabled = ImsManager.isEnhanced4gLteModeSettingEnabledByPlatform((Context)this.mContext) && ImsManager.isEnhanced4gLteModeSettingEnabledByUser((Context)this.mContext);
            if (!imsUseEnabled) {
                Rlog.w("GSMPhone", "IMS is disabled: forced to CS");
            }
            if (imsUseEnabled && imsPhone != null && (imsPhone.getServiceState().getState() == 0 && !PhoneNumberUtils.isEmergencyNumber(dialString) || PhoneNumberUtils.isEmergencyNumber(dialString) && this.mContext.getResources().getBoolean(17956977))) {
                try {
                    Rlog.d("GSMPhone", "Trying IMS PS call");
                    return imsPhone.dial(dialString, videoState);
                }
                catch (CallStateException e) {
                    Rlog.d("GSMPhone", "IMS PS call exception " + e);
                    if ("cs_fallback".equals(e.getMessage())) break block4;
                    CallStateException ce = new CallStateException(e.getMessage());
                    ce.setStackTrace(e.getStackTrace());
                    throw ce;
                }
            }
        }
        Rlog.d("GSMPhone", "Trying (non-IMS) CS call");
        return this.dialInternal(dialString, null, 0);
    }

    private final Connection $$robo$$com_android_internal_telephony_gsm_GSMPhone$dialInternal(String dialString, UUSInfo uusInfo, int videoState) throws CallStateException {
        String newDialString = PhoneNumberUtils.stripSeparators(dialString);
        if (this.handleInCallMmiCommands(newDialString)) {
            return null;
        }
        String networkPortion = PhoneNumberUtils.extractNetworkPortionAlt(newDialString);
        GsmMmiCode mmi = GsmMmiCode.newFromDialString(networkPortion, this, (UiccCardApplication)this.mUiccApplication.get());
        Rlog.d("GSMPhone", "dialing w/ mmi '" + mmi + "'...");
        if (mmi == null) {
            return this.mCT.dial(newDialString, uusInfo);
        }
        if (mmi.isTemporaryModeCLIR()) {
            return this.mCT.dial(mmi.mDialingNumber, mmi.getCLIRMode(), uusInfo);
        }
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.processCode();
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$handlePinMmi(String dialString) {
        GsmMmiCode mmi = GsmMmiCode.newFromDialString(dialString, this, (UiccCardApplication)this.mUiccApplication.get());
        if (mmi != null && mmi.isPinPukCommand()) {
            this.mPendingMMIs.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            mmi.processCode();
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$sendUssdResponse(String ussdMessge) {
        GsmMmiCode mmi = GsmMmiCode.newFromUssdUserInput(ussdMessge, this, (UiccCardApplication)this.mUiccApplication.get());
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.sendUssd(ussdMessge);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e("GSMPhone", "sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.mState == PhoneConstants.State.OFFHOOK) {
            this.mCi.sendDtmf(c, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e("GSMPhone", "startDtmf called with invalid character '" + c + "'");
        } else {
            this.mCi.startDtmf(c, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$stopDtmf() {
        this.mCi.stopDtmf(null);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$sendBurstDtmf(String dtmfString) {
        Rlog.e("GSMPhone", "[GSMPhone] sendBurstDtmf() is a CDMA method");
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setRadioPower(boolean power) {
        this.mSST.setRadioPower(power);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$storeVoiceMailNumber(String number) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("vm_number_key" + this.getPhoneId(), number);
        editor.apply();
        this.setVmSimImsi(this.getSubscriberId());
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getVoiceMailNumber() {
        String[] listArray;
        String number;
        IccRecords r = (IccRecords)this.mIccRecords.get();
        String string2 = number = r != null ? r.getVoiceMailNumber() : "";
        if (TextUtils.isEmpty(number)) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
            number = sp.getString("vm_number_key" + this.getPhoneId(), null);
        }
        if (TextUtils.isEmpty(number) && (listArray = this.getContext().getResources().getStringArray(17236026)) != null && listArray.length > 0) {
            for (int i = 0; i < listArray.length; ++i) {
                String[] defaultVMNumberArray;
                if (TextUtils.isEmpty(listArray[i]) || (defaultVMNumberArray = listArray[i].split(";")) == null || defaultVMNumberArray.length <= 0) continue;
                if (defaultVMNumberArray.length == 1) {
                    number = defaultVMNumberArray[0];
                    continue;
                }
                if (defaultVMNumberArray.length != 2 || TextUtils.isEmpty(defaultVMNumberArray[1]) || !defaultVMNumberArray[1].equalsIgnoreCase(this.getGroupIdLevel1())) continue;
                number = defaultVMNumberArray[0];
                break;
            }
        }
        return number;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getVmSimImsi() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        return sp.getString("vm_sim_imsi_key" + this.getPhoneId(), null);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setVmSimImsi(String imsi) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("vm_sim_imsi_key" + this.getPhoneId(), imsi);
        editor.apply();
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getVoiceMailAlphaTag() {
        String ret;
        IccRecords r = (IccRecords)this.mIccRecords.get();
        String string2 = ret = r != null ? r.getVoiceMailAlphaTag() : "";
        if (ret == null || ret.length() == 0) {
            return this.mContext.getText(0x1040004).toString();
        }
        return ret;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDeviceId() {
        return this.mImei;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDeviceSvn() {
        return this.mImeiSv;
    }

    private final IsimRecords $$robo$$com_android_internal_telephony_gsm_GSMPhone$getIsimRecords() {
        return this.mIsimUiccRecords;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getImei() {
        return this.mImei;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getEsn() {
        Rlog.e("GSMPhone", "[GSMPhone] getEsn() is a CDMA method");
        return "0";
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getMeid() {
        Rlog.e("GSMPhone", "[GSMPhone] getMeid() is a CDMA method");
        return "0";
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getSubscriberId() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getIMSI() : null;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getGroupIdLevel1() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getGid1() : null;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getLine1Number() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getMsisdnNumber() : null;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getMsisdn() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getMsisdnNumber() : null;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getLine1AlphaTag() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getMsisdnAlphaTag() : null;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setLine1Number(String alphaTag, String number, Message onComplete) {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            r.setMsisdnNumber(alphaTag, number, onComplete);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setVoiceMailNumber(String alphaTag, String voiceMailNumber, Message onComplete) {
        this.mVmNumber = voiceMailNumber;
        Message resp = this.obtainMessage(20, 0, 0, onComplete);
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            r.setVoiceMailNumber(alphaTag, this.mVmNumber, resp);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$isValidCommandInterfaceCFReason(int commandInterfaceCFReason) {
        switch (commandInterfaceCFReason) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getSystemProperty(String property, String defValue) {
        if (this.getUnitTestMode()) {
            return null;
        }
        return TelephonyManager.getTelephonyProperty(property, this.getSubId(), defValue);
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$isValidCommandInterfaceCFAction(int commandInterfaceCFAction) {
        switch (commandInterfaceCFAction) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$updateDataConnectionTracker() {
        ((DcTracker)this.mDcTracker).update();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$isCfEnable(int action) {
        return action == 1 || action == 3;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            imsPhone.getCallForwardingOption(commandInterfaceCFReason, onComplete);
            return;
        }
        if (this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Rlog.d("GSMPhone", "requesting call forwarding query.");
            Message resp = commandInterfaceCFReason == 0 ? this.obtainMessage(13, onComplete) : onComplete;
            this.mCi.queryCallForwardStatus(commandInterfaceCFReason, 0, null, resp);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            imsPhone.setCallForwardingOption(commandInterfaceCFAction, commandInterfaceCFReason, dialingNumber, timerSeconds, onComplete);
            return;
        }
        if (this.isValidCommandInterfaceCFAction(commandInterfaceCFAction) && this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Message resp;
            if (commandInterfaceCFReason == 0) {
                Cfu cfu = new Cfu(dialingNumber, onComplete);
                resp = this.obtainMessage(12, this.isCfEnable(commandInterfaceCFAction) ? 1 : 0, 0, cfu);
            } else {
                resp = onComplete;
            }
            this.mCi.setCallForward(commandInterfaceCFAction, commandInterfaceCFReason, 1, dialingNumber, timerSeconds, resp);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$getOutgoingCallerIdDisplay(Message onComplete) {
        this.mCi.getCLIR(onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        this.mCi.setCLIR(commandInterfaceCLIRMode, this.obtainMessage(18, commandInterfaceCLIRMode, 0, onComplete));
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$getCallWaiting(Message onComplete) {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            imsPhone.getCallWaiting(onComplete);
            return;
        }
        this.mCi.queryCallWaiting(0, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setCallWaiting(boolean enable, Message onComplete) {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            imsPhone.setCallWaiting(enable, onComplete);
            return;
        }
        this.mCi.setCallWaiting(enable, 1, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$getAvailableNetworks(Message response) {
        this.mCi.getAvailableNetworks(response);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$getNeighboringCids(Message response) {
        this.mCi.getNeighboringCids(response);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setOnPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialHandler = new Registrant(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$getMute() {
        return this.mCT.getMute();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDataCallList(Message response) {
        this.mCi.getDataCallList(response);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$updateServiceLocation() {
        this.mSST.enableSingleLocationUpdate();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$enableLocationUpdates() {
        this.mSST.enableLocationUpdates();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$disableLocationUpdates() {
        this.mSST.disableLocationUpdates();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDataRoamingEnabled() {
        return this.mDcTracker.getDataOnRoamingEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setDataRoamingEnabled(boolean enable) {
        this.mDcTracker.setDataOnRoamingEnabled(enable);
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDataEnabled() {
        return this.mDcTracker.getDataEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setDataEnabled(boolean enable) {
        this.mDcTracker.setDataEnabled(enable);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$onMMIDone(GsmMmiCode mmi) {
        if (this.mPendingMMIs.remove(mmi) || mmi.isUssdRequest()) {
            this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$onNetworkInitiatedUssd(GsmMmiCode mmi) {
        this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$onIncomingUSSD(int ussdMode, String ussdMessage) {
        boolean isUssdRequest = ussdMode == 1;
        boolean isUssdError = ussdMode != 0 && ussdMode != 1;
        GsmMmiCode found = null;
        int s = this.mPendingMMIs.size();
        for (int i = 0; i < s; ++i) {
            if (!this.mPendingMMIs.get(i).isPendingUSSD()) continue;
            found = this.mPendingMMIs.get(i);
            break;
        }
        if (found != null) {
            if (isUssdError) {
                found.onUssdFinishedError();
            } else {
                found.onUssdFinished(ussdMessage, isUssdRequest);
            }
        } else if (!isUssdError && ussdMessage != null) {
            GsmMmiCode mmi = GsmMmiCode.newNetworkInitiatedUssd(ussdMessage, isUssdRequest, this, (UiccCardApplication)this.mUiccApplication.get());
            this.onNetworkInitiatedUssd(mmi);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$syncClirSetting() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        int clirSetting = sp.getInt("clir_key" + this.getPhoneId(), -1);
        if (clirSetting >= 0) {
            this.mCi.setCLIR(clirSetting, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleMessage(Message msg) {
        if (!this.mIsTheCurrentActivePhone) {
            Rlog.e("GSMPhone", "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        switch (msg.what) {
            case 1: {
                this.mCi.getBasebandVersion(this.obtainMessage(6));
                this.mCi.getIMEI(this.obtainMessage(9));
                this.mCi.getIMEISV(this.obtainMessage(10));
                break;
            }
            case 5: {
                break;
            }
            case 19: {
                this.syncClirSetting();
                break;
            }
            case 3: {
                this.updateCurrentCarrierInProvider();
                String imsi = this.getVmSimImsi();
                String imsiFromSIM = this.getSubscriberId();
                if (imsi != null && imsiFromSIM != null && !imsiFromSIM.equals(imsi)) {
                    this.storeVoiceMailNumber(null);
                    this.setVmSimImsi(null);
                }
                this.mSimRecordsLoadedRegistrants.notifyRegistrants();
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                Rlog.d("GSMPhone", "Baseband version: " + ar.result);
                this.setSystemProperty("gsm.version.baseband", (String)ar.result);
                break;
            }
            case 9: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mImei = (String)ar.result;
                break;
            }
            case 10: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mImeiSv = (String)ar.result;
                break;
            }
            case 7: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String[] ussdResult = (String[])ar.result;
                if (ussdResult.length <= 1) break;
                try {
                    this.onIncomingUSSD(Integer.parseInt(ussdResult[0]), ussdResult[1]);
                }
                catch (NumberFormatException e) {
                    Rlog.w("GSMPhone", "error parsing USSD");
                }
                break;
            }
            case 8: {
                for (int i = this.mPendingMMIs.size() - 1; i >= 0; --i) {
                    if (!this.mPendingMMIs.get(i).isPendingUSSD()) continue;
                    this.mPendingMMIs.get(i).onUssdFinishedError();
                }
                ImsPhone imsPhone = this.mImsPhone;
                if (imsPhone == null) break;
                imsPhone.getServiceState().setStateOff();
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                SuppServiceNotification not = (SuppServiceNotification)ar.result;
                this.mSsnRegistrants.notifyRegistrants(ar);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                IccRecords r = (IccRecords)this.mIccRecords.get();
                Cfu cfu = (Cfu)ar.userObj;
                if (ar.exception == null && r != null) {
                    r.setVoiceCallForwardingFlag(1, msg.arg1 == 1, cfu.mSetCfNumber);
                }
                if (cfu.mOnComplete == null) break;
                AsyncResult.forMessage(cfu.mOnComplete, ar.result, ar.exception);
                cfu.mOnComplete.sendToTarget();
                break;
            }
            case 20: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (IccVmNotSupportedException.class.isInstance(ar.exception)) {
                    this.storeVoiceMailNumber(this.mVmNumber);
                    ar.exception = null;
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 13: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.handleCfuQueryResult((CallForwardInfo[])ar.result);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 28: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (this.mSST.mSS.getIsManualSelection()) {
                    this.setNetworkSelectionModeAutomatic((Message)ar.result);
                    Rlog.d("GSMPhone", "SET_NETWORK_SELECTION_AUTOMATIC: set to automatic");
                    break;
                }
                Rlog.d("GSMPhone", "SET_NETWORK_SELECTION_AUTOMATIC: already automatic, ignore");
                break;
            }
            case 29: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.processIccRecordEvents((Integer)ar.result);
                break;
            }
            case 18: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.saveClirSetting(msg.arg1);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 500: {
                this.log("EVENT_SUBSCRIPTION_ACTIVATED");
                this.onSubscriptionActivated();
                break;
            }
            case 501: {
                this.log("EVENT_SUBSCRIPTION_DEACTIVATED");
                this.onSubscriptionDeactivated();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final UiccCardApplication $$robo$$com_android_internal_telephony_gsm_GSMPhone$getUiccCardApplication() {
        return this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$onUpdateIccAvailability() {
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 3);
        IsimUiccRecords newIsimUiccRecords = null;
        if (newUiccApplication != null) {
            newIsimUiccRecords = (IsimUiccRecords)newUiccApplication.getIccRecords();
            this.log("New ISIM application found");
        }
        this.mIsimUiccRecords = newIsimUiccRecords;
        newUiccApplication = this.getUiccCardApplication();
        UiccCardApplication app = (UiccCardApplication)this.mUiccApplication.get();
        if (app != newUiccApplication) {
            if (app != null) {
                this.log("Removing stale icc objects.");
                if (this.mIccRecords.get() != null) {
                    this.unregisterForSimRecordEvents();
                    this.mSimPhoneBookIntManager.updateIccRecords(null);
                }
                this.mIccRecords.set(null);
                this.mUiccApplication.set(null);
            }
            if (newUiccApplication != null) {
                this.log("New Uicc application found");
                this.mUiccApplication.set(newUiccApplication);
                this.mIccRecords.set(newUiccApplication.getIccRecords());
                this.registerForSimRecordEvents();
                this.mSimPhoneBookIntManager.updateIccRecords((IccRecords)this.mIccRecords.get());
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$processIccRecordEvents(int eventCode) {
        switch (eventCode) {
            case 1: {
                this.notifyCallForwardingIndicator();
                break;
            }
            case 0: {
                this.notifyMessageWaitingIndicator();
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$updateCurrentCarrierInProvider() {
        long currentDds = SubscriptionManager.getDefaultDataSubId();
        String operatorNumeric = this.getOperatorNumeric();
        this.log("updateCurrentCarrierInProvider: mSubId = " + this.getSubId() + " currentDds = " + currentDds + " operatorNumeric = " + operatorNumeric);
        if (!TextUtils.isEmpty(operatorNumeric) && this.getSubId() == currentDds) {
            try {
                Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                ContentValues map = new ContentValues();
                map.put("numeric", operatorNumeric);
                this.mContext.getContentResolver().insert(uri, map);
                return true;
            }
            catch (SQLException e) {
                Rlog.e("GSMPhone", "Can't store current operator", e);
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$saveClirSetting(int commandInterfaceCLIRMode) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("clir_key" + this.getPhoneId(), commandInterfaceCLIRMode);
        if (!editor.commit()) {
            Rlog.e("GSMPhone", "failed to commit CLIR preference");
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleCfuQueryResult(CallForwardInfo[] infos) {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            if (infos == null || infos.length == 0) {
                r.setVoiceCallForwardingFlag(1, false, null);
            } else {
                int s = infos.length;
                for (int i = 0; i < s; ++i) {
                    if ((infos[i].serviceClass & 1) == 0) continue;
                    r.setVoiceCallForwardingFlag(1, infos[i].status == 1, infos[i].number);
                    break;
                }
            }
        }
    }

    private final PhoneSubInfo $$robo$$com_android_internal_telephony_gsm_GSMPhone$getPhoneSubInfo() {
        return this.mSubInfo;
    }

    private final IccPhoneBookInterfaceManager $$robo$$com_android_internal_telephony_gsm_GSMPhone$getIccPhoneBookInterfaceManager() {
        return this.mSimPhoneBookIntManager;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$activateCellBroadcastSms(int activate, Message response) {
        Rlog.e("GSMPhone", "[GSMPhone] activateCellBroadcastSms() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$getCellBroadcastSmsConfig(Message response) {
        Rlog.e("GSMPhone", "[GSMPhone] getCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setCellBroadcastSmsConfig(int[] configValuesArray, Message response) {
        Rlog.e("GSMPhone", "[GSMPhone] setCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$isCspPlmnEnabled() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.isCspPlmnEnabled() : false;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$registerForSimRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        r.registerForNetworkSelectionModeAutomatic(this, 28, null);
        r.registerForRecordsEvents(this, 29, null);
        r.registerForRecordsLoaded(this, 3, null);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$unregisterForSimRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        r.unregisterForNetworkSelectionModeAutomatic(this);
        r.unregisterForRecordsEvents(this);
        r.unregisterForRecordsLoaded(this);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$exitEmergencyCallbackMode() {
        if (this.mImsPhone != null) {
            this.mImsPhone.exitEmergencyCallbackMode();
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("GSMPhone extends:");
        super.dump(fd, pw, args);
        pw.println(" mCT=" + this.mCT);
        pw.println(" mSST=" + this.mSST);
        pw.println(" mPendingMMIs=" + this.mPendingMMIs);
        pw.println(" mSimPhoneBookIntManager=" + this.mSimPhoneBookIntManager);
        pw.println(" mSubInfo=" + this.mSubInfo);
        pw.println(" mVmNumber=" + this.mVmNumber);
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$setOperatorBrandOverride(String brand) {
        if (this.mUiccController == null) {
            return false;
        }
        UiccCard card = this.mUiccController.getUiccCard();
        if (card == null) {
            return false;
        }
        boolean status = card.setOperatorBrandOverride(brand);
        if (status) {
            IccRecords iccRecords = (IccRecords)this.mIccRecords.get();
            if (iccRecords != null) {
                SystemProperties.set("gsm.sim.operator.alpha", iccRecords.getServiceProviderName());
            }
            if (this.mSST != null) {
                this.mSST.pollState();
            }
        }
        return status;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GSMPhone$getOperatorNumeric() {
        String operatorNumeric = null;
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            operatorNumeric = r.getOperatorNumeric();
        }
        return operatorNumeric;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$registerForAllDataDisconnected(Handler h, int what, Object obj) {
        ((DcTracker)this.mDcTracker).registerForAllDataDisconnected(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$unregisterForAllDataDisconnected(Handler h) {
        ((DcTracker)this.mDcTracker).unregisterForAllDataDisconnected(h);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$setInternalDataEnabled(boolean enable, Message onCompleteMsg) {
        ((DcTracker)this.mDcTracker).setInternalDataEnabled(enable, onCompleteMsg);
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GSMPhone$setInternalDataEnabledFlag(boolean enable) {
        return ((DcTracker)this.mDcTracker).setInternalDataEnabledFlag(enable);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyEcbmTimerReset(Boolean flag) {
        this.mEcmTimerResetRegistrants.notifyResult(flag);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$registerForEcmTimerReset(Handler h, int what, Object obj) {
        this.mEcmTimerResetRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$unregisterForEcmTimerReset(Handler h) {
        this.mEcmTimerResetRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$resetSubSpecifics() {
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GSMPhone$log(String s) {
        Rlog.d("GSMPhone", "[GSMPhone] " + s);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier) {
        this.$$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(context, commandsInterface, phoneNotifier);
    }

    public GSMPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier) {
        this(context, commandsInterface, phoneNotifier, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier ), 0, this, context, commandsInterface, phoneNotifier);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl) {
        this.$$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(context, commandsInterface, phoneNotifier, bl);
    }

    public GSMPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl) {
        super("GSM", phoneNotifier, context, commandsInterface, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier boolean ), 0, this, context, commandsInterface, phoneNotifier, bl);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, int n) {
        this.$$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(context, commandsInterface, phoneNotifier, n);
    }

    public GSMPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, int n) {
        this(context, commandsInterface, phoneNotifier, false, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier int ), 0, this, context, commandsInterface, phoneNotifier, n);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl, int n) {
        this.$$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(context, commandsInterface, phoneNotifier, bl, n);
    }

    public GSMPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl, int n) {
        super("GSM", phoneNotifier, context, commandsInterface, bl, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GSMPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier boolean int ), 0, this, context, commandsInterface, phoneNotifier, bl, n);
    }

    protected void setProperties() {
        InvokeDynamicSupport.bootstrap("setProperties", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setProperties(), 0, this);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_gsm_GSMPhone$dispose(), 0, this);
    }

    @Override
    public void removeReferences() {
        InvokeDynamicSupport.bootstrap("removeReferences", $$robo$$com_android_internal_telephony_gsm_GSMPhone$removeReferences(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_gsm_GSMPhone$finalize(), 0, this);
    }

    private void onSubscriptionActivated() {
        InvokeDynamicSupport.bootstrap("onSubscriptionActivated", $$robo$$com_android_internal_telephony_gsm_GSMPhone$onSubscriptionActivated(), 0, this);
    }

    private void onSubscriptionDeactivated() {
        InvokeDynamicSupport.bootstrap("onSubscriptionDeactivated", $$robo$$com_android_internal_telephony_gsm_GSMPhone$onSubscriptionDeactivated(), 0, this);
    }

    @Override
    public ServiceState getServiceState() {
        return InvokeDynamicSupport.bootstrap("getServiceState", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getServiceState(), 0, this);
    }

    @Override
    public CellLocation getCellLocation() {
        return InvokeDynamicSupport.bootstrap("getCellLocation", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getCellLocation(), 0, this);
    }

    @Override
    public PhoneConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getState(), 0, this);
    }

    @Override
    public int getPhoneType() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneType", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getPhoneType(), 0, this);
    }

    @Override
    public ServiceStateTracker getServiceStateTracker() {
        return InvokeDynamicSupport.bootstrap("getServiceStateTracker", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getServiceStateTracker(), 0, this);
    }

    @Override
    public CallTracker getCallTracker() {
        return InvokeDynamicSupport.bootstrap("getCallTracker", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getCallTracker(), 0, this);
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return InvokeDynamicSupport.bootstrap("getPendingMmiCodes", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getPendingMmiCodes(), 0, this);
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState(String string2) {
        return InvokeDynamicSupport.bootstrap("getDataConnectionState", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDataConnectionState(java.lang.String ), 0, this, string2);
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        return InvokeDynamicSupport.bootstrap("getDataActivityState", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDataActivityState(), 0, this);
    }

    void notifyPhoneStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyPhoneStateChanged", $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyPhoneStateChanged(), 0, this);
    }

    void notifyPreciseCallStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyPreciseCallStateChanged", $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyPreciseCallStateChanged(), 0, this);
    }

    public void notifyNewRingingConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyNewRingingConnection", $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyNewRingingConnection(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    void notifyDisconnect(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyDisconnect", $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyDisconnect(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    void notifyUnknownConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyUnknownConnection", $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyUnknownConnection(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    void notifySuppServiceFailed(Phone.SuppService suppService) {
        InvokeDynamicSupport.bootstrap("notifySuppServiceFailed", $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifySuppServiceFailed(com.android.internal.telephony.Phone$SuppService ), 0, this, suppService);
    }

    void notifyServiceStateChanged(ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("notifyServiceStateChanged", $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyServiceStateChanged(android.telephony.ServiceState ), 0, this, serviceState);
    }

    void notifyLocationChanged() {
        InvokeDynamicSupport.bootstrap("notifyLocationChanged", $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyLocationChanged(), 0, this);
    }

    @Override
    public void notifyCallForwardingIndicator() {
        InvokeDynamicSupport.bootstrap("notifyCallForwardingIndicator", $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyCallForwardingIndicator(), 0, this);
    }

    @Override
    public void setSystemProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSystemProperty", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSuppServiceNotification", $$robo$$com_android_internal_telephony_gsm_GSMPhone$registerForSuppServiceNotification(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSuppServiceNotification", $$robo$$com_android_internal_telephony_gsm_GSMPhone$unregisterForSuppServiceNotification(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSimRecordsLoaded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSimRecordsLoaded", $$robo$$com_android_internal_telephony_gsm_GSMPhone$registerForSimRecordsLoaded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSimRecordsLoaded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSimRecordsLoaded", $$robo$$com_android_internal_telephony_gsm_GSMPhone$unregisterForSimRecordsLoaded(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void acceptCall(int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_gsm_GSMPhone$acceptCall(int ), 0, this, n);
    }

    @Override
    public void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_gsm_GSMPhone$rejectCall(), 0, this);
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchHoldingAndActive", $$robo$$com_android_internal_telephony_gsm_GSMPhone$switchHoldingAndActive(), 0, this);
    }

    @Override
    public boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_gsm_GSMPhone$canConference(), 0, this);
    }

    public boolean canDial() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDial", $$robo$$com_android_internal_telephony_gsm_GSMPhone$canDial(), 0, this);
    }

    @Override
    public void conference() {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_gsm_GSMPhone$conference(), 0, this);
    }

    @Override
    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_gsm_GSMPhone$clearDisconnected(), 0, this);
    }

    @Override
    public boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_gsm_GSMPhone$canTransfer(), 0, this);
    }

    @Override
    public void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_gsm_GSMPhone$explicitCallTransfer(), 0, this);
    }

    @Override
    public GsmCall getForegroundCall() {
        return InvokeDynamicSupport.bootstrap("getForegroundCall", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getForegroundCall(), 0, this);
    }

    @Override
    public GsmCall getBackgroundCall() {
        return InvokeDynamicSupport.bootstrap("getBackgroundCall", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getBackgroundCall(), 0, this);
    }

    @Override
    public Call getRingingCall() {
        return InvokeDynamicSupport.bootstrap("getRingingCall", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getRingingCall(), 0, this);
    }

    private boolean handleCallDeflectionIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCallDeflectionIncallSupplementaryService", $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleCallDeflectionIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    private boolean handleCallWaitingIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCallWaitingIncallSupplementaryService", $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleCallWaitingIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    private boolean handleCallHoldIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCallHoldIncallSupplementaryService", $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleCallHoldIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    private boolean handleMultipartyIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMultipartyIncallSupplementaryService", $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleMultipartyIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    private boolean handleEctIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleEctIncallSupplementaryService", $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleEctIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    private boolean handleCcbsIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCcbsIncallSupplementaryService", $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleCcbsIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean handleInCallMmiCommands(String string2) throws CallStateException {
        return (boolean)InvokeDynamicSupport.bootstrap("handleInCallMmiCommands", $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleInCallMmiCommands(java.lang.String ), 0, this, string2);
    }

    boolean isInCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInCall", $$robo$$com_android_internal_telephony_gsm_GSMPhone$isInCall(), 0, this);
    }

    @Override
    public Connection dial(String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_gsm_GSMPhone$dial(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public Connection dial(String string2, UUSInfo uUSInfo, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_gsm_GSMPhone$dial(java.lang.String com.android.internal.telephony.UUSInfo int ), 0, this, string2, uUSInfo, n);
    }

    @Override
    protected Connection dialInternal(String string2, UUSInfo uUSInfo, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_gsm_GSMPhone$dialInternal(java.lang.String com.android.internal.telephony.UUSInfo int ), 0, this, string2, uUSInfo, n);
    }

    @Override
    public boolean handlePinMmi(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePinMmi", $$robo$$com_android_internal_telephony_gsm_GSMPhone$handlePinMmi(java.lang.String ), 0, this, string2);
    }

    @Override
    public void sendUssdResponse(String string2) {
        InvokeDynamicSupport.bootstrap("sendUssdResponse", $$robo$$com_android_internal_telephony_gsm_GSMPhone$sendUssdResponse(java.lang.String ), 0, this, string2);
    }

    @Override
    public void sendDtmf(char c) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_gsm_GSMPhone$sendDtmf(char ), 0, this, c);
    }

    @Override
    public void startDtmf(char c) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_gsm_GSMPhone$startDtmf(char ), 0, this, c);
    }

    @Override
    public void stopDtmf() {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_gsm_GSMPhone$stopDtmf(), 0, this);
    }

    public void sendBurstDtmf(String string2) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_gsm_GSMPhone$sendBurstDtmf(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setRadioPower(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRadioPower", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setRadioPower(boolean ), 0, this, bl);
    }

    private void storeVoiceMailNumber(String string2) {
        InvokeDynamicSupport.bootstrap("storeVoiceMailNumber", $$robo$$com_android_internal_telephony_gsm_GSMPhone$storeVoiceMailNumber(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getVoiceMailNumber(), 0, this);
    }

    private String getVmSimImsi() {
        return InvokeDynamicSupport.bootstrap("getVmSimImsi", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getVmSimImsi(), 0, this);
    }

    private void setVmSimImsi(String string2) {
        InvokeDynamicSupport.bootstrap("setVmSimImsi", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setVmSimImsi(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getVoiceMailAlphaTag(), 0, this);
    }

    @Override
    public String getDeviceId() {
        return InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDeviceId(), 0, this);
    }

    @Override
    public String getDeviceSvn() {
        return InvokeDynamicSupport.bootstrap("getDeviceSvn", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDeviceSvn(), 0, this);
    }

    @Override
    public IsimRecords getIsimRecords() {
        return InvokeDynamicSupport.bootstrap("getIsimRecords", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getIsimRecords(), 0, this);
    }

    @Override
    public String getImei() {
        return InvokeDynamicSupport.bootstrap("getImei", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getImei(), 0, this);
    }

    @Override
    public String getEsn() {
        return InvokeDynamicSupport.bootstrap("getEsn", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getEsn(), 0, this);
    }

    @Override
    public String getMeid() {
        return InvokeDynamicSupport.bootstrap("getMeid", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getMeid(), 0, this);
    }

    @Override
    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getSubscriberId(), 0, this);
    }

    @Override
    public String getGroupIdLevel1() {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getGroupIdLevel1(), 0, this);
    }

    @Override
    public String getLine1Number() {
        return InvokeDynamicSupport.bootstrap("getLine1Number", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getLine1Number(), 0, this);
    }

    @Override
    public String getMsisdn() {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getMsisdn(), 0, this);
    }

    @Override
    public String getLine1AlphaTag() {
        return InvokeDynamicSupport.bootstrap("getLine1AlphaTag", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getLine1AlphaTag(), 0, this);
    }

    @Override
    public void setLine1Number(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setLine1Number", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setLine1Number(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setVoiceMailNumber(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    private boolean isValidCommandInterfaceCFReason(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidCommandInterfaceCFReason", $$robo$$com_android_internal_telephony_gsm_GSMPhone$isValidCommandInterfaceCFReason(int ), 0, this, n);
    }

    @Override
    public String getSystemProperty(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getSystemProperty", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private boolean isValidCommandInterfaceCFAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidCommandInterfaceCFAction", $$robo$$com_android_internal_telephony_gsm_GSMPhone$isValidCommandInterfaceCFAction(int ), 0, this, n);
    }

    public void updateDataConnectionTracker() {
        InvokeDynamicSupport.bootstrap("updateDataConnectionTracker", $$robo$$com_android_internal_telephony_gsm_GSMPhone$updateDataConnectionTracker(), 0, this);
    }

    protected boolean isCfEnable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCfEnable", $$robo$$com_android_internal_telephony_gsm_GSMPhone$isCfEnable(int ), 0, this, n);
    }

    @Override
    public void getCallForwardingOption(int n, Message message) {
        InvokeDynamicSupport.bootstrap("getCallForwardingOption", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getCallForwardingOption(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
        InvokeDynamicSupport.bootstrap("setCallForwardingOption", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setCallForwardingOption(int int java.lang.String int android.os.Message ), 0, this, n, n2, string2, n3, message);
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        InvokeDynamicSupport.bootstrap("getOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getOutgoingCallerIdDisplay(android.os.Message ), 0, this, message);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setOutgoingCallerIdDisplay(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getCallWaiting(Message message) {
        InvokeDynamicSupport.bootstrap("getCallWaiting", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getCallWaiting(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setCallWaiting", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setCallWaiting(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        InvokeDynamicSupport.bootstrap("getAvailableNetworks", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getAvailableNetworks(android.os.Message ), 0, this, message);
    }

    @Override
    public void getNeighboringCids(Message message) {
        InvokeDynamicSupport.bootstrap("getNeighboringCids", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getNeighboringCids(android.os.Message ), 0, this, message);
    }

    @Override
    public void setOnPostDialCharacter(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnPostDialCharacter", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setOnPostDialCharacter(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setMute(boolean ), 0, this, bl);
    }

    @Override
    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getMute(), 0, this);
    }

    @Override
    public void getDataCallList(Message message) {
        InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDataCallList(android.os.Message ), 0, this, message);
    }

    @Override
    public void updateServiceLocation() {
        InvokeDynamicSupport.bootstrap("updateServiceLocation", $$robo$$com_android_internal_telephony_gsm_GSMPhone$updateServiceLocation(), 0, this);
    }

    @Override
    public void enableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("enableLocationUpdates", $$robo$$com_android_internal_telephony_gsm_GSMPhone$enableLocationUpdates(), 0, this);
    }

    @Override
    public void disableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("disableLocationUpdates", $$robo$$com_android_internal_telephony_gsm_GSMPhone$disableLocationUpdates(), 0, this);
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataRoamingEnabled", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDataRoamingEnabled(), 0, this);
    }

    @Override
    public void setDataRoamingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataRoamingEnabled", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setDataRoamingEnabled(boolean ), 0, this, bl);
    }

    @Override
    public boolean getDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataEnabled", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getDataEnabled(), 0, this);
    }

    @Override
    public void setDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataEnabled", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setDataEnabled(boolean ), 0, this, bl);
    }

    void onMMIDone(GsmMmiCode gsmMmiCode) {
        InvokeDynamicSupport.bootstrap("onMMIDone", $$robo$$com_android_internal_telephony_gsm_GSMPhone$onMMIDone(com.android.internal.telephony.gsm.GsmMmiCode ), 0, this, gsmMmiCode);
    }

    private void onNetworkInitiatedUssd(GsmMmiCode gsmMmiCode) {
        InvokeDynamicSupport.bootstrap("onNetworkInitiatedUssd", $$robo$$com_android_internal_telephony_gsm_GSMPhone$onNetworkInitiatedUssd(com.android.internal.telephony.gsm.GsmMmiCode ), 0, this, gsmMmiCode);
    }

    private void onIncomingUSSD(int n, String string2) {
        InvokeDynamicSupport.bootstrap("onIncomingUSSD", $$robo$$com_android_internal_telephony_gsm_GSMPhone$onIncomingUSSD(int java.lang.String ), 0, this, n, string2);
    }

    protected void syncClirSetting() {
        InvokeDynamicSupport.bootstrap("syncClirSetting", $$robo$$com_android_internal_telephony_gsm_GSMPhone$syncClirSetting(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleMessage(android.os.Message ), 0, this, message);
    }

    protected UiccCardApplication getUiccCardApplication() {
        return InvokeDynamicSupport.bootstrap("getUiccCardApplication", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getUiccCardApplication(), 0, this);
    }

    @Override
    protected void onUpdateIccAvailability() {
        InvokeDynamicSupport.bootstrap("onUpdateIccAvailability", $$robo$$com_android_internal_telephony_gsm_GSMPhone$onUpdateIccAvailability(), 0, this);
    }

    private void processIccRecordEvents(int n) {
        InvokeDynamicSupport.bootstrap("processIccRecordEvents", $$robo$$com_android_internal_telephony_gsm_GSMPhone$processIccRecordEvents(int ), 0, this, n);
    }

    public boolean updateCurrentCarrierInProvider() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateCurrentCarrierInProvider", $$robo$$com_android_internal_telephony_gsm_GSMPhone$updateCurrentCarrierInProvider(), 0, this);
    }

    public void saveClirSetting(int n) {
        InvokeDynamicSupport.bootstrap("saveClirSetting", $$robo$$com_android_internal_telephony_gsm_GSMPhone$saveClirSetting(int ), 0, this, n);
    }

    private void handleCfuQueryResult(CallForwardInfo[] callForwardInfoArray) {
        InvokeDynamicSupport.bootstrap("handleCfuQueryResult", $$robo$$com_android_internal_telephony_gsm_GSMPhone$handleCfuQueryResult(com.android.internal.telephony.CallForwardInfo[] ), 0, this, callForwardInfoArray);
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return InvokeDynamicSupport.bootstrap("getPhoneSubInfo", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getPhoneSubInfo(), 0, this);
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return InvokeDynamicSupport.bootstrap("getIccPhoneBookInterfaceManager", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getIccPhoneBookInterfaceManager(), 0, this);
    }

    @Override
    public void activateCellBroadcastSms(int n, Message message) {
        InvokeDynamicSupport.bootstrap("activateCellBroadcastSms", $$robo$$com_android_internal_telephony_gsm_GSMPhone$activateCellBroadcastSms(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getCellBroadcastSmsConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getCellBroadcastSmsConfig", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getCellBroadcastSmsConfig(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] nArray, Message message) {
        InvokeDynamicSupport.bootstrap("setCellBroadcastSmsConfig", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setCellBroadcastSmsConfig(int[] android.os.Message ), 0, this, nArray, message);
    }

    @Override
    public boolean isCspPlmnEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCspPlmnEnabled", $$robo$$com_android_internal_telephony_gsm_GSMPhone$isCspPlmnEnabled(), 0, this);
    }

    private void registerForSimRecordEvents() {
        InvokeDynamicSupport.bootstrap("registerForSimRecordEvents", $$robo$$com_android_internal_telephony_gsm_GSMPhone$registerForSimRecordEvents(), 0, this);
    }

    private void unregisterForSimRecordEvents() {
        InvokeDynamicSupport.bootstrap("unregisterForSimRecordEvents", $$robo$$com_android_internal_telephony_gsm_GSMPhone$unregisterForSimRecordEvents(), 0, this);
    }

    @Override
    public void exitEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_gsm_GSMPhone$exitEmergencyCallbackMode(), 0, this);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_gsm_GSMPhone$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public boolean setOperatorBrandOverride(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setOperatorBrandOverride(java.lang.String ), 0, this, string2);
    }

    public String getOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getOperatorNumeric", $$robo$$com_android_internal_telephony_gsm_GSMPhone$getOperatorNumeric(), 0, this);
    }

    public void registerForAllDataDisconnected(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForAllDataDisconnected", $$robo$$com_android_internal_telephony_gsm_GSMPhone$registerForAllDataDisconnected(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForAllDataDisconnected(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForAllDataDisconnected", $$robo$$com_android_internal_telephony_gsm_GSMPhone$unregisterForAllDataDisconnected(android.os.Handler ), 0, this, handler);
    }

    public void setInternalDataEnabled(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setInternalDataEnabled", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setInternalDataEnabled(boolean android.os.Message ), 0, this, bl, message);
    }

    public boolean setInternalDataEnabledFlag(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setInternalDataEnabledFlag", $$robo$$com_android_internal_telephony_gsm_GSMPhone$setInternalDataEnabledFlag(boolean ), 0, this, bl);
    }

    public void notifyEcbmTimerReset(Boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyEcbmTimerReset", $$robo$$com_android_internal_telephony_gsm_GSMPhone$notifyEcbmTimerReset(java.lang.Boolean ), 0, this, bl);
    }

    @Override
    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEcmTimerReset", $$robo$$com_android_internal_telephony_gsm_GSMPhone$registerForEcmTimerReset(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEcmTimerReset", $$robo$$com_android_internal_telephony_gsm_GSMPhone$unregisterForEcmTimerReset(android.os.Handler ), 0, this, handler);
    }

    public void resetSubSpecifics() {
        InvokeDynamicSupport.bootstrap("resetSubSpecifics", $$robo$$com_android_internal_telephony_gsm_GSMPhone$resetSubSpecifics(), 0, this);
    }

    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_gsm_GSMPhone$log(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ GSMPhone() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GSMPhone)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$DctConstants$State;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$DctConstants$Activity;

        static void __staticInitializer__() {
            $SwitchMap$com$android$internal$telephony$DctConstants$Activity = new int[DctConstants.Activity.values().length];
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[DctConstants.Activity.DATAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[DctConstants.Activity.DATAOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[DctConstants.Activity.DATAINANDOUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[DctConstants.Activity.DORMANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $SwitchMap$com$android$internal$telephony$DctConstants$State = new int[DctConstants.State.values().length];
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.RETRYING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.IDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.CONNECTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.DISCONNECTING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.CONNECTING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DctConstants$State[DctConstants.State.SCANNING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Cfu
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mSetCfNumber;
        Message mOnComplete;

        private void $$robo$$com_android_internal_telephony_gsm_GSMPhone_Cfu$__constructor__(String cfNumber, Message onComplete) {
            this.mSetCfNumber = cfNumber;
            this.mOnComplete = onComplete;
        }

        private void __constructor__(String string2, Message message) {
            this.$$robo$$com_android_internal_telephony_gsm_GSMPhone_Cfu$__constructor__(string2, message);
        }

        Cfu(String string2, Message message) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GSMPhone_Cfu$__constructor__(java.lang.String android.os.Message ), 0, this, string2, message);
        }

        public /* synthetic */ Cfu() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cfu)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

