/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.EventLog;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmConnection;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class GsmCallTracker
extends CallTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "GsmCallTracker";
    private static boolean REPEAT_POLLING = false;
    private static boolean DBG_POLL = false;
    static int MAX_CONNECTIONS = 7;
    static int MAX_CONNECTIONS_PER_CALL = 5;
    GsmConnection[] mConnections;
    RegistrantList mVoiceCallEndedRegistrants;
    RegistrantList mVoiceCallStartedRegistrants;
    ArrayList<GsmConnection> mDroppedDuringPoll;
    GsmCall mRingingCall;
    GsmCall mForegroundCall;
    GsmCall mBackgroundCall;
    GsmConnection mPendingMO;
    boolean mHangupPendingMO;
    GSMPhone mPhone;
    boolean mDesiredMute;
    PhoneConstants.State mState;
    Call.SrvccState mSrvccState;

    private void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$__constructor__(GSMPhone phone) {
        this.mConnections = new GsmConnection[7];
        this.mVoiceCallEndedRegistrants = new RegistrantList();
        this.mVoiceCallStartedRegistrants = new RegistrantList();
        this.mDroppedDuringPoll = new ArrayList(7);
        this.mRingingCall = new GsmCall(this);
        this.mForegroundCall = new GsmCall(this);
        this.mBackgroundCall = new GsmCall(this);
        this.mDesiredMute = false;
        this.mState = PhoneConstants.State.IDLE;
        this.mSrvccState = Call.SrvccState.NONE;
        this.mPhone = phone;
        this.mCi = phone.mCi;
        this.mCi.registerForCallStateChanged(this, 2, null);
        this.mCi.registerForOn(this, 9, null);
        this.mCi.registerForNotAvailable(this, 10, null);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dispose() {
        Rlog.d("GsmCallTracker", "GsmCallTracker dispose");
        this.mCi.unregisterForCallStateChanged(this);
        this.mCi.unregisterForOn(this);
        this.mCi.unregisterForNotAvailable(this);
        this.clearDisconnected();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$finalize() {
        Rlog.d("GsmCallTracker", "GsmCallTracker finalized");
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$fakeHoldForegroundBeforeDial() {
        List connCopy = (List)this.mForegroundCall.mConnections.clone();
        int s = connCopy.size();
        for (int i = 0; i < s; ++i) {
            GsmConnection conn = (GsmConnection)connCopy.get(i);
            conn.fakeHoldBeforeDial();
        }
    }

    private final synchronized Connection $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dial(String dialString, int clirMode, UUSInfo uusInfo) throws CallStateException {
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        String origNumber = dialString;
        dialString = this.convertNumberIfNecessary(this.mPhone, dialString);
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            this.switchWaitingOrHoldingAndActive();
            this.fakeHoldForegroundBeforeDial();
        }
        if (this.mForegroundCall.getState() != Call.State.IDLE) {
            throw new CallStateException("cannot dial in current state");
        }
        this.mPendingMO = new GsmConnection(this.mPhone.getContext(), this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall);
        this.mHangupPendingMO = false;
        if (this.mPendingMO.getAddress() == null || this.mPendingMO.getAddress().length() == 0 || this.mPendingMO.getAddress().indexOf(78) >= 0) {
            this.mPendingMO.mCause = 7;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.mCi.dial(this.mPendingMO.getAddress(), clirMode, uusInfo, this.obtainCompleteMessage());
        }
        if (this.mNumberConverted) {
            this.mPendingMO.setConverted(origNumber);
            this.mNumberConverted = false;
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    private final Connection $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dial(String dialString) throws CallStateException {
        return this.dial(dialString, 0, null);
    }

    private final Connection $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dial(String dialString, UUSInfo uusInfo) throws CallStateException {
        return this.dial(dialString, 0, uusInfo);
    }

    private final Connection $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dial(String dialString, int clirMode) throws CallStateException {
        return this.dial(dialString, clirMode, null);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$acceptCall() throws CallStateException {
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            Rlog.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            this.mCi.acceptCall(this.obtainCompleteMessage());
        } else if (this.mRingingCall.getState() == Call.State.WAITING) {
            this.setMute(false);
            this.switchWaitingOrHoldingAndActive();
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$rejectCall() throws CallStateException {
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.mCi.rejectCall(this.obtainCompleteMessage());
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$switchWaitingOrHoldingAndActive() throws CallStateException {
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        this.mCi.switchWaitingOrHoldingAndActive(this.obtainCompleteMessage(8));
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$conference() {
        this.mCi.conference(this.obtainCompleteMessage(11));
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$explicitCallTransfer() {
        this.mCi.explicitCallTransfer(this.obtainCompleteMessage(13));
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$canDial() {
        int serviceState = this.mPhone.getServiceState().getState();
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean ret = serviceState != 3 && this.mPendingMO == null && !this.mRingingCall.isRinging() && !disableCall.equals("true") && (!this.mForegroundCall.getState().isAlive() || !this.mBackgroundCall.getState().isAlive());
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$canTransfer() {
        return (this.mForegroundCall.getState() == Call.State.ACTIVE || this.mForegroundCall.getState() == Call.State.ALERTING || this.mForegroundCall.getState() == Call.State.DIALING) && this.mBackgroundCall.getState() == Call.State.HOLDING;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
    }

    private final Message $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    private final Message $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$obtainCompleteMessage(int what) {
        ++this.mPendingOperations;
        this.mLastRelevantPoll = null;
        this.mNeedsPoll = true;
        return this.obtainMessage(what);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$operationComplete() {
        --this.mPendingOperations;
        if (this.mPendingOperations == 0 && this.mNeedsPoll) {
            this.mLastRelevantPoll = this.obtainMessage(1);
            this.mCi.getCurrentCalls(this.mLastRelevantPoll);
        } else if (this.mPendingOperations < 0) {
            Rlog.e("GsmCallTracker", "GsmCallTracker.pendingOperations < 0");
            this.mPendingOperations = 0;
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$updatePhoneState() {
        PhoneConstants.State oldState = this.mState;
        this.mState = this.mRingingCall.isRinging() ? PhoneConstants.State.RINGING : (this.mPendingMO != null || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle() ? PhoneConstants.State.OFFHOOK : PhoneConstants.State.IDLE);
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$handlePollCalls(AsyncResult ar) {
        int i;
        ArrayList polledCalls;
        if (ar.exception == null) {
            polledCalls = (ArrayList)ar.result;
        } else if (this.isCommandExceptionRadioNotAvailable(ar.exception)) {
            polledCalls = new ArrayList();
        } else {
            this.pollCallsAfterDelay();
            return;
        }
        GsmConnection newRinging = null;
        GsmConnection newUnknown = null;
        boolean hasNonHangupStateChanged = false;
        boolean hasAnyCallDisconnected = false;
        boolean needsPollDelay = false;
        boolean unknownConnectionAppeared = false;
        int curDC = 0;
        int dcSize = polledCalls.size();
        for (i = 0; i < this.mConnections.length; ++i) {
            GsmConnection conn = this.mConnections[i];
            DriverCall dc = null;
            if (curDC < dcSize) {
                dc = (DriverCall)polledCalls.get(curDC);
                if (dc.index == i + 1) {
                    ++curDC;
                } else {
                    dc = null;
                }
            }
            if (conn == null && dc != null) {
                if (this.mPendingMO != null && this.mPendingMO.compareTo(dc)) {
                    this.mConnections[i] = this.mPendingMO;
                    this.mPendingMO.mIndex = i;
                    this.mPendingMO.update(dc);
                    this.mPendingMO = null;
                    if (this.mHangupPendingMO) {
                        this.mHangupPendingMO = false;
                        try {
                            this.log("poll: hangupPendingMO, hangup conn " + i);
                            this.hangup(this.mConnections[i]);
                        }
                        catch (CallStateException ex) {
                            Rlog.e("GsmCallTracker", "unexpected error on hangup");
                        }
                        return;
                    }
                } else {
                    this.mConnections[i] = new GsmConnection(this.mPhone.getContext(), dc, this, i);
                    if (this.mConnections[i].getCall() == this.mRingingCall) {
                        newRinging = this.mConnections[i];
                    } else if (this.mHandoverConnection != null) {
                        this.mPhone.migrateFrom((PhoneBase)this.mPhone.getImsPhone());
                        this.mConnections[i].migrateFrom(this.mHandoverConnection);
                        this.mPhone.notifyHandoverStateChanged(this.mConnections[i]);
                        this.mHandoverConnection = null;
                    } else {
                        Rlog.i("GsmCallTracker", "Phantom call appeared " + dc);
                        if (dc.state != DriverCall.State.ALERTING && dc.state != DriverCall.State.DIALING) {
                            this.mConnections[i].onConnectedInOrOut();
                            if (dc.state == DriverCall.State.HOLDING) {
                                this.mConnections[i].onStartedHolding();
                            }
                        }
                        newUnknown = this.mConnections[i];
                        unknownConnectionAppeared = true;
                    }
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn != null && dc == null) {
                this.mDroppedDuringPoll.add(conn);
                this.mConnections[i] = null;
                continue;
            }
            if (conn != null && dc != null && !conn.compareTo(dc)) {
                this.mDroppedDuringPoll.add(conn);
                this.mConnections[i] = new GsmConnection(this.mPhone.getContext(), dc, this, i);
                if (this.mConnections[i].getCall() == this.mRingingCall) {
                    newRinging = this.mConnections[i];
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn == null || dc == null) continue;
            boolean changed = conn.update(dc);
            hasNonHangupStateChanged = hasNonHangupStateChanged || changed;
        }
        if (this.mPendingMO != null) {
            Rlog.d("GsmCallTracker", "Pending MO dropped before poll fg state:" + (Object)((Object)this.mForegroundCall.getState()));
            this.mDroppedDuringPoll.add(this.mPendingMO);
            this.mPendingMO = null;
            this.mHangupPendingMO = false;
        }
        if (newRinging != null) {
            this.mPhone.notifyNewRingingConnection(newRinging);
        }
        for (i = this.mDroppedDuringPoll.size() - 1; i >= 0; --i) {
            GsmConnection conn = this.mDroppedDuringPoll.get(i);
            if (conn.isIncoming() && conn.getConnectTime() == 0L) {
                int cause = conn.mCause == 3 ? 16 : 1;
                this.log("missed/rejected call, conn.cause=" + conn.mCause);
                this.log("setting cause to " + cause);
                this.mDroppedDuringPoll.remove(i);
                hasAnyCallDisconnected |= conn.onDisconnect(cause);
                continue;
            }
            if (conn.mCause != 3 && conn.mCause != 7) continue;
            this.mDroppedDuringPoll.remove(i);
            hasAnyCallDisconnected |= conn.onDisconnect(conn.mCause);
        }
        if (this.mDroppedDuringPoll.size() > 0) {
            this.mCi.getLastCallFailCause(this.obtainNoPollCompleteMessage(5));
        }
        if (needsPollDelay) {
            this.pollCallsAfterDelay();
        }
        if (newRinging != null || hasNonHangupStateChanged || hasAnyCallDisconnected) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (unknownConnectionAppeared) {
            this.mPhone.notifyUnknownConnection(newUnknown);
        }
        if (hasNonHangupStateChanged || newRinging != null || hasAnyCallDisconnected) {
            this.mPhone.notifyPreciseCallStateChanged();
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dumpState() {
        int i;
        Rlog.i("GsmCallTracker", "Phone State:" + (Object)((Object)this.mState));
        Rlog.i("GsmCallTracker", "Ringing call: " + this.mRingingCall.toString());
        List<Connection> l = this.mRingingCall.getConnections();
        int s = l.size();
        for (i = 0; i < s; ++i) {
            Rlog.i("GsmCallTracker", ((Object)l.get(i)).toString());
        }
        Rlog.i("GsmCallTracker", "Foreground call: " + this.mForegroundCall.toString());
        l = this.mForegroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            Rlog.i("GsmCallTracker", ((Object)l.get(i)).toString());
        }
        Rlog.i("GsmCallTracker", "Background call: " + this.mBackgroundCall.toString());
        l = this.mBackgroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            Rlog.i("GsmCallTracker", ((Object)l.get(i)).toString());
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangup(GsmConnection conn) throws CallStateException {
        if (conn.mOwner != this) {
            throw new CallStateException("GsmConnection " + conn + "does not belong to GsmCallTracker " + this);
        }
        if (conn == this.mPendingMO) {
            this.log("hangup: set hangupPendingMO to true");
            this.mHangupPendingMO = true;
        } else {
            try {
                this.mCi.hangupConnection(conn.getGSMIndex(), this.obtainCompleteMessage());
            }
            catch (CallStateException ex) {
                Rlog.w("GsmCallTracker", "GsmCallTracker WARN: hangup() on absent connection " + conn);
            }
        }
        conn.onHangupLocal();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$separate(GsmConnection conn) throws CallStateException {
        if (conn.mOwner != this) {
            throw new CallStateException("GsmConnection " + conn + "does not belong to GsmCallTracker " + this);
        }
        try {
            this.mCi.separateConnection(conn.getGSMIndex(), this.obtainCompleteMessage(12));
        }
        catch (CallStateException ex) {
            Rlog.w("GsmCallTracker", "GsmCallTracker WARN: separate() on absent connection " + conn);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mCi.setMute(this.mDesiredMute, null);
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$getMute() {
        return this.mDesiredMute;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangup(GsmCall call) throws CallStateException {
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup waiting or background");
            this.mCi.hangupWaitingOrBackground(this.obtainCompleteMessage());
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
                this.hangup((GsmConnection)call.getConnections().get(0));
            } else if (this.mRingingCall.isRinging()) {
                this.log("hangup all conns in active/background call, without affecting ringing call");
                this.hangupAllConnections(call);
            } else {
                this.hangupForegroundResumeBackground();
            }
        } else if (call == this.mBackgroundCall) {
            if (this.mRingingCall.isRinging()) {
                this.log("hangup all conns in background call");
                this.hangupAllConnections(call);
            } else {
                this.hangupWaitingOrBackground();
            }
        } else {
            throw new RuntimeException("GsmCall " + call + "does not belong to GsmCallTracker " + this);
        }
        call.onHangupLocal();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        this.mCi.hangupWaitingOrBackground(this.obtainCompleteMessage());
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        this.mCi.hangupForegroundResumeBackground(this.obtainCompleteMessage());
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangupConnectionByIndex(GsmCall call, int index) throws CallStateException {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            GsmConnection cn = (GsmConnection)call.mConnections.get(i);
            if (cn.getGSMIndex() != index) continue;
            this.mCi.hangupConnection(index, this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("no gsm index found");
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangupAllConnections(GsmCall call) {
        try {
            int count = call.mConnections.size();
            for (int i = 0; i < count; ++i) {
                GsmConnection cn = (GsmConnection)call.mConnections.get(i);
                this.mCi.hangupConnection(cn.getGSMIndex(), this.obtainCompleteMessage());
            }
        }
        catch (CallStateException ex) {
            Rlog.e("GsmCallTracker", "hangupConnectionByIndex caught " + ex);
        }
    }

    private final GsmConnection $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$getConnectionByIndex(GsmCall call, int index) throws CallStateException {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            GsmConnection cn = (GsmConnection)call.mConnections.get(i);
            if (cn.getGSMIndex() != index) continue;
            return cn;
        }
        return null;
    }

    private final Phone.SuppService $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$getFailedService(int what) {
        switch (what) {
            case 8: {
                return Phone.SuppService.SWITCH;
            }
            case 11: {
                return Phone.SuppService.CONFERENCE;
            }
            case 12: {
                return Phone.SuppService.SEPARATE;
            }
            case 13: {
                return Phone.SuppService.TRANSFER;
            }
        }
        return Phone.SuppService.UNKNOWN;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$handleMessage(Message msg) {
        if (!this.mPhone.mIsTheCurrentActivePhone) {
            Rlog.e("GsmCallTracker", "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (msg != this.mLastRelevantPoll) break;
                this.mNeedsPoll = false;
                this.mLastRelevantPoll = null;
                this.handlePollCalls((AsyncResult)msg.obj);
                break;
            }
            case 4: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.operationComplete();
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    this.mPhone.notifySuppServiceFailed(this.getFailedService(msg.what));
                }
                this.operationComplete();
                break;
            }
            case 5: {
                int causeCode;
                AsyncResult ar = (AsyncResult)msg.obj;
                this.operationComplete();
                if (ar.exception != null) {
                    causeCode = 16;
                    Rlog.i("GsmCallTracker", "Exception during getLastCallFailCause, assuming normal disconnect");
                } else {
                    causeCode = ((int[])ar.result)[0];
                }
                if (causeCode == 34 || causeCode == 41 || causeCode == 42 || causeCode == 44 || causeCode == 49 || causeCode == 58 || causeCode == 65535) {
                    GsmCellLocation loc = (GsmCellLocation)this.mPhone.getCellLocation();
                    EventLog.writeEvent(50106, causeCode, loc != null ? loc.getCid() : -1, TelephonyManager.getDefault().getNetworkType());
                }
                int s = this.mDroppedDuringPoll.size();
                for (int i = 0; i < s; ++i) {
                    GsmConnection conn = this.mDroppedDuringPoll.get(i);
                    conn.onRemoteDisconnect(causeCode);
                }
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                this.mDroppedDuringPoll.clear();
                break;
            }
            case 2: 
            case 3: {
                this.pollCallsWhenSafe();
                break;
            }
            case 9: {
                this.handleRadioAvailable();
                break;
            }
            case 10: {
                this.handleRadioNotAvailable();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$log(String msg) {
        Rlog.d("GsmCallTracker", "[GsmCallTracker] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("GsmCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println("mConnections: length=" + this.mConnections.length);
        for (i = 0; i < this.mConnections.length; ++i) {
            pw.printf("  mConnections[%d]=%s\n", i, this.mConnections[i]);
        }
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        pw.println(" mDroppedDuringPoll: size=" + this.mDroppedDuringPoll.size());
        for (i = 0; i < this.mDroppedDuringPoll.size(); ++i) {
            pw.printf("  mDroppedDuringPoll[%d]=%s\n", i, this.mDroppedDuringPoll.get(i));
        }
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mHangupPendingMO=" + this.mHangupPendingMO);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mState=" + (Object)((Object)this.mState));
    }

    private void __constructor__(GSMPhone gSMPhone) {
        this.$$robo$$com_android_internal_telephony_gsm_GsmCallTracker$__constructor__(gSMPhone);
    }

    GsmCallTracker(GSMPhone gSMPhone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$__constructor__(com.android.internal.telephony.gsm.GSMPhone ), 0, this, gSMPhone);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dispose(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$finalize(), 0, this);
    }

    @Override
    public void registerForVoiceCallStarted(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallStarted", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$registerForVoiceCallStarted(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallStarted", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$unregisterForVoiceCallStarted(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForVoiceCallEnded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallEnded", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$registerForVoiceCallEnded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallEnded", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$unregisterForVoiceCallEnded(android.os.Handler ), 0, this, handler);
    }

    private void fakeHoldForegroundBeforeDial() {
        InvokeDynamicSupport.bootstrap("fakeHoldForegroundBeforeDial", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$fakeHoldForegroundBeforeDial(), 0, this);
    }

    synchronized Connection dial(String string2, int n, UUSInfo uUSInfo) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dial(java.lang.String int com.android.internal.telephony.UUSInfo ), 0, this, string2, n, uUSInfo);
    }

    Connection dial(String string2) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dial(java.lang.String ), 0, this, string2);
    }

    Connection dial(String string2, UUSInfo uUSInfo) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dial(java.lang.String com.android.internal.telephony.UUSInfo ), 0, this, string2, uUSInfo);
    }

    Connection dial(String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dial(java.lang.String int ), 0, this, string2, n);
    }

    void acceptCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$acceptCall(), 0, this);
    }

    void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$rejectCall(), 0, this);
    }

    void switchWaitingOrHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchWaitingOrHoldingAndActive", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$switchWaitingOrHoldingAndActive(), 0, this);
    }

    void conference() {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$conference(), 0, this);
    }

    void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$explicitCallTransfer(), 0, this);
    }

    void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$clearDisconnected(), 0, this);
    }

    boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$canConference(), 0, this);
    }

    boolean canDial() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDial", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$canDial(), 0, this);
    }

    boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$canTransfer(), 0, this);
    }

    private void internalClearDisconnected() {
        InvokeDynamicSupport.bootstrap("internalClearDisconnected", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$internalClearDisconnected(), 0, this);
    }

    private Message obtainCompleteMessage() {
        return InvokeDynamicSupport.bootstrap("obtainCompleteMessage", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$obtainCompleteMessage(), 0, this);
    }

    private Message obtainCompleteMessage(int n) {
        return InvokeDynamicSupport.bootstrap("obtainCompleteMessage", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$obtainCompleteMessage(int ), 0, this, n);
    }

    private void operationComplete() {
        InvokeDynamicSupport.bootstrap("operationComplete", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$operationComplete(), 0, this);
    }

    private void updatePhoneState() {
        InvokeDynamicSupport.bootstrap("updatePhoneState", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$updatePhoneState(), 0, this);
    }

    @Override
    protected synchronized void handlePollCalls(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handlePollCalls", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$handlePollCalls(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private void handleRadioNotAvailable() {
        InvokeDynamicSupport.bootstrap("handleRadioNotAvailable", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$handleRadioNotAvailable(), 0, this);
    }

    private void dumpState() {
        InvokeDynamicSupport.bootstrap("dumpState", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dumpState(), 0, this);
    }

    void hangup(GsmConnection gsmConnection) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangup(com.android.internal.telephony.gsm.GsmConnection ), 0, this, gsmConnection);
    }

    void separate(GsmConnection gsmConnection) throws CallStateException {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$separate(com.android.internal.telephony.gsm.GsmConnection ), 0, this, gsmConnection);
    }

    void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$setMute(boolean ), 0, this, bl);
    }

    boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$getMute(), 0, this);
    }

    void hangup(GsmCall gsmCall) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangup(com.android.internal.telephony.gsm.GsmCall ), 0, this, gsmCall);
    }

    void hangupWaitingOrBackground() {
        InvokeDynamicSupport.bootstrap("hangupWaitingOrBackground", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangupWaitingOrBackground(), 0, this);
    }

    void hangupForegroundResumeBackground() {
        InvokeDynamicSupport.bootstrap("hangupForegroundResumeBackground", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangupForegroundResumeBackground(), 0, this);
    }

    void hangupConnectionByIndex(GsmCall gsmCall, int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangupConnectionByIndex", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangupConnectionByIndex(com.android.internal.telephony.gsm.GsmCall int ), 0, this, gsmCall, n);
    }

    void hangupAllConnections(GsmCall gsmCall) {
        InvokeDynamicSupport.bootstrap("hangupAllConnections", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$hangupAllConnections(com.android.internal.telephony.gsm.GsmCall ), 0, this, gsmCall);
    }

    GsmConnection getConnectionByIndex(GsmCall gsmCall, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("getConnectionByIndex", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$getConnectionByIndex(com.android.internal.telephony.gsm.GsmCall int ), 0, this, gsmCall, n);
    }

    private Phone.SuppService getFailedService(int n) {
        return InvokeDynamicSupport.bootstrap("getFailedService", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$getFailedService(int ), 0, this, n);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$handleMessage(android.os.Message ), 0, this, message);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$log(java.lang.String ), 0, this, string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_gsm_GsmCallTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ GsmCallTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmCallTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

