/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.CellLocation;
import android.telephony.SmsCbLocation;
import android.telephony.SmsCbMessage;
import android.telephony.gsm.GsmCellLocation;
import com.android.internal.telephony.CellBroadcastHandler;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.GsmSmsCbMessage;
import com.android.internal.telephony.gsm.SmsCbHeader;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.Iterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GsmCellBroadcastHandler
extends CellBroadcastHandler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean VDBG = false;
    private HashMap<SmsCbConcatInfo, byte[][]> mSmsCbPageMap;

    private void $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$__constructor__(Context context, PhoneBase phone) {
        this.mSmsCbPageMap = new HashMap(4);
        phone.mCi.setOnNewGsmBroadcastSms(this.getHandler(), 1, null);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$onQuitting() {
        this.mPhone.mCi.unSetOnNewGsmBroadcastSms(this.getHandler());
        super.onQuitting();
    }

    private static final GsmCellBroadcastHandler $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$makeGsmCellBroadcastHandler(Context context, PhoneBase phone) {
        GsmCellBroadcastHandler handler = new GsmCellBroadcastHandler(context, phone);
        handler.start();
        return handler;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$handleSmsMessage(Message message) {
        SmsCbMessage cbMessage;
        if (message.obj instanceof AsyncResult && (cbMessage = this.handleGsmBroadcastSms((AsyncResult)message.obj)) != null) {
            this.handleBroadcastSms(cbMessage);
            return true;
        }
        return super.handleSmsMessage(message);
    }

    private final SmsCbMessage $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$handleGsmBroadcastSms(AsyncResult ar) {
        try {
            Object pdus;
            SmsCbLocation location;
            byte[] receivedPdu = (byte[])ar.result;
            SmsCbHeader header = new SmsCbHeader(receivedPdu);
            String plmn = SystemProperties.get("gsm.operator.numeric");
            int lac = -1;
            int cid = -1;
            CellLocation cl = this.mPhone.getCellLocation();
            if (cl instanceof GsmCellLocation) {
                GsmCellLocation cellLocation = (GsmCellLocation)cl;
                lac = cellLocation.getLac();
                cid = cellLocation.getCid();
            }
            switch (header.getGeographicalScope()) {
                case 2: {
                    location = new SmsCbLocation(plmn, lac, -1);
                    break;
                }
                case 0: 
                case 3: {
                    location = new SmsCbLocation(plmn, lac, cid);
                    break;
                }
                default: {
                    location = new SmsCbLocation(plmn);
                }
            }
            int pageCount = header.getNumberOfPages();
            if (pageCount > 1) {
                SmsCbConcatInfo concatInfo = new SmsCbConcatInfo(header, location);
                pdus = this.mSmsCbPageMap.get(concatInfo);
                if (pdus == null) {
                    pdus = new byte[pageCount][];
                    this.mSmsCbPageMap.put(concatInfo, (byte[][])pdus);
                }
                pdus[header.getPageIndex() - 1] = receivedPdu;
                for (byte[] pdu : pdus) {
                    if (pdu != null) continue;
                    return null;
                }
                this.mSmsCbPageMap.remove(concatInfo);
            } else {
                pdus = new byte[][]{receivedPdu};
            }
            Iterator<SmsCbConcatInfo> iter = this.mSmsCbPageMap.keySet().iterator();
            while (iter.hasNext()) {
                SmsCbConcatInfo smsCbConcatInfo = iter.next();
                if (smsCbConcatInfo.matchesLocation(plmn, lac, cid)) continue;
                iter.remove();
            }
            return GsmSmsCbMessage.createSmsCbMessage(header, location, pdus);
        }
        catch (RuntimeException e) {
            this.loge("Error in decoding SMS CB pdu", e);
            return null;
        }
    }

    private void __constructor__(Context context, PhoneBase phoneBase) {
        this.$$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$__constructor__(context, phoneBase);
    }

    protected GsmCellBroadcastHandler(Context context, PhoneBase phoneBase) {
        super("GsmCellBroadcastHandler", context, phoneBase);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$__constructor__(android.content.Context com.android.internal.telephony.PhoneBase ), 0, this, context, phoneBase);
    }

    @Override
    protected void onQuitting() {
        InvokeDynamicSupport.bootstrap("onQuitting", $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$onQuitting(), 0, this);
    }

    public static GsmCellBroadcastHandler makeGsmCellBroadcastHandler(Context context, PhoneBase phoneBase) {
        return InvokeDynamicSupport.bootstrapStatic("makeGsmCellBroadcastHandler", $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$makeGsmCellBroadcastHandler(android.content.Context com.android.internal.telephony.PhoneBase ), 0, (Context)context, (PhoneBase)phoneBase);
    }

    @Override
    protected boolean handleSmsMessage(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleSmsMessage", $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$handleSmsMessage(android.os.Message ), 0, this, message);
    }

    private SmsCbMessage handleGsmBroadcastSms(AsyncResult asyncResult) {
        return InvokeDynamicSupport.bootstrap("handleGsmBroadcastSms", $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler$handleGsmBroadcastSms(android.os.AsyncResult ), 0, this, asyncResult);
    }

    public /* synthetic */ GsmCellBroadcastHandler() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmCellBroadcastHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SmsCbConcatInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SmsCbHeader mHeader;
        private SmsCbLocation mLocation;

        private void $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler_SmsCbConcatInfo$__constructor__(SmsCbHeader header, SmsCbLocation location) {
            this.mHeader = header;
            this.mLocation = location;
        }

        private final int $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler_SmsCbConcatInfo$hashCode() {
            return this.mHeader.getSerialNumber() * 31 + this.mLocation.hashCode();
        }

        private final boolean $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler_SmsCbConcatInfo$equals(Object obj) {
            if (obj instanceof SmsCbConcatInfo) {
                SmsCbConcatInfo other = (SmsCbConcatInfo)obj;
                return this.mHeader.getSerialNumber() == other.mHeader.getSerialNumber() && this.mLocation.equals(other.mLocation);
            }
            return false;
        }

        private final boolean $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler_SmsCbConcatInfo$matchesLocation(String plmn, int lac, int cid) {
            return this.mLocation.isInLocationArea(plmn, lac, cid);
        }

        private void __constructor__(SmsCbHeader smsCbHeader, SmsCbLocation smsCbLocation) {
            this.$$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler_SmsCbConcatInfo$__constructor__(smsCbHeader, smsCbLocation);
        }

        SmsCbConcatInfo(SmsCbHeader smsCbHeader, SmsCbLocation smsCbLocation) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler_SmsCbConcatInfo$__constructor__(com.android.internal.telephony.gsm.SmsCbHeader android.telephony.SmsCbLocation ), 0, this, smsCbHeader, smsCbLocation);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler_SmsCbConcatInfo$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler_SmsCbConcatInfo$equals(java.lang.Object ), 0, this, object);
        }

        public boolean matchesLocation(String string2, int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("matchesLocation", $$robo$$com_android_internal_telephony_gsm_GsmCellBroadcastHandler_SmsCbConcatInfo$matchesLocation(java.lang.String int int ), 0, this, string2, n, n2);
        }

        public /* synthetic */ SmsCbConcatInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsCbConcatInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

