/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmCallTracker;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.UiccCardApplication;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GsmConnection
extends Connection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "GsmConnection";
    private static boolean DBG = true;
    GsmCallTracker mOwner;
    GsmCall mParent;
    String mPostDialString;
    boolean mDisconnected;
    int mIndex;
    long mDisconnectTime;
    int mNextPostDialChar;
    int mCause;
    Connection.PostDialState mPostDialState;
    UUSInfo mUusInfo;
    int mPreciseCause;
    Connection mOrigConnection;
    Handler mHandler;
    private PowerManager.WakeLock mPartialWakeLock;
    static int EVENT_DTMF_DONE = 1;
    static int EVENT_PAUSE_DONE = 2;
    static int EVENT_NEXT_POST_DIAL = 3;
    static int EVENT_WAKE_LOCK_TIMEOUT = 4;
    static int PAUSE_DELAY_MILLIS = 3000;
    static int WAKE_LOCK_TIMEOUT_MILLIS = 60000;

    private void $$robo$$com_android_internal_telephony_gsm_GsmConnection$__constructor__(Context context, DriverCall dc, GsmCallTracker ct, int index) {
        this.mCause = 0;
        this.mPostDialState = Connection.PostDialState.NOT_STARTED;
        this.mPreciseCause = 0;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mAddress = dc.number;
        this.mIsIncoming = dc.isMT;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mCnapName = dc.name;
        this.mCnapNamePresentation = dc.namePresentation;
        this.mNumberPresentation = dc.numberPresentation;
        this.mUusInfo = dc.uusInfo;
        this.mIndex = index;
        this.mParent = this.parentFromDCState(dc.state);
        this.mParent.attach(this, dc);
    }

    private void $$robo$$com_android_internal_telephony_gsm_GsmConnection$__constructor__(Context context, String dialString, GsmCallTracker ct, GsmCall parent) {
        this.mCause = 0;
        this.mPostDialState = Connection.PostDialState.NOT_STARTED;
        this.mPreciseCause = 0;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mDialString = dialString;
        this.mAddress = PhoneNumberUtils.extractNetworkPortionAlt(dialString);
        this.mPostDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.mIndex = -1;
        this.mIsIncoming = false;
        this.mCnapName = null;
        this.mCnapNamePresentation = 1;
        this.mNumberPresentation = 1;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mParent = parent;
        parent.attachFake(this, Call.State.DIALING);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$dispose() {
    }

    private static final boolean $$robo$$com_android_internal_telephony_gsm_GsmConnection$equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmConnection$compareTo(DriverCall c) {
        if (!this.mIsIncoming && !c.isMT) {
            return true;
        }
        if (this.mOrigConnection != null) {
            return true;
        }
        String cAddress = PhoneNumberUtils.stringFromStringAndTOA(c.number, c.TOA);
        return this.mIsIncoming == c.isMT && GsmConnection.equalsHandlesNulls(this.mAddress, cAddress);
    }

    private final GsmCall $$robo$$com_android_internal_telephony_gsm_GsmConnection$getCall() {
        return this.mParent;
    }

    private final long $$robo$$com_android_internal_telephony_gsm_GsmConnection$getDisconnectTime() {
        return this.mDisconnectTime;
    }

    private final long $$robo$$com_android_internal_telephony_gsm_GsmConnection$getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.mHoldingStartTime;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_GsmConnection$getDisconnectCause() {
        return this.mCause;
    }

    private final Call.State $$robo$$com_android_internal_telephony_gsm_GsmConnection$getState() {
        if (this.mDisconnected) {
            return Call.State.DISCONNECTED;
        }
        return super.getState();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$hangup() throws CallStateException {
        if (this.mDisconnected) {
            throw new CallStateException("disconnected");
        }
        this.mOwner.hangup(this);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$separate() throws CallStateException {
        if (this.mDisconnected) {
            throw new CallStateException("disconnected");
        }
        this.mOwner.separate(this);
    }

    private final Connection.PostDialState $$robo$$com_android_internal_telephony_gsm_GsmConnection$getPostDialState() {
        return this.mPostDialState;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$proceedAfterWaitChar() {
        if (this.mPostDialState != Connection.PostDialState.WAIT) {
            Rlog.w("GsmConnection", "GsmConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        this.processNextPostDialChar();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$proceedAfterWildChar(String str) {
        if (this.mPostDialState != Connection.PostDialState.WILD) {
            Rlog.w("GsmConnection", "GsmConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        StringBuilder buf = new StringBuilder(str);
        buf.append(this.mPostDialString.substring(this.mNextPostDialChar));
        this.mPostDialString = buf.toString();
        this.mNextPostDialChar = 0;
        this.log("proceedAfterWildChar: new postDialString is " + this.mPostDialString);
        this.processNextPostDialChar();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$cancelPostDial() {
        this.setPostDialState(Connection.PostDialState.CANCELLED);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$onHangupLocal() {
        this.mCause = 3;
        this.mPreciseCause = 0;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_GsmConnection$disconnectCauseFromCode(int causeCode) {
        IccCardApplicationStatus.AppState uiccAppState;
        switch (causeCode) {
            case 17: {
                return 4;
            }
            case 34: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 58: {
                return 5;
            }
            case 68: {
                return 15;
            }
            case 240: {
                return 20;
            }
            case 241: {
                return 21;
            }
            case 1: {
                return 25;
            }
        }
        GSMPhone phone = this.mOwner.mPhone;
        int serviceState = phone.getServiceState().getState();
        UiccCardApplication cardApp = phone.getUiccCardApplication();
        IccCardApplicationStatus.AppState appState = uiccAppState = cardApp != null ? cardApp.getState() : IccCardApplicationStatus.AppState.APPSTATE_UNKNOWN;
        if (serviceState == 3) {
            return 17;
        }
        if (serviceState == 1 || serviceState == 2) {
            return 18;
        }
        if (uiccAppState != IccCardApplicationStatus.AppState.APPSTATE_READY) {
            return 19;
        }
        if (causeCode == 65535) {
            if (phone.mSST.mRestrictedState.isCsRestricted()) {
                return 22;
            }
            if (phone.mSST.mRestrictedState.isCsEmergencyRestricted()) {
                return 24;
            }
            if (phone.mSST.mRestrictedState.isCsNormalRestricted()) {
                return 23;
            }
            return 36;
        }
        if (causeCode == 16) {
            return 2;
        }
        return 36;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$onRemoteDisconnect(int causeCode) {
        this.mPreciseCause = causeCode;
        this.onDisconnect(this.disconnectCauseFromCode(causeCode));
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmConnection$onDisconnect(int cause) {
        boolean changed = false;
        this.mCause = cause;
        if (!this.mDisconnected) {
            this.mIndex = -1;
            this.mDisconnectTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.mDuration = SystemClock.elapsedRealtime() - this.mConnectTimeReal;
            this.mDisconnected = true;
            Rlog.d("GsmConnection", "onDisconnect: cause=" + cause);
            this.mOwner.mPhone.notifyDisconnect(this);
            if (this.mParent != null) {
                changed = this.mParent.connectionDisconnected(this);
            }
            this.mOrigConnection = null;
        }
        this.clearPostDialListeners();
        this.releaseWakeLock();
        return changed;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmConnection$update(DriverCall dc) {
        boolean changed = false;
        boolean wasConnectingInOrOut = this.isConnectingInOrOut();
        boolean wasHolding = this.getState() == Call.State.HOLDING;
        GsmCall newParent = this.parentFromDCState(dc.state);
        if (this.mOrigConnection != null) {
            this.log("update: mOrigConnection is not null");
        } else {
            this.log(" mNumberConverted " + this.mNumberConverted);
            if (!(GsmConnection.equalsHandlesNulls(this.mAddress, dc.number) || this.mNumberConverted && GsmConnection.equalsHandlesNulls(this.mConvertedNumber, dc.number))) {
                this.log("update: phone # changed!");
                this.mAddress = dc.number;
                changed = true;
            }
        }
        if (TextUtils.isEmpty(dc.name)) {
            if (!TextUtils.isEmpty(this.mCnapName)) {
                changed = true;
                this.mCnapName = "";
            }
        } else if (!dc.name.equals(this.mCnapName)) {
            changed = true;
            this.mCnapName = dc.name;
        }
        this.log("--dssds----" + this.mCnapName);
        this.mCnapNamePresentation = dc.namePresentation;
        this.mNumberPresentation = dc.numberPresentation;
        if (newParent != this.mParent) {
            if (this.mParent != null) {
                this.mParent.detach(this);
            }
            newParent.attach(this, dc);
            this.mParent = newParent;
            changed = true;
        } else {
            boolean parentStateChange = this.mParent.update(this, dc);
            changed = changed || parentStateChange;
        }
        this.log("update: parent=" + this.mParent + ", hasNewParent=" + (newParent != this.mParent) + ", wasConnectingInOrOut=" + wasConnectingInOrOut + ", wasHolding=" + wasHolding + ", isConnectingInOrOut=" + this.isConnectingInOrOut() + ", changed=" + changed);
        if (wasConnectingInOrOut && !this.isConnectingInOrOut()) {
            this.onConnectedInOrOut();
        }
        if (changed && !wasHolding && this.getState() == Call.State.HOLDING) {
            this.onStartedHolding();
        }
        return changed;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$fakeHoldBeforeDial() {
        if (this.mParent != null) {
            this.mParent.detach(this);
        }
        this.mParent = this.mOwner.mBackgroundCall;
        this.mParent.attachFake(this, Call.State.HOLDING);
        this.onStartedHolding();
    }

    private final int $$robo$$com_android_internal_telephony_gsm_GsmConnection$getGSMIndex() throws CallStateException {
        if (this.mIndex >= 0) {
            return this.mIndex + 1;
        }
        throw new CallStateException("GSM index not yet assigned");
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$onConnectedInOrOut() {
        this.mConnectTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mConnectTimeReal = SystemClock.elapsedRealtime();
        this.mDuration = 0L;
        this.log("onConnectedInOrOut: connectTime=" + this.mConnectTime);
        if (!this.mIsIncoming) {
            this.processNextPostDialChar();
        }
        this.releaseWakeLock();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$onStartedHolding() {
        this.mHoldingStartTime = SystemClock.elapsedRealtime();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmConnection$processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            this.mOwner.mCi.sendDtmf(c, this.mHandler.obtainMessage(1));
        } else if (c == ',') {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 3000L);
        } else if (c == ';') {
            this.setPostDialState(Connection.PostDialState.WAIT);
        } else if (c == 'N') {
            this.setPostDialState(Connection.PostDialState.WILD);
        } else {
            return false;
        }
        return true;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GsmConnection$getRemainingPostDialString() {
        if (this.mPostDialState == Connection.PostDialState.CANCELLED || this.mPostDialState == Connection.PostDialState.COMPLETE || this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            return "";
        }
        return this.mPostDialString.substring(this.mNextPostDialChar);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$finalize() {
        if (this.mPartialWakeLock.isHeld()) {
            Rlog.e("GsmConnection", "[GSMConn] UNEXPECTED; mPartialWakeLock is held when finalizing.");
        }
        this.clearPostDialListeners();
        this.releaseWakeLock();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$processNextPostDialChar() {
        Message notifyMessage;
        char c = '\u0000';
        if (this.mPostDialState == Connection.PostDialState.CANCELLED) {
            return;
        }
        if (this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            this.setPostDialState(Connection.PostDialState.COMPLETE);
            c = '\u0000';
        } else {
            this.setPostDialState(Connection.PostDialState.STARTED);
            c = this.mPostDialString.charAt(this.mNextPostDialChar++);
            boolean isValid = this.processPostDialChar(c);
            if (!isValid) {
                this.mHandler.obtainMessage(3).sendToTarget();
                Rlog.e("GSM", "processNextPostDialChar: c=" + c + " isn't valid!");
                return;
            }
        }
        Registrant postDialHandler = this.mOwner.mPhone.mPostDialHandler;
        if (postDialHandler != null && (notifyMessage = postDialHandler.messageForRegistrant()) != null) {
            Connection.PostDialState state = this.mPostDialState;
            AsyncResult ar = AsyncResult.forMessage(notifyMessage);
            ar.result = this;
            ar.userObj = state;
            notifyMessage.arg1 = c;
            notifyMessage.sendToTarget();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmConnection$isConnectingInOrOut() {
        return this.mParent == null || this.mParent == this.mOwner.mRingingCall || this.mParent.mState == Call.State.DIALING || this.mParent.mState == Call.State.ALERTING;
    }

    private final GsmCall $$robo$$com_android_internal_telephony_gsm_GsmConnection$parentFromDCState(DriverCall.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$DriverCall$State[state.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return this.mOwner.mForegroundCall;
            }
            case 4: {
                return this.mOwner.mBackgroundCall;
            }
            case 5: 
            case 6: {
                return this.mOwner.mRingingCall;
            }
        }
        throw new RuntimeException("illegal call state: " + (Object)((Object)state));
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$setPostDialState(Connection.PostDialState s) {
        if (this.mPostDialState != Connection.PostDialState.STARTED && s == Connection.PostDialState.STARTED) {
            this.acquireWakeLock();
            Message msg = this.mHandler.obtainMessage(4);
            this.mHandler.sendMessageDelayed(msg, 60000L);
        } else if (this.mPostDialState == Connection.PostDialState.STARTED && s != Connection.PostDialState.STARTED) {
            this.mHandler.removeMessages(4);
            this.releaseWakeLock();
        }
        this.mPostDialState = s;
        this.notifyPostDialListeners();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$createWakeLock(Context context) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mPartialWakeLock = pm.newWakeLock(1, "GsmConnection");
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$acquireWakeLock() {
        this.log("acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$releaseWakeLock() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            if (this.mPartialWakeLock.isHeld()) {
                this.log("releaseWakeLock");
                this.mPartialWakeLock.release();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$log(String msg) {
        Rlog.d("GsmConnection", "[GSMConn] " + msg);
    }

    private final int $$robo$$com_android_internal_telephony_gsm_GsmConnection$getNumberPresentation() {
        return this.mNumberPresentation;
    }

    private final UUSInfo $$robo$$com_android_internal_telephony_gsm_GsmConnection$getUUSInfo() {
        return this.mUusInfo;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_GsmConnection$getPreciseDisconnectCause() {
        return this.mPreciseCause;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection$migrateFrom(Connection c) {
        if (c == null) {
            return;
        }
        super.migrateFrom(c);
        this.mUusInfo = c.getUUSInfo();
        this.setUserData(c.getUserData());
    }

    private final Connection $$robo$$com_android_internal_telephony_gsm_GsmConnection$getOrigConnection() {
        return this.mOrigConnection;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmConnection$isMultiparty() {
        if (this.mOrigConnection != null) {
            return this.mOrigConnection.isMultiparty();
        }
        return false;
    }

    private void __constructor__(Context context, DriverCall driverCall, GsmCallTracker gsmCallTracker, int n) {
        this.$$robo$$com_android_internal_telephony_gsm_GsmConnection$__constructor__(context, driverCall, gsmCallTracker, n);
    }

    GsmConnection(Context context, DriverCall driverCall, GsmCallTracker gsmCallTracker, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmConnection$__constructor__(android.content.Context com.android.internal.telephony.DriverCall com.android.internal.telephony.gsm.GsmCallTracker int ), 0, this, context, driverCall, gsmCallTracker, n);
    }

    private void __constructor__(Context context, String string2, GsmCallTracker gsmCallTracker, GsmCall gsmCall) {
        this.$$robo$$com_android_internal_telephony_gsm_GsmConnection$__constructor__(context, string2, gsmCallTracker, gsmCall);
    }

    GsmConnection(Context context, String string2, GsmCallTracker gsmCallTracker, GsmCall gsmCall) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmConnection$__constructor__(android.content.Context java.lang.String com.android.internal.telephony.gsm.GsmCallTracker com.android.internal.telephony.gsm.GsmCall ), 0, this, context, string2, gsmCallTracker, gsmCall);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_gsm_GsmConnection$dispose(), 0, this);
    }

    static boolean equalsHandlesNulls(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equalsHandlesNulls", $$robo$$com_android_internal_telephony_gsm_GsmConnection$equalsHandlesNulls(java.lang.Object java.lang.Object ), 0, (Object)object, (Object)object2);
    }

    boolean compareTo(DriverCall driverCall) {
        return (boolean)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$com_android_internal_telephony_gsm_GsmConnection$compareTo(com.android.internal.telephony.DriverCall ), 0, this, driverCall);
    }

    @Override
    public GsmCall getCall() {
        return InvokeDynamicSupport.bootstrap("getCall", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getCall(), 0, this);
    }

    @Override
    public long getDisconnectTime() {
        return (long)InvokeDynamicSupport.bootstrap("getDisconnectTime", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getDisconnectTime(), 0, this);
    }

    @Override
    public long getHoldDurationMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getHoldDurationMillis", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getHoldDurationMillis(), 0, this);
    }

    @Override
    public int getDisconnectCause() {
        return (int)InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getDisconnectCause(), 0, this);
    }

    @Override
    public Call.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getState(), 0, this);
    }

    @Override
    public void hangup() throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_gsm_GsmConnection$hangup(), 0, this);
    }

    @Override
    public void separate() throws CallStateException {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$com_android_internal_telephony_gsm_GsmConnection$separate(), 0, this);
    }

    @Override
    public Connection.PostDialState getPostDialState() {
        return InvokeDynamicSupport.bootstrap("getPostDialState", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getPostDialState(), 0, this);
    }

    @Override
    public void proceedAfterWaitChar() {
        InvokeDynamicSupport.bootstrap("proceedAfterWaitChar", $$robo$$com_android_internal_telephony_gsm_GsmConnection$proceedAfterWaitChar(), 0, this);
    }

    @Override
    public void proceedAfterWildChar(String string2) {
        InvokeDynamicSupport.bootstrap("proceedAfterWildChar", $$robo$$com_android_internal_telephony_gsm_GsmConnection$proceedAfterWildChar(java.lang.String ), 0, this, string2);
    }

    @Override
    public void cancelPostDial() {
        InvokeDynamicSupport.bootstrap("cancelPostDial", $$robo$$com_android_internal_telephony_gsm_GsmConnection$cancelPostDial(), 0, this);
    }

    void onHangupLocal() {
        InvokeDynamicSupport.bootstrap("onHangupLocal", $$robo$$com_android_internal_telephony_gsm_GsmConnection$onHangupLocal(), 0, this);
    }

    int disconnectCauseFromCode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("disconnectCauseFromCode", $$robo$$com_android_internal_telephony_gsm_GsmConnection$disconnectCauseFromCode(int ), 0, this, n);
    }

    void onRemoteDisconnect(int n) {
        InvokeDynamicSupport.bootstrap("onRemoteDisconnect", $$robo$$com_android_internal_telephony_gsm_GsmConnection$onRemoteDisconnect(int ), 0, this, n);
    }

    boolean onDisconnect(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$com_android_internal_telephony_gsm_GsmConnection$onDisconnect(int ), 0, this, n);
    }

    boolean update(DriverCall driverCall) {
        return (boolean)InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_gsm_GsmConnection$update(com.android.internal.telephony.DriverCall ), 0, this, driverCall);
    }

    void fakeHoldBeforeDial() {
        InvokeDynamicSupport.bootstrap("fakeHoldBeforeDial", $$robo$$com_android_internal_telephony_gsm_GsmConnection$fakeHoldBeforeDial(), 0, this);
    }

    int getGSMIndex() throws CallStateException {
        return (int)InvokeDynamicSupport.bootstrap("getGSMIndex", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getGSMIndex(), 0, this);
    }

    void onConnectedInOrOut() {
        InvokeDynamicSupport.bootstrap("onConnectedInOrOut", $$robo$$com_android_internal_telephony_gsm_GsmConnection$onConnectedInOrOut(), 0, this);
    }

    void onStartedHolding() {
        InvokeDynamicSupport.bootstrap("onStartedHolding", $$robo$$com_android_internal_telephony_gsm_GsmConnection$onStartedHolding(), 0, this);
    }

    private boolean processPostDialChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("processPostDialChar", $$robo$$com_android_internal_telephony_gsm_GsmConnection$processPostDialChar(char ), 0, this, c);
    }

    @Override
    public String getRemainingPostDialString() {
        return InvokeDynamicSupport.bootstrap("getRemainingPostDialString", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getRemainingPostDialString(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_gsm_GsmConnection$finalize(), 0, this);
    }

    private void processNextPostDialChar() {
        InvokeDynamicSupport.bootstrap("processNextPostDialChar", $$robo$$com_android_internal_telephony_gsm_GsmConnection$processNextPostDialChar(), 0, this);
    }

    private boolean isConnectingInOrOut() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectingInOrOut", $$robo$$com_android_internal_telephony_gsm_GsmConnection$isConnectingInOrOut(), 0, this);
    }

    private GsmCall parentFromDCState(DriverCall.State state) {
        return InvokeDynamicSupport.bootstrap("parentFromDCState", $$robo$$com_android_internal_telephony_gsm_GsmConnection$parentFromDCState(com.android.internal.telephony.DriverCall$State ), 0, this, state);
    }

    private void setPostDialState(Connection.PostDialState postDialState) {
        InvokeDynamicSupport.bootstrap("setPostDialState", $$robo$$com_android_internal_telephony_gsm_GsmConnection$setPostDialState(com.android.internal.telephony.Connection$PostDialState ), 0, this, postDialState);
    }

    private void createWakeLock(Context context) {
        InvokeDynamicSupport.bootstrap("createWakeLock", $$robo$$com_android_internal_telephony_gsm_GsmConnection$createWakeLock(android.content.Context ), 0, this, context);
    }

    private void acquireWakeLock() {
        InvokeDynamicSupport.bootstrap("acquireWakeLock", $$robo$$com_android_internal_telephony_gsm_GsmConnection$acquireWakeLock(), 0, this);
    }

    private void releaseWakeLock() {
        InvokeDynamicSupport.bootstrap("releaseWakeLock", $$robo$$com_android_internal_telephony_gsm_GsmConnection$releaseWakeLock(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_gsm_GsmConnection$log(java.lang.String ), 0, this, string2);
    }

    @Override
    public int getNumberPresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberPresentation", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getNumberPresentation(), 0, this);
    }

    @Override
    public UUSInfo getUUSInfo() {
        return InvokeDynamicSupport.bootstrap("getUUSInfo", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getUUSInfo(), 0, this);
    }

    @Override
    public int getPreciseDisconnectCause() {
        return (int)InvokeDynamicSupport.bootstrap("getPreciseDisconnectCause", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getPreciseDisconnectCause(), 0, this);
    }

    @Override
    public void migrateFrom(Connection connection) {
        InvokeDynamicSupport.bootstrap("migrateFrom", $$robo$$com_android_internal_telephony_gsm_GsmConnection$migrateFrom(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    @Override
    public Connection getOrigConnection() {
        return InvokeDynamicSupport.bootstrap("getOrigConnection", $$robo$$com_android_internal_telephony_gsm_GsmConnection$getOrigConnection(), 0, this);
    }

    @Override
    public boolean isMultiparty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiparty", $$robo$$com_android_internal_telephony_gsm_GsmConnection$isMultiparty(), 0, this);
    }

    public /* synthetic */ GsmConnection() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$DriverCall$State;

        static void __staticInitializer__() {
            $SwitchMap$com$android$internal$telephony$DriverCall$State = new int[DriverCall.State.values().length];
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.ACTIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.DIALING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.ALERTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.HOLDING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.INCOMING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$android$internal$telephony$DriverCall$State[DriverCall.State.WAITING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ GsmConnection this$0;

        private void $$robo$$com_android_internal_telephony_gsm_GsmConnection_MyHandler$__constructor__(GsmConnection gsmConnection, Looper l) {
        }

        private final void $$robo$$com_android_internal_telephony_gsm_GsmConnection_MyHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: 
                case 3: {
                    this.this$0.processNextPostDialChar();
                    break;
                }
                case 4: {
                    this.this$0.releaseWakeLock();
                }
            }
        }

        private void __constructor__(GsmConnection gsmConnection, Looper looper) {
            this.$$robo$$com_android_internal_telephony_gsm_GsmConnection_MyHandler$__constructor__(gsmConnection, looper);
        }

        MyHandler(GsmConnection gsmConnection, Looper looper) {
            this.this$0 = gsmConnection;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmConnection_MyHandler$__constructor__(com.android.internal.telephony.gsm.GsmConnection android.os.Looper ), 0, this, gsmConnection, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_gsm_GsmConnection_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

