/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.BidiFormatter;
import android.text.SpannableStringBuilder;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.google.errorprone.annotations.DoNotMock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class GsmMmiCode
extends Handler
implements MmiCode,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "GsmMmiCode";
    static int MAX_LENGTH_SHORT_CODE = 2;
    static char END_OF_USSD_COMMAND = '#';
    static String ACTION_ACTIVATE = "*";
    static String ACTION_DEACTIVATE = "#";
    static String ACTION_INTERROGATE = "*#";
    static String ACTION_REGISTER = "**";
    static String ACTION_ERASURE = "##";
    static String SC_CLIP = "30";
    static String SC_CLIR = "31";
    static String SC_CFU = "21";
    static String SC_CFB = "67";
    static String SC_CFNRy = "61";
    static String SC_CFNR = "62";
    static String SC_CF_All = "002";
    static String SC_CF_All_Conditional = "004";
    static String SC_WAIT = "43";
    static String SC_BAOC = "33";
    static String SC_BAOIC = "331";
    static String SC_BAOICxH = "332";
    static String SC_BAIC = "35";
    static String SC_BAICr = "351";
    static String SC_BA_ALL = "330";
    static String SC_BA_MO = "333";
    static String SC_BA_MT = "353";
    static String SC_PWD = "03";
    static String SC_PIN = "04";
    static String SC_PIN2 = "042";
    static String SC_PUK = "05";
    static String SC_PUK2 = "052";
    static int EVENT_SET_COMPLETE = 1;
    static int EVENT_GET_CLIR_COMPLETE = 2;
    static int EVENT_QUERY_CF_COMPLETE = 3;
    static int EVENT_USSD_COMPLETE = 4;
    static int EVENT_QUERY_COMPLETE = 5;
    static int EVENT_SET_CFF_COMPLETE = 6;
    static int EVENT_USSD_CANCEL_COMPLETE = 7;
    GSMPhone mPhone;
    Context mContext;
    UiccCardApplication mUiccApplication;
    IccRecords mIccRecords;
    String mAction;
    String mSc;
    String mSia;
    String mSib;
    String mSic;
    String mPoundString;
    String mDialingNumber;
    String mPwd;
    private boolean mIsPendingUSSD;
    private boolean mIsUssdRequest;
    private boolean mIsCallFwdReg;
    MmiCode.State mState;
    CharSequence mMessage;
    static Pattern sPatternSuppService;
    static int MATCH_GROUP_POUND_STRING = 1;
    static int MATCH_GROUP_ACTION = 2;
    static int MATCH_GROUP_SERVICE_CODE = 3;
    static int MATCH_GROUP_SIA = 5;
    static int MATCH_GROUP_SIB = 7;
    static int MATCH_GROUP_SIC = 9;
    static int MATCH_GROUP_PWD_CONFIRM = 11;
    static int MATCH_GROUP_DIALING_NUMBER = 12;
    private static String[] sTwoDigitNumberPattern;

    private static final GsmMmiCode $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$newFromDialString(String dialString, GSMPhone phone, UiccCardApplication app) {
        GsmMmiCode ret = null;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            ret = new GsmMmiCode(phone, app);
            ret.mPoundString = GsmMmiCode.makeEmptyNull(m.group(1));
            ret.mAction = GsmMmiCode.makeEmptyNull(m.group(2));
            ret.mSc = GsmMmiCode.makeEmptyNull(m.group(3));
            ret.mSia = GsmMmiCode.makeEmptyNull(m.group(5));
            ret.mSib = GsmMmiCode.makeEmptyNull(m.group(7));
            ret.mSic = GsmMmiCode.makeEmptyNull(m.group(9));
            ret.mPwd = GsmMmiCode.makeEmptyNull(m.group(11));
            ret.mDialingNumber = GsmMmiCode.makeEmptyNull(m.group(12));
            if (ret.mDialingNumber != null && ret.mDialingNumber.endsWith("#") && dialString.endsWith("#")) {
                ret = new GsmMmiCode(phone, app);
                ret.mPoundString = dialString;
            }
        } else if (dialString.endsWith("#")) {
            ret = new GsmMmiCode(phone, app);
            ret.mPoundString = dialString;
        } else if (GsmMmiCode.isTwoDigitShortCode(phone.getContext(), dialString)) {
            ret = null;
        } else if (GsmMmiCode.isShortCode(dialString, phone)) {
            ret = new GsmMmiCode(phone, app);
            ret.mDialingNumber = dialString;
        }
        return ret;
    }

    private static final GsmMmiCode $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$newNetworkInitiatedUssd(String ussdMessage, boolean isUssdRequest, GSMPhone phone, UiccCardApplication app) {
        GsmMmiCode ret = new GsmMmiCode(phone, app);
        ret.mMessage = ussdMessage;
        ret.mIsUssdRequest = isUssdRequest;
        if (isUssdRequest) {
            ret.mIsPendingUSSD = true;
            ret.mState = MmiCode.State.PENDING;
        } else {
            ret.mState = MmiCode.State.COMPLETE;
        }
        return ret;
    }

    private static final GsmMmiCode $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$newFromUssdUserInput(String ussdMessge, GSMPhone phone, UiccCardApplication app) {
        GsmMmiCode ret = new GsmMmiCode(phone, app);
        ret.mMessage = ussdMessge;
        ret.mState = MmiCode.State.PENDING;
        ret.mIsPendingUSSD = true;
        return ret;
    }

    private static final String $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    private static final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isEmptyOrNull(CharSequence s) {
        return s == null || s.length() == 0;
    }

    private static final int $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$scToCallForwardReason(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call forward sc");
        }
        if (sc.equals("002")) {
            return 4;
        }
        if (sc.equals("21")) {
            return 0;
        }
        if (sc.equals("67")) {
            return 1;
        }
        if (sc.equals("62")) {
            return 3;
        }
        if (sc.equals("61")) {
            return 2;
        }
        if (sc.equals("004")) {
            return 5;
        }
        throw new RuntimeException("invalid call forward sc");
    }

    private static final int $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$siToServiceClass(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        int serviceCode = Integer.parseInt(si, 10);
        switch (serviceCode) {
            case 10: {
                return 13;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 19: {
                return 5;
            }
            case 20: {
                return 48;
            }
            case 21: {
                return 160;
            }
            case 22: {
                return 80;
            }
            case 24: {
                return 16;
            }
            case 25: {
                return 32;
            }
            case 26: {
                return 17;
            }
            case 99: {
                return 64;
            }
        }
        throw new RuntimeException("unsupported MMI service code " + si);
    }

    private static final int $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$siToTime(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        return Integer.parseInt(si, 10);
    }

    private static final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isServiceCodeCallForwarding(String sc) {
        return sc != null && (sc.equals("21") || sc.equals("67") || sc.equals("61") || sc.equals("62") || sc.equals("002") || sc.equals("004"));
    }

    private static final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isServiceCodeCallBarring(String sc) {
        String[] barringMMI;
        Resources resource = Resources.getSystem();
        if (sc != null && (barringMMI = resource.getStringArray(17236020)) != null) {
            for (String match : barringMMI) {
                if (!sc.equals(match)) continue;
                return true;
            }
        }
        return false;
    }

    private static final String $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$scToBarringFacility(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call barring sc");
        }
        if (sc.equals("33")) {
            return "AO";
        }
        if (sc.equals("331")) {
            return "OI";
        }
        if (sc.equals("332")) {
            return "OX";
        }
        if (sc.equals("35")) {
            return "AI";
        }
        if (sc.equals("351")) {
            return "IR";
        }
        if (sc.equals("330")) {
            return "AB";
        }
        if (sc.equals("333")) {
            return "AG";
        }
        if (sc.equals("353")) {
            return "AC";
        }
        throw new RuntimeException("invalid call barring sc");
    }

    private void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$__constructor__(GSMPhone phone, UiccCardApplication app) {
        this.mState = MmiCode.State.PENDING;
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mUiccApplication = app;
        if (app != null) {
            this.mIccRecords = app.getIccRecords();
        }
    }

    private final MmiCode.State $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getState() {
        return this.mState;
    }

    private final CharSequence $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getMessage() {
        return this.mMessage;
    }

    private final Phone $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getPhone() {
        return this.mPhone;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$cancel() {
        if (this.mState == MmiCode.State.COMPLETE || this.mState == MmiCode.State.FAILED) {
            return;
        }
        this.mState = MmiCode.State.CANCELLED;
        if (this.mIsPendingUSSD) {
            this.mPhone.mCi.cancelPendingUssd(this.obtainMessage(7, this));
        } else {
            this.mPhone.onMMIDone(this);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isCancelable() {
        return this.mIsPendingUSSD;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isMMI() {
        return this.mPoundString != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isShortCode() {
        return this.mPoundString == null && this.mDialingNumber != null && this.mDialingNumber.length() <= 2;
    }

    private static final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isTwoDigitShortCode(Context context, String dialString) {
        Rlog.d("GsmMmiCode", "isTwoDigitShortCode");
        if (dialString == null || dialString.length() > 2) {
            return false;
        }
        if (sTwoDigitNumberPattern == null) {
            sTwoDigitNumberPattern = context.getResources().getStringArray(17236008);
        }
        for (String dialnumber : sTwoDigitNumberPattern) {
            Rlog.d("GsmMmiCode", "Two Digit Number Pattern " + dialnumber);
            if (!dialString.equals(dialnumber)) continue;
            Rlog.d("GsmMmiCode", "Two Digit Number Pattern -true");
            return true;
        }
        Rlog.d("GsmMmiCode", "Two Digit Number Pattern -false");
        return false;
    }

    private static final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isShortCode(String dialString, GSMPhone phone) {
        if (dialString == null) {
            return false;
        }
        if (dialString.length() == 0) {
            return false;
        }
        if (PhoneNumberUtils.isLocalEmergencyNumber(phone.getContext(), dialString)) {
            return false;
        }
        return GsmMmiCode.isShortCodeUSSD(dialString, phone);
    }

    private static final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isShortCodeUSSD(String dialString, GSMPhone phone) {
        if (dialString != null && dialString.length() <= 2) {
            if (phone.isInCall()) {
                return true;
            }
            if (dialString.length() != 2 || dialString.charAt(0) != '1') {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isPinPukCommand() {
        return this.mSc != null && (this.mSc.equals("04") || this.mSc.equals("042") || this.mSc.equals("05") || this.mSc.equals("052"));
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isTemporaryModeCLIR() {
        return this.mSc != null && this.mSc.equals("31") && this.mDialingNumber != null && (this.isActivate() || this.isDeactivate());
    }

    private final int $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getCLIRMode() {
        if (this.mSc != null && this.mSc.equals("31")) {
            if (this.isActivate()) {
                return 2;
            }
            if (this.isDeactivate()) {
                return 1;
            }
        }
        return 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isActivate() {
        return this.mAction != null && this.mAction.equals("*");
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isDeactivate() {
        return this.mAction != null && this.mAction.equals("#");
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isInterrogate() {
        return this.mAction != null && this.mAction.equals("*#");
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isRegister() {
        return this.mAction != null && this.mAction.equals("**");
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isErasure() {
        return this.mAction != null && this.mAction.equals("##");
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isPendingUSSD() {
        return this.mIsPendingUSSD;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isUssdRequest() {
        return this.mIsUssdRequest;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$processCode() {
        block44: {
            try {
                if (this.isShortCode()) {
                    Rlog.d("GsmMmiCode", "isShortCode");
                    this.sendUssd(this.mDialingNumber);
                    break block44;
                }
                if (this.mDialingNumber != null) {
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals("30")) {
                    Rlog.d("GsmMmiCode", "is CLIP");
                    if (this.isInterrogate()) {
                        this.mPhone.mCi.queryCLIP(this.obtainMessage(5, this));
                        break block44;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals("31")) {
                    Rlog.d("GsmMmiCode", "is CLIR");
                    if (this.isActivate()) {
                        this.mPhone.mCi.setCLIR(1, this.obtainMessage(1, this));
                        break block44;
                    }
                    if (this.isDeactivate()) {
                        this.mPhone.mCi.setCLIR(2, this.obtainMessage(1, this));
                        break block44;
                    }
                    if (this.isInterrogate()) {
                        this.mPhone.mCi.getCLIR(this.obtainMessage(2, this));
                        break block44;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (GsmMmiCode.isServiceCodeCallForwarding(this.mSc)) {
                    Rlog.d("GsmMmiCode", "is CF");
                    String dialingNumber = this.mSia;
                    int serviceClass = GsmMmiCode.siToServiceClass(this.mSib);
                    int reason = GsmMmiCode.scToCallForwardReason(this.mSc);
                    int time = GsmMmiCode.siToTime(this.mSic);
                    if (this.isInterrogate()) {
                        this.mPhone.mCi.queryCallForwardStatus(reason, serviceClass, dialingNumber, this.obtainMessage(3, this));
                    } else {
                        int cfAction;
                        if (this.isActivate()) {
                            if (GsmMmiCode.isEmptyOrNull(dialingNumber)) {
                                cfAction = 1;
                                this.mIsCallFwdReg = false;
                            } else {
                                cfAction = 3;
                                this.mIsCallFwdReg = true;
                            }
                        } else if (this.isDeactivate()) {
                            cfAction = 0;
                        } else if (this.isRegister()) {
                            cfAction = 3;
                        } else if (this.isErasure()) {
                            cfAction = 4;
                        } else {
                            throw new RuntimeException("invalid action");
                        }
                        int isSettingUnconditionalVoice = !(reason != 0 && reason != 4 || (serviceClass & 1) == 0 && serviceClass != 0) ? 1 : 0;
                        int isEnableDesired = cfAction == 1 || cfAction == 3 ? 1 : 0;
                        Rlog.d("GsmMmiCode", "is CF setCallForward");
                        this.mPhone.mCi.setCallForward(cfAction, reason, serviceClass, dialingNumber, time, this.obtainMessage(6, isSettingUnconditionalVoice, isEnableDesired, this));
                    }
                    break block44;
                }
                if (GsmMmiCode.isServiceCodeCallBarring(this.mSc)) {
                    String password = this.mSia;
                    int serviceClass = GsmMmiCode.siToServiceClass(this.mSib);
                    String facility = GsmMmiCode.scToBarringFacility(this.mSc);
                    if (this.isInterrogate()) {
                        this.mPhone.mCi.queryFacilityLock(facility, password, serviceClass, this.obtainMessage(5, this));
                        break block44;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        this.mPhone.mCi.setFacilityLock(facility, this.isActivate(), password, serviceClass, this.obtainMessage(1, this));
                        break block44;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals("03")) {
                    String oldPwd = this.mSib;
                    String newPwd = this.mSic;
                    if (this.isActivate() || this.isRegister()) {
                        this.mAction = "**";
                        String facility = this.mSia == null ? "AB" : GsmMmiCode.scToBarringFacility(this.mSia);
                        if (newPwd.equals(this.mPwd)) {
                            this.mPhone.mCi.changeBarringPassword(facility, oldPwd, newPwd, this.obtainMessage(1, this));
                        } else {
                            this.handlePasswordError(17039494);
                        }
                        break block44;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals("43")) {
                    int serviceClass = GsmMmiCode.siToServiceClass(this.mSia);
                    if (this.isActivate() || this.isDeactivate()) {
                        this.mPhone.mCi.setCallWaiting(this.isActivate(), serviceClass, this.obtainMessage(1, this));
                        break block44;
                    }
                    if (this.isInterrogate()) {
                        this.mPhone.mCi.queryCallWaiting(serviceClass, this.obtainMessage(5, this));
                        break block44;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.isPinPukCommand()) {
                    String oldPinOrPuk = this.mSia;
                    String newPinOrPuk = this.mSib;
                    int pinLen = newPinOrPuk.length();
                    if (this.isRegister()) {
                        if (!newPinOrPuk.equals(this.mSic)) {
                            this.handlePasswordError(17039498);
                            break block44;
                        }
                        if (pinLen < 4 || pinLen > 8) {
                            this.handlePasswordError(17039499);
                            break block44;
                        }
                        if (this.mSc.equals("04") && this.mUiccApplication != null && this.mUiccApplication.getState() == IccCardApplicationStatus.AppState.APPSTATE_PUK) {
                            this.handlePasswordError(17039501);
                            break block44;
                        }
                        if (this.mUiccApplication != null) {
                            Rlog.d("GsmMmiCode", "process mmi service code using UiccApp sc=" + this.mSc);
                            if (this.mSc.equals("04")) {
                                this.mUiccApplication.changeIccLockPassword(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                                break block44;
                            }
                            if (this.mSc.equals("042")) {
                                this.mUiccApplication.changeIccFdnPassword(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                                break block44;
                            }
                            if (this.mSc.equals("05")) {
                                this.mUiccApplication.supplyPuk(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                                break block44;
                            }
                            if (this.mSc.equals("052")) {
                                this.mUiccApplication.supplyPuk2(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                                break block44;
                            }
                            throw new RuntimeException("uicc unsupported service code=" + this.mSc);
                        }
                        throw new RuntimeException("No application mUiccApplicaiton is null");
                    }
                    throw new RuntimeException("Ivalid register/action=" + this.mAction);
                }
                if (this.mPoundString != null) {
                    this.sendUssd(this.mPoundString);
                    break block44;
                }
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            catch (RuntimeException exc) {
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.mContext.getText(17039487);
                this.mPhone.onMMIDone(this);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$handlePasswordError(int res) {
        this.mState = MmiCode.State.FAILED;
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        sb.append(this.mContext.getText(res));
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onUssdFinished(String ussdMessage, boolean isUssdRequest) {
        if (this.mState == MmiCode.State.PENDING) {
            this.mMessage = ussdMessage == null ? this.mContext.getText(17039495) : ussdMessage;
            this.mIsUssdRequest = isUssdRequest;
            if (!isUssdRequest) {
                this.mState = MmiCode.State.COMPLETE;
            }
            this.mPhone.onMMIDone(this);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onUssdFinishedError() {
        if (this.mState == MmiCode.State.PENDING) {
            this.mState = MmiCode.State.FAILED;
            this.mMessage = this.mContext.getText(17039487);
            this.mPhone.onMMIDone(this);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$sendUssd(String ussdMessage) {
        this.mIsPendingUSSD = true;
        this.mPhone.mCi.sendUSSD(ussdMessage, this.obtainMessage(4, this));
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSetComplete(msg, ar);
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && msg.arg1 == 1) {
                    boolean cffEnabled;
                    boolean bl = cffEnabled = msg.arg2 == 1;
                    if (this.mIccRecords != null) {
                        this.mIccRecords.setVoiceCallForwardingFlag(1, cffEnabled, this.mDialingNumber);
                    }
                }
                this.onSetComplete(msg, ar);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onGetClirComplete(ar);
                break;
            }
            case 3: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryCfComplete(ar);
                break;
            }
            case 5: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryComplete(ar);
                break;
            }
            case 4: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) break;
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.getErrorMessage(ar);
                this.mPhone.onMMIDone(this);
                break;
            }
            case 7: {
                this.mPhone.onMMIDone(this);
            }
        }
    }

    private final CharSequence $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getErrorMessage(AsyncResult ar) {
        CommandException.Error err;
        if (ar.exception instanceof CommandException && (err = ((CommandException)ar.exception).getCommandError()) == CommandException.Error.FDN_CHECK_FAILURE) {
            Rlog.i("GsmMmiCode", "FDN_CHECK_FAILURE");
            return this.mContext.getText(17039488);
        }
        return this.mContext.getText(17039487);
    }

    private final CharSequence $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getScString() {
        if (this.mSc != null) {
            if (GsmMmiCode.isServiceCodeCallBarring(this.mSc)) {
                return this.mContext.getText(17039512);
            }
            if (GsmMmiCode.isServiceCodeCallForwarding(this.mSc)) {
                return this.mContext.getText(17039510);
            }
            if (this.mSc.equals("30")) {
                return this.mContext.getText(17039506);
            }
            if (this.mSc.equals("31")) {
                return this.mContext.getText(17039507);
            }
            if (this.mSc.equals("03")) {
                return this.mContext.getText(17039513);
            }
            if (this.mSc.equals("43")) {
                return this.mContext.getText(17039511);
            }
            if (this.isPinPukCommand()) {
                return this.mContext.getText(17039514);
            }
        }
        return "";
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onSetComplete(Message msg, AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof CommandException) {
                CommandException.Error err = ((CommandException)ar.exception).getCommandError();
                if (err == CommandException.Error.PASSWORD_INCORRECT) {
                    if (this.isPinPukCommand()) {
                        if (this.mSc.equals("05") || this.mSc.equals("052")) {
                            sb.append(this.mContext.getText(17039497));
                        } else {
                            sb.append(this.mContext.getText(17039496));
                        }
                        int attemptsRemaining = msg.arg1;
                        if (attemptsRemaining <= 0) {
                            Rlog.d("GsmMmiCode", "onSetComplete: PUK locked, cancel as lock screen will handle this");
                            this.mState = MmiCode.State.CANCELLED;
                        } else if (attemptsRemaining > 0) {
                            Rlog.d("GsmMmiCode", "onSetComplete: attemptsRemaining=" + attemptsRemaining);
                            sb.append(this.mContext.getResources().getQuantityString(0x1140000, attemptsRemaining, attemptsRemaining));
                        }
                    } else {
                        sb.append(this.mContext.getText(17039494));
                    }
                } else if (err == CommandException.Error.SIM_PUK2) {
                    sb.append(this.mContext.getText(17039496));
                    sb.append("\n");
                    sb.append(this.mContext.getText(17039502));
                } else if (err == CommandException.Error.REQUEST_NOT_SUPPORTED) {
                    if (this.mSc.equals("04")) {
                        sb.append(this.mContext.getText(17039503));
                    }
                } else if (err == CommandException.Error.FDN_CHECK_FAILURE) {
                    Rlog.i("GsmMmiCode", "FDN_CHECK_FAILURE");
                    sb.append(this.mContext.getText(17039488));
                } else {
                    sb.append(this.mContext.getText(17039487));
                }
            } else {
                sb.append(this.mContext.getText(17039487));
            }
        } else if (this.isActivate()) {
            this.mState = MmiCode.State.COMPLETE;
            if (this.mIsCallFwdReg) {
                sb.append(this.mContext.getText(17039492));
            } else {
                sb.append(this.mContext.getText(17039489));
            }
            if (this.mSc.equals("31")) {
                this.mPhone.saveClirSetting(1);
            }
        } else if (this.isDeactivate()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17039491));
            if (this.mSc.equals("31")) {
                this.mPhone.saveClirSetting(2);
            }
        } else if (this.isRegister()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17039492));
        } else if (this.isErasure()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17039493));
        } else {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.mContext.getText(17039487));
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onGetClirComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.getErrorMessage(ar));
        } else {
            int[] clirArgs = (int[])ar.result;
            switch (clirArgs[1]) {
                case 0: {
                    sb.append(this.mContext.getText(17039525));
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 1: {
                    sb.append(this.mContext.getText(17039526));
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 2: {
                    sb.append(this.mContext.getText(17039487));
                    this.mState = MmiCode.State.FAILED;
                    break;
                }
                case 3: {
                    switch (clirArgs[0]) {
                        default: {
                            sb.append(this.mContext.getText(17039521));
                            break;
                        }
                        case 1: {
                            sb.append(this.mContext.getText(17039521));
                            break;
                        }
                        case 2: {
                            sb.append(this.mContext.getText(17039522));
                        }
                    }
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 4: {
                    switch (clirArgs[0]) {
                        default: {
                            sb.append(this.mContext.getText(17039524));
                            break;
                        }
                        case 1: {
                            sb.append(this.mContext.getText(17039523));
                            break;
                        }
                        case 2: {
                            sb.append(this.mContext.getText(17039524));
                        }
                    }
                    this.mState = MmiCode.State.COMPLETE;
                }
            }
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private final CharSequence $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$serviceClassToCFString(int serviceClass) {
        switch (serviceClass) {
            case 1: {
                return this.mContext.getText(17039536);
            }
            case 2: {
                return this.mContext.getText(17039537);
            }
            case 4: {
                return this.mContext.getText(17039538);
            }
            case 8: {
                return this.mContext.getText(17039539);
            }
            case 16: {
                return this.mContext.getText(17039541);
            }
            case 32: {
                return this.mContext.getText(17039540);
            }
            case 64: {
                return this.mContext.getText(17039542);
            }
            case 128: {
                return this.mContext.getText(17039543);
            }
        }
        return null;
    }

    private final CharSequence $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$makeCFQueryResultMessage(CallForwardInfo info, int serviceClassMask) {
        boolean needTimeTemplate;
        String[] sources = new String[]{"{0}", "{1}", "{2}"};
        CharSequence[] destinations = new CharSequence[3];
        boolean bl = needTimeTemplate = info.reason == 2;
        CharSequence template = info.status == 1 ? (needTimeTemplate ? this.mContext.getText(17039560) : this.mContext.getText(17039559)) : (info.status == 0 && GsmMmiCode.isEmptyOrNull(info.number) ? this.mContext.getText(17039558) : (needTimeTemplate ? this.mContext.getText(17039562) : this.mContext.getText(17039561)));
        destinations[0] = this.serviceClassToCFString(info.serviceClass & serviceClassMask);
        destinations[1] = this.formatLtr(PhoneNumberUtils.stringFromStringAndTOA(info.number, info.toa));
        destinations[2] = Integer.toString(info.timeSeconds);
        if (info.reason == 0 && (info.serviceClass & serviceClassMask) == 1) {
            boolean cffEnabled;
            boolean bl2 = cffEnabled = info.status == 1;
            if (this.mIccRecords != null) {
                this.mIccRecords.setVoiceCallForwardingFlag(1, cffEnabled, info.number);
            }
        }
        return TextUtils.replace(template, sources, destinations);
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$formatLtr(String str) {
        BidiFormatter fmt = BidiFormatter.getInstance();
        return str == null ? str : fmt.unicodeWrap(str, TextDirectionHeuristics.LTR, true);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onQueryCfComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.getErrorMessage(ar));
        } else {
            CallForwardInfo[] infos = (CallForwardInfo[])ar.result;
            if (infos.length == 0) {
                sb.append(this.mContext.getText(17039491));
                if (this.mIccRecords != null) {
                    this.mIccRecords.setVoiceCallForwardingFlag(1, false, null);
                }
            } else {
                SpannableStringBuilder tb = new SpannableStringBuilder();
                for (int serviceClassMask = 1; serviceClassMask <= 128; serviceClassMask <<= 1) {
                    int s = infos.length;
                    for (int i = 0; i < s; ++i) {
                        if ((serviceClassMask & infos[i].serviceClass) == 0) continue;
                        tb.append(this.makeCFQueryResultMessage(infos[i], serviceClassMask));
                        tb.append("\n");
                    }
                }
                sb.append(tb);
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onQueryComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.getErrorMessage(ar));
        } else {
            int[] ints = (int[])ar.result;
            if (ints.length != 0) {
                if (ints[0] == 0) {
                    sb.append(this.mContext.getText(17039491));
                } else if (this.mSc.equals("43")) {
                    sb.append(this.createQueryCallWaitingResultMessage(ints[1]));
                } else if (GsmMmiCode.isServiceCodeCallBarring(this.mSc)) {
                    sb.append(this.createQueryCallBarringResultMessage(ints[0]));
                } else if (ints[0] == 1) {
                    sb.append(this.mContext.getText(17039489));
                } else {
                    sb.append(this.mContext.getText(17039487));
                }
            } else {
                sb.append(this.mContext.getText(17039487));
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private final CharSequence $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$createQueryCallWaitingResultMessage(int serviceClass) {
        StringBuilder sb = new StringBuilder(this.mContext.getText(17039490));
        for (int classMask = 1; classMask <= 128; classMask <<= 1) {
            if ((classMask & serviceClass) == 0) continue;
            sb.append("\n");
            sb.append(this.serviceClassToCFString(classMask & serviceClass));
        }
        return sb;
    }

    private final CharSequence $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$createQueryCallBarringResultMessage(int serviceClass) {
        StringBuilder sb = new StringBuilder(this.mContext.getText(17039490));
        for (int classMask = 1; classMask <= 128; classMask <<= 1) {
            if ((classMask & serviceClass) == 0) continue;
            sb.append("\n");
            sb.append(this.serviceClassToCFString(classMask & serviceClass));
        }
        return sb;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$toString() {
        StringBuilder sb = new StringBuilder("GsmMmiCode {");
        sb.append("State=" + (Object)((Object)this.getState()));
        if (this.mAction != null) {
            sb.append(" action=" + this.mAction);
        }
        if (this.mSc != null) {
            sb.append(" sc=" + this.mSc);
        }
        if (this.mSia != null) {
            sb.append(" sia=" + this.mSia);
        }
        if (this.mSib != null) {
            sb.append(" sib=" + this.mSib);
        }
        if (this.mSic != null) {
            sb.append(" sic=" + this.mSic);
        }
        if (this.mPoundString != null) {
            sb.append(" poundString=" + this.mPoundString);
        }
        if (this.mDialingNumber != null) {
            sb.append(" dialingNumber=" + this.mDialingNumber);
        }
        if (this.mPwd != null) {
            sb.append(" pwd=" + this.mPwd);
        }
        sb.append("}");
        return sb.toString();
    }

    static void __staticInitializer__() {
        sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    }

    static GsmMmiCode newFromDialString(String string2, GSMPhone gSMPhone, UiccCardApplication uiccCardApplication) {
        return InvokeDynamicSupport.bootstrapStatic("newFromDialString", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$newFromDialString(java.lang.String com.android.internal.telephony.gsm.GSMPhone com.android.internal.telephony.uicc.UiccCardApplication ), 0, (String)string2, (GSMPhone)gSMPhone, (UiccCardApplication)uiccCardApplication);
    }

    static GsmMmiCode newNetworkInitiatedUssd(String string2, boolean bl, GSMPhone gSMPhone, UiccCardApplication uiccCardApplication) {
        return InvokeDynamicSupport.bootstrapStatic("newNetworkInitiatedUssd", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$newNetworkInitiatedUssd(java.lang.String boolean com.android.internal.telephony.gsm.GSMPhone com.android.internal.telephony.uicc.UiccCardApplication ), 0, (String)string2, (boolean)bl, (GSMPhone)gSMPhone, (UiccCardApplication)uiccCardApplication);
    }

    static GsmMmiCode newFromUssdUserInput(String string2, GSMPhone gSMPhone, UiccCardApplication uiccCardApplication) {
        return InvokeDynamicSupport.bootstrapStatic("newFromUssdUserInput", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$newFromUssdUserInput(java.lang.String com.android.internal.telephony.gsm.GSMPhone com.android.internal.telephony.uicc.UiccCardApplication ), 0, (String)string2, (GSMPhone)gSMPhone, (UiccCardApplication)uiccCardApplication);
    }

    private static String makeEmptyNull(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeEmptyNull", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$makeEmptyNull(java.lang.String ), 0, (String)string2);
    }

    private static boolean isEmptyOrNull(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmptyOrNull", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isEmptyOrNull(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    private static int scToCallForwardReason(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("scToCallForwardReason", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$scToCallForwardReason(java.lang.String ), 0, (String)string2);
    }

    private static int siToServiceClass(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("siToServiceClass", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$siToServiceClass(java.lang.String ), 0, (String)string2);
    }

    private static int siToTime(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("siToTime", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$siToTime(java.lang.String ), 0, (String)string2);
    }

    static boolean isServiceCodeCallForwarding(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isServiceCodeCallForwarding", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isServiceCodeCallForwarding(java.lang.String ), 0, (String)string2);
    }

    static boolean isServiceCodeCallBarring(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isServiceCodeCallBarring", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isServiceCodeCallBarring(java.lang.String ), 0, (String)string2);
    }

    static String scToBarringFacility(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("scToBarringFacility", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$scToBarringFacility(java.lang.String ), 0, (String)string2);
    }

    private void __constructor__(GSMPhone gSMPhone, UiccCardApplication uiccCardApplication) {
        this.$$robo$$com_android_internal_telephony_gsm_GsmMmiCode$__constructor__(gSMPhone, uiccCardApplication);
    }

    GsmMmiCode(GSMPhone gSMPhone, UiccCardApplication uiccCardApplication) {
        super(gSMPhone.getHandler().getLooper());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$__constructor__(com.android.internal.telephony.gsm.GSMPhone com.android.internal.telephony.uicc.UiccCardApplication ), 0, this, gSMPhone, uiccCardApplication);
    }

    @Override
    public MmiCode.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getState(), 0, this);
    }

    @Override
    public CharSequence getMessage() {
        return InvokeDynamicSupport.bootstrap("getMessage", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getMessage(), 0, this);
    }

    @Override
    public Phone getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getPhone(), 0, this);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$cancel(), 0, this);
    }

    @Override
    public boolean isCancelable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCancelable", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isCancelable(), 0, this);
    }

    boolean isMMI() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMMI", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isMMI(), 0, this);
    }

    boolean isShortCode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShortCode", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isShortCode(), 0, this);
    }

    private static boolean isTwoDigitShortCode(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTwoDigitShortCode", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isTwoDigitShortCode(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    private static boolean isShortCode(String string2, GSMPhone gSMPhone) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isShortCode", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isShortCode(java.lang.String com.android.internal.telephony.gsm.GSMPhone ), 0, (String)string2, (GSMPhone)gSMPhone);
    }

    private static boolean isShortCodeUSSD(String string2, GSMPhone gSMPhone) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isShortCodeUSSD", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isShortCodeUSSD(java.lang.String com.android.internal.telephony.gsm.GSMPhone ), 0, (String)string2, (GSMPhone)gSMPhone);
    }

    boolean isPinPukCommand() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPinPukCommand", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isPinPukCommand(), 0, this);
    }

    boolean isTemporaryModeCLIR() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTemporaryModeCLIR", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isTemporaryModeCLIR(), 0, this);
    }

    int getCLIRMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCLIRMode", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getCLIRMode(), 0, this);
    }

    boolean isActivate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActivate", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isActivate(), 0, this);
    }

    boolean isDeactivate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeactivate", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isDeactivate(), 0, this);
    }

    boolean isInterrogate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInterrogate", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isInterrogate(), 0, this);
    }

    boolean isRegister() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRegister", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isRegister(), 0, this);
    }

    boolean isErasure() {
        return (boolean)InvokeDynamicSupport.bootstrap("isErasure", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isErasure(), 0, this);
    }

    public boolean isPendingUSSD() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPendingUSSD", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isPendingUSSD(), 0, this);
    }

    @Override
    public boolean isUssdRequest() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUssdRequest", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$isUssdRequest(), 0, this);
    }

    void processCode() {
        InvokeDynamicSupport.bootstrap("processCode", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$processCode(), 0, this);
    }

    private void handlePasswordError(int n) {
        InvokeDynamicSupport.bootstrap("handlePasswordError", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$handlePasswordError(int ), 0, this, n);
    }

    void onUssdFinished(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("onUssdFinished", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onUssdFinished(java.lang.String boolean ), 0, this, string2, bl);
    }

    void onUssdFinishedError() {
        InvokeDynamicSupport.bootstrap("onUssdFinishedError", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onUssdFinishedError(), 0, this);
    }

    void sendUssd(String string2) {
        InvokeDynamicSupport.bootstrap("sendUssd", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$sendUssd(java.lang.String ), 0, this, string2);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$handleMessage(android.os.Message ), 0, this, message);
    }

    private CharSequence getErrorMessage(AsyncResult asyncResult) {
        return InvokeDynamicSupport.bootstrap("getErrorMessage", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getErrorMessage(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private CharSequence getScString() {
        return InvokeDynamicSupport.bootstrap("getScString", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$getScString(), 0, this);
    }

    private void onSetComplete(Message message, AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onSetComplete", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onSetComplete(android.os.Message android.os.AsyncResult ), 0, this, message, asyncResult);
    }

    private void onGetClirComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onGetClirComplete", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onGetClirComplete(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private CharSequence serviceClassToCFString(int n) {
        return InvokeDynamicSupport.bootstrap("serviceClassToCFString", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$serviceClassToCFString(int ), 0, this, n);
    }

    private CharSequence makeCFQueryResultMessage(CallForwardInfo callForwardInfo, int n) {
        return InvokeDynamicSupport.bootstrap("makeCFQueryResultMessage", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$makeCFQueryResultMessage(com.android.internal.telephony.CallForwardInfo int ), 0, this, callForwardInfo, n);
    }

    private String formatLtr(String string2) {
        return InvokeDynamicSupport.bootstrap("formatLtr", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$formatLtr(java.lang.String ), 0, this, string2);
    }

    private void onQueryCfComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onQueryCfComplete", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onQueryCfComplete(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private void onQueryComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onQueryComplete", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$onQueryComplete(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private CharSequence createQueryCallWaitingResultMessage(int n) {
        return InvokeDynamicSupport.bootstrap("createQueryCallWaitingResultMessage", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$createQueryCallWaitingResultMessage(int ), 0, this, n);
    }

    private CharSequence createQueryCallBarringResultMessage(int n) {
        return InvokeDynamicSupport.bootstrap("createQueryCallBarringResultMessage", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$createQueryCallBarringResultMessage(int ), 0, this, n);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_gsm_GsmMmiCode$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(GsmMmiCode.class);
    }

    public /* synthetic */ GsmMmiCode() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmMmiCode)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

