/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.res.Resources;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.text.format.Time;
import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.Sms7BitEncodingTranslator;
import com.android.internal.telephony.SmsConstants;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.gsm.GsmSmsAddress;
import com.android.internal.telephony.uicc.IccUtils;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SmsMessage
extends SmsMessageBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "SmsMessage";
    private static boolean VDBG = false;
    private SmsConstants.MessageClass messageClass;
    private int mMti;
    private int mProtocolIdentifier;
    private int mDataCodingScheme;
    private boolean mReplyPathPresent;
    private GsmSmsAddress mRecipientAddress;
    private int mStatus;
    private boolean mIsStatusReportMessage;
    private int mVoiceMailCount;

    private void $$robo$$com_android_internal_telephony_gsm_SmsMessage$__constructor__() {
        this.mReplyPathPresent = false;
        this.mIsStatusReportMessage = false;
        this.mVoiceMailCount = 0;
    }

    private static final SmsMessage $$robo$$com_android_internal_telephony_gsm_SmsMessage$createFromPdu(byte[] pdu) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.parsePdu(pdu);
            return msg;
        }
        catch (RuntimeException ex) {
            Rlog.e("SmsMessage", "SMS PDU parsing failed: ", ex);
            return null;
        }
        catch (OutOfMemoryError e) {
            Rlog.e("SmsMessage", "SMS PDU parsing failed with out of memory: ", e);
            return null;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsMessage$isTypeZero() {
        return this.mProtocolIdentifier == 64;
    }

    private static final SmsMessage $$robo$$com_android_internal_telephony_gsm_SmsMessage$newFromCMT(String[] lines) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.parsePdu(IccUtils.hexStringToBytes(lines[1]));
            return msg;
        }
        catch (RuntimeException ex) {
            Rlog.e("SmsMessage", "SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    private static final SmsMessage $$robo$$com_android_internal_telephony_gsm_SmsMessage$newFromCDS(String line) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.parsePdu(IccUtils.hexStringToBytes(line));
            return msg;
        }
        catch (RuntimeException ex) {
            Rlog.e("SmsMessage", "CDS SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    private static final SmsMessage $$robo$$com_android_internal_telephony_gsm_SmsMessage$createFromEfRecord(int index, byte[] data) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.mIndexOnIcc = index;
            if ((data[0] & 1) == 0) {
                Rlog.w("SmsMessage", "SMS parsing failed: Trying to parse a free record");
                return null;
            }
            msg.mStatusOnIcc = data[0] & 7;
            int size = data.length - 1;
            byte[] pdu = new byte[size];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)1, (byte[])pdu, (int)0, (int)size);
            msg.parsePdu(pdu);
            return msg;
        }
        catch (RuntimeException ex) {
            Rlog.e("SmsMessage", "SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    private static final int $$robo$$com_android_internal_telephony_gsm_SmsMessage$getTPLayerLengthForPDU(String pdu) {
        int len = pdu.length() / 2;
        int smscLen = Integer.parseInt(pdu.substring(0, 2), 16);
        return len - smscLen - 1;
    }

    private static final SubmitPdu $$robo$$com_android_internal_telephony_gsm_SmsMessage$getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested, byte[] header) {
        return SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, header, 0, 0, 0);
    }

    private static final SubmitPdu $$robo$$com_android_internal_telephony_gsm_SmsMessage$getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested, byte[] header, int encoding, int languageTable, int languageShiftTable) {
        byte[] userData;
        ByteArrayOutputStream bo;
        SubmitPdu ret;
        block17: {
            if (message == null || destinationAddress == null) {
                return null;
            }
            if (encoding == 0) {
                GsmAlphabet.TextEncodingDetails ted = SmsMessage.calculateLength(message, false);
                encoding = ted.codeUnitSize;
                languageTable = ted.languageTable;
                languageShiftTable = ted.languageShiftTable;
                if (encoding == 1 && (languageTable != 0 || languageShiftTable != 0)) {
                    SmsHeader smsHeader;
                    if (header != null) {
                        smsHeader = SmsHeader.fromByteArray(header);
                        if (smsHeader.languageTable != languageTable || smsHeader.languageShiftTable != languageShiftTable) {
                            Rlog.w("SmsMessage", "Updating language table in SMS header: " + smsHeader.languageTable + " -> " + languageTable + ", " + smsHeader.languageShiftTable + " -> " + languageShiftTable);
                            smsHeader.languageTable = languageTable;
                            smsHeader.languageShiftTable = languageShiftTable;
                            header = SmsHeader.toByteArray(smsHeader);
                        }
                    } else {
                        smsHeader = new SmsHeader();
                        smsHeader.languageTable = languageTable;
                        smsHeader.languageShiftTable = languageShiftTable;
                        header = SmsHeader.toByteArray(smsHeader);
                    }
                }
            }
            ret = new SubmitPdu();
            byte mtiByte = (byte)(1 | (header != null ? 64 : 0));
            bo = SmsMessage.getSubmitPduHead(scAddress, destinationAddress, mtiByte, statusReportRequested, ret);
            try {
                if (encoding == 1) {
                    userData = GsmAlphabet.stringToGsm7BitPackedWithHeader(message, header, languageTable, languageShiftTable);
                    break block17;
                }
                try {
                    userData = SmsMessage.encodeUCS2(message, header);
                }
                catch (UnsupportedEncodingException uex) {
                    Rlog.e("SmsMessage", "Implausible UnsupportedEncodingException ", uex);
                    return null;
                }
            }
            catch (EncodeException ex) {
                try {
                    userData = SmsMessage.encodeUCS2(message, header);
                    encoding = 3;
                }
                catch (UnsupportedEncodingException uex) {
                    Rlog.e("SmsMessage", "Implausible UnsupportedEncodingException ", uex);
                    return null;
                }
            }
        }
        if (encoding == 1) {
            if ((0xFF & userData[0]) > 160) {
                Rlog.e("SmsMessage", "Message too long (" + (0xFF & userData[0]) + " septets)");
                return null;
            }
            bo.write(0);
        } else {
            if ((0xFF & userData[0]) > 140) {
                Rlog.e("SmsMessage", "Message too long (" + (0xFF & userData[0]) + " bytes)");
                return null;
            }
            bo.write(8);
        }
        bo.write(userData, 0, userData.length);
        ret.encodedMessage = bo.toByteArray();
        return ret;
    }

    private static final byte[] $$robo$$com_android_internal_telephony_gsm_SmsMessage$encodeUCS2(String message, byte[] header) throws UnsupportedEncodingException {
        byte[] userData;
        byte[] textPart = message.getBytes("utf-16be");
        if (header != null) {
            userData = new byte[header.length + textPart.length + 1];
            userData[0] = (byte)header.length;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])header, (int)0, (byte[])userData, (int)1, (int)header.length);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])textPart, (int)0, (byte[])userData, (int)(header.length + 1), (int)textPart.length);
        } else {
            userData = textPart;
        }
        byte[] ret = new byte[userData.length + 1];
        ret[0] = (byte)(userData.length & 0xFF);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])userData, (int)0, (byte[])ret, (int)1, (int)userData.length);
        return ret;
    }

    private static final SubmitPdu $$robo$$com_android_internal_telephony_gsm_SmsMessage$getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested) {
        return SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, null);
    }

    private static final SubmitPdu $$robo$$com_android_internal_telephony_gsm_SmsMessage$getSubmitPdu(String scAddress, String destinationAddress, int destinationPort, byte[] data, boolean statusReportRequested) {
        SmsHeader.PortAddrs portAddrs = new SmsHeader.PortAddrs();
        portAddrs.destPort = destinationPort;
        portAddrs.origPort = 0;
        portAddrs.areEightBits = false;
        SmsHeader smsHeader = new SmsHeader();
        smsHeader.portAddrs = portAddrs;
        byte[] smsHeaderData = SmsHeader.toByteArray(smsHeader);
        if (data.length + smsHeaderData.length + 1 > 140) {
            Rlog.e("SmsMessage", "SMS data message may only contain " + (140 - smsHeaderData.length - 1) + " bytes");
            return null;
        }
        SubmitPdu ret = new SubmitPdu();
        ByteArrayOutputStream bo = SmsMessage.getSubmitPduHead(scAddress, destinationAddress, (byte)65, statusReportRequested, ret);
        bo.write(4);
        bo.write(data.length + smsHeaderData.length + 1);
        bo.write(smsHeaderData.length);
        bo.write(smsHeaderData, 0, smsHeaderData.length);
        bo.write(data, 0, data.length);
        ret.encodedMessage = bo.toByteArray();
        return ret;
    }

    private static final ByteArrayOutputStream $$robo$$com_android_internal_telephony_gsm_SmsMessage$getSubmitPduHead(String scAddress, String destinationAddress, byte mtiByte, boolean statusReportRequested, SubmitPdu ret) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream(180);
        ret.encodedScAddress = (byte[])(scAddress == null ? null : PhoneNumberUtils.networkPortionToCalledPartyBCDWithLength(scAddress));
        if (statusReportRequested) {
            mtiByte = (byte)(mtiByte | 0x20);
        }
        bo.write(mtiByte);
        bo.write(0);
        byte[] daBytes = PhoneNumberUtils.networkPortionToCalledPartyBCD(destinationAddress);
        bo.write((daBytes.length - 1) * 2 - ((daBytes[daBytes.length - 1] & 0xF0) == 240 ? 1 : 0));
        bo.write(daBytes, 0, daBytes.length);
        bo.write(0);
        return bo;
    }

    private static final GsmAlphabet.TextEncodingDetails $$robo$$com_android_internal_telephony_gsm_SmsMessage$calculateLength(CharSequence msgBody, boolean use7bitOnly) {
        GsmAlphabet.TextEncodingDetails ted;
        CharSequence newMsgBody = null;
        Resources r = Resources.getSystem();
        if (r.getBoolean(17956987)) {
            newMsgBody = Sms7BitEncodingTranslator.translate(msgBody);
        }
        if (TextUtils.isEmpty(newMsgBody)) {
            newMsgBody = msgBody;
        }
        if ((ted = GsmAlphabet.countGsmSeptets(newMsgBody, use7bitOnly)) == null) {
            ted = new GsmAlphabet.TextEncodingDetails();
            int octets = newMsgBody.length() * 2;
            ted.codeUnitCount = newMsgBody.length();
            if (octets > 140) {
                int max_user_data_bytes_with_header = 134;
                if (!android.telephony.SmsMessage.hasEmsSupport() && octets <= 9 * (max_user_data_bytes_with_header - 2)) {
                    max_user_data_bytes_with_header -= 2;
                }
                ted.msgCount = (octets + (max_user_data_bytes_with_header - 1)) / max_user_data_bytes_with_header;
                ted.codeUnitsRemaining = (ted.msgCount * max_user_data_bytes_with_header - octets) / 2;
            } else {
                ted.msgCount = 1;
                ted.codeUnitsRemaining = (140 - octets) / 2;
            }
            ted.codeUnitSize = 3;
        }
        return ted;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsMessage$getProtocolIdentifier() {
        return this.mProtocolIdentifier;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsMessage$getDataCodingScheme() {
        return this.mDataCodingScheme;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsMessage$isReplace() {
        return (this.mProtocolIdentifier & 0xC0) == 64 && (this.mProtocolIdentifier & 0x3F) > 0 && (this.mProtocolIdentifier & 0x3F) < 8;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsMessage$isCphsMwiMessage() {
        return ((GsmSmsAddress)this.mOriginatingAddress).isCphsVoiceMessageClear() || ((GsmSmsAddress)this.mOriginatingAddress).isCphsVoiceMessageSet();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsMessage$isMWIClearMessage() {
        if (this.mIsMwi && !this.mMwiSense) {
            return true;
        }
        return this.mOriginatingAddress != null && ((GsmSmsAddress)this.mOriginatingAddress).isCphsVoiceMessageClear();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsMessage$isMWISetMessage() {
        if (this.mIsMwi && this.mMwiSense) {
            return true;
        }
        return this.mOriginatingAddress != null && ((GsmSmsAddress)this.mOriginatingAddress).isCphsVoiceMessageSet();
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsMessage$isMwiDontStore() {
        if (this.mIsMwi && this.mMwiDontStore) {
            return true;
        }
        return this.isCphsMwiMessage() && " ".equals(this.getMessageBody());
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsMessage$getStatus() {
        return this.mStatus;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsMessage$isStatusReportMessage() {
        return this.mIsStatusReportMessage;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsMessage$isReplyPathPresent() {
        return this.mReplyPathPresent;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_SmsMessage$parsePdu(byte[] pdu) {
        this.mPdu = pdu;
        PduParser p = new PduParser(pdu);
        this.mScAddress = p.getSCAddress();
        if (this.mScAddress != null) {
            // empty if block
        }
        int firstByte = p.getByte();
        this.mMti = firstByte & 3;
        switch (this.mMti) {
            case 0: 
            case 3: {
                this.parseSmsDeliver(p, firstByte);
                break;
            }
            case 1: {
                this.parseSmsSubmit(p, firstByte);
                break;
            }
            case 2: {
                this.parseSmsStatusReport(p, firstByte);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported message type");
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_SmsMessage$parseSmsStatusReport(PduParser p, int firstByte) {
        this.mIsStatusReportMessage = true;
        this.mMessageRef = p.getByte();
        this.mRecipientAddress = p.getAddress();
        this.mScTimeMillis = p.getSCTimestampMillis();
        p.getSCTimestampMillis();
        this.mStatus = p.getByte();
        if (p.moreDataPresent()) {
            int extraParams;
            int moreExtraParams = extraParams = p.getByte();
            while ((moreExtraParams & 0x80) != 0) {
                moreExtraParams = p.getByte();
            }
            if ((extraParams & 0x78) == 0) {
                if ((extraParams & 1) != 0) {
                    this.mProtocolIdentifier = p.getByte();
                }
                if ((extraParams & 2) != 0) {
                    this.mDataCodingScheme = p.getByte();
                }
                if ((extraParams & 4) != 0) {
                    boolean hasUserDataHeader = (firstByte & 0x40) == 64;
                    this.parseUserData(p, hasUserDataHeader);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_SmsMessage$parseSmsDeliver(PduParser p, int firstByte) {
        this.mReplyPathPresent = (firstByte & 0x80) == 128;
        this.mOriginatingAddress = p.getAddress();
        if (this.mOriginatingAddress != null) {
            // empty if block
        }
        this.mProtocolIdentifier = p.getByte();
        this.mDataCodingScheme = p.getByte();
        this.mScTimeMillis = p.getSCTimestampMillis();
        boolean hasUserDataHeader = (firstByte & 0x40) == 64;
        this.parseUserData(p, hasUserDataHeader);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_SmsMessage$parseSmsSubmit(PduParser p, int firstByte) {
        this.mReplyPathPresent = (firstByte & 0x80) == 128;
        this.mMessageRef = p.getByte();
        this.mRecipientAddress = p.getAddress();
        if (this.mRecipientAddress != null) {
            // empty if block
        }
        this.mProtocolIdentifier = p.getByte();
        this.mDataCodingScheme = p.getByte();
        int validityPeriodLength = 0;
        int validityPeriodFormat = firstByte >> 3 & 3;
        validityPeriodLength = 0 == validityPeriodFormat ? 0 : (2 == validityPeriodFormat ? 1 : 7);
        while (validityPeriodLength-- > 0) {
            p.getByte();
        }
        boolean hasUserDataHeader = (firstByte & 0x40) == 64;
        this.parseUserData(p, hasUserDataHeader);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_SmsMessage$parseUserData(PduParser p, boolean hasUserDataHeader) {
        boolean hasMessageClass = false;
        boolean userDataCompressed = false;
        int encodingType = 0;
        if ((this.mDataCodingScheme & 0x80) == 0) {
            userDataCompressed = 0 != (this.mDataCodingScheme & 0x20);
            boolean bl = hasMessageClass = 0 != (this.mDataCodingScheme & 0x10);
            if (userDataCompressed) {
                Rlog.w("SmsMessage", "4 - Unsupported SMS data coding scheme (compression) " + (this.mDataCodingScheme & 0xFF));
            } else {
                switch (this.mDataCodingScheme >> 2 & 3) {
                    case 0: {
                        encodingType = 1;
                        break;
                    }
                    case 2: {
                        encodingType = 3;
                        break;
                    }
                    case 1: {
                        Resources r = Resources.getSystem();
                        if (r.getBoolean(17956982)) {
                            encodingType = 2;
                            break;
                        }
                    }
                    case 3: {
                        Rlog.w("SmsMessage", "1 - Unsupported SMS data coding scheme " + (this.mDataCodingScheme & 0xFF));
                        encodingType = 2;
                    }
                }
            }
        } else if ((this.mDataCodingScheme & 0xF0) == 240) {
            hasMessageClass = true;
            userDataCompressed = false;
            encodingType = 0 == (this.mDataCodingScheme & 4) ? 1 : 2;
        } else if ((this.mDataCodingScheme & 0xF0) == 192 || (this.mDataCodingScheme & 0xF0) == 208 || (this.mDataCodingScheme & 0xF0) == 224) {
            boolean active;
            encodingType = (this.mDataCodingScheme & 0xF0) == 224 ? 3 : 1;
            userDataCompressed = false;
            boolean bl = active = (this.mDataCodingScheme & 8) == 8;
            if ((this.mDataCodingScheme & 3) == 0) {
                this.mIsMwi = true;
                this.mMwiSense = active;
                this.mMwiDontStore = (this.mDataCodingScheme & 0xF0) == 192;
                this.mVoiceMailCount = active ? -1 : 0;
                Rlog.w("SmsMessage", "MWI in DCS for Vmail. DCS = " + (this.mDataCodingScheme & 0xFF) + " Dont store = " + this.mMwiDontStore + " vmail count = " + this.mVoiceMailCount);
            } else {
                this.mIsMwi = false;
                Rlog.w("SmsMessage", "MWI in DCS for fax/email/other: " + (this.mDataCodingScheme & 0xFF));
            }
        } else if ((this.mDataCodingScheme & 0xC0) == 128) {
            if (this.mDataCodingScheme == 132) {
                encodingType = 4;
            } else {
                Rlog.w("SmsMessage", "5 - Unsupported SMS data coding scheme " + (this.mDataCodingScheme & 0xFF));
            }
        } else {
            Rlog.w("SmsMessage", "3 - Unsupported SMS data coding scheme " + (this.mDataCodingScheme & 0xFF));
        }
        int count = p.constructUserData(hasUserDataHeader, encodingType == 1);
        this.mUserData = p.getUserData();
        this.mUserDataHeader = p.getUserDataHeader();
        if (hasUserDataHeader && this.mUserDataHeader.specialSmsMsgList.size() != 0) {
            for (SmsHeader.SpecialSmsMsg msg : this.mUserDataHeader.specialSmsMsgList) {
                int msgInd = msg.msgIndType & 0xFF;
                if (msgInd == 0 || msgInd == 128) {
                    this.mIsMwi = true;
                    if (msgInd == 128) {
                        this.mMwiDontStore = false;
                    } else if (!this.mMwiDontStore && ((this.mDataCodingScheme & 0xF0) != 208 && (this.mDataCodingScheme & 0xF0) != 224 || (this.mDataCodingScheme & 3) != 0)) {
                        this.mMwiDontStore = true;
                    }
                    this.mVoiceMailCount = msg.msgCount & 0xFF;
                    this.mMwiSense = this.mVoiceMailCount > 0;
                    Rlog.w("SmsMessage", "MWI in TP-UDH for Vmail. Msg Ind = " + msgInd + " Dont store = " + this.mMwiDontStore + " Vmail count = " + this.mVoiceMailCount);
                    continue;
                }
                Rlog.w("SmsMessage", "TP_UDH fax/email/extended msg/multisubscriber profile. Msg Ind = " + msgInd);
            }
        }
        switch (encodingType) {
            case 0: {
                this.mMessageBody = null;
                break;
            }
            case 2: {
                Resources r = Resources.getSystem();
                if (r.getBoolean(17956982)) {
                    this.mMessageBody = p.getUserDataGSM8bit(count);
                    break;
                }
                this.mMessageBody = null;
                break;
            }
            case 1: {
                this.mMessageBody = p.getUserDataGSM7Bit(count, hasUserDataHeader ? this.mUserDataHeader.languageTable : 0, hasUserDataHeader ? this.mUserDataHeader.languageShiftTable : 0);
                break;
            }
            case 3: {
                this.mMessageBody = p.getUserDataUCS2(count);
                break;
            }
            case 4: {
                this.mMessageBody = p.getUserDataKSC5601(count);
            }
        }
        if (this.mMessageBody != null) {
            this.parseMessageBody();
        }
        if (!hasMessageClass) {
            this.messageClass = SmsConstants.MessageClass.UNKNOWN;
        } else {
            switch (this.mDataCodingScheme & 3) {
                case 0: {
                    this.messageClass = SmsConstants.MessageClass.CLASS_0;
                    break;
                }
                case 1: {
                    this.messageClass = SmsConstants.MessageClass.CLASS_1;
                    break;
                }
                case 2: {
                    this.messageClass = SmsConstants.MessageClass.CLASS_2;
                    break;
                }
                case 3: {
                    this.messageClass = SmsConstants.MessageClass.CLASS_3;
                }
            }
        }
    }

    private final SmsConstants.MessageClass $$robo$$com_android_internal_telephony_gsm_SmsMessage$getMessageClass() {
        return this.messageClass;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsMessage$isUsimDataDownload() {
        return this.messageClass == SmsConstants.MessageClass.CLASS_2 && (this.mProtocolIdentifier == 127 || this.mProtocolIdentifier == 124);
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsMessage$getNumOfVoicemails() {
        if (!this.mIsMwi && this.isCphsMwiMessage()) {
            this.mVoiceMailCount = this.mOriginatingAddress != null && ((GsmSmsAddress)this.mOriginatingAddress).isCphsVoiceMessageSet() ? 255 : 0;
            Rlog.v("SmsMessage", "CPHS voice mail message");
        }
        return this.mVoiceMailCount;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_gsm_SmsMessage$__constructor__();
    }

    public SmsMessage() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_SmsMessage$__constructor__(), 0, this);
    }

    public static SmsMessage createFromPdu(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromPdu", $$robo$$com_android_internal_telephony_gsm_SmsMessage$createFromPdu(byte[] ), 0, (byte[])byArray);
    }

    public boolean isTypeZero() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTypeZero", $$robo$$com_android_internal_telephony_gsm_SmsMessage$isTypeZero(), 0, this);
    }

    public static SmsMessage newFromCMT(String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("newFromCMT", $$robo$$com_android_internal_telephony_gsm_SmsMessage$newFromCMT(java.lang.String[] ), 0, (String[])stringArray);
    }

    public static SmsMessage newFromCDS(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("newFromCDS", $$robo$$com_android_internal_telephony_gsm_SmsMessage$newFromCDS(java.lang.String ), 0, (String)string2);
    }

    public static SmsMessage createFromEfRecord(int n, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromEfRecord", $$robo$$com_android_internal_telephony_gsm_SmsMessage$createFromEfRecord(int byte[] ), 0, (int)n, (byte[])byArray);
    }

    public static int getTPLayerLengthForPDU(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTPLayerLengthForPDU", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getTPLayerLengthForPDU(java.lang.String ), 0, (String)string2);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("getSubmitPdu", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getSubmitPdu(java.lang.String java.lang.String java.lang.String boolean byte[] ), 0, (String)string2, (String)string3, (String)string4, (boolean)bl, (byte[])byArray);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl, byte[] byArray, int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("getSubmitPdu", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getSubmitPdu(java.lang.String java.lang.String java.lang.String boolean byte[] int int int ), 0, (String)string2, (String)string3, (String)string4, (boolean)bl, (byte[])byArray, (int)n, (int)n2, (int)n3);
    }

    private static byte[] encodeUCS2(String string2, byte[] byArray) throws UnsupportedEncodingException {
        return InvokeDynamicSupport.bootstrapStatic("encodeUCS2", $$robo$$com_android_internal_telephony_gsm_SmsMessage$encodeUCS2(java.lang.String byte[] ), 0, (String)string2, (byte[])byArray);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getSubmitPdu", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getSubmitPdu(java.lang.String java.lang.String java.lang.String boolean ), 0, (String)string2, (String)string3, (String)string4, (boolean)bl);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, int n, byte[] byArray, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getSubmitPdu", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getSubmitPdu(java.lang.String java.lang.String int byte[] boolean ), 0, (String)string2, (String)string3, (int)n, (byte[])byArray, (boolean)bl);
    }

    private static ByteArrayOutputStream getSubmitPduHead(String string2, String string3, byte by, boolean bl, SubmitPdu submitPdu) {
        return InvokeDynamicSupport.bootstrapStatic("getSubmitPduHead", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getSubmitPduHead(java.lang.String java.lang.String byte boolean com.android.internal.telephony.gsm.SmsMessage$SubmitPdu ), 0, (String)string2, (String)string3, (byte)by, (boolean)bl, (SubmitPdu)submitPdu);
    }

    public static GsmAlphabet.TextEncodingDetails calculateLength(CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("calculateLength", $$robo$$com_android_internal_telephony_gsm_SmsMessage$calculateLength(java.lang.CharSequence boolean ), 0, (CharSequence)charSequence, (boolean)bl);
    }

    @Override
    public int getProtocolIdentifier() {
        return (int)InvokeDynamicSupport.bootstrap("getProtocolIdentifier", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getProtocolIdentifier(), 0, this);
    }

    int getDataCodingScheme() {
        return (int)InvokeDynamicSupport.bootstrap("getDataCodingScheme", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getDataCodingScheme(), 0, this);
    }

    @Override
    public boolean isReplace() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReplace", $$robo$$com_android_internal_telephony_gsm_SmsMessage$isReplace(), 0, this);
    }

    @Override
    public boolean isCphsMwiMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCphsMwiMessage", $$robo$$com_android_internal_telephony_gsm_SmsMessage$isCphsMwiMessage(), 0, this);
    }

    @Override
    public boolean isMWIClearMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMWIClearMessage", $$robo$$com_android_internal_telephony_gsm_SmsMessage$isMWIClearMessage(), 0, this);
    }

    @Override
    public boolean isMWISetMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMWISetMessage", $$robo$$com_android_internal_telephony_gsm_SmsMessage$isMWISetMessage(), 0, this);
    }

    @Override
    public boolean isMwiDontStore() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMwiDontStore", $$robo$$com_android_internal_telephony_gsm_SmsMessage$isMwiDontStore(), 0, this);
    }

    @Override
    public int getStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStatus", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getStatus(), 0, this);
    }

    @Override
    public boolean isStatusReportMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStatusReportMessage", $$robo$$com_android_internal_telephony_gsm_SmsMessage$isStatusReportMessage(), 0, this);
    }

    @Override
    public boolean isReplyPathPresent() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReplyPathPresent", $$robo$$com_android_internal_telephony_gsm_SmsMessage$isReplyPathPresent(), 0, this);
    }

    private void parsePdu(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("parsePdu", $$robo$$com_android_internal_telephony_gsm_SmsMessage$parsePdu(byte[] ), 0, this, byArray);
    }

    private void parseSmsStatusReport(PduParser pduParser, int n) {
        InvokeDynamicSupport.bootstrap("parseSmsStatusReport", $$robo$$com_android_internal_telephony_gsm_SmsMessage$parseSmsStatusReport(com.android.internal.telephony.gsm.SmsMessage$PduParser int ), 0, this, pduParser, n);
    }

    private void parseSmsDeliver(PduParser pduParser, int n) {
        InvokeDynamicSupport.bootstrap("parseSmsDeliver", $$robo$$com_android_internal_telephony_gsm_SmsMessage$parseSmsDeliver(com.android.internal.telephony.gsm.SmsMessage$PduParser int ), 0, this, pduParser, n);
    }

    private void parseSmsSubmit(PduParser pduParser, int n) {
        InvokeDynamicSupport.bootstrap("parseSmsSubmit", $$robo$$com_android_internal_telephony_gsm_SmsMessage$parseSmsSubmit(com.android.internal.telephony.gsm.SmsMessage$PduParser int ), 0, this, pduParser, n);
    }

    private void parseUserData(PduParser pduParser, boolean bl) {
        InvokeDynamicSupport.bootstrap("parseUserData", $$robo$$com_android_internal_telephony_gsm_SmsMessage$parseUserData(com.android.internal.telephony.gsm.SmsMessage$PduParser boolean ), 0, this, pduParser, bl);
    }

    @Override
    public SmsConstants.MessageClass getMessageClass() {
        return InvokeDynamicSupport.bootstrap("getMessageClass", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getMessageClass(), 0, this);
    }

    boolean isUsimDataDownload() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsimDataDownload", $$robo$$com_android_internal_telephony_gsm_SmsMessage$isUsimDataDownload(), 0, this);
    }

    public int getNumOfVoicemails() {
        return (int)InvokeDynamicSupport.bootstrap("getNumOfVoicemails", $$robo$$com_android_internal_telephony_gsm_SmsMessage$getNumOfVoicemails(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsMessage)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class PduParser
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        byte[] mPdu;
        int mCur;
        SmsHeader mUserDataHeader;
        byte[] mUserData;
        int mUserDataSeptetPadding;

        private void $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$__constructor__(byte[] pdu) {
            this.mPdu = pdu;
            this.mCur = 0;
            this.mUserDataSeptetPadding = 0;
        }

        private final String $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getSCAddress() {
            String ret;
            int len = this.getByte();
            if (len == 0) {
                ret = null;
            } else {
                try {
                    ret = PhoneNumberUtils.calledPartyBCDToString(this.mPdu, this.mCur, len);
                }
                catch (RuntimeException tr) {
                    Rlog.d("SmsMessage", "invalid SC address: ", tr);
                    ret = null;
                }
            }
            this.mCur += len;
            return ret;
        }

        private final int $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getByte() {
            return this.mPdu[this.mCur++] & 0xFF;
        }

        private final GsmSmsAddress $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getAddress() {
            GsmSmsAddress ret;
            int addressLength = this.mPdu[this.mCur] & 0xFF;
            int lengthBytes = 2 + (addressLength + 1) / 2;
            try {
                ret = new GsmSmsAddress(this.mPdu, this.mCur, lengthBytes);
            }
            catch (ParseException e) {
                Object ret2 = null;
                throw new RuntimeException(e.getMessage());
            }
            this.mCur += lengthBytes;
            return ret;
        }

        private final long $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getSCTimestampMillis() {
            int year = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            int month = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            int day = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            int hour = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            int minute = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            int second = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            byte tzByte = this.mPdu[this.mCur++];
            int timezoneOffset = IccUtils.gsmBcdByteToInt((byte)(tzByte & 0xFFFFFFF7));
            timezoneOffset = (tzByte & 8) == 0 ? timezoneOffset : -timezoneOffset;
            Time time = new Time("UTC");
            time.year = year >= 90 ? year + 1900 : year + 2000;
            time.month = month - 1;
            time.monthDay = day;
            time.hour = hour;
            time.minute = minute;
            time.second = second;
            return time.toMillis(true) - (long)(timezoneOffset * 15 * 60 * 1000);
        }

        private final int $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$constructUserData(boolean hasUserDataHeader, boolean dataInSeptets) {
            int bufferLen;
            int offset = this.mCur;
            int userDataLength = this.mPdu[offset++] & 0xFF;
            int headerSeptets = 0;
            int userDataHeaderLength = 0;
            if (hasUserDataHeader) {
                userDataHeaderLength = this.mPdu[offset++] & 0xFF;
                byte[] udh = new byte[userDataHeaderLength];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mPdu, (int)offset, (byte[])udh, (int)0, (int)userDataHeaderLength);
                this.mUserDataHeader = SmsHeader.fromByteArray(udh);
                offset += userDataHeaderLength;
                int headerBits = (userDataHeaderLength + 1) * 8;
                headerSeptets = headerBits / 7;
                this.mUserDataSeptetPadding = (headerSeptets += headerBits % 7 > 0 ? 1 : 0) * 7 - headerBits;
            }
            if (dataInSeptets) {
                bufferLen = this.mPdu.length - offset;
            } else {
                bufferLen = userDataLength - (hasUserDataHeader ? userDataHeaderLength + 1 : 0);
                if (bufferLen < 0) {
                    bufferLen = 0;
                }
            }
            this.mUserData = new byte[bufferLen];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mPdu, (int)offset, (byte[])this.mUserData, (int)0, (int)this.mUserData.length);
            this.mCur = offset;
            if (dataInSeptets) {
                int count = userDataLength - headerSeptets;
                return count < 0 ? 0 : count;
            }
            return this.mUserData.length;
        }

        private final byte[] $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserData() {
            return this.mUserData;
        }

        private final SmsHeader $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserDataHeader() {
            return this.mUserDataHeader;
        }

        private final String $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserDataGSM7Bit(int septetCount, int languageTable, int languageShiftTable) {
            String ret = GsmAlphabet.gsm7BitPackedToString(this.mPdu, this.mCur, septetCount, this.mUserDataSeptetPadding, languageTable, languageShiftTable);
            this.mCur += septetCount * 7 / 8;
            return ret;
        }

        private final String $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserDataGSM8bit(int byteCount) {
            String ret = GsmAlphabet.gsm8BitUnpackedToString(this.mPdu, this.mCur, byteCount);
            this.mCur += byteCount;
            return ret;
        }

        private final String $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserDataUCS2(int byteCount) {
            String ret;
            try {
                ret = new String(this.mPdu, this.mCur, byteCount, "utf-16");
            }
            catch (UnsupportedEncodingException ex) {
                ret = "";
                Rlog.e("SmsMessage", "implausible UnsupportedEncodingException", ex);
            }
            this.mCur += byteCount;
            return ret;
        }

        private final String $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserDataKSC5601(int byteCount) {
            String ret;
            try {
                ret = new String(this.mPdu, this.mCur, byteCount, "KSC5601");
            }
            catch (UnsupportedEncodingException ex) {
                ret = "";
                Rlog.e("SmsMessage", "implausible UnsupportedEncodingException", ex);
            }
            this.mCur += byteCount;
            return ret;
        }

        private final boolean $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$moreDataPresent() {
            return this.mPdu.length > this.mCur;
        }

        private void __constructor__(byte[] byArray) {
            this.$$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$__constructor__(byArray);
        }

        PduParser(byte[] byArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$__constructor__(byte[] ), 0, this, byArray);
        }

        String getSCAddress() {
            return InvokeDynamicSupport.bootstrap("getSCAddress", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getSCAddress(), 0, this);
        }

        int getByte() {
            return (int)InvokeDynamicSupport.bootstrap("getByte", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getByte(), 0, this);
        }

        GsmSmsAddress getAddress() {
            return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getAddress(), 0, this);
        }

        long getSCTimestampMillis() {
            return (long)InvokeDynamicSupport.bootstrap("getSCTimestampMillis", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getSCTimestampMillis(), 0, this);
        }

        int constructUserData(boolean bl, boolean bl2) {
            return (int)InvokeDynamicSupport.bootstrap("constructUserData", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$constructUserData(boolean boolean ), 0, this, bl, bl2);
        }

        byte[] getUserData() {
            return InvokeDynamicSupport.bootstrap("getUserData", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserData(), 0, this);
        }

        SmsHeader getUserDataHeader() {
            return InvokeDynamicSupport.bootstrap("getUserDataHeader", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserDataHeader(), 0, this);
        }

        String getUserDataGSM7Bit(int n, int n2, int n3) {
            return InvokeDynamicSupport.bootstrap("getUserDataGSM7Bit", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserDataGSM7Bit(int int int ), 0, this, n, n2, n3);
        }

        String getUserDataGSM8bit(int n) {
            return InvokeDynamicSupport.bootstrap("getUserDataGSM8bit", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserDataGSM8bit(int ), 0, this, n);
        }

        String getUserDataUCS2(int n) {
            return InvokeDynamicSupport.bootstrap("getUserDataUCS2", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserDataUCS2(int ), 0, this, n);
        }

        String getUserDataKSC5601(int n) {
            return InvokeDynamicSupport.bootstrap("getUserDataKSC5601", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$getUserDataKSC5601(int ), 0, this, n);
        }

        boolean moreDataPresent() {
            return (boolean)InvokeDynamicSupport.bootstrap("moreDataPresent", $$robo$$com_android_internal_telephony_gsm_SmsMessage_PduParser$moreDataPresent(), 0, this);
        }

        public /* synthetic */ PduParser() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PduParser)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SubmitPdu
    extends SmsMessageBase.SubmitPduBase
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_telephony_gsm_SmsMessage_SubmitPdu$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_gsm_SmsMessage_SubmitPdu$__constructor__();
        }

        public SubmitPdu() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_SmsMessage_SubmitPdu$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubmitPdu)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

