/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.IccConstants;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UsimPhoneBookManager
extends Handler
implements IccConstants,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "UsimPhoneBookManager";
    private static boolean DBG = true;
    private PbrFile mPbrFile;
    private Boolean mIsPbrPresent;
    private IccFileHandler mFh;
    private AdnRecordCache mAdnCache;
    private Object mLock;
    private ArrayList<AdnRecord> mPhoneBookRecords;
    private boolean mEmailPresentInIap;
    private int mEmailTagNumberInIap;
    private ArrayList<byte[]> mIapFileRecord;
    private ArrayList<byte[]> mEmailFileRecord;
    private Map<Integer, ArrayList<String>> mEmailsForAdnRec;
    private boolean mRefreshCache;
    private static int EVENT_PBR_LOAD_DONE = 1;
    private static int EVENT_USIM_ADN_LOAD_DONE = 2;
    private static int EVENT_IAP_LOAD_DONE = 3;
    private static int EVENT_EMAIL_LOAD_DONE = 4;
    private static int USIM_TYPE1_TAG = 168;
    private static int USIM_TYPE2_TAG = 169;
    private static int USIM_TYPE3_TAG = 170;
    private static int USIM_EFADN_TAG = 192;
    private static int USIM_EFIAP_TAG = 193;
    private static int USIM_EFEXT1_TAG = 194;
    private static int USIM_EFSNE_TAG = 195;
    private static int USIM_EFANR_TAG = 196;
    private static int USIM_EFPBC_TAG = 197;
    private static int USIM_EFGRP_TAG = 198;
    private static int USIM_EFAAS_TAG = 199;
    private static int USIM_EFGSD_TAG = 200;
    private static int USIM_EFUID_TAG = 201;
    private static int USIM_EFEMAIL_TAG = 202;
    private static int USIM_EFCCP1_TAG = 203;

    private void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$__constructor__(IccFileHandler fh, AdnRecordCache cache) {
        this.mLock = new Object();
        this.mEmailPresentInIap = false;
        this.mEmailTagNumberInIap = 0;
        this.mRefreshCache = false;
        this.mFh = fh;
        this.mPhoneBookRecords = new ArrayList();
        this.mPbrFile = null;
        this.mIsPbrPresent = true;
        this.mAdnCache = cache;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$reset() {
        this.mPhoneBookRecords.clear();
        this.mIapFileRecord = null;
        this.mEmailFileRecord = null;
        this.mPbrFile = null;
        this.mIsPbrPresent = true;
        this.mRefreshCache = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArrayList<AdnRecord> $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$loadEfFilesFromUsim() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mPhoneBookRecords.isEmpty()) {
                if (this.mRefreshCache) {
                    this.mRefreshCache = false;
                    this.refreshCache();
                }
                return this.mPhoneBookRecords;
            }
            if (!this.mIsPbrPresent.booleanValue()) {
                return null;
            }
            if (this.mPbrFile == null) {
                this.readPbrFileAndWait();
            }
            if (this.mPbrFile == null) {
                return null;
            }
            int numRecs = this.mPbrFile.mFileIds.size();
            for (int i = 0; i < numRecs; ++i) {
                this.readAdnFileAndWait(i);
                this.readEmailFileAndWait(i);
            }
        }
        return this.mPhoneBookRecords;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$refreshCache() {
        if (this.mPbrFile == null) {
            return;
        }
        this.mPhoneBookRecords.clear();
        int numRecs = this.mPbrFile.mFileIds.size();
        for (int i = 0; i < numRecs; ++i) {
            this.readAdnFileAndWait(i);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$invalidateCache() {
        this.mRefreshCache = true;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readPbrFileAndWait() {
        this.mFh.loadEFLinearFixedAll(20272, this.obtainMessage(1));
        try {
            this.mLock.wait();
        }
        catch (InterruptedException e) {
            Rlog.e("UsimPhoneBookManager", "Interrupted Exception in readAdnFileAndWait");
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readEmailFileAndWait(int recNum) {
        Map<Integer, Integer> fileIds = this.mPbrFile.mFileIds.get(recNum);
        if (fileIds == null) {
            return;
        }
        if (fileIds.containsKey(202)) {
            int efid = fileIds.get(202);
            if (this.mEmailPresentInIap) {
                this.readIapFileAndWait(fileIds.get(193));
                if (this.mIapFileRecord == null) {
                    Rlog.e("UsimPhoneBookManager", "Error: IAP file is empty");
                    return;
                }
            }
            this.mFh.loadEFLinearFixedAll(fileIds.get(202), this.obtainMessage(4));
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                Rlog.e("UsimPhoneBookManager", "Interrupted Exception in readEmailFileAndWait");
            }
            if (this.mEmailFileRecord == null) {
                Rlog.e("UsimPhoneBookManager", "Error: Email file is empty");
                return;
            }
            this.updatePhoneAdnRecord();
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readIapFileAndWait(int efid) {
        this.mFh.loadEFLinearFixedAll(efid, this.obtainMessage(3));
        try {
            this.mLock.wait();
        }
        catch (InterruptedException e) {
            Rlog.e("UsimPhoneBookManager", "Interrupted Exception in readIapFileAndWait");
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$updatePhoneAdnRecord() {
        if (this.mEmailFileRecord == null) {
            return;
        }
        int numAdnRecs = this.mPhoneBookRecords.size();
        if (this.mIapFileRecord != null) {
            for (int i = 0; i < numAdnRecs; ++i) {
                byte[] record = null;
                try {
                    record = this.mIapFileRecord.get(i);
                }
                catch (IndexOutOfBoundsException e) {
                    Rlog.e("UsimPhoneBookManager", "Error: Improper ICC card: No IAP record for ADN, continuing");
                    break;
                }
                byte recNum = record[this.mEmailTagNumberInIap];
                if (recNum == -1) continue;
                String[] emails = new String[]{this.readEmailRecord(recNum - 1)};
                AdnRecord rec = this.mPhoneBookRecords.get(i);
                if (rec != null) {
                    rec.setEmails(emails);
                } else {
                    rec = new AdnRecord("", "", emails);
                }
                this.mPhoneBookRecords.set(i, rec);
            }
        }
        int len = this.mPhoneBookRecords.size();
        if (this.mEmailsForAdnRec == null) {
            this.parseType1EmailFile(len);
        }
        for (int i = 0; i < numAdnRecs; ++i) {
            ArrayList<String> emailList = null;
            try {
                emailList = this.mEmailsForAdnRec.get(i);
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            if (emailList == null) continue;
            AdnRecord rec = this.mPhoneBookRecords.get(i);
            String[] emails = new String[emailList.size()];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)emailList.toArray(), (int)0, (Object)emails, (int)0, (int)emailList.size());
            rec.setEmails(emails);
            this.mPhoneBookRecords.set(i, rec);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$parseType1EmailFile(int numRecs) {
        this.mEmailsForAdnRec = new HashMap<Integer, ArrayList<String>>();
        byte[] emailRec = null;
        for (int i = 0; i < numRecs; ++i) {
            String email;
            try {
                emailRec = this.mEmailFileRecord.get(i);
            }
            catch (IndexOutOfBoundsException e) {
                Rlog.e("UsimPhoneBookManager", "Error: Improper ICC card: No email record for ADN, continuing");
                break;
            }
            byte adnRecNum = emailRec[emailRec.length - 1];
            if (adnRecNum == -1 || (email = this.readEmailRecord(i)) == null || email.equals("")) continue;
            ArrayList<String> val = this.mEmailsForAdnRec.get(adnRecNum - 1);
            if (val == null) {
                val = new ArrayList();
            }
            val.add(email);
            this.mEmailsForAdnRec.put(adnRecNum - 1, val);
        }
    }

    private final String $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readEmailRecord(int recNum) {
        byte[] emailRec = null;
        try {
            emailRec = this.mEmailFileRecord.get(recNum);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        String email = IccUtils.adnStringFieldToString(emailRec, 0, emailRec.length - 2);
        return email;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readAdnFileAndWait(int recNum) {
        Map<Integer, Integer> fileIds = this.mPbrFile.mFileIds.get(recNum);
        if (fileIds == null || fileIds.isEmpty()) {
            return;
        }
        int extEf = 0;
        if (fileIds.containsKey(194)) {
            extEf = fileIds.get(194);
        }
        this.mAdnCache.requestLoadAllAdnLike(fileIds.get(192), extEf, this.obtainMessage(2));
        try {
            this.mLock.wait();
        }
        catch (InterruptedException e) {
            Rlog.e("UsimPhoneBookManager", "Interrupted Exception in readAdnFileAndWait");
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$createPbrFile(ArrayList<byte[]> records) {
        if (records == null) {
            this.mPbrFile = null;
            this.mIsPbrPresent = false;
            return;
        }
        this.mPbrFile = new PbrFile(this, records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.createPbrFile((ArrayList)ar.result);
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case 2: {
                this.log("Loading USIM ADN records done");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mPhoneBookRecords.addAll((ArrayList)ar.result);
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case 3: {
                this.log("Loading USIM IAP records done");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mIapFileRecord = (ArrayList)ar.result;
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case 4: {
                this.log("Loading USIM Email records done");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mEmailFileRecord = (ArrayList)ar.result;
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$log(String msg) {
        Rlog.d("UsimPhoneBookManager", msg);
    }

    private void __constructor__(IccFileHandler iccFileHandler, AdnRecordCache adnRecordCache) {
        this.$$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$__constructor__(iccFileHandler, adnRecordCache);
    }

    public UsimPhoneBookManager(IccFileHandler iccFileHandler, AdnRecordCache adnRecordCache) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$__constructor__(com.android.internal.telephony.uicc.IccFileHandler com.android.internal.telephony.uicc.AdnRecordCache ), 0, this, iccFileHandler, adnRecordCache);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$reset(), 0, this);
    }

    public ArrayList<AdnRecord> loadEfFilesFromUsim() {
        return InvokeDynamicSupport.bootstrap("loadEfFilesFromUsim", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$loadEfFilesFromUsim(), 0, this);
    }

    private void refreshCache() {
        InvokeDynamicSupport.bootstrap("refreshCache", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$refreshCache(), 0, this);
    }

    public void invalidateCache() {
        InvokeDynamicSupport.bootstrap("invalidateCache", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$invalidateCache(), 0, this);
    }

    private void readPbrFileAndWait() {
        InvokeDynamicSupport.bootstrap("readPbrFileAndWait", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readPbrFileAndWait(), 0, this);
    }

    private void readEmailFileAndWait(int n) {
        InvokeDynamicSupport.bootstrap("readEmailFileAndWait", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readEmailFileAndWait(int ), 0, this, n);
    }

    private void readIapFileAndWait(int n) {
        InvokeDynamicSupport.bootstrap("readIapFileAndWait", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readIapFileAndWait(int ), 0, this, n);
    }

    private void updatePhoneAdnRecord() {
        InvokeDynamicSupport.bootstrap("updatePhoneAdnRecord", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$updatePhoneAdnRecord(), 0, this);
    }

    void parseType1EmailFile(int n) {
        InvokeDynamicSupport.bootstrap("parseType1EmailFile", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$parseType1EmailFile(int ), 0, this, n);
    }

    private String readEmailRecord(int n) {
        return InvokeDynamicSupport.bootstrap("readEmailRecord", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readEmailRecord(int ), 0, this, n);
    }

    private void readAdnFileAndWait(int n) {
        InvokeDynamicSupport.bootstrap("readAdnFileAndWait", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readAdnFileAndWait(int ), 0, this, n);
    }

    private void createPbrFile(ArrayList<byte[]> arrayList) {
        InvokeDynamicSupport.bootstrap("createPbrFile", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$createPbrFile(java.util.ArrayList<byte[]> ), 0, this, arrayList);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$handleMessage(android.os.Message ), 0, this, message);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$log(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ UsimPhoneBookManager() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsimPhoneBookManager)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class PbrFile
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        HashMap<Integer, Map<Integer, Integer>> mFileIds;
        /* synthetic */ UsimPhoneBookManager this$0;

        private void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrFile$__constructor__(UsimPhoneBookManager usimPhoneBookManager, ArrayList<byte[]> records) {
            this.mFileIds = new HashMap();
            int recNum = 0;
            for (byte[] record : records) {
                SimTlv recTlv = new SimTlv(record, 0, record.length);
                this.parseTag(recTlv, recNum);
                ++recNum;
            }
        }

        private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrFile$parseTag(SimTlv tlv, int recNum) {
            HashMap<Integer, Integer> val = new HashMap<Integer, Integer>();
            do {
                int tag = tlv.getTag();
                switch (tag) {
                    case 168: 
                    case 169: 
                    case 170: {
                        byte[] data = tlv.getData();
                        SimTlv tlvEf = new SimTlv(data, 0, data.length);
                        this.parseEf(tlvEf, val, tag);
                    }
                }
            } while (tlv.nextObject());
            this.mFileIds.put(recNum, val);
        }

        private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrFile$parseEf(SimTlv tlv, Map<Integer, Integer> val, int parentTag) {
            int tagNumberWithinParentTag = 0;
            do {
                int tag = tlv.getTag();
                if (parentTag == 169 && tag == 202) {
                    this.this$0.mEmailPresentInIap = true;
                    this.this$0.mEmailTagNumberInIap = tagNumberWithinParentTag;
                }
                switch (tag) {
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: {
                        byte[] data = tlv.getData();
                        int efid = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
                        val.put(tag, efid);
                    }
                }
                ++tagNumberWithinParentTag;
            } while (tlv.nextObject());
        }

        private void __constructor__(UsimPhoneBookManager usimPhoneBookManager, ArrayList<byte[]> arrayList) {
            this.$$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrFile$__constructor__(usimPhoneBookManager, arrayList);
        }

        PbrFile(UsimPhoneBookManager usimPhoneBookManager, ArrayList<byte[]> arrayList) {
            this.this$0 = usimPhoneBookManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrFile$__constructor__(com.android.internal.telephony.gsm.UsimPhoneBookManager java.util.ArrayList<byte[]> ), 0, this, usimPhoneBookManager, arrayList);
        }

        void parseTag(SimTlv simTlv, int n) {
            InvokeDynamicSupport.bootstrap("parseTag", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrFile$parseTag(com.android.internal.telephony.gsm.SimTlv int ), 0, this, simTlv, n);
        }

        void parseEf(SimTlv simTlv, Map<Integer, Integer> map, int n) {
            InvokeDynamicSupport.bootstrap("parseEf", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrFile$parseEf(com.android.internal.telephony.gsm.SimTlv java.util.Map<java.lang.Integer, java.lang.Integer> int ), 0, this, simTlv, map, n);
        }

        public /* synthetic */ PbrFile() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PbrFile)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

