/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.telephony.Rlog;
import com.android.ims.ImsCall;
import com.android.ims.ImsException;
import com.android.ims.ImsStreamMediaProfile;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsPhoneCall
extends Call
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsPhoneCall";
    ImsPhoneCallTracker mOwner;
    private boolean mRingbackTonePlayed;

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__() {
        this.mRingbackTonePlayed = false;
    }

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__(ImsPhoneCallTracker owner) {
        this.mRingbackTonePlayed = false;
        this.mOwner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$dispose() {
        try {
            this.mOwner.hangup(this);
        }
        catch (CallStateException i) {
            int s = this.mConnections.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ImsPhoneConnection c = (ImsPhoneConnection)this.mConnections.get(i2);
                c.onDisconnect(14);
            }
        }
        finally {
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                ImsPhoneConnection c = (ImsPhoneConnection)this.mConnections.get(i);
                c.onDisconnect(14);
            }
        }
    }

    private final List<Connection> $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getConnections() {
        return this.mConnections;
    }

    private final Phone $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getPhone() {
        return this.mOwner.mPhone;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isMultiparty() {
        return this.mConnections.size() > 1;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$hangup() throws CallStateException {
        this.mOwner.hangup(this);
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$toString() {
        return this.mState.toString();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attach(Connection conn) {
        this.clearDisconnected();
        this.mConnections.add(conn);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attach(Connection conn, Call.State state) {
        this.attach(conn);
        this.mState = state;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attachFake(Connection conn, Call.State state) {
        this.attach(conn, state);
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$connectionDisconnected(ImsPhoneConnection conn) {
        if (this.mState != Call.State.DISCONNECTED) {
            boolean hasOnlyDisconnectedConnections = true;
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                if (((Connection)this.mConnections.get(i)).getState() == Call.State.DISCONNECTED) continue;
                hasOnlyDisconnectedConnections = false;
                break;
            }
            if (hasOnlyDisconnectedConnections) {
                this.mState = Call.State.DISCONNECTED;
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$detach(ImsPhoneConnection conn) {
        this.mConnections.remove(conn);
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isFull() {
        return this.mConnections.size() == 5;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$onHangupLocal() {
        int s = this.mConnections.size();
        for (int i = 0; i < s; ++i) {
            ImsPhoneConnection cn = (ImsPhoneConnection)this.mConnections.get(i);
            cn.onHangupLocal();
        }
        this.mState = Call.State.DISCONNECTING;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$clearDisconnected() {
        for (int i = this.mConnections.size() - 1; i >= 0; --i) {
            ImsPhoneConnection cn = (ImsPhoneConnection)this.mConnections.get(i);
            if (cn.getState() != Call.State.DISCONNECTED) continue;
            this.mConnections.remove(i);
        }
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }

    private final ImsPhoneConnection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getFirstConnection() {
        if (this.mConnections.size() == 0) {
            return null;
        }
        return (ImsPhoneConnection)this.mConnections.get(0);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$setMute(boolean mute) {
        ImsCall imsCall;
        ImsCall imsCall2 = imsCall = this.getFirstConnection() == null ? null : this.getFirstConnection().getImsCall();
        if (imsCall != null) {
            try {
                imsCall.setMute(mute);
            }
            catch (ImsException e) {
                Rlog.e("ImsPhoneCall", "setMute failed : " + e.getMessage());
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$merge(ImsPhoneCall that, Call.State state) {
        ImsPhoneConnection[] cc;
        for (ImsPhoneConnection c : cc = that.mConnections.toArray(new ImsPhoneConnection[that.mConnections.size()])) {
            c.update(null, state);
        }
    }

    private final ImsCall $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getImsCall() {
        return this.getFirstConnection() == null ? null : this.getFirstConnection().getImsCall();
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isLocalTone(ImsCall imsCall) {
        if (imsCall == null || imsCall.getCallProfile() == null || imsCall.getCallProfile().mMediaProfile == null) {
            return false;
        }
        ImsStreamMediaProfile mediaProfile = imsCall.getCallProfile().mMediaProfile;
        return mediaProfile.mAudioDirection == 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$update(ImsPhoneConnection conn, ImsCall imsCall, Call.State state) {
        Call.State newState = state;
        boolean changed = false;
        if (state == Call.State.ALERTING) {
            if (this.mRingbackTonePlayed && !ImsPhoneCall.isLocalTone(imsCall)) {
                this.mOwner.mPhone.stopRingbackTone();
                this.mRingbackTonePlayed = false;
            } else if (!this.mRingbackTonePlayed && ImsPhoneCall.isLocalTone(imsCall)) {
                this.mOwner.mPhone.startRingbackTone();
                this.mRingbackTonePlayed = true;
            }
        } else if (this.mRingbackTonePlayed) {
            this.mOwner.mPhone.stopRingbackTone();
            this.mRingbackTonePlayed = false;
        }
        if (newState != this.mState && state != Call.State.DISCONNECTED) {
            this.mState = newState;
            changed = true;
        } else if (state == Call.State.DISCONNECTED) {
            changed = true;
        }
        return changed;
    }

    private final ImsPhoneConnection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getHandoverConnection() {
        ImsPhoneConnection conn = (ImsPhoneConnection)this.getEarliestConnection();
        if (conn != null) {
            conn.setMultiparty(this.isMultiparty());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$switchWith(ImsPhoneCall that) {
        Class<ImsPhoneCall> clazz = ImsPhoneCall.class;
        synchronized (ImsPhoneCall.class) {
            ImsPhoneCall tmp = new ImsPhoneCall();
            tmp.takeOver(this);
            this.takeOver(that);
            that.takeOver(tmp);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$takeOver(ImsPhoneCall that) {
        this.mConnections = that.mConnections;
        this.mState = that.mState;
        for (Connection c : this.mConnections) {
            ((ImsPhoneConnection)c).changeParent(this);
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__();
    }

    ImsPhoneCall() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__(), 0, this);
    }

    private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__(imsPhoneCallTracker);
    }

    ImsPhoneCall(ImsPhoneCallTracker imsPhoneCallTracker) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$dispose(), 0, this);
    }

    @Override
    public List<Connection> getConnections() {
        return InvokeDynamicSupport.bootstrap("getConnections", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getConnections(), 0, this);
    }

    @Override
    public Phone getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getPhone(), 0, this);
    }

    @Override
    public boolean isMultiparty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiparty", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isMultiparty(), 0, this);
    }

    @Override
    public void hangup() throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$hangup(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$toString(), 0, this);
    }

    void attach(Connection connection) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attach(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    void attach(Connection connection, Call.State state) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attach(com.android.internal.telephony.Connection com.android.internal.telephony.Call$State ), 0, this, connection, state);
    }

    void attachFake(Connection connection, Call.State state) {
        InvokeDynamicSupport.bootstrap("attachFake", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attachFake(com.android.internal.telephony.Connection com.android.internal.telephony.Call$State ), 0, this, connection, state);
    }

    boolean connectionDisconnected(ImsPhoneConnection imsPhoneConnection) {
        return (boolean)InvokeDynamicSupport.bootstrap("connectionDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$connectionDisconnected(com.android.internal.telephony.imsphone.ImsPhoneConnection ), 0, this, imsPhoneConnection);
    }

    void detach(ImsPhoneConnection imsPhoneConnection) {
        InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$detach(com.android.internal.telephony.imsphone.ImsPhoneConnection ), 0, this, imsPhoneConnection);
    }

    boolean isFull() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFull", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isFull(), 0, this);
    }

    void onHangupLocal() {
        InvokeDynamicSupport.bootstrap("onHangupLocal", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$onHangupLocal(), 0, this);
    }

    void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$clearDisconnected(), 0, this);
    }

    ImsPhoneConnection getFirstConnection() {
        return InvokeDynamicSupport.bootstrap("getFirstConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getFirstConnection(), 0, this);
    }

    void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$setMute(boolean ), 0, this, bl);
    }

    void merge(ImsPhoneCall imsPhoneCall, Call.State state) {
        InvokeDynamicSupport.bootstrap("merge", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$merge(com.android.internal.telephony.imsphone.ImsPhoneCall com.android.internal.telephony.Call$State ), 0, this, imsPhoneCall, state);
    }

    ImsCall getImsCall() {
        return InvokeDynamicSupport.bootstrap("getImsCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getImsCall(), 0, this);
    }

    static boolean isLocalTone(ImsCall imsCall) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLocalTone", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isLocalTone(com.android.ims.ImsCall ), 0, (ImsCall)imsCall);
    }

    boolean update(ImsPhoneConnection imsPhoneConnection, ImsCall imsCall, Call.State state) {
        return (boolean)InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$update(com.android.internal.telephony.imsphone.ImsPhoneConnection com.android.ims.ImsCall com.android.internal.telephony.Call$State ), 0, this, imsPhoneConnection, imsCall, state);
    }

    ImsPhoneConnection getHandoverConnection() {
        return InvokeDynamicSupport.bootstrap("getHandoverConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getHandoverConnection(), 0, this);
    }

    void switchWith(ImsPhoneCall imsPhoneCall) {
        InvokeDynamicSupport.bootstrap("switchWith", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$switchWith(com.android.internal.telephony.imsphone.ImsPhoneCall ), 0, this, imsPhoneCall);
    }

    private void takeOver(ImsPhoneCall imsPhoneCall) {
        InvokeDynamicSupport.bootstrap("takeOver", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$takeOver(com.android.internal.telephony.imsphone.ImsPhoneCall ), 0, this, imsPhoneCall);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsPhoneCall)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

