/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telecom.Connection;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.ims.ImsCall;
import com.android.ims.ImsCallProfile;
import com.android.ims.ImsConnectionStateListener;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsUtInterface;
import com.android.ims.internal.IImsVideoCallProvider;
import com.android.ims.internal.ImsVideoCallProviderWrapper;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ImsPhoneCallTracker
extends CallTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "ImsPhoneCallTracker";
    private static boolean DBG = true;
    private boolean mIsVolteEnabled;
    private boolean mIsVtEnabled;
    private BroadcastReceiver mReceiver;
    static int MAX_CONNECTIONS = 7;
    static int MAX_CONNECTIONS_PER_CALL = 5;
    private static int EVENT_HANGUP_PENDINGMO = 18;
    private static int EVENT_RESUME_BACKGROUND = 19;
    private static int EVENT_DIAL_PENDINGMO = 20;
    private static int TIMEOUT_HANGUP_PENDINGMO = 500;
    private ArrayList<ImsPhoneConnection> mConnections;
    private RegistrantList mVoiceCallEndedRegistrants;
    private RegistrantList mVoiceCallStartedRegistrants;
    ImsPhoneCall mRingingCall;
    ImsPhoneCall mForegroundCall;
    ImsPhoneCall mBackgroundCall;
    ImsPhoneCall mHandoverCall;
    private ImsPhoneConnection mPendingMO;
    private int mClirMode;
    private Object mSyncHold;
    private ImsCall mUssdSession;
    private Message mPendingUssd;
    ImsPhone mPhone;
    private boolean mDesiredMute;
    private boolean mOnHoldToneStarted;
    PhoneConstants.State mState;
    private ImsManager mImsManager;
    private int mServiceId;
    private Call.SrvccState mSrvccState;
    private boolean mIsInEmergencyCall;
    private int pendingCallClirMode;
    private int pendingCallVideoState;
    private boolean pendingCallInEcm;
    private ImsCall.Listener mImsCallListener;
    private ImsCall.Listener mImsUssdListener;
    private ImsConnectionStateListener mImsConnectionStateListener;

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$__constructor__(ImsPhone phone) {
        this.mIsVolteEnabled = false;
        this.mIsVtEnabled = false;
        this.mReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$__constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("com.android.ims.IMS_INCOMING_CALL")) {
                    this.this$0.log("onReceive : incoming call intent");
                    if (this.this$0.mImsManager == null) {
                        return;
                    }
                    if (this.this$0.mServiceId < 0) {
                        return;
                    }
                    try {
                        boolean isUssd = intent.getBooleanExtra("android:ussd", false);
                        if (isUssd) {
                            this.this$0.log("onReceive : USSD");
                            this.this$0.mUssdSession = this.this$0.mImsManager.takeCall(this.this$0.mServiceId, intent, this.this$0.mImsUssdListener);
                            if (this.this$0.mUssdSession != null) {
                                this.this$0.mUssdSession.accept(2);
                            }
                            return;
                        }
                        ImsCall imsCall = this.this$0.mImsManager.takeCall(this.this$0.mServiceId, intent, this.this$0.mImsCallListener);
                        ImsPhoneConnection conn = new ImsPhoneConnection(this.this$0.mPhone.getContext(), imsCall, this.this$0, this.this$0.mRingingCall);
                        this.this$0.addConnection(conn);
                        IImsVideoCallProvider imsVideoCallProvider = imsCall.getCallSession().getVideoCallProvider();
                        if (imsVideoCallProvider != null) {
                            ImsVideoCallProviderWrapper imsVideoCallProviderWrapper = new ImsVideoCallProviderWrapper(imsVideoCallProvider);
                            conn.setVideoProvider((Connection.VideoProvider)imsVideoCallProviderWrapper);
                        }
                        if (this.this$0.mForegroundCall.getState() != Call.State.IDLE || this.this$0.mBackgroundCall.getState() != Call.State.IDLE) {
                            conn.update(imsCall, Call.State.WAITING);
                        }
                        this.this$0.mPhone.notifyNewRingingConnection(conn);
                        this.this$0.mPhone.notifyIncomingRing();
                        this.this$0.updatePhoneState();
                        this.this$0.mPhone.notifyPreciseCallStateChanged();
                    }
                    catch (ImsException e) {
                        this.this$0.loge("onReceive : exception " + (Object)((Object)e));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnections = new ArrayList();
        this.mVoiceCallEndedRegistrants = new RegistrantList();
        this.mVoiceCallStartedRegistrants = new RegistrantList();
        this.mRingingCall = new ImsPhoneCall(this);
        this.mForegroundCall = new ImsPhoneCall(this);
        this.mBackgroundCall = new ImsPhoneCall(this);
        this.mHandoverCall = new ImsPhoneCall(this);
        this.mClirMode = 0;
        this.mSyncHold = new Object();
        this.mUssdSession = null;
        this.mPendingUssd = null;
        this.mDesiredMute = false;
        this.mOnHoldToneStarted = false;
        this.mState = PhoneConstants.State.IDLE;
        this.mServiceId = -1;
        this.mSrvccState = Call.SrvccState.NONE;
        this.mIsInEmergencyCall = false;
        this.pendingCallInEcm = false;
        this.mImsCallListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$__constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallProgressing(ImsCall imsCall) {
                this.this$0.log("onCallProgressing");
                this.this$0.mPendingMO = null;
                this.this$0.processCallStateChange(imsCall, Call.State.ALERTING, 0);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStarted(ImsCall imsCall) {
                this.this$0.log("onCallStarted");
                this.this$0.mPendingMO = null;
                this.this$0.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallStartFailed reasonCode=" + reasonInfo.getCode());
                if (this.this$0.mPendingMO != null) {
                    if (reasonInfo.getCode() == 146 && this.this$0.mBackgroundCall.getState() == Call.State.IDLE && this.this$0.mRingingCall.getState() == Call.State.IDLE) {
                        this.this$0.mForegroundCall.detach(this.this$0.mPendingMO);
                        this.this$0.removeConnection(this.this$0.mPendingMO);
                        this.this$0.mPendingMO.finalize();
                        this.this$0.mPendingMO = null;
                        this.this$0.mPhone.initiateSilentRedial();
                        return;
                    }
                    this.this$0.mPendingMO = null;
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallTerminated reasonCode=" + reasonInfo.getCode());
                Call.State oldState = this.this$0.mForegroundCall.getState();
                int cause = this.this$0.getDisconnectCauseFromReasonInfo(reasonInfo);
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                this.this$0.log("cause = " + cause + " conn = " + conn);
                if (conn != null && conn.isIncoming() && conn.getConnectTime() == 0L) {
                    cause = cause == 3 ? 16 : 1;
                }
                this.this$0.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
                if (reasonInfo.getCode() == 501 && oldState == Call.State.DISCONNECTING && this.this$0.mForegroundCall.getState() == Call.State.DISCONNECTED && this.this$0.mBackgroundCall.getState() == Call.State.HOLDING) {
                    this.this$0.sendEmptyMessage(19);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHeld(ImsCall imsCall) {
                this.this$0.log("onCallHeld");
                Object object = this.this$0.mSyncHold;
                synchronized (object) {
                    Call.State oldState = this.this$0.mBackgroundCall.getState();
                    this.this$0.processCallStateChange(imsCall, Call.State.HOLDING, 0);
                    if (oldState == Call.State.ACTIVE) {
                        if (this.this$0.mForegroundCall.getState() == Call.State.HOLDING || this.this$0.mRingingCall.getState() == Call.State.WAITING) {
                            this.this$0.sendEmptyMessage(19);
                        } else if (this.this$0.mPendingMO != null) {
                            this.this$0.sendEmptyMessage(20);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHoldFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallHoldFailed reasonCode=" + reasonInfo.getCode());
                Object object = this.this$0.mSyncHold;
                synchronized (object) {
                    Call.State bgState = this.this$0.mBackgroundCall.getState();
                    if (reasonInfo.getCode() == 148) {
                        if (this.this$0.mPendingMO != null) {
                            this.this$0.sendEmptyMessage(20);
                        }
                    } else if (bgState == Call.State.ACTIVE) {
                        this.this$0.mForegroundCall.switchWith(this.this$0.mBackgroundCall);
                        if (this.this$0.mPendingMO != null) {
                            this.this$0.mPendingMO.setDisconnectCause(36);
                            this.this$0.sendEmptyMessageDelayed(18, 500L);
                        }
                    }
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumed(ImsCall imsCall) {
                this.this$0.log("onCallResumed");
                this.this$0.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumeFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumeReceived(ImsCall imsCall) {
                this.this$0.log("onCallResumeReceived");
                if (this.this$0.mOnHoldToneStarted) {
                    this.this$0.mPhone.stopOnHoldTone();
                    this.this$0.mOnHoldToneStarted = false;
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHoldReceived(ImsCall imsCall) {
                this.this$0.log("onCallHoldReceived");
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                if (conn != null && conn.getState() == Call.State.ACTIVE && !this.this$0.mOnHoldToneStarted && ImsPhoneCall.isLocalTone(imsCall)) {
                    this.this$0.mPhone.startOnHoldTone();
                    this.this$0.mOnHoldToneStarted = true;
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallMerged(ImsCall call, ImsCall newCall) {
                this.this$0.log("onCallMerged");
                this.this$0.mForegroundCall.merge(this.this$0.mBackgroundCall, this.this$0.mForegroundCall.getState());
                this.this$0.updatePhoneState();
                this.this$0.mPhone.notifyPreciseCallStateChanged();
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallMergeFailed(ImsCall call, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallMergeFailed reasonCode=" + reasonInfo.getCode());
                this.this$0.mPhone.notifySuppServiceFailed(Phone.SuppService.CONFERENCE);
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            public void onCallProgressing(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallProgressing", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallProgressing(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallStarted(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStarted(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallStartFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStartFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallTerminated(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallTerminated", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallTerminated(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallHeld(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallHeld", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHeld(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallHoldFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallHoldFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHoldFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallResumed(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallResumed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumed(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallResumeFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallResumeFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumeFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallResumeReceived(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallResumeReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumeReceived(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallHoldReceived(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallHoldReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHoldReceived(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallMerged(ImsCall imsCall, ImsCall imsCall2) {
                InvokeDynamicSupport.bootstrap("onCallMerged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallMerged(com.android.ims.ImsCall com.android.ims.ImsCall ), 0, this, imsCall, imsCall2);
            }

            public void onCallMergeFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallMergeFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallMergeFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsUssdListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$__constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallStarted(ImsCall imsCall) {
                this.this$0.log("mImsUssdListener onCallStarted");
                if (imsCall == this.this$0.mUssdSession && this.this$0.mPendingUssd != null) {
                    AsyncResult.forMessage(this.this$0.mPendingUssd);
                    this.this$0.mPendingUssd.sendToTarget();
                    this.this$0.mPendingUssd = null;
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("mImsUssdListener onCallStartFailed reasonCode=" + reasonInfo.getCode());
                this.onCallTerminated(imsCall, reasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("mImsUssdListener onCallTerminated reasonCode=" + reasonInfo.getCode());
                if (imsCall == this.this$0.mUssdSession) {
                    this.this$0.mUssdSession = null;
                    if (this.this$0.mPendingUssd != null) {
                        CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                        AsyncResult.forMessage(this.this$0.mPendingUssd, null, ex);
                        this.this$0.mPendingUssd.sendToTarget();
                        this.this$0.mPendingUssd = null;
                    }
                }
                imsCall.close();
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallUssdMessageReceived(ImsCall call, int mode, String ussdMessage) {
                this.this$0.log("mImsUssdListener onCallUssdMessageReceived mode=" + mode);
                int ussdMode = -1;
                switch (mode) {
                    case 1: {
                        ussdMode = 1;
                        break;
                    }
                    case 0: {
                        ussdMode = 0;
                    }
                }
                this.this$0.mPhone.onIncomingUSSD(ussdMode, ussdMessage);
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            public void onCallStarted(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallStarted(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallStartFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallStartFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallTerminated(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallTerminated", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallTerminated(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallUssdMessageReceived(ImsCall imsCall, int n, String string2) {
                InvokeDynamicSupport.bootstrap("onCallUssdMessageReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallUssdMessageReceived(com.android.ims.ImsCall int java.lang.String ), 0, this, imsCall, n, string2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsConnectionStateListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$__constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsConnected() {
                this.this$0.log("onImsConnected");
                this.this$0.mPhone.setServiceState(0);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsDisconnected() {
                this.this$0.log("onImsDisconnected");
                this.this$0.mPhone.setServiceState(1);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsResumed() {
                this.this$0.log("onImsResumed");
                this.this$0.mPhone.setServiceState(0);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsSuspended() {
                this.this$0.log("onImsSuspended");
                this.this$0.mPhone.setServiceState(1);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) {
                if (serviceClass == 1) {
                    if (enabledFeatures[0] == 0) {
                        this.this$0.mIsVolteEnabled = true;
                    }
                    if (enabledFeatures[1] == 1) {
                        this.this$0.mIsVtEnabled = true;
                    }
                    if (disabledFeatures[0] == 0) {
                        this.this$0.mIsVolteEnabled = false;
                    }
                    if (disabledFeatures[1] == 1) {
                        this.this$0.mIsVtEnabled = false;
                    }
                }
                this.this$0.log("onFeatureCapabilityChanged, mIsVolteEnabled = " + this.this$0.mIsVolteEnabled + " mIsVtEnabled = " + this.this$0.mIsVtEnabled);
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            public void onImsConnected() {
                InvokeDynamicSupport.bootstrap("onImsConnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsConnected(), 0, this);
            }

            public void onImsDisconnected() {
                InvokeDynamicSupport.bootstrap("onImsDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsDisconnected(), 0, this);
            }

            public void onImsResumed() {
                InvokeDynamicSupport.bootstrap("onImsResumed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsResumed(), 0, this);
            }

            public void onImsSuspended() {
                InvokeDynamicSupport.bootstrap("onImsSuspended", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsSuspended(), 0, this);
            }

            public void onFeatureCapabilityChanged(int n, int[] nArray, int[] nArray2) {
                InvokeDynamicSupport.bootstrap("onFeatureCapabilityChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onFeatureCapabilityChanged(int int[] int[] ), 0, this, n, nArray, nArray2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction("com.android.ims.IMS_INCOMING_CALL");
        this.mPhone.getContext().registerReceiver(this.mReceiver, intentfilter);
        ShadowedObject t = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$__constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$run() {
                this.this$0.getImsService();
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        t.start();
    }

    private final PendingIntent $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$createIncomingCallPendingIntent() {
        Intent intent = new Intent("com.android.ims.IMS_INCOMING_CALL");
        intent.addFlags(0x10000000);
        return PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getImsService() {
        this.log("getImsService");
        this.mImsManager = ImsManager.getInstance((Context)this.mPhone.getContext(), (long)this.mPhone.getSubId());
        try {
            this.mServiceId = this.mImsManager.open(1, this.createIncomingCallPendingIntent(), this.mImsConnectionStateListener);
            this.getEcbmInterface().setEcbmStateListener(this.mPhone.mImsEcbmStateListener);
            if (this.mPhone.isInEcm()) {
                this.mPhone.exitEmergencyCallbackMode();
            }
        }
        catch (ImsException e) {
            this.loge("getImsService: " + (Object)((Object)e));
            this.mImsManager = null;
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dispose() {
        this.log("dispose");
        this.mRingingCall.dispose();
        this.mBackgroundCall.dispose();
        this.mForegroundCall.dispose();
        this.mHandoverCall.dispose();
        this.clearDisconnected();
        this.mPhone.getContext().unregisterReceiver(this.mReceiver);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$finalize() {
        this.log("ImsPhoneCallTracker finalized");
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(String dialString, int videoState) throws CallStateException {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        int oirMode = sp.getInt("clir_key", 0);
        return this.dial(dialString, oirMode, videoState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(String dialString, int clirMode, int videoState) throws CallStateException {
        boolean isPhoneInEcmMode = SystemProperties.getBoolean("ril.cdma.inecmmode", false);
        boolean isEmergencyNumber = PhoneNumberUtils.isEmergencyNumber(dialString);
        this.log("dial clirMode=" + clirMode);
        this.clearDisconnected();
        if (this.mImsManager == null) {
            throw new CallStateException("service not available");
        }
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        if (isPhoneInEcmMode && isEmergencyNumber) {
            this.handleEcmTimer(1);
        }
        boolean holdBeforeDial = false;
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            if (this.mBackgroundCall.getState() != Call.State.IDLE) {
                throw new CallStateException("cannot dial in current state");
            }
            holdBeforeDial = true;
            this.switchWaitingOrHoldingAndActive();
        }
        Call.State fgState = Call.State.IDLE;
        Call.State bgState = Call.State.IDLE;
        this.mClirMode = clirMode;
        Object object = this.mSyncHold;
        synchronized (object) {
            if (holdBeforeDial) {
                fgState = this.mForegroundCall.getState();
                bgState = this.mBackgroundCall.getState();
                if (fgState == Call.State.ACTIVE) {
                    throw new CallStateException("cannot dial in current state");
                }
                if (bgState == Call.State.HOLDING) {
                    holdBeforeDial = false;
                }
            }
            this.mPendingMO = new ImsPhoneConnection(this.mPhone.getContext(), this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall);
        }
        this.addConnection(this.mPendingMO);
        if (!holdBeforeDial) {
            if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyNumber) {
                this.dialInternal(this.mPendingMO, clirMode, videoState);
            } else {
                try {
                    this.getEcbmInterface().exitEmergencyCallbackMode();
                }
                catch (ImsException e) {
                    e.printStackTrace();
                    throw new CallStateException("service not available");
                }
                this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                this.pendingCallClirMode = clirMode;
                this.pendingCallVideoState = videoState;
                this.pendingCallInEcm = true;
            }
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleEcmTimer(int action) {
        this.mPhone.handleTimerInEmergencyCallbackMode(action);
        switch (action) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.log("handleEcmTimer, unsupported action " + action);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dialInternal(ImsPhoneConnection conn, int clirMode, int videoState) {
        if (conn == null) {
            return;
        }
        if (conn.getAddress() == null || conn.getAddress().length() == 0 || conn.getAddress().indexOf(78) >= 0) {
            conn.setDisconnectCause(7);
            this.sendEmptyMessageDelayed(18, 500L);
            return;
        }
        this.setMute(false);
        int serviceType = PhoneNumberUtils.isEmergencyNumber(conn.getAddress()) ? 2 : 1;
        int callType = ImsCallProfile.getCallTypeFromVideoState(videoState);
        conn.setVideoState(videoState);
        try {
            String[] callees = new String[]{conn.getAddress()};
            ImsCallProfile profile = this.mImsManager.createCallProfile(this.mServiceId, serviceType, callType);
            profile.setCallExtraInt("oir", clirMode);
            ImsCall imsCall = this.mImsManager.makeCall(this.mServiceId, profile, callees, this.mImsCallListener);
            conn.setImsCall(imsCall);
            IImsVideoCallProvider imsVideoCallProvider = imsCall.getCallSession().getVideoCallProvider();
            if (imsVideoCallProvider != null) {
                ImsVideoCallProviderWrapper imsVideoCallProviderWrapper = new ImsVideoCallProviderWrapper(imsVideoCallProvider);
                conn.setVideoProvider((Connection.VideoProvider)imsVideoCallProviderWrapper);
            }
        }
        catch (ImsException e) {
            this.loge("dialInternal : " + (Object)((Object)e));
            conn.setDisconnectCause(36);
            this.sendEmptyMessageDelayed(18, 500L);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$acceptCall(int videoState) throws CallStateException {
        this.log("acceptCall");
        if (this.mForegroundCall.getState().isAlive() && this.mBackgroundCall.getState().isAlive()) {
            throw new CallStateException("cannot accept call");
        }
        if (this.mRingingCall.getState() == Call.State.WAITING && this.mForegroundCall.getState().isAlive()) {
            this.setMute(false);
            this.switchWaitingOrHoldingAndActive();
        } else if (this.mRingingCall.getState().isRinging()) {
            this.log("acceptCall: incoming...");
            this.setMute(false);
            try {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall == null) {
                    throw new CallStateException("no valid ims call");
                }
                imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(videoState));
            }
            catch (ImsException e) {
                throw new CallStateException("cannot accept call");
            }
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$rejectCall() throws CallStateException {
        this.log("rejectCall");
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.hangup(this.mRingingCall);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$switchWaitingOrHoldingAndActive() throws CallStateException {
        this.log("switchWaitingOrHoldingAndActive");
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            ImsCall imsCall = this.mForegroundCall.getImsCall();
            if (imsCall == null) {
                throw new CallStateException("no ims call");
            }
            this.mForegroundCall.switchWith(this.mBackgroundCall);
            try {
                imsCall.hold();
            }
            catch (ImsException e) {
                this.mForegroundCall.switchWith(this.mBackgroundCall);
                throw new CallStateException(e.getMessage());
            }
        } else if (this.mBackgroundCall.getState() == Call.State.HOLDING) {
            this.resumeWaitingOrHolding();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$conference() {
        this.log("conference");
        ImsCall fgImsCall = this.mForegroundCall.getImsCall();
        if (fgImsCall == null) {
            this.log("conference no foreground ims call");
            return;
        }
        ImsCall bgImsCall = this.mBackgroundCall.getImsCall();
        if (bgImsCall == null) {
            this.log("conference no background ims call");
            return;
        }
        try {
            fgImsCall.merge(bgImsCall);
        }
        catch (ImsException e) {
            this.log("conference " + e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$explicitCallTransfer() {
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$clearDisconnected() {
        this.log("clearDisconnected");
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canDial() {
        int serviceState = this.mPhone.getServiceState().getState();
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean ret = serviceState != 3 && this.mPendingMO == null && !this.mRingingCall.isRinging() && !disableCall.equals("true") && (!this.mForegroundCall.getState().isAlive() || !this.mBackgroundCall.getState().isAlive());
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canTransfer() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
        this.mHandoverCall.clearDisconnected();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$updatePhoneState() {
        PhoneConstants.State oldState = this.mState;
        this.mState = this.mRingingCall.isRinging() ? PhoneConstants.State.RINGING : (this.mPendingMO != null || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle() ? PhoneConstants.State.OFFHOOK : PhoneConstants.State.IDLE);
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("updatePhoneState oldState=" + (Object)((Object)oldState) + ", newState=" + (Object)((Object)this.mState));
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dumpState() {
        int i;
        this.log("Phone State:" + (Object)((Object)this.mState));
        this.log("Ringing call: " + this.mRingingCall.toString());
        List<Connection> l = this.mRingingCall.getConnections();
        int s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Foreground call: " + this.mForegroundCall.toString());
        l = this.mForegroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Background call: " + this.mBackgroundCall.toString());
        l = this.mBackgroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mForegroundCall.setMute(mute);
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getMute() {
        return this.mDesiredMute;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendDtmf(char c) {
        this.log("sendDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.sendDtmf(c);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(ImsPhoneConnection conn) throws CallStateException {
        this.log("hangup connection");
        if (conn.getOwner() != this) {
            throw new CallStateException("ImsPhoneConnection " + conn + "does not belong to ImsPhoneCallTracker " + this);
        }
        this.hangup((ImsPhoneCall)conn.getCall());
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(ImsPhoneCall call) throws CallStateException {
        this.log("hangup call");
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections");
        }
        ImsCall imsCall = call.getImsCall();
        boolean rejectCall = false;
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup incoming");
            rejectCall = true;
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
            } else {
                this.log("(foregnd) hangup foreground");
            }
        } else if (call == this.mBackgroundCall) {
            this.log("(backgnd) hangup waiting or background");
        } else {
            throw new CallStateException("ImsPhoneCall " + call + "does not belong to ImsPhoneCallTracker " + this);
        }
        call.onHangupLocal();
        try {
            if (imsCall != null) {
                if (rejectCall) {
                    imsCall.reject(504);
                } else {
                    imsCall.terminate(501);
                }
            } else if (this.mPendingMO != null && call == this.mForegroundCall) {
                this.mPendingMO.update(null, Call.State.DISCONNECTED);
                this.mPendingMO.onDisconnect();
                this.removeConnection(this.mPendingMO);
                this.mPendingMO = null;
                this.updatePhoneState();
                this.removeMessages(20);
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$resumeWaitingOrHolding() throws CallStateException {
        this.log("resumeWaitingOrHolding");
        try {
            if (this.mForegroundCall.getState().isAlive()) {
                ImsCall imsCall = this.mForegroundCall.getImsCall();
                if (imsCall != null) {
                    imsCall.resume();
                }
            } else if (this.mRingingCall.getState() == Call.State.WAITING) {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall != null) {
                    imsCall.accept(2);
                }
            } else {
                ImsCall imsCall = this.mBackgroundCall.getImsCall();
                if (imsCall != null) {
                    imsCall.resume();
                }
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendUSSD(String ussdString, Message response) {
        this.log("sendUSSD");
        try {
            if (this.mUssdSession != null) {
                this.mUssdSession.sendUssd(ussdString);
                AsyncResult.forMessage(response, null, null);
                response.sendToTarget();
                return;
            }
            String[] callees = new String[]{ussdString};
            ImsCallProfile profile = this.mImsManager.createCallProfile(this.mServiceId, 1, 2);
            profile.setCallExtraInt("dialstring", 2);
            this.mUssdSession = this.mImsManager.makeCall(this.mServiceId, profile, callees, this.mImsUssdListener);
        }
        catch (ImsException e) {
            this.loge("sendUSSD : " + (Object)((Object)e));
            this.mPhone.sendErrorResponse(response, e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cancelUSSD() {
        if (this.mUssdSession == null) {
            return;
        }
        try {
            this.mUssdSession.terminate(501);
        }
        catch (ImsException imsException) {
            // empty catch block
        }
    }

    private final synchronized ImsPhoneConnection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$findConnection(ImsCall imsCall) {
        for (ImsPhoneConnection conn : this.mConnections) {
            if (conn.getImsCall() != imsCall) continue;
            return conn;
        }
        return null;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$removeConnection(ImsPhoneConnection conn) {
        this.mConnections.remove(conn);
    }

    private final synchronized void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$addConnection(ImsPhoneConnection conn) {
        this.mConnections.add(conn);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$processCallStateChange(ImsCall imsCall, Call.State state, int cause) {
        this.log("processCallStateChange state=" + (Object)((Object)state) + " cause=" + cause);
        if (imsCall == null) {
            return;
        }
        boolean changed = false;
        ImsPhoneConnection conn = this.findConnection(imsCall);
        if (conn == null) {
            return;
        }
        changed = conn.update(imsCall, state);
        if (state == Call.State.DISCONNECTED) {
            changed = conn.onDisconnect(cause) || changed;
            this.removeConnection(conn);
        }
        if (changed) {
            if (conn.getCall() == this.mHandoverCall) {
                return;
            }
            this.updatePhoneState();
            this.mPhone.notifyPreciseCallStateChanged();
        }
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getDisconnectCauseFromReasonInfo(ImsReasonInfo reasonInfo) {
        int cause = 36;
        int code = reasonInfo.getCode();
        switch (code) {
            case 337: 
            case 341: {
                return 8;
            }
            case 338: {
                return 4;
            }
            case 501: {
                return 3;
            }
            case 510: {
                return 2;
            }
            case 321: 
            case 331: 
            case 332: 
            case 340: 
            case 361: 
            case 362: {
                return 12;
            }
            case 333: 
            case 352: 
            case 354: {
                return 9;
            }
            case 106: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 131: 
            case 132: 
            case 144: {
                return 18;
            }
            case 201: 
            case 202: 
            case 203: 
            case 335: {
                return 13;
            }
            case 111: 
            case 112: {
                return 17;
            }
        }
        return cause;
    }

    private final ImsUtInterface $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getUtInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw new ImsException("no ims manager", 0);
        }
        ImsUtInterface ut = this.mImsManager.getSupplementaryServiceConfiguration(this.mServiceId);
        return ut;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$notifySrvccState(Call.SrvccState state) {
        this.log("notifySrvccState state=" + (Object)((Object)state));
        this.mSrvccState = state;
        if (this.mSrvccState == Call.SrvccState.COMPLETED) {
            if (this.mForegroundCall.getConnections().size() > 0) {
                this.mHandoverCall.switchWith(this.mForegroundCall);
            } else if (this.mBackgroundCall.getConnections().size() > 0) {
                this.mHandoverCall.switchWith(this.mBackgroundCall);
            }
            ImsPhoneConnection con = this.mHandoverCall.getHandoverConnection();
            if (con != null) {
                con.releaseWakeLock();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleMessage(Message msg) {
        this.log("handleMessage what=" + msg.what);
        switch (msg.what) {
            case 18: {
                if (this.mPendingMO != null) {
                    this.mPendingMO.onDisconnect();
                    this.removeConnection(this.mPendingMO);
                    this.mPendingMO = null;
                }
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                break;
            }
            case 19: {
                try {
                    this.resumeWaitingOrHolding();
                }
                catch (CallStateException e) {
                    this.loge("handleMessage EVENT_RESUME_BACKGROUND exception=" + e);
                }
                break;
            }
            case 20: {
                this.dialInternal(this.mPendingMO, this.mClirMode, 0);
                break;
            }
            case 14: {
                if (this.pendingCallInEcm) {
                    this.dialInternal(this.mPendingMO, this.pendingCallClirMode, this.pendingCallVideoState);
                    this.pendingCallInEcm = false;
                }
                this.mPhone.unsetOnEcbModeExitResponse(this);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$log(String msg) {
        Rlog.d("ImsPhoneCallTracker", "[ImsPhoneCallTracker] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$loge(String msg) {
        Rlog.e("ImsPhoneCallTracker", "[ImsPhoneCallTracker] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsPhoneCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mHandoverCall=" + this.mHandoverCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mState=" + (Object)((Object)this.mState));
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handlePollCalls(AsyncResult ar) {
    }

    private final ImsEcbm $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getEcbmInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw new ImsException("no ims manager", 0);
        }
        ImsEcbm ecbm = this.mImsManager.getEcbmInterface(this.mServiceId);
        return ecbm;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVolteEnabled() {
        return this.mIsVolteEnabled;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVtEnabled() {
        return this.mIsVtEnabled;
    }

    private void __constructor__(ImsPhone imsPhone) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$__constructor__(imsPhone);
    }

    ImsPhoneCallTracker(ImsPhone imsPhone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$__constructor__(com.android.internal.telephony.imsphone.ImsPhone ), 0, this, imsPhone);
    }

    private PendingIntent createIncomingCallPendingIntent() {
        return InvokeDynamicSupport.bootstrap("createIncomingCallPendingIntent", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$createIncomingCallPendingIntent(), 0, this);
    }

    private void getImsService() {
        InvokeDynamicSupport.bootstrap("getImsService", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getImsService(), 0, this);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dispose(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$finalize(), 0, this);
    }

    @Override
    public void registerForVoiceCallStarted(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallStarted(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallStarted(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForVoiceCallEnded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallEnded", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallEnded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallEnded", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallEnded(android.os.Handler ), 0, this, handler);
    }

    Connection dial(String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(java.lang.String int ), 0, this, string2, n);
    }

    synchronized Connection dial(String string2, int n, int n2) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(java.lang.String int int ), 0, this, string2, n, n2);
    }

    private void handleEcmTimer(int n) {
        InvokeDynamicSupport.bootstrap("handleEcmTimer", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleEcmTimer(int ), 0, this, n);
    }

    private void dialInternal(ImsPhoneConnection imsPhoneConnection, int n, int n2) {
        InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dialInternal(com.android.internal.telephony.imsphone.ImsPhoneConnection int int ), 0, this, imsPhoneConnection, n, n2);
    }

    void acceptCall(int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$acceptCall(int ), 0, this, n);
    }

    void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$rejectCall(), 0, this);
    }

    void switchWaitingOrHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchWaitingOrHoldingAndActive", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$switchWaitingOrHoldingAndActive(), 0, this);
    }

    void conference() {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$conference(), 0, this);
    }

    void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$explicitCallTransfer(), 0, this);
    }

    void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$clearDisconnected(), 0, this);
    }

    boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canConference(), 0, this);
    }

    boolean canDial() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canDial(), 0, this);
    }

    boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canTransfer(), 0, this);
    }

    private void internalClearDisconnected() {
        InvokeDynamicSupport.bootstrap("internalClearDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$internalClearDisconnected(), 0, this);
    }

    private void updatePhoneState() {
        InvokeDynamicSupport.bootstrap("updatePhoneState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$updatePhoneState(), 0, this);
    }

    private void handleRadioNotAvailable() {
        InvokeDynamicSupport.bootstrap("handleRadioNotAvailable", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleRadioNotAvailable(), 0, this);
    }

    private void dumpState() {
        InvokeDynamicSupport.bootstrap("dumpState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dumpState(), 0, this);
    }

    void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setMute(boolean ), 0, this, bl);
    }

    boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getMute(), 0, this);
    }

    void sendDtmf(char c) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendDtmf(char ), 0, this, c);
    }

    void hangup(ImsPhoneConnection imsPhoneConnection) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(com.android.internal.telephony.imsphone.ImsPhoneConnection ), 0, this, imsPhoneConnection);
    }

    void hangup(ImsPhoneCall imsPhoneCall) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(com.android.internal.telephony.imsphone.ImsPhoneCall ), 0, this, imsPhoneCall);
    }

    void resumeWaitingOrHolding() throws CallStateException {
        InvokeDynamicSupport.bootstrap("resumeWaitingOrHolding", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$resumeWaitingOrHolding(), 0, this);
    }

    void sendUSSD(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendUSSD(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    void cancelUSSD() {
        InvokeDynamicSupport.bootstrap("cancelUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cancelUSSD(), 0, this);
    }

    private synchronized ImsPhoneConnection findConnection(ImsCall imsCall) {
        return InvokeDynamicSupport.bootstrap("findConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$findConnection(com.android.ims.ImsCall ), 0, this, imsCall);
    }

    private synchronized void removeConnection(ImsPhoneConnection imsPhoneConnection) {
        InvokeDynamicSupport.bootstrap("removeConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$removeConnection(com.android.internal.telephony.imsphone.ImsPhoneConnection ), 0, this, imsPhoneConnection);
    }

    private synchronized void addConnection(ImsPhoneConnection imsPhoneConnection) {
        InvokeDynamicSupport.bootstrap("addConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$addConnection(com.android.internal.telephony.imsphone.ImsPhoneConnection ), 0, this, imsPhoneConnection);
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int n) {
        InvokeDynamicSupport.bootstrap("processCallStateChange", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$processCallStateChange(com.android.ims.ImsCall com.android.internal.telephony.Call$State int ), 0, this, imsCall, state, n);
    }

    private int getDisconnectCauseFromReasonInfo(ImsReasonInfo imsReasonInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getDisconnectCauseFromReasonInfo", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getDisconnectCauseFromReasonInfo(com.android.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
    }

    ImsUtInterface getUtInterface() throws ImsException {
        return InvokeDynamicSupport.bootstrap("getUtInterface", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getUtInterface(), 0, this);
    }

    void notifySrvccState(Call.SrvccState srvccState) {
        InvokeDynamicSupport.bootstrap("notifySrvccState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$notifySrvccState(com.android.internal.telephony.Call$SrvccState ), 0, this, srvccState);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleMessage(android.os.Message ), 0, this, message);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$log(java.lang.String ), 0, this, string2);
    }

    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$loge(java.lang.String ), 0, this, string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    protected void handlePollCalls(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handlePollCalls", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handlePollCalls(android.os.AsyncResult ), 0, this, asyncResult);
    }

    ImsEcbm getEcbmInterface() throws ImsException {
        return InvokeDynamicSupport.bootstrap("getEcbmInterface", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getEcbmInterface(), 0, this);
    }

    public boolean isInEmergencyCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEmergencyCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isInEmergencyCall(), 0, this);
    }

    public boolean isVolteEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolteEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVolteEnabled(), 0, this);
    }

    public boolean isVtEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVtEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVtEnabled(), 0, this);
    }

    public /* synthetic */ ImsPhoneCallTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsPhoneCallTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

