/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.ims.ImsCall;
import com.android.ims.ImsCallProfile;
import com.android.ims.ImsException;
import com.android.ims.ImsStreamMediaProfile;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsPhoneConnection
extends Connection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsPhoneConnection";
    private static boolean DBG = true;
    private ImsPhoneCallTracker mOwner;
    private ImsPhoneCall mParent;
    private ImsCall mImsCall;
    private String mPostDialString;
    private boolean mDisconnected;
    private long mDisconnectTime;
    private int mNextPostDialChar;
    private int mCause;
    private Connection.PostDialState mPostDialState;
    private UUSInfo mUusInfo;
    private boolean mIsMultiparty;
    private Handler mHandler;
    private PowerManager.WakeLock mPartialWakeLock;
    private static int EVENT_DTMF_DONE = 1;
    private static int EVENT_PAUSE_DONE = 2;
    private static int EVENT_NEXT_POST_DIAL = 3;
    private static int EVENT_WAKE_LOCK_TIMEOUT = 4;
    private static int PAUSE_DELAY_MILLIS = 3000;
    private static int WAKE_LOCK_TIMEOUT_MILLIS = 60000;

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(Context context, ImsCall imsCall, ImsPhoneCallTracker ct, ImsPhoneCall parent) {
        this.mCause = 0;
        this.mPostDialState = Connection.PostDialState.NOT_STARTED;
        this.mIsMultiparty = false;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mImsCall = imsCall;
        if (imsCall != null && imsCall.getCallProfile() != null) {
            this.mAddress = imsCall.getCallProfile().getCallExtra("oi");
            this.mCnapName = imsCall.getCallProfile().getCallExtra("cna");
            this.mNumberPresentation = ImsCallProfile.OIRToPresentation(imsCall.getCallProfile().getCallExtraInt("oir"));
            this.mCnapNamePresentation = ImsCallProfile.OIRToPresentation(imsCall.getCallProfile().getCallExtraInt("cnap"));
            ImsCallProfile imsCallProfile = imsCall.getCallProfile();
            if (imsCallProfile != null) {
                int callType = imsCall.getCallProfile().mCallType;
                this.setVideoState(ImsCallProfile.getVideoStateFromCallType(callType));
                ImsStreamMediaProfile mediaProfile = imsCallProfile.mMediaProfile;
                if (mediaProfile != null) {
                    this.setAudioQuality(this.getAudioQualityFromMediaProfile(mediaProfile));
                }
            }
            try {
                ImsCallProfile localCallProfile = imsCall.getLocalCallProfile();
                if (localCallProfile != null) {
                    int localCallTypeCapability = localCallProfile.mCallType;
                    boolean isLocalVideoCapable = localCallTypeCapability == 4;
                    this.setLocalVideoCapable(isLocalVideoCapable);
                }
            }
            catch (ImsException imsException) {}
        } else {
            this.mNumberPresentation = 3;
            this.mCnapNamePresentation = 3;
        }
        this.mIsIncoming = true;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mUusInfo = null;
        this.mParent = parent;
        this.mParent.attach(this, Call.State.INCOMING);
    }

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(Context context, String dialString, ImsPhoneCallTracker ct, ImsPhoneCall parent) {
        this.mCause = 0;
        this.mPostDialState = Connection.PostDialState.NOT_STARTED;
        this.mIsMultiparty = false;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mDialString = dialString;
        this.mAddress = PhoneNumberUtils.extractNetworkPortionAlt(dialString);
        this.mPostDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.mIsIncoming = false;
        this.mCnapName = null;
        this.mCnapNamePresentation = 1;
        this.mNumberPresentation = 1;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mParent = parent;
        parent.attachFake(this, Call.State.DIALING);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$dispose() {
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getAudioQualityFromMediaProfile(ImsStreamMediaProfile mediaProfile) {
        int audioQuality = mediaProfile.mAudioQuality == 2 ? 2 : 1;
        return audioQuality;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOrigDialString() {
        return this.mDialString;
    }

    private final ImsPhoneCall $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getCall() {
        return this.mParent;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getDisconnectTime() {
        return this.mDisconnectTime;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getHoldingStartTime() {
        return this.mHoldingStartTime;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.mHoldingStartTime;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getDisconnectCause() {
        return this.mCause;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setDisconnectCause(int cause) {
        this.mCause = cause;
    }

    private final ImsPhoneCallTracker $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOwner() {
        return this.mOwner;
    }

    private final Call.State $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getState() {
        if (this.mDisconnected) {
            return Call.State.DISCONNECTED;
        }
        return super.getState();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$hangup() throws CallStateException {
        if (this.mDisconnected) {
            throw new CallStateException("disconnected");
        }
        this.mOwner.hangup(this);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$separate() throws CallStateException {
        throw new CallStateException("not supported");
    }

    private final Connection.PostDialState $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getPostDialState() {
        return this.mPostDialState;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$proceedAfterWaitChar() {
        if (this.mPostDialState != Connection.PostDialState.WAIT) {
            Rlog.w("ImsPhoneConnection", "ImsPhoneConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        this.processNextPostDialChar();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$proceedAfterWildChar(String str) {
        if (this.mPostDialState != Connection.PostDialState.WILD) {
            Rlog.w("ImsPhoneConnection", "ImsPhoneConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        StringBuilder buf = new StringBuilder(str);
        buf.append(this.mPostDialString.substring(this.mNextPostDialChar));
        this.mPostDialString = buf.toString();
        this.mNextPostDialChar = 0;
        Rlog.d("ImsPhoneConnection", "proceedAfterWildChar: new postDialString is " + this.mPostDialString);
        this.processNextPostDialChar();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$cancelPostDial() {
        this.setPostDialState(Connection.PostDialState.CANCELLED);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onHangupLocal() {
        this.mCause = 3;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onDisconnect(int cause) {
        Rlog.d("ImsPhoneConnection", "onDisconnect: cause=" + cause);
        if (this.mCause != 3) {
            this.mCause = cause;
        }
        return this.onDisconnect();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onDisconnect() {
        boolean changed = false;
        if (!this.mDisconnected) {
            this.mDisconnectTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.mDuration = SystemClock.elapsedRealtime() - this.mConnectTimeReal;
            this.mDisconnected = true;
            this.mOwner.mPhone.notifyDisconnect(this);
            if (this.mParent != null) {
                changed = this.mParent.connectionDisconnected(this);
            } else {
                Rlog.d("ImsPhoneConnection", "onDisconnect: no parent");
            }
            if (this.mImsCall != null) {
                this.mImsCall.close();
            }
            this.mImsCall = null;
        }
        this.releaseWakeLock();
        return changed;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onConnectedInOrOut() {
        this.mConnectTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mConnectTimeReal = SystemClock.elapsedRealtime();
        this.mDuration = 0L;
        Rlog.d("ImsPhoneConnection", "onConnectedInOrOut: connectTime=" + this.mConnectTime);
        if (!this.mIsIncoming) {
            this.processNextPostDialChar();
        }
        this.releaseWakeLock();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onStartedHolding() {
        this.mHoldingStartTime = SystemClock.elapsedRealtime();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            this.mOwner.mCi.sendDtmf(c, this.mHandler.obtainMessage(1));
        } else if (c == ',') {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 3000L);
        } else if (c == ';') {
            this.setPostDialState(Connection.PostDialState.WAIT);
        } else if (c == 'N') {
            this.setPostDialState(Connection.PostDialState.WILD);
        } else {
            return false;
        }
        return true;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getRemainingPostDialString() {
        if (this.mPostDialState == Connection.PostDialState.CANCELLED || this.mPostDialState == Connection.PostDialState.COMPLETE || this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            return "";
        }
        return this.mPostDialString.substring(this.mNextPostDialChar);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$finalize() {
        this.releaseWakeLock();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$processNextPostDialChar() {
        Message notifyMessage;
        char c = '\u0000';
        if (this.mPostDialState == Connection.PostDialState.CANCELLED) {
            return;
        }
        if (this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            this.setPostDialState(Connection.PostDialState.COMPLETE);
            c = '\u0000';
        } else {
            this.setPostDialState(Connection.PostDialState.STARTED);
            c = this.mPostDialString.charAt(this.mNextPostDialChar++);
            boolean isValid = this.processPostDialChar(c);
            if (!isValid) {
                this.mHandler.obtainMessage(3).sendToTarget();
                Rlog.e("ImsPhoneConnection", "processNextPostDialChar: c=" + c + " isn't valid!");
                return;
            }
        }
        Registrant postDialHandler = this.mOwner.mPhone.mPostDialHandler;
        if (postDialHandler != null && (notifyMessage = postDialHandler.messageForRegistrant()) != null) {
            Connection.PostDialState state = this.mPostDialState;
            AsyncResult ar = AsyncResult.forMessage(notifyMessage);
            ar.result = this;
            ar.userObj = state;
            notifyMessage.arg1 = c;
            notifyMessage.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setPostDialState(Connection.PostDialState s) {
        if (this.mPostDialState != Connection.PostDialState.STARTED && s == Connection.PostDialState.STARTED) {
            this.acquireWakeLock();
            Message msg = this.mHandler.obtainMessage(4);
            this.mHandler.sendMessageDelayed(msg, 60000L);
        } else if (this.mPostDialState == Connection.PostDialState.STARTED && s != Connection.PostDialState.STARTED) {
            this.mHandler.removeMessages(4);
            this.releaseWakeLock();
        }
        this.mPostDialState = s;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$createWakeLock(Context context) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mPartialWakeLock = pm.newWakeLock(1, "ImsPhoneConnection");
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$acquireWakeLock() {
        Rlog.d("ImsPhoneConnection", "acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$releaseWakeLock() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            if (this.mPartialWakeLock.isHeld()) {
                Rlog.d("ImsPhoneConnection", "releaseWakeLock");
                this.mPartialWakeLock.release();
            }
        }
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getNumberPresentation() {
        return this.mNumberPresentation;
    }

    private final UUSInfo $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getUUSInfo() {
        return this.mUusInfo;
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOrigConnection() {
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setMultiparty(boolean isMultiparty) {
        Rlog.d("ImsPhoneConnection", "setMultiparty " + isMultiparty);
        this.mIsMultiparty = isMultiparty;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$isMultiparty() {
        return this.mIsMultiparty;
    }

    private final ImsCall $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getImsCall() {
        return this.mImsCall;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setImsCall(ImsCall imsCall) {
        this.mImsCall = imsCall;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$changeParent(ImsPhoneCall parent) {
        this.mParent = parent;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$update(ImsCall imsCall, Call.State state) {
        boolean changed = false;
        if (state == Call.State.ACTIVE) {
            if (this.mParent.getState().isRinging() || this.mParent.getState().isDialing()) {
                this.onConnectedInOrOut();
            }
            if (this.mParent.getState().isRinging() || this.mParent == this.mOwner.mBackgroundCall) {
                this.mParent.detach(this);
                this.mParent = this.mOwner.mForegroundCall;
                this.mParent.attach(this);
            }
        } else if (state == Call.State.HOLDING) {
            this.onStartedHolding();
        }
        changed = this.mParent.update(this, imsCall, state);
        if (imsCall != null) {
            try {
                ImsCallProfile localCallProfile = imsCall.getLocalCallProfile();
                if (localCallProfile != null) {
                    boolean newLocalVideoCapable;
                    int localCallTypeCapability = localCallProfile.mCallType;
                    boolean bl = newLocalVideoCapable = localCallTypeCapability == 4;
                    if (this.isLocalVideoCapable() != newLocalVideoCapable) {
                        this.setLocalVideoCapable(newLocalVideoCapable);
                        changed = true;
                    }
                }
            }
            catch (ImsException localCallProfile) {
                // empty catch block
            }
            ImsCallProfile callProfile = imsCall.getCallProfile();
            if (callProfile != null) {
                int newAudioQuality;
                int oldAudioQuality;
                ImsStreamMediaProfile mediaProfile;
                int newVideoState;
                int oldVideoState = this.getVideoState();
                if (oldVideoState != (newVideoState = ImsCallProfile.getVideoStateFromCallType(callProfile.mCallType))) {
                    this.setVideoState(newVideoState);
                    changed = true;
                }
                if ((mediaProfile = callProfile.mMediaProfile) != null && (oldAudioQuality = this.getAudioQuality()) != (newAudioQuality = this.getAudioQualityFromMediaProfile(mediaProfile))) {
                    this.setAudioQuality(newAudioQuality);
                    changed = true;
                }
            }
        }
        return changed;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getPreciseDisconnectCause() {
        return 0;
    }

    private void __constructor__(Context context, ImsCall imsCall, ImsPhoneCallTracker imsPhoneCallTracker, ImsPhoneCall imsPhoneCall) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(context, imsCall, imsPhoneCallTracker, imsPhoneCall);
    }

    ImsPhoneConnection(Context context, ImsCall imsCall, ImsPhoneCallTracker imsPhoneCallTracker, ImsPhoneCall imsPhoneCall) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(android.content.Context com.android.ims.ImsCall com.android.internal.telephony.imsphone.ImsPhoneCallTracker com.android.internal.telephony.imsphone.ImsPhoneCall ), 0, this, context, imsCall, imsPhoneCallTracker, imsPhoneCall);
    }

    private void __constructor__(Context context, String string2, ImsPhoneCallTracker imsPhoneCallTracker, ImsPhoneCall imsPhoneCall) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(context, string2, imsPhoneCallTracker, imsPhoneCall);
    }

    ImsPhoneConnection(Context context, String string2, ImsPhoneCallTracker imsPhoneCallTracker, ImsPhoneCall imsPhoneCall) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$__constructor__(android.content.Context java.lang.String com.android.internal.telephony.imsphone.ImsPhoneCallTracker com.android.internal.telephony.imsphone.ImsPhoneCall ), 0, this, context, string2, imsPhoneCallTracker, imsPhoneCall);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$dispose(), 0, this);
    }

    static boolean equalsHandlesNulls(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equalsHandlesNulls", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$equalsHandlesNulls(java.lang.Object java.lang.Object ), 0, (Object)object, (Object)object2);
    }

    private int getAudioQualityFromMediaProfile(ImsStreamMediaProfile imsStreamMediaProfile) {
        return (int)InvokeDynamicSupport.bootstrap("getAudioQualityFromMediaProfile", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getAudioQualityFromMediaProfile(com.android.ims.ImsStreamMediaProfile ), 0, this, imsStreamMediaProfile);
    }

    @Override
    public String getOrigDialString() {
        return InvokeDynamicSupport.bootstrap("getOrigDialString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOrigDialString(), 0, this);
    }

    @Override
    public ImsPhoneCall getCall() {
        return InvokeDynamicSupport.bootstrap("getCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getCall(), 0, this);
    }

    @Override
    public long getDisconnectTime() {
        return (long)InvokeDynamicSupport.bootstrap("getDisconnectTime", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getDisconnectTime(), 0, this);
    }

    @Override
    public long getHoldingStartTime() {
        return (long)InvokeDynamicSupport.bootstrap("getHoldingStartTime", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getHoldingStartTime(), 0, this);
    }

    @Override
    public long getHoldDurationMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getHoldDurationMillis", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getHoldDurationMillis(), 0, this);
    }

    @Override
    public int getDisconnectCause() {
        return (int)InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getDisconnectCause(), 0, this);
    }

    public void setDisconnectCause(int n) {
        InvokeDynamicSupport.bootstrap("setDisconnectCause", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setDisconnectCause(int ), 0, this, n);
    }

    public ImsPhoneCallTracker getOwner() {
        return InvokeDynamicSupport.bootstrap("getOwner", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOwner(), 0, this);
    }

    @Override
    public Call.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getState(), 0, this);
    }

    @Override
    public void hangup() throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$hangup(), 0, this);
    }

    @Override
    public void separate() throws CallStateException {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$separate(), 0, this);
    }

    @Override
    public Connection.PostDialState getPostDialState() {
        return InvokeDynamicSupport.bootstrap("getPostDialState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getPostDialState(), 0, this);
    }

    @Override
    public void proceedAfterWaitChar() {
        InvokeDynamicSupport.bootstrap("proceedAfterWaitChar", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$proceedAfterWaitChar(), 0, this);
    }

    @Override
    public void proceedAfterWildChar(String string2) {
        InvokeDynamicSupport.bootstrap("proceedAfterWildChar", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$proceedAfterWildChar(java.lang.String ), 0, this, string2);
    }

    @Override
    public void cancelPostDial() {
        InvokeDynamicSupport.bootstrap("cancelPostDial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$cancelPostDial(), 0, this);
    }

    void onHangupLocal() {
        InvokeDynamicSupport.bootstrap("onHangupLocal", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onHangupLocal(), 0, this);
    }

    boolean onDisconnect(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onDisconnect(int ), 0, this, n);
    }

    boolean onDisconnect() {
        return (boolean)InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onDisconnect(), 0, this);
    }

    void onConnectedInOrOut() {
        InvokeDynamicSupport.bootstrap("onConnectedInOrOut", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onConnectedInOrOut(), 0, this);
    }

    void onStartedHolding() {
        InvokeDynamicSupport.bootstrap("onStartedHolding", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$onStartedHolding(), 0, this);
    }

    private boolean processPostDialChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("processPostDialChar", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$processPostDialChar(char ), 0, this, c);
    }

    @Override
    public String getRemainingPostDialString() {
        return InvokeDynamicSupport.bootstrap("getRemainingPostDialString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getRemainingPostDialString(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$finalize(), 0, this);
    }

    private void processNextPostDialChar() {
        InvokeDynamicSupport.bootstrap("processNextPostDialChar", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$processNextPostDialChar(), 0, this);
    }

    private void setPostDialState(Connection.PostDialState postDialState) {
        InvokeDynamicSupport.bootstrap("setPostDialState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setPostDialState(com.android.internal.telephony.Connection$PostDialState ), 0, this, postDialState);
    }

    private void createWakeLock(Context context) {
        InvokeDynamicSupport.bootstrap("createWakeLock", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$createWakeLock(android.content.Context ), 0, this, context);
    }

    private void acquireWakeLock() {
        InvokeDynamicSupport.bootstrap("acquireWakeLock", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$acquireWakeLock(), 0, this);
    }

    void releaseWakeLock() {
        InvokeDynamicSupport.bootstrap("releaseWakeLock", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$releaseWakeLock(), 0, this);
    }

    @Override
    public int getNumberPresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberPresentation", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getNumberPresentation(), 0, this);
    }

    @Override
    public UUSInfo getUUSInfo() {
        return InvokeDynamicSupport.bootstrap("getUUSInfo", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getUUSInfo(), 0, this);
    }

    @Override
    public Connection getOrigConnection() {
        return InvokeDynamicSupport.bootstrap("getOrigConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getOrigConnection(), 0, this);
    }

    void setMultiparty(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMultiparty", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setMultiparty(boolean ), 0, this, bl);
    }

    @Override
    public boolean isMultiparty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiparty", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$isMultiparty(), 0, this);
    }

    ImsCall getImsCall() {
        return InvokeDynamicSupport.bootstrap("getImsCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getImsCall(), 0, this);
    }

    void setImsCall(ImsCall imsCall) {
        InvokeDynamicSupport.bootstrap("setImsCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$setImsCall(com.android.ims.ImsCall ), 0, this, imsCall);
    }

    void changeParent(ImsPhoneCall imsPhoneCall) {
        InvokeDynamicSupport.bootstrap("changeParent", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$changeParent(com.android.internal.telephony.imsphone.ImsPhoneCall ), 0, this, imsPhoneCall);
    }

    boolean update(ImsCall imsCall, Call.State state) {
        return (boolean)InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$update(com.android.ims.ImsCall com.android.internal.telephony.Call$State ), 0, this, imsCall, state);
    }

    @Override
    public int getPreciseDisconnectCause() {
        return (int)InvokeDynamicSupport.bootstrap("getPreciseDisconnectCause", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection$getPreciseDisconnectCause(), 0, this);
    }

    public /* synthetic */ ImsPhoneConnection() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsPhoneConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ImsPhoneConnection this$0;

        private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection_MyHandler$__constructor__(ImsPhoneConnection imsPhoneConnection, Looper l) {
        }

        private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection_MyHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: 
                case 3: {
                    this.this$0.processNextPostDialChar();
                    break;
                }
                case 4: {
                    this.this$0.releaseWakeLock();
                }
            }
        }

        private void __constructor__(ImsPhoneConnection imsPhoneConnection, Looper looper) {
            this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection_MyHandler$__constructor__(imsPhoneConnection, looper);
        }

        MyHandler(ImsPhoneConnection imsPhoneConnection, Looper looper) {
            this.this$0 = imsPhoneConnection;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection_MyHandler$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneConnection android.os.Looper ), 0, this, imsPhoneConnection, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneConnection_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

