/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RuimRecords
extends IccRecords
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "RuimRecords";
    private boolean mOtaCommited;
    private String mMyMobileNumber;
    private String mMin2Min1;
    private String mPrlVersion;
    private byte[] mEFpl;
    private byte[] mEFli;
    boolean mCsimSpnDisplayCondition;
    private String mMdn;
    private String mMin;
    private String mHomeSystemId;
    private String mHomeNetworkId;
    private static int EVENT_GET_IMSI_DONE = 3;
    private static int EVENT_GET_DEVICE_IDENTITY_DONE = 4;
    private static int EVENT_GET_ICCID_DONE = 5;
    private static int EVENT_GET_CDMA_SUBSCRIPTION_DONE = 10;
    private static int EVENT_UPDATE_DONE = 14;
    private static int EVENT_GET_SST_DONE = 17;
    private static int EVENT_GET_ALL_SMS_DONE = 18;
    private static int EVENT_MARK_SMS_READ_DONE = 19;
    private static int EVENT_SMS_ON_RUIM = 21;
    private static int EVENT_GET_SMS_DONE = 22;
    private static int EVENT_RUIM_REFRESH = 31;

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$toString() {
        return "RuimRecords: " + super.toString() + " m_ota_commited" + this.mOtaCommited + " mMyMobileNumber=" + "xxxx" + " mMin2Min1=" + this.mMin2Min1 + " mPrlVersion=" + this.mPrlVersion + " mEFpl=" + this.mEFpl + " mEFli=" + this.mEFli + " mCsimSpnDisplayCondition=" + this.mCsimSpnDisplayCondition + " mMdn=" + this.mMdn + " mMin=" + this.mMin + " mHomeSystemId=" + this.mHomeSystemId + " mHomeNetworkId=" + this.mHomeNetworkId;
    }

    private void $$robo$$com_android_internal_telephony_uicc_RuimRecords$__constructor__(UiccCardApplication app, Context c, CommandsInterface ci) {
        this.mOtaCommited = false;
        this.mEFpl = null;
        this.mEFli = null;
        this.mCsimSpnDisplayCondition = false;
        this.mAdnCache = new AdnRecordCache(this.mFh);
        this.mRecordsRequested = false;
        this.mRecordsToLoad = 0;
        this.mCi.registerForIccRefresh(this, 31, null);
        this.resetRecords();
        this.mParentApp.registerForReady(this, 1, null);
        this.log("RuimRecords X ctor this=" + this);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$dispose() {
        this.log("Disposing RuimRecords " + this);
        this.mCi.unregisterForIccRefresh(this);
        this.mParentApp.unregisterForReady(this);
        this.resetRecords();
        super.dispose();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$finalize() {
        this.log("RuimRecords finalized");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$resetRecords() {
        this.mCountVoiceMessages = 0;
        this.mMncLength = -1;
        this.log("setting0 mMncLength" + this.mMncLength);
        this.mIccId = null;
        this.mAdnCache.reset();
        this.mRecordsRequested = false;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getIMSI() {
        return this.mImsi;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMdnNumber() {
        return this.mMyMobileNumber;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getCdmaMin() {
        return this.mMin2Min1;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getPrlVersion() {
        return this.mPrlVersion;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
        AsyncResult.forMessage((Message)onComplete).exception = new IccException("setVoiceMailNumber not implemented");
        onComplete.sendToTarget();
        this.loge("method setVoiceMailNumber is not implemented");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onRefresh(boolean fileChanged, int[] fileList) {
        if (fileChanged) {
            this.fetchRuimRecords();
        }
    }

    private final int $$robo$$com_android_internal_telephony_uicc_RuimRecords$adjstMinDigits(int digits) {
        digits = (digits += 111) % 10 == 0 ? digits - 10 : digits;
        digits = digits / 10 % 10 == 0 ? digits - 100 : digits;
        digits = digits / 100 % 10 == 0 ? digits - 1000 : digits;
        return digits;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getRUIMOperatorNumeric() {
        if (this.mImsi == null) {
            return null;
        }
        if (this.mMncLength != -1 && this.mMncLength != 0) {
            return this.mImsi.substring(0, 3 + this.mMncLength);
        }
        int mcc = Integer.parseInt(this.mImsi.substring(0, 3));
        return this.mImsi.substring(0, 3 + MccTable.smallestDigitsMccForMnc(mcc));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onGetCSimEprlDone(AsyncResult ar) {
        byte[] data = (byte[])ar.result;
        this.log("CSIM_EPRL=" + IccUtils.bytesToHexString(data));
        if (data.length > 3) {
            int prlId = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
            this.mPrlVersion = Integer.toString(prlId);
        }
        this.log("CSIM PRL version=" + this.mPrlVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$handleMessage(Message msg) {
        boolean isRecordLoadResponse = false;
        if (this.mDestroyed.get()) {
            this.loge("Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        try {
            switch (msg.what) {
                case 1: {
                    this.onReady();
                    return;
                }
                case 4: {
                    this.log("Event EVENT_GET_DEVICE_IDENTITY_DONE Received");
                    return;
                }
                case 3: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.loge("Exception querying IMSI, Exception:" + ar.exception);
                        return;
                    } else {
                        this.mImsi = (String)ar.result;
                        if (this.mImsi != null && (this.mImsi.length() < 6 || this.mImsi.length() > 15)) {
                            this.loge("invalid IMSI " + this.mImsi);
                            this.mImsi = null;
                        }
                        String operatorNumeric = this.getRUIMOperatorNumeric();
                        this.log("NO update mccmnc=" + operatorNumeric);
                        return;
                    }
                }
                case 10: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    String[] localTemp = (String[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.mMyMobileNumber = localTemp[0];
                        this.mMin2Min1 = localTemp[3];
                        this.mPrlVersion = localTemp[4];
                        this.log("MDN: " + this.mMyMobileNumber + " MIN: " + this.mMin2Min1);
                        return;
                    }
                }
                case 5: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.mIccId = IccUtils.bcdToString(data, 0, data.length);
                        this.log("iccid: " + this.mIccId);
                        return;
                    }
                }
                case 14: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) return;
                    Rlog.i("RuimRecords", "RuimRecords update failed", ar.exception);
                    return;
                }
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    Rlog.w("RuimRecords", "Event not supported: " + msg.what);
                    return;
                }
                case 17: {
                    this.log("Event EVENT_GET_SST_DONE Received");
                    return;
                }
                case 31: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) return;
                    this.handleRuimRefresh((IccRefreshResponse)ar.result);
                    return;
                }
                default: {
                    super.handleMessage(msg);
                    return;
                }
            }
        }
        catch (RuntimeException exc) {
            Rlog.w("RuimRecords", "Exception parsing RUIM record", exc);
            return;
        }
        finally {
            if (isRecordLoadResponse) {
                this.onRecordLoaded();
            }
        }
    }

    private static final String[] $$robo$$com_android_internal_telephony_uicc_RuimRecords$getAssetLanguages(Context ctx) {
        String[] locales = ctx.getAssets().getLocales();
        String[] localeLangs = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            String localeStr = locales[i];
            int separator = localeStr.indexOf(45);
            localeLangs[i] = separator < 0 ? localeStr : localeStr.substring(0, separator);
        }
        return localeLangs;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$findBestLanguage(byte[] languages) {
        String[] assetLanguages = RuimRecords.getAssetLanguages(this.mContext);
        if (languages == null || assetLanguages == null) {
            return null;
        }
        int i = 0;
        while (i + 1 < languages.length) {
            block5: {
                String lang;
                try {
                    lang = new String(languages, i, 2, "ISO-8859-1");
                }
                catch (UnsupportedEncodingException e) {
                    this.log("Failed to parse SIM language records");
                    break block5;
                }
                for (int j = 0; j < assetLanguages.length; ++j) {
                    if (!assetLanguages[j].equals(lang)) continue;
                    return lang;
                }
            }
            i += 2;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$setLocaleFromCsim() {
        String prefLang = null;
        prefLang = this.findBestLanguage(this.mEFli);
        if (prefLang == null) {
            prefLang = this.findBestLanguage(this.mEFpl);
        }
        if (prefLang != null) {
            String imsi = this.getIMSI();
            String country = null;
            if (imsi != null) {
                country = MccTable.countryCodeForMcc(Integer.parseInt(imsi.substring(0, 3)));
            }
            this.log("Setting locale to " + prefLang + "_" + country);
            MccTable.setSystemLocale(this.mContext, prefLang, country);
        } else {
            this.log("No suitable CSIM selected locale");
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onRecordLoaded() {
        --this.mRecordsToLoad;
        this.log("onRecordLoaded " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
        if (this.mRecordsToLoad == 0 && this.mRecordsRequested) {
            this.onAllRecordsLoaded();
        } else if (this.mRecordsToLoad < 0) {
            this.loge("recordsToLoad <0, programmer error suspected");
            this.mRecordsToLoad = 0;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onAllRecordsLoaded() {
        this.log("record load complete");
        this.setLocaleFromCsim();
        this.mRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onReady() {
        this.fetchRuimRecords();
        this.mCi.getCDMASubscription(this.obtainMessage(10));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$fetchRuimRecords() {
        this.mRecordsRequested = true;
        this.log("fetchRuimRecords " + this.mRecordsToLoad);
        this.mCi.getIMSIForApp(this.mParentApp.getAid(), this.obtainMessage(3));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(12258, this.obtainMessage(5));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(12037, this.obtainMessage(100, new EfPlLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28474, this.obtainMessage(100, new EfCsimLiLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28481, this.obtainMessage(100, new EfCsimSpnLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28484, 1, this.obtainMessage(100, new EfCsimMdnLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28450, this.obtainMessage(100, new EfCsimImsimLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixedAll(28456, this.obtainMessage(100, new EfCsimCdmaHomeLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28506, 4, this.obtainMessage(100, new EfCsimEprlLoaded(this)));
        ++this.mRecordsToLoad;
        this.log("fetchRuimRecords " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_RuimRecords$getDisplayRule(String plmn) {
        return 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_RuimRecords$isProvisioned() {
        if (SystemProperties.getBoolean("persist.radio.test-csim", false)) {
            return true;
        }
        if (this.mParentApp == null) {
            return false;
        }
        return this.mParentApp.getType() != IccCardApplicationStatus.AppType.APPTYPE_CSIM || this.mMdn != null && this.mMin != null;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$setVoiceMessageWaiting(int line, int countWaiting) {
        if (line != 1) {
            return;
        }
        if (countWaiting < 0) {
            countWaiting = -1;
        } else if (countWaiting > 255) {
            countWaiting = 255;
        }
        this.mCountVoiceMessages = countWaiting;
        this.mRecordsEventsRegistrants.notifyResult(0);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$handleRuimRefresh(IccRefreshResponse refreshResponse) {
        if (refreshResponse == null) {
            this.log("handleRuimRefresh received without input");
            return;
        }
        if (refreshResponse.aid != null && !refreshResponse.aid.equals(this.mParentApp.getAid())) {
            return;
        }
        switch (refreshResponse.refreshResult) {
            case 0: {
                this.log("handleRuimRefresh with SIM_REFRESH_FILE_UPDATED");
                this.mAdnCache.reset();
                this.fetchRuimRecords();
                break;
            }
            case 1: {
                this.log("handleRuimRefresh with SIM_REFRESH_INIT");
                this.onIccRefreshInit();
                break;
            }
            case 2: {
                this.log("handleRuimRefresh with SIM_REFRESH_RESET");
                if (!this.requirePowerOffOnSimRefreshReset()) break;
                this.mCi.setRadioPower(false, null);
                break;
            }
            default: {
                this.log("handleRuimRefresh with unknown operation");
            }
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMdn() {
        return this.mMdn;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMin() {
        return this.mMin;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getSid() {
        return this.mHomeSystemId;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getNid() {
        return this.mHomeNetworkId;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_RuimRecords$getCsimSpnDisplayCondition() {
        return this.mCsimSpnDisplayCondition;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$log(String s) {
        Rlog.d("RuimRecords", "[RuimRecords] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$loge(String s) {
        Rlog.e("RuimRecords", "[RuimRecords] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("RuimRecords: " + this);
        pw.println(" extends:");
        super.dump(fd, pw, args);
        pw.println(" mOtaCommited=" + this.mOtaCommited);
        pw.println(" mMyMobileNumber=" + this.mMyMobileNumber);
        pw.println(" mMin2Min1=" + this.mMin2Min1);
        pw.println(" mPrlVersion=" + this.mPrlVersion);
        pw.println(" mEFpl[]=" + Arrays.toString(this.mEFpl));
        pw.println(" mEFli[]=" + Arrays.toString(this.mEFli));
        pw.println(" mCsimSpnDisplayCondition=" + this.mCsimSpnDisplayCondition);
        pw.println(" mMdn=" + this.mMdn);
        pw.println(" mMin=" + this.mMin);
        pw.println(" mHomeSystemId=" + this.mHomeSystemId);
        pw.println(" mHomeNetworkId=" + this.mHomeNetworkId);
        pw.flush();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$setSystemProperty(String key, String val) {
        if (!TelephonyManager.getDefault().isMultiSimEnabled()) {
            SystemProperties.set(key, val);
        }
    }

    static /* synthetic */ byte[] access$002(RuimRecords x0, byte[] x1) {
        x0.mEFpl = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(RuimRecords x0, byte[] x1) {
        x0.mEFli = x1;
        return x1;
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_uicc_RuimRecords$toString(), 0, this);
    }

    private void __constructor__(UiccCardApplication uiccCardApplication, Context context, CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_uicc_RuimRecords$__constructor__(uiccCardApplication, context, commandsInterface);
    }

    public RuimRecords(UiccCardApplication uiccCardApplication, Context context, CommandsInterface commandsInterface) {
        super(uiccCardApplication, context, commandsInterface);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords$__constructor__(com.android.internal.telephony.uicc.UiccCardApplication android.content.Context com.android.internal.telephony.CommandsInterface ), 0, this, uiccCardApplication, context, commandsInterface);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_uicc_RuimRecords$dispose(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_uicc_RuimRecords$finalize(), 0, this);
    }

    protected void resetRecords() {
        InvokeDynamicSupport.bootstrap("resetRecords", $$robo$$com_android_internal_telephony_uicc_RuimRecords$resetRecords(), 0, this);
    }

    @Override
    public String getIMSI() {
        return InvokeDynamicSupport.bootstrap("getIMSI", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getIMSI(), 0, this);
    }

    public String getMdnNumber() {
        return InvokeDynamicSupport.bootstrap("getMdnNumber", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMdnNumber(), 0, this);
    }

    public String getCdmaMin() {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getCdmaMin(), 0, this);
    }

    public String getPrlVersion() {
        return InvokeDynamicSupport.bootstrap("getPrlVersion", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getPrlVersion(), 0, this);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$com_android_internal_telephony_uicc_RuimRecords$setVoiceMailNumber(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void onRefresh(boolean bl, int[] nArray) {
        InvokeDynamicSupport.bootstrap("onRefresh", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onRefresh(boolean int[] ), 0, this, bl, nArray);
    }

    private int adjstMinDigits(int n) {
        return (int)InvokeDynamicSupport.bootstrap("adjstMinDigits", $$robo$$com_android_internal_telephony_uicc_RuimRecords$adjstMinDigits(int ), 0, this, n);
    }

    public String getRUIMOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getRUIMOperatorNumeric", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getRUIMOperatorNumeric(), 0, this);
    }

    private void onGetCSimEprlDone(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onGetCSimEprlDone", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onGetCSimEprlDone(android.os.AsyncResult ), 0, this, asyncResult);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_RuimRecords$handleMessage(android.os.Message ), 0, this, message);
    }

    private static String[] getAssetLanguages(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getAssetLanguages", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getAssetLanguages(android.content.Context ), 0, (Context)context);
    }

    private String findBestLanguage(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("findBestLanguage", $$robo$$com_android_internal_telephony_uicc_RuimRecords$findBestLanguage(byte[] ), 0, this, byArray);
    }

    private void setLocaleFromCsim() {
        InvokeDynamicSupport.bootstrap("setLocaleFromCsim", $$robo$$com_android_internal_telephony_uicc_RuimRecords$setLocaleFromCsim(), 0, this);
    }

    @Override
    protected void onRecordLoaded() {
        InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onRecordLoaded(), 0, this);
    }

    @Override
    protected void onAllRecordsLoaded() {
        InvokeDynamicSupport.bootstrap("onAllRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onAllRecordsLoaded(), 0, this);
    }

    @Override
    public void onReady() {
        InvokeDynamicSupport.bootstrap("onReady", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onReady(), 0, this);
    }

    private void fetchRuimRecords() {
        InvokeDynamicSupport.bootstrap("fetchRuimRecords", $$robo$$com_android_internal_telephony_uicc_RuimRecords$fetchRuimRecords(), 0, this);
    }

    @Override
    public int getDisplayRule(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getDisplayRule", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getDisplayRule(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isProvisioned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProvisioned", $$robo$$com_android_internal_telephony_uicc_RuimRecords$isProvisioned(), 0, this);
    }

    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVoiceMessageWaiting", $$robo$$com_android_internal_telephony_uicc_RuimRecords$setVoiceMessageWaiting(int int ), 0, this, n, n2);
    }

    private void handleRuimRefresh(IccRefreshResponse iccRefreshResponse) {
        InvokeDynamicSupport.bootstrap("handleRuimRefresh", $$robo$$com_android_internal_telephony_uicc_RuimRecords$handleRuimRefresh(com.android.internal.telephony.uicc.IccRefreshResponse ), 0, this, iccRefreshResponse);
    }

    public String getMdn() {
        return InvokeDynamicSupport.bootstrap("getMdn", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMdn(), 0, this);
    }

    public String getMin() {
        return InvokeDynamicSupport.bootstrap("getMin", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMin(), 0, this);
    }

    public String getSid() {
        return InvokeDynamicSupport.bootstrap("getSid", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getSid(), 0, this);
    }

    public String getNid() {
        return InvokeDynamicSupport.bootstrap("getNid", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getNid(), 0, this);
    }

    public boolean getCsimSpnDisplayCondition() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCsimSpnDisplayCondition", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getCsimSpnDisplayCondition(), 0, this);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_RuimRecords$log(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_uicc_RuimRecords$loge(java.lang.String ), 0, this, string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_RuimRecords$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    private void setSystemProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSystemProperty", $$robo$$com_android_internal_telephony_uicc_RuimRecords$setSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public /* synthetic */ RuimRecords() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RuimRecords)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class EfCsimEprlLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$getEfName() {
            return "EF_CSIM_EPRL";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$onRecordLoaded(AsyncResult ar) {
            this.this$0.onGetCSimEprlDone(ar);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$__constructor__(ruimRecords);
        }

        private EfCsimEprlLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimEprlLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimEprlLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimCdmaHomeLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$getEfName() {
            return "EF_CSIM_CDMAHOME";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$onRecordLoaded(AsyncResult ar) {
            ArrayList dataList = (ArrayList)ar.result;
            this.this$0.log("CSIM_CDMAHOME data size=" + dataList.size());
            if (dataList.isEmpty()) {
                return;
            }
            StringBuilder sidBuf = new StringBuilder();
            StringBuilder nidBuf = new StringBuilder();
            for (byte[] data : dataList) {
                if (data.length != 5) continue;
                int sid = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
                int nid = (data[3] & 0xFF) << 8 | data[2] & 0xFF;
                sidBuf.append(sid).append(',');
                nidBuf.append(nid).append(',');
            }
            sidBuf.setLength(sidBuf.length() - 1);
            nidBuf.setLength(nidBuf.length() - 1);
            this.this$0.mHomeSystemId = sidBuf.toString();
            this.this$0.mHomeNetworkId = nidBuf.toString();
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$__constructor__(ruimRecords);
        }

        private EfCsimCdmaHomeLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimCdmaHomeLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimCdmaHomeLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimImsimLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$getEfName() {
            return "EF_CSIM_IMSIM";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$onRecordLoaded(AsyncResult ar) {
            boolean provisioned;
            byte[] data = (byte[])ar.result;
            this.this$0.log("CSIM_IMSIM=" + IccUtils.bytesToHexString(data));
            boolean bl = provisioned = (data[7] & 0x80) == 128;
            if (provisioned) {
                int first3digits = ((3 & data[2]) << 8) + (0xFF & data[1]);
                int second3digits = ((0xFF & data[5]) << 8 | 0xFF & data[4]) >> 6;
                int digit7 = 0xF & data[4] >> 2;
                if (digit7 > 9) {
                    digit7 = 0;
                }
                int last3digits = (3 & data[4]) << 8 | 0xFF & data[3];
                first3digits = this.this$0.adjstMinDigits(first3digits);
                second3digits = this.this$0.adjstMinDigits(second3digits);
                last3digits = this.this$0.adjstMinDigits(last3digits);
                StringBuilder builder = new StringBuilder();
                builder.append(String.format(Locale.US, "%03d", first3digits));
                builder.append(String.format(Locale.US, "%03d", second3digits));
                builder.append(String.format(Locale.US, "%d", digit7));
                builder.append(String.format(Locale.US, "%03d", last3digits));
                this.this$0.mMin = builder.toString();
                this.this$0.log("min present=" + this.this$0.mMin);
            } else {
                this.this$0.log("min not present");
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$__constructor__(ruimRecords);
        }

        private EfCsimImsimLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimImsimLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimImsimLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimMdnLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$getEfName() {
            return "EF_CSIM_MDN";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            this.this$0.log("CSIM_MDN=" + IccUtils.bytesToHexString(data));
            int mdnDigitsNum = 0xF & data[0];
            this.this$0.mMdn = IccUtils.cdmaBcdToString(data, 1, mdnDigitsNum);
            this.this$0.log("CSIM MDN=" + this.this$0.mMdn);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$__constructor__(ruimRecords);
        }

        private EfCsimMdnLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimMdnLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimMdnLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimSpnLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$getEfName() {
            return "EF_CSIM_SPN";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$onRecordLoaded(AsyncResult ar) {
            int numBytes;
            byte[] data = (byte[])ar.result;
            this.this$0.log("CSIM_SPN=" + IccUtils.bytesToHexString(data));
            this.this$0.mCsimSpnDisplayCondition = (1 & data[0]) != 0;
            byte encoding = data[1];
            byte language = data[2];
            byte[] spnData = new byte[32];
            int len = data.length - 3 < 32 ? data.length - 3 : 32;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)3, (byte[])spnData, (int)0, (int)len);
            for (numBytes = 0; numBytes < spnData.length && (spnData[numBytes] & 0xFF) != 255; ++numBytes) {
            }
            if (numBytes == 0) {
                this.this$0.setServiceProviderName("");
                return;
            }
            try {
                switch (encoding) {
                    case 0: 
                    case 8: {
                        this.this$0.setServiceProviderName(new String(spnData, 0, numBytes, "ISO-8859-1"));
                        break;
                    }
                    case 3: 
                    case 9: {
                        this.this$0.setServiceProviderName(GsmAlphabet.gsm7BitPackedToString(spnData, 0, numBytes * 8 / 7));
                        break;
                    }
                    case 2: {
                        String spn = new String(spnData, 0, numBytes, "US-ASCII");
                        if (TextUtils.isPrintableAsciiOnly(spn)) {
                            this.this$0.setServiceProviderName(spn);
                            break;
                        }
                        this.this$0.log("Some corruption in SPN decoding = " + spn);
                        this.this$0.log("Using ENCODING_GSM_7BIT_ALPHABET scheme...");
                        this.this$0.setServiceProviderName(GsmAlphabet.gsm7BitPackedToString(spnData, 0, numBytes * 8 / 7));
                        break;
                    }
                    case 4: {
                        this.this$0.setServiceProviderName(new String(spnData, 0, numBytes, "utf-16"));
                        break;
                    }
                    default: {
                        this.this$0.log("SPN encoding not supported");
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.this$0.log("spn decode error: " + e);
            }
            this.this$0.log("spn=" + this.this$0.getServiceProviderName());
            this.this$0.log("spnCondition=" + this.this$0.mCsimSpnDisplayCondition);
            SystemProperties.set("gsm.sim.operator.alpha", this.this$0.getServiceProviderName());
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$__constructor__(ruimRecords);
        }

        private EfCsimSpnLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimSpnLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimSpnLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimLiLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$getEfName() {
            return "EF_CSIM_LI";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$onRecordLoaded(AsyncResult ar) {
            RuimRecords.access$102(this.this$0, (byte[])ar.result);
            block9: for (int i = 0; i < this.this$0.mEFli.length; i += 2) {
                switch (this.this$0.mEFli[i + 1]) {
                    case 1: {
                        ((RuimRecords)this.this$0).mEFli[i] = 101;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 110;
                        continue block9;
                    }
                    case 2: {
                        ((RuimRecords)this.this$0).mEFli[i] = 102;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 114;
                        continue block9;
                    }
                    case 3: {
                        ((RuimRecords)this.this$0).mEFli[i] = 101;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 115;
                        continue block9;
                    }
                    case 4: {
                        ((RuimRecords)this.this$0).mEFli[i] = 106;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 97;
                        continue block9;
                    }
                    case 5: {
                        ((RuimRecords)this.this$0).mEFli[i] = 107;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 111;
                        continue block9;
                    }
                    case 6: {
                        ((RuimRecords)this.this$0).mEFli[i] = 122;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 104;
                        continue block9;
                    }
                    case 7: {
                        ((RuimRecords)this.this$0).mEFli[i] = 104;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 101;
                        continue block9;
                    }
                    default: {
                        ((RuimRecords)this.this$0).mEFli[i] = 32;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 32;
                    }
                }
            }
            this.this$0.log("EF_LI=" + IccUtils.bytesToHexString(this.this$0.mEFli));
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$__constructor__(ruimRecords);
        }

        private EfCsimLiLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimLiLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimLiLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfPlLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$getEfName() {
            return "EF_PL";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$onRecordLoaded(AsyncResult ar) {
            RuimRecords.access$002(this.this$0, (byte[])ar.result);
            this.this$0.log("EF_PL=" + IccUtils.bytesToHexString(this.this$0.mEFpl));
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$__constructor__(ruimRecords);
        }

        private EfPlLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfPlLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfPlLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

