/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.AdnRecordLoader;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.IccVmFixedException;
import com.android.internal.telephony.uicc.IccVmNotSupportedException;
import com.android.internal.telephony.uicc.SpnOverride;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UsimServiceTable;
import com.android.internal.telephony.uicc.VoiceMailConstants;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SIMRecords
extends IccRecords
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static String LOG_TAG = "SIMRecords";
    private static boolean CRASH_RIL = false;
    VoiceMailConstants mVmConfig;
    SpnOverride mSpnOverride;
    private boolean mCallForwardingEnabled;
    private GetSpnFsmState mSpnState;
    private byte[] mCphsInfo;
    boolean mCspPlmnEnabled;
    byte[] mEfMWIS;
    byte[] mEfCPHS_MWI;
    byte[] mEfCff;
    byte[] mEfCfis;
    byte[] mEfLi;
    byte[] mEfPl;
    int mSpnDisplayCondition;
    ArrayList<String> mSpdiNetworks;
    String mPnnHomeName;
    UsimServiceTable mUsimServiceTable;
    static int TAG_SPDI = 163;
    static int TAG_SPDI_PLMN_LIST = 128;
    static int TAG_FULL_NETWORK_NAME = 67;
    static int TAG_SHORT_NETWORK_NAME = 69;
    static int CFF_UNCONDITIONAL_ACTIVE = 10;
    static int CFF_UNCONDITIONAL_DEACTIVE = 5;
    static int CFF_LINE1_MASK = 15;
    static int CFF_LINE1_RESET = 240;
    private static int CPHS_SST_MBN_MASK = 48;
    private static int CPHS_SST_MBN_ENABLED = 48;
    private static int CFIS_BCD_NUMBER_LENGTH_OFFSET = 2;
    private static int CFIS_TON_NPI_OFFSET = 3;
    private static int CFIS_ADN_CAPABILITY_ID_OFFSET = 14;
    private static int CFIS_ADN_EXTENSION_ID_OFFSET = 15;
    private static int EVENT_GET_IMSI_DONE = 3;
    private static int EVENT_GET_ICCID_DONE = 4;
    private static int EVENT_GET_MBI_DONE = 5;
    private static int EVENT_GET_MBDN_DONE = 6;
    private static int EVENT_GET_MWIS_DONE = 7;
    private static int EVENT_GET_VOICE_MAIL_INDICATOR_CPHS_DONE = 8;
    protected static int EVENT_GET_AD_DONE = 9;
    protected static int EVENT_GET_MSISDN_DONE = 10;
    private static int EVENT_GET_CPHS_MAILBOX_DONE = 11;
    private static int EVENT_GET_SPN_DONE = 12;
    private static int EVENT_GET_SPDI_DONE = 13;
    private static int EVENT_UPDATE_DONE = 14;
    private static int EVENT_GET_PNN_DONE = 15;
    protected static int EVENT_GET_SST_DONE = 17;
    private static int EVENT_GET_ALL_SMS_DONE = 18;
    private static int EVENT_MARK_SMS_READ_DONE = 19;
    private static int EVENT_SET_MBDN_DONE = 20;
    private static int EVENT_SMS_ON_SIM = 21;
    private static int EVENT_GET_SMS_DONE = 22;
    private static int EVENT_GET_CFF_DONE = 24;
    private static int EVENT_SET_CPHS_MAILBOX_DONE = 25;
    private static int EVENT_GET_INFO_CPHS_DONE = 26;
    private static int EVENT_SIM_REFRESH = 31;
    private static int EVENT_GET_CFIS_DONE = 32;
    private static int EVENT_GET_CSP_CPHS_DONE = 33;
    private static int EVENT_GET_GID1_DONE = 34;
    private static int EVENT_APP_LOCKED = 35;
    private static String[] MCCMNC_CODES_HAVING_3DIGITS_MNC;

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$toString() {
        return "SimRecords: " + super.toString() + " mVmConfig" + this.mVmConfig + " mSpnOverride=" + "mSpnOverride" + " callForwardingEnabled=" + this.mCallForwardingEnabled + " spnState=" + (Object)((Object)this.mSpnState) + " mCphsInfo=" + this.mCphsInfo + " mCspPlmnEnabled=" + this.mCspPlmnEnabled + " efMWIS=" + this.mEfMWIS + " efCPHS_MWI=" + this.mEfCPHS_MWI + " mEfCff=" + this.mEfCff + " mEfCfis=" + this.mEfCfis + " getOperatorNumeric=" + this.getOperatorNumeric();
    }

    private void $$robo$$com_android_internal_telephony_uicc_SIMRecords$__constructor__(UiccCardApplication app, Context c, CommandsInterface ci) {
        this.mCphsInfo = null;
        this.mCspPlmnEnabled = true;
        this.mEfMWIS = null;
        this.mEfCPHS_MWI = null;
        this.mEfCff = null;
        this.mEfCfis = null;
        this.mEfLi = null;
        this.mEfPl = null;
        this.mSpdiNetworks = null;
        this.mPnnHomeName = null;
        this.mAdnCache = new AdnRecordCache(this.mFh);
        this.mVmConfig = new VoiceMailConstants();
        this.mSpnOverride = new SpnOverride();
        this.mRecordsRequested = false;
        this.mRecordsToLoad = 0;
        this.mCi.setOnSmsOnSim(this, 21, null);
        this.mCi.registerForIccRefresh(this, 31, null);
        this.resetRecords();
        this.mParentApp.registerForReady(this, 1, null);
        this.mParentApp.registerForLocked(this, 35, null);
        this.log("SIMRecords X ctor this=" + this);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$dispose() {
        this.log("Disposing SIMRecords this=" + this);
        this.mCi.unregisterForIccRefresh(this);
        this.mCi.unSetOnSmsOnSim(this);
        this.mParentApp.unregisterForReady(this);
        this.mParentApp.unregisterForLocked(this);
        this.resetRecords();
        super.dispose();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$finalize() {
        this.log("finalized");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$resetRecords() {
        this.mImsi = null;
        this.mMsisdn = null;
        this.mVoiceMailNum = null;
        this.mCountVoiceMessages = 0;
        this.mMncLength = -1;
        this.log("setting0 mMncLength" + this.mMncLength);
        this.mIccId = null;
        this.mSpnDisplayCondition = -1;
        this.mEfMWIS = null;
        this.mEfCPHS_MWI = null;
        this.mSpdiNetworks = null;
        this.mPnnHomeName = null;
        this.mGid1 = null;
        this.mAdnCache.reset();
        this.log("SIMRecords: onRadioOffOrNotAvailable set 'gsm.sim.operator.numeric' to operator=null");
        this.log("update icc_operator_numeric=" + null);
        this.setSystemProperty("gsm.sim.operator.numeric", null);
        this.setSystemProperty("gsm.sim.operator.alpha", null);
        this.setSystemProperty("gsm.sim.operator.iso-country", null);
        this.mRecordsRequested = false;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getIMSI() {
        return this.mImsi;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getMsisdnNumber() {
        return this.mMsisdn;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getGid1() {
        return this.mGid1;
    }

    private final UsimServiceTable $$robo$$com_android_internal_telephony_uicc_SIMRecords$getUsimServiceTable() {
        return this.mUsimServiceTable;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setMsisdnNumber(String alphaTag, String number, Message onComplete) {
        this.mMsisdn = number;
        this.mMsisdnTag = alphaTag;
        this.log("Set MSISDN: " + this.mMsisdnTag + " " + "xxxxxxx");
        AdnRecord adn = new AdnRecord(this.mMsisdnTag, this.mMsisdn);
        new AdnRecordLoader(this.mFh).updateEF(adn, 28480, 28490, 1, null, this.obtainMessage(30, onComplete));
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getMsisdnAlphaTag() {
        return this.mMsisdnTag;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceMailNumber() {
        return this.mVoiceMailNum;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
        if (this.mIsVoiceMailFixed) {
            AsyncResult.forMessage((Message)onComplete).exception = new IccVmFixedException("Voicemail number is fixed by operator");
            onComplete.sendToTarget();
            return;
        }
        this.mNewVoiceMailNum = voiceNumber;
        this.mNewVoiceMailTag = alphaTag;
        AdnRecord adn = new AdnRecord(this.mNewVoiceMailTag, this.mNewVoiceMailNum);
        if (this.mMailboxIndex != 0 && this.mMailboxIndex != 255) {
            new AdnRecordLoader(this.mFh).updateEF(adn, 28615, 28616, this.mMailboxIndex, null, this.obtainMessage(20, onComplete));
        } else if (this.isCphsMailboxEnabled()) {
            new AdnRecordLoader(this.mFh).updateEF(adn, 28439, 28490, 1, null, this.obtainMessage(25, onComplete));
        } else {
            AsyncResult.forMessage((Message)onComplete).exception = new IccVmNotSupportedException("Update SIM voice mailbox error");
            onComplete.sendToTarget();
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceMailAlphaTag() {
        return this.mVoiceMailTag;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMessageWaiting(int line, int countWaiting) {
        if (line != 1) {
            return;
        }
        if (countWaiting < 0) {
            countWaiting = -1;
        } else if (countWaiting > 255) {
            countWaiting = 255;
        }
        this.mCountVoiceMessages = countWaiting;
        this.mRecordsEventsRegistrants.notifyResult(0);
        try {
            if (this.mEfMWIS != null) {
                this.mEfMWIS[0] = (byte)(this.mEfMWIS[0] & 0xFE | (this.mCountVoiceMessages == 0 ? 0 : 1));
                this.mEfMWIS[1] = countWaiting < 0 ? (byte)0 : (byte)countWaiting;
                this.mFh.updateEFLinearFixed(28618, 1, this.mEfMWIS, null, this.obtainMessage(14, 28618));
            }
            if (this.mEfCPHS_MWI != null) {
                this.mEfCPHS_MWI[0] = (byte)(this.mEfCPHS_MWI[0] & 0xF0 | (this.mCountVoiceMessages == 0 ? 5 : 10));
                this.mFh.updateEFTransparent(28433, this.mEfCPHS_MWI, this.obtainMessage(14, 28433));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.logw("Error saving voice mail state to SIM. Probably malformed SIM record", ex);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_SIMRecords$validEfCfis(byte[] data) {
        return data != null && data[0] >= 1 && data[0] <= 4;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceCallForwardingFlag() {
        return this.mCallForwardingEnabled;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceCallForwardingFlag(int line, boolean enable, String dialNumber) {
        if (line != 1) {
            return;
        }
        this.mCallForwardingEnabled = enable;
        this.mRecordsEventsRegistrants.notifyResult(1);
        try {
            if (this.validEfCfis(this.mEfCfis)) {
                this.mEfCfis[1] = enable ? (byte)(this.mEfCfis[1] | 1) : (byte)(this.mEfCfis[1] & 0xFE);
                this.log("setVoiceCallForwardingFlag: enable=" + enable + " mEfCfis=" + IccUtils.bytesToHexString(this.mEfCfis));
                if (enable && !TextUtils.isEmpty(dialNumber)) {
                    this.log("EF_CFIS: updating cf number, " + dialNumber);
                    byte[] bcdNumber = PhoneNumberUtils.numberToCalledPartyBCD(dialNumber);
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])bcdNumber, (int)0, (byte[])this.mEfCfis, (int)3, (int)bcdNumber.length);
                    this.mEfCfis[2] = (byte)bcdNumber.length;
                    this.mEfCfis[14] = -1;
                    this.mEfCfis[15] = -1;
                }
                this.mFh.updateEFLinearFixed(28619, 1, this.mEfCfis, null, this.obtainMessage(14, 28619));
            } else {
                this.log("setVoiceCallForwardingFlag: ignoring enable=" + enable + " invalid mEfCfis=" + IccUtils.bytesToHexString(this.mEfCfis));
            }
            if (this.mEfCff != null) {
                this.mEfCff[0] = enable ? (byte)(this.mEfCff[0] & 0xF0 | 0xA) : (byte)(this.mEfCff[0] & 0xF0 | 5);
                this.mFh.updateEFTransparent(28435, this.mEfCff, this.obtainMessage(14, 28435));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.logw("Error saving call forwarding flag to SIM. Probably malformed SIM record", ex);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onRefresh(boolean fileChanged, int[] fileList) {
        if (fileChanged) {
            this.fetchSimRecords();
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getOperatorNumeric() {
        if (this.mImsi == null) {
            this.log("getOperatorNumeric: IMSI == null");
            return null;
        }
        if (this.mMncLength == -1 || this.mMncLength == 0) {
            this.log("getSIMOperatorNumeric: bad mncLength");
            return null;
        }
        return this.mImsi.substring(0, 3 + this.mMncLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleMessage(Message msg) {
        boolean isRecordLoadResponse = false;
        if (this.mDestroyed.get()) {
            this.loge("Received message " + msg + "[" + msg.what + "] " + " while being destroyed. Ignoring.");
            return;
        }
        try {
            switch (msg.what) {
                case 1: {
                    this.onReady();
                    return;
                }
                case 35: {
                    this.onLocked();
                    return;
                }
                case 3: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.loge("Exception querying IMSI, Exception:" + ar.exception);
                        return;
                    }
                    this.mImsi = (String)ar.result;
                    if (this.mImsi != null && (this.mImsi.length() < 6 || this.mImsi.length() > 15)) {
                        this.loge("invalid IMSI " + this.mImsi);
                        this.mImsi = null;
                    }
                    this.log("IMSI: mMncLength=" + this.mMncLength);
                    this.log("IMSI: " + this.mImsi.substring(0, 6) + "xxxxxxx");
                    if ((this.mMncLength == 0 || this.mMncLength == 2) && this.mImsi != null && this.mImsi.length() >= 6) {
                        String mccmncCode = this.mImsi.substring(0, 6);
                        for (String mccmnc : MCCMNC_CODES_HAVING_3DIGITS_MNC) {
                            if (!mccmnc.equals(mccmncCode)) continue;
                            this.mMncLength = 3;
                            this.log("IMSI: setting1 mMncLength=" + this.mMncLength);
                            break;
                        }
                    }
                    if (this.mMncLength == 0) {
                        try {
                            int mcc = Integer.parseInt(this.mImsi.substring(0, 3));
                            this.mMncLength = MccTable.smallestDigitsMccForMnc(mcc);
                            this.log("setting2 mMncLength=" + this.mMncLength);
                        }
                        catch (NumberFormatException e) {
                            this.mMncLength = 0;
                            this.loge("Corrupt IMSI! setting3 mMncLength=" + this.mMncLength);
                        }
                    }
                    if (this.mMncLength != 0 && this.mMncLength != -1) {
                        this.log("update mccmnc=" + this.mImsi.substring(0, 3 + this.mMncLength));
                        MccTable.updateMccMncConfiguration(this.mContext, this.mImsi.substring(0, 3 + this.mMncLength), false);
                    }
                    this.mImsiReadyRegistrants.notifyRegistrants();
                    return;
                }
                case 5: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    boolean isValidMbdn = false;
                    if (ar.exception == null) {
                        this.log("EF_MBI: " + IccUtils.bytesToHexString(data));
                        this.mMailboxIndex = data[0] & 0xFF;
                        if (this.mMailboxIndex != 0 && this.mMailboxIndex != 255) {
                            this.log("Got valid mailbox number for MBDN");
                            isValidMbdn = true;
                        }
                    }
                    ++this.mRecordsToLoad;
                    if (isValidMbdn) {
                        new AdnRecordLoader(this.mFh).loadFromEF(28615, 28616, this.mMailboxIndex, this.obtainMessage(6));
                        return;
                    } else {
                        new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                        return;
                    }
                }
                case 6: 
                case 11: {
                    this.mVoiceMailNum = null;
                    this.mVoiceMailTag = null;
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.log("Invalid or missing EF" + (msg.what == 11 ? "[MAILBOX]" : "[MBDN]"));
                        if (msg.what != 6) return;
                        ++this.mRecordsToLoad;
                        new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                        return;
                    } else {
                        AdnRecord adn = (AdnRecord)ar.result;
                        this.log("VM: " + adn + (msg.what == 11 ? " EF[MAILBOX]" : " EF[MBDN]"));
                        if (adn.isEmpty() && msg.what == 6) {
                            ++this.mRecordsToLoad;
                            new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                            return;
                        } else {
                            this.mVoiceMailNum = adn.getNumber();
                            this.mVoiceMailTag = adn.getAlphaTag();
                            return;
                        }
                    }
                }
                case 10: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.log("Invalid or missing EF[MSISDN]");
                        return;
                    } else {
                        AdnRecord adn = (AdnRecord)ar.result;
                        this.mMsisdn = adn.getNumber();
                        this.mMsisdnTag = adn.getAlphaTag();
                        this.log("MSISDN: xxxxxxx");
                        return;
                    }
                }
                case 30: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.userObj == null) return;
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    return;
                }
                case 7: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.log("EF_MWIS: " + IccUtils.bytesToHexString(data));
                        this.mEfMWIS = data;
                        if ((data[0] & 0xFF) == 255) {
                            this.log("Uninitialized record MWIS");
                            return;
                        } else {
                            boolean voiceMailWaiting = (data[0] & 1) != 0;
                            this.mCountVoiceMessages = data[1] & 0xFF;
                            if (voiceMailWaiting && this.mCountVoiceMessages == 0) {
                                this.mCountVoiceMessages = -1;
                            }
                            this.mRecordsEventsRegistrants.notifyResult(0);
                            return;
                        }
                    }
                }
                case 8: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.mEfCPHS_MWI = data;
                        if (this.mEfMWIS != null) return;
                        int indicator = data[0] & 0xF;
                        if (indicator == 10) {
                            this.mCountVoiceMessages = -1;
                        } else if (indicator == 5) {
                            this.mCountVoiceMessages = 0;
                        }
                        this.mRecordsEventsRegistrants.notifyResult(0);
                        return;
                    }
                }
                case 4: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.mIccId = IccUtils.bcdToString(data, 0, data.length);
                        this.log("iccid: " + this.mIccId);
                        return;
                    }
                }
                case 9: {
                    try {
                        isRecordLoadResponse = true;
                        AsyncResult ar = (AsyncResult)msg.obj;
                        byte[] data = (byte[])ar.result;
                        if (ar.exception != null) return;
                        this.log("EF_AD: " + IccUtils.bytesToHexString(data));
                        if (data.length < 3) {
                            this.log("Corrupt AD data on SIM");
                            return;
                        } else if (data.length == 3) {
                            this.log("MNC length not present in EF_AD");
                            return;
                        } else {
                            this.mMncLength = data[3] & 0xF;
                            this.log("setting4 mMncLength=" + this.mMncLength);
                            if (this.mMncLength != 15) return;
                            this.mMncLength = 0;
                            this.log("setting5 mMncLength=" + this.mMncLength);
                        }
                        return;
                    }
                    finally {
                        if ((this.mMncLength == -1 || this.mMncLength == 0 || this.mMncLength == 2) && this.mImsi != null && this.mImsi.length() >= 6) {
                            String mccmncCode = this.mImsi.substring(0, 6);
                            this.log("mccmncCode=" + mccmncCode);
                            for (String mccmnc : MCCMNC_CODES_HAVING_3DIGITS_MNC) {
                                if (!mccmnc.equals(mccmncCode)) continue;
                                this.mMncLength = 3;
                                this.log("setting6 mMncLength=" + this.mMncLength);
                                break;
                            }
                        }
                        if (this.mMncLength == 0 || this.mMncLength == -1) {
                            if (this.mImsi != null) {
                                try {
                                    int mcc = Integer.parseInt(this.mImsi.substring(0, 3));
                                    this.mMncLength = MccTable.smallestDigitsMccForMnc(mcc);
                                    this.log("setting7 mMncLength=" + this.mMncLength);
                                }
                                catch (NumberFormatException e) {
                                    this.mMncLength = 0;
                                    this.loge("Corrupt IMSI! setting8 mMncLength=" + this.mMncLength);
                                }
                            } else {
                                this.mMncLength = 0;
                                this.log("MNC length not present in EF_AD setting9 mMncLength=" + this.mMncLength);
                            }
                        }
                        if (this.mImsi != null && this.mMncLength != 0) {
                            this.log("update mccmnc=" + this.mImsi.substring(0, 3 + this.mMncLength));
                            MccTable.updateMccMncConfiguration(this.mContext, this.mImsi.substring(0, 3 + this.mMncLength), false);
                        }
                    }
                }
                case 12: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.getSpnFsm(false, ar);
                    return;
                }
                case 24: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.log("EF_CFF_CPHS: " + IccUtils.bytesToHexString(data));
                        this.mEfCff = data;
                        if (!this.validEfCfis(this.mEfCfis)) {
                            this.mCallForwardingEnabled = (data[0] & 0xF) == 10;
                            this.mRecordsEventsRegistrants.notifyResult(1);
                            return;
                        } else {
                            this.log("EVENT_GET_CFF_DONE: EF_CFIS is valid, ignoring EF_CFF_CPHS");
                            return;
                        }
                    }
                }
                case 13: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.parseEfSpdi(data);
                        return;
                    }
                }
                case 14: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) return;
                    this.logw("update failed. ", ar.exception);
                    return;
                }
                case 15: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    }
                    SimTlv tlv = new SimTlv(data, 0, data.length);
                    while (tlv.isValidObject()) {
                        if (tlv.getTag() == 67) {
                            this.mPnnHomeName = IccUtils.networkNameToString(tlv.getData(), 0, tlv.getData().length);
                            return;
                        }
                        tlv.nextObject();
                    }
                    return;
                }
                case 18: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.handleSmses((ArrayList)ar.result);
                        return;
                    }
                }
                case 19: {
                    Rlog.i("ENF", "marked read: sms " + msg.arg1);
                    return;
                }
                case 21: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    int[] index = (int[])ar.result;
                    if (ar.exception != null || index.length != 1) {
                        this.loge("Error on SMS_ON_SIM with exp " + ar.exception + " length " + index.length);
                        return;
                    } else {
                        this.log("READ EF_SMS RECORD index=" + index[0]);
                        this.mFh.loadEFLinearFixed(28476, index[0], this.obtainMessage(22));
                        return;
                    }
                }
                case 22: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.handleSms((byte[])ar.result);
                        return;
                    } else {
                        this.loge("Error on GET_SMS with exp " + ar.exception);
                        return;
                    }
                }
                case 17: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.mUsimServiceTable = new UsimServiceTable(data);
                        this.log("SST: " + this.mUsimServiceTable);
                        return;
                    }
                }
                case 26: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.mCphsInfo = (byte[])ar.result;
                        this.log("iCPHS: " + IccUtils.bytesToHexString(this.mCphsInfo));
                        return;
                    }
                }
                case 20: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.log("EVENT_SET_MBDN_DONE ex:" + ar.exception);
                    if (ar.exception == null) {
                        this.mVoiceMailNum = this.mNewVoiceMailNum;
                        this.mVoiceMailTag = this.mNewVoiceMailTag;
                    }
                    if (this.isCphsMailboxEnabled()) {
                        AdnRecord adn = new AdnRecord(this.mVoiceMailTag, this.mVoiceMailNum);
                        Message onCphsCompleted = (Message)ar.userObj;
                        if (ar.exception == null && ar.userObj != null) {
                            AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = null;
                            ((Message)ar.userObj).sendToTarget();
                            this.log("Callback with MBDN successful.");
                            onCphsCompleted = null;
                        }
                        new AdnRecordLoader(this.mFh).updateEF(adn, 28439, 28490, 1, null, this.obtainMessage(25, onCphsCompleted));
                        return;
                    } else {
                        if (ar.userObj == null) return;
                        Resources resource = Resources.getSystem();
                        AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception != null && resource.getBoolean(17956984) ? new IccVmNotSupportedException("Update SIM voice mailbox error") : ar.exception;
                        ((Message)ar.userObj).sendToTarget();
                        return;
                    }
                }
                case 25: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.mVoiceMailNum = this.mNewVoiceMailNum;
                        this.mVoiceMailTag = this.mNewVoiceMailTag;
                    } else {
                        this.log("Set CPHS MailBox with exception: " + ar.exception);
                    }
                    if (ar.userObj == null) return;
                    this.log("Callback with CPHS MB successful.");
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    return;
                }
                case 31: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.log("Sim REFRESH with exception: " + ar.exception);
                    if (ar.exception != null) return;
                    this.handleSimRefresh((IccRefreshResponse)ar.result);
                    return;
                }
                case 32: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.log("EF_CFIS: " + IccUtils.bytesToHexString(data));
                        if (this.validEfCfis(data)) {
                            this.mEfCfis = data;
                            this.mCallForwardingEnabled = (data[1] & 1) != 0;
                            this.log("EF_CFIS: callForwardingEnabled=" + this.mCallForwardingEnabled);
                            this.mRecordsEventsRegistrants.notifyResult(1);
                            return;
                        } else {
                            this.log("EF_CFIS: invalid data=" + IccUtils.bytesToHexString(data));
                            return;
                        }
                    }
                }
                case 33: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.loge("Exception in fetching EF_CSP data " + ar.exception);
                        return;
                    } else {
                        byte[] data = (byte[])ar.result;
                        this.log("EF_CSP: " + IccUtils.bytesToHexString(data));
                        this.handleEfCspData(data);
                        return;
                    }
                }
                case 34: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        this.loge("Exception in get GID1 " + ar.exception);
                        this.mGid1 = null;
                        return;
                    } else {
                        this.mGid1 = IccUtils.bytesToHexString(data);
                        this.log("GID1: " + this.mGid1);
                        return;
                    }
                }
                default: {
                    super.handleMessage(msg);
                    return;
                }
            }
        }
        catch (RuntimeException exc) {
            this.logw("Exception parsing SIM record", exc);
            return;
        }
        finally {
            if (isRecordLoadResponse) {
                this.onRecordLoaded();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleFileUpdate(int efid) {
        switch (efid) {
            case 28615: {
                ++this.mRecordsToLoad;
                new AdnRecordLoader(this.mFh).loadFromEF(28615, 28616, this.mMailboxIndex, this.obtainMessage(6));
                break;
            }
            case 28439: {
                ++this.mRecordsToLoad;
                new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                break;
            }
            case 28437: {
                ++this.mRecordsToLoad;
                this.log("[CSP] SIM Refresh for EF_CSP_CPHS");
                this.mFh.loadEFTransparent(28437, this.obtainMessage(33));
                break;
            }
            case 28475: {
                this.log("SIM Refresh called for EF_FDN");
                this.mParentApp.queryFdn();
                break;
            }
            default: {
                this.mAdnCache.reset();
                this.fetchSimRecords();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleSimRefresh(IccRefreshResponse refreshResponse) {
        if (refreshResponse == null) {
            this.log("handleSimRefresh received without input");
            return;
        }
        if (refreshResponse.aid != null && !refreshResponse.aid.equals(this.mParentApp.getAid())) {
            return;
        }
        switch (refreshResponse.refreshResult) {
            case 0: {
                this.log("handleSimRefresh with SIM_FILE_UPDATED");
                this.handleFileUpdate(refreshResponse.efId);
                break;
            }
            case 1: {
                this.log("handleSimRefresh with SIM_REFRESH_INIT");
                this.onIccRefreshInit();
                break;
            }
            case 2: {
                this.log("handleSimRefresh with SIM_REFRESH_RESET");
                if (this.requirePowerOffOnSimRefreshReset()) {
                    this.mCi.setRadioPower(false, null);
                }
                this.mAdnCache.reset();
                break;
            }
            default: {
                this.log("handleSimRefresh with unknown operation");
            }
        }
    }

    private final int $$robo$$com_android_internal_telephony_uicc_SIMRecords$dispatchGsmMessage(SmsMessage message) {
        this.mNewSmsRegistrants.notifyResult(message);
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleSms(byte[] ba) {
        if (ba[0] != 0) {
            Rlog.d("ENF", "status : " + ba[0]);
        }
        if (ba[0] == 3) {
            int n = ba.length;
            byte[] pdu = new byte[n - 1];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])ba, (int)1, (byte[])pdu, (int)0, (int)(n - 1));
            SmsMessage message = SmsMessage.createFromPdu(pdu, "3gpp");
            this.dispatchGsmMessage(message);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleSmses(ArrayList<byte[]> messages) {
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            byte[] ba = messages.get(i);
            if (ba[0] != 0) {
                Rlog.i("ENF", "status " + i + ": " + ba[0]);
            }
            if (ba[0] != 3) continue;
            int n = ba.length;
            byte[] pdu = new byte[n - 1];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])ba, (int)1, (byte[])pdu, (int)0, (int)(n - 1));
            SmsMessage message = SmsMessage.createFromPdu(pdu, "3gpp");
            this.dispatchGsmMessage(message);
            ba[0] = 1;
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$findBestLanguage(byte[] languages) {
        Object bestMatch = null;
        String[] locales = this.mContext.getAssets().getLocales();
        if (languages == null || locales == null) {
            return null;
        }
        int i = 0;
        while (i + 1 < languages.length) {
            try {
                String lang = new String(languages, i, 2, "ISO-8859-1");
                this.log("languages from sim = " + lang);
                for (int j = 0; j < locales.length; ++j) {
                    if (locales[j] == null || locales[j].length() < 2 || !locales[j].substring(0, 2).equalsIgnoreCase(lang)) continue;
                    return lang;
                }
                if (bestMatch != null) {
                    break;
                }
            }
            catch (UnsupportedEncodingException e) {
                this.log("Failed to parse USIM language records" + e);
            }
            i += 2;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setLocaleFromUsim() {
        String prefLang = null;
        prefLang = this.findBestLanguage(this.mEfLi);
        if (prefLang == null) {
            prefLang = this.findBestLanguage(this.mEfPl);
        }
        if (prefLang != null) {
            String imsi = this.getIMSI();
            String country = null;
            if (imsi != null) {
                country = MccTable.countryCodeForMcc(Integer.parseInt(imsi.substring(0, 3)));
            }
            this.log("Setting locale to " + prefLang + "_" + country);
            MccTable.setSystemLocale(this.mContext, prefLang, country);
        } else {
            this.log("No suitable USIM selected locale");
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onRecordLoaded() {
        --this.mRecordsToLoad;
        this.log("onRecordLoaded " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
        if (this.mRecordsToLoad == 0 && this.mRecordsRequested) {
            this.onAllRecordsLoaded();
        } else if (this.mRecordsToLoad < 0) {
            this.loge("recordsToLoad <0, programmer error suspected");
            this.mRecordsToLoad = 0;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onAllRecordsLoaded() {
        this.log("record load complete");
        this.setLocaleFromUsim();
        if (this.mParentApp.getState() == IccCardApplicationStatus.AppState.APPSTATE_PIN || this.mParentApp.getState() == IccCardApplicationStatus.AppState.APPSTATE_PUK) {
            this.mRecordsRequested = false;
            return;
        }
        String operator = this.getOperatorNumeric();
        if (!TextUtils.isEmpty(operator)) {
            this.log("onAllRecordsLoaded set 'gsm.sim.operator.numeric' to operator='" + operator + "'");
            this.log("update icc_operator_numeric=" + operator);
            this.setSystemProperty("gsm.sim.operator.numeric", operator);
            SubscriptionController subController = SubscriptionController.getInstance();
            subController.setMccMnc(operator, subController.getDefaultSmsSubId());
        } else {
            this.log("onAllRecordsLoaded empty 'gsm.sim.operator.numeric' skipping");
        }
        if (!TextUtils.isEmpty(this.mImsi)) {
            this.log("onAllRecordsLoaded set mcc imsi=" + this.mImsi);
            this.setSystemProperty("gsm.sim.operator.iso-country", MccTable.countryCodeForMcc(Integer.parseInt(this.mImsi.substring(0, 3))));
        } else {
            this.log("onAllRecordsLoaded empty imsi skipping setting mcc");
        }
        this.setVoiceMailByCountry(operator);
        this.setSpnFromConfig(operator);
        this.mRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setSpnFromConfig(String carrier) {
        if (this.mSpnOverride.containsCarrier(carrier)) {
            this.setServiceProviderName(this.mSpnOverride.getSpn(carrier));
            SystemProperties.set("gsm.sim.operator.alpha", this.getServiceProviderName());
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMailByCountry(String spn) {
        if (this.mVmConfig.containsCarrier(spn)) {
            this.mIsVoiceMailFixed = true;
            this.mVoiceMailNum = this.mVmConfig.getVoiceMailNumber(spn);
            this.mVoiceMailTag = this.mVmConfig.getVoiceMailTag(spn);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onReady() {
        this.fetchSimRecords();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onLocked() {
        this.log("only fetch EF_LI and EF_PL in lock state");
        this.loadEfLiAndEfPl();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$loadEfLiAndEfPl() {
        if (this.mParentApp.getType() == IccCardApplicationStatus.AppType.APPTYPE_USIM) {
            this.mRecordsRequested = true;
            this.mFh.loadEFTransparent(28421, this.obtainMessage(100, new EfUsimLiLoaded(this)));
            ++this.mRecordsToLoad;
            this.mFh.loadEFTransparent(12037, this.obtainMessage(100, new EfPlLoaded(this)));
            ++this.mRecordsToLoad;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$fetchSimRecords() {
        this.mRecordsRequested = true;
        this.log("fetchSimRecords " + this.mRecordsToLoad);
        this.mCi.getIMSIForApp(this.mParentApp.getAid(), this.obtainMessage(3));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(12258, this.obtainMessage(4));
        ++this.mRecordsToLoad;
        new AdnRecordLoader(this.mFh).loadFromEF(28480, 28490, 1, this.obtainMessage(10));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28617, 1, this.obtainMessage(5));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28589, this.obtainMessage(9));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28618, 1, this.obtainMessage(7));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28433, this.obtainMessage(8));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28619, 1, this.obtainMessage(32));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28435, this.obtainMessage(24));
        ++this.mRecordsToLoad;
        this.getSpnFsm(true, null);
        this.mFh.loadEFTransparent(28621, this.obtainMessage(13));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28613, 1, this.obtainMessage(15));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28472, this.obtainMessage(17));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28438, this.obtainMessage(26));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28437, this.obtainMessage(33));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28478, this.obtainMessage(34));
        ++this.mRecordsToLoad;
        this.loadEfLiAndEfPl();
        this.log("fetchSimRecords " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_SIMRecords$getDisplayRule(String plmn) {
        int rule;
        if (this.mParentApp != null && this.mParentApp.getUiccCard() != null && this.mParentApp.getUiccCard().getOperatorBrandOverride() != null) {
            rule = 2;
        } else if (TextUtils.isEmpty(this.getServiceProviderName()) || this.mSpnDisplayCondition == -1) {
            rule = 2;
        } else if (this.isOnMatchingPlmn(plmn)) {
            rule = 1;
            if ((this.mSpnDisplayCondition & 1) == 1) {
                rule |= 2;
            }
        } else {
            rule = 2;
            if ((this.mSpnDisplayCondition & 2) == 0) {
                rule |= 1;
            }
        }
        return rule;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_SIMRecords$isOnMatchingPlmn(String plmn) {
        if (plmn == null) {
            return false;
        }
        if (plmn.equals(this.getOperatorNumeric())) {
            return true;
        }
        if (this.mSpdiNetworks != null) {
            for (String spdiNet : this.mSpdiNetworks) {
                if (!plmn.equals(spdiNet)) continue;
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$getSpnFsm(boolean start, AsyncResult ar) {
        if (start) {
            if (this.mSpnState == GetSpnFsmState.READ_SPN_3GPP || this.mSpnState == GetSpnFsmState.READ_SPN_CPHS || this.mSpnState == GetSpnFsmState.READ_SPN_SHORT_CPHS || this.mSpnState == GetSpnFsmState.INIT) {
                this.mSpnState = GetSpnFsmState.INIT;
                return;
            }
            this.mSpnState = GetSpnFsmState.INIT;
        }
        switch (1.$SwitchMap$com$android$internal$telephony$uicc$SIMRecords$GetSpnFsmState[this.mSpnState.ordinal()]) {
            case 1: {
                this.setServiceProviderName(null);
                this.mFh.loadEFTransparent(28486, this.obtainMessage(12));
                ++this.mRecordsToLoad;
                this.mSpnState = GetSpnFsmState.READ_SPN_3GPP;
                break;
            }
            case 2: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.mSpnDisplayCondition = 0xFF & data[0];
                    this.setServiceProviderName(IccUtils.adnStringFieldToString(data, 1, data.length - 1));
                    this.log("Load EF_SPN: " + this.getServiceProviderName() + " spnDisplayCondition: " + this.mSpnDisplayCondition);
                    this.setSystemProperty("gsm.sim.operator.alpha", this.getServiceProviderName());
                    this.mSpnState = GetSpnFsmState.IDLE;
                    break;
                }
                this.mFh.loadEFTransparent(28436, this.obtainMessage(12));
                ++this.mRecordsToLoad;
                this.mSpnState = GetSpnFsmState.READ_SPN_CPHS;
                this.mSpnDisplayCondition = -1;
                break;
            }
            case 3: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.setServiceProviderName(IccUtils.adnStringFieldToString(data, 0, data.length));
                    this.log("Load EF_SPN_CPHS: " + this.getServiceProviderName());
                    this.setSystemProperty("gsm.sim.operator.alpha", this.getServiceProviderName());
                    this.mSpnState = GetSpnFsmState.IDLE;
                    break;
                }
                this.mFh.loadEFTransparent(28440, this.obtainMessage(12));
                ++this.mRecordsToLoad;
                this.mSpnState = GetSpnFsmState.READ_SPN_SHORT_CPHS;
                break;
            }
            case 4: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.setServiceProviderName(IccUtils.adnStringFieldToString(data, 0, data.length));
                    this.log("Load EF_SPN_SHORT_CPHS: " + this.getServiceProviderName());
                    this.setSystemProperty("gsm.sim.operator.alpha", this.getServiceProviderName());
                } else {
                    this.log("No SPN loaded in either CHPS or 3GPP");
                }
                this.mSpnState = GetSpnFsmState.IDLE;
                break;
            }
            default: {
                this.mSpnState = GetSpnFsmState.IDLE;
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$parseEfSpdi(byte[] data) {
        SimTlv tlv = new SimTlv(data, 0, data.length);
        byte[] plmnEntries = null;
        while (tlv.isValidObject()) {
            if (tlv.getTag() == 163) {
                tlv = new SimTlv(tlv.getData(), 0, tlv.getData().length);
            }
            if (tlv.getTag() == 128) {
                plmnEntries = tlv.getData();
                break;
            }
            tlv.nextObject();
        }
        if (plmnEntries == null) {
            return;
        }
        this.mSpdiNetworks = new ArrayList(plmnEntries.length / 3);
        int i = 0;
        while (i + 2 < plmnEntries.length) {
            String plmnCode = IccUtils.bcdToString(plmnEntries, i, 3);
            if (plmnCode.length() >= 5) {
                this.log("EF_SPDI network: " + plmnCode);
                this.mSpdiNetworks.add(plmnCode);
            }
            i += 3;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_SIMRecords$isCphsMailboxEnabled() {
        if (this.mCphsInfo == null) {
            return false;
        }
        return (this.mCphsInfo[1] & 0x30) == 48;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$log(String s) {
        Rlog.d("SIMRecords", "[SIMRecords] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$loge(String s) {
        Rlog.e("SIMRecords", "[SIMRecords] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$logw(String s, Throwable tr) {
        Rlog.w("SIMRecords", "[SIMRecords] " + s, tr);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$logv(String s) {
        Rlog.v("SIMRecords", "[SIMRecords] " + s);
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_SIMRecords$isCspPlmnEnabled() {
        return this.mCspPlmnEnabled;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleEfCspData(byte[] data) {
        int usedCspGroups = data.length / 2;
        byte valueAddedServicesGroup = -64;
        this.mCspPlmnEnabled = true;
        for (int i = 0; i < usedCspGroups; ++i) {
            if (data[2 * i] != valueAddedServicesGroup) continue;
            this.log("[CSP] found ValueAddedServicesGroup, value " + data[2 * i + 1]);
            if ((data[2 * i + 1] & 0x80) == 128) {
                this.mCspPlmnEnabled = true;
            } else {
                this.mCspPlmnEnabled = false;
                this.log("[CSP] Set Automatic Network Selection");
                this.mNetworkSelectionModeAutomaticRegistrants.notifyRegistrants();
            }
            return;
        }
        this.log("[CSP] Value Added Service Group (0xC0), not found!");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("SIMRecords: " + this);
        pw.println(" extends:");
        super.dump(fd, pw, args);
        pw.println(" mVmConfig=" + this.mVmConfig);
        pw.println(" mSpnOverride=" + this.mSpnOverride);
        pw.println(" mCallForwardingEnabled=" + this.mCallForwardingEnabled);
        pw.println(" mSpnState=" + (Object)((Object)this.mSpnState));
        pw.println(" mCphsInfo=" + this.mCphsInfo);
        pw.println(" mCspPlmnEnabled=" + this.mCspPlmnEnabled);
        pw.println(" mEfMWIS[]=" + Arrays.toString(this.mEfMWIS));
        pw.println(" mEfCPHS_MWI[]=" + Arrays.toString(this.mEfCPHS_MWI));
        pw.println(" mEfCff[]=" + Arrays.toString(this.mEfCff));
        pw.println(" mEfCfis[]=" + Arrays.toString(this.mEfCfis));
        pw.println(" mSpnDisplayCondition=" + this.mSpnDisplayCondition);
        pw.println(" mSpdiNetworks[]=" + this.mSpdiNetworks);
        pw.println(" mPnnHomeName=" + this.mPnnHomeName);
        pw.println(" mUsimServiceTable=" + this.mUsimServiceTable);
        pw.println(" mGid1=" + this.mGid1);
        pw.flush();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setSystemProperty(String key, String val) {
        if (!TelephonyManager.getDefault().isMultiSimEnabled()) {
            SystemProperties.set(key, val);
        }
    }

    static void __staticInitializer__() {
        MCCMNC_CODES_HAVING_3DIGITS_MNC = new String[]{"302370", "302720", "310260", "405025", "405026", "405027", "405028", "405029", "405030", "405031", "405032", "405033", "405034", "405035", "405036", "405037", "405038", "405039", "405040", "405041", "405042", "405043", "405044", "405045", "405046", "405047", "405750", "405751", "405752", "405753", "405754", "405755", "405756", "405799", "405800", "405801", "405802", "405803", "405804", "405805", "405806", "405807", "405808", "405809", "405810", "405811", "405812", "405813", "405814", "405815", "405816", "405817", "405818", "405819", "405820", "405821", "405822", "405823", "405824", "405825", "405826", "405827", "405828", "405829", "405830", "405831", "405832", "405833", "405834", "405835", "405836", "405837", "405838", "405839", "405840", "405841", "405842", "405843", "405844", "405845", "405846", "405847", "405848", "405849", "405850", "405851", "405852", "405853", "405875", "405876", "405877", "405878", "405879", "405880", "405881", "405882", "405883", "405884", "405885", "405886", "405908", "405909", "405910", "405911", "405912", "405913", "405914", "405915", "405916", "405917", "405918", "405919", "405920", "405921", "405922", "405923", "405924", "405925", "405926", "405927", "405928", "405929", "405930", "405931", "405932", "502142", "502143", "502145", "502146", "502147", "502148"};
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_uicc_SIMRecords$toString(), 0, this);
    }

    private void __constructor__(UiccCardApplication uiccCardApplication, Context context, CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_uicc_SIMRecords$__constructor__(uiccCardApplication, context, commandsInterface);
    }

    public SIMRecords(UiccCardApplication uiccCardApplication, Context context, CommandsInterface commandsInterface) {
        super(uiccCardApplication, context, commandsInterface);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_SIMRecords$__constructor__(com.android.internal.telephony.uicc.UiccCardApplication android.content.Context com.android.internal.telephony.CommandsInterface ), 0, this, uiccCardApplication, context, commandsInterface);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_uicc_SIMRecords$dispose(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_uicc_SIMRecords$finalize(), 0, this);
    }

    protected void resetRecords() {
        InvokeDynamicSupport.bootstrap("resetRecords", $$robo$$com_android_internal_telephony_uicc_SIMRecords$resetRecords(), 0, this);
    }

    @Override
    public String getIMSI() {
        return InvokeDynamicSupport.bootstrap("getIMSI", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getIMSI(), 0, this);
    }

    @Override
    public String getMsisdnNumber() {
        return InvokeDynamicSupport.bootstrap("getMsisdnNumber", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getMsisdnNumber(), 0, this);
    }

    @Override
    public String getGid1() {
        return InvokeDynamicSupport.bootstrap("getGid1", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getGid1(), 0, this);
    }

    @Override
    public UsimServiceTable getUsimServiceTable() {
        return InvokeDynamicSupport.bootstrap("getUsimServiceTable", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getUsimServiceTable(), 0, this);
    }

    @Override
    public void setMsisdnNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setMsisdnNumber", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setMsisdnNumber(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public String getMsisdnAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getMsisdnAlphaTag", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getMsisdnAlphaTag(), 0, this);
    }

    @Override
    public String getVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceMailNumber(), 0, this);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMailNumber(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceMailAlphaTag(), 0, this);
    }

    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVoiceMessageWaiting", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMessageWaiting(int int ), 0, this, n, n2);
    }

    private boolean validEfCfis(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("validEfCfis", $$robo$$com_android_internal_telephony_uicc_SIMRecords$validEfCfis(byte[] ), 0, this, byArray);
    }

    @Override
    public boolean getVoiceCallForwardingFlag() {
        return (boolean)InvokeDynamicSupport.bootstrap("getVoiceCallForwardingFlag", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceCallForwardingFlag(), 0, this);
    }

    @Override
    public void setVoiceCallForwardingFlag(int n, boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("setVoiceCallForwardingFlag", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceCallForwardingFlag(int boolean java.lang.String ), 0, this, n, bl, string2);
    }

    @Override
    public void onRefresh(boolean bl, int[] nArray) {
        InvokeDynamicSupport.bootstrap("onRefresh", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onRefresh(boolean int[] ), 0, this, bl, nArray);
    }

    @Override
    public String getOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getOperatorNumeric", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getOperatorNumeric(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleMessage(android.os.Message ), 0, this, message);
    }

    private void handleFileUpdate(int n) {
        InvokeDynamicSupport.bootstrap("handleFileUpdate", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleFileUpdate(int ), 0, this, n);
    }

    private void handleSimRefresh(IccRefreshResponse iccRefreshResponse) {
        InvokeDynamicSupport.bootstrap("handleSimRefresh", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleSimRefresh(com.android.internal.telephony.uicc.IccRefreshResponse ), 0, this, iccRefreshResponse);
    }

    private int dispatchGsmMessage(SmsMessage smsMessage) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchGsmMessage", $$robo$$com_android_internal_telephony_uicc_SIMRecords$dispatchGsmMessage(android.telephony.SmsMessage ), 0, this, smsMessage);
    }

    private void handleSms(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("handleSms", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleSms(byte[] ), 0, this, byArray);
    }

    private void handleSmses(ArrayList<byte[]> arrayList) {
        InvokeDynamicSupport.bootstrap("handleSmses", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleSmses(java.util.ArrayList<byte[]> ), 0, this, arrayList);
    }

    private String findBestLanguage(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("findBestLanguage", $$robo$$com_android_internal_telephony_uicc_SIMRecords$findBestLanguage(byte[] ), 0, this, byArray);
    }

    private void setLocaleFromUsim() {
        InvokeDynamicSupport.bootstrap("setLocaleFromUsim", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setLocaleFromUsim(), 0, this);
    }

    @Override
    protected void onRecordLoaded() {
        InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onRecordLoaded(), 0, this);
    }

    @Override
    protected void onAllRecordsLoaded() {
        InvokeDynamicSupport.bootstrap("onAllRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onAllRecordsLoaded(), 0, this);
    }

    private void setSpnFromConfig(String string2) {
        InvokeDynamicSupport.bootstrap("setSpnFromConfig", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setSpnFromConfig(java.lang.String ), 0, this, string2);
    }

    private void setVoiceMailByCountry(String string2) {
        InvokeDynamicSupport.bootstrap("setVoiceMailByCountry", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMailByCountry(java.lang.String ), 0, this, string2);
    }

    @Override
    public void onReady() {
        InvokeDynamicSupport.bootstrap("onReady", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onReady(), 0, this);
    }

    private void onLocked() {
        InvokeDynamicSupport.bootstrap("onLocked", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onLocked(), 0, this);
    }

    private void loadEfLiAndEfPl() {
        InvokeDynamicSupport.bootstrap("loadEfLiAndEfPl", $$robo$$com_android_internal_telephony_uicc_SIMRecords$loadEfLiAndEfPl(), 0, this);
    }

    protected void fetchSimRecords() {
        InvokeDynamicSupport.bootstrap("fetchSimRecords", $$robo$$com_android_internal_telephony_uicc_SIMRecords$fetchSimRecords(), 0, this);
    }

    @Override
    public int getDisplayRule(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getDisplayRule", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getDisplayRule(java.lang.String ), 0, this, string2);
    }

    private boolean isOnMatchingPlmn(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOnMatchingPlmn", $$robo$$com_android_internal_telephony_uicc_SIMRecords$isOnMatchingPlmn(java.lang.String ), 0, this, string2);
    }

    private void getSpnFsm(boolean bl, AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("getSpnFsm", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getSpnFsm(boolean android.os.AsyncResult ), 0, this, bl, asyncResult);
    }

    private void parseEfSpdi(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("parseEfSpdi", $$robo$$com_android_internal_telephony_uicc_SIMRecords$parseEfSpdi(byte[] ), 0, this, byArray);
    }

    private boolean isCphsMailboxEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCphsMailboxEnabled", $$robo$$com_android_internal_telephony_uicc_SIMRecords$isCphsMailboxEnabled(), 0, this);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_SIMRecords$log(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_uicc_SIMRecords$loge(java.lang.String ), 0, this, string2);
    }

    protected void logw(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("logw", $$robo$$com_android_internal_telephony_uicc_SIMRecords$logw(java.lang.String java.lang.Throwable ), 0, this, string2, throwable);
    }

    protected void logv(String string2) {
        InvokeDynamicSupport.bootstrap("logv", $$robo$$com_android_internal_telephony_uicc_SIMRecords$logv(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isCspPlmnEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCspPlmnEnabled", $$robo$$com_android_internal_telephony_uicc_SIMRecords$isCspPlmnEnabled(), 0, this);
    }

    private void handleEfCspData(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("handleEfCspData", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleEfCspData(byte[] ), 0, this, byArray);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_SIMRecords$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    private void setSystemProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSystemProperty", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    static {
        RobolectricInternals.classInitializing(SIMRecords.class);
    }

    public /* synthetic */ SIMRecords() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SIMRecords)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class GetSpnFsmState
    extends Enum<GetSpnFsmState> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ GetSpnFsmState IDLE;
        public static /* enum */ GetSpnFsmState INIT;
        public static /* enum */ GetSpnFsmState READ_SPN_3GPP;
        public static /* enum */ GetSpnFsmState READ_SPN_CPHS;
        public static /* enum */ GetSpnFsmState READ_SPN_SHORT_CPHS;
        private static /* synthetic */ GetSpnFsmState[] $VALUES;

        private static final GetSpnFsmState[] $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$values() {
            return (GetSpnFsmState[])$VALUES.clone();
        }

        private static final GetSpnFsmState $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$valueOf(String name) {
            return Enum.valueOf(GetSpnFsmState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            IDLE = new GetSpnFsmState();
            INIT = new GetSpnFsmState();
            READ_SPN_3GPP = new GetSpnFsmState();
            READ_SPN_CPHS = new GetSpnFsmState();
            READ_SPN_SHORT_CPHS = new GetSpnFsmState();
            $VALUES = new GetSpnFsmState[]{IDLE, INIT, READ_SPN_3GPP, READ_SPN_CPHS, READ_SPN_SHORT_CPHS};
        }

        public static GetSpnFsmState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$values(), 0);
        }

        public static GetSpnFsmState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$__constructor__(string2, n);
        }

        private GetSpnFsmState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(GetSpnFsmState.class);
        }

        public /* synthetic */ GetSpnFsmState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GetSpnFsmState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfUsimLiLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SIMRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(SIMRecords sIMRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$getEfName() {
            return "EF_LI";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$onRecordLoaded(AsyncResult ar) {
            this.this$0.mEfLi = (byte[])ar.result;
            this.this$0.log("EF_LI=" + IccUtils.bytesToHexString(this.this$0.mEfLi));
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(SIMRecords x0, 1 x1) {
        }

        private void __constructor__(SIMRecords sIMRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(sIMRecords);
        }

        private EfUsimLiLoaded(SIMRecords sIMRecords) {
            this.this$0 = sIMRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(com.android.internal.telephony.uicc.SIMRecords ), 0, this, sIMRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(SIMRecords sIMRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(sIMRecords, var2_2);
        }

        public /* synthetic */ EfUsimLiLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfUsimLiLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfPlLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SIMRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(SIMRecords sIMRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$getEfName() {
            return "EF_PL";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$onRecordLoaded(AsyncResult ar) {
            this.this$0.mEfPl = (byte[])ar.result;
            this.this$0.log("EF_PL=" + IccUtils.bytesToHexString(this.this$0.mEfPl));
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(SIMRecords x0, 1 x1) {
        }

        private void __constructor__(SIMRecords sIMRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(sIMRecords);
        }

        private EfPlLoaded(SIMRecords sIMRecords) {
            this.this$0 = sIMRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(com.android.internal.telephony.uicc.SIMRecords ), 0, this, sIMRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(SIMRecords sIMRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(sIMRecords, var2_2);
        }

        public /* synthetic */ EfPlLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfPlLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

