/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.preference.PreferenceManager;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.cat.CatService;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccCarrierPrivilegeRules;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UiccCard
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static String LOG_TAG = "UiccCard";
    protected static boolean DBG = true;
    private static String OPERATOR_BRAND_OVERRIDE_PREFIX = "operator_branding_";
    private Object mLock;
    private IccCardStatus.CardState mCardState;
    private IccCardStatus.PinState mUniversalPinState;
    private int mGsmUmtsSubscriptionAppIndex;
    private int mCdmaSubscriptionAppIndex;
    private int mImsSubscriptionAppIndex;
    private UiccCardApplication[] mUiccApplications;
    private Context mContext;
    private CommandsInterface mCi;
    private CatService mCatService;
    private boolean mDestroyed;
    private CommandsInterface.RadioState mLastRadioState;
    private UiccCarrierPrivilegeRules mCarrierPrivilegeRules;
    private RegistrantList mAbsentRegistrants;
    private RegistrantList mCarrierPrivilegeRegistrants;
    private static int EVENT_CARD_REMOVED = 13;
    private static int EVENT_CARD_ADDED = 14;
    private static int EVENT_OPEN_LOGICAL_CHANNEL_DONE = 15;
    private static int EVENT_CLOSE_LOGICAL_CHANNEL_DONE = 16;
    private static int EVENT_TRANSMIT_APDU_LOGICAL_CHANNEL_DONE = 17;
    private static int EVENT_TRANSMIT_APDU_BASIC_CHANNEL_DONE = 18;
    private static int EVENT_SIM_IO_DONE = 19;
    private static int EVENT_CARRIER_PRIVILIGES_LOADED = 20;
    int mSlotId;
    protected Handler mHandler;

    private void $$robo$$com_android_internal_telephony_uicc_UiccCard$__constructor__(Context c, CommandsInterface ci, IccCardStatus ics) {
        this.mLock = new Object();
        this.mUiccApplications = new UiccCardApplication[8];
        this.mDestroyed = false;
        this.mLastRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
        this.mAbsentRegistrants = new RegistrantList();
        this.mCarrierPrivilegeRegistrants = new RegistrantList();
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ UiccCard this$0;

            private void $$robo$$com_android_internal_telephony_uicc_UiccCard_2$__constructor__(UiccCard uiccCard) {
            }

            private final void $$robo$$com_android_internal_telephony_uicc_UiccCard_2$handleMessage(Message msg) {
                if (this.this$0.mDestroyed) {
                    this.this$0.loge("Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
                    return;
                }
                switch (msg.what) {
                    case 13: {
                        this.this$0.onIccSwap(false);
                        break;
                    }
                    case 14: {
                        this.this$0.onIccSwap(true);
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        if (ar.exception != null) {
                            this.this$0.log("Error in SIM access with exception" + ar.exception);
                        }
                        AsyncResult.forMessage((Message)ar.userObj, ar.result, ar.exception);
                        ((Message)ar.userObj).sendToTarget();
                        break;
                    }
                    case 20: {
                        this.this$0.onCarrierPriviligesLoadedMessage();
                        break;
                    }
                    default: {
                        this.this$0.loge("Unknown Event " + msg.what);
                    }
                }
            }

            private void __constructor__(UiccCard uiccCard) {
                this.$$robo$$com_android_internal_telephony_uicc_UiccCard_2$__constructor__(uiccCard);
            }
            {
                this.this$0 = uiccCard;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCard_2$__constructor__(com.android.internal.telephony.uicc.UiccCard ), 0, this, uiccCard);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccCard_2$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.log("Creating");
        this.mCardState = ics.mCardState;
        this.update(c, ci, ics);
    }

    private void $$robo$$com_android_internal_telephony_uicc_UiccCard$__constructor__(Context c, CommandsInterface ci, IccCardStatus ics, int slotId) {
        this.mLock = new Object();
        this.mUiccApplications = new UiccCardApplication[8];
        this.mDestroyed = false;
        this.mLastRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
        this.mAbsentRegistrants = new RegistrantList();
        this.mCarrierPrivilegeRegistrants = new RegistrantList();
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        this.mCardState = ics.mCardState;
        this.mSlotId = slotId;
        this.update(c, ci, ics);
    }

    private void $$robo$$com_android_internal_telephony_uicc_UiccCard$__constructor__() {
        this.mLock = new Object();
        this.mUiccApplications = new UiccCardApplication[8];
        this.mDestroyed = false;
        this.mLastRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
        this.mAbsentRegistrants = new RegistrantList();
        this.mCarrierPrivilegeRegistrants = new RegistrantList();
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$dispose() {
        Object object = this.mLock;
        synchronized (object) {
            this.log("Disposing card");
            if (this.mCatService != null) {
                this.mCatService.dispose();
            }
            for (UiccCardApplication app : this.mUiccApplications) {
                if (app == null) continue;
                app.dispose();
            }
            this.mCatService = null;
            this.mUiccApplications = null;
            this.mCarrierPrivilegeRules = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$update(Context c, CommandsInterface ci, IccCardStatus ics) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                this.loge("Updated after destroyed! Fix me!");
                return;
            }
            IccCardStatus.CardState oldState = this.mCardState;
            this.mCardState = ics.mCardState;
            this.mUniversalPinState = ics.mUniversalPinState;
            this.mGsmUmtsSubscriptionAppIndex = ics.mGsmUmtsSubscriptionAppIndex;
            this.mCdmaSubscriptionAppIndex = ics.mCdmaSubscriptionAppIndex;
            this.mImsSubscriptionAppIndex = ics.mImsSubscriptionAppIndex;
            this.mContext = c;
            this.mCi = ci;
            this.log(ics.mApplications.length + " applications");
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null) {
                    if (i >= ics.mApplications.length) continue;
                    this.mUiccApplications[i] = new UiccCardApplication(this, ics.mApplications[i], this.mContext, this.mCi);
                    continue;
                }
                if (i >= ics.mApplications.length) {
                    this.mUiccApplications[i].dispose();
                    this.mUiccApplications[i] = null;
                    continue;
                }
                this.mUiccApplications[i].update(ics.mApplications[i], this.mContext, this.mCi);
            }
            this.createAndUpdateCatService();
            this.log("Before privilege rules: " + this.mCarrierPrivilegeRules + " : " + (Object)((Object)this.mCardState));
            if (this.mCarrierPrivilegeRules == null && this.mCardState == IccCardStatus.CardState.CARDSTATE_PRESENT) {
                this.mCarrierPrivilegeRules = new UiccCarrierPrivilegeRules(this, this.mHandler.obtainMessage(20));
            } else if (this.mCarrierPrivilegeRules != null && this.mCardState != IccCardStatus.CardState.CARDSTATE_PRESENT) {
                this.mCarrierPrivilegeRules = null;
            }
            this.sanitizeApplicationIndexes();
            CommandsInterface.RadioState radioState = this.mCi.getRadioState();
            this.log("update: radioState=" + (Object)((Object)radioState) + " mLastRadioState=" + (Object)((Object)this.mLastRadioState));
            if (radioState == CommandsInterface.RadioState.RADIO_ON && this.mLastRadioState == CommandsInterface.RadioState.RADIO_ON) {
                if (oldState != IccCardStatus.CardState.CARDSTATE_ABSENT && this.mCardState == IccCardStatus.CardState.CARDSTATE_ABSENT) {
                    this.log("update: notify card removed");
                    this.mAbsentRegistrants.notifyRegistrants();
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(13, null));
                } else if (oldState == IccCardStatus.CardState.CARDSTATE_ABSENT && this.mCardState != IccCardStatus.CardState.CARDSTATE_ABSENT) {
                    this.log("update: notify card added");
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(14, null));
                }
            }
            this.mLastRadioState = radioState;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$createAndUpdateCatService() {
        if (this.mUiccApplications.length > 0 && this.mUiccApplications[0] != null) {
            if (this.mCatService == null) {
                this.mCatService = CatService.getInstance(this.mCi, this.mContext, this, this.mSlotId);
            } else {
                this.mCatService.update(this.mCi, this.mContext, this);
            }
        } else {
            if (this.mCatService != null) {
                this.mCatService.dispose();
            }
            this.mCatService = null;
        }
    }

    private final CatService $$robo$$com_android_internal_telephony_uicc_UiccCard$getCatService() {
        return this.mCatService;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$finalize() {
        this.log("UiccCard finalized");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$sanitizeApplicationIndexes() {
        this.mGsmUmtsSubscriptionAppIndex = this.checkIndex(this.mGsmUmtsSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_SIM, IccCardApplicationStatus.AppType.APPTYPE_USIM);
        this.mCdmaSubscriptionAppIndex = this.checkIndex(this.mCdmaSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_RUIM, IccCardApplicationStatus.AppType.APPTYPE_CSIM);
        this.mImsSubscriptionAppIndex = this.checkIndex(this.mImsSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_ISIM, null);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCard$checkIndex(int index, IccCardApplicationStatus.AppType expectedAppType, IccCardApplicationStatus.AppType altExpectedAppType) {
        if (this.mUiccApplications == null || index >= this.mUiccApplications.length) {
            this.loge("App index " + index + " is invalid since there are no applications");
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (this.mUiccApplications[index].getType() != expectedAppType && this.mUiccApplications[index].getType() != altExpectedAppType) {
            this.loge("App index " + index + " is invalid since it's not " + (Object)((Object)expectedAppType) + " and not " + (Object)((Object)altExpectedAppType));
            return -1;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$registerForAbsent(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mAbsentRegistrants.add(r);
            if (this.mCardState == IccCardStatus.CardState.CARDSTATE_ABSENT) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$unregisterForAbsent(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAbsentRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$registerForCarrierPrivilegeRulesLoaded(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mCarrierPrivilegeRegistrants.add(r);
            if (this.areCarrierPriviligeRulesLoaded()) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$unregisterForCarrierPrivilegeRulesLoaded(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCarrierPrivilegeRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$onIccSwap(boolean isAdded) {
        boolean isHotSwapSupported = this.mContext.getResources().getBoolean(17956916);
        if (isHotSwapSupported) {
            this.log("onIccSwap: isHotSwapSupported is true, don't prompt for rebooting");
            return;
        }
        this.log("onIccSwap: isHotSwapSupported is false, prompt for rebooting");
        Object object = this.mLock;
        synchronized (object) {
            DialogInterface.OnClickListener listener = null;
            listener = new DialogInterface.OnClickListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ UiccCard this$0;

                private void $$robo$$com_android_internal_telephony_uicc_UiccCard_1$__constructor__(UiccCard uiccCard) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$com_android_internal_telephony_uicc_UiccCard_1$onClick(DialogInterface dialog, int which) {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        if (which == -1) {
                            this.this$0.log("Reboot due to SIM swap");
                            PowerManager pm = (PowerManager)this.this$0.mContext.getSystemService("power");
                            pm.reboot("SIM is added.");
                        }
                    }
                }

                private void __constructor__(UiccCard uiccCard) {
                    this.$$robo$$com_android_internal_telephony_uicc_UiccCard_1$__constructor__(uiccCard);
                }
                {
                    this.this$0 = uiccCard;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCard_1$__constructor__(com.android.internal.telephony.uicc.UiccCard ), 0, this, uiccCard);
                }

                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_telephony_uicc_UiccCard_1$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            Resources r = Resources.getSystem();
            String title = isAdded ? r.getString(17040586) : r.getString(17040583);
            String message = isAdded ? r.getString(17040587) : r.getString(17040584);
            String buttonTxt = r.getString(17040588);
            AlertDialog dialog = new AlertDialog.Builder(this.mContext).setTitle(title).setMessage(message).setPositiveButton(buttonTxt, listener).create();
            dialog.getWindow().setType(2003);
            dialog.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$onCarrierPriviligesLoadedMessage() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCarrierPrivilegeRegistrants.notifyRegistrants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCard$isApplicationOnIcc(IccCardApplicationStatus.AppType type) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || this.mUiccApplications[i].getType() != type) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccCardStatus.CardState $$robo$$com_android_internal_telephony_uicc_UiccCard$getCardState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCardState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccCardStatus.PinState $$robo$$com_android_internal_telephony_uicc_UiccCard$getUniversalPinState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUniversalPinState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCardApplication $$robo$$com_android_internal_telephony_uicc_UiccCard$getApplication(int family) {
        Object object = this.mLock;
        synchronized (object) {
            int index = 8;
            switch (family) {
                case 1: {
                    index = this.mGsmUmtsSubscriptionAppIndex;
                    break;
                }
                case 2: {
                    index = this.mCdmaSubscriptionAppIndex;
                    break;
                }
                case 3: {
                    index = this.mImsSubscriptionAppIndex;
                }
            }
            if (index >= 0 && index < this.mUiccApplications.length) {
                return this.mUiccApplications[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCardApplication $$robo$$com_android_internal_telephony_uicc_UiccCard$getApplicationIndex(int index) {
        Object object = this.mLock;
        synchronized (object) {
            if (index >= 0 && index < this.mUiccApplications.length) {
                return this.mUiccApplications[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCardApplication $$robo$$com_android_internal_telephony_uicc_UiccCard$getApplicationByType(int type) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || this.mUiccApplications[i].getType().ordinal() != type) continue;
                return this.mUiccApplications[i];
            }
            return null;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$iccOpenLogicalChannel(String AID, Message response) {
        this.mCi.iccOpenLogicalChannel(AID, this.mHandler.obtainMessage(15, response));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$iccCloseLogicalChannel(int channel, Message response) {
        this.mCi.iccCloseLogicalChannel(channel, this.mHandler.obtainMessage(16, response));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$iccTransmitApduLogicalChannel(int channel, int cla, int command, int p1, int p2, int p3, String data, Message response) {
        this.mCi.iccTransmitApduLogicalChannel(channel, cla, command, p1, p2, p3, data, this.mHandler.obtainMessage(17, response));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$iccTransmitApduBasicChannel(int cla, int command, int p1, int p2, int p3, String data, Message response) {
        this.mCi.iccTransmitApduBasicChannel(cla, command, p1, p2, p3, data, this.mHandler.obtainMessage(18, response));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String pathID, Message response) {
        this.mCi.iccIO(command, fileID, pathID, p1, p2, p3, null, null, this.mHandler.obtainMessage(19, response));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$sendEnvelopeWithStatus(String contents, Message response) {
        this.mCi.sendEnvelopeWithStatus(contents, response);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCard$getNumApplications() {
        int count = 0;
        for (UiccCardApplication a : this.mUiccApplications) {
            if (a == null) continue;
            ++count;
        }
        return count;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCard$areCarrierPriviligeRulesLoaded() {
        return this.mCarrierPrivilegeRules == null || this.mCarrierPrivilegeRules.areCarrierPriviligeRulesLoaded();
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCard$getCarrierPrivilegeStatus(Signature signature, String packageName) {
        return this.mCarrierPrivilegeRules == null ? -1 : this.mCarrierPrivilegeRules.getCarrierPrivilegeStatus(signature, packageName);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCard$getCarrierPrivilegeStatus(PackageManager packageManager, String packageName) {
        return this.mCarrierPrivilegeRules == null ? -1 : this.mCarrierPrivilegeRules.getCarrierPrivilegeStatus(packageManager, packageName);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCard$getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        return this.mCarrierPrivilegeRules == null ? -1 : this.mCarrierPrivilegeRules.getCarrierPrivilegeStatusForCurrentTransaction(packageManager);
    }

    private final List<String> $$robo$$com_android_internal_telephony_uicc_UiccCard$getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        return this.mCarrierPrivilegeRules == null ? null : this.mCarrierPrivilegeRules.getCarrierPackageNamesForIntent(packageManager, intent);
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCard$setOperatorBrandOverride(String brand) {
        this.log("setOperatorBrandOverride: " + brand);
        this.log("current iccId: " + this.getIccId());
        String iccId = this.getIccId();
        if (TextUtils.isEmpty(iccId)) {
            return false;
        }
        SharedPreferences.Editor spEditor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
        String key = "operator_branding_" + iccId;
        if (brand == null) {
            spEditor.remove(key).commit();
        } else {
            spEditor.putString(key, brand).commit();
        }
        return true;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccCard$getOperatorBrandOverride() {
        String iccId = this.getIccId();
        if (TextUtils.isEmpty(iccId)) {
            return null;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        return sp.getString("operator_branding_" + iccId, null);
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccCard$getIccId() {
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || (ir = app.getIccRecords()) == null || ir.getIccId() == null) continue;
            return ir.getIccId();
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$log(String msg) {
        Rlog.d("UiccCard", msg);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$loge(String msg) {
        Rlog.e("UiccCard", msg);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCard$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("UiccCard:");
        pw.println(" mCi=" + this.mCi);
        pw.println(" mDestroyed=" + this.mDestroyed);
        pw.println(" mLastRadioState=" + (Object)((Object)this.mLastRadioState));
        pw.println(" mCatService=" + this.mCatService);
        pw.println(" mAbsentRegistrants: size=" + this.mAbsentRegistrants.size());
        for (i = 0; i < this.mAbsentRegistrants.size(); ++i) {
            pw.println("  mAbsentRegistrants[" + i + "]=" + ((Registrant)this.mAbsentRegistrants.get(i)).getHandler());
        }
        for (i = 0; i < this.mCarrierPrivilegeRegistrants.size(); ++i) {
            pw.println("  mCarrierPrivilegeRegistrants[" + i + "]=" + ((Registrant)this.mCarrierPrivilegeRegistrants.get(i)).getHandler());
        }
        pw.println(" mCardState=" + (Object)((Object)this.mCardState));
        pw.println(" mUniversalPinState=" + (Object)((Object)this.mUniversalPinState));
        pw.println(" mGsmUmtsSubscriptionAppIndex=" + this.mGsmUmtsSubscriptionAppIndex);
        pw.println(" mCdmaSubscriptionAppIndex=" + this.mCdmaSubscriptionAppIndex);
        pw.println(" mImsSubscriptionAppIndex=" + this.mImsSubscriptionAppIndex);
        pw.println(" mImsSubscriptionAppIndex=" + this.mImsSubscriptionAppIndex);
        pw.println(" mUiccApplications: length=" + this.mUiccApplications.length);
        for (i = 0; i < this.mUiccApplications.length; ++i) {
            if (this.mUiccApplications[i] == null) {
                pw.println("  mUiccApplications[" + i + "]=" + null);
                continue;
            }
            pw.println("  mUiccApplications[" + i + "]=" + (Object)((Object)this.mUiccApplications[i].getType()) + " " + this.mUiccApplications[i]);
        }
        pw.println();
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.dump(fd, pw, args);
            pw.println();
        }
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || (ir = app.getIccRecords()) == null) continue;
            ir.dump(fd, pw, args);
            pw.println();
        }
        pw.flush();
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, IccCardStatus iccCardStatus) {
        this.$$robo$$com_android_internal_telephony_uicc_UiccCard$__constructor__(context, commandsInterface, iccCardStatus);
    }

    public UiccCard(Context context, CommandsInterface commandsInterface, IccCardStatus iccCardStatus) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCard$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.uicc.IccCardStatus ), 0, this, context, commandsInterface, iccCardStatus);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, IccCardStatus iccCardStatus, int n) {
        this.$$robo$$com_android_internal_telephony_uicc_UiccCard$__constructor__(context, commandsInterface, iccCardStatus, n);
    }

    public UiccCard(Context context, CommandsInterface commandsInterface, IccCardStatus iccCardStatus, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCard$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.uicc.IccCardStatus int ), 0, this, context, commandsInterface, iccCardStatus, n);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_uicc_UiccCard$__constructor__();
    }

    protected UiccCard() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCard$__constructor__(), 0, this);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_uicc_UiccCard$dispose(), 0, this);
    }

    public void update(Context context, CommandsInterface commandsInterface, IccCardStatus iccCardStatus) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_uicc_UiccCard$update(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.uicc.IccCardStatus ), 0, this, context, commandsInterface, iccCardStatus);
    }

    protected void createAndUpdateCatService() {
        InvokeDynamicSupport.bootstrap("createAndUpdateCatService", $$robo$$com_android_internal_telephony_uicc_UiccCard$createAndUpdateCatService(), 0, this);
    }

    public CatService getCatService() {
        return InvokeDynamicSupport.bootstrap("getCatService", $$robo$$com_android_internal_telephony_uicc_UiccCard$getCatService(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_uicc_UiccCard$finalize(), 0, this);
    }

    private void sanitizeApplicationIndexes() {
        InvokeDynamicSupport.bootstrap("sanitizeApplicationIndexes", $$robo$$com_android_internal_telephony_uicc_UiccCard$sanitizeApplicationIndexes(), 0, this);
    }

    private int checkIndex(int n, IccCardApplicationStatus.AppType appType, IccCardApplicationStatus.AppType appType2) {
        return (int)InvokeDynamicSupport.bootstrap("checkIndex", $$robo$$com_android_internal_telephony_uicc_UiccCard$checkIndex(int com.android.internal.telephony.uicc.IccCardApplicationStatus$AppType com.android.internal.telephony.uicc.IccCardApplicationStatus$AppType ), 0, this, n, appType, appType2);
    }

    public void registerForAbsent(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForAbsent", $$robo$$com_android_internal_telephony_uicc_UiccCard$registerForAbsent(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForAbsent(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForAbsent", $$robo$$com_android_internal_telephony_uicc_UiccCard$unregisterForAbsent(android.os.Handler ), 0, this, handler);
    }

    public void registerForCarrierPrivilegeRulesLoaded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCarrierPrivilegeRulesLoaded", $$robo$$com_android_internal_telephony_uicc_UiccCard$registerForCarrierPrivilegeRulesLoaded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForCarrierPrivilegeRulesLoaded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCarrierPrivilegeRulesLoaded", $$robo$$com_android_internal_telephony_uicc_UiccCard$unregisterForCarrierPrivilegeRulesLoaded(android.os.Handler ), 0, this, handler);
    }

    private void onIccSwap(boolean bl) {
        InvokeDynamicSupport.bootstrap("onIccSwap", $$robo$$com_android_internal_telephony_uicc_UiccCard$onIccSwap(boolean ), 0, this, bl);
    }

    private void onCarrierPriviligesLoadedMessage() {
        InvokeDynamicSupport.bootstrap("onCarrierPriviligesLoadedMessage", $$robo$$com_android_internal_telephony_uicc_UiccCard$onCarrierPriviligesLoadedMessage(), 0, this);
    }

    public boolean isApplicationOnIcc(IccCardApplicationStatus.AppType appType) {
        return (boolean)InvokeDynamicSupport.bootstrap("isApplicationOnIcc", $$robo$$com_android_internal_telephony_uicc_UiccCard$isApplicationOnIcc(com.android.internal.telephony.uicc.IccCardApplicationStatus$AppType ), 0, this, appType);
    }

    public IccCardStatus.CardState getCardState() {
        return InvokeDynamicSupport.bootstrap("getCardState", $$robo$$com_android_internal_telephony_uicc_UiccCard$getCardState(), 0, this);
    }

    public IccCardStatus.PinState getUniversalPinState() {
        return InvokeDynamicSupport.bootstrap("getUniversalPinState", $$robo$$com_android_internal_telephony_uicc_UiccCard$getUniversalPinState(), 0, this);
    }

    public UiccCardApplication getApplication(int n) {
        return InvokeDynamicSupport.bootstrap("getApplication", $$robo$$com_android_internal_telephony_uicc_UiccCard$getApplication(int ), 0, this, n);
    }

    public UiccCardApplication getApplicationIndex(int n) {
        return InvokeDynamicSupport.bootstrap("getApplicationIndex", $$robo$$com_android_internal_telephony_uicc_UiccCard$getApplicationIndex(int ), 0, this, n);
    }

    public UiccCardApplication getApplicationByType(int n) {
        return InvokeDynamicSupport.bootstrap("getApplicationByType", $$robo$$com_android_internal_telephony_uicc_UiccCard$getApplicationByType(int ), 0, this, n);
    }

    public void iccOpenLogicalChannel(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccOpenLogicalChannel", $$robo$$com_android_internal_telephony_uicc_UiccCard$iccOpenLogicalChannel(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    public void iccCloseLogicalChannel(int n, Message message) {
        InvokeDynamicSupport.bootstrap("iccCloseLogicalChannel", $$robo$$com_android_internal_telephony_uicc_UiccCard$iccCloseLogicalChannel(int android.os.Message ), 0, this, n, message);
    }

    public void iccTransmitApduLogicalChannel(int n, int n2, int n3, int n4, int n5, int n6, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduLogicalChannel", $$robo$$com_android_internal_telephony_uicc_UiccCard$iccTransmitApduLogicalChannel(int int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, n6, string2, message);
    }

    public void iccTransmitApduBasicChannel(int n, int n2, int n3, int n4, int n5, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduBasicChannel", $$robo$$com_android_internal_telephony_uicc_UiccCard$iccTransmitApduBasicChannel(int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, string2, message);
    }

    public void iccExchangeSimIO(int n, int n2, int n3, int n4, int n5, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccExchangeSimIO", $$robo$$com_android_internal_telephony_uicc_UiccCard$iccExchangeSimIO(int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, string2, message);
    }

    public void sendEnvelopeWithStatus(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendEnvelopeWithStatus", $$robo$$com_android_internal_telephony_uicc_UiccCard$sendEnvelopeWithStatus(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    public int getNumApplications() {
        return (int)InvokeDynamicSupport.bootstrap("getNumApplications", $$robo$$com_android_internal_telephony_uicc_UiccCard$getNumApplications(), 0, this);
    }

    public boolean areCarrierPriviligeRulesLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("areCarrierPriviligeRulesLoaded", $$robo$$com_android_internal_telephony_uicc_UiccCard$areCarrierPriviligeRulesLoaded(), 0, this);
    }

    public int getCarrierPrivilegeStatus(Signature signature, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_uicc_UiccCard$getCarrierPrivilegeStatus(android.content.pm.Signature java.lang.String ), 0, this, signature, string2);
    }

    public int getCarrierPrivilegeStatus(PackageManager packageManager, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_uicc_UiccCard$getCarrierPrivilegeStatus(android.content.pm.PackageManager java.lang.String ), 0, this, packageManager, string2);
    }

    public int getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatusForCurrentTransaction", $$robo$$com_android_internal_telephony_uicc_UiccCard$getCarrierPrivilegeStatusForCurrentTransaction(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public List<String> getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        return InvokeDynamicSupport.bootstrap("getCarrierPackageNamesForIntent", $$robo$$com_android_internal_telephony_uicc_UiccCard$getCarrierPackageNamesForIntent(android.content.pm.PackageManager android.content.Intent ), 0, this, packageManager, intent);
    }

    public boolean setOperatorBrandOverride(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$com_android_internal_telephony_uicc_UiccCard$setOperatorBrandOverride(java.lang.String ), 0, this, string2);
    }

    public String getOperatorBrandOverride() {
        return InvokeDynamicSupport.bootstrap("getOperatorBrandOverride", $$robo$$com_android_internal_telephony_uicc_UiccCard$getOperatorBrandOverride(), 0, this);
    }

    public String getIccId() {
        return InvokeDynamicSupport.bootstrap("getIccId", $$robo$$com_android_internal_telephony_uicc_UiccCard$getIccId(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_UiccCard$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_uicc_UiccCard$loge(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_UiccCard$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiccCard)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

