/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCard;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UiccCarrierPrivilegeRules
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "UiccCarrierPrivilegeRules";
    private static String AID = "A00000015141434C00";
    private static int CLA = 128;
    private static int COMMAND = 202;
    private static int P1 = 255;
    private static int P2 = 64;
    private static int P3 = 0;
    private static String DATA = "";
    private static String TAG_ALL_REF_AR_DO = "FF40";
    private static String TAG_REF_AR_DO = "E2";
    private static String TAG_REF_DO = "E1";
    private static String TAG_DEVICE_APP_ID_REF_DO = "C1";
    private static String TAG_PKG_REF_DO = "CA";
    private static String TAG_AR_DO = "E3";
    private static String TAG_PERM_AR_DO = "DB";
    private static int EVENT_OPEN_LOGICAL_CHANNEL_DONE = 1;
    private static int EVENT_TRANSMIT_LOGICAL_CHANNEL_DONE = 2;
    private static int EVENT_CLOSE_LOGICAL_CHANNEL_DONE = 3;
    private static int STATE_LOADING = 0;
    private static int STATE_LOADED = 1;
    private static int STATE_ERROR = 2;
    private UiccCard mUiccCard;
    private AtomicInteger mState;
    private List<AccessRule> mAccessRules;
    private Message mLoadedCallback;

    private void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$__constructor__(UiccCard uiccCard, Message loadedCallback) {
        Rlog.d("UiccCarrierPrivilegeRules", "Creating UiccCarrierPrivilegeRules");
        this.mUiccCard = uiccCard;
        this.mState = new AtomicInteger(0);
        this.mLoadedCallback = loadedCallback;
        this.mUiccCard.iccOpenLogicalChannel("A00000015141434C00", this.obtainMessage(1, null));
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$areCarrierPriviligeRulesLoaded() {
        return this.mState.get() != 0;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatus(Signature signature, String packageName) {
        Rlog.d("UiccCarrierPrivilegeRules", "hasCarrierPrivileges: " + signature + " : " + packageName);
        int state = this.mState.get();
        if (state == 0) {
            Rlog.d("UiccCarrierPrivilegeRules", "Rules not loaded.");
            return -1;
        }
        if (state == 2) {
            Rlog.d("UiccCarrierPrivilegeRules", "Error loading rules.");
            return -2;
        }
        byte[] certHash = UiccCarrierPrivilegeRules.getCertHash(signature);
        if (certHash == null) {
            return 0;
        }
        Rlog.e("UiccCarrierPrivilegeRules", "Checking: " + IccUtils.bytesToHexString(certHash) + " : " + packageName);
        for (AccessRule ar : this.mAccessRules) {
            if (!ar.matches(certHash, packageName)) continue;
            Rlog.d("UiccCarrierPrivilegeRules", "Match found!");
            return 1;
        }
        Rlog.d("UiccCarrierPrivilegeRules", "No matching rule found. Returning false.");
        return 0;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatus(PackageManager packageManager, String packageName) {
        try {
            Signature[] signatures;
            PackageInfo pInfo = packageManager.getPackageInfo(packageName, 64);
            for (Signature sig : signatures = pInfo.signatures) {
                int accessStatus = this.getCarrierPrivilegeStatus(sig, pInfo.packageName);
                if (accessStatus == 0) continue;
                return accessStatus;
            }
        }
        catch (PackageManager.NameNotFoundException ex) {
            Rlog.e("UiccCarrierPrivilegeRules", "NameNotFoundException", ex);
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        String[] packages;
        for (String pkg : packages = packageManager.getPackagesForUid(Binder.getCallingUid())) {
            int accessStatus = this.getCarrierPrivilegeStatus(packageManager, pkg);
            if (accessStatus == 0) continue;
            return accessStatus;
        }
        return 0;
    }

    private final List<String> $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        ArrayList<String> packages = new ArrayList<String>();
        ArrayList<ResolveInfo> receivers = new ArrayList<ResolveInfo>();
        receivers.addAll(packageManager.queryBroadcastReceivers(intent, 0));
        receivers.addAll(packageManager.queryIntentContentProviders(intent, 0));
        receivers.addAll(packageManager.queryIntentActivities(intent, 0));
        receivers.addAll(packageManager.queryIntentServices(intent, 0));
        for (ResolveInfo resolveInfo : receivers) {
            if (resolveInfo.activityInfo == null) continue;
            String packageName = resolveInfo.activityInfo.packageName;
            int status = this.getCarrierPrivilegeStatus(packageManager, packageName);
            if (status == 1) {
                packages.add(packageName);
                continue;
            }
            if (status == 0) continue;
            return null;
        }
        return packages;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                Rlog.d("UiccCarrierPrivilegeRules", "EVENT_OPEN_LOGICAL_CHANNEL_DONE");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && ar.result != null) {
                    int channelId = ((int[])ar.result)[0];
                    this.mUiccCard.iccTransmitApduLogicalChannel(channelId, 128, 202, 255, 64, 0, "", this.obtainMessage(2, new Integer(channelId)));
                    break;
                }
                Rlog.e("UiccCarrierPrivilegeRules", "Error opening channel");
                this.updateState(2);
                break;
            }
            case 2: {
                Rlog.d("UiccCarrierPrivilegeRules", "EVENT_TRANSMIT_LOGICAL_CHANNEL_DONE");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && ar.result != null) {
                    IccIoResult response = (IccIoResult)ar.result;
                    if (response.payload != null && response.sw1 == 144 && response.sw2 == 0) {
                        try {
                            this.mAccessRules = UiccCarrierPrivilegeRules.parseRules(IccUtils.bytesToHexString(response.payload));
                            this.updateState(1);
                        }
                        catch (IllegalArgumentException ex) {
                            Rlog.e("UiccCarrierPrivilegeRules", "Error parsing rules: " + ex);
                            this.updateState(2);
                        }
                    } else {
                        Rlog.e("UiccCarrierPrivilegeRules", "Invalid response: payload=" + response.payload + " sw1=" + response.sw1 + " sw2=" + response.sw2);
                        this.updateState(2);
                    }
                } else {
                    Rlog.e("UiccCarrierPrivilegeRules", "Error reading value from SIM.");
                    this.updateState(2);
                }
                int channelId = (Integer)ar.userObj;
                this.mUiccCard.iccCloseLogicalChannel(channelId, this.obtainMessage(3));
                break;
            }
            case 3: {
                Rlog.d("UiccCarrierPrivilegeRules", "EVENT_CLOSE_LOGICAL_CHANNEL_DONE");
                break;
            }
            default: {
                Rlog.e("UiccCarrierPrivilegeRules", "Unknown event " + msg.what);
            }
        }
    }

    private static final List<AccessRule> $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$parseRules(String rules) {
        rules = rules.toUpperCase(Locale.US);
        Rlog.d("UiccCarrierPrivilegeRules", "Got rules: " + rules);
        TLV allRefArDo = new TLV("FF40");
        allRefArDo.parse(rules, true);
        String arDos = allRefArDo.value;
        ArrayList<AccessRule> accessRules = new ArrayList<AccessRule>();
        while (!arDos.isEmpty()) {
            TLV refArDo = new TLV("E2");
            arDos = refArDo.parse(arDos, false);
            AccessRule accessRule = UiccCarrierPrivilegeRules.parseRefArdo(refArDo.value);
            if (accessRule != null) {
                accessRules.add(accessRule);
                continue;
            }
            Rlog.e("UiccCarrierPrivilegeRules", "Skip unrecognized rule." + refArDo.value);
        }
        return accessRules;
    }

    private static final AccessRule $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$parseRefArdo(String rule) {
        Rlog.d("UiccCarrierPrivilegeRules", "Got rule: " + rule);
        String certificateHash = null;
        String packageName = null;
        String tmp = null;
        long accessType = 0L;
        while (!rule.isEmpty()) {
            if (rule.startsWith("E1")) {
                TLV refDo = new TLV("E1");
                rule = refDo.parse(rule, false);
                if (!refDo.value.startsWith("C1")) {
                    return null;
                }
                TLV deviceDo = new TLV("C1");
                tmp = deviceDo.parse(refDo.value, false);
                certificateHash = deviceDo.value;
                if (!tmp.isEmpty()) {
                    if (!tmp.startsWith("CA")) {
                        return null;
                    }
                    TLV pkgDo = new TLV("CA");
                    pkgDo.parse(tmp, true);
                    packageName = new String(IccUtils.hexStringToBytes(pkgDo.value));
                    continue;
                }
                packageName = null;
                continue;
            }
            if (rule.startsWith("E3")) {
                TLV arDo = new TLV("E3");
                rule = arDo.parse(rule, false);
                if (!arDo.value.startsWith("DB")) {
                    return null;
                }
                TLV permDo = new TLV("DB");
                permDo.parse(arDo.value, true);
                Rlog.e("UiccCarrierPrivilegeRules", permDo.value);
                continue;
            }
            throw new RuntimeException("Invalid Rule type");
        }
        Rlog.e("UiccCarrierPrivilegeRules", "Adding: " + certificateHash + " : " + packageName + " : " + accessType);
        AccessRule accessRule = new AccessRule(IccUtils.hexStringToBytes(certificateHash), packageName, accessType);
        Rlog.e("UiccCarrierPrivilegeRules", "Parsed rule: " + accessRule);
        return accessRule;
    }

    private static final byte[] $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCertHash(Signature signature) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
            MessageDigest md = MessageDigest.getInstance("SHA");
            return md.digest(cert.getEncoded());
        }
        catch (CertificateException ex) {
            Rlog.e("UiccCarrierPrivilegeRules", "CertificateException: " + ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Rlog.e("UiccCarrierPrivilegeRules", "NoSuchAlgorithmException: " + ex);
        }
        Rlog.e("UiccCarrierPrivilegeRules", "Cannot compute cert hash");
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$updateState(int newState) {
        this.mState.set(newState);
        if (this.mLoadedCallback != null) {
            this.mLoadedCallback.sendToTarget();
        }
    }

    private void __constructor__(UiccCard uiccCard, Message message) {
        this.$$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$__constructor__(uiccCard, message);
    }

    public UiccCarrierPrivilegeRules(UiccCard uiccCard, Message message) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$__constructor__(com.android.internal.telephony.uicc.UiccCard android.os.Message ), 0, this, uiccCard, message);
    }

    public boolean areCarrierPriviligeRulesLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("areCarrierPriviligeRulesLoaded", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$areCarrierPriviligeRulesLoaded(), 0, this);
    }

    public int getCarrierPrivilegeStatus(Signature signature, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatus(android.content.pm.Signature java.lang.String ), 0, this, signature, string2);
    }

    public int getCarrierPrivilegeStatus(PackageManager packageManager, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatus(android.content.pm.PackageManager java.lang.String ), 0, this, packageManager, string2);
    }

    public int getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatusForCurrentTransaction", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatusForCurrentTransaction(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public List<String> getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        return InvokeDynamicSupport.bootstrap("getCarrierPackageNamesForIntent", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPackageNamesForIntent(android.content.pm.PackageManager android.content.Intent ), 0, this, packageManager, intent);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$handleMessage(android.os.Message ), 0, this, message);
    }

    private static List<AccessRule> parseRules(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseRules", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$parseRules(java.lang.String ), 0, (String)string2);
    }

    private static AccessRule parseRefArdo(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseRefArdo", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$parseRefArdo(java.lang.String ), 0, (String)string2);
    }

    private static byte[] getCertHash(Signature signature) {
        return InvokeDynamicSupport.bootstrapStatic("getCertHash", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCertHash(android.content.pm.Signature ), 0, (Signature)signature);
    }

    private void updateState(int n) {
        InvokeDynamicSupport.bootstrap("updateState", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$updateState(int ), 0, this, n);
    }

    public /* synthetic */ UiccCarrierPrivilegeRules() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiccCarrierPrivilegeRules)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class TLV
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String tag;
        private Integer length;
        private String value;

        private void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$__constructor__(String tag) {
            this.tag = tag;
        }

        private final String $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$parse(String data, boolean shouldConsumeAll) {
            Rlog.d("UiccCarrierPrivilegeRules", "Parse TLV: " + this.tag);
            if (!data.startsWith(this.tag)) {
                throw new IllegalArgumentException("Tags don't match.");
            }
            int index = this.tag.length();
            if (index + 2 > data.length()) {
                throw new IllegalArgumentException("No length.");
            }
            this.length = new Integer(2 * Integer.parseInt(data.substring(index, index + 2), 16));
            int remainingLength = data.length() - ((index += 2) + this.length);
            if (remainingLength < 0) {
                throw new IllegalArgumentException("Not enough data.");
            }
            if (shouldConsumeAll && remainingLength != 0) {
                throw new IllegalArgumentException("Did not consume all.");
            }
            this.value = data.substring(index, index + this.length);
            Rlog.d("UiccCarrierPrivilegeRules", "Got TLV: " + this.tag + "," + this.length + "," + this.value);
            return data.substring(index + this.length);
        }

        private void __constructor__(String string2) {
            this.$$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$__constructor__(string2);
        }

        public TLV(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$__constructor__(java.lang.String ), 0, this, string2);
        }

        public String parse(String string2, boolean bl) {
            return InvokeDynamicSupport.bootstrap("parse", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$parse(java.lang.String boolean ), 0, this, string2, bl);
        }

        public /* synthetic */ TLV() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TLV)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AccessRule
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public byte[] certificateHash;
        public String packageName;
        public long accessType;

        private void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_AccessRule$__constructor__(byte[] certificateHash, String packageName, long accessType) {
            this.certificateHash = certificateHash;
            this.packageName = packageName;
            this.accessType = accessType;
        }

        private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_AccessRule$matches(byte[] certHash, String packageName) {
            return certHash != null && Arrays.equals(this.certificateHash, certHash) && (this.packageName == null || this.packageName.equals(packageName));
        }

        private final String $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_AccessRule$toString() {
            return "cert: " + this.certificateHash + " pkg: " + this.packageName + " access: " + this.accessType;
        }

        private void __constructor__(byte[] byArray, String string2, long l) {
            this.$$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_AccessRule$__constructor__(byArray, string2, l);
        }

        AccessRule(byte[] byArray, String string2, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_AccessRule$__constructor__(byte[] java.lang.String long ), 0, this, byArray, string2, l);
        }

        boolean matches(byte[] byArray, String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_AccessRule$matches(byte[] java.lang.String ), 0, this, byArray, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_AccessRule$toString(), 0, this);
        }

        public /* synthetic */ AccessRule() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessRule)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

