/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.util.AsyncService;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Stack;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AsyncChannel
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AsyncChannel";
    private static boolean DBG = false;
    private static int BASE = 69632;
    public static int CMD_CHANNEL_HALF_CONNECTED = 69632;
    public static int CMD_CHANNEL_FULL_CONNECTION = 69633;
    public static int CMD_CHANNEL_FULLY_CONNECTED = 69634;
    public static int CMD_CHANNEL_DISCONNECT = 69635;
    public static int CMD_CHANNEL_DISCONNECTED = 69636;
    private static int CMD_TO_STRING_COUNT = 5;
    private static String[] sCmdToString;
    public static int STATUS_SUCCESSFUL = 0;
    public static int STATUS_BINDING_UNSUCCESSFUL = 1;
    public static int STATUS_SEND_UNSUCCESSFUL = 2;
    public static int STATUS_FULL_CONNECTION_REFUSED_ALREADY_CONNECTED = 3;
    public static int STATUS_REMOTE_DISCONNECTION = 4;
    private AsyncChannelConnection mConnection;
    private Context mSrcContext;
    private Handler mSrcHandler;
    private Messenger mSrcMessenger;
    private Messenger mDstMessenger;
    private DeathMonitor mDeathMonitor;

    private static final String $$robo$$com_android_internal_util_AsyncChannel$cmdToString(int cmd) {
        if ((cmd -= 69632) >= 0 && cmd < sCmdToString.length) {
            return sCmdToString[cmd];
        }
        return null;
    }

    private void $$robo$$com_android_internal_util_AsyncChannel$__constructor__() {
    }

    private final int $$robo$$com_android_internal_util_AsyncChannel$connectSrcHandlerToPackageSync(Context srcContext, Handler srcHandler, String dstPackageName, String dstClassName) {
        this.mConnection = new AsyncChannelConnection(this);
        this.mSrcContext = srcContext;
        this.mSrcHandler = srcHandler;
        this.mSrcMessenger = new Messenger(srcHandler);
        this.mDstMessenger = null;
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setClassName(dstPackageName, dstClassName);
        boolean result = srcContext.bindService(intent, this.mConnection, 1);
        return result ? 0 : 1;
    }

    private final int $$robo$$com_android_internal_util_AsyncChannel$connectSync(Context srcContext, Handler srcHandler, Messenger dstMessenger) {
        this.connected(srcContext, srcHandler, dstMessenger);
        return 0;
    }

    private final int $$robo$$com_android_internal_util_AsyncChannel$connectSync(Context srcContext, Handler srcHandler, Handler dstHandler) {
        return this.connectSync(srcContext, srcHandler, new Messenger(dstHandler));
    }

    private final int $$robo$$com_android_internal_util_AsyncChannel$fullyConnectSync(Context srcContext, Handler srcHandler, Handler dstHandler) {
        int status = this.connectSync(srcContext, srcHandler, dstHandler);
        if (status == 0) {
            Message response = this.sendMessageSynchronously(69633);
            status = response.arg1;
        }
        return status;
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$connect(Context srcContext, Handler srcHandler, String dstPackageName, String dstClassName) {
        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public final class ConnectAsync
        implements Runnable,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            Context mSrcCtx;
            Handler mSrcHdlr;
            String mDstPackageName;
            String mDstClassName;
            /* synthetic */ AsyncChannel this$0;

            private void $$robo$$com_android_internal_util_AsyncChannel_1ConnectAsync$__constructor__(AsyncChannel asyncChannel, Context srcContext, Handler srcHandler, String dstPackageName, String dstClassName) {
                this.mSrcCtx = srcContext;
                this.mSrcHdlr = srcHandler;
                this.mDstPackageName = dstPackageName;
                this.mDstClassName = dstClassName;
            }

            private final void $$robo$$com_android_internal_util_AsyncChannel_1ConnectAsync$run() {
                int result = this.this$0.connectSrcHandlerToPackageSync(this.mSrcCtx, this.mSrcHdlr, this.mDstPackageName, this.mDstClassName);
                this.this$0.replyHalfConnected(result);
            }

            private void __constructor__(AsyncChannel asyncChannel, Context context, Handler handler, String string2, String string3) {
                this.$$robo$$com_android_internal_util_AsyncChannel_1ConnectAsync$__constructor__(asyncChannel, context, handler, string2, string3);
            }

            ConnectAsync(AsyncChannel asyncChannel, Context context, Handler handler, String string2, String string3) {
                this.this$0 = asyncChannel;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_AsyncChannel_1ConnectAsync$__constructor__(com.android.internal.util.AsyncChannel android.content.Context android.os.Handler java.lang.String java.lang.String ), 0, this, asyncChannel, context, handler, string2, string3);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_util_AsyncChannel_1ConnectAsync$run(), 0, this);
            }

            public /* synthetic */ ConnectAsync() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectAsync)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
        ConnectAsync ca = new ConnectAsync(this, srcContext, srcHandler, dstPackageName, dstClassName);
        new Thread(ca).start();
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$connect(Context srcContext, Handler srcHandler, Class<?> klass) {
        this.connect(srcContext, srcHandler, klass.getPackage().getName(), klass.getName());
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$connect(Context srcContext, Handler srcHandler, Messenger dstMessenger) {
        this.connected(srcContext, srcHandler, dstMessenger);
        this.replyHalfConnected(0);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$connected(Context srcContext, Handler srcHandler, Messenger dstMessenger) {
        this.mSrcContext = srcContext;
        this.mSrcHandler = srcHandler;
        this.mSrcMessenger = new Messenger(this.mSrcHandler);
        this.mDstMessenger = dstMessenger;
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$connect(Context srcContext, Handler srcHandler, Handler dstHandler) {
        this.connect(srcContext, srcHandler, new Messenger(dstHandler));
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$connect(AsyncService srcAsyncService, Messenger dstMessenger) {
        this.connect((Context)srcAsyncService, srcAsyncService.getHandler(), dstMessenger);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$disconnected() {
        this.mSrcContext = null;
        this.mSrcHandler = null;
        this.mSrcMessenger = null;
        this.mDstMessenger = null;
        this.mDeathMonitor = null;
        this.mConnection = null;
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$disconnect() {
        if (this.mConnection != null && this.mSrcContext != null) {
            this.mSrcContext.unbindService(this.mConnection);
            this.mConnection = null;
        }
        try {
            Message msg = Message.obtain();
            msg.what = 69636;
            msg.replyTo = this.mSrcMessenger;
            this.mDstMessenger.send(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mSrcHandler != null) {
            this.replyDisconnected(0);
            this.mSrcHandler = null;
        }
        if (this.mConnection == null && this.mDstMessenger != null && this.mDeathMonitor != null) {
            this.mDstMessenger.getBinder().unlinkToDeath(this.mDeathMonitor, 0);
            this.mDeathMonitor = null;
        }
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$sendMessage(Message msg) {
        msg.replyTo = this.mSrcMessenger;
        try {
            this.mDstMessenger.send(msg);
        }
        catch (RemoteException e) {
            this.replyDisconnected(2);
        }
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$sendMessage(int what) {
        Message msg = Message.obtain();
        msg.what = what;
        this.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$sendMessage(int what, int arg1) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        this.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$sendMessage(int what, int arg1, int arg2) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        this.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$sendMessage(int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        this.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$sendMessage(int what, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.obj = obj;
        this.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(Message srcMsg, Message dstMsg) {
        try {
            dstMsg.replyTo = this.mSrcMessenger;
            srcMsg.replyTo.send(dstMsg);
        }
        catch (RemoteException e) {
            AsyncChannel.log("TODO: handle replyToMessage RemoteException" + e);
            e.printStackTrace();
        }
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(Message srcMsg, int what) {
        Message msg = Message.obtain();
        msg.what = what;
        this.replyToMessage(srcMsg, msg);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(Message srcMsg, int what, int arg1) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        this.replyToMessage(srcMsg, msg);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(Message srcMsg, int what, int arg1, int arg2) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        this.replyToMessage(srcMsg, msg);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(Message srcMsg, int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        this.replyToMessage(srcMsg, msg);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(Message srcMsg, int what, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.obj = obj;
        this.replyToMessage(srcMsg, msg);
    }

    private final Message $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(Message msg) {
        Message resultMsg = SyncMessenger.sendMessageSynchronously(this.mDstMessenger, msg);
        return resultMsg;
    }

    private final Message $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(int what) {
        Message msg = Message.obtain();
        msg.what = what;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    private final Message $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(int what, int arg1) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    private final Message $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(int what, int arg1, int arg2) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    private final Message $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    private final Message $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(int what, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.obj = obj;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$replyHalfConnected(int status) {
        Message msg = this.mSrcHandler.obtainMessage(69632);
        msg.arg1 = status;
        msg.obj = this;
        msg.replyTo = this.mDstMessenger;
        if (this.mConnection == null) {
            this.mDeathMonitor = new DeathMonitor(this);
            try {
                this.mDstMessenger.getBinder().linkToDeath(this.mDeathMonitor, 0);
            }
            catch (RemoteException e) {
                this.mDeathMonitor = null;
                msg.arg1 = 1;
            }
        }
        this.mSrcHandler.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_util_AsyncChannel$replyDisconnected(int status) {
        Message msg = this.mSrcHandler.obtainMessage(69636);
        msg.arg1 = status;
        msg.obj = this;
        msg.replyTo = this.mDstMessenger;
        this.mSrcHandler.sendMessage(msg);
    }

    private static final void $$robo$$com_android_internal_util_AsyncChannel$log(String s) {
        Slog.d("AsyncChannel", s);
    }

    static void __staticInitializer__() {
        sCmdToString = new String[5];
        AsyncChannel.sCmdToString[0] = "CMD_CHANNEL_HALF_CONNECTED";
        AsyncChannel.sCmdToString[1] = "CMD_CHANNEL_FULL_CONNECTION";
        AsyncChannel.sCmdToString[2] = "CMD_CHANNEL_FULLY_CONNECTED";
        AsyncChannel.sCmdToString[3] = "CMD_CHANNEL_DISCONNECT";
        AsyncChannel.sCmdToString[4] = "CMD_CHANNEL_DISCONNECTED";
    }

    protected static String cmdToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("cmdToString", $$robo$$com_android_internal_util_AsyncChannel$cmdToString(int ), 0, (int)n);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_AsyncChannel$__constructor__();
    }

    public AsyncChannel() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_AsyncChannel$__constructor__(), 0, this);
    }

    public int connectSrcHandlerToPackageSync(Context context, Handler handler, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("connectSrcHandlerToPackageSync", $$robo$$com_android_internal_util_AsyncChannel$connectSrcHandlerToPackageSync(android.content.Context android.os.Handler java.lang.String java.lang.String ), 0, this, context, handler, string2, string3);
    }

    public int connectSync(Context context, Handler handler, Messenger messenger) {
        return (int)InvokeDynamicSupport.bootstrap("connectSync", $$robo$$com_android_internal_util_AsyncChannel$connectSync(android.content.Context android.os.Handler android.os.Messenger ), 0, this, context, handler, messenger);
    }

    public int connectSync(Context context, Handler handler, Handler handler2) {
        return (int)InvokeDynamicSupport.bootstrap("connectSync", $$robo$$com_android_internal_util_AsyncChannel$connectSync(android.content.Context android.os.Handler android.os.Handler ), 0, this, context, handler, handler2);
    }

    public int fullyConnectSync(Context context, Handler handler, Handler handler2) {
        return (int)InvokeDynamicSupport.bootstrap("fullyConnectSync", $$robo$$com_android_internal_util_AsyncChannel$fullyConnectSync(android.content.Context android.os.Handler android.os.Handler ), 0, this, context, handler, handler2);
    }

    public void connect(Context context, Handler handler, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$com_android_internal_util_AsyncChannel$connect(android.content.Context android.os.Handler java.lang.String java.lang.String ), 0, this, context, handler, string2, string3);
    }

    public void connect(Context context, Handler handler, Class<?> clazz) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$com_android_internal_util_AsyncChannel$connect(android.content.Context android.os.Handler java.lang.Class<?> ), 0, this, context, handler, clazz);
    }

    public void connect(Context context, Handler handler, Messenger messenger) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$com_android_internal_util_AsyncChannel$connect(android.content.Context android.os.Handler android.os.Messenger ), 0, this, context, handler, messenger);
    }

    public void connected(Context context, Handler handler, Messenger messenger) {
        InvokeDynamicSupport.bootstrap("connected", $$robo$$com_android_internal_util_AsyncChannel$connected(android.content.Context android.os.Handler android.os.Messenger ), 0, this, context, handler, messenger);
    }

    public void connect(Context context, Handler handler, Handler handler2) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$com_android_internal_util_AsyncChannel$connect(android.content.Context android.os.Handler android.os.Handler ), 0, this, context, handler, handler2);
    }

    public void connect(AsyncService asyncService, Messenger messenger) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$com_android_internal_util_AsyncChannel$connect(com.android.internal.util.AsyncService android.os.Messenger ), 0, this, asyncService, messenger);
    }

    public void disconnected() {
        InvokeDynamicSupport.bootstrap("disconnected", $$robo$$com_android_internal_util_AsyncChannel$disconnected(), 0, this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$com_android_internal_util_AsyncChannel$disconnect(), 0, this);
    }

    public void sendMessage(Message message) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_AsyncChannel$sendMessage(android.os.Message ), 0, this, message);
    }

    public void sendMessage(int n) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_AsyncChannel$sendMessage(int ), 0, this, n);
    }

    public void sendMessage(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_AsyncChannel$sendMessage(int int ), 0, this, n, n2);
    }

    public void sendMessage(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_AsyncChannel$sendMessage(int int int ), 0, this, n, n2, n3);
    }

    public void sendMessage(int n, int n2, int n3, Object object) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_AsyncChannel$sendMessage(int int int java.lang.Object ), 0, this, n, n2, n3, object);
    }

    public void sendMessage(int n, Object object) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_AsyncChannel$sendMessage(int java.lang.Object ), 0, this, n, object);
    }

    public void replyToMessage(Message message, Message message2) {
        InvokeDynamicSupport.bootstrap("replyToMessage", $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(android.os.Message android.os.Message ), 0, this, message, message2);
    }

    public void replyToMessage(Message message, int n) {
        InvokeDynamicSupport.bootstrap("replyToMessage", $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(android.os.Message int ), 0, this, message, n);
    }

    public void replyToMessage(Message message, int n, int n2) {
        InvokeDynamicSupport.bootstrap("replyToMessage", $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(android.os.Message int int ), 0, this, message, n, n2);
    }

    public void replyToMessage(Message message, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("replyToMessage", $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(android.os.Message int int int ), 0, this, message, n, n2, n3);
    }

    public void replyToMessage(Message message, int n, int n2, int n3, Object object) {
        InvokeDynamicSupport.bootstrap("replyToMessage", $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(android.os.Message int int int java.lang.Object ), 0, this, message, n, n2, n3, object);
    }

    public void replyToMessage(Message message, int n, Object object) {
        InvokeDynamicSupport.bootstrap("replyToMessage", $$robo$$com_android_internal_util_AsyncChannel$replyToMessage(android.os.Message int java.lang.Object ), 0, this, message, n, object);
    }

    public Message sendMessageSynchronously(Message message) {
        return InvokeDynamicSupport.bootstrap("sendMessageSynchronously", $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(android.os.Message ), 0, this, message);
    }

    public Message sendMessageSynchronously(int n) {
        return InvokeDynamicSupport.bootstrap("sendMessageSynchronously", $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(int ), 0, this, n);
    }

    public Message sendMessageSynchronously(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("sendMessageSynchronously", $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(int int ), 0, this, n, n2);
    }

    public Message sendMessageSynchronously(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("sendMessageSynchronously", $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(int int int ), 0, this, n, n2, n3);
    }

    public Message sendMessageSynchronously(int n, int n2, int n3, Object object) {
        return InvokeDynamicSupport.bootstrap("sendMessageSynchronously", $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(int int int java.lang.Object ), 0, this, n, n2, n3, object);
    }

    public Message sendMessageSynchronously(int n, Object object) {
        return InvokeDynamicSupport.bootstrap("sendMessageSynchronously", $$robo$$com_android_internal_util_AsyncChannel$sendMessageSynchronously(int java.lang.Object ), 0, this, n, object);
    }

    private void replyHalfConnected(int n) {
        InvokeDynamicSupport.bootstrap("replyHalfConnected", $$robo$$com_android_internal_util_AsyncChannel$replyHalfConnected(int ), 0, this, n);
    }

    private void replyDisconnected(int n) {
        InvokeDynamicSupport.bootstrap("replyDisconnected", $$robo$$com_android_internal_util_AsyncChannel$replyDisconnected(int ), 0, this, n);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$com_android_internal_util_AsyncChannel$log(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(AsyncChannel.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AsyncChannel)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class DeathMonitor
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AsyncChannel this$0;

        private void $$robo$$com_android_internal_util_AsyncChannel_DeathMonitor$__constructor__(AsyncChannel asyncChannel) {
        }

        private final void $$robo$$com_android_internal_util_AsyncChannel_DeathMonitor$binderDied() {
            this.this$0.replyDisconnected(4);
        }

        private void __constructor__(AsyncChannel asyncChannel) {
            this.$$robo$$com_android_internal_util_AsyncChannel_DeathMonitor$__constructor__(asyncChannel);
        }

        DeathMonitor(AsyncChannel asyncChannel) {
            this.this$0 = asyncChannel;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_AsyncChannel_DeathMonitor$__constructor__(com.android.internal.util.AsyncChannel ), 0, this, asyncChannel);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$com_android_internal_util_AsyncChannel_DeathMonitor$binderDied(), 0, this);
        }

        public /* synthetic */ DeathMonitor() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeathMonitor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class AsyncChannelConnection
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AsyncChannel this$0;

        private void $$robo$$com_android_internal_util_AsyncChannel_AsyncChannelConnection$__constructor__(AsyncChannel asyncChannel) {
        }

        private final void $$robo$$com_android_internal_util_AsyncChannel_AsyncChannelConnection$onServiceConnected(ComponentName className, IBinder service) {
            this.this$0.mDstMessenger = new Messenger(service);
            this.this$0.replyHalfConnected(0);
        }

        private final void $$robo$$com_android_internal_util_AsyncChannel_AsyncChannelConnection$onServiceDisconnected(ComponentName className) {
            this.this$0.replyDisconnected(0);
        }

        private void __constructor__(AsyncChannel asyncChannel) {
            this.$$robo$$com_android_internal_util_AsyncChannel_AsyncChannelConnection$__constructor__(asyncChannel);
        }

        AsyncChannelConnection(AsyncChannel asyncChannel) {
            this.this$0 = asyncChannel;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_AsyncChannel_AsyncChannelConnection$__constructor__(com.android.internal.util.AsyncChannel ), 0, this, asyncChannel);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_util_AsyncChannel_AsyncChannelConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_util_AsyncChannel_AsyncChannelConnection$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        public /* synthetic */ AsyncChannelConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AsyncChannelConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SyncMessenger
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static Stack<SyncMessenger> sStack;
        private static int sCount;
        private HandlerThread mHandlerThread;
        private SyncHandler mHandler;
        private Messenger mMessenger;

        private void $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger$__constructor__() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final SyncMessenger $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger$obtain() {
            SyncMessenger sm;
            Stack<SyncMessenger> stack = sStack;
            synchronized (stack) {
                if (sStack.isEmpty()) {
                    sm = new SyncMessenger();
                    sm.mHandlerThread = new HandlerThread("SyncHandler-" + sCount++);
                    sm.mHandlerThread.start();
                    SyncMessenger syncMessenger = sm;
                    syncMessenger.getClass();
                    sm.mHandler = new SyncHandler(syncMessenger, sm.mHandlerThread.getLooper());
                    sm.mMessenger = new Messenger(sm.mHandler);
                } else {
                    sm = sStack.pop();
                }
            }
            return sm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger$recycle() {
            Stack<SyncMessenger> stack = sStack;
            synchronized (stack) {
                sStack.push(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Message $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger$sendMessageSynchronously(Messenger dstMessenger, Message msg) {
            SyncMessenger sm;
            block7: {
                sm = SyncMessenger.obtain();
                try {
                    if (dstMessenger != null && msg != null) {
                        msg.replyTo = sm.mMessenger;
                        Object object = sm.mHandler.mLockObject;
                        synchronized (object) {
                            dstMessenger.send(msg);
                            sm.mHandler.mLockObject.wait();
                            break block7;
                        }
                    }
                    sm.mHandler.mResultMsg = null;
                }
                catch (InterruptedException e) {
                    sm.mHandler.mResultMsg = null;
                }
                catch (RemoteException e) {
                    sm.mHandler.mResultMsg = null;
                }
            }
            Message resultMsg = sm.mHandler.mResultMsg;
            sm.recycle();
            return resultMsg;
        }

        static void __staticInitializer__() {
            sStack = new Stack();
            sCount = 0;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_util_AsyncChannel_SyncMessenger$__constructor__();
        }

        private SyncMessenger() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger$__constructor__(), 0, this);
        }

        private static SyncMessenger obtain() {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger$obtain(), 0);
        }

        private void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger$recycle(), 0, this);
        }

        private static Message sendMessageSynchronously(Messenger messenger, Message message) {
            return InvokeDynamicSupport.bootstrapStatic("sendMessageSynchronously", $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger$sendMessageSynchronously(android.os.Messenger android.os.Message ), 0, (Messenger)messenger, (Message)message);
        }

        static {
            RobolectricInternals.classInitializing(SyncMessenger.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SyncMessenger)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class SyncHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private Object mLockObject;
            private Message mResultMsg;
            /* synthetic */ SyncMessenger this$0;

            private void $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger_SyncHandler$__constructor__(SyncMessenger syncMessenger, Looper looper) {
                this.mLockObject = new Object();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger_SyncHandler$handleMessage(Message msg) {
                this.mResultMsg = Message.obtain();
                this.mResultMsg.copyFrom(msg);
                Object object = this.mLockObject;
                synchronized (object) {
                    this.mLockObject.notify();
                }
            }

            private /* synthetic */ void $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger_SyncHandler$__constructor__(SyncMessenger x0, Looper x1, 1 x2) {
            }

            private void __constructor__(SyncMessenger syncMessenger, Looper looper) {
                this.$$robo$$com_android_internal_util_AsyncChannel_SyncMessenger_SyncHandler$__constructor__(syncMessenger, looper);
            }

            private SyncHandler(SyncMessenger syncMessenger, Looper looper) {
                this.this$0 = syncMessenger;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger_SyncHandler$__constructor__(com.android.internal.util.AsyncChannel$SyncMessenger android.os.Looper ), 0, this, syncMessenger, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_util_AsyncChannel_SyncMessenger_SyncHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            private /* synthetic */ void __constructor__(SyncMessenger syncMessenger, Looper looper, 1 var3_3) {
                this.$$robo$$com_android_internal_util_AsyncChannel_SyncMessenger_SyncHandler$__constructor__(syncMessenger, looper, var3_3);
            }

            public /* synthetic */ SyncHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SyncHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

