/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.ImageUtils;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NotificationColorUtil
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NotificationColorUtil";
    private static Object sLock;
    private static NotificationColorUtil sInstance;
    private ImageUtils mImageUtils;
    private WeakHashMap<Bitmap, Pair<Boolean, Integer>> mGrayscaleBitmapCache;
    private int mGrayscaleIconMaxSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final NotificationColorUtil $$robo$$com_android_internal_util_NotificationColorUtil$getInstance(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new NotificationColorUtil(context);
            }
            return sInstance;
        }
    }

    private void $$robo$$com_android_internal_util_NotificationColorUtil$__constructor__(Context context) {
        this.mImageUtils = new ImageUtils();
        this.mGrayscaleBitmapCache = new WeakHashMap();
        this.mGrayscaleIconMaxSize = context.getResources().getDimensionPixelSize(0x1050005);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(Bitmap bitmap) {
        int generationId;
        boolean result;
        if (bitmap.getWidth() > this.mGrayscaleIconMaxSize || bitmap.getHeight() > this.mGrayscaleIconMaxSize) {
            return false;
        }
        Object object = sLock;
        synchronized (object) {
            Pair<Boolean, Integer> cached = this.mGrayscaleBitmapCache.get(bitmap);
            if (cached != null && ((Integer)cached.second).intValue() == bitmap.getGenerationId()) {
                return (Boolean)cached.first;
            }
        }
        Object object2 = this.mImageUtils;
        synchronized (object2) {
            result = this.mImageUtils.isGrayscale(bitmap);
            generationId = bitmap.getGenerationId();
        }
        object2 = sLock;
        synchronized (object2) {
            this.mGrayscaleBitmapCache.put(bitmap, Pair.create(result, generationId));
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(Drawable d) {
        if (d == null) {
            return false;
        }
        if (d instanceof BitmapDrawable) {
            BitmapDrawable bd = (BitmapDrawable)d;
            return bd.getBitmap() != null && this.isGrayscaleIcon(bd.getBitmap());
        }
        if (d instanceof AnimationDrawable) {
            AnimationDrawable ad = (AnimationDrawable)d;
            int count = ad.getNumberOfFrames();
            return count > 0 && this.isGrayscaleIcon(ad.getFrame(0));
        }
        return d instanceof VectorDrawable;
    }

    private final boolean $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(Context context, int drawableResId) {
        if (drawableResId != 0) {
            try {
                return this.isGrayscaleIcon(context.getDrawable(drawableResId));
            }
            catch (Resources.NotFoundException ex) {
                Log.e("NotificationColorUtil", "Drawable not found: " + drawableResId);
                return false;
            }
        }
        return false;
    }

    private final CharSequence $$robo$$com_android_internal_util_NotificationColorUtil$invertCharSequenceColors(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            Spanned ss = (Spanned)charSequence;
            Object[] spans = ss.getSpans(0, ss.length(), Object.class);
            SpannableStringBuilder builder = new SpannableStringBuilder(ss.toString());
            Object[] arr$ = spans;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Object span;
                Object resultSpan = span = arr$[i$];
                if (span instanceof TextAppearanceSpan) {
                    resultSpan = this.processTextAppearanceSpan((TextAppearanceSpan)span);
                }
                builder.setSpan(resultSpan, ss.getSpanStart(span), ss.getSpanEnd(span), ss.getSpanFlags(span));
            }
            return builder;
        }
        return charSequence;
    }

    private final TextAppearanceSpan $$robo$$com_android_internal_util_NotificationColorUtil$processTextAppearanceSpan(TextAppearanceSpan span) {
        ColorStateList colorStateList = span.getTextColor();
        if (colorStateList != null) {
            int[] colors = colorStateList.getColors();
            boolean changed = false;
            for (int i = 0; i < colors.length; ++i) {
                if (!ImageUtils.isGrayscale(colors[i])) continue;
                if (!changed) {
                    colors = Arrays.copyOf(colors, colors.length);
                }
                colors[i] = this.processColor(colors[i]);
                changed = true;
            }
            if (changed) {
                return new TextAppearanceSpan(span.getFamily(), span.getTextStyle(), span.getTextSize(), new ColorStateList(colorStateList.getStates(), colors), span.getLinkTextColor());
            }
        }
        return span;
    }

    private final int $$robo$$com_android_internal_util_NotificationColorUtil$processColor(int color2) {
        return Color.argb(Color.alpha(color2), 255 - Color.red(color2), 255 - Color.green(color2), 255 - Color.blue(color2));
    }

    static void __staticInitializer__() {
        sLock = new Object();
    }

    public static NotificationColorUtil getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_util_NotificationColorUtil$getInstance(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_util_NotificationColorUtil$__constructor__(context);
    }

    private NotificationColorUtil(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_NotificationColorUtil$__constructor__(android.content.Context ), 0, this, context);
    }

    public boolean isGrayscaleIcon(Bitmap bitmap) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGrayscaleIcon", $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public boolean isGrayscaleIcon(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGrayscaleIcon", $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public boolean isGrayscaleIcon(Context context, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGrayscaleIcon", $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(android.content.Context int ), 0, this, context, n);
    }

    public CharSequence invertCharSequenceColors(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("invertCharSequenceColors", $$robo$$com_android_internal_util_NotificationColorUtil$invertCharSequenceColors(java.lang.CharSequence ), 0, this, charSequence);
    }

    private TextAppearanceSpan processTextAppearanceSpan(TextAppearanceSpan textAppearanceSpan) {
        return InvokeDynamicSupport.bootstrap("processTextAppearanceSpan", $$robo$$com_android_internal_util_NotificationColorUtil$processTextAppearanceSpan(android.text.style.TextAppearanceSpan ), 0, this, textAppearanceSpan);
    }

    private int processColor(int n) {
        return (int)InvokeDynamicSupport.bootstrap("processColor", $$robo$$com_android_internal_util_NotificationColorUtil$processColor(int ), 0, this, n);
    }

    static {
        RobolectricInternals.classInitializing(NotificationColorUtil.class);
    }

    public /* synthetic */ NotificationColorUtil() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationColorUtil)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

