/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputContextCallback;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IInputConnectionWrapper
extends IInputContext.Stub
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "IInputConnectionWrapper";
    private static int DO_GET_TEXT_AFTER_CURSOR = 10;
    private static int DO_GET_TEXT_BEFORE_CURSOR = 20;
    private static int DO_GET_SELECTED_TEXT = 25;
    private static int DO_GET_CURSOR_CAPS_MODE = 30;
    private static int DO_GET_EXTRACTED_TEXT = 40;
    private static int DO_COMMIT_TEXT = 50;
    private static int DO_COMMIT_COMPLETION = 55;
    private static int DO_COMMIT_CORRECTION = 56;
    private static int DO_SET_SELECTION = 57;
    private static int DO_PERFORM_EDITOR_ACTION = 58;
    private static int DO_PERFORM_CONTEXT_MENU_ACTION = 59;
    private static int DO_SET_COMPOSING_TEXT = 60;
    private static int DO_SET_COMPOSING_REGION = 63;
    private static int DO_FINISH_COMPOSING_TEXT = 65;
    private static int DO_SEND_KEY_EVENT = 70;
    private static int DO_DELETE_SURROUNDING_TEXT = 80;
    private static int DO_BEGIN_BATCH_EDIT = 90;
    private static int DO_END_BATCH_EDIT = 95;
    private static int DO_REPORT_FULLSCREEN_MODE = 100;
    private static int DO_PERFORM_PRIVATE_COMMAND = 120;
    private static int DO_CLEAR_META_KEY_STATES = 130;
    private static int DO_REQUEST_UPDATE_CURSOR_ANCHOR_INFO = 140;
    private WeakReference<InputConnection> mInputConnection;
    private Looper mMainLooper;
    private Handler mH;

    private void $$robo$$com_android_internal_view_IInputConnectionWrapper$__constructor__(Looper mainLooper, InputConnection conn) {
        this.mInputConnection = new WeakReference<InputConnection>(conn);
        this.mMainLooper = mainLooper;
        this.mH = new MyHandler(this, this.mMainLooper);
    }

    private final boolean $$robo$$com_android_internal_view_IInputConnectionWrapper$isActive() {
        return true;
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$getTextAfterCursor(int length, int flags, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageIISC(10, length, flags, seq, callback));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$getTextBeforeCursor(int length, int flags, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageIISC(20, length, flags, seq, callback));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$getSelectedText(int flags, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageISC(25, flags, seq, callback));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$getCursorCapsMode(int reqModes, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageISC(30, reqModes, seq, callback));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$getExtractedText(ExtractedTextRequest request, int flags, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageIOSC(40, flags, request, seq, callback));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$commitText(CharSequence text, int newCursorPosition) {
        this.dispatchMessage(this.obtainMessageIO(50, newCursorPosition, text));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$commitCompletion(CompletionInfo text) {
        this.dispatchMessage(this.obtainMessageO(55, text));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$commitCorrection(CorrectionInfo info) {
        this.dispatchMessage(this.obtainMessageO(56, info));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$setSelection(int start, int end) {
        this.dispatchMessage(this.obtainMessageII(57, start, end));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$performEditorAction(int id2) {
        this.dispatchMessage(this.obtainMessageII(58, id2, 0));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$performContextMenuAction(int id2) {
        this.dispatchMessage(this.obtainMessageII(59, id2, 0));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$setComposingRegion(int start, int end) {
        this.dispatchMessage(this.obtainMessageII(63, start, end));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$setComposingText(CharSequence text, int newCursorPosition) {
        this.dispatchMessage(this.obtainMessageIO(60, newCursorPosition, text));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$finishComposingText() {
        this.dispatchMessage(this.obtainMessage(65));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$sendKeyEvent(KeyEvent event) {
        this.dispatchMessage(this.obtainMessageO(70, event));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$clearMetaKeyStates(int states) {
        this.dispatchMessage(this.obtainMessageII(130, states, 0));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$deleteSurroundingText(int leftLength, int rightLength) {
        this.dispatchMessage(this.obtainMessageII(80, leftLength, rightLength));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$beginBatchEdit() {
        this.dispatchMessage(this.obtainMessage(90));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$endBatchEdit() {
        this.dispatchMessage(this.obtainMessage(95));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$reportFullscreenMode(boolean enabled) {
        this.dispatchMessage(this.obtainMessageII(100, enabled ? 1 : 0, 0));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$performPrivateCommand(String action, Bundle data) {
        this.dispatchMessage(this.obtainMessageOO(120, action, data));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$requestUpdateCursorAnchorInfo(int cursorUpdateMode, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageISC(140, cursorUpdateMode, seq, callback));
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$dispatchMessage(Message msg) {
        if (Looper.myLooper() == this.mMainLooper) {
            this.executeMessage(msg);
            msg.recycle();
            return;
        }
        this.mH.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_view_IInputConnectionWrapper$executeMessage(Message msg) {
        switch (msg.what) {
            case 10: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w("IInputConnectionWrapper", "getTextAfterCursor on inactive InputConnection");
                        args.callback.setTextAfterCursor(null, args.seq);
                        return;
                    }
                    args.callback.setTextAfterCursor(ic.getTextAfterCursor(msg.arg1, msg.arg2), args.seq);
                }
                catch (RemoteException e) {
                    Log.w("IInputConnectionWrapper", "Got RemoteException calling setTextAfterCursor", e);
                }
                return;
            }
            case 20: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w("IInputConnectionWrapper", "getTextBeforeCursor on inactive InputConnection");
                        args.callback.setTextBeforeCursor(null, args.seq);
                        return;
                    }
                    args.callback.setTextBeforeCursor(ic.getTextBeforeCursor(msg.arg1, msg.arg2), args.seq);
                }
                catch (RemoteException e) {
                    Log.w("IInputConnectionWrapper", "Got RemoteException calling setTextBeforeCursor", e);
                }
                return;
            }
            case 25: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w("IInputConnectionWrapper", "getSelectedText on inactive InputConnection");
                        args.callback.setSelectedText(null, args.seq);
                        return;
                    }
                    args.callback.setSelectedText(ic.getSelectedText(msg.arg1), args.seq);
                }
                catch (RemoteException e) {
                    Log.w("IInputConnectionWrapper", "Got RemoteException calling setSelectedText", e);
                }
                return;
            }
            case 30: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w("IInputConnectionWrapper", "getCursorCapsMode on inactive InputConnection");
                        args.callback.setCursorCapsMode(0, args.seq);
                        return;
                    }
                    args.callback.setCursorCapsMode(ic.getCursorCapsMode(msg.arg1), args.seq);
                }
                catch (RemoteException e) {
                    Log.w("IInputConnectionWrapper", "Got RemoteException calling setCursorCapsMode", e);
                }
                return;
            }
            case 40: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w("IInputConnectionWrapper", "getExtractedText on inactive InputConnection");
                        args.callback.setExtractedText(null, args.seq);
                        return;
                    }
                    args.callback.setExtractedText(ic.getExtractedText((ExtractedTextRequest)args.arg1, msg.arg1), args.seq);
                }
                catch (RemoteException e) {
                    Log.w("IInputConnectionWrapper", "Got RemoteException calling setExtractedText", e);
                }
                return;
            }
            case 50: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "commitText on inactive InputConnection");
                    return;
                }
                ic.commitText((CharSequence)msg.obj, msg.arg1);
                return;
            }
            case 57: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "setSelection on inactive InputConnection");
                    return;
                }
                ic.setSelection(msg.arg1, msg.arg2);
                return;
            }
            case 58: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "performEditorAction on inactive InputConnection");
                    return;
                }
                ic.performEditorAction(msg.arg1);
                return;
            }
            case 59: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "performContextMenuAction on inactive InputConnection");
                    return;
                }
                ic.performContextMenuAction(msg.arg1);
                return;
            }
            case 55: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "commitCompletion on inactive InputConnection");
                    return;
                }
                ic.commitCompletion((CompletionInfo)msg.obj);
                return;
            }
            case 56: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "commitCorrection on inactive InputConnection");
                    return;
                }
                ic.commitCorrection((CorrectionInfo)msg.obj);
                return;
            }
            case 60: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "setComposingText on inactive InputConnection");
                    return;
                }
                ic.setComposingText((CharSequence)msg.obj, msg.arg1);
                return;
            }
            case 63: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "setComposingRegion on inactive InputConnection");
                    return;
                }
                ic.setComposingRegion(msg.arg1, msg.arg2);
                return;
            }
            case 65: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null) {
                    Log.w("IInputConnectionWrapper", "finishComposingText on inactive InputConnection");
                    return;
                }
                ic.finishComposingText();
                return;
            }
            case 70: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "sendKeyEvent on inactive InputConnection");
                    return;
                }
                ic.sendKeyEvent((KeyEvent)msg.obj);
                return;
            }
            case 130: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "clearMetaKeyStates on inactive InputConnection");
                    return;
                }
                ic.clearMetaKeyStates(msg.arg1);
                return;
            }
            case 80: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "deleteSurroundingText on inactive InputConnection");
                    return;
                }
                ic.deleteSurroundingText(msg.arg1, msg.arg2);
                return;
            }
            case 90: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "beginBatchEdit on inactive InputConnection");
                    return;
                }
                ic.beginBatchEdit();
                return;
            }
            case 95: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "endBatchEdit on inactive InputConnection");
                    return;
                }
                ic.endBatchEdit();
                return;
            }
            case 100: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "showStatusIcon on inactive InputConnection");
                    return;
                }
                ic.reportFullscreenMode(msg.arg1 == 1);
                return;
            }
            case 120: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w("IInputConnectionWrapper", "performPrivateCommand on inactive InputConnection");
                    return;
                }
                SomeArgs args = (SomeArgs)msg.obj;
                ic.performPrivateCommand((String)args.arg1, (Bundle)args.arg2);
                return;
            }
            case 140: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w("IInputConnectionWrapper", "requestCursorAnchorInfo on inactive InputConnection");
                        args.callback.setRequestUpdateCursorAnchorInfoResult(false, args.seq);
                        return;
                    }
                    args.callback.setRequestUpdateCursorAnchorInfoResult(ic.requestCursorUpdates(msg.arg1), args.seq);
                }
                catch (RemoteException e) {
                    Log.w("IInputConnectionWrapper", "Got RemoteException calling requestCursorAnchorInfo", e);
                }
                return;
            }
        }
        Log.w("IInputConnectionWrapper", "Unhandled message code: " + msg.what);
    }

    private final Message $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessage(int what) {
        return this.mH.obtainMessage(what);
    }

    private final Message $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageII(int what, int arg1, int arg2) {
        return this.mH.obtainMessage(what, arg1, arg2);
    }

    private final Message $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageO(int what, Object arg1) {
        return this.mH.obtainMessage(what, 0, 0, arg1);
    }

    private final Message $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageISC(int what, int arg1, int seq, IInputContextCallback callback) {
        SomeArgs args = new SomeArgs();
        args.callback = callback;
        args.seq = seq;
        return this.mH.obtainMessage(what, arg1, 0, args);
    }

    private final Message $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageIISC(int what, int arg1, int arg2, int seq, IInputContextCallback callback) {
        SomeArgs args = new SomeArgs();
        args.callback = callback;
        args.seq = seq;
        return this.mH.obtainMessage(what, arg1, arg2, args);
    }

    private final Message $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageOSC(int what, Object arg1, int seq, IInputContextCallback callback) {
        SomeArgs args = new SomeArgs();
        args.arg1 = arg1;
        args.callback = callback;
        args.seq = seq;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    private final Message $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageIOSC(int what, int arg1, Object arg2, int seq, IInputContextCallback callback) {
        SomeArgs args = new SomeArgs();
        args.arg1 = arg2;
        args.callback = callback;
        args.seq = seq;
        return this.mH.obtainMessage(what, arg1, 0, args);
    }

    private final Message $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageIO(int what, int arg1, Object arg2) {
        return this.mH.obtainMessage(what, arg1, 0, arg2);
    }

    private final Message $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageOO(int what, Object arg1, Object arg2) {
        SomeArgs args = new SomeArgs();
        args.arg1 = arg1;
        args.arg2 = arg2;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    private void __constructor__(Looper looper, InputConnection inputConnection) {
        this.$$robo$$com_android_internal_view_IInputConnectionWrapper$__constructor__(looper, inputConnection);
    }

    public IInputConnectionWrapper(Looper looper, InputConnection inputConnection) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_IInputConnectionWrapper$__constructor__(android.os.Looper android.view.inputmethod.InputConnection ), 0, this, looper, inputConnection);
    }

    public boolean isActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$com_android_internal_view_IInputConnectionWrapper$isActive(), 0, this);
    }

    @Override
    public void getTextAfterCursor(int n, int n2, int n3, IInputContextCallback iInputContextCallback) {
        InvokeDynamicSupport.bootstrap("getTextAfterCursor", $$robo$$com_android_internal_view_IInputConnectionWrapper$getTextAfterCursor(int int int com.android.internal.view.IInputContextCallback ), 0, this, n, n2, n3, iInputContextCallback);
    }

    @Override
    public void getTextBeforeCursor(int n, int n2, int n3, IInputContextCallback iInputContextCallback) {
        InvokeDynamicSupport.bootstrap("getTextBeforeCursor", $$robo$$com_android_internal_view_IInputConnectionWrapper$getTextBeforeCursor(int int int com.android.internal.view.IInputContextCallback ), 0, this, n, n2, n3, iInputContextCallback);
    }

    @Override
    public void getSelectedText(int n, int n2, IInputContextCallback iInputContextCallback) {
        InvokeDynamicSupport.bootstrap("getSelectedText", $$robo$$com_android_internal_view_IInputConnectionWrapper$getSelectedText(int int com.android.internal.view.IInputContextCallback ), 0, this, n, n2, iInputContextCallback);
    }

    @Override
    public void getCursorCapsMode(int n, int n2, IInputContextCallback iInputContextCallback) {
        InvokeDynamicSupport.bootstrap("getCursorCapsMode", $$robo$$com_android_internal_view_IInputConnectionWrapper$getCursorCapsMode(int int com.android.internal.view.IInputContextCallback ), 0, this, n, n2, iInputContextCallback);
    }

    @Override
    public void getExtractedText(ExtractedTextRequest extractedTextRequest, int n, int n2, IInputContextCallback iInputContextCallback) {
        InvokeDynamicSupport.bootstrap("getExtractedText", $$robo$$com_android_internal_view_IInputConnectionWrapper$getExtractedText(android.view.inputmethod.ExtractedTextRequest int int com.android.internal.view.IInputContextCallback ), 0, this, extractedTextRequest, n, n2, iInputContextCallback);
    }

    @Override
    public void commitText(CharSequence charSequence, int n) {
        InvokeDynamicSupport.bootstrap("commitText", $$robo$$com_android_internal_view_IInputConnectionWrapper$commitText(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    @Override
    public void commitCompletion(CompletionInfo completionInfo) {
        InvokeDynamicSupport.bootstrap("commitCompletion", $$robo$$com_android_internal_view_IInputConnectionWrapper$commitCompletion(android.view.inputmethod.CompletionInfo ), 0, this, completionInfo);
    }

    @Override
    public void commitCorrection(CorrectionInfo correctionInfo) {
        InvokeDynamicSupport.bootstrap("commitCorrection", $$robo$$com_android_internal_view_IInputConnectionWrapper$commitCorrection(android.view.inputmethod.CorrectionInfo ), 0, this, correctionInfo);
    }

    @Override
    public void setSelection(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSelection", $$robo$$com_android_internal_view_IInputConnectionWrapper$setSelection(int int ), 0, this, n, n2);
    }

    @Override
    public void performEditorAction(int n) {
        InvokeDynamicSupport.bootstrap("performEditorAction", $$robo$$com_android_internal_view_IInputConnectionWrapper$performEditorAction(int ), 0, this, n);
    }

    @Override
    public void performContextMenuAction(int n) {
        InvokeDynamicSupport.bootstrap("performContextMenuAction", $$robo$$com_android_internal_view_IInputConnectionWrapper$performContextMenuAction(int ), 0, this, n);
    }

    @Override
    public void setComposingRegion(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setComposingRegion", $$robo$$com_android_internal_view_IInputConnectionWrapper$setComposingRegion(int int ), 0, this, n, n2);
    }

    @Override
    public void setComposingText(CharSequence charSequence, int n) {
        InvokeDynamicSupport.bootstrap("setComposingText", $$robo$$com_android_internal_view_IInputConnectionWrapper$setComposingText(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    @Override
    public void finishComposingText() {
        InvokeDynamicSupport.bootstrap("finishComposingText", $$robo$$com_android_internal_view_IInputConnectionWrapper$finishComposingText(), 0, this);
    }

    @Override
    public void sendKeyEvent(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("sendKeyEvent", $$robo$$com_android_internal_view_IInputConnectionWrapper$sendKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public void clearMetaKeyStates(int n) {
        InvokeDynamicSupport.bootstrap("clearMetaKeyStates", $$robo$$com_android_internal_view_IInputConnectionWrapper$clearMetaKeyStates(int ), 0, this, n);
    }

    @Override
    public void deleteSurroundingText(int n, int n2) {
        InvokeDynamicSupport.bootstrap("deleteSurroundingText", $$robo$$com_android_internal_view_IInputConnectionWrapper$deleteSurroundingText(int int ), 0, this, n, n2);
    }

    @Override
    public void beginBatchEdit() {
        InvokeDynamicSupport.bootstrap("beginBatchEdit", $$robo$$com_android_internal_view_IInputConnectionWrapper$beginBatchEdit(), 0, this);
    }

    @Override
    public void endBatchEdit() {
        InvokeDynamicSupport.bootstrap("endBatchEdit", $$robo$$com_android_internal_view_IInputConnectionWrapper$endBatchEdit(), 0, this);
    }

    @Override
    public void reportFullscreenMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("reportFullscreenMode", $$robo$$com_android_internal_view_IInputConnectionWrapper$reportFullscreenMode(boolean ), 0, this, bl);
    }

    @Override
    public void performPrivateCommand(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("performPrivateCommand", $$robo$$com_android_internal_view_IInputConnectionWrapper$performPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    @Override
    public void requestUpdateCursorAnchorInfo(int n, int n2, IInputContextCallback iInputContextCallback) {
        InvokeDynamicSupport.bootstrap("requestUpdateCursorAnchorInfo", $$robo$$com_android_internal_view_IInputConnectionWrapper$requestUpdateCursorAnchorInfo(int int com.android.internal.view.IInputContextCallback ), 0, this, n, n2, iInputContextCallback);
    }

    void dispatchMessage(Message message) {
        InvokeDynamicSupport.bootstrap("dispatchMessage", $$robo$$com_android_internal_view_IInputConnectionWrapper$dispatchMessage(android.os.Message ), 0, this, message);
    }

    void executeMessage(Message message) {
        InvokeDynamicSupport.bootstrap("executeMessage", $$robo$$com_android_internal_view_IInputConnectionWrapper$executeMessage(android.os.Message ), 0, this, message);
    }

    Message obtainMessage(int n) {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessage(int ), 0, this, n);
    }

    Message obtainMessageII(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("obtainMessageII", $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageII(int int int ), 0, this, n, n2, n3);
    }

    Message obtainMessageO(int n, Object object) {
        return InvokeDynamicSupport.bootstrap("obtainMessageO", $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageO(int java.lang.Object ), 0, this, n, object);
    }

    Message obtainMessageISC(int n, int n2, int n3, IInputContextCallback iInputContextCallback) {
        return InvokeDynamicSupport.bootstrap("obtainMessageISC", $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageISC(int int int com.android.internal.view.IInputContextCallback ), 0, this, n, n2, n3, iInputContextCallback);
    }

    Message obtainMessageIISC(int n, int n2, int n3, int n4, IInputContextCallback iInputContextCallback) {
        return InvokeDynamicSupport.bootstrap("obtainMessageIISC", $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageIISC(int int int int com.android.internal.view.IInputContextCallback ), 0, this, n, n2, n3, n4, iInputContextCallback);
    }

    Message obtainMessageOSC(int n, Object object, int n2, IInputContextCallback iInputContextCallback) {
        return InvokeDynamicSupport.bootstrap("obtainMessageOSC", $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageOSC(int java.lang.Object int com.android.internal.view.IInputContextCallback ), 0, this, n, object, n2, iInputContextCallback);
    }

    Message obtainMessageIOSC(int n, int n2, Object object, int n3, IInputContextCallback iInputContextCallback) {
        return InvokeDynamicSupport.bootstrap("obtainMessageIOSC", $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageIOSC(int int java.lang.Object int com.android.internal.view.IInputContextCallback ), 0, this, n, n2, object, n3, iInputContextCallback);
    }

    Message obtainMessageIO(int n, int n2, Object object) {
        return InvokeDynamicSupport.bootstrap("obtainMessageIO", $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageIO(int int java.lang.Object ), 0, this, n, n2, object);
    }

    Message obtainMessageOO(int n, Object object, Object object2) {
        return InvokeDynamicSupport.bootstrap("obtainMessageOO", $$robo$$com_android_internal_view_IInputConnectionWrapper$obtainMessageOO(int java.lang.Object java.lang.Object ), 0, this, n, object, object2);
    }

    public /* synthetic */ IInputConnectionWrapper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IInputConnectionWrapper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ IInputConnectionWrapper this$0;

        private void $$robo$$com_android_internal_view_IInputConnectionWrapper_MyHandler$__constructor__(IInputConnectionWrapper iInputConnectionWrapper, Looper looper) {
        }

        private final void $$robo$$com_android_internal_view_IInputConnectionWrapper_MyHandler$handleMessage(Message msg) {
            this.this$0.executeMessage(msg);
        }

        private void __constructor__(IInputConnectionWrapper iInputConnectionWrapper, Looper looper) {
            this.$$robo$$com_android_internal_view_IInputConnectionWrapper_MyHandler$__constructor__(iInputConnectionWrapper, looper);
        }

        MyHandler(IInputConnectionWrapper iInputConnectionWrapper, Looper looper) {
            this.this$0 = iInputConnectionWrapper;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_IInputConnectionWrapper_MyHandler$__constructor__(com.android.internal.view.IInputConnectionWrapper android.os.Looper ), 0, this, iInputConnectionWrapper, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_view_IInputConnectionWrapper_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SomeArgs
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Object arg1;
        Object arg2;
        IInputContextCallback callback;
        int seq;

        private void $$robo$$com_android_internal_view_IInputConnectionWrapper_SomeArgs$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_view_IInputConnectionWrapper_SomeArgs$__constructor__();
        }

        SomeArgs() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_IInputConnectionWrapper_SomeArgs$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SomeArgs)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

