/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MenuItemImpl
implements MenuItem,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MenuItemImpl";
    private static int SHOW_AS_ACTION_MASK = 3;
    private int mId;
    private int mGroup;
    private int mCategoryOrder;
    private int mOrdering;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;
    private Intent mIntent;
    private char mShortcutNumericChar;
    private char mShortcutAlphabeticChar;
    private Drawable mIconDrawable;
    private int mIconResId;
    private MenuBuilder mMenu;
    private SubMenuBuilder mSubMenu;
    private Runnable mItemCallback;
    private MenuItem.OnMenuItemClickListener mClickListener;
    private int mFlags;
    private static int CHECKABLE = 1;
    private static int CHECKED = 2;
    private static int EXCLUSIVE = 4;
    private static int HIDDEN = 8;
    private static int ENABLED = 16;
    private static int IS_ACTION = 32;
    private int mShowAsAction;
    private View mActionView;
    private ActionProvider mActionProvider;
    private MenuItem.OnActionExpandListener mOnActionExpandListener;
    private boolean mIsActionViewExpanded;
    static int NO_ICON = 0;
    private ContextMenu.ContextMenuInfo mMenuInfo;
    private static String sLanguage;
    private static String sPrependShortcutLabel;
    private static String sEnterShortcutLabel;
    private static String sDeleteShortcutLabel;
    private static String sSpaceShortcutLabel;

    private void $$robo$$com_android_internal_view_menu_MenuItemImpl$__constructor__(MenuBuilder menu2, int group, int id2, int categoryOrder, int ordering, CharSequence title, int showAsAction) {
        this.mIconResId = 0;
        this.mFlags = 16;
        this.mShowAsAction = 0;
        this.mIsActionViewExpanded = false;
        String lang = menu2.getContext().getResources().getConfiguration().locale.toString();
        if (sPrependShortcutLabel == null || !lang.equals(sLanguage)) {
            sLanguage = lang;
            sPrependShortcutLabel = menu2.getContext().getResources().getString(17040428);
            sEnterShortcutLabel = menu2.getContext().getResources().getString(17040430);
            sDeleteShortcutLabel = menu2.getContext().getResources().getString(17040431);
            sSpaceShortcutLabel = menu2.getContext().getResources().getString(17040429);
        }
        this.mMenu = menu2;
        this.mId = id2;
        this.mGroup = group;
        this.mCategoryOrder = categoryOrder;
        this.mOrdering = ordering;
        this.mTitle = title;
        this.mShowAsAction = showAsAction;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$invoke() {
        if (this.mClickListener != null && this.mClickListener.onMenuItemClick(this)) {
            return true;
        }
        if (this.mMenu.dispatchMenuItemSelected(this.mMenu.getRootMenu(), this)) {
            return true;
        }
        if (this.mItemCallback != null) {
            this.mItemCallback.run();
            return true;
        }
        if (this.mIntent != null) {
            try {
                this.mMenu.getContext().startActivity(this.mIntent);
                return true;
            }
            catch (ActivityNotFoundException e) {
                Log.e("MenuItemImpl", "Can't find activity to handle intent; ignoring", e);
            }
        }
        return this.mActionProvider != null && this.mActionProvider.onPerformDefaultAction();
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isEnabled() {
        return (this.mFlags & 0x10) != 0;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setEnabled(boolean enabled) {
        this.mFlags = enabled ? (this.mFlags |= 0x10) : (this.mFlags &= 0xFFFFFFEF);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuItemImpl$getGroupId() {
        return this.mGroup;
    }

    @ViewDebug.CapturedViewProperty
    private final int $$robo$$com_android_internal_view_menu_MenuItemImpl$getItemId() {
        return this.mId;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuItemImpl$getOrder() {
        return this.mCategoryOrder;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuItemImpl$getOrdering() {
        return this.mOrdering;
    }

    private final Intent $$robo$$com_android_internal_view_menu_MenuItemImpl$getIntent() {
        return this.mIntent;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    private final Runnable $$robo$$com_android_internal_view_menu_MenuItemImpl$getCallback() {
        return this.mItemCallback;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setCallback(Runnable callback) {
        this.mItemCallback = callback;
        return this;
    }

    private final char $$robo$$com_android_internal_view_menu_MenuItemImpl$getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setAlphabeticShortcut(char alphaChar) {
        if (this.mShortcutAlphabeticChar == alphaChar) {
            return this;
        }
        this.mShortcutAlphabeticChar = Character.toLowerCase(alphaChar);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final char $$robo$$com_android_internal_view_menu_MenuItemImpl$getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setNumericShortcut(char numericChar) {
        if (this.mShortcutNumericChar == numericChar) {
            return this;
        }
        this.mShortcutNumericChar = numericChar;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setShortcut(char numericChar, char alphaChar) {
        this.mShortcutNumericChar = numericChar;
        this.mShortcutAlphabeticChar = Character.toLowerCase(alphaChar);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final char $$robo$$com_android_internal_view_menu_MenuItemImpl$getShortcut() {
        return this.mMenu.isQwertyMode() ? this.mShortcutAlphabeticChar : this.mShortcutNumericChar;
    }

    private final String $$robo$$com_android_internal_view_menu_MenuItemImpl$getShortcutLabel() {
        char shortcut = this.getShortcut();
        if (shortcut == '\u0000') {
            return "";
        }
        StringBuilder sb = new StringBuilder(sPrependShortcutLabel);
        switch (shortcut) {
            case '\n': {
                sb.append(sEnterShortcutLabel);
                break;
            }
            case '\b': {
                sb.append(sDeleteShortcutLabel);
                break;
            }
            case ' ': {
                sb.append(sSpaceShortcutLabel);
                break;
            }
            default: {
                sb.append(shortcut);
            }
        }
        return sb.toString();
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$shouldShowShortcut() {
        return this.mMenu.isShortcutsVisible() && this.getShortcut() != '\u0000';
    }

    private final SubMenu $$robo$$com_android_internal_view_menu_MenuItemImpl$getSubMenu() {
        return this.mSubMenu;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$hasSubMenu() {
        return this.mSubMenu != null;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setSubMenu(SubMenuBuilder subMenu) {
        this.mSubMenu = subMenu;
        subMenu.setHeaderTitle(this.getTitle());
    }

    @ViewDebug.CapturedViewProperty
    private final CharSequence $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitle() {
        return this.mTitle;
    }

    private final CharSequence $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitleForItemView(MenuView.ItemView itemView) {
        return itemView != null && itemView.prefersCondensedTitle() ? this.getTitleCondensed() : this.getTitle();
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitle(CharSequence title) {
        this.mTitle = title;
        this.mMenu.onItemsChanged(false);
        if (this.mSubMenu != null) {
            this.mSubMenu.setHeaderTitle(title);
        }
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitle(int title) {
        return this.setTitle(this.mMenu.getContext().getString(title));
    }

    private final CharSequence $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitleCondensed() {
        return this.mTitleCondensed != null ? this.mTitleCondensed : this.mTitle;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitleCondensed(CharSequence title) {
        this.mTitleCondensed = title;
        if (title == null) {
            title = this.mTitle;
        }
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final Drawable $$robo$$com_android_internal_view_menu_MenuItemImpl$getIcon() {
        if (this.mIconDrawable != null) {
            return this.mIconDrawable;
        }
        if (this.mIconResId != 0) {
            Drawable icon = this.mMenu.getContext().getDrawable(this.mIconResId);
            this.mIconResId = 0;
            this.mIconDrawable = icon;
            return icon;
        }
        return null;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setIcon(Drawable icon) {
        this.mIconResId = 0;
        this.mIconDrawable = icon;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setIcon(int iconResId) {
        this.mIconDrawable = null;
        this.mIconResId = iconResId;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isCheckable() {
        return (this.mFlags & 1) == 1;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setCheckable(boolean checkable) {
        int oldFlags = this.mFlags;
        this.mFlags = this.mFlags & 0xFFFFFFFE | (checkable ? 1 : 0);
        if (oldFlags != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
        return this;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setExclusiveCheckable(boolean exclusive) {
        this.mFlags = this.mFlags & 0xFFFFFFFB | (exclusive ? 4 : 0);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isExclusiveCheckable() {
        return (this.mFlags & 4) != 0;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isChecked() {
        return (this.mFlags & 2) == 2;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setChecked(boolean checked) {
        if ((this.mFlags & 4) != 0) {
            this.mMenu.setExclusiveItemChecked(this);
        } else {
            this.setCheckedInt(checked);
        }
        return this;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setCheckedInt(boolean checked) {
        int oldFlags = this.mFlags;
        this.mFlags = this.mFlags & 0xFFFFFFFD | (checked ? 2 : 0);
        if (oldFlags != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isVisible() {
        if (this.mActionProvider != null && this.mActionProvider.overridesItemVisibility()) {
            return (this.mFlags & 8) == 0 && this.mActionProvider.isVisible();
        }
        return (this.mFlags & 8) == 0;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$setVisibleInt(boolean shown) {
        int oldFlags = this.mFlags;
        this.mFlags = this.mFlags & 0xFFFFFFF7 | (shown ? 0 : 8);
        return oldFlags != this.mFlags;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setVisible(boolean shown) {
        if (this.setVisibleInt(shown)) {
            this.mMenu.onItemVisibleChanged(this);
        }
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener clickListener) {
        this.mClickListener = clickListener;
        return this;
    }

    private final String $$robo$$com_android_internal_view_menu_MenuItemImpl$toString() {
        return this.mTitle != null ? this.mTitle.toString() : null;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setMenuInfo(ContextMenu.ContextMenuInfo menuInfo) {
        this.mMenuInfo = menuInfo;
    }

    private final ContextMenu.ContextMenuInfo $$robo$$com_android_internal_view_menu_MenuItemImpl$getMenuInfo() {
        return this.mMenuInfo;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$actionFormatChanged() {
        this.mMenu.onItemActionRequestChanged(this);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$shouldShowIcon() {
        return this.mMenu.getOptionalIconsVisible();
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isActionButton() {
        return (this.mFlags & 0x20) == 32;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$requestsActionButton() {
        return (this.mShowAsAction & 1) == 1;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$requiresActionButton() {
        return (this.mShowAsAction & 2) == 2;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setIsActionButton(boolean isActionButton) {
        this.mFlags = isActionButton ? (this.mFlags |= 0x20) : (this.mFlags &= 0xFFFFFFDF);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$showsTextAsAction() {
        return (this.mShowAsAction & 4) == 4;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setShowAsAction(int actionEnum) {
        switch (actionEnum & 3) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("SHOW_AS_ACTION_ALWAYS, SHOW_AS_ACTION_IF_ROOM, and SHOW_AS_ACTION_NEVER are mutually exclusive.");
            }
        }
        this.mShowAsAction = actionEnum;
        this.mMenu.onItemActionRequestChanged(this);
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionView(View view) {
        this.mActionView = view;
        this.mActionProvider = null;
        if (view != null && view.getId() == -1 && this.mId > 0) {
            view.setId(this.mId);
        }
        this.mMenu.onItemActionRequestChanged(this);
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionView(int resId) {
        Context context = this.mMenu.getContext();
        LayoutInflater inflater = LayoutInflater.from(context);
        this.setActionView(inflater.inflate(resId, (ViewGroup)new LinearLayout(context), false));
        return this;
    }

    private final View $$robo$$com_android_internal_view_menu_MenuItemImpl$getActionView() {
        if (this.mActionView != null) {
            return this.mActionView;
        }
        if (this.mActionProvider != null) {
            this.mActionView = this.mActionProvider.onCreateActionView(this);
            return this.mActionView;
        }
        return null;
    }

    private final ActionProvider $$robo$$com_android_internal_view_menu_MenuItemImpl$getActionProvider() {
        return this.mActionProvider;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionProvider(ActionProvider actionProvider) {
        if (this.mActionProvider != null) {
            this.mActionProvider.setVisibilityListener(null);
        }
        this.mActionView = null;
        this.mActionProvider = actionProvider;
        this.mMenu.onItemsChanged(true);
        if (this.mActionProvider != null) {
            this.mActionProvider.setVisibilityListener(new ActionProvider.VisibilityListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ MenuItemImpl this$0;

                private void $$robo$$com_android_internal_view_menu_MenuItemImpl_1$__constructor__(MenuItemImpl menuItemImpl) {
                }

                private final void $$robo$$com_android_internal_view_menu_MenuItemImpl_1$onActionProviderVisibilityChanged(boolean isVisible) {
                    this.this$0.mMenu.onItemVisibleChanged(this.this$0);
                }

                private void __constructor__(MenuItemImpl menuItemImpl) {
                    this.$$robo$$com_android_internal_view_menu_MenuItemImpl_1$__constructor__(menuItemImpl);
                }
                {
                    this.this$0 = menuItemImpl;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuItemImpl_1$__constructor__(com.android.internal.view.menu.MenuItemImpl ), 0, this, menuItemImpl);
                }

                @Override
                public void onActionProviderVisibilityChanged(boolean bl) {
                    InvokeDynamicSupport.bootstrap("onActionProviderVisibilityChanged", $$robo$$com_android_internal_view_menu_MenuItemImpl_1$onActionProviderVisibilityChanged(boolean ), 0, this, bl);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setShowAsActionFlags(int actionEnum) {
        this.setShowAsAction(actionEnum);
        return this;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$expandActionView() {
        if (!this.hasCollapsibleActionView()) {
            return false;
        }
        if (this.mOnActionExpandListener == null || this.mOnActionExpandListener.onMenuItemActionExpand(this)) {
            return this.mMenu.expandItemActionView(this);
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$collapseActionView() {
        if ((this.mShowAsAction & 8) == 0) {
            return false;
        }
        if (this.mActionView == null) {
            return true;
        }
        if (this.mOnActionExpandListener == null || this.mOnActionExpandListener.onMenuItemActionCollapse(this)) {
            return this.mMenu.collapseItemActionView(this);
        }
        return false;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setOnActionExpandListener(MenuItem.OnActionExpandListener listener) {
        this.mOnActionExpandListener = listener;
        return this;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$hasCollapsibleActionView() {
        if ((this.mShowAsAction & 8) != 0) {
            if (this.mActionView == null && this.mActionProvider != null) {
                this.mActionView = this.mActionProvider.onCreateActionView(this);
            }
            return this.mActionView != null;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionViewExpanded(boolean isExpanded) {
        this.mIsActionViewExpanded = isExpanded;
        this.mMenu.onItemsChanged(false);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isActionViewExpanded() {
        return this.mIsActionViewExpanded;
    }

    private void __constructor__(MenuBuilder menuBuilder, int n, int n2, int n3, int n4, CharSequence charSequence, int n5) {
        this.$$robo$$com_android_internal_view_menu_MenuItemImpl$__constructor__(menuBuilder, n, n2, n3, n4, charSequence, n5);
    }

    MenuItemImpl(MenuBuilder menuBuilder, int n, int n2, int n3, int n4, CharSequence charSequence, int n5) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuItemImpl$__constructor__(com.android.internal.view.menu.MenuBuilder int int int int java.lang.CharSequence int ), 0, this, menuBuilder, n, n2, n3, n4, charSequence, n5);
    }

    public boolean invoke() {
        return (boolean)InvokeDynamicSupport.bootstrap("invoke", $$robo$$com_android_internal_view_menu_MenuItemImpl$invoke(), 0, this);
    }

    @Override
    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$com_android_internal_view_menu_MenuItemImpl$isEnabled(), 0, this);
    }

    @Override
    public MenuItem setEnabled(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$com_android_internal_view_menu_MenuItemImpl$setEnabled(boolean ), 0, this, bl);
    }

    @Override
    public int getGroupId() {
        return (int)InvokeDynamicSupport.bootstrap("getGroupId", $$robo$$com_android_internal_view_menu_MenuItemImpl$getGroupId(), 0, this);
    }

    @Override
    @ViewDebug.CapturedViewProperty
    public int getItemId() {
        return (int)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_view_menu_MenuItemImpl$getItemId(), 0, this);
    }

    @Override
    public int getOrder() {
        return (int)InvokeDynamicSupport.bootstrap("getOrder", $$robo$$com_android_internal_view_menu_MenuItemImpl$getOrder(), 0, this);
    }

    public int getOrdering() {
        return (int)InvokeDynamicSupport.bootstrap("getOrdering", $$robo$$com_android_internal_view_menu_MenuItemImpl$getOrdering(), 0, this);
    }

    @Override
    public Intent getIntent() {
        return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$com_android_internal_view_menu_MenuItemImpl$getIntent(), 0, this);
    }

    @Override
    public MenuItem setIntent(Intent intent) {
        return InvokeDynamicSupport.bootstrap("setIntent", $$robo$$com_android_internal_view_menu_MenuItemImpl$setIntent(android.content.Intent ), 0, this, intent);
    }

    Runnable getCallback() {
        return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$com_android_internal_view_menu_MenuItemImpl$getCallback(), 0, this);
    }

    public MenuItem setCallback(Runnable runnable) {
        return InvokeDynamicSupport.bootstrap("setCallback", $$robo$$com_android_internal_view_menu_MenuItemImpl$setCallback(java.lang.Runnable ), 0, this, runnable);
    }

    @Override
    public char getAlphabeticShortcut() {
        return (char)InvokeDynamicSupport.bootstrap("getAlphabeticShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$getAlphabeticShortcut(), 0, this);
    }

    @Override
    public MenuItem setAlphabeticShortcut(char c) {
        return InvokeDynamicSupport.bootstrap("setAlphabeticShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$setAlphabeticShortcut(char ), 0, this, c);
    }

    @Override
    public char getNumericShortcut() {
        return (char)InvokeDynamicSupport.bootstrap("getNumericShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$getNumericShortcut(), 0, this);
    }

    @Override
    public MenuItem setNumericShortcut(char c) {
        return InvokeDynamicSupport.bootstrap("setNumericShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$setNumericShortcut(char ), 0, this, c);
    }

    @Override
    public MenuItem setShortcut(char c, char c2) {
        return InvokeDynamicSupport.bootstrap("setShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$setShortcut(char char ), 0, this, c, c2);
    }

    char getShortcut() {
        return (char)InvokeDynamicSupport.bootstrap("getShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$getShortcut(), 0, this);
    }

    String getShortcutLabel() {
        return InvokeDynamicSupport.bootstrap("getShortcutLabel", $$robo$$com_android_internal_view_menu_MenuItemImpl$getShortcutLabel(), 0, this);
    }

    boolean shouldShowShortcut() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldShowShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$shouldShowShortcut(), 0, this);
    }

    @Override
    public SubMenu getSubMenu() {
        return InvokeDynamicSupport.bootstrap("getSubMenu", $$robo$$com_android_internal_view_menu_MenuItemImpl$getSubMenu(), 0, this);
    }

    @Override
    public boolean hasSubMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSubMenu", $$robo$$com_android_internal_view_menu_MenuItemImpl$hasSubMenu(), 0, this);
    }

    void setSubMenu(SubMenuBuilder subMenuBuilder) {
        InvokeDynamicSupport.bootstrap("setSubMenu", $$robo$$com_android_internal_view_menu_MenuItemImpl$setSubMenu(com.android.internal.view.menu.SubMenuBuilder ), 0, this, subMenuBuilder);
    }

    @Override
    @ViewDebug.CapturedViewProperty
    public CharSequence getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitle(), 0, this);
    }

    CharSequence getTitleForItemView(MenuView.ItemView itemView) {
        return InvokeDynamicSupport.bootstrap("getTitleForItemView", $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitleForItemView(com.android.internal.view.menu.MenuView$ItemView ), 0, this, itemView);
    }

    @Override
    public MenuItem setTitle(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public MenuItem setTitle(int n) {
        return InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitle(int ), 0, this, n);
    }

    @Override
    public CharSequence getTitleCondensed() {
        return InvokeDynamicSupport.bootstrap("getTitleCondensed", $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitleCondensed(), 0, this);
    }

    @Override
    public MenuItem setTitleCondensed(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("setTitleCondensed", $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitleCondensed(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public Drawable getIcon() {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$com_android_internal_view_menu_MenuItemImpl$getIcon(), 0, this);
    }

    @Override
    public MenuItem setIcon(Drawable drawable2) {
        return InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_view_menu_MenuItemImpl$setIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public MenuItem setIcon(int n) {
        return InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_view_menu_MenuItemImpl$setIcon(int ), 0, this, n);
    }

    @Override
    public boolean isCheckable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCheckable", $$robo$$com_android_internal_view_menu_MenuItemImpl$isCheckable(), 0, this);
    }

    @Override
    public MenuItem setCheckable(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setCheckable", $$robo$$com_android_internal_view_menu_MenuItemImpl$setCheckable(boolean ), 0, this, bl);
    }

    public void setExclusiveCheckable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setExclusiveCheckable", $$robo$$com_android_internal_view_menu_MenuItemImpl$setExclusiveCheckable(boolean ), 0, this, bl);
    }

    public boolean isExclusiveCheckable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExclusiveCheckable", $$robo$$com_android_internal_view_menu_MenuItemImpl$isExclusiveCheckable(), 0, this);
    }

    @Override
    public boolean isChecked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isChecked", $$robo$$com_android_internal_view_menu_MenuItemImpl$isChecked(), 0, this);
    }

    @Override
    public MenuItem setChecked(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setChecked", $$robo$$com_android_internal_view_menu_MenuItemImpl$setChecked(boolean ), 0, this, bl);
    }

    void setCheckedInt(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCheckedInt", $$robo$$com_android_internal_view_menu_MenuItemImpl$setCheckedInt(boolean ), 0, this, bl);
    }

    @Override
    public boolean isVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$com_android_internal_view_menu_MenuItemImpl$isVisible(), 0, this);
    }

    boolean setVisibleInt(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisibleInt", $$robo$$com_android_internal_view_menu_MenuItemImpl$setVisibleInt(boolean ), 0, this, bl);
    }

    @Override
    public MenuItem setVisible(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setVisible", $$robo$$com_android_internal_view_menu_MenuItemImpl$setVisible(boolean ), 0, this, bl);
    }

    @Override
    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        return InvokeDynamicSupport.bootstrap("setOnMenuItemClickListener", $$robo$$com_android_internal_view_menu_MenuItemImpl$setOnMenuItemClickListener(android.view.MenuItem$OnMenuItemClickListener ), 0, this, onMenuItemClickListener);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_view_menu_MenuItemImpl$toString(), 0, this);
    }

    void setMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        InvokeDynamicSupport.bootstrap("setMenuInfo", $$robo$$com_android_internal_view_menu_MenuItemImpl$setMenuInfo(android.view.ContextMenu$ContextMenuInfo ), 0, this, contextMenuInfo);
    }

    @Override
    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return InvokeDynamicSupport.bootstrap("getMenuInfo", $$robo$$com_android_internal_view_menu_MenuItemImpl$getMenuInfo(), 0, this);
    }

    public void actionFormatChanged() {
        InvokeDynamicSupport.bootstrap("actionFormatChanged", $$robo$$com_android_internal_view_menu_MenuItemImpl$actionFormatChanged(), 0, this);
    }

    public boolean shouldShowIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldShowIcon", $$robo$$com_android_internal_view_menu_MenuItemImpl$shouldShowIcon(), 0, this);
    }

    public boolean isActionButton() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActionButton", $$robo$$com_android_internal_view_menu_MenuItemImpl$isActionButton(), 0, this);
    }

    public boolean requestsActionButton() {
        return (boolean)InvokeDynamicSupport.bootstrap("requestsActionButton", $$robo$$com_android_internal_view_menu_MenuItemImpl$requestsActionButton(), 0, this);
    }

    public boolean requiresActionButton() {
        return (boolean)InvokeDynamicSupport.bootstrap("requiresActionButton", $$robo$$com_android_internal_view_menu_MenuItemImpl$requiresActionButton(), 0, this);
    }

    public void setIsActionButton(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsActionButton", $$robo$$com_android_internal_view_menu_MenuItemImpl$setIsActionButton(boolean ), 0, this, bl);
    }

    public boolean showsTextAsAction() {
        return (boolean)InvokeDynamicSupport.bootstrap("showsTextAsAction", $$robo$$com_android_internal_view_menu_MenuItemImpl$showsTextAsAction(), 0, this);
    }

    @Override
    public void setShowAsAction(int n) {
        InvokeDynamicSupport.bootstrap("setShowAsAction", $$robo$$com_android_internal_view_menu_MenuItemImpl$setShowAsAction(int ), 0, this, n);
    }

    @Override
    public MenuItem setActionView(View view) {
        return InvokeDynamicSupport.bootstrap("setActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionView(android.view.View ), 0, this, view);
    }

    @Override
    public MenuItem setActionView(int n) {
        return InvokeDynamicSupport.bootstrap("setActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionView(int ), 0, this, n);
    }

    @Override
    public View getActionView() {
        return InvokeDynamicSupport.bootstrap("getActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$getActionView(), 0, this);
    }

    @Override
    public ActionProvider getActionProvider() {
        return InvokeDynamicSupport.bootstrap("getActionProvider", $$robo$$com_android_internal_view_menu_MenuItemImpl$getActionProvider(), 0, this);
    }

    @Override
    public MenuItem setActionProvider(ActionProvider actionProvider) {
        return InvokeDynamicSupport.bootstrap("setActionProvider", $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionProvider(android.view.ActionProvider ), 0, this, actionProvider);
    }

    @Override
    public MenuItem setShowAsActionFlags(int n) {
        return InvokeDynamicSupport.bootstrap("setShowAsActionFlags", $$robo$$com_android_internal_view_menu_MenuItemImpl$setShowAsActionFlags(int ), 0, this, n);
    }

    @Override
    public boolean expandActionView() {
        return (boolean)InvokeDynamicSupport.bootstrap("expandActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$expandActionView(), 0, this);
    }

    @Override
    public boolean collapseActionView() {
        return (boolean)InvokeDynamicSupport.bootstrap("collapseActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$collapseActionView(), 0, this);
    }

    @Override
    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        return InvokeDynamicSupport.bootstrap("setOnActionExpandListener", $$robo$$com_android_internal_view_menu_MenuItemImpl$setOnActionExpandListener(android.view.MenuItem$OnActionExpandListener ), 0, this, onActionExpandListener);
    }

    public boolean hasCollapsibleActionView() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCollapsibleActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$hasCollapsibleActionView(), 0, this);
    }

    public void setActionViewExpanded(boolean bl) {
        InvokeDynamicSupport.bootstrap("setActionViewExpanded", $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionViewExpanded(boolean ), 0, this, bl);
    }

    @Override
    public boolean isActionViewExpanded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActionViewExpanded", $$robo$$com_android_internal_view_menu_MenuItemImpl$isActionViewExpanded(), 0, this);
    }

    public /* synthetic */ MenuItemImpl() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuItemImpl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

