/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcelable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import com.android.internal.view.menu.ListMenuItemView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MenuPopupHelper
implements AdapterView.OnItemClickListener,
View.OnKeyListener,
ViewTreeObserver.OnGlobalLayoutListener,
PopupWindow.OnDismissListener,
View.OnAttachStateChangeListener,
MenuPresenter,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MenuPopupHelper";
    static int ITEM_LAYOUT = 17367180;
    private Context mContext;
    private LayoutInflater mInflater;
    private MenuBuilder mMenu;
    private MenuAdapter mAdapter;
    private boolean mOverflowOnly;
    private int mPopupMaxWidth;
    private int mPopupStyleAttr;
    private View mAnchorView;
    private ListPopupWindow mPopup;
    private ViewTreeObserver mTreeObserver;
    private MenuPresenter.Callback mPresenterCallback;
    boolean mForceShowIcon;
    private ViewGroup mMeasureParent;
    private boolean mHasContentWidth;
    private int mContentWidth;
    private int mDropDownGravity;

    private void $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(Context context, MenuBuilder menu2) {
    }

    private void $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(Context context, MenuBuilder menu2, View anchorView) {
    }

    private void $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(Context context, MenuBuilder menu2, View anchorView, boolean overflowOnly, int popupStyleAttr) {
        this.mDropDownGravity = 0;
        this.mContext = context;
        this.mInflater = LayoutInflater.from(context);
        this.mMenu = menu2;
        this.mAdapter = new MenuAdapter(this, this.mMenu);
        this.mOverflowOnly = overflowOnly;
        this.mPopupStyleAttr = popupStyleAttr;
        Resources res = context.getResources();
        this.mPopupMaxWidth = Math.max(res.getDisplayMetrics().widthPixels / 2, res.getDimensionPixelSize(17104905));
        this.mAnchorView = anchorView;
        menu2.addMenuPresenter(this, context);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$setAnchorView(View anchor) {
        this.mAnchorView = anchor;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$setForceShowIcon(boolean forceShow) {
        this.mForceShowIcon = forceShow;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$setGravity(int gravity) {
        this.mDropDownGravity = gravity;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$show() {
        if (!this.tryShow()) {
            throw new IllegalStateException("MenuPopupHelper cannot be used without an anchor");
        }
    }

    private final ListPopupWindow $$robo$$com_android_internal_view_menu_MenuPopupHelper$getPopup() {
        return this.mPopup;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuPopupHelper$tryShow() {
        this.mPopup = new ListPopupWindow(this.mContext, null, this.mPopupStyleAttr);
        this.mPopup.setOnDismissListener(this);
        this.mPopup.setOnItemClickListener(this);
        this.mPopup.setAdapter(this.mAdapter);
        this.mPopup.setModal(true);
        View anchor = this.mAnchorView;
        if (anchor != null) {
            boolean addGlobalListener = this.mTreeObserver == null;
            this.mTreeObserver = anchor.getViewTreeObserver();
            if (addGlobalListener) {
                this.mTreeObserver.addOnGlobalLayoutListener(this);
            }
        } else {
            return false;
        }
        anchor.addOnAttachStateChangeListener(this);
        this.mPopup.setAnchorView(anchor);
        this.mPopup.setDropDownGravity(this.mDropDownGravity);
        if (!this.mHasContentWidth) {
            this.mContentWidth = this.measureContentWidth();
            this.mHasContentWidth = true;
        }
        this.mPopup.setContentWidth(this.mContentWidth);
        this.mPopup.setInputMethodMode(2);
        this.mPopup.show();
        this.mPopup.getListView().setOnKeyListener(this);
        return true;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$dismiss() {
        if (this.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$onDismiss() {
        this.mPopup = null;
        this.mMenu.close();
        if (this.mTreeObserver != null) {
            if (!this.mTreeObserver.isAlive()) {
                this.mTreeObserver = this.mAnchorView.getViewTreeObserver();
            }
            this.mTreeObserver.removeGlobalOnLayoutListener(this);
            this.mTreeObserver = null;
        }
        this.mAnchorView.removeOnAttachStateChangeListener(this);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuPopupHelper$isShowing() {
        return this.mPopup != null && this.mPopup.isShowing();
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        MenuAdapter adapter = this.mAdapter;
        adapter.mAdapterMenu.performItemAction((MenuItem)adapter.getItem(position), 0);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuPopupHelper$onKey(View v, int keyCode, KeyEvent event) {
        if (event.getAction() == 1 && keyCode == 82) {
            this.dismiss();
            return true;
        }
        return false;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuPopupHelper$measureContentWidth() {
        int maxWidth = 0;
        View itemView = null;
        int itemType = 0;
        MenuAdapter adapter = this.mAdapter;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if (this.mMeasureParent == null) {
                this.mMeasureParent = new FrameLayout(this.mContext);
            }
            itemView = adapter.getView(i, itemView, this.mMeasureParent);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            int itemWidth = itemView.getMeasuredWidth();
            if (itemWidth >= this.mPopupMaxWidth) {
                return this.mPopupMaxWidth;
            }
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        return maxWidth;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$onGlobalLayout() {
        if (this.isShowing()) {
            View anchor = this.mAnchorView;
            if (anchor == null || !anchor.isShown()) {
                this.dismiss();
            } else if (this.isShowing()) {
                this.mPopup.show();
            }
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$onViewAttachedToWindow(View v) {
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$onViewDetachedFromWindow(View v) {
        if (this.mTreeObserver != null) {
            if (!this.mTreeObserver.isAlive()) {
                this.mTreeObserver = v.getViewTreeObserver();
            }
            this.mTreeObserver.removeGlobalOnLayoutListener(this);
        }
        v.removeOnAttachStateChangeListener(this);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$initForMenu(Context context, MenuBuilder menu2) {
    }

    private final MenuView $$robo$$com_android_internal_view_menu_MenuPopupHelper$getMenuView(ViewGroup root) {
        throw new UnsupportedOperationException("MenuPopupHelpers manage their own views");
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$updateMenuView(boolean cleared) {
        this.mHasContentWidth = false;
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$setCallback(MenuPresenter.Callback cb) {
        this.mPresenterCallback = cb;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuPopupHelper$onSubMenuSelected(SubMenuBuilder subMenu) {
        if (subMenu.hasVisibleItems()) {
            MenuPopupHelper subPopup = new MenuPopupHelper(this.mContext, subMenu, this.mAnchorView);
            subPopup.setCallback(this.mPresenterCallback);
            boolean preserveIconSpacing = false;
            int count = subMenu.size();
            for (int i = 0; i < count; ++i) {
                MenuItem childItem = subMenu.getItem(i);
                if (!childItem.isVisible() || childItem.getIcon() == null) continue;
                preserveIconSpacing = true;
                break;
            }
            subPopup.setForceShowIcon(preserveIconSpacing);
            if (subPopup.tryShow()) {
                if (this.mPresenterCallback != null) {
                    this.mPresenterCallback.onOpenSubMenu(subMenu);
                }
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        if (menu2 != this.mMenu) {
            return;
        }
        this.dismiss();
        if (this.mPresenterCallback != null) {
            this.mPresenterCallback.onCloseMenu(menu2, allMenusAreClosing);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuPopupHelper$flagActionItems() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuPopupHelper$expandItemActionView(MenuBuilder menu2, MenuItemImpl item) {
        return false;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuPopupHelper$collapseItemActionView(MenuBuilder menu2, MenuItemImpl item) {
        return false;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuPopupHelper$getId() {
        return 0;
    }

    private final Parcelable $$robo$$com_android_internal_view_menu_MenuPopupHelper$onSaveInstanceState() {
        return null;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$onRestoreInstanceState(Parcelable state) {
    }

    private void __constructor__(Context context, MenuBuilder menuBuilder) {
        this.$$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(context, menuBuilder);
    }

    public MenuPopupHelper(Context context, MenuBuilder menuBuilder) {
        this(context, menuBuilder, null, false, 0x1010300);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(android.content.Context com.android.internal.view.menu.MenuBuilder ), 0, this, context, menuBuilder);
    }

    private void __constructor__(Context context, MenuBuilder menuBuilder, View view) {
        this.$$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(context, menuBuilder, view);
    }

    public MenuPopupHelper(Context context, MenuBuilder menuBuilder, View view) {
        this(context, menuBuilder, view, false, 0x1010300);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(android.content.Context com.android.internal.view.menu.MenuBuilder android.view.View ), 0, this, context, menuBuilder, view);
    }

    private void __constructor__(Context context, MenuBuilder menuBuilder, View view, boolean bl, int n) {
        this.$$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(context, menuBuilder, view, bl, n);
    }

    public MenuPopupHelper(Context context, MenuBuilder menuBuilder, View view, boolean bl, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(android.content.Context com.android.internal.view.menu.MenuBuilder android.view.View boolean int ), 0, this, context, menuBuilder, view, bl, n);
    }

    public void setAnchorView(View view) {
        InvokeDynamicSupport.bootstrap("setAnchorView", $$robo$$com_android_internal_view_menu_MenuPopupHelper$setAnchorView(android.view.View ), 0, this, view);
    }

    public void setForceShowIcon(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceShowIcon", $$robo$$com_android_internal_view_menu_MenuPopupHelper$setForceShowIcon(boolean ), 0, this, bl);
    }

    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$com_android_internal_view_menu_MenuPopupHelper$setGravity(int ), 0, this, n);
    }

    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$com_android_internal_view_menu_MenuPopupHelper$show(), 0, this);
    }

    public ListPopupWindow getPopup() {
        return InvokeDynamicSupport.bootstrap("getPopup", $$robo$$com_android_internal_view_menu_MenuPopupHelper$getPopup(), 0, this);
    }

    public boolean tryShow() {
        return (boolean)InvokeDynamicSupport.bootstrap("tryShow", $$robo$$com_android_internal_view_menu_MenuPopupHelper$tryShow(), 0, this);
    }

    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_view_menu_MenuPopupHelper$dismiss(), 0, this);
    }

    @Override
    public void onDismiss() {
        InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onDismiss(), 0, this);
    }

    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$com_android_internal_view_menu_MenuPopupHelper$isShowing(), 0, this);
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
    }

    @Override
    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKey", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onKey(android.view.View int android.view.KeyEvent ), 0, this, view, n, keyEvent);
    }

    private int measureContentWidth() {
        return (int)InvokeDynamicSupport.bootstrap("measureContentWidth", $$robo$$com_android_internal_view_menu_MenuPopupHelper$measureContentWidth(), 0, this);
    }

    @Override
    public void onGlobalLayout() {
        InvokeDynamicSupport.bootstrap("onGlobalLayout", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onGlobalLayout(), 0, this);
    }

    @Override
    public void onViewAttachedToWindow(View view) {
        InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onViewAttachedToWindow(android.view.View ), 0, this, view);
    }

    @Override
    public void onViewDetachedFromWindow(View view) {
        InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onViewDetachedFromWindow(android.view.View ), 0, this, view);
    }

    @Override
    public void initForMenu(Context context, MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("initForMenu", $$robo$$com_android_internal_view_menu_MenuPopupHelper$initForMenu(android.content.Context com.android.internal.view.menu.MenuBuilder ), 0, this, context, menuBuilder);
    }

    @Override
    public MenuView getMenuView(ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getMenuView", $$robo$$com_android_internal_view_menu_MenuPopupHelper$getMenuView(android.view.ViewGroup ), 0, this, viewGroup);
    }

    @Override
    public void updateMenuView(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateMenuView", $$robo$$com_android_internal_view_menu_MenuPopupHelper$updateMenuView(boolean ), 0, this, bl);
    }

    @Override
    public void setCallback(MenuPresenter.Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$com_android_internal_view_menu_MenuPopupHelper$setCallback(com.android.internal.view.menu.MenuPresenter$Callback ), 0, this, callback);
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSubMenuSelected", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onSubMenuSelected(com.android.internal.view.menu.SubMenuBuilder ), 0, this, subMenuBuilder);
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), 0, this, menuBuilder, bl);
    }

    @Override
    public boolean flagActionItems() {
        return (boolean)InvokeDynamicSupport.bootstrap("flagActionItems", $$robo$$com_android_internal_view_menu_MenuPopupHelper$flagActionItems(), 0, this);
    }

    @Override
    public boolean expandItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("expandItemActionView", $$robo$$com_android_internal_view_menu_MenuPopupHelper$expandItemActionView(com.android.internal.view.menu.MenuBuilder com.android.internal.view.menu.MenuItemImpl ), 0, this, menuBuilder, menuItemImpl);
    }

    @Override
    public boolean collapseItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("collapseItemActionView", $$robo$$com_android_internal_view_menu_MenuPopupHelper$collapseItemActionView(com.android.internal.view.menu.MenuBuilder com.android.internal.view.menu.MenuItemImpl ), 0, this, menuBuilder, menuItemImpl);
    }

    @Override
    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$com_android_internal_view_menu_MenuPopupHelper$getId(), 0, this);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onSaveInstanceState(), 0, this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    public /* synthetic */ MenuPopupHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuPopupHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class MenuAdapter
    extends BaseAdapter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MenuBuilder mAdapterMenu;
        private int mExpandedIndex;
        /* synthetic */ MenuPopupHelper this$0;

        private void $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$__constructor__(MenuPopupHelper menuPopupHelper, MenuBuilder menu2) {
            this.mExpandedIndex = -1;
            this.mAdapterMenu = menu2;
            this.findExpandedIndex();
        }

        private final int $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$getCount() {
            ArrayList<MenuItemImpl> items;
            ArrayList<MenuItemImpl> arrayList = items = this.this$0.mOverflowOnly ? this.mAdapterMenu.getNonActionItems() : this.mAdapterMenu.getVisibleItems();
            if (this.mExpandedIndex < 0) {
                return items.size();
            }
            return items.size() - 1;
        }

        private final MenuItemImpl $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$getItem(int position) {
            ArrayList<MenuItemImpl> items;
            ArrayList<MenuItemImpl> arrayList = items = this.this$0.mOverflowOnly ? this.mAdapterMenu.getNonActionItems() : this.mAdapterMenu.getVisibleItems();
            if (this.mExpandedIndex >= 0 && position >= this.mExpandedIndex) {
                ++position;
            }
            return items.get(position);
        }

        private final long $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$getItemId(int position) {
            return position;
        }

        private final View $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.this$0.mInflater.inflate(17367180, parent, false);
            }
            MenuView.ItemView itemView = (MenuView.ItemView)((Object)convertView);
            if (this.this$0.mForceShowIcon) {
                ((ListMenuItemView)convertView).setForceShowIcon(true);
            }
            itemView.initialize((MenuItemImpl)this.getItem(position), 0);
            return convertView;
        }

        private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$findExpandedIndex() {
            MenuItemImpl expandedItem = this.this$0.mMenu.getExpandedItem();
            if (expandedItem != null) {
                ArrayList<MenuItemImpl> items = this.this$0.mMenu.getNonActionItems();
                int count = items.size();
                for (int i = 0; i < count; ++i) {
                    MenuItemImpl item = items.get(i);
                    if (item != expandedItem) continue;
                    this.mExpandedIndex = i;
                    return;
                }
            }
            this.mExpandedIndex = -1;
        }

        private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$notifyDataSetChanged() {
            this.findExpandedIndex();
            super.notifyDataSetChanged();
        }

        private void __constructor__(MenuPopupHelper menuPopupHelper, MenuBuilder menuBuilder) {
            this.$$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$__constructor__(menuPopupHelper, menuBuilder);
        }

        public MenuAdapter(MenuPopupHelper menuPopupHelper, MenuBuilder menuBuilder) {
            this.this$0 = menuPopupHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$__constructor__(com.android.internal.view.menu.MenuPopupHelper com.android.internal.view.menu.MenuBuilder ), 0, this, menuPopupHelper, menuBuilder);
        }

        @Override
        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$getCount(), 0, this);
        }

        @Override
        public MenuItemImpl getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$getItem(int ), 0, this, n);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$getItemId(int ), 0, this, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        void findExpandedIndex() {
            InvokeDynamicSupport.bootstrap("findExpandedIndex", $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$findExpandedIndex(), 0, this);
        }

        @Override
        public void notifyDataSetChanged() {
            InvokeDynamicSupport.bootstrap("notifyDataSetChanged", $$robo$$com_android_internal_view_menu_MenuPopupHelper_MenuAdapter$notifyDataSetChanged(), 0, this);
        }

        public /* synthetic */ MenuAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

