/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.DecelerateInterpolator;
import android.widget.ActionMenuPresenter;
import android.widget.ActionMenuView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.widget.AbsActionBarView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActionBarContextView
extends AbsActionBarView
implements Animator.AnimatorListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ActionBarContextView";
    private CharSequence mTitle;
    private CharSequence mSubtitle;
    private View mClose;
    private View mCustomView;
    private LinearLayout mTitleLayout;
    private TextView mTitleView;
    private TextView mSubtitleView;
    private int mTitleStyleRes;
    private int mSubtitleStyleRes;
    private Drawable mSplitBackground;
    private boolean mTitleOptional;
    private int mCloseItemLayout;
    private Animator mCurrentAnimation;
    private boolean mAnimateInOnLayout;
    private int mAnimationMode;
    private static int ANIMATE_IDLE = 0;
    private static int ANIMATE_IN = 1;
    private static int ANIMATE_OUT = 2;

    private void $$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ActionMode, defStyleAttr, defStyleRes);
        this.setBackground(a.getDrawable(0));
        this.mTitleStyleRes = a.getResourceId(2, 0);
        this.mSubtitleStyleRes = a.getResourceId(3, 0);
        this.mContentHeight = a.getLayoutDimension(1, 0);
        this.mSplitBackground = a.getDrawable(4);
        this.mCloseItemLayout = a.getResourceId(5, 17367071);
        a.recycle();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.hideOverflowMenu();
            this.mActionMenuPresenter.hideSubMenus();
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$setSplitToolbar(boolean split) {
        if (this.mSplitActionBar != split) {
            if (this.mActionMenuPresenter != null) {
                ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
                if (!split) {
                    this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
                    this.mMenuView.setBackground(null);
                    ViewGroup oldParent = (ViewGroup)this.mMenuView.getParent();
                    if (oldParent != null) {
                        oldParent.removeView(this.mMenuView);
                    }
                    this.addView((View)this.mMenuView, layoutParams);
                } else {
                    this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
                    this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
                    layoutParams.width = -1;
                    layoutParams.height = this.mContentHeight;
                    this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
                    this.mMenuView.setBackground(this.mSplitBackground);
                    ViewGroup oldParent = (ViewGroup)this.mMenuView.getParent();
                    if (oldParent != null) {
                        oldParent.removeView(this.mMenuView);
                    }
                    this.mSplitView.addView((View)this.mMenuView, layoutParams);
                }
            }
            super.setSplitToolbar(split);
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$setContentHeight(int height) {
        this.mContentHeight = height;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$setCustomView(View view) {
        if (this.mCustomView != null) {
            this.removeView(this.mCustomView);
        }
        this.mCustomView = view;
        if (this.mTitleLayout != null) {
            this.removeView(this.mTitleLayout);
            this.mTitleLayout = null;
        }
        if (view != null) {
            this.addView(view);
        }
        this.requestLayout();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$setTitle(CharSequence title) {
        this.mTitle = title;
        this.initTitle();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$setSubtitle(CharSequence subtitle) {
        this.mSubtitle = subtitle;
        this.initTitle();
    }

    private final CharSequence $$robo$$com_android_internal_widget_ActionBarContextView$getTitle() {
        return this.mTitle;
    }

    private final CharSequence $$robo$$com_android_internal_widget_ActionBarContextView$getSubtitle() {
        return this.mSubtitle;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$initTitle() {
        if (this.mTitleLayout == null) {
            LayoutInflater inflater = LayoutInflater.from(this.getContext());
            inflater.inflate(17367066, (ViewGroup)this);
            this.mTitleLayout = (LinearLayout)this.getChildAt(this.getChildCount() - 1);
            this.mTitleView = (TextView)this.mTitleLayout.findViewById(16908980);
            this.mSubtitleView = (TextView)this.mTitleLayout.findViewById(16908981);
            if (this.mTitleStyleRes != 0) {
                this.mTitleView.setTextAppearance(this.mContext, this.mTitleStyleRes);
            }
            if (this.mSubtitleStyleRes != 0) {
                this.mSubtitleView.setTextAppearance(this.mContext, this.mSubtitleStyleRes);
            }
        }
        this.mTitleView.setText(this.mTitle);
        this.mSubtitleView.setText(this.mSubtitle);
        boolean hasTitle = !TextUtils.isEmpty(this.mTitle);
        boolean hasSubtitle = !TextUtils.isEmpty(this.mSubtitle);
        this.mSubtitleView.setVisibility(hasSubtitle ? 0 : 8);
        this.mTitleLayout.setVisibility(hasTitle || hasSubtitle ? 0 : 8);
        if (this.mTitleLayout.getParent() == null) {
            this.addView(this.mTitleLayout);
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$initForMode(ActionMode mode) {
        if (this.mClose == null) {
            LayoutInflater inflater = LayoutInflater.from(this.mContext);
            this.mClose = inflater.inflate(this.mCloseItemLayout, (ViewGroup)this, false);
            this.addView(this.mClose);
        } else if (this.mClose.getParent() == null) {
            this.addView(this.mClose);
        }
        View closeButton = this.mClose.findViewById(16908982);
        closeButton.setOnClickListener(new View.OnClickListener(this, mode){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ActionMode val$mode;
            /* synthetic */ ActionBarContextView this$0;

            private void $$robo$$com_android_internal_widget_ActionBarContextView_1$__constructor__(ActionBarContextView actionBarContextView, ActionMode actionMode) {
            }

            private final void $$robo$$com_android_internal_widget_ActionBarContextView_1$onClick(View v) {
                this.val$mode.finish();
            }

            private void __constructor__(ActionBarContextView actionBarContextView, ActionMode actionMode) {
                this.$$robo$$com_android_internal_widget_ActionBarContextView_1$__constructor__(actionBarContextView, actionMode);
            }
            {
                this.this$0 = actionBarContextView;
                this.val$mode = actionMode;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarContextView_1$__constructor__(com.android.internal.widget.ActionBarContextView android.view.ActionMode ), 0, this, actionBarContextView, actionMode);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_widget_ActionBarContextView_1$onClick(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        MenuBuilder menu2 = (MenuBuilder)mode.getMenu();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.dismissPopupMenus();
        }
        this.mActionMenuPresenter = new ActionMenuPresenter(this.mContext);
        this.mActionMenuPresenter.setReserveOverflow(true);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        if (!this.mSplitActionBar) {
            menu2.addMenuPresenter(this.mActionMenuPresenter, this.mPopupContext);
            this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            this.mMenuView.setBackgroundDrawable(null);
            this.addView((View)this.mMenuView, layoutParams);
        } else {
            this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
            this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
            layoutParams.width = -1;
            layoutParams.height = this.mContentHeight;
            menu2.addMenuPresenter(this.mActionMenuPresenter, this.mPopupContext);
            this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            this.mMenuView.setBackgroundDrawable(this.mSplitBackground);
            this.mSplitView.addView((View)this.mMenuView, layoutParams);
        }
        this.mAnimateInOnLayout = true;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$closeMode() {
        if (this.mAnimationMode == 2) {
            return;
        }
        if (this.mClose == null) {
            this.killMode();
            return;
        }
        this.finishAnimation();
        this.mAnimationMode = 2;
        this.mCurrentAnimation = this.makeOutAnimation();
        this.mCurrentAnimation.start();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$finishAnimation() {
        Animator a = this.mCurrentAnimation;
        if (a != null) {
            this.mCurrentAnimation = null;
            a.end();
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$killMode() {
        this.finishAnimation();
        this.removeAllViews();
        if (this.mSplitView != null) {
            this.mSplitView.removeView(this.mMenuView);
        }
        this.mCustomView = null;
        this.mMenuView = null;
        this.mAnimateInOnLayout = false;
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarContextView$showOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.showOverflowMenu();
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarContextView$hideOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.hideOverflowMenu();
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarContextView$isOverflowMenuShowing() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.isOverflowMenuShowing();
        }
        return false;
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_ActionBarContextView$generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -2);
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_ActionBarContextView$generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewGroup.LayoutParams lp;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        if (widthMode != 0x40000000) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_width=\"match_parent\" (or fill_parent)");
        }
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        if (heightMode == 0) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_height=\"wrap_content\"");
        }
        int contentWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int maxHeight = this.mContentHeight > 0 ? this.mContentHeight : View.MeasureSpec.getSize(heightMeasureSpec);
        int verticalPadding = this.getPaddingTop() + this.getPaddingBottom();
        int availableWidth = contentWidth - this.getPaddingLeft() - this.getPaddingRight();
        int height = maxHeight - verticalPadding;
        int childSpecHeight = View.MeasureSpec.makeMeasureSpec(height, Integer.MIN_VALUE);
        if (this.mClose != null) {
            availableWidth = this.measureChildView(this.mClose, availableWidth, childSpecHeight, 0);
            lp = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
            availableWidth -= lp.leftMargin + lp.rightMargin;
        }
        if (this.mMenuView != null && this.mMenuView.getParent() == this) {
            availableWidth = this.measureChildView(this.mMenuView, availableWidth, childSpecHeight, 0);
        }
        if (this.mTitleLayout != null && this.mCustomView == null) {
            if (this.mTitleOptional) {
                boolean titleFits;
                int titleWidthSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
                this.mTitleLayout.measure(titleWidthSpec, childSpecHeight);
                int titleWidth = this.mTitleLayout.getMeasuredWidth();
                boolean bl = titleFits = titleWidth <= availableWidth;
                if (titleFits) {
                    availableWidth -= titleWidth;
                }
                this.mTitleLayout.setVisibility(titleFits ? 0 : 8);
            } else {
                availableWidth = this.measureChildView(this.mTitleLayout, availableWidth, childSpecHeight, 0);
            }
        }
        if (this.mCustomView != null) {
            lp = this.mCustomView.getLayoutParams();
            int customWidthMode = lp.width != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int customWidth = lp.width >= 0 ? Math.min(lp.width, availableWidth) : availableWidth;
            int customHeightMode = lp.height != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int customHeight = lp.height >= 0 ? Math.min(lp.height, height) : height;
            this.mCustomView.measure(View.MeasureSpec.makeMeasureSpec(customWidth, customWidthMode), View.MeasureSpec.makeMeasureSpec(customHeight, customHeightMode));
        }
        if (this.mContentHeight <= 0) {
            int measuredHeight = 0;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View v = this.getChildAt(i);
                int paddedViewHeight = v.getMeasuredHeight() + verticalPadding;
                if (paddedViewHeight <= measuredHeight) continue;
                measuredHeight = paddedViewHeight;
            }
            this.setMeasuredDimension(contentWidth, measuredHeight);
        } else {
            this.setMeasuredDimension(contentWidth, maxHeight);
        }
    }

    private final Animator $$robo$$com_android_internal_widget_ActionBarContextView$makeInAnimation() {
        int count;
        this.mClose.setTranslationX(-this.mClose.getWidth() - ((ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams()).leftMargin);
        ObjectAnimator buttonAnimator = ObjectAnimator.ofFloat((Object)this.mClose, "translationX", 0.0f);
        buttonAnimator.setDuration(200L);
        buttonAnimator.addListener(this);
        buttonAnimator.setInterpolator(new DecelerateInterpolator());
        AnimatorSet set = new AnimatorSet();
        AnimatorSet.Builder b = set.play(buttonAnimator);
        if (this.mMenuView != null && (count = this.mMenuView.getChildCount()) > 0) {
            int i = count - 1;
            int j = 0;
            while (i >= 0) {
                View child = this.mMenuView.getChildAt(i);
                child.setScaleY(0.0f);
                ObjectAnimator a = ObjectAnimator.ofFloat((Object)child, "scaleY", 0.0f, 1.0f);
                a.setDuration(300L);
                b.with(a);
                --i;
                ++j;
            }
        }
        return set;
    }

    private final Animator $$robo$$com_android_internal_widget_ActionBarContextView$makeOutAnimation() {
        int count;
        ObjectAnimator buttonAnimator = ObjectAnimator.ofFloat((Object)this.mClose, "translationX", -this.mClose.getWidth() - ((ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams()).leftMargin);
        buttonAnimator.setDuration(200L);
        buttonAnimator.addListener(this);
        buttonAnimator.setInterpolator(new DecelerateInterpolator());
        AnimatorSet set = new AnimatorSet();
        AnimatorSet.Builder b = set.play(buttonAnimator);
        if (this.mMenuView != null && (count = this.mMenuView.getChildCount()) > 0) {
            for (int i = 0; i < 0; ++i) {
                View child = this.mMenuView.getChildAt(i);
                child.setScaleY(0.0f);
                ObjectAnimator a = ObjectAnimator.ofFloat((Object)child, "scaleY", 0.0f);
                a.setDuration(300L);
                b.with(a);
            }
        }
        return set;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$onLayout(boolean changed, int l, int t, int r, int b) {
        boolean isLayoutRtl = this.isLayoutRtl();
        int x = isLayoutRtl ? r - l - this.getPaddingRight() : this.getPaddingLeft();
        int y = this.getPaddingTop();
        int contentHeight = b - t - this.getPaddingTop() - this.getPaddingBottom();
        if (this.mClose != null && this.mClose.getVisibility() != 8) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
            int startMargin = isLayoutRtl ? lp.rightMargin : lp.leftMargin;
            int endMargin = isLayoutRtl ? lp.leftMargin : lp.rightMargin;
            x = ActionBarContextView.next(x, startMargin, isLayoutRtl);
            x += this.positionChild(this.mClose, x, y, contentHeight, isLayoutRtl);
            x = ActionBarContextView.next(x, endMargin, isLayoutRtl);
            if (this.mAnimateInOnLayout) {
                this.mAnimationMode = 1;
                this.mCurrentAnimation = this.makeInAnimation();
                this.mCurrentAnimation.start();
                this.mAnimateInOnLayout = false;
            }
        }
        if (this.mTitleLayout != null && this.mCustomView == null && this.mTitleLayout.getVisibility() != 8) {
            x += this.positionChild(this.mTitleLayout, x, y, contentHeight, isLayoutRtl);
        }
        if (this.mCustomView != null) {
            x += this.positionChild(this.mCustomView, x, y, contentHeight, isLayoutRtl);
        }
        int n = x = isLayoutRtl ? this.getPaddingLeft() : r - l - this.getPaddingRight();
        if (this.mMenuView != null) {
            x += this.positionChild(this.mMenuView, x, y, contentHeight, !isLayoutRtl);
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$onAnimationStart(Animator animation) {
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$onAnimationEnd(Animator animation) {
        if (this.mAnimationMode == 2) {
            this.killMode();
        }
        this.mAnimationMode = 0;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$onAnimationCancel(Animator animation) {
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$onAnimationRepeat(Animator animation) {
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarContextView$shouldDelayChildPressedState() {
        return false;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        if (event.getEventType() == 32) {
            event.setSource(this);
            event.setClassName(this.getClass().getName());
            event.setPackageName(this.getContext().getPackageName());
            event.setContentDescription(this.mTitle);
        } else {
            super.onInitializeAccessibilityEvent(event);
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContextView$setTitleOptional(boolean titleOptional) {
        if (titleOptional != this.mTitleOptional) {
            this.requestLayout();
        }
        this.mTitleOptional = titleOptional;
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarContextView$isTitleOptional() {
        return this.mTitleOptional;
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(context);
    }

    public ActionBarContextView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(context, attributeSet);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843668);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(context, attributeSet, n);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(context, attributeSet, n, n2);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarContextView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_ActionBarContextView$onDetachedFromWindow(), 0, this);
    }

    @Override
    public void setSplitToolbar(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSplitToolbar", $$robo$$com_android_internal_widget_ActionBarContextView$setSplitToolbar(boolean ), 0, this, bl);
    }

    @Override
    public void setContentHeight(int n) {
        InvokeDynamicSupport.bootstrap("setContentHeight", $$robo$$com_android_internal_widget_ActionBarContextView$setContentHeight(int ), 0, this, n);
    }

    public void setCustomView(View view) {
        InvokeDynamicSupport.bootstrap("setCustomView", $$robo$$com_android_internal_widget_ActionBarContextView$setCustomView(android.view.View ), 0, this, view);
    }

    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_widget_ActionBarContextView$setTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setSubtitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setSubtitle", $$robo$$com_android_internal_widget_ActionBarContextView$setSubtitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    public CharSequence getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$com_android_internal_widget_ActionBarContextView$getTitle(), 0, this);
    }

    public CharSequence getSubtitle() {
        return InvokeDynamicSupport.bootstrap("getSubtitle", $$robo$$com_android_internal_widget_ActionBarContextView$getSubtitle(), 0, this);
    }

    private void initTitle() {
        InvokeDynamicSupport.bootstrap("initTitle", $$robo$$com_android_internal_widget_ActionBarContextView$initTitle(), 0, this);
    }

    public void initForMode(ActionMode actionMode) {
        InvokeDynamicSupport.bootstrap("initForMode", $$robo$$com_android_internal_widget_ActionBarContextView$initForMode(android.view.ActionMode ), 0, this, actionMode);
    }

    public void closeMode() {
        InvokeDynamicSupport.bootstrap("closeMode", $$robo$$com_android_internal_widget_ActionBarContextView$closeMode(), 0, this);
    }

    private void finishAnimation() {
        InvokeDynamicSupport.bootstrap("finishAnimation", $$robo$$com_android_internal_widget_ActionBarContextView$finishAnimation(), 0, this);
    }

    public void killMode() {
        InvokeDynamicSupport.bootstrap("killMode", $$robo$$com_android_internal_widget_ActionBarContextView$killMode(), 0, this);
    }

    @Override
    public boolean showOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("showOverflowMenu", $$robo$$com_android_internal_widget_ActionBarContextView$showOverflowMenu(), 0, this);
    }

    @Override
    public boolean hideOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("hideOverflowMenu", $$robo$$com_android_internal_widget_ActionBarContextView$hideOverflowMenu(), 0, this);
    }

    @Override
    public boolean isOverflowMenuShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowing", $$robo$$com_android_internal_widget_ActionBarContextView$isOverflowMenuShowing(), 0, this);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$com_android_internal_widget_ActionBarContextView$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_ActionBarContextView$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_ActionBarContextView$onMeasure(int int ), 0, this, n, n2);
    }

    private Animator makeInAnimation() {
        return InvokeDynamicSupport.bootstrap("makeInAnimation", $$robo$$com_android_internal_widget_ActionBarContextView$makeInAnimation(), 0, this);
    }

    private Animator makeOutAnimation() {
        return InvokeDynamicSupport.bootstrap("makeOutAnimation", $$robo$$com_android_internal_widget_ActionBarContextView$makeOutAnimation(), 0, this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_ActionBarContextView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public void onAnimationStart(Animator animator2) {
        InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_widget_ActionBarContextView$onAnimationStart(android.animation.Animator ), 0, this, animator2);
    }

    @Override
    public void onAnimationEnd(Animator animator2) {
        InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_ActionBarContextView$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
    }

    @Override
    public void onAnimationCancel(Animator animator2) {
        InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$com_android_internal_widget_ActionBarContextView$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
    }

    @Override
    public void onAnimationRepeat(Animator animator2) {
        InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$com_android_internal_widget_ActionBarContextView$onAnimationRepeat(android.animation.Animator ), 0, this, animator2);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$com_android_internal_widget_ActionBarContextView$shouldDelayChildPressedState(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$com_android_internal_widget_ActionBarContextView$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    public void setTitleOptional(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTitleOptional", $$robo$$com_android_internal_widget_ActionBarContextView$setTitleOptional(boolean ), 0, this, bl);
    }

    public boolean isTitleOptional() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTitleOptional", $$robo$$com_android_internal_widget_ActionBarContextView$isTitleOptional(), 0, this);
    }

    public /* synthetic */ ActionBarContextView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionBarContextView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

