/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import java.util.LinkedList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ExploreByTouchHelper
extends View.AccessibilityDelegate
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int INVALID_ID = Integer.MIN_VALUE;
    private static String DEFAULT_CLASS_NAME;
    private Rect mTempScreenRect;
    private Rect mTempParentRect;
    private Rect mTempVisibleRect;
    private int[] mTempGlobalRect;
    private Context mContext;
    private AccessibilityManager mManager;
    private View mView;
    private ExploreByTouchNodeProvider mNodeProvider;
    private int mFocusedVirtualViewId;
    private int mHoveredVirtualViewId;

    private void $$robo$$com_android_internal_widget_ExploreByTouchHelper$__constructor__(View forView) {
        this.mTempScreenRect = new Rect();
        this.mTempParentRect = new Rect();
        this.mTempVisibleRect = new Rect();
        this.mTempGlobalRect = new int[2];
        this.mFocusedVirtualViewId = Integer.MIN_VALUE;
        this.mHoveredVirtualViewId = Integer.MIN_VALUE;
        if (forView == null) {
            throw new IllegalArgumentException("View may not be null");
        }
        this.mView = forView;
        this.mContext = forView.getContext();
        this.mManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
    }

    private final AccessibilityNodeProvider $$robo$$com_android_internal_widget_ExploreByTouchHelper$getAccessibilityNodeProvider(View host) {
        if (this.mNodeProvider == null) {
            this.mNodeProvider = new ExploreByTouchNodeProvider(this);
        }
        return this.mNodeProvider;
    }

    private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper$dispatchHoverEvent(MotionEvent event) {
        if (!this.mManager.isEnabled() || !this.mManager.isTouchExplorationEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 7: 
            case 9: {
                int virtualViewId = this.getVirtualViewAt(event.getX(), event.getY());
                this.updateHoveredVirtualView(virtualViewId);
                return virtualViewId != Integer.MIN_VALUE;
            }
            case 10: {
                if (this.mFocusedVirtualViewId != Integer.MIN_VALUE) {
                    this.updateHoveredVirtualView(Integer.MIN_VALUE);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper$sendEventForVirtualView(int virtualViewId, int eventType) {
        if (virtualViewId == Integer.MIN_VALUE || !this.mManager.isEnabled()) {
            return false;
        }
        ViewParent parent = this.mView.getParent();
        if (parent == null) {
            return false;
        }
        AccessibilityEvent event = this.createEvent(virtualViewId, eventType);
        return parent.requestSendAccessibilityEvent(this.mView, event);
    }

    private final void $$robo$$com_android_internal_widget_ExploreByTouchHelper$invalidateRoot() {
        this.invalidateVirtualView(-1);
    }

    private final void $$robo$$com_android_internal_widget_ExploreByTouchHelper$invalidateVirtualView(int virtualViewId) {
        this.sendEventForVirtualView(virtualViewId, 2048);
    }

    private final int $$robo$$com_android_internal_widget_ExploreByTouchHelper$getFocusedVirtualView() {
        return this.mFocusedVirtualViewId;
    }

    private final void $$robo$$com_android_internal_widget_ExploreByTouchHelper$updateHoveredVirtualView(int virtualViewId) {
        if (this.mHoveredVirtualViewId == virtualViewId) {
            return;
        }
        int previousVirtualViewId = this.mHoveredVirtualViewId;
        this.mHoveredVirtualViewId = virtualViewId;
        this.sendEventForVirtualView(virtualViewId, 128);
        this.sendEventForVirtualView(previousVirtualViewId, 256);
    }

    private final AccessibilityEvent $$robo$$com_android_internal_widget_ExploreByTouchHelper$createEvent(int virtualViewId, int eventType) {
        switch (virtualViewId) {
            case -1: {
                return this.createEventForHost(eventType);
            }
        }
        return this.createEventForChild(virtualViewId, eventType);
    }

    private final AccessibilityEvent $$robo$$com_android_internal_widget_ExploreByTouchHelper$createEventForHost(int eventType) {
        AccessibilityEvent event = AccessibilityEvent.obtain(eventType);
        this.onInitializeAccessibilityEvent(this.mView, event);
        return event;
    }

    private final AccessibilityEvent $$robo$$com_android_internal_widget_ExploreByTouchHelper$createEventForChild(int virtualViewId, int eventType) {
        AccessibilityEvent event = AccessibilityEvent.obtain(eventType);
        event.setEnabled(true);
        event.setClassName(DEFAULT_CLASS_NAME);
        this.onPopulateEventForVirtualView(virtualViewId, event);
        if (event.getText().isEmpty() && event.getContentDescription() == null) {
            throw new RuntimeException("Callbacks must add text or a content description in populateEventForVirtualViewId()");
        }
        event.setPackageName(this.mView.getContext().getPackageName());
        event.setSource(this.mView, virtualViewId);
        return event;
    }

    private final AccessibilityNodeInfo $$robo$$com_android_internal_widget_ExploreByTouchHelper$createNode(int virtualViewId) {
        switch (virtualViewId) {
            case -1: {
                return this.createNodeForHost();
            }
        }
        return this.createNodeForChild(virtualViewId);
    }

    private final AccessibilityNodeInfo $$robo$$com_android_internal_widget_ExploreByTouchHelper$createNodeForHost() {
        AccessibilityNodeInfo node = AccessibilityNodeInfo.obtain(this.mView);
        this.onInitializeAccessibilityNodeInfo(this.mView, node);
        LinkedList<Integer> virtualViewIds = new LinkedList<Integer>();
        this.getVisibleVirtualViews(virtualViewIds);
        for (Integer childVirtualViewId : virtualViewIds) {
            node.addChild(this.mView, childVirtualViewId);
        }
        return node;
    }

    private final AccessibilityNodeInfo $$robo$$com_android_internal_widget_ExploreByTouchHelper$createNodeForChild(int virtualViewId) {
        AccessibilityNodeInfo node = AccessibilityNodeInfo.obtain();
        node.setEnabled(true);
        node.setClassName(DEFAULT_CLASS_NAME);
        this.onPopulateNodeForVirtualView(virtualViewId, node);
        if (node.getText() == null && node.getContentDescription() == null) {
            throw new RuntimeException("Callbacks must add text or a content description in populateNodeForVirtualViewId()");
        }
        node.getBoundsInParent(this.mTempParentRect);
        if (this.mTempParentRect.isEmpty()) {
            throw new RuntimeException("Callbacks must set parent bounds in populateNodeForVirtualViewId()");
        }
        int actions = node.getActions();
        if ((actions & 0x40) != 0) {
            throw new RuntimeException("Callbacks must not add ACTION_ACCESSIBILITY_FOCUS in populateNodeForVirtualViewId()");
        }
        if ((actions & 0x80) != 0) {
            throw new RuntimeException("Callbacks must not add ACTION_CLEAR_ACCESSIBILITY_FOCUS in populateNodeForVirtualViewId()");
        }
        node.setPackageName(this.mView.getContext().getPackageName());
        node.setSource(this.mView, virtualViewId);
        node.setParent(this.mView);
        if (this.mFocusedVirtualViewId == virtualViewId) {
            node.setAccessibilityFocused(true);
            node.addAction(128);
        } else {
            node.setAccessibilityFocused(false);
            node.addAction(64);
        }
        if (this.intersectVisibleToUser(this.mTempParentRect)) {
            node.setVisibleToUser(true);
            node.setBoundsInParent(this.mTempParentRect);
        }
        this.mView.getLocationOnScreen(this.mTempGlobalRect);
        int offsetX = this.mTempGlobalRect[0];
        int offsetY = this.mTempGlobalRect[1];
        this.mTempScreenRect.set(this.mTempParentRect);
        this.mTempScreenRect.offset(offsetX, offsetY);
        node.setBoundsInScreen(this.mTempScreenRect);
        return node;
    }

    private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper$performAction(int virtualViewId, int action, Bundle arguments) {
        switch (virtualViewId) {
            case -1: {
                return this.performActionForHost(action, arguments);
            }
        }
        return this.performActionForChild(virtualViewId, action, arguments);
    }

    private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper$performActionForHost(int action, Bundle arguments) {
        return this.performAccessibilityAction(this.mView, action, arguments);
    }

    private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper$performActionForChild(int virtualViewId, int action, Bundle arguments) {
        switch (action) {
            case 64: 
            case 128: {
                return this.manageFocusForChild(virtualViewId, action, arguments);
            }
        }
        return this.onPerformActionForVirtualView(virtualViewId, action, arguments);
    }

    private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper$manageFocusForChild(int virtualViewId, int action, Bundle arguments) {
        switch (action) {
            case 64: {
                return this.requestAccessibilityFocus(virtualViewId);
            }
            case 128: {
                return this.clearAccessibilityFocus(virtualViewId);
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper$intersectVisibleToUser(Rect localRect) {
        if (localRect == null || localRect.isEmpty()) {
            return false;
        }
        if (this.mView.getWindowVisibility() != 0) {
            return false;
        }
        ViewParent viewParent = this.mView.getParent();
        while (viewParent instanceof View) {
            View view = (View)((Object)viewParent);
            if (view.getAlpha() <= 0.0f || view.getVisibility() != 0) {
                return false;
            }
            viewParent = view.getParent();
        }
        if (viewParent == null) {
            return false;
        }
        if (!this.mView.getLocalVisibleRect(this.mTempVisibleRect)) {
            return false;
        }
        return localRect.intersect(this.mTempVisibleRect);
    }

    private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper$isAccessibilityFocused(int virtualViewId) {
        return this.mFocusedVirtualViewId == virtualViewId;
    }

    private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper$requestAccessibilityFocus(int virtualViewId) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        if (!this.mManager.isEnabled() || !accessibilityManager.isTouchExplorationEnabled()) {
            return false;
        }
        if (!this.isAccessibilityFocused(virtualViewId)) {
            this.mFocusedVirtualViewId = virtualViewId;
            this.mView.invalidate();
            this.sendEventForVirtualView(virtualViewId, 32768);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper$clearAccessibilityFocus(int virtualViewId) {
        if (this.isAccessibilityFocused(virtualViewId)) {
            this.mFocusedVirtualViewId = Integer.MIN_VALUE;
            this.mView.invalidate();
            this.sendEventForVirtualView(virtualViewId, 65536);
            return true;
        }
        return false;
    }

    protected abstract int getVirtualViewAt(float var1, float var2);

    protected abstract void getVisibleVirtualViews(List<Integer> var1);

    protected abstract void onPopulateEventForVirtualView(int var1, AccessibilityEvent var2);

    protected abstract void onPopulateNodeForVirtualView(int var1, AccessibilityNodeInfo var2);

    protected abstract boolean onPerformActionForVirtualView(int var1, int var2, Bundle var3);

    static void __staticInitializer__() {
        DEFAULT_CLASS_NAME = View.class.getName();
    }

    private void __constructor__(View view) {
        this.$$robo$$com_android_internal_widget_ExploreByTouchHelper$__constructor__(view);
    }

    public ExploreByTouchHelper(View view) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ExploreByTouchHelper$__constructor__(android.view.View ), 0, this, view);
    }

    @Override
    public AccessibilityNodeProvider getAccessibilityNodeProvider(View view) {
        return InvokeDynamicSupport.bootstrap("getAccessibilityNodeProvider", $$robo$$com_android_internal_widget_ExploreByTouchHelper$getAccessibilityNodeProvider(android.view.View ), 0, this, view);
    }

    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchHoverEvent", $$robo$$com_android_internal_widget_ExploreByTouchHelper$dispatchHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public boolean sendEventForVirtualView(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendEventForVirtualView", $$robo$$com_android_internal_widget_ExploreByTouchHelper$sendEventForVirtualView(int int ), 0, this, n, n2);
    }

    public void invalidateRoot() {
        InvokeDynamicSupport.bootstrap("invalidateRoot", $$robo$$com_android_internal_widget_ExploreByTouchHelper$invalidateRoot(), 0, this);
    }

    public void invalidateVirtualView(int n) {
        InvokeDynamicSupport.bootstrap("invalidateVirtualView", $$robo$$com_android_internal_widget_ExploreByTouchHelper$invalidateVirtualView(int ), 0, this, n);
    }

    public int getFocusedVirtualView() {
        return (int)InvokeDynamicSupport.bootstrap("getFocusedVirtualView", $$robo$$com_android_internal_widget_ExploreByTouchHelper$getFocusedVirtualView(), 0, this);
    }

    private void updateHoveredVirtualView(int n) {
        InvokeDynamicSupport.bootstrap("updateHoveredVirtualView", $$robo$$com_android_internal_widget_ExploreByTouchHelper$updateHoveredVirtualView(int ), 0, this, n);
    }

    private AccessibilityEvent createEvent(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createEvent", $$robo$$com_android_internal_widget_ExploreByTouchHelper$createEvent(int int ), 0, this, n, n2);
    }

    private AccessibilityEvent createEventForHost(int n) {
        return InvokeDynamicSupport.bootstrap("createEventForHost", $$robo$$com_android_internal_widget_ExploreByTouchHelper$createEventForHost(int ), 0, this, n);
    }

    private AccessibilityEvent createEventForChild(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createEventForChild", $$robo$$com_android_internal_widget_ExploreByTouchHelper$createEventForChild(int int ), 0, this, n, n2);
    }

    private AccessibilityNodeInfo createNode(int n) {
        return InvokeDynamicSupport.bootstrap("createNode", $$robo$$com_android_internal_widget_ExploreByTouchHelper$createNode(int ), 0, this, n);
    }

    private AccessibilityNodeInfo createNodeForHost() {
        return InvokeDynamicSupport.bootstrap("createNodeForHost", $$robo$$com_android_internal_widget_ExploreByTouchHelper$createNodeForHost(), 0, this);
    }

    private AccessibilityNodeInfo createNodeForChild(int n) {
        return InvokeDynamicSupport.bootstrap("createNodeForChild", $$robo$$com_android_internal_widget_ExploreByTouchHelper$createNodeForChild(int ), 0, this, n);
    }

    private boolean performAction(int n, int n2, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAction", $$robo$$com_android_internal_widget_ExploreByTouchHelper$performAction(int int android.os.Bundle ), 0, this, n, n2, bundle);
    }

    private boolean performActionForHost(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performActionForHost", $$robo$$com_android_internal_widget_ExploreByTouchHelper$performActionForHost(int android.os.Bundle ), 0, this, n, bundle);
    }

    private boolean performActionForChild(int n, int n2, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performActionForChild", $$robo$$com_android_internal_widget_ExploreByTouchHelper$performActionForChild(int int android.os.Bundle ), 0, this, n, n2, bundle);
    }

    private boolean manageFocusForChild(int n, int n2, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("manageFocusForChild", $$robo$$com_android_internal_widget_ExploreByTouchHelper$manageFocusForChild(int int android.os.Bundle ), 0, this, n, n2, bundle);
    }

    private boolean intersectVisibleToUser(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("intersectVisibleToUser", $$robo$$com_android_internal_widget_ExploreByTouchHelper$intersectVisibleToUser(android.graphics.Rect ), 0, this, rect);
    }

    private boolean isAccessibilityFocused(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAccessibilityFocused", $$robo$$com_android_internal_widget_ExploreByTouchHelper$isAccessibilityFocused(int ), 0, this, n);
    }

    private boolean requestAccessibilityFocus(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestAccessibilityFocus", $$robo$$com_android_internal_widget_ExploreByTouchHelper$requestAccessibilityFocus(int ), 0, this, n);
    }

    private boolean clearAccessibilityFocus(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearAccessibilityFocus", $$robo$$com_android_internal_widget_ExploreByTouchHelper$clearAccessibilityFocus(int ), 0, this, n);
    }

    static {
        RobolectricInternals.classInitializing(ExploreByTouchHelper.class);
    }

    public /* synthetic */ ExploreByTouchHelper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExploreByTouchHelper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ExploreByTouchNodeProvider
    extends AccessibilityNodeProvider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ExploreByTouchHelper this$0;

        private void $$robo$$com_android_internal_widget_ExploreByTouchHelper_ExploreByTouchNodeProvider$__constructor__(ExploreByTouchHelper exploreByTouchHelper) {
        }

        private final AccessibilityNodeInfo $$robo$$com_android_internal_widget_ExploreByTouchHelper_ExploreByTouchNodeProvider$createAccessibilityNodeInfo(int virtualViewId) {
            return this.this$0.createNode(virtualViewId);
        }

        private final boolean $$robo$$com_android_internal_widget_ExploreByTouchHelper_ExploreByTouchNodeProvider$performAction(int virtualViewId, int action, Bundle arguments) {
            return this.this$0.performAction(virtualViewId, action, arguments);
        }

        private /* synthetic */ void $$robo$$com_android_internal_widget_ExploreByTouchHelper_ExploreByTouchNodeProvider$__constructor__(ExploreByTouchHelper x0, 1 x1) {
        }

        private void __constructor__(ExploreByTouchHelper exploreByTouchHelper) {
            this.$$robo$$com_android_internal_widget_ExploreByTouchHelper_ExploreByTouchNodeProvider$__constructor__(exploreByTouchHelper);
        }

        private ExploreByTouchNodeProvider(ExploreByTouchHelper exploreByTouchHelper) {
            this.this$0 = exploreByTouchHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ExploreByTouchHelper_ExploreByTouchNodeProvider$__constructor__(com.android.internal.widget.ExploreByTouchHelper ), 0, this, exploreByTouchHelper);
        }

        @Override
        public AccessibilityNodeInfo createAccessibilityNodeInfo(int n) {
            return InvokeDynamicSupport.bootstrap("createAccessibilityNodeInfo", $$robo$$com_android_internal_widget_ExploreByTouchHelper_ExploreByTouchNodeProvider$createAccessibilityNodeInfo(int ), 0, this, n);
        }

        @Override
        public boolean performAction(int n, int n2, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("performAction", $$robo$$com_android_internal_widget_ExploreByTouchHelper_ExploreByTouchNodeProvider$performAction(int int android.os.Bundle ), 0, this, n, n2, bundle);
        }

        private /* synthetic */ void __constructor__(ExploreByTouchHelper exploreByTouchHelper, 1 var2_2) {
            this.$$robo$$com_android_internal_widget_ExploreByTouchHelper_ExploreByTouchNodeProvider$__constructor__(exploreByTouchHelper, var2_2);
        }

        public /* synthetic */ ExploreByTouchNodeProvider() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExploreByTouchNodeProvider)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

