/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.admin.DevicePolicyManager;
import android.app.trust.TrustManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IMountService;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.IWindowManager;
import android.widget.Button;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternUtilsCache;
import com.android.internal.widget.LockPatternView;
import com.google.android.collect.Lists;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LockPatternUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "LockPatternUtils";
    private static boolean DEBUG = false;
    public static int FAILED_ATTEMPTS_BEFORE_TIMEOUT = 5;
    public static int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static long FAILED_ATTEMPT_TIMEOUT_MS = 30000L;
    public static long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static int FAILED_ATTEMPTS_BEFORE_WIPE_GRACE = 5;
    public static int MIN_LOCK_PATTERN_SIZE = 4;
    public static int MIN_PATTERN_REGISTER_FAIL = 4;
    public static String KEYGUARD_SHOW_USER_SWITCHER = "showuserswitcher";
    public static String KEYGUARD_SHOW_SECURITY_CHALLENGE = "showsecuritychallenge";
    public static String KEYGUARD_SHOW_APPWIDGET = "showappwidget";
    public static int FLAG_BIOMETRIC_WEAK_LIVELINESS = 1;
    public static int ID_DEFAULT_STATUS_WIDGET = -2;
    public static String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    public static String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    public static String PATTERN_EVER_CHOSEN_KEY = "lockscreen.patterneverchosen";
    public static String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    public static String PASSWORD_TYPE_ALTERNATE_KEY = "lockscreen.password_type_alternate";
    public static String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    public static String DISABLE_LOCKSCREEN_KEY = "lockscreen.disabled";
    public static String LOCKSCREEN_OPTIONS = "lockscreen.options";
    public static String LOCKSCREEN_BIOMETRIC_WEAK_FALLBACK = "lockscreen.biometric_weak_fallback";
    public static String BIOMETRIC_WEAK_EVER_CHOSEN_KEY = "lockscreen.biometricweakeverchosen";
    public static String LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS = "lockscreen.power_button_instantly_locks";
    public static String LOCKSCREEN_WIDGETS_ENABLED = "lockscreen.widgets_enabled";
    public static String PASSWORD_HISTORY_KEY = "lockscreen.passwordhistory";
    private static String LOCK_SCREEN_OWNER_INFO = "lock_screen_owner_info";
    private static String LOCK_SCREEN_OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
    private static String ENABLED_TRUST_AGENTS = "lockscreen.enabledtrustagents";
    public static int MAX_ALLOWED_SEQUENCE = 3;
    private Context mContext;
    private ContentResolver mContentResolver;
    private DevicePolicyManager mDevicePolicyManager;
    private ILockSettings mLockSettingsService;
    private boolean mMultiUserMode;
    private static volatile int sCurrentUserId;

    private final DevicePolicyManager $$robo$$com_android_internal_widget_LockPatternUtils$getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                Log.e("LockPatternUtils", "Can't get DevicePolicyManagerService: is it running?", new IllegalStateException("Stack trace:"));
            }
        }
        return this.mDevicePolicyManager;
    }

    private final TrustManager $$robo$$com_android_internal_widget_LockPatternUtils$getTrustManager() {
        TrustManager trust = (TrustManager)this.mContext.getSystemService("trust");
        if (trust == null) {
            Log.e("LockPatternUtils", "Can't get TrustManagerService: is it running?", new IllegalStateException("Stack trace:"));
        }
        return trust;
    }

    private void $$robo$$com_android_internal_widget_LockPatternUtils$__constructor__(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mMultiUserMode = context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0;
    }

    private final ILockSettings $$robo$$com_android_internal_widget_LockPatternUtils$getLockSettings() {
        if (this.mLockSettingsService == null) {
            this.mLockSettingsService = LockPatternUtilsCache.getInstance(ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings")));
        }
        return this.mLockSettingsService;
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedMinimumPasswordLength() {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null, this.getCurrentOrCallingUserId());
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordQuality() {
        return this.getDevicePolicyManager().getPasswordQuality(null, this.getCurrentOrCallingUserId());
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordHistoryLength() {
        return this.getDevicePolicyManager().getPasswordHistoryLength(null, this.getCurrentOrCallingUserId());
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumLetters() {
        return this.getDevicePolicyManager().getPasswordMinimumLetters(null, this.getCurrentOrCallingUserId());
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumUpperCase() {
        return this.getDevicePolicyManager().getPasswordMinimumUpperCase(null, this.getCurrentOrCallingUserId());
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumLowerCase() {
        return this.getDevicePolicyManager().getPasswordMinimumLowerCase(null, this.getCurrentOrCallingUserId());
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumNumeric() {
        return this.getDevicePolicyManager().getPasswordMinimumNumeric(null, this.getCurrentOrCallingUserId());
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumSymbols() {
        return this.getDevicePolicyManager().getPasswordMinimumSymbols(null, this.getCurrentOrCallingUserId());
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumNonLetter() {
        return this.getDevicePolicyManager().getPasswordMinimumNonLetter(null, this.getCurrentOrCallingUserId());
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$reportFailedPasswordAttempt() {
        int userId = this.getCurrentOrCallingUserId();
        this.getDevicePolicyManager().reportFailedPasswordAttempt(userId);
        this.getTrustManager().reportUnlockAttempt(false, userId);
        this.getTrustManager().reportRequireCredentialEntry(userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$reportSuccessfulPasswordAttempt() {
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt(this.getCurrentOrCallingUserId());
        this.getTrustManager().reportUnlockAttempt(true, this.getCurrentOrCallingUserId());
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setCurrentUser(int userId) {
        sCurrentUserId = userId;
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getCurrentUser() {
        if (sCurrentUserId != -10000) {
            return sCurrentUserId;
        }
        try {
            return ActivityManagerNative.getDefault().getCurrentUser().id;
        }
        catch (RemoteException re) {
            return 0;
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$removeUser(int userId) {
        try {
            this.getLockSettings().removeUser(userId);
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Couldn't remove lock settings for user " + userId);
        }
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getCurrentOrCallingUserId() {
        if (this.mMultiUserMode) {
            return this.getCurrentUser();
        }
        return UserHandle.getCallingUserId();
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$checkPattern(List<LockPatternView.Cell> pattern) {
        int userId = this.getCurrentOrCallingUserId();
        try {
            return this.getLockSettings().checkPattern(LockPatternUtils.patternToString(pattern), userId);
        }
        catch (RemoteException re) {
            return true;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$checkPassword(String password) {
        int userId = this.getCurrentOrCallingUserId();
        try {
            return this.getLockSettings().checkPassword(password, userId);
        }
        catch (RemoteException re) {
            return true;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$checkVoldPassword() {
        int userId = this.getCurrentOrCallingUserId();
        try {
            return this.getLockSettings().checkVoldPassword(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$checkPasswordHistory(String password) {
        String passwordHashString = new String(this.passwordToHash(password, this.getCurrentOrCallingUserId()));
        String passwordHistory = this.getString("lockscreen.passwordhistory");
        if (passwordHistory == null) {
            return false;
        }
        int passwordHashLength = passwordHashString.length();
        int passwordHistoryLength = this.getRequestedPasswordHistoryLength();
        if (passwordHistoryLength == 0) {
            return false;
        }
        int neededPasswordHistoryLength = passwordHashLength * passwordHistoryLength + passwordHistoryLength - 1;
        if (passwordHistory.length() > neededPasswordHistoryLength) {
            passwordHistory = passwordHistory.substring(0, neededPasswordHistoryLength);
        }
        return passwordHistory.contains(passwordHashString);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$savedPatternExists() {
        try {
            return this.getLockSettings().havePattern(this.getCurrentOrCallingUserId());
        }
        catch (RemoteException re) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$savedPasswordExists() {
        try {
            return this.getLockSettings().havePassword(this.getCurrentOrCallingUserId());
        }
        catch (RemoteException re) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isPatternEverChosen() {
        return this.getBoolean("lockscreen.patterneverchosen", false);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isBiometricWeakEverChosen() {
        return this.getBoolean("lockscreen.biometricweakeverchosen", false);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getActivePasswordQuality() {
        int activePasswordQuality = 0;
        int quality = (int)this.getLong("lockscreen.password_type", 65536L);
        switch (quality) {
            case 65536: {
                if (!this.isLockPatternEnabled()) break;
                activePasswordQuality = 65536;
                break;
            }
            case 32768: {
                if (!this.isBiometricWeakInstalled()) break;
                activePasswordQuality = 32768;
                break;
            }
            case 131072: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 131072;
                break;
            }
            case 196608: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 196608;
                break;
            }
            case 262144: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 262144;
                break;
            }
            case 327680: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 327680;
                break;
            }
            case 393216: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 393216;
            }
        }
        return activePasswordQuality;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$clearLock(boolean isFallback) {
        if (!isFallback) {
            this.deleteGallery();
        }
        this.saveLockPassword(null, 65536);
        this.setLockPatternEnabled(false);
        this.saveLockPattern(null);
        this.setLong("lockscreen.password_type", 0L);
        this.setLong("lockscreen.password_type_alternate", 0L);
        this.onAfterChangingPassword();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setLockScreenDisabled(boolean disable) {
        this.setLong("lockscreen.disabled", disable ? 1L : 0L);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isLockScreenDisabled() {
        if (!this.isSecure() && this.getLong("lockscreen.disabled", 0L) != 0L) {
            List<UserInfo> users = UserManager.get(this.mContext).getUsers(true);
            int userCount = users.size();
            int switchableUsers = 0;
            for (int i = 0; i < userCount; ++i) {
                if (!users.get(i).supportsSwitchTo()) continue;
                ++switchableUsers;
            }
            return switchableUsers < 2;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$deleteTempGallery() {
        Intent intent = new Intent().setAction("com.android.facelock.DELETE_GALLERY");
        intent.putExtra("deleteTempGallery", true);
        this.mContext.sendBroadcast(intent);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$deleteGallery() {
        if (this.usingBiometricWeak()) {
            Intent intent = new Intent().setAction("com.android.facelock.DELETE_GALLERY");
            intent.putExtra("deleteGallery", true);
            this.mContext.sendBroadcast(intent);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPattern(List<LockPatternView.Cell> pattern) {
        this.saveLockPattern(pattern, false);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPattern(List<LockPatternView.Cell> pattern, boolean isFallback) {
        try {
            int userId = this.getCurrentOrCallingUserId();
            this.getLockSettings().setLockPattern(LockPatternUtils.patternToString(pattern), userId);
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (pattern != null) {
                if (userId == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
                    boolean required = this.isCredentialRequiredToDecrypt(true);
                    if (!required) {
                        this.clearEncryptionPassword();
                    } else {
                        String stringPattern = LockPatternUtils.patternToString(pattern);
                        this.updateEncryptionPassword(2, stringPattern);
                    }
                }
                this.setBoolean("lockscreen.patterneverchosen", true);
                if (!isFallback) {
                    this.deleteGallery();
                    this.setLong("lockscreen.password_type", 65536L);
                    dpm.setActivePasswordState(65536, pattern.size(), 0, 0, 0, 0, 0, 0, userId);
                } else {
                    this.setLong("lockscreen.password_type", 32768L);
                    this.setLong("lockscreen.password_type_alternate", 65536L);
                    this.finishBiometricWeak();
                    dpm.setActivePasswordState(32768, 0, 0, 0, 0, 0, 0, 0, userId);
                }
            } else {
                dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userId);
            }
            this.onAfterChangingPassword();
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Couldn't save lock pattern " + re);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$updateCryptoUserInfo() {
        int userId = this.getCurrentOrCallingUserId();
        if (userId != 0) {
            return;
        }
        String ownerInfo = this.isOwnerInfoEnabled() ? this.getOwnerInfo(userId) : "";
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e("LockPatternUtils", "Could not find the mount service to update the user info");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            Log.d("LockPatternUtils", "Setting owner info");
            mountService.setField("OwnerInfo", ownerInfo);
        }
        catch (RemoteException e) {
            Log.e("LockPatternUtils", "Error changing user info", e);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setOwnerInfo(String info, int userId) {
        this.setString("lock_screen_owner_info", info, userId);
        this.updateCryptoUserInfo();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setOwnerInfoEnabled(boolean enabled) {
        this.setBoolean("lock_screen_owner_info_enabled", enabled);
        this.updateCryptoUserInfo();
    }

    private final String $$robo$$com_android_internal_widget_LockPatternUtils$getOwnerInfo(int userId) {
        return this.getString("lock_screen_owner_info");
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isOwnerInfoEnabled() {
        return this.getBoolean("lock_screen_owner_info_enabled", false);
    }

    private static final int $$robo$$com_android_internal_widget_LockPatternUtils$computePasswordQuality(String password) {
        boolean hasDigit = false;
        boolean hasNonDigit = false;
        int len = password.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(password.charAt(i))) {
                hasDigit = true;
                continue;
            }
            hasNonDigit = true;
        }
        if (hasNonDigit && hasDigit) {
            return 327680;
        }
        if (hasNonDigit) {
            return 262144;
        }
        if (hasDigit) {
            return LockPatternUtils.maxLengthSequence(password) > 3 ? 131072 : 196608;
        }
        return 0;
    }

    private static final int $$robo$$com_android_internal_widget_LockPatternUtils$categoryChar(char c) {
        if ('a' <= c && c <= 'z') {
            return 0;
        }
        if ('A' <= c && c <= 'Z') {
            return 1;
        }
        if ('0' <= c && c <= '9') {
            return 2;
        }
        return 3;
    }

    private static final int $$robo$$com_android_internal_widget_LockPatternUtils$maxDiffCategory(int category) {
        if (category == 0 || category == 1) {
            return 1;
        }
        if (category == 2) {
            return 10;
        }
        return 0;
    }

    private static final int $$robo$$com_android_internal_widget_LockPatternUtils$maxLengthSequence(String string2) {
        if (string2.length() == 0) {
            return 0;
        }
        char previousChar = string2.charAt(0);
        int category = LockPatternUtils.categoryChar(previousChar);
        int diff = 0;
        boolean hasDiff = false;
        int maxLength = 0;
        int startSequence = 0;
        for (int current = 1; current < string2.length(); ++current) {
            char currentChar = string2.charAt(current);
            int categoryCurrent = LockPatternUtils.categoryChar(currentChar);
            int currentDiff = currentChar - previousChar;
            if (categoryCurrent != category || Math.abs(currentDiff) > LockPatternUtils.maxDiffCategory(category)) {
                maxLength = Math.max(maxLength, current - startSequence);
                startSequence = current;
                hasDiff = false;
                category = categoryCurrent;
            } else {
                if (hasDiff && currentDiff != diff) {
                    maxLength = Math.max(maxLength, current - startSequence);
                    startSequence = current - 1;
                }
                diff = currentDiff;
                hasDiff = true;
            }
            previousChar = currentChar;
        }
        maxLength = Math.max(maxLength, string2.length() - startSequence);
        return maxLength;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$updateEncryptionPassword(int type, String password) {
        if (!LockPatternUtils.isDeviceEncryptionEnabled()) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e("LockPatternUtils", "Could not find the mount service to update the encryption password");
            return;
        }
        new AsyncTask<Void, Void, Void>(this, service, type, password){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IBinder val$service;
            /* synthetic */ int val$type;
            /* synthetic */ String val$password;
            /* synthetic */ LockPatternUtils this$0;

            private void $$robo$$com_android_internal_widget_LockPatternUtils_1$__constructor__(LockPatternUtils lockPatternUtils, IBinder iBinder, int n, String string2) {
            }

            private final Void $$robo$$com_android_internal_widget_LockPatternUtils_1$doInBackground(Void ... dummy) {
                IMountService mountService = IMountService.Stub.asInterface(this.val$service);
                try {
                    mountService.changeEncryptionPassword(this.val$type, this.val$password);
                }
                catch (RemoteException e) {
                    Log.e("LockPatternUtils", "Error changing encryption password", e);
                }
                return null;
            }

            private void __constructor__(LockPatternUtils lockPatternUtils, IBinder iBinder, int n, String string2) {
                this.$$robo$$com_android_internal_widget_LockPatternUtils_1$__constructor__(lockPatternUtils, iBinder, n, string2);
            }
            {
                this.this$0 = lockPatternUtils;
                this.val$service = iBinder;
                this.val$type = n;
                this.val$password = string2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternUtils_1$__constructor__(com.android.internal.widget.LockPatternUtils android.os.IBinder int java.lang.String ), 0, this, lockPatternUtils, iBinder, n, string2);
            }

            protected Void doInBackground(Void ... voidArray) {
                return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$com_android_internal_widget_LockPatternUtils_1$doInBackground(java.lang.Void[] ), 0, this, voidArray);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.execute(new Void[0]);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPassword(String password, int quality) {
        this.saveLockPassword(password, quality, false, this.getCurrentOrCallingUserId());
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPassword(String password, int quality, boolean isFallback) {
        this.saveLockPassword(password, quality, isFallback, this.getCurrentOrCallingUserId());
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPassword(String password, int quality, boolean isFallback, int userHandle) {
        try {
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (!TextUtils.isEmpty(password)) {
                int passwordHistoryLength;
                this.getLockSettings().setLockPassword(password, userHandle);
                int computedQuality = LockPatternUtils.computePasswordQuality(password);
                if (userHandle == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
                    if (!this.isCredentialRequiredToDecrypt(true)) {
                        this.clearEncryptionPassword();
                    } else {
                        boolean numeric = computedQuality == 131072;
                        boolean numericComplex = computedQuality == 196608;
                        int type = numeric || numericComplex ? 3 : 0;
                        this.updateEncryptionPassword(type, password);
                    }
                }
                if (!isFallback) {
                    this.deleteGallery();
                    this.setLong("lockscreen.password_type", Math.max(quality, computedQuality), userHandle);
                    if (computedQuality != 0) {
                        int letters = 0;
                        int uppercase = 0;
                        int lowercase = 0;
                        int numbers = 0;
                        int symbols = 0;
                        int nonletter = 0;
                        for (int i = 0; i < password.length(); ++i) {
                            char c = password.charAt(i);
                            if (c >= 'A' && c <= 'Z') {
                                ++letters;
                                ++uppercase;
                                continue;
                            }
                            if (c >= 'a' && c <= 'z') {
                                ++letters;
                                ++lowercase;
                                continue;
                            }
                            if (c >= '0' && c <= '9') {
                                ++numbers;
                                ++nonletter;
                                continue;
                            }
                            ++symbols;
                            ++nonletter;
                        }
                        dpm.setActivePasswordState(Math.max(quality, computedQuality), password.length(), letters, uppercase, lowercase, numbers, symbols, nonletter, userHandle);
                    } else {
                        dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userHandle);
                    }
                } else {
                    this.setLong("lockscreen.password_type", 32768L, userHandle);
                    this.setLong("lockscreen.password_type_alternate", Math.max(quality, computedQuality), userHandle);
                    this.finishBiometricWeak();
                    dpm.setActivePasswordState(32768, 0, 0, 0, 0, 0, 0, 0, userHandle);
                }
                String passwordHistory = this.getString("lockscreen.passwordhistory", userHandle);
                if (passwordHistory == null) {
                    passwordHistory = new String();
                }
                if ((passwordHistoryLength = this.getRequestedPasswordHistoryLength()) == 0) {
                    passwordHistory = "";
                } else {
                    byte[] hash = this.passwordToHash(password, userHandle);
                    passwordHistory = new String(hash) + "," + passwordHistory;
                    passwordHistory = passwordHistory.substring(0, Math.min(hash.length * passwordHistoryLength + passwordHistoryLength - 1, passwordHistory.length()));
                }
                this.setString("lockscreen.passwordhistory", passwordHistory, userHandle);
            } else {
                this.getLockSettings().setLockPassword(null, userHandle);
                if (userHandle == 0) {
                    this.updateEncryptionPassword(1, null);
                }
                dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userHandle);
            }
            this.onAfterChangingPassword();
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Unable to save lock password " + re);
        }
    }

    private static final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isDeviceEncrypted() {
        IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        try {
            return mountService.getEncryptionState() != 1 && mountService.getPasswordType() != 1;
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Error getting encryption state", re);
            return true;
        }
    }

    private static final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isDeviceEncryptionEnabled() {
        String status = SystemProperties.get("ro.crypto.state", "unsupported");
        return "encrypted".equalsIgnoreCase(status);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$clearEncryptionPassword() {
        this.updateEncryptionPassword(1, null);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getKeyguardStoredPasswordQuality() {
        return this.getKeyguardStoredPasswordQuality(this.getCurrentOrCallingUserId());
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getKeyguardStoredPasswordQuality(int userHandle) {
        int quality = (int)this.getLong("lockscreen.password_type", 0L, userHandle);
        if (quality == 32768) {
            quality = (int)this.getLong("lockscreen.password_type_alternate", 0L, userHandle);
        }
        return quality;
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$usingBiometricWeak() {
        int quality = (int)this.getLong("lockscreen.password_type", 0L);
        return quality == 32768;
    }

    private static final List<LockPatternView.Cell> $$robo$$com_android_internal_widget_LockPatternUtils$stringToPattern(String string2) {
        ArrayList<LockPatternView.Cell> result = Lists.newArrayList();
        byte[] bytes = string2.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            result.add(LockPatternView.Cell.of(b / 3, b % 3));
        }
        return result;
    }

    private static final String $$robo$$com_android_internal_widget_LockPatternUtils$patternToString(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return "";
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        return new String(res);
    }

    private static final byte[] $$robo$$com_android_internal_widget_LockPatternUtils$patternToHash(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return null;
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(res);
            return hash;
        }
        catch (NoSuchAlgorithmException nsa) {
            return res;
        }
    }

    private final String $$robo$$com_android_internal_widget_LockPatternUtils$getSalt(int userId) {
        long salt = this.getLong("lockscreen.password_salt", 0L, userId);
        if (salt == 0L) {
            try {
                salt = SecureRandom.getInstance("SHA1PRNG").nextLong();
                this.setLong("lockscreen.password_salt", salt, userId);
                Log.v("LockPatternUtils", "Initialized lock password salt for user: " + userId);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Couldn't get SecureRandom number", e);
            }
        }
        return Long.toHexString(salt);
    }

    private final byte[] $$robo$$com_android_internal_widget_LockPatternUtils$passwordToHash(String password, int userId) {
        if (password == null) {
            return null;
        }
        String algo = null;
        byte[] hashed = null;
        try {
            byte[] saltedPassword = (password + this.getSalt(userId)).getBytes();
            algo = "SHA-1";
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(saltedPassword);
            algo = "MD5";
            byte[] md5 = MessageDigest.getInstance("MD5").digest(saltedPassword);
            hashed = (LockPatternUtils.toHex(sha1) + LockPatternUtils.toHex(md5)).getBytes();
        }
        catch (NoSuchAlgorithmException e) {
            Log.w("LockPatternUtils", "Failed to encode string because of missing algorithm: " + algo);
        }
        return hashed;
    }

    private static final String $$robo$$com_android_internal_widget_LockPatternUtils$toHex(byte[] ary) {
        String hex = "0123456789ABCDEF";
        String ret = "";
        for (int i = 0; i < ary.length; ++i) {
            ret = ret + "0123456789ABCDEF".charAt(ary[i] >> 4 & 0xF);
            ret = ret + "0123456789ABCDEF".charAt(ary[i] & 0xF);
        }
        return ret;
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isLockPasswordEnabled() {
        long mode = this.getLong("lockscreen.password_type", 0L);
        long backupMode = this.getLong("lockscreen.password_type_alternate", 0L);
        boolean passwordEnabled = mode == 262144L || mode == 131072L || mode == 196608L || mode == 327680L || mode == 393216L;
        boolean backupEnabled = backupMode == 262144L || backupMode == 131072L || backupMode == 196608L || backupMode == 327680L || backupMode == 393216L;
        return this.savedPasswordExists() && (passwordEnabled || this.usingBiometricWeak() && backupEnabled);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isLockPatternEnabled() {
        boolean backupEnabled = this.getLong("lockscreen.password_type_alternate", 0L) == 65536L;
        return this.getBoolean("lock_pattern_autolock", false) && (this.getLong("lockscreen.password_type", 0L) == 65536L || this.usingBiometricWeak() && backupEnabled);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isBiometricWeakInstalled() {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            pm.getPackageInfo("com.android.facelock", 1);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        if (!pm.hasSystemFeature("android.hardware.camera.front")) {
            return false;
        }
        if (this.getDevicePolicyManager().getCameraDisabled(null, this.getCurrentOrCallingUserId())) {
            return false;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setBiometricWeakLivelinessEnabled(boolean enabled) {
        long currentFlag = this.getLong("lock_biometric_weak_flags", 0L);
        long newFlag = enabled ? currentFlag | 1L : currentFlag & 0xFFFFFFFFFFFFFFFEL;
        this.setLong("lock_biometric_weak_flags", newFlag);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isBiometricWeakLivelinessEnabled() {
        long currentFlag = this.getLong("lock_biometric_weak_flags", 0L);
        return (currentFlag & 1L) != 0L;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setLockPatternEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_autolock", enabled);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isVisiblePatternEnabled() {
        return this.getBoolean("lock_pattern_visible_pattern", false);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setVisiblePatternEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_visible_pattern", enabled);
        int userId = this.getCurrentOrCallingUserId();
        if (userId != 0) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e("LockPatternUtils", "Could not find the mount service to update the user info");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            mountService.setField("PatternVisible", enabled ? "1" : "0");
        }
        catch (RemoteException e) {
            Log.e("LockPatternUtils", "Error changing pattern visible state", e);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isTactileFeedbackEnabled() {
        return Settings.System.getIntForUser(this.mContentResolver, "haptic_feedback_enabled", 1, -2) != 0;
    }

    private final long $$robo$$com_android_internal_widget_LockPatternUtils$setLockoutAttemptDeadline() {
        long deadline = SystemClock.elapsedRealtime() + 30000L;
        this.setLong("lockscreen.lockoutattemptdeadline", deadline);
        return deadline;
    }

    private final long $$robo$$com_android_internal_widget_LockPatternUtils$getLockoutAttemptDeadline() {
        long now;
        long deadline = this.getLong("lockscreen.lockoutattemptdeadline", 0L);
        if (deadline < (now = SystemClock.elapsedRealtime()) || deadline > now + 30000L) {
            return 0L;
        }
        return deadline;
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isPermanentlyLocked() {
        return this.getBoolean("lockscreen.lockedoutpermanently", false);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setPermanentlyLocked(boolean locked) {
        this.setBoolean("lockscreen.lockedoutpermanently", locked);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isEmergencyCallCapable() {
        return this.mContext.getResources().getBoolean(17956931);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isPukUnlockScreenEnable() {
        return this.mContext.getResources().getBoolean(17956917);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isEmergencyCallEnabledWhileSimLocked() {
        return this.mContext.getResources().getBoolean(17956918);
    }

    private final AlarmManager.AlarmClockInfo $$robo$$com_android_internal_widget_LockPatternUtils$getNextAlarm() {
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        return alarmManager.getNextAlarmClock(-2);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$getBoolean(String secureSettingKey, boolean defaultValue, int userId) {
        try {
            return this.getLockSettings().getBoolean(secureSettingKey, defaultValue, userId);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$getBoolean(String secureSettingKey, boolean defaultValue) {
        return this.getBoolean(secureSettingKey, defaultValue, this.getCurrentOrCallingUserId());
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setBoolean(String secureSettingKey, boolean enabled, int userId) {
        try {
            this.getLockSettings().setBoolean(secureSettingKey, enabled, userId);
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Couldn't write boolean " + secureSettingKey + re);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setBoolean(String secureSettingKey, boolean enabled) {
        this.setBoolean(secureSettingKey, enabled, this.getCurrentOrCallingUserId());
    }

    private final int[] $$robo$$com_android_internal_widget_LockPatternUtils$getAppWidgets() {
        return this.getAppWidgets(-2);
    }

    private final int[] $$robo$$com_android_internal_widget_LockPatternUtils$getAppWidgets(int userId) {
        String appWidgetIdString = Settings.Secure.getStringForUser(this.mContentResolver, "lock_screen_appwidget_ids", userId);
        String delims = ",";
        if (appWidgetIdString != null && appWidgetIdString.length() > 0) {
            String[] appWidgetStringIds = appWidgetIdString.split(delims);
            int[] appWidgetIds = new int[appWidgetStringIds.length];
            for (int i = 0; i < appWidgetStringIds.length; ++i) {
                String appWidget = appWidgetStringIds[i];
                try {
                    appWidgetIds[i] = Integer.decode(appWidget);
                    continue;
                }
                catch (NumberFormatException e) {
                    Log.d("LockPatternUtils", "Error when parsing widget id " + appWidget);
                    return null;
                }
            }
            return appWidgetIds;
        }
        return new int[0];
    }

    private static final String $$robo$$com_android_internal_widget_LockPatternUtils$combineStrings(int[] list, String separator) {
        int listLength = list.length;
        switch (listLength) {
            case 0: {
                return "";
            }
            case 1: {
                return Integer.toString(list[0]);
            }
        }
        int strLength = 0;
        int separatorLength = separator.length();
        String[] stringList = new String[list.length];
        for (int i = 0; i < listLength; ++i) {
            stringList[i] = Integer.toString(list[i]);
            strLength += stringList[i].length();
            if (i >= listLength - 1) continue;
            strLength += separatorLength;
        }
        StringBuilder sb = new StringBuilder(strLength);
        for (int i = 0; i < listLength; ++i) {
            sb.append(list[i]);
            if (i >= listLength - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$writeFallbackAppWidgetId(int appWidgetId) {
        Settings.Secure.putIntForUser(this.mContentResolver, "lock_screen_fallback_appwidget_id", appWidgetId, -2);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getFallbackAppWidgetId() {
        return Settings.Secure.getIntForUser(this.mContentResolver, "lock_screen_fallback_appwidget_id", 0, -2);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$writeAppWidgets(int[] appWidgetIds) {
        Settings.Secure.putStringForUser(this.mContentResolver, "lock_screen_appwidget_ids", LockPatternUtils.combineStrings(appWidgetIds, ","), -2);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$addAppWidget(int widgetId, int index) {
        int[] widgets = this.getAppWidgets();
        if (widgets == null) {
            return false;
        }
        if (index < 0 || index > widgets.length) {
            return false;
        }
        int[] newWidgets = new int[widgets.length + 1];
        int j = 0;
        for (int i = 0; i < newWidgets.length; ++i) {
            if (index == i) {
                newWidgets[i] = widgetId;
                ++i;
            }
            if (i >= newWidgets.length) continue;
            newWidgets[i] = widgets[j];
            ++j;
        }
        this.writeAppWidgets(newWidgets);
        return true;
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$removeAppWidget(int widgetId) {
        int[] widgets = this.getAppWidgets();
        if (widgets.length == 0) {
            return false;
        }
        int[] newWidgets = new int[widgets.length - 1];
        int j = 0;
        for (int i = 0; i < widgets.length; ++i) {
            if (widgets[i] == widgetId) continue;
            if (j >= newWidgets.length) {
                return false;
            }
            newWidgets[j] = widgets[i];
            ++j;
        }
        this.writeAppWidgets(newWidgets);
        return true;
    }

    private final long $$robo$$com_android_internal_widget_LockPatternUtils$getLong(String secureSettingKey, long defaultValue, int userHandle) {
        try {
            return this.getLockSettings().getLong(secureSettingKey, defaultValue, userHandle);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private final long $$robo$$com_android_internal_widget_LockPatternUtils$getLong(String secureSettingKey, long defaultValue) {
        try {
            return this.getLockSettings().getLong(secureSettingKey, defaultValue, this.getCurrentOrCallingUserId());
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setLong(String secureSettingKey, long value) {
        this.setLong(secureSettingKey, value, this.getCurrentOrCallingUserId());
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setLong(String secureSettingKey, long value, int userHandle) {
        try {
            this.getLockSettings().setLong(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Couldn't write long " + secureSettingKey + re);
        }
    }

    private final String $$robo$$com_android_internal_widget_LockPatternUtils$getString(String secureSettingKey) {
        return this.getString(secureSettingKey, this.getCurrentOrCallingUserId());
    }

    private final String $$robo$$com_android_internal_widget_LockPatternUtils$getString(String secureSettingKey, int userHandle) {
        try {
            return this.getLockSettings().getString(secureSettingKey, null, userHandle);
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setString(String secureSettingKey, String value, int userHandle) {
        try {
            this.getLockSettings().setString(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Couldn't write string " + secureSettingKey + re);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isSecure() {
        long mode = this.getKeyguardStoredPasswordQuality();
        boolean isPattern = mode == 65536L;
        boolean isPassword = mode == 131072L || mode == 196608L || mode == 262144L || mode == 327680L || mode == 393216L;
        boolean secure = isPattern && this.isLockPatternEnabled() && this.savedPatternExists() || isPassword && this.savedPasswordExists();
        return secure;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$updateEmergencyCallButtonState(Button button, boolean shown, boolean showIcon) {
        int textId;
        if (!this.isEmergencyCallCapable() || !shown) {
            button.setVisibility(8);
            return;
        }
        button.setVisibility(0);
        if (this.isInCall()) {
            textId = 17040242;
            int phoneCallIcon = showIcon ? 17301636 : 0;
            button.setCompoundDrawablesWithIntrinsicBounds(phoneCallIcon, 0, 0, 0);
        } else {
            textId = 17040241;
            int emergencyIcon = showIcon ? 17302368 : 0;
            button.setCompoundDrawablesWithIntrinsicBounds(emergencyIcon, 0, 0, 0);
        }
        button.setText(textId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$resumeCall() {
        this.getTelecommManager().showInCallScreen(false);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isInCall() {
        return this.getTelecommManager().isInCall();
    }

    private final TelecomManager $$robo$$com_android_internal_widget_LockPatternUtils$getTelecommManager() {
        return (TelecomManager)this.mContext.getSystemService("telecom");
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$finishBiometricWeak() {
        this.setBoolean("lockscreen.biometricweakeverchosen", true);
        Intent intent = new Intent();
        intent.setClassName("com.android.facelock", "com.android.facelock.SetupEndScreen");
        this.mContext.startActivity(intent);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setPowerButtonInstantlyLocks(boolean enabled) {
        this.setBoolean("lockscreen.power_button_instantly_locks", enabled);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$getPowerButtonInstantlyLocks() {
        return this.getBoolean("lockscreen.power_button_instantly_locks", true);
    }

    private static final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isSafeModeEnabled() {
        try {
            return IWindowManager.Stub.asInterface(ServiceManager.getService("window")).isSafeModeEnabled();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$hasWidgetsEnabledInKeyguard(int userid) {
        int[] widgets = this.getAppWidgets(userid);
        for (int i = 0; i < widgets.length; ++i) {
            if (widgets[i] <= 0) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$getWidgetsEnabled() {
        return this.getWidgetsEnabled(this.getCurrentOrCallingUserId());
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$getWidgetsEnabled(int userId) {
        return this.getBoolean("lockscreen.widgets_enabled", false, userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setWidgetsEnabled(boolean enabled) {
        this.setWidgetsEnabled(enabled, this.getCurrentOrCallingUserId());
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setWidgetsEnabled(boolean enabled, int userId) {
        this.setBoolean("lockscreen.widgets_enabled", enabled, userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setEnabledTrustAgents(Collection<ComponentName> activeTrustAgents) {
        this.setEnabledTrustAgents(activeTrustAgents, this.getCurrentOrCallingUserId());
    }

    private final List<ComponentName> $$robo$$com_android_internal_widget_LockPatternUtils$getEnabledTrustAgents() {
        return this.getEnabledTrustAgents(this.getCurrentOrCallingUserId());
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setEnabledTrustAgents(Collection<ComponentName> activeTrustAgents, int userId) {
        StringBuilder sb = new StringBuilder();
        for (ComponentName cn : activeTrustAgents) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(cn.flattenToShortString());
        }
        this.setString("lockscreen.enabledtrustagents", sb.toString(), userId);
        this.getTrustManager().reportEnabledTrustAgentsChanged(this.getCurrentOrCallingUserId());
    }

    private final List<ComponentName> $$robo$$com_android_internal_widget_LockPatternUtils$getEnabledTrustAgents(int userId) {
        String serialized = this.getString("lockscreen.enabledtrustagents", userId);
        if (TextUtils.isEmpty(serialized)) {
            return null;
        }
        String[] split = serialized.split(",");
        ArrayList<ComponentName> activeTrustAgents = new ArrayList<ComponentName>(split.length);
        for (String s : split) {
            if (TextUtils.isEmpty(s)) continue;
            activeTrustAgents.add(ComponentName.unflattenFromString(s));
        }
        return activeTrustAgents;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$requireCredentialEntry(int userId) {
        this.getTrustManager().reportRequireCredentialEntry(userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$onAfterChangingPassword() {
        this.getTrustManager().reportEnabledTrustAgentsChanged(this.getCurrentOrCallingUserId());
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isCredentialRequiredToDecrypt(boolean defaultValue) {
        int value = Settings.Global.getInt(this.mContentResolver, "require_password_to_decrypt", -1);
        return value == -1 ? defaultValue : value != 0;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setCredentialRequiredToDecrypt(boolean required) {
        if (this.getCurrentUser() != 0) {
            Log.w("LockPatternUtils", "Only device owner may call setCredentialRequiredForDecrypt()");
            return;
        }
        Settings.Global.putInt(this.mContext.getContentResolver(), "require_password_to_decrypt", required ? 1 : 0);
    }

    static void __staticInitializer__() {
        sCurrentUserId = -10000;
    }

    public DevicePolicyManager getDevicePolicyManager() {
        return InvokeDynamicSupport.bootstrap("getDevicePolicyManager", $$robo$$com_android_internal_widget_LockPatternUtils$getDevicePolicyManager(), 0, this);
    }

    private TrustManager getTrustManager() {
        return InvokeDynamicSupport.bootstrap("getTrustManager", $$robo$$com_android_internal_widget_LockPatternUtils$getTrustManager(), 0, this);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_LockPatternUtils$__constructor__(context);
    }

    public LockPatternUtils(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternUtils$__constructor__(android.content.Context ), 0, this, context);
    }

    private ILockSettings getLockSettings() {
        return InvokeDynamicSupport.bootstrap("getLockSettings", $$robo$$com_android_internal_widget_LockPatternUtils$getLockSettings(), 0, this);
    }

    public int getRequestedMinimumPasswordLength() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedMinimumPasswordLength", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedMinimumPasswordLength(), 0, this);
    }

    public int getRequestedPasswordQuality() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordQuality", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordQuality(), 0, this);
    }

    public int getRequestedPasswordHistoryLength() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordHistoryLength", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordHistoryLength(), 0, this);
    }

    public int getRequestedPasswordMinimumLetters() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumLetters", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumLetters(), 0, this);
    }

    public int getRequestedPasswordMinimumUpperCase() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumUpperCase", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumUpperCase(), 0, this);
    }

    public int getRequestedPasswordMinimumLowerCase() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumLowerCase", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumLowerCase(), 0, this);
    }

    public int getRequestedPasswordMinimumNumeric() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumNumeric", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumNumeric(), 0, this);
    }

    public int getRequestedPasswordMinimumSymbols() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumSymbols", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumSymbols(), 0, this);
    }

    public int getRequestedPasswordMinimumNonLetter() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumNonLetter", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumNonLetter(), 0, this);
    }

    public void reportFailedPasswordAttempt() {
        InvokeDynamicSupport.bootstrap("reportFailedPasswordAttempt", $$robo$$com_android_internal_widget_LockPatternUtils$reportFailedPasswordAttempt(), 0, this);
    }

    public void reportSuccessfulPasswordAttempt() {
        InvokeDynamicSupport.bootstrap("reportSuccessfulPasswordAttempt", $$robo$$com_android_internal_widget_LockPatternUtils$reportSuccessfulPasswordAttempt(), 0, this);
    }

    public void setCurrentUser(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentUser", $$robo$$com_android_internal_widget_LockPatternUtils$setCurrentUser(int ), 0, this, n);
    }

    public int getCurrentUser() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentUser", $$robo$$com_android_internal_widget_LockPatternUtils$getCurrentUser(), 0, this);
    }

    public void removeUser(int n) {
        InvokeDynamicSupport.bootstrap("removeUser", $$robo$$com_android_internal_widget_LockPatternUtils$removeUser(int ), 0, this, n);
    }

    private int getCurrentOrCallingUserId() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentOrCallingUserId", $$robo$$com_android_internal_widget_LockPatternUtils$getCurrentOrCallingUserId(), 0, this);
    }

    public boolean checkPattern(List<LockPatternView.Cell> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkPattern", $$robo$$com_android_internal_widget_LockPatternUtils$checkPattern(java.util.List<com.android.internal.widget.LockPatternView$Cell> ), 0, this, list);
    }

    public boolean checkPassword(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkPassword", $$robo$$com_android_internal_widget_LockPatternUtils$checkPassword(java.lang.String ), 0, this, string2);
    }

    public boolean checkVoldPassword() {
        return (boolean)InvokeDynamicSupport.bootstrap("checkVoldPassword", $$robo$$com_android_internal_widget_LockPatternUtils$checkVoldPassword(), 0, this);
    }

    public boolean checkPasswordHistory(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkPasswordHistory", $$robo$$com_android_internal_widget_LockPatternUtils$checkPasswordHistory(java.lang.String ), 0, this, string2);
    }

    public boolean savedPatternExists() {
        return (boolean)InvokeDynamicSupport.bootstrap("savedPatternExists", $$robo$$com_android_internal_widget_LockPatternUtils$savedPatternExists(), 0, this);
    }

    public boolean savedPasswordExists() {
        return (boolean)InvokeDynamicSupport.bootstrap("savedPasswordExists", $$robo$$com_android_internal_widget_LockPatternUtils$savedPasswordExists(), 0, this);
    }

    public boolean isPatternEverChosen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPatternEverChosen", $$robo$$com_android_internal_widget_LockPatternUtils$isPatternEverChosen(), 0, this);
    }

    public boolean isBiometricWeakEverChosen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBiometricWeakEverChosen", $$robo$$com_android_internal_widget_LockPatternUtils$isBiometricWeakEverChosen(), 0, this);
    }

    public int getActivePasswordQuality() {
        return (int)InvokeDynamicSupport.bootstrap("getActivePasswordQuality", $$robo$$com_android_internal_widget_LockPatternUtils$getActivePasswordQuality(), 0, this);
    }

    public void clearLock(boolean bl) {
        InvokeDynamicSupport.bootstrap("clearLock", $$robo$$com_android_internal_widget_LockPatternUtils$clearLock(boolean ), 0, this, bl);
    }

    public void setLockScreenDisabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLockScreenDisabled", $$robo$$com_android_internal_widget_LockPatternUtils$setLockScreenDisabled(boolean ), 0, this, bl);
    }

    public boolean isLockScreenDisabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLockScreenDisabled", $$robo$$com_android_internal_widget_LockPatternUtils$isLockScreenDisabled(), 0, this);
    }

    public void deleteTempGallery() {
        InvokeDynamicSupport.bootstrap("deleteTempGallery", $$robo$$com_android_internal_widget_LockPatternUtils$deleteTempGallery(), 0, this);
    }

    void deleteGallery() {
        InvokeDynamicSupport.bootstrap("deleteGallery", $$robo$$com_android_internal_widget_LockPatternUtils$deleteGallery(), 0, this);
    }

    public void saveLockPattern(List<LockPatternView.Cell> list) {
        InvokeDynamicSupport.bootstrap("saveLockPattern", $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPattern(java.util.List<com.android.internal.widget.LockPatternView$Cell> ), 0, this, list);
    }

    public void saveLockPattern(List<LockPatternView.Cell> list, boolean bl) {
        InvokeDynamicSupport.bootstrap("saveLockPattern", $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPattern(java.util.List<com.android.internal.widget.LockPatternView$Cell> boolean ), 0, this, list, bl);
    }

    private void updateCryptoUserInfo() {
        InvokeDynamicSupport.bootstrap("updateCryptoUserInfo", $$robo$$com_android_internal_widget_LockPatternUtils$updateCryptoUserInfo(), 0, this);
    }

    public void setOwnerInfo(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setOwnerInfo", $$robo$$com_android_internal_widget_LockPatternUtils$setOwnerInfo(java.lang.String int ), 0, this, string2, n);
    }

    public void setOwnerInfoEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOwnerInfoEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setOwnerInfoEnabled(boolean ), 0, this, bl);
    }

    public String getOwnerInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getOwnerInfo", $$robo$$com_android_internal_widget_LockPatternUtils$getOwnerInfo(int ), 0, this, n);
    }

    public boolean isOwnerInfoEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOwnerInfoEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isOwnerInfoEnabled(), 0, this);
    }

    public static int computePasswordQuality(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("computePasswordQuality", $$robo$$com_android_internal_widget_LockPatternUtils$computePasswordQuality(java.lang.String ), 0, (String)string2);
    }

    private static int categoryChar(char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("categoryChar", $$robo$$com_android_internal_widget_LockPatternUtils$categoryChar(char ), 0, (char)c);
    }

    private static int maxDiffCategory(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("maxDiffCategory", $$robo$$com_android_internal_widget_LockPatternUtils$maxDiffCategory(int ), 0, (int)n);
    }

    public static int maxLengthSequence(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("maxLengthSequence", $$robo$$com_android_internal_widget_LockPatternUtils$maxLengthSequence(java.lang.String ), 0, (String)string2);
    }

    private void updateEncryptionPassword(int n, String string2) {
        InvokeDynamicSupport.bootstrap("updateEncryptionPassword", $$robo$$com_android_internal_widget_LockPatternUtils$updateEncryptionPassword(int java.lang.String ), 0, this, n, string2);
    }

    public void saveLockPassword(String string2, int n) {
        InvokeDynamicSupport.bootstrap("saveLockPassword", $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPassword(java.lang.String int ), 0, this, string2, n);
    }

    public void saveLockPassword(String string2, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("saveLockPassword", $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPassword(java.lang.String int boolean ), 0, this, string2, n, bl);
    }

    public void saveLockPassword(String string2, int n, boolean bl, int n2) {
        InvokeDynamicSupport.bootstrap("saveLockPassword", $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPassword(java.lang.String int boolean int ), 0, this, string2, n, bl, n2);
    }

    public static boolean isDeviceEncrypted() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDeviceEncrypted", $$robo$$com_android_internal_widget_LockPatternUtils$isDeviceEncrypted(), 0);
    }

    public static boolean isDeviceEncryptionEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDeviceEncryptionEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isDeviceEncryptionEnabled(), 0);
    }

    public void clearEncryptionPassword() {
        InvokeDynamicSupport.bootstrap("clearEncryptionPassword", $$robo$$com_android_internal_widget_LockPatternUtils$clearEncryptionPassword(), 0, this);
    }

    public int getKeyguardStoredPasswordQuality() {
        return (int)InvokeDynamicSupport.bootstrap("getKeyguardStoredPasswordQuality", $$robo$$com_android_internal_widget_LockPatternUtils$getKeyguardStoredPasswordQuality(), 0, this);
    }

    public int getKeyguardStoredPasswordQuality(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getKeyguardStoredPasswordQuality", $$robo$$com_android_internal_widget_LockPatternUtils$getKeyguardStoredPasswordQuality(int ), 0, this, n);
    }

    public boolean usingBiometricWeak() {
        return (boolean)InvokeDynamicSupport.bootstrap("usingBiometricWeak", $$robo$$com_android_internal_widget_LockPatternUtils$usingBiometricWeak(), 0, this);
    }

    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("stringToPattern", $$robo$$com_android_internal_widget_LockPatternUtils$stringToPattern(java.lang.String ), 0, (String)string2);
    }

    public static String patternToString(List<LockPatternView.Cell> list) {
        return InvokeDynamicSupport.bootstrapStatic("patternToString", $$robo$$com_android_internal_widget_LockPatternUtils$patternToString(java.util.List<com.android.internal.widget.LockPatternView$Cell> ), 0, list);
    }

    public static byte[] patternToHash(List<LockPatternView.Cell> list) {
        return InvokeDynamicSupport.bootstrapStatic("patternToHash", $$robo$$com_android_internal_widget_LockPatternUtils$patternToHash(java.util.List<com.android.internal.widget.LockPatternView$Cell> ), 0, list);
    }

    private String getSalt(int n) {
        return InvokeDynamicSupport.bootstrap("getSalt", $$robo$$com_android_internal_widget_LockPatternUtils$getSalt(int ), 0, this, n);
    }

    public byte[] passwordToHash(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("passwordToHash", $$robo$$com_android_internal_widget_LockPatternUtils$passwordToHash(java.lang.String int ), 0, this, string2, n);
    }

    private static String toHex(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("toHex", $$robo$$com_android_internal_widget_LockPatternUtils$toHex(byte[] ), 0, (byte[])byArray);
    }

    public boolean isLockPasswordEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLockPasswordEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isLockPasswordEnabled(), 0, this);
    }

    public boolean isLockPatternEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLockPatternEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isLockPatternEnabled(), 0, this);
    }

    public boolean isBiometricWeakInstalled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBiometricWeakInstalled", $$robo$$com_android_internal_widget_LockPatternUtils$isBiometricWeakInstalled(), 0, this);
    }

    public void setBiometricWeakLivelinessEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBiometricWeakLivelinessEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setBiometricWeakLivelinessEnabled(boolean ), 0, this, bl);
    }

    public boolean isBiometricWeakLivelinessEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBiometricWeakLivelinessEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isBiometricWeakLivelinessEnabled(), 0, this);
    }

    public void setLockPatternEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLockPatternEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setLockPatternEnabled(boolean ), 0, this, bl);
    }

    public boolean isVisiblePatternEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisiblePatternEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isVisiblePatternEnabled(), 0, this);
    }

    public void setVisiblePatternEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setVisiblePatternEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setVisiblePatternEnabled(boolean ), 0, this, bl);
    }

    public boolean isTactileFeedbackEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTactileFeedbackEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isTactileFeedbackEnabled(), 0, this);
    }

    public long setLockoutAttemptDeadline() {
        return (long)InvokeDynamicSupport.bootstrap("setLockoutAttemptDeadline", $$robo$$com_android_internal_widget_LockPatternUtils$setLockoutAttemptDeadline(), 0, this);
    }

    public long getLockoutAttemptDeadline() {
        return (long)InvokeDynamicSupport.bootstrap("getLockoutAttemptDeadline", $$robo$$com_android_internal_widget_LockPatternUtils$getLockoutAttemptDeadline(), 0, this);
    }

    public boolean isPermanentlyLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPermanentlyLocked", $$robo$$com_android_internal_widget_LockPatternUtils$isPermanentlyLocked(), 0, this);
    }

    public void setPermanentlyLocked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPermanentlyLocked", $$robo$$com_android_internal_widget_LockPatternUtils$setPermanentlyLocked(boolean ), 0, this, bl);
    }

    public boolean isEmergencyCallCapable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmergencyCallCapable", $$robo$$com_android_internal_widget_LockPatternUtils$isEmergencyCallCapable(), 0, this);
    }

    public boolean isPukUnlockScreenEnable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPukUnlockScreenEnable", $$robo$$com_android_internal_widget_LockPatternUtils$isPukUnlockScreenEnable(), 0, this);
    }

    public boolean isEmergencyCallEnabledWhileSimLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmergencyCallEnabledWhileSimLocked", $$robo$$com_android_internal_widget_LockPatternUtils$isEmergencyCallEnabledWhileSimLocked(), 0, this);
    }

    public AlarmManager.AlarmClockInfo getNextAlarm() {
        return InvokeDynamicSupport.bootstrap("getNextAlarm", $$robo$$com_android_internal_widget_LockPatternUtils$getNextAlarm(), 0, this);
    }

    private boolean getBoolean(String string2, boolean bl, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$com_android_internal_widget_LockPatternUtils$getBoolean(java.lang.String boolean int ), 0, this, string2, bl, n);
    }

    private boolean getBoolean(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$com_android_internal_widget_LockPatternUtils$getBoolean(java.lang.String boolean ), 0, this, string2, bl);
    }

    private void setBoolean(String string2, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setBoolean", $$robo$$com_android_internal_widget_LockPatternUtils$setBoolean(java.lang.String boolean int ), 0, this, string2, bl, n);
    }

    private void setBoolean(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBoolean", $$robo$$com_android_internal_widget_LockPatternUtils$setBoolean(java.lang.String boolean ), 0, this, string2, bl);
    }

    public int[] getAppWidgets() {
        return InvokeDynamicSupport.bootstrap("getAppWidgets", $$robo$$com_android_internal_widget_LockPatternUtils$getAppWidgets(), 0, this);
    }

    private int[] getAppWidgets(int n) {
        return InvokeDynamicSupport.bootstrap("getAppWidgets", $$robo$$com_android_internal_widget_LockPatternUtils$getAppWidgets(int ), 0, this, n);
    }

    private static String combineStrings(int[] nArray, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("combineStrings", $$robo$$com_android_internal_widget_LockPatternUtils$combineStrings(int[] java.lang.String ), 0, (int[])nArray, (String)string2);
    }

    public void writeFallbackAppWidgetId(int n) {
        InvokeDynamicSupport.bootstrap("writeFallbackAppWidgetId", $$robo$$com_android_internal_widget_LockPatternUtils$writeFallbackAppWidgetId(int ), 0, this, n);
    }

    public int getFallbackAppWidgetId() {
        return (int)InvokeDynamicSupport.bootstrap("getFallbackAppWidgetId", $$robo$$com_android_internal_widget_LockPatternUtils$getFallbackAppWidgetId(), 0, this);
    }

    private void writeAppWidgets(int[] nArray) {
        InvokeDynamicSupport.bootstrap("writeAppWidgets", $$robo$$com_android_internal_widget_LockPatternUtils$writeAppWidgets(int[] ), 0, this, nArray);
    }

    public boolean addAppWidget(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("addAppWidget", $$robo$$com_android_internal_widget_LockPatternUtils$addAppWidget(int int ), 0, this, n, n2);
    }

    public boolean removeAppWidget(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAppWidget", $$robo$$com_android_internal_widget_LockPatternUtils$removeAppWidget(int ), 0, this, n);
    }

    private long getLong(String string2, long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$com_android_internal_widget_LockPatternUtils$getLong(java.lang.String long int ), 0, this, string2, l, n);
    }

    private long getLong(String string2, long l) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$com_android_internal_widget_LockPatternUtils$getLong(java.lang.String long ), 0, this, string2, l);
    }

    private void setLong(String string2, long l) {
        InvokeDynamicSupport.bootstrap("setLong", $$robo$$com_android_internal_widget_LockPatternUtils$setLong(java.lang.String long ), 0, this, string2, l);
    }

    private void setLong(String string2, long l, int n) {
        InvokeDynamicSupport.bootstrap("setLong", $$robo$$com_android_internal_widget_LockPatternUtils$setLong(java.lang.String long int ), 0, this, string2, l, n);
    }

    private String getString(String string2) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$com_android_internal_widget_LockPatternUtils$getString(java.lang.String ), 0, this, string2);
    }

    private String getString(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$com_android_internal_widget_LockPatternUtils$getString(java.lang.String int ), 0, this, string2, n);
    }

    private void setString(String string2, String string3, int n) {
        InvokeDynamicSupport.bootstrap("setString", $$robo$$com_android_internal_widget_LockPatternUtils$setString(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    public boolean isSecure() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecure", $$robo$$com_android_internal_widget_LockPatternUtils$isSecure(), 0, this);
    }

    public void updateEmergencyCallButtonState(Button button, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("updateEmergencyCallButtonState", $$robo$$com_android_internal_widget_LockPatternUtils$updateEmergencyCallButtonState(android.widget.Button boolean boolean ), 0, this, button, bl, bl2);
    }

    public void resumeCall() {
        InvokeDynamicSupport.bootstrap("resumeCall", $$robo$$com_android_internal_widget_LockPatternUtils$resumeCall(), 0, this);
    }

    public boolean isInCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInCall", $$robo$$com_android_internal_widget_LockPatternUtils$isInCall(), 0, this);
    }

    private TelecomManager getTelecommManager() {
        return InvokeDynamicSupport.bootstrap("getTelecommManager", $$robo$$com_android_internal_widget_LockPatternUtils$getTelecommManager(), 0, this);
    }

    private void finishBiometricWeak() {
        InvokeDynamicSupport.bootstrap("finishBiometricWeak", $$robo$$com_android_internal_widget_LockPatternUtils$finishBiometricWeak(), 0, this);
    }

    public void setPowerButtonInstantlyLocks(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPowerButtonInstantlyLocks", $$robo$$com_android_internal_widget_LockPatternUtils$setPowerButtonInstantlyLocks(boolean ), 0, this, bl);
    }

    public boolean getPowerButtonInstantlyLocks() {
        return (boolean)InvokeDynamicSupport.bootstrap("getPowerButtonInstantlyLocks", $$robo$$com_android_internal_widget_LockPatternUtils$getPowerButtonInstantlyLocks(), 0, this);
    }

    public static boolean isSafeModeEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSafeModeEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isSafeModeEnabled(), 0);
    }

    public boolean hasWidgetsEnabledInKeyguard(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasWidgetsEnabledInKeyguard", $$robo$$com_android_internal_widget_LockPatternUtils$hasWidgetsEnabledInKeyguard(int ), 0, this, n);
    }

    public boolean getWidgetsEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getWidgetsEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$getWidgetsEnabled(), 0, this);
    }

    public boolean getWidgetsEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getWidgetsEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$getWidgetsEnabled(int ), 0, this, n);
    }

    public void setWidgetsEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setWidgetsEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setWidgetsEnabled(boolean ), 0, this, bl);
    }

    public void setWidgetsEnabled(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setWidgetsEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setWidgetsEnabled(boolean int ), 0, this, bl, n);
    }

    public void setEnabledTrustAgents(Collection<ComponentName> collection) {
        InvokeDynamicSupport.bootstrap("setEnabledTrustAgents", $$robo$$com_android_internal_widget_LockPatternUtils$setEnabledTrustAgents(java.util.Collection<android.content.ComponentName> ), 0, this, collection);
    }

    public List<ComponentName> getEnabledTrustAgents() {
        return InvokeDynamicSupport.bootstrap("getEnabledTrustAgents", $$robo$$com_android_internal_widget_LockPatternUtils$getEnabledTrustAgents(), 0, this);
    }

    public void setEnabledTrustAgents(Collection<ComponentName> collection, int n) {
        InvokeDynamicSupport.bootstrap("setEnabledTrustAgents", $$robo$$com_android_internal_widget_LockPatternUtils$setEnabledTrustAgents(java.util.Collection<android.content.ComponentName> int ), 0, this, collection, n);
    }

    public List<ComponentName> getEnabledTrustAgents(int n) {
        return InvokeDynamicSupport.bootstrap("getEnabledTrustAgents", $$robo$$com_android_internal_widget_LockPatternUtils$getEnabledTrustAgents(int ), 0, this, n);
    }

    public void requireCredentialEntry(int n) {
        InvokeDynamicSupport.bootstrap("requireCredentialEntry", $$robo$$com_android_internal_widget_LockPatternUtils$requireCredentialEntry(int ), 0, this, n);
    }

    private void onAfterChangingPassword() {
        InvokeDynamicSupport.bootstrap("onAfterChangingPassword", $$robo$$com_android_internal_widget_LockPatternUtils$onAfterChangingPassword(), 0, this);
    }

    public boolean isCredentialRequiredToDecrypt(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCredentialRequiredToDecrypt", $$robo$$com_android_internal_widget_LockPatternUtils$isCredentialRequiredToDecrypt(boolean ), 0, this, bl);
    }

    public void setCredentialRequiredToDecrypt(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCredentialRequiredToDecrypt", $$robo$$com_android_internal_widget_LockPatternUtils$setCredentialRequiredToDecrypt(boolean ), 0, this, bl);
    }

    static {
        RobolectricInternals.classInitializing(LockPatternUtils.class);
    }

    public /* synthetic */ LockPatternUtils() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LockPatternUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

