/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.hardware.input.InputManager;
import android.os.SystemProperties;
import android.util.Log;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManagerPolicy;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PointerLocationView
extends View
implements InputManager.InputDeviceListener,
WindowManagerPolicy.PointerEventListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Pointer";
    private static String ALT_STRATEGY_PROPERY_KEY = "debug.velocitytracker.alt";
    private int ESTIMATE_PAST_POINTS = 4;
    private int ESTIMATE_FUTURE_POINTS = 2;
    private float ESTIMATE_INTERVAL = 0.02f;
    private InputManager mIm;
    private ViewConfiguration mVC;
    private Paint mTextPaint;
    private Paint mTextBackgroundPaint;
    private Paint mTextLevelPaint;
    private Paint mPaint;
    private Paint mCurrentPointPaint;
    private Paint mTargetPaint;
    private Paint mPathPaint;
    private Paint.FontMetricsInt mTextMetrics;
    private int mHeaderBottom;
    private boolean mCurDown;
    private int mCurNumPointers;
    private int mMaxNumPointers;
    private int mActivePointerId;
    private ArrayList<PointerState> mPointers;
    private MotionEvent.PointerCoords mTempCoords;
    private VelocityTracker mVelocity;
    private VelocityTracker mAltVelocity;
    private FasterStringBuilder mText;
    private boolean mPrintCoords;
    private RectF mReusableOvalRect;

    private void $$robo$$com_android_internal_widget_PointerLocationView$__constructor__(Context c) {
        this.ESTIMATE_PAST_POINTS = 4;
        this.ESTIMATE_FUTURE_POINTS = 2;
        this.ESTIMATE_INTERVAL = 0.02f;
        this.mTextMetrics = new Paint.FontMetricsInt();
        this.mPointers = new ArrayList();
        this.mTempCoords = new MotionEvent.PointerCoords();
        this.mText = new FasterStringBuilder();
        this.mPrintCoords = true;
        this.mReusableOvalRect = new RectF();
        this.setFocusableInTouchMode(true);
        this.mIm = (InputManager)c.getSystemService("input");
        this.mVC = ViewConfiguration.get(c);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize(10.0f * this.getResources().getDisplayMetrics().density);
        this.mTextPaint.setARGB(255, 0, 0, 0);
        this.mTextBackgroundPaint = new Paint();
        this.mTextBackgroundPaint.setAntiAlias(false);
        this.mTextBackgroundPaint.setARGB(128, 255, 255, 255);
        this.mTextLevelPaint = new Paint();
        this.mTextLevelPaint.setAntiAlias(false);
        this.mTextLevelPaint.setARGB(192, 255, 0, 0);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setARGB(255, 255, 255, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(2.0f);
        this.mCurrentPointPaint = new Paint();
        this.mCurrentPointPaint.setAntiAlias(true);
        this.mCurrentPointPaint.setARGB(255, 255, 0, 0);
        this.mCurrentPointPaint.setStyle(Paint.Style.STROKE);
        this.mCurrentPointPaint.setStrokeWidth(2.0f);
        this.mTargetPaint = new Paint();
        this.mTargetPaint.setAntiAlias(false);
        this.mTargetPaint.setARGB(255, 0, 0, 192);
        this.mPathPaint = new Paint();
        this.mPathPaint.setAntiAlias(false);
        this.mPathPaint.setARGB(255, 0, 96, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(1.0f);
        PointerState ps = new PointerState();
        this.mPointers.add(ps);
        this.mActivePointerId = 0;
        this.mVelocity = VelocityTracker.obtain();
        String altStrategy = SystemProperties.get("debug.velocitytracker.alt");
        if (altStrategy.length() != 0) {
            Log.d("Pointer", "Comparing default velocity tracker strategy with " + altStrategy);
            this.mAltVelocity = VelocityTracker.obtain(altStrategy);
        } else {
            this.mAltVelocity = null;
        }
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$setPrintCoords(boolean state) {
        this.mPrintCoords = state;
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mTextPaint.getFontMetricsInt(this.mTextMetrics);
        this.mHeaderBottom = -this.mTextMetrics.ascent + this.mTextMetrics.descent + 2;
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$drawOval(Canvas canvas, float x, float y, float major, float minor, float angle, Paint paint) {
        canvas.save(1);
        canvas.rotate((float)((double)(angle * 180.0f) / Math.PI), x, y);
        this.mReusableOvalRect.left = x - minor / 2.0f;
        this.mReusableOvalRect.right = x + minor / 2.0f;
        this.mReusableOvalRect.top = y - major / 2.0f;
        this.mReusableOvalRect.bottom = y + major / 2.0f;
        canvas.drawOval(this.mReusableOvalRect, paint);
        canvas.restore();
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$onDraw(Canvas canvas) {
        int w = this.getWidth();
        int itemW = w / 7;
        int base = -this.mTextMetrics.ascent + 1;
        int bottom = this.mHeaderBottom;
        int NP = this.mPointers.size();
        if (this.mActivePointerId >= 0) {
            PointerState ps = this.mPointers.get(this.mActivePointerId);
            canvas.drawRect(0.0f, 0.0f, itemW - 1, bottom, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("P: ").append(this.mCurNumPointers).append(" / ").append(this.mMaxNumPointers).toString(), 1.0f, base, this.mTextPaint);
            int N = ps.mTraceCount;
            if (this.mCurDown && ps.mCurDown || N == 0) {
                canvas.drawRect(itemW, 0.0f, itemW * 2 - 1, bottom, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("X: ").append(((PointerState)ps).mCoords.x, 1).toString(), 1 + itemW, base, this.mTextPaint);
                canvas.drawRect(itemW * 2, 0.0f, itemW * 3 - 1, bottom, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("Y: ").append(((PointerState)ps).mCoords.y, 1).toString(), 1 + itemW * 2, base, this.mTextPaint);
            } else {
                float dx = ps.mTraceX[N - 1] - ps.mTraceX[0];
                float dy = ps.mTraceY[N - 1] - ps.mTraceY[0];
                canvas.drawRect(itemW, 0.0f, itemW * 2 - 1, bottom, Math.abs(dx) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint);
                canvas.drawText(this.mText.clear().append("dX: ").append(dx, 1).toString(), 1 + itemW, base, this.mTextPaint);
                canvas.drawRect(itemW * 2, 0.0f, itemW * 3 - 1, bottom, Math.abs(dy) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint);
                canvas.drawText(this.mText.clear().append("dY: ").append(dy, 1).toString(), 1 + itemW * 2, base, this.mTextPaint);
            }
            canvas.drawRect(itemW * 3, 0.0f, itemW * 4 - 1, bottom, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("Xv: ").append(ps.mXVelocity, 3).toString(), 1 + itemW * 3, base, this.mTextPaint);
            canvas.drawRect(itemW * 4, 0.0f, itemW * 5 - 1, bottom, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("Yv: ").append(ps.mYVelocity, 3).toString(), 1 + itemW * 4, base, this.mTextPaint);
            canvas.drawRect(itemW * 5, 0.0f, itemW * 6 - 1, bottom, this.mTextBackgroundPaint);
            canvas.drawRect(itemW * 5, 0.0f, (float)(itemW * 5) + ((PointerState)ps).mCoords.pressure * (float)itemW - 1.0f, bottom, this.mTextLevelPaint);
            canvas.drawText(this.mText.clear().append("Prs: ").append(((PointerState)ps).mCoords.pressure, 2).toString(), 1 + itemW * 5, base, this.mTextPaint);
            canvas.drawRect(itemW * 6, 0.0f, w, bottom, this.mTextBackgroundPaint);
            canvas.drawRect(itemW * 6, 0.0f, (float)(itemW * 6) + ((PointerState)ps).mCoords.size * (float)itemW - 1.0f, bottom, this.mTextLevelPaint);
            canvas.drawText(this.mText.clear().append("Size: ").append(((PointerState)ps).mCoords.size, 2).toString(), 1 + itemW * 6, base, this.mTextPaint);
        }
        for (int p = 0; p < NP; ++p) {
            PointerState ps = this.mPointers.get(p);
            int N = ps.mTraceCount;
            float lastX = 0.0f;
            float lastY = 0.0f;
            boolean haveLast = false;
            boolean drawn = false;
            this.mPaint.setARGB(255, 128, 255, 255);
            for (int i = 0; i < N; ++i) {
                float x = ps.mTraceX[i];
                float y = ps.mTraceY[i];
                if (Float.isNaN(x)) {
                    haveLast = false;
                    continue;
                }
                if (haveLast) {
                    canvas.drawLine(lastX, lastY, x, y, this.mPathPaint);
                    Paint paint = ps.mTraceCurrent[i] ? this.mCurrentPointPaint : this.mPaint;
                    canvas.drawPoint(lastX, lastY, paint);
                    drawn = true;
                }
                lastX = x;
                lastY = y;
                haveLast = true;
            }
            if (drawn) {
                this.mPaint.setARGB(128, 128, 0, 128);
                float lx = ps.mEstimator.estimateX(-0.08f);
                float ly = ps.mEstimator.estimateY(-0.08f);
                for (int i = -3; i <= 2; ++i) {
                    float x = ps.mEstimator.estimateX((float)i * 0.02f);
                    float y = ps.mEstimator.estimateY((float)i * 0.02f);
                    canvas.drawLine(lx, ly, x, y, this.mPaint);
                    lx = x;
                    ly = y;
                }
                this.mPaint.setARGB(255, 255, 64, 128);
                float xVel = ps.mXVelocity * 16.0f;
                float yVel = ps.mYVelocity * 16.0f;
                canvas.drawLine(lastX, lastY, lastX + xVel, lastY + yVel, this.mPaint);
                if (this.mAltVelocity != null) {
                    this.mPaint.setARGB(128, 0, 128, 128);
                    lx = ps.mAltEstimator.estimateX(-0.08f);
                    ly = ps.mAltEstimator.estimateY(-0.08f);
                    for (int i = -3; i <= 2; ++i) {
                        float x = ps.mAltEstimator.estimateX((float)i * 0.02f);
                        float y = ps.mAltEstimator.estimateY((float)i * 0.02f);
                        canvas.drawLine(lx, ly, x, y, this.mPaint);
                        lx = x;
                        ly = y;
                    }
                    this.mPaint.setARGB(255, 64, 255, 128);
                    xVel = ps.mAltXVelocity * 16.0f;
                    yVel = ps.mAltYVelocity * 16.0f;
                    canvas.drawLine(lastX, lastY, lastX + xVel, lastY + yVel, this.mPaint);
                }
            }
            if (!this.mCurDown || !ps.mCurDown) continue;
            canvas.drawLine(0.0f, ((PointerState)ps).mCoords.y, this.getWidth(), ((PointerState)ps).mCoords.y, this.mTargetPaint);
            canvas.drawLine(((PointerState)ps).mCoords.x, 0.0f, ((PointerState)ps).mCoords.x, this.getHeight(), this.mTargetPaint);
            int pressureLevel = (int)(((PointerState)ps).mCoords.pressure * 255.0f);
            this.mPaint.setARGB(255, pressureLevel, 255, 255 - pressureLevel);
            canvas.drawPoint(((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, this.mPaint);
            this.mPaint.setARGB(255, pressureLevel, 255 - pressureLevel, 128);
            this.drawOval(canvas, ((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, ((PointerState)ps).mCoords.touchMajor, ((PointerState)ps).mCoords.touchMinor, ((PointerState)ps).mCoords.orientation, this.mPaint);
            this.mPaint.setARGB(255, pressureLevel, 128, 255 - pressureLevel);
            this.drawOval(canvas, ((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, ((PointerState)ps).mCoords.toolMajor, ((PointerState)ps).mCoords.toolMinor, ((PointerState)ps).mCoords.orientation, this.mPaint);
            float arrowSize = ((PointerState)ps).mCoords.toolMajor * 0.7f;
            if (arrowSize < 20.0f) {
                arrowSize = 20.0f;
            }
            this.mPaint.setARGB(255, pressureLevel, 255, 0);
            float orientationVectorX = (float)(Math.sin(((PointerState)ps).mCoords.orientation) * (double)arrowSize);
            float orientationVectorY = (float)(-Math.cos(((PointerState)ps).mCoords.orientation) * (double)arrowSize);
            if (ps.mToolType == 2 || ps.mToolType == 4) {
                canvas.drawLine(((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, ((PointerState)ps).mCoords.x + orientationVectorX, ((PointerState)ps).mCoords.y + orientationVectorY, this.mPaint);
            } else {
                canvas.drawLine(((PointerState)ps).mCoords.x - orientationVectorX, ((PointerState)ps).mCoords.y - orientationVectorY, ((PointerState)ps).mCoords.x + orientationVectorX, ((PointerState)ps).mCoords.y + orientationVectorY, this.mPaint);
            }
            float tiltScale = (float)Math.sin(ps.mCoords.getAxisValue(25));
            canvas.drawCircle(((PointerState)ps).mCoords.x + orientationVectorX * tiltScale, ((PointerState)ps).mCoords.y + orientationVectorY * tiltScale, 3.0f, this.mPaint);
            if (!ps.mHasBoundingBox) continue;
            canvas.drawRect(ps.mBoundingLeft, ps.mBoundingTop, ps.mBoundingRight, ps.mBoundingBottom, this.mPaint);
        }
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$logMotionEvent(String type, MotionEvent event) {
        int action = event.getAction();
        int N = event.getHistorySize();
        int NI = event.getPointerCount();
        for (int historyPos = 0; historyPos < N; ++historyPos) {
            for (int i = 0; i < NI; ++i) {
                int id2 = event.getPointerId(i);
                event.getHistoricalPointerCoords(i, historyPos, this.mTempCoords);
                this.logCoords(type, action, i, this.mTempCoords, id2, event);
            }
        }
        for (int i = 0; i < NI; ++i) {
            int id3 = event.getPointerId(i);
            event.getPointerCoords(i, this.mTempCoords);
            this.logCoords(type, action, i, this.mTempCoords, id3, event);
        }
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$logCoords(String type, int action, int index, MotionEvent.PointerCoords coords, int id2, MotionEvent event) {
        String prefix;
        int toolType = event.getToolType(index);
        int buttonState = event.getButtonState();
        switch (action & 0xFF) {
            case 0: {
                prefix = "DOWN";
                break;
            }
            case 1: {
                prefix = "UP";
                break;
            }
            case 2: {
                prefix = "MOVE";
                break;
            }
            case 3: {
                prefix = "CANCEL";
                break;
            }
            case 4: {
                prefix = "OUTSIDE";
                break;
            }
            case 5: {
                if (index == (action & 0xFF00) >> 8) {
                    prefix = "DOWN";
                    break;
                }
                prefix = "MOVE";
                break;
            }
            case 6: {
                if (index == (action & 0xFF00) >> 8) {
                    prefix = "UP";
                    break;
                }
                prefix = "MOVE";
                break;
            }
            case 7: {
                prefix = "HOVER MOVE";
                break;
            }
            case 9: {
                prefix = "HOVER ENTER";
                break;
            }
            case 10: {
                prefix = "HOVER EXIT";
                break;
            }
            case 8: {
                prefix = "SCROLL";
                break;
            }
            default: {
                prefix = Integer.toString(action);
            }
        }
        Log.i("Pointer", this.mText.clear().append(type).append(" id ").append(id2 + 1).append(": ").append(prefix).append(" (").append(coords.x, 3).append(", ").append(coords.y, 3).append(") Pressure=").append(coords.pressure, 3).append(" Size=").append(coords.size, 3).append(" TouchMajor=").append(coords.touchMajor, 3).append(" TouchMinor=").append(coords.touchMinor, 3).append(" ToolMajor=").append(coords.toolMajor, 3).append(" ToolMinor=").append(coords.toolMinor, 3).append(" Orientation=").append((float)((double)(coords.orientation * 180.0f) / Math.PI), 1).append("deg").append(" Tilt=").append((float)((double)(coords.getAxisValue(25) * 180.0f) / Math.PI), 1).append("deg").append(" Distance=").append(coords.getAxisValue(24), 1).append(" VScroll=").append(coords.getAxisValue(9), 1).append(" HScroll=").append(coords.getAxisValue(10), 1).append(" BoundingBox=[(").append(event.getAxisValue(32), 3).append(", ").append(event.getAxisValue(33), 3).append(")").append(", (").append(event.getAxisValue(34), 3).append(", ").append(event.getAxisValue(35), 3).append(")]").append(" ToolType=").append(MotionEvent.toolTypeToString(toolType)).append(" ButtonState=").append(MotionEvent.buttonStateToString(buttonState)).toString());
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$onPointerEvent(MotionEvent event) {
        int action = event.getAction();
        int NP = this.mPointers.size();
        if (action == 0 || (action & 0xFF) == 5) {
            PointerState ps;
            int index = (action & 0xFF00) >> 8;
            if (action == 0) {
                for (int p = 0; p < NP; ++p) {
                    ps = this.mPointers.get(p);
                    ps.clearTrace();
                    ps.mCurDown = false;
                }
                this.mCurDown = true;
                this.mCurNumPointers = 0;
                this.mMaxNumPointers = 0;
                this.mVelocity.clear();
                if (this.mAltVelocity != null) {
                    this.mAltVelocity.clear();
                }
            }
            ++this.mCurNumPointers;
            if (this.mMaxNumPointers < this.mCurNumPointers) {
                this.mMaxNumPointers = this.mCurNumPointers;
            }
            int id2 = event.getPointerId(index);
            while (NP <= id2) {
                ps = new PointerState();
                this.mPointers.add(ps);
                ++NP;
            }
            if (this.mActivePointerId < 0 || !this.mPointers.get(this.mActivePointerId).mCurDown) {
                this.mActivePointerId = id2;
            }
            ps = this.mPointers.get(id2);
            ps.mCurDown = true;
            InputDevice device = InputDevice.getDevice(event.getDeviceId());
            ps.mHasBoundingBox = device != null && device.getMotionRange(32) != null;
        }
        int NI = event.getPointerCount();
        this.mVelocity.addMovement(event);
        this.mVelocity.computeCurrentVelocity(1);
        if (this.mAltVelocity != null) {
            this.mAltVelocity.addMovement(event);
            this.mAltVelocity.computeCurrentVelocity(1);
        }
        int N = event.getHistorySize();
        for (int historyPos = 0; historyPos < N; ++historyPos) {
            for (int i = 0; i < NI; ++i) {
                int id3 = event.getPointerId(i);
                PointerState ps = this.mCurDown ? this.mPointers.get(id3) : null;
                MotionEvent.PointerCoords coords = ps != null ? ps.mCoords : this.mTempCoords;
                event.getHistoricalPointerCoords(i, historyPos, coords);
                if (this.mPrintCoords) {
                    this.logCoords("Pointer", action, i, coords, id3, event);
                }
                if (ps == null) continue;
                ps.addTrace(coords.x, coords.y, false);
            }
        }
        for (int i = 0; i < NI; ++i) {
            int id4 = event.getPointerId(i);
            PointerState ps = this.mCurDown ? this.mPointers.get(id4) : null;
            MotionEvent.PointerCoords coords = ps != null ? ps.mCoords : this.mTempCoords;
            event.getPointerCoords(i, coords);
            if (this.mPrintCoords) {
                this.logCoords("Pointer", action, i, coords, id4, event);
            }
            if (ps == null) continue;
            ps.addTrace(coords.x, coords.y, true);
            ps.mXVelocity = this.mVelocity.getXVelocity(id4);
            ps.mYVelocity = this.mVelocity.getYVelocity(id4);
            this.mVelocity.getEstimator(id4, ps.mEstimator);
            if (this.mAltVelocity != null) {
                ps.mAltXVelocity = this.mAltVelocity.getXVelocity(id4);
                ps.mAltYVelocity = this.mAltVelocity.getYVelocity(id4);
                this.mAltVelocity.getEstimator(id4, ps.mAltEstimator);
            }
            ps.mToolType = event.getToolType(i);
            if (!ps.mHasBoundingBox) continue;
            ps.mBoundingLeft = event.getAxisValue(32, i);
            ps.mBoundingTop = event.getAxisValue(33, i);
            ps.mBoundingRight = event.getAxisValue(34, i);
            ps.mBoundingBottom = event.getAxisValue(35, i);
        }
        if (action == 1 || action == 3 || (action & 0xFF) == 6) {
            int index = (action & 0xFF00) >> 8;
            int id5 = event.getPointerId(index);
            PointerState ps = this.mPointers.get(id5);
            ps.mCurDown = false;
            if (action == 1 || action == 3) {
                this.mCurDown = false;
                this.mCurNumPointers = 0;
            } else {
                --this.mCurNumPointers;
                if (this.mActivePointerId == id5) {
                    this.mActivePointerId = event.getPointerId(index == 0 ? 1 : 0);
                }
                ps.addTrace(Float.NaN, Float.NaN, false);
            }
        }
        this.invalidate();
    }

    private final boolean $$robo$$com_android_internal_widget_PointerLocationView$onTouchEvent(MotionEvent event) {
        this.onPointerEvent(event);
        if (event.getAction() == 0 && !this.isFocused()) {
            this.requestFocus();
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_widget_PointerLocationView$onGenericMotionEvent(MotionEvent event) {
        int source = event.getSource();
        if ((source & 2) != 0) {
            this.onPointerEvent(event);
        } else if ((source & 0x10) != 0) {
            this.logMotionEvent("Joystick", event);
        } else if ((source & 8) != 0) {
            this.logMotionEvent("Position", event);
        } else {
            this.logMotionEvent("Generic", event);
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_widget_PointerLocationView$onKeyDown(int keyCode, KeyEvent event) {
        if (PointerLocationView.shouldLogKey(keyCode)) {
            int repeatCount = event.getRepeatCount();
            if (repeatCount == 0) {
                Log.i("Pointer", "Key Down: " + event);
            } else {
                Log.i("Pointer", "Key Repeat #" + repeatCount + ": " + event);
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private final boolean $$robo$$com_android_internal_widget_PointerLocationView$onKeyUp(int keyCode, KeyEvent event) {
        if (PointerLocationView.shouldLogKey(keyCode)) {
            Log.i("Pointer", "Key Up: " + event);
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private static final boolean $$robo$$com_android_internal_widget_PointerLocationView$shouldLogKey(int keyCode) {
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return KeyEvent.isGamepadButton(keyCode) || KeyEvent.isModifierKey(keyCode);
    }

    private final boolean $$robo$$com_android_internal_widget_PointerLocationView$onTrackballEvent(MotionEvent event) {
        this.logMotionEvent("Trackball", event);
        return true;
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIm.registerInputDeviceListener(this, this.getHandler());
        this.logInputDevices();
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIm.unregisterInputDeviceListener(this);
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$onInputDeviceAdded(int deviceId) {
        this.logInputDeviceState(deviceId, "Device Added");
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$onInputDeviceChanged(int deviceId) {
        this.logInputDeviceState(deviceId, "Device Changed");
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$onInputDeviceRemoved(int deviceId) {
        this.logInputDeviceState(deviceId, "Device Removed");
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$logInputDevices() {
        int[] deviceIds = InputDevice.getDeviceIds();
        for (int i = 0; i < deviceIds.length; ++i) {
            this.logInputDeviceState(deviceIds[i], "Device Enumerated");
        }
    }

    private final void $$robo$$com_android_internal_widget_PointerLocationView$logInputDeviceState(int deviceId, String state) {
        InputDevice device = this.mIm.getInputDevice(deviceId);
        if (device != null) {
            Log.i("Pointer", state + ": " + device);
        } else {
            Log.i("Pointer", state + ": " + deviceId);
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_PointerLocationView$__constructor__(context);
    }

    public PointerLocationView(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_PointerLocationView$__constructor__(android.content.Context ), 0, this, context);
    }

    public void setPrintCoords(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPrintCoords", $$robo$$com_android_internal_widget_PointerLocationView$setPrintCoords(boolean ), 0, this, bl);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_PointerLocationView$onMeasure(int int ), 0, this, n, n2);
    }

    private void drawOval(Canvas canvas, float f, float f2, float f3, float f4, float f5, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawOval", $$robo$$com_android_internal_widget_PointerLocationView$drawOval(android.graphics.Canvas float float float float float android.graphics.Paint ), 0, this, canvas, f, f2, f3, f4, f5, paint);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_PointerLocationView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    private void logMotionEvent(String string2, MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("logMotionEvent", $$robo$$com_android_internal_widget_PointerLocationView$logMotionEvent(java.lang.String android.view.MotionEvent ), 0, this, string2, motionEvent);
    }

    private void logCoords(String string2, int n, int n2, MotionEvent.PointerCoords pointerCoords, int n3, MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("logCoords", $$robo$$com_android_internal_widget_PointerLocationView$logCoords(java.lang.String int int android.view.MotionEvent$PointerCoords int android.view.MotionEvent ), 0, this, string2, n, n2, pointerCoords, n3, motionEvent);
    }

    @Override
    public void onPointerEvent(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onPointerEvent", $$robo$$com_android_internal_widget_PointerLocationView$onPointerEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_PointerLocationView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$com_android_internal_widget_PointerLocationView$onGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$com_android_internal_widget_PointerLocationView$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$com_android_internal_widget_PointerLocationView$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    private static boolean shouldLogKey(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldLogKey", $$robo$$com_android_internal_widget_PointerLocationView$shouldLogKey(int ), 0, (int)n);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTrackballEvent", $$robo$$com_android_internal_widget_PointerLocationView$onTrackballEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_widget_PointerLocationView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_PointerLocationView$onDetachedFromWindow(), 0, this);
    }

    @Override
    public void onInputDeviceAdded(int n) {
        InvokeDynamicSupport.bootstrap("onInputDeviceAdded", $$robo$$com_android_internal_widget_PointerLocationView$onInputDeviceAdded(int ), 0, this, n);
    }

    @Override
    public void onInputDeviceChanged(int n) {
        InvokeDynamicSupport.bootstrap("onInputDeviceChanged", $$robo$$com_android_internal_widget_PointerLocationView$onInputDeviceChanged(int ), 0, this, n);
    }

    @Override
    public void onInputDeviceRemoved(int n) {
        InvokeDynamicSupport.bootstrap("onInputDeviceRemoved", $$robo$$com_android_internal_widget_PointerLocationView$onInputDeviceRemoved(int ), 0, this, n);
    }

    private void logInputDevices() {
        InvokeDynamicSupport.bootstrap("logInputDevices", $$robo$$com_android_internal_widget_PointerLocationView$logInputDevices(), 0, this);
    }

    private void logInputDeviceState(int n, String string2) {
        InvokeDynamicSupport.bootstrap("logInputDeviceState", $$robo$$com_android_internal_widget_PointerLocationView$logInputDeviceState(int java.lang.String ), 0, this, n, string2);
    }

    public /* synthetic */ PointerLocationView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PointerLocationView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class FasterStringBuilder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private char[] mChars;
        private int mLength;

        private void $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$__constructor__() {
            this.mChars = new char[64];
        }

        private final FasterStringBuilder $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$clear() {
            this.mLength = 0;
            return this;
        }

        private final FasterStringBuilder $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$append(String value) {
            int valueLength = value.length();
            int index = this.reserve(valueLength);
            value.getChars(0, valueLength, this.mChars, index);
            this.mLength += valueLength;
            return this;
        }

        private final FasterStringBuilder $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$append(int value) {
            return this.append(value, 0);
        }

        private final FasterStringBuilder $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$append(int value, int zeroPadWidth) {
            int divisor;
            boolean negative;
            boolean bl = negative = value < 0;
            if (negative && (value = -value) < 0) {
                this.append("-2147483648");
                return this;
            }
            int index = this.reserve(11);
            char[] chars = this.mChars;
            if (value == 0) {
                chars[index++] = 48;
                ++this.mLength;
                return this;
            }
            if (negative) {
                chars[index++] = 45;
            }
            int numberWidth = 10;
            for (divisor = 1000000000; value < divisor; divisor /= 10) {
                if (--numberWidth >= zeroPadWidth) continue;
                chars[index++] = 48;
            }
            do {
                int digit = value / divisor;
                value -= digit * divisor;
                chars[index++] = (char)(digit + 48);
            } while ((divisor /= 10) != 0);
            this.mLength = index;
            return this;
        }

        private final FasterStringBuilder $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$append(float value, int precision) {
            int scale = 1;
            for (int i = 0; i < precision; ++i) {
                scale *= 10;
            }
            value = (float)(Math.rint(value * (float)scale) / (double)scale);
            this.append((int)value);
            if (precision != 0) {
                this.append(".");
                value = Math.abs(value);
                value = (float)((double)value - Math.floor(value));
                this.append((int)(value * (float)scale), precision);
            }
            return this;
        }

        private final String $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$toString() {
            return new String(this.mChars, 0, this.mLength);
        }

        private final int $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$reserve(int length) {
            int oldLength = this.mLength;
            int newLength = this.mLength + length;
            char[] oldChars = this.mChars;
            int oldCapacity = oldChars.length;
            if (newLength > oldCapacity) {
                int newCapacity = oldCapacity * 2;
                char[] newChars = new char[newCapacity];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])oldChars, (int)0, (char[])newChars, (int)0, (int)oldLength);
                this.mChars = newChars;
            }
            return oldLength;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$__constructor__();
        }

        public FasterStringBuilder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$__constructor__(), 0, this);
        }

        public FasterStringBuilder clear() {
            return InvokeDynamicSupport.bootstrap("clear", $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$clear(), 0, this);
        }

        public FasterStringBuilder append(String string2) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$append(java.lang.String ), 0, this, string2);
        }

        public FasterStringBuilder append(int n) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$append(int ), 0, this, n);
        }

        public FasterStringBuilder append(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$append(int int ), 0, this, n, n2);
        }

        public FasterStringBuilder append(float f, int n) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$append(float int ), 0, this, f, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$toString(), 0, this);
        }

        private int reserve(int n) {
            return (int)InvokeDynamicSupport.bootstrap("reserve", $$robo$$com_android_internal_widget_PointerLocationView_FasterStringBuilder$reserve(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FasterStringBuilder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PointerState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private float[] mTraceX;
        private float[] mTraceY;
        private boolean[] mTraceCurrent;
        private int mTraceCount;
        private boolean mCurDown;
        private MotionEvent.PointerCoords mCoords;
        private int mToolType;
        private float mXVelocity;
        private float mYVelocity;
        private float mAltXVelocity;
        private float mAltYVelocity;
        private boolean mHasBoundingBox;
        private float mBoundingLeft;
        private float mBoundingTop;
        private float mBoundingRight;
        private float mBoundingBottom;
        private VelocityTracker.Estimator mEstimator;
        private VelocityTracker.Estimator mAltEstimator;

        private void $$robo$$com_android_internal_widget_PointerLocationView_PointerState$__constructor__() {
            this.mTraceX = new float[32];
            this.mTraceY = new float[32];
            this.mTraceCurrent = new boolean[32];
            this.mCoords = new MotionEvent.PointerCoords();
            this.mEstimator = new VelocityTracker.Estimator();
            this.mAltEstimator = new VelocityTracker.Estimator();
        }

        private final void $$robo$$com_android_internal_widget_PointerLocationView_PointerState$clearTrace() {
            this.mTraceCount = 0;
        }

        private final void $$robo$$com_android_internal_widget_PointerLocationView_PointerState$addTrace(float x, float y, boolean current) {
            int traceCapacity = this.mTraceX.length;
            if (this.mTraceCount == traceCapacity) {
                float[] newTraceX = new float[traceCapacity *= 2];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])this.mTraceX, (int)0, (float[])newTraceX, (int)0, (int)this.mTraceCount);
                this.mTraceX = newTraceX;
                float[] newTraceY = new float[traceCapacity];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])this.mTraceY, (int)0, (float[])newTraceY, (int)0, (int)this.mTraceCount);
                this.mTraceY = newTraceY;
                boolean[] newTraceCurrent = new boolean[traceCapacity];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (boolean[])this.mTraceCurrent, (int)0, (boolean[])newTraceCurrent, (int)0, (int)this.mTraceCount);
                this.mTraceCurrent = newTraceCurrent;
            }
            this.mTraceX[this.mTraceCount] = x;
            this.mTraceY[this.mTraceCount] = y;
            this.mTraceCurrent[this.mTraceCount] = current;
            ++this.mTraceCount;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_PointerLocationView_PointerState$__constructor__();
        }

        public PointerState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_PointerLocationView_PointerState$__constructor__(), 0, this);
        }

        public void clearTrace() {
            InvokeDynamicSupport.bootstrap("clearTrace", $$robo$$com_android_internal_widget_PointerLocationView_PointerState$clearTrace(), 0, this);
        }

        public void addTrace(float f, float f2, boolean bl) {
            InvokeDynamicSupport.bootstrap("addTrace", $$robo$$com_android_internal_widget_PointerLocationView_PointerState$addTrace(float float boolean ), 0, this, f, f2, bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PointerState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

